package org.hl7.fhir.dstu3.formats;

import java.io.IOException;

/*-
 * #%L
 * org.hl7.fhir.dstu3
 * %%
 * Copyright (C) 2014 - 2019 Health Level 7
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Mon, Apr 17, 2017 08:38+1000 for FHIR v3.0.x
import org.hl7.fhir.dstu3.model.*;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

public class JsonParser extends JsonParserBase {

  public JsonParser() {
    super();
  }

  public JsonParser(boolean allowUnknownContent) {
    super();
    setAllowUnknownContent(allowUnknownContent);
  }


  protected void parseElementProperties(JsonObject json, Element element) throws IOException, FHIRFormatError {
    super.parseElementProperties(json, element);
    if (json.has("extension")) {
      JsonArray array = json.getAsJsonArray("extension");
      for (int i = 0; i < array.size(); i++) {
        element.getExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected void parseBackboneProperties(JsonObject json, BackboneElement element) throws IOException, FHIRFormatError {
    parseElementProperties(json, element);
    if (json.has("modifierExtension")) {
      JsonArray array = json.getAsJsonArray("modifierExtension");
      for (int i = 0; i < array.size(); i++) {
        element.getModifierExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    }
  }

  protected void parseTypeProperties(JsonObject json, Element element) throws IOException, FHIRFormatError {
    parseElementProperties(json, element);
  }

  @SuppressWarnings("unchecked")
  protected <E extends Enum<E>> Enumeration<E> parseEnumeration(String s, E item, EnumFactory e) throws IOException, FHIRFormatError {
    Enumeration<E> res = new Enumeration<E>(e);
    if (s != null)
      res.setValue((E) e.fromCode(s));
    return res;
  }

  protected DateType parseDate(String v) throws IOException, FHIRFormatError {
    DateType res = new DateType(v);
    return res;
  }

  protected DateTimeType parseDateTime(String v) throws IOException, FHIRFormatError {
    DateTimeType res = new DateTimeType(v);
    return res;
  }

  protected CodeType parseCode(String v) throws IOException, FHIRFormatError {
    CodeType res = new CodeType(v);
    return res;
  }

  protected StringType parseString(String v) throws IOException, FHIRFormatError {
    StringType res = new StringType(v);
    return res;
  }

  protected IntegerType parseInteger(java.lang.Long v) throws IOException, FHIRFormatError {
    IntegerType res = new IntegerType(v);
    return res;
  }

  protected OidType parseOid(String v) throws IOException, FHIRFormatError {
    OidType res = new OidType(v);
    return res;
  }

  protected UriType parseUri(String v) throws IOException, FHIRFormatError {
    UriType res = new UriType(v);
    return res;
  }

  protected UuidType parseUuid(String v) throws IOException, FHIRFormatError {
    UuidType res = new UuidType(v);
    return res;
  }

  protected InstantType parseInstant(String v) throws IOException, FHIRFormatError {
    InstantType res = new InstantType(v);
    return res;
  }

  protected BooleanType parseBoolean(java.lang.Boolean v) throws IOException, FHIRFormatError {
    BooleanType res = new BooleanType(v);
    return res;
  }

  protected Base64BinaryType parseBase64Binary(String v) throws IOException, FHIRFormatError {
    Base64BinaryType res = new Base64BinaryType(v);
    return res;
  }

  protected UnsignedIntType parseUnsignedInt(String v) throws IOException, FHIRFormatError {
    UnsignedIntType res = new UnsignedIntType(v);
    return res;
  }

  protected MarkdownType parseMarkdown(String v) throws IOException, FHIRFormatError {
    MarkdownType res = new MarkdownType(v);
    return res;
  }

  protected TimeType parseTime(String v) throws IOException, FHIRFormatError {
    TimeType res = new TimeType(v);
    return res;
  }

  protected IdType parseId(String v) throws IOException, FHIRFormatError {
    IdType res = new IdType(v);
    return res;
  }

  protected PositiveIntType parsePositiveInt(String v) throws IOException, FHIRFormatError {
    PositiveIntType res = new PositiveIntType(v);
    return res;
  }

  protected DecimalType parseDecimal(java.math.BigDecimal v) throws IOException, FHIRFormatError {
    DecimalType res = new DecimalType(v);
    return res;
  }

  protected Extension parseExtension(JsonObject json) throws IOException, FHIRFormatError {
    Extension res = new Extension();
    parseExtensionProperties(json, res);
    return res;
  }

  protected void parseExtensionProperties(JsonObject json, Extension res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Narrative parseNarrative(JsonObject json) throws IOException, FHIRFormatError {
    Narrative res = new Narrative();
    parseNarrativeProperties(json, res);
    return res;
  }

  protected void parseNarrativeProperties(JsonObject json, Narrative res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("div"))
      res.setDiv(parseXhtml(json.get("div").getAsString()));
  }

  protected Reference parseReference(JsonObject json) throws IOException, FHIRFormatError {
    Reference res = new Reference();
    parseReferenceProperties(json, res);
    return res;
  }

  protected void parseReferenceProperties(JsonObject json, Reference res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("reference"))
      res.setReferenceElement(parseString(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
  }

  protected Quantity parseQuantity(JsonObject json) throws IOException, FHIRFormatError {
    Quantity res = new Quantity();
    parseQuantityProperties(json, res);
    return res;
  }

  protected void parseQuantityProperties(JsonObject json, Quantity res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("comparator"))
      res.setComparatorElement(parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
    if (json.has("_comparator"))
      parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
    if (json.has("unit"))
      res.setUnitElement(parseString(json.get("unit").getAsString()));
    if (json.has("_unit"))
      parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
  }

  protected Period parsePeriod(JsonObject json) throws IOException, FHIRFormatError {
    Period res = new Period();
    parsePeriodProperties(json, res);
    return res;
  }

  protected void parsePeriodProperties(JsonObject json, Period res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseDateTime(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseDateTime(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
  }

  protected Attachment parseAttachment(JsonObject json) throws IOException, FHIRFormatError {
    Attachment res = new Attachment();
    parseAttachmentProperties(json, res);
    return res;
  }

  protected void parseAttachmentProperties(JsonObject json, Attachment res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("contentType"))
      res.setContentTypeElement(parseCode(json.get("contentType").getAsString()));
    if (json.has("_contentType"))
      parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("data"))
      res.setDataElement(parseBase64Binary(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("size"))
      res.setSizeElement(parseUnsignedInt(json.get("size").getAsString()));
    if (json.has("_size"))
      parseElementProperties(json.getAsJsonObject("_size"), res.getSizeElement());
    if (json.has("hash"))
      res.setHashElement(parseBase64Binary(json.get("hash").getAsString()));
    if (json.has("_hash"))
      parseElementProperties(json.getAsJsonObject("_hash"), res.getHashElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("creation"))
      res.setCreationElement(parseDateTime(json.get("creation").getAsString()));
    if (json.has("_creation"))
      parseElementProperties(json.getAsJsonObject("_creation"), res.getCreationElement());
  }

  protected Duration parseDuration(JsonObject json) throws IOException, FHIRFormatError {
    Duration res = new Duration();
    parseDurationProperties(json, res);
    return res;
  }

  protected void parseDurationProperties(JsonObject json, Duration res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected Count parseCount(JsonObject json) throws IOException, FHIRFormatError {
    Count res = new Count();
    parseCountProperties(json, res);
    return res;
  }

  protected void parseCountProperties(JsonObject json, Count res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected Range parseRange(JsonObject json) throws IOException, FHIRFormatError {
    Range res = new Range();
    parseRangeProperties(json, res);
    return res;
  }

  protected void parseRangeProperties(JsonObject json, Range res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("low"))
      res.setLow(parseSimpleQuantity(json.getAsJsonObject("low")));
    if (json.has("high"))
      res.setHigh(parseSimpleQuantity(json.getAsJsonObject("high")));
  }

  protected Annotation parseAnnotation(JsonObject json) throws IOException, FHIRFormatError {
    Annotation res = new Annotation();
    parseAnnotationProperties(json, res);
    return res;
  }

  protected void parseAnnotationProperties(JsonObject json, Annotation res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    Type author = parseType("author", json);
    if (author != null)
      res.setAuthor(author);
    if (json.has("time"))
      res.setTimeElement(parseDateTime(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
  }

  protected Money parseMoney(JsonObject json) throws IOException, FHIRFormatError {
    Money res = new Money();
    parseMoneyProperties(json, res);
    return res;
  }

  protected void parseMoneyProperties(JsonObject json, Money res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected Identifier parseIdentifier(JsonObject json) throws IOException, FHIRFormatError {
    Identifier res = new Identifier();
    parseIdentifierProperties(json, res);
    return res;
  }

  protected void parseIdentifierProperties(JsonObject json, Identifier res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("assigner"))
      res.setAssigner(parseReference(json.getAsJsonObject("assigner")));
  }

  protected Coding parseCoding(JsonObject json) throws IOException, FHIRFormatError {
    Coding res = new Coding();
    parseCodingProperties(json, res);
    return res;
  }

  protected void parseCodingProperties(JsonObject json, Coding res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("userSelected"))
      res.setUserSelectedElement(parseBoolean(json.get("userSelected").getAsBoolean()));
    if (json.has("_userSelected"))
      parseElementProperties(json.getAsJsonObject("_userSelected"), res.getUserSelectedElement());
  }

  protected Signature parseSignature(JsonObject json) throws IOException, FHIRFormatError {
    Signature res = new Signature();
    parseSignatureProperties(json, res);
    return res;
  }

  protected void parseSignatureProperties(JsonObject json, Signature res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("when"))
      res.setWhenElement(parseInstant(json.get("when").getAsString()));
    if (json.has("_when"))
      parseElementProperties(json.getAsJsonObject("_when"), res.getWhenElement());
    Type who = parseType("who", json);
    if (who != null)
      res.setWho(who);
    Type onBehalfOf = parseType("onBehalfOf", json);
    if (onBehalfOf != null)
      res.setOnBehalfOf(onBehalfOf);
    if (json.has("contentType"))
      res.setContentTypeElement(parseCode(json.get("contentType").getAsString()));
    if (json.has("_contentType"))
      parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
    if (json.has("blob"))
      res.setBlobElement(parseBase64Binary(json.get("blob").getAsString()));
    if (json.has("_blob"))
      parseElementProperties(json.getAsJsonObject("_blob"), res.getBlobElement());
  }

  protected SampledData parseSampledData(JsonObject json) throws IOException, FHIRFormatError {
    SampledData res = new SampledData();
    parseSampledDataProperties(json, res);
    return res;
  }

  protected void parseSampledDataProperties(JsonObject json, SampledData res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("origin"))
      res.setOrigin(parseSimpleQuantity(json.getAsJsonObject("origin")));
    if (json.has("period"))
      res.setPeriodElement(parseDecimal(json.get("period").getAsBigDecimal()));
    if (json.has("_period"))
      parseElementProperties(json.getAsJsonObject("_period"), res.getPeriodElement());
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("lowerLimit"))
      res.setLowerLimitElement(parseDecimal(json.get("lowerLimit").getAsBigDecimal()));
    if (json.has("_lowerLimit"))
      parseElementProperties(json.getAsJsonObject("_lowerLimit"), res.getLowerLimitElement());
    if (json.has("upperLimit"))
      res.setUpperLimitElement(parseDecimal(json.get("upperLimit").getAsBigDecimal()));
    if (json.has("_upperLimit"))
      parseElementProperties(json.getAsJsonObject("_upperLimit"), res.getUpperLimitElement());
    if (json.has("dimensions"))
      res.setDimensionsElement(parsePositiveInt(json.get("dimensions").getAsString()));
    if (json.has("_dimensions"))
      parseElementProperties(json.getAsJsonObject("_dimensions"), res.getDimensionsElement());
    if (json.has("data"))
      res.setDataElement(parseString(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
  }

  protected Ratio parseRatio(JsonObject json) throws IOException, FHIRFormatError {
    Ratio res = new Ratio();
    parseRatioProperties(json, res);
    return res;
  }

  protected void parseRatioProperties(JsonObject json, Ratio res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("numerator"))
      res.setNumerator(parseQuantity(json.getAsJsonObject("numerator")));
    if (json.has("denominator"))
      res.setDenominator(parseQuantity(json.getAsJsonObject("denominator")));
  }

  protected Distance parseDistance(JsonObject json) throws IOException, FHIRFormatError {
    Distance res = new Distance();
    parseDistanceProperties(json, res);
    return res;
  }

  protected void parseDistanceProperties(JsonObject json, Distance res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected Age parseAge(JsonObject json) throws IOException, FHIRFormatError {
    Age res = new Age();
    parseAgeProperties(json, res);
    return res;
  }

  protected void parseAgeProperties(JsonObject json, Age res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected CodeableConcept parseCodeableConcept(JsonObject json) throws IOException, FHIRFormatError {
    CodeableConcept res = new CodeableConcept();
    parseCodeableConceptProperties(json, res);
    return res;
  }

  protected void parseCodeableConceptProperties(JsonObject json, CodeableConcept res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("coding")) {
      JsonArray array = json.getAsJsonArray("coding");
      for (int i = 0; i < array.size(); i++) {
        res.getCoding().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
  }

  protected SimpleQuantity parseSimpleQuantity(JsonObject json) throws IOException, FHIRFormatError {
    SimpleQuantity res = new SimpleQuantity();
    parseSimpleQuantityProperties(json, res);
    return res;
  }

  protected void parseSimpleQuantityProperties(JsonObject json, SimpleQuantity res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("comparator"))
      res.setComparatorElement(parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
    if (json.has("_comparator"))
      parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
    if (json.has("unit"))
      res.setUnitElement(parseString(json.get("unit").getAsString()));
    if (json.has("_unit"))
      parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
  }

  protected Meta parseMeta(JsonObject json) throws IOException, FHIRFormatError {
    Meta res = new Meta();
    parseMetaProperties(json, res);
    return res;
  }

  protected void parseMetaProperties(JsonObject json, Meta res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("versionId"))
      res.setVersionIdElement(parseId(json.get("versionId").getAsString()));
    if (json.has("_versionId"))
      parseElementProperties(json.getAsJsonObject("_versionId"), res.getVersionIdElement());
    if (json.has("lastUpdated"))
      res.setLastUpdatedElement(parseInstant(json.get("lastUpdated").getAsString()));
    if (json.has("_lastUpdated"))
      parseElementProperties(json.getAsJsonObject("_lastUpdated"), res.getLastUpdatedElement());
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        res.getProfile().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_profile")) {
      JsonArray array = json.getAsJsonArray("_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
      }
    };
    if (json.has("security")) {
      JsonArray array = json.getAsJsonArray("security");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurity().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("tag")) {
      JsonArray array = json.getAsJsonArray("tag");
      for (int i = 0; i < array.size(); i++) {
        res.getTag().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Address parseAddress(JsonObject json) throws IOException, FHIRFormatError {
    Address res = new Address();
    parseAddressProperties(json, res);
    return res;
  }

  protected void parseAddressProperties(JsonObject json, Address res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("line")) {
      JsonArray array = json.getAsJsonArray("line");
      for (int i = 0; i < array.size(); i++) {
        res.getLine().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_line")) {
      JsonArray array = json.getAsJsonArray("_line");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLine().size())
          res.getLine().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLine().get(i));
      }
    };
    if (json.has("city"))
      res.setCityElement(parseString(json.get("city").getAsString()));
    if (json.has("_city"))
      parseElementProperties(json.getAsJsonObject("_city"), res.getCityElement());
    if (json.has("district"))
      res.setDistrictElement(parseString(json.get("district").getAsString()));
    if (json.has("_district"))
      parseElementProperties(json.getAsJsonObject("_district"), res.getDistrictElement());
    if (json.has("state"))
      res.setStateElement(parseString(json.get("state").getAsString()));
    if (json.has("_state"))
      parseElementProperties(json.getAsJsonObject("_state"), res.getStateElement());
    if (json.has("postalCode"))
      res.setPostalCodeElement(parseString(json.get("postalCode").getAsString()));
    if (json.has("_postalCode"))
      parseElementProperties(json.getAsJsonObject("_postalCode"), res.getPostalCodeElement());
    if (json.has("country"))
      res.setCountryElement(parseString(json.get("country").getAsString()));
    if (json.has("_country"))
      parseElementProperties(json.getAsJsonObject("_country"), res.getCountryElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected TriggerDefinition parseTriggerDefinition(JsonObject json) throws IOException, FHIRFormatError {
    TriggerDefinition res = new TriggerDefinition();
    parseTriggerDefinitionProperties(json, res);
    return res;
  }

  protected void parseTriggerDefinitionProperties(JsonObject json, TriggerDefinition res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), TriggerDefinition.TriggerType.NULL, new TriggerDefinition.TriggerTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("eventName"))
      res.setEventNameElement(parseString(json.get("eventName").getAsString()));
    if (json.has("_eventName"))
      parseElementProperties(json.getAsJsonObject("_eventName"), res.getEventNameElement());
    Type eventTiming = parseType("eventTiming", json);
    if (eventTiming != null)
      res.setEventTiming(eventTiming);
    if (json.has("eventData"))
      res.setEventData(parseDataRequirement(json.getAsJsonObject("eventData")));
  }

  protected Contributor parseContributor(JsonObject json) throws IOException, FHIRFormatError {
    Contributor res = new Contributor();
    parseContributorProperties(json, res);
    return res;
  }

  protected void parseContributorProperties(JsonObject json, Contributor res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Contributor.ContributorType.NULL, new Contributor.ContributorTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DataRequirement parseDataRequirement(JsonObject json) throws IOException, FHIRFormatError {
    DataRequirement res = new DataRequirement();
    parseDataRequirementProperties(json, res);
    return res;
  }

  protected void parseDataRequirementProperties(JsonObject json, DataRequirement res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        res.getProfile().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_profile")) {
      JsonArray array = json.getAsJsonArray("_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
      }
    };
    if (json.has("mustSupport")) {
      JsonArray array = json.getAsJsonArray("mustSupport");
      for (int i = 0; i < array.size(); i++) {
        res.getMustSupport().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_mustSupport")) {
      JsonArray array = json.getAsJsonArray("_mustSupport");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getMustSupport().size())
          res.getMustSupport().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getMustSupport().get(i));
      }
    };
    if (json.has("codeFilter")) {
      JsonArray array = json.getAsJsonArray("codeFilter");
      for (int i = 0; i < array.size(); i++) {
        res.getCodeFilter().add(parseDataRequirementDataRequirementCodeFilterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("dateFilter")) {
      JsonArray array = json.getAsJsonArray("dateFilter");
      for (int i = 0; i < array.size(); i++) {
        res.getDateFilter().add(parseDataRequirementDataRequirementDateFilterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementDataRequirementCodeFilterComponent(JsonObject json, DataRequirement owner) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
    parseDataRequirementDataRequirementCodeFilterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDataRequirementDataRequirementCodeFilterComponentProperties(JsonObject json, DataRequirement owner, DataRequirement.DataRequirementCodeFilterComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    Type valueSet = parseType("valueSet", json);
    if (valueSet != null)
      res.setValueSet(valueSet);
    if (json.has("valueCode")) {
      JsonArray array = json.getAsJsonArray("valueCode");
      for (int i = 0; i < array.size(); i++) {
        res.getValueCode().add(parseCode(array.get(i).getAsString()));
      }
    };
    if (json.has("_valueCode")) {
      JsonArray array = json.getAsJsonArray("_valueCode");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getValueCode().size())
          res.getValueCode().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getValueCode().get(i));
      }
    };
    if (json.has("valueCoding")) {
      JsonArray array = json.getAsJsonArray("valueCoding");
      for (int i = 0; i < array.size(); i++) {
        res.getValueCoding().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("valueCodeableConcept")) {
      JsonArray array = json.getAsJsonArray("valueCodeableConcept");
      for (int i = 0; i < array.size(); i++) {
        res.getValueCodeableConcept().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDataRequirementDateFilterComponent(JsonObject json, DataRequirement owner) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
    parseDataRequirementDataRequirementDateFilterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDataRequirementDataRequirementDateFilterComponentProperties(JsonObject json, DataRequirement owner, DataRequirement.DataRequirementDateFilterComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Dosage parseDosage(JsonObject json) throws IOException, FHIRFormatError {
    Dosage res = new Dosage();
    parseDosageProperties(json, res);
    return res;
  }

  protected void parseDosageProperties(JsonObject json, Dosage res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parseInteger(json.get("sequence").getAsLong()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("additionalInstruction")) {
      JsonArray array = json.getAsJsonArray("additionalInstruction");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditionalInstruction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patientInstruction"))
      res.setPatientInstructionElement(parseString(json.get("patientInstruction").getAsString()));
    if (json.has("_patientInstruction"))
      parseElementProperties(json.getAsJsonObject("_patientInstruction"), res.getPatientInstructionElement());
    if (json.has("timing"))
      res.setTiming(parseTiming(json.getAsJsonObject("timing")));
    Type asNeeded = parseType("asNeeded", json);
    if (asNeeded != null)
      res.setAsNeeded(asNeeded);
    if (json.has("site"))
      res.setSite(parseCodeableConcept(json.getAsJsonObject("site")));
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(json.getAsJsonObject("route")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    Type dose = parseType("dose", json);
    if (dose != null)
      res.setDose(dose);
    if (json.has("maxDosePerPeriod"))
      res.setMaxDosePerPeriod(parseRatio(json.getAsJsonObject("maxDosePerPeriod")));
    if (json.has("maxDosePerAdministration"))
      res.setMaxDosePerAdministration(parseSimpleQuantity(json.getAsJsonObject("maxDosePerAdministration")));
    if (json.has("maxDosePerLifetime"))
      res.setMaxDosePerLifetime(parseSimpleQuantity(json.getAsJsonObject("maxDosePerLifetime")));
    Type rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
  }

  protected RelatedArtifact parseRelatedArtifact(JsonObject json) throws IOException, FHIRFormatError {
    RelatedArtifact res = new RelatedArtifact();
    parseRelatedArtifactProperties(json, res);
    return res;
  }

  protected void parseRelatedArtifactProperties(JsonObject json, RelatedArtifact res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), RelatedArtifact.RelatedArtifactType.NULL, new RelatedArtifact.RelatedArtifactTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("citation"))
      res.setCitationElement(parseString(json.get("citation").getAsString()));
    if (json.has("_citation"))
      parseElementProperties(json.getAsJsonObject("_citation"), res.getCitationElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("document"))
      res.setDocument(parseAttachment(json.getAsJsonObject("document")));
    if (json.has("resource"))
      res.setResource(parseReference(json.getAsJsonObject("resource")));
  }

  protected ContactDetail parseContactDetail(JsonObject json) throws IOException, FHIRFormatError {
    ContactDetail res = new ContactDetail();
    parseContactDetailProperties(json, res);
    return res;
  }

  protected void parseContactDetailProperties(JsonObject json, ContactDetail res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected HumanName parseHumanName(JsonObject json) throws IOException, FHIRFormatError {
    HumanName res = new HumanName();
    parseHumanNameProperties(json, res);
    return res;
  }

  protected void parseHumanNameProperties(JsonObject json, HumanName res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("family"))
      res.setFamilyElement(parseString(json.get("family").getAsString()));
    if (json.has("_family"))
      parseElementProperties(json.getAsJsonObject("_family"), res.getFamilyElement());
    if (json.has("given")) {
      JsonArray array = json.getAsJsonArray("given");
      for (int i = 0; i < array.size(); i++) {
        res.getGiven().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_given")) {
      JsonArray array = json.getAsJsonArray("_given");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getGiven().size())
          res.getGiven().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getGiven().get(i));
      }
    };
    if (json.has("prefix")) {
      JsonArray array = json.getAsJsonArray("prefix");
      for (int i = 0; i < array.size(); i++) {
        res.getPrefix().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_prefix")) {
      JsonArray array = json.getAsJsonArray("_prefix");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPrefix().size())
          res.getPrefix().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPrefix().get(i));
      }
    };
    if (json.has("suffix")) {
      JsonArray array = json.getAsJsonArray("suffix");
      for (int i = 0; i < array.size(); i++) {
        res.getSuffix().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_suffix")) {
      JsonArray array = json.getAsJsonArray("_suffix");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSuffix().size())
          res.getSuffix().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSuffix().get(i));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected ContactPoint parseContactPoint(JsonObject json) throws IOException, FHIRFormatError {
    ContactPoint res = new ContactPoint();
    parseContactPointProperties(json, res);
    return res;
  }

  protected void parseContactPointProperties(JsonObject json, ContactPoint res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseEnumeration(json.get("system").getAsString(), ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("rank"))
      res.setRankElement(parsePositiveInt(json.get("rank").getAsString()));
    if (json.has("_rank"))
      parseElementProperties(json.getAsJsonObject("_rank"), res.getRankElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected UsageContext parseUsageContext(JsonObject json) throws IOException, FHIRFormatError {
    UsageContext res = new UsageContext();
    parseUsageContextProperties(json, res);
    return res;
  }

  protected void parseUsageContextProperties(JsonObject json, UsageContext res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCoding(json.getAsJsonObject("code")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Timing parseTiming(JsonObject json) throws IOException, FHIRFormatError {
    Timing res = new Timing();
    parseTimingProperties(json, res);
    return res;
  }

  protected void parseTimingProperties(JsonObject json, Timing res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseDateTime(array.get(i).getAsString()));
      }
    };
    if (json.has("_event")) {
      JsonArray array = json.getAsJsonArray("_event");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getEvent().size())
          res.getEvent().add(parseDateTime(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getEvent().get(i));
      }
    };
    if (json.has("repeat"))
      res.setRepeat(parseTimingTimingRepeatComponent(json.getAsJsonObject("repeat"), res));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
  }

  protected Timing.TimingRepeatComponent parseTimingTimingRepeatComponent(JsonObject json, Timing owner) throws IOException, FHIRFormatError {
    Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
    parseTimingTimingRepeatComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTimingTimingRepeatComponentProperties(JsonObject json, Timing owner, Timing.TimingRepeatComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    Type bounds = parseType("bounds", json);
    if (bounds != null)
      res.setBounds(bounds);
    if (json.has("count"))
      res.setCountElement(parseInteger(json.get("count").getAsLong()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("countMax"))
      res.setCountMaxElement(parseInteger(json.get("countMax").getAsLong()));
    if (json.has("_countMax"))
      parseElementProperties(json.getAsJsonObject("_countMax"), res.getCountMaxElement());
    if (json.has("duration"))
      res.setDurationElement(parseDecimal(json.get("duration").getAsBigDecimal()));
    if (json.has("_duration"))
      parseElementProperties(json.getAsJsonObject("_duration"), res.getDurationElement());
    if (json.has("durationMax"))
      res.setDurationMaxElement(parseDecimal(json.get("durationMax").getAsBigDecimal()));
    if (json.has("_durationMax"))
      parseElementProperties(json.getAsJsonObject("_durationMax"), res.getDurationMaxElement());
    if (json.has("durationUnit"))
      res.setDurationUnitElement(parseEnumeration(json.get("durationUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
    if (json.has("_durationUnit"))
      parseElementProperties(json.getAsJsonObject("_durationUnit"), res.getDurationUnitElement());
    if (json.has("frequency"))
      res.setFrequencyElement(parseInteger(json.get("frequency").getAsLong()));
    if (json.has("_frequency"))
      parseElementProperties(json.getAsJsonObject("_frequency"), res.getFrequencyElement());
    if (json.has("frequencyMax"))
      res.setFrequencyMaxElement(parseInteger(json.get("frequencyMax").getAsLong()));
    if (json.has("_frequencyMax"))
      parseElementProperties(json.getAsJsonObject("_frequencyMax"), res.getFrequencyMaxElement());
    if (json.has("period"))
      res.setPeriodElement(parseDecimal(json.get("period").getAsBigDecimal()));
    if (json.has("_period"))
      parseElementProperties(json.getAsJsonObject("_period"), res.getPeriodElement());
    if (json.has("periodMax"))
      res.setPeriodMaxElement(parseDecimal(json.get("periodMax").getAsBigDecimal()));
    if (json.has("_periodMax"))
      parseElementProperties(json.getAsJsonObject("_periodMax"), res.getPeriodMaxElement());
    if (json.has("periodUnit"))
      res.setPeriodUnitElement(parseEnumeration(json.get("periodUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
    if (json.has("_periodUnit"))
      parseElementProperties(json.getAsJsonObject("_periodUnit"), res.getPeriodUnitElement());
    if (json.has("dayOfWeek")) {
      JsonArray array = json.getAsJsonArray("dayOfWeek");
      for (int i = 0; i < array.size(); i++) {
        res.getDayOfWeek().add(parseEnumeration(array.get(i).getAsString(), Timing.DayOfWeek.NULL, new Timing.DayOfWeekEnumFactory()));
      }
    };
    if (json.has("_dayOfWeek")) {
      JsonArray array = json.getAsJsonArray("_dayOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDayOfWeek().size())
          res.getDayOfWeek().add(parseEnumeration(null, Timing.DayOfWeek.NULL, new Timing.DayOfWeekEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDayOfWeek().get(i));
      }
    };
    if (json.has("timeOfDay")) {
      JsonArray array = json.getAsJsonArray("timeOfDay");
      for (int i = 0; i < array.size(); i++) {
        res.getTimeOfDay().add(parseTime(array.get(i).getAsString()));
      }
    };
    if (json.has("_timeOfDay")) {
      JsonArray array = json.getAsJsonArray("_timeOfDay");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getTimeOfDay().size())
          res.getTimeOfDay().add(parseTime(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getTimeOfDay().get(i));
      }
    };
    if (json.has("when")) {
      JsonArray array = json.getAsJsonArray("when");
      for (int i = 0; i < array.size(); i++) {
        res.getWhen().add(parseEnumeration(array.get(i).getAsString(), Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
      }
    };
    if (json.has("_when")) {
      JsonArray array = json.getAsJsonArray("_when");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getWhen().size())
          res.getWhen().add(parseEnumeration(null, Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getWhen().get(i));
      }
    };
    if (json.has("offset"))
      res.setOffsetElement(parseUnsignedInt(json.get("offset").getAsString()));
    if (json.has("_offset"))
      parseElementProperties(json.getAsJsonObject("_offset"), res.getOffsetElement());
  }

  protected ElementDefinition parseElementDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition res = new ElementDefinition();
    parseElementDefinitionProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionProperties(JsonObject json, ElementDefinition res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("representation")) {
      JsonArray array = json.getAsJsonArray("representation");
      for (int i = 0; i < array.size(); i++) {
        res.getRepresentation().add(parseEnumeration(array.get(i).getAsString(), ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
      }
    };
    if (json.has("_representation")) {
      JsonArray array = json.getAsJsonArray("_representation");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getRepresentation().size())
          res.getRepresentation().add(parseEnumeration(null, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getRepresentation().get(i));
      }
    };
    if (json.has("sliceName"))
      res.setSliceNameElement(parseString(json.get("sliceName").getAsString()));
    if (json.has("_sliceName"))
      parseElementProperties(json.getAsJsonObject("_sliceName"), res.getSliceNameElement());
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("slicing"))
      res.setSlicing(parseElementDefinitionElementDefinitionSlicingComponent(json.getAsJsonObject("slicing"), res));
    if (json.has("short"))
      res.setShortElement(parseString(json.get("short").getAsString()));
    if (json.has("_short"))
      parseElementProperties(json.getAsJsonObject("_short"), res.getShortElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseMarkdown(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("comment"))
      res.setCommentElement(parseMarkdown(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("requirements"))
      res.setRequirementsElement(parseMarkdown(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        res.getAlias().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    };
    if (json.has("min"))
      res.setMinElement(parseUnsignedInt(json.get("min").getAsString()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
    if (json.has("base"))
      res.setBase(parseElementDefinitionElementDefinitionBaseComponent(json.getAsJsonObject("base"), res));
    if (json.has("contentReference"))
      res.setContentReferenceElement(parseUri(json.get("contentReference").getAsString()));
    if (json.has("_contentReference"))
      parseElementProperties(json.getAsJsonObject("_contentReference"), res.getContentReferenceElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseElementDefinitionTypeRefComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type defaultValue = parseType("defaultValue", json);
    if (defaultValue != null)
      res.setDefaultValue(defaultValue);
    if (json.has("meaningWhenMissing"))
      res.setMeaningWhenMissingElement(parseMarkdown(json.get("meaningWhenMissing").getAsString()));
    if (json.has("_meaningWhenMissing"))
      parseElementProperties(json.getAsJsonObject("_meaningWhenMissing"), res.getMeaningWhenMissingElement());
    if (json.has("orderMeaning"))
      res.setOrderMeaningElement(parseString(json.get("orderMeaning").getAsString()));
    if (json.has("_orderMeaning"))
      parseElementProperties(json.getAsJsonObject("_orderMeaning"), res.getOrderMeaningElement());
    Type fixed = parseType("fixed", json);
    if (fixed != null)
      res.setFixed(fixed);
    Type pattern = parseType("pattern", json);
    if (pattern != null)
      res.setPattern(pattern);
    if (json.has("example")) {
      JsonArray array = json.getAsJsonArray("example");
      for (int i = 0; i < array.size(); i++) {
        res.getExample().add(parseElementDefinitionElementDefinitionExampleComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type minValue = parseType("minValue", json);
    if (minValue != null)
      res.setMinValue(minValue);
    Type maxValue = parseType("maxValue", json);
    if (maxValue != null)
      res.setMaxValue(maxValue);
    if (json.has("maxLength"))
      res.setMaxLengthElement(parseInteger(json.get("maxLength").getAsLong()));
    if (json.has("_maxLength"))
      parseElementProperties(json.getAsJsonObject("_maxLength"), res.getMaxLengthElement());
    if (json.has("condition")) {
      JsonArray array = json.getAsJsonArray("condition");
      for (int i = 0; i < array.size(); i++) {
        res.getCondition().add(parseId(array.get(i).getAsString()));
      }
    };
    if (json.has("_condition")) {
      JsonArray array = json.getAsJsonArray("_condition");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCondition().size())
          res.getCondition().add(parseId(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCondition().get(i));
      }
    };
    if (json.has("constraint")) {
      JsonArray array = json.getAsJsonArray("constraint");
      for (int i = 0; i < array.size(); i++) {
        res.getConstraint().add(parseElementDefinitionElementDefinitionConstraintComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("mustSupport"))
      res.setMustSupportElement(parseBoolean(json.get("mustSupport").getAsBoolean()));
    if (json.has("_mustSupport"))
      parseElementProperties(json.getAsJsonObject("_mustSupport"), res.getMustSupportElement());
    if (json.has("isModifier"))
      res.setIsModifierElement(parseBoolean(json.get("isModifier").getAsBoolean()));
    if (json.has("_isModifier"))
      parseElementProperties(json.getAsJsonObject("_isModifier"), res.getIsModifierElement());
    if (json.has("isSummary"))
      res.setIsSummaryElement(parseBoolean(json.get("isSummary").getAsBoolean()));
    if (json.has("_isSummary"))
      parseElementProperties(json.getAsJsonObject("_isSummary"), res.getIsSummaryElement());
    if (json.has("binding"))
      res.setBinding(parseElementDefinitionElementDefinitionBindingComponent(json.getAsJsonObject("binding"), res));
    if (json.has("mapping")) {
      JsonArray array = json.getAsJsonArray("mapping");
      for (int i = 0; i < array.size(); i++) {
        res.getMapping().add(parseElementDefinitionElementDefinitionMappingComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionElementDefinitionSlicingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
    parseElementDefinitionElementDefinitionSlicingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionSlicingComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionSlicingComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("discriminator")) {
      JsonArray array = json.getAsJsonArray("discriminator");
      for (int i = 0; i < array.size(); i++) {
        res.getDiscriminator().add(parseElementDefinitionElementDefinitionSlicingDiscriminatorComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("ordered"))
      res.setOrderedElement(parseBoolean(json.get("ordered").getAsBoolean()));
    if (json.has("_ordered"))
      parseElementProperties(json.getAsJsonObject("_ordered"), res.getOrderedElement());
    if (json.has("rules"))
      res.setRulesElement(parseEnumeration(json.get("rules").getAsString(), ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
    if (json.has("_rules"))
      parseElementProperties(json.getAsJsonObject("_rules"), res.getRulesElement());
  }

  protected ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent parseElementDefinitionElementDefinitionSlicingDiscriminatorComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
    parseElementDefinitionElementDefinitionSlicingDiscriminatorComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionSlicingDiscriminatorComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ElementDefinition.DiscriminatorType.NULL, new ElementDefinition.DiscriminatorTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
  }

  protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionElementDefinitionBaseComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
    parseElementDefinitionElementDefinitionBaseComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionBaseComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionBaseComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("min"))
      res.setMinElement(parseUnsignedInt(json.get("min").getAsString()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
  }

  protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
    parseElementDefinitionTypeRefComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionTypeRefComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.TypeRefComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseUri(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("profile"))
      res.setProfileElement(parseUri(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
    if (json.has("targetProfile"))
      res.setTargetProfileElement(parseUri(json.get("targetProfile").getAsString()));
    if (json.has("_targetProfile"))
      parseElementProperties(json.getAsJsonObject("_targetProfile"), res.getTargetProfileElement());
    if (json.has("aggregation")) {
      JsonArray array = json.getAsJsonArray("aggregation");
      for (int i = 0; i < array.size(); i++) {
        res.getAggregation().add(parseEnumeration(array.get(i).getAsString(), ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
      }
    };
    if (json.has("_aggregation")) {
      JsonArray array = json.getAsJsonArray("_aggregation");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAggregation().size())
          res.getAggregation().add(parseEnumeration(null, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAggregation().get(i));
      }
    };
    if (json.has("versioning"))
      res.setVersioningElement(parseEnumeration(json.get("versioning").getAsString(), ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
    if (json.has("_versioning"))
      parseElementProperties(json.getAsJsonObject("_versioning"), res.getVersioningElement());
  }

  protected ElementDefinition.ElementDefinitionExampleComponent parseElementDefinitionElementDefinitionExampleComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionExampleComponent res = new ElementDefinition.ElementDefinitionExampleComponent();
    parseElementDefinitionElementDefinitionExampleComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionExampleComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionExampleComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionElementDefinitionConstraintComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
    parseElementDefinitionElementDefinitionConstraintComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionConstraintComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionConstraintComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("key"))
      res.setKeyElement(parseId(json.get("key").getAsString()));
    if (json.has("_key"))
      parseElementProperties(json.getAsJsonObject("_key"), res.getKeyElement());
    if (json.has("requirements"))
      res.setRequirementsElement(parseString(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
    if (json.has("human"))
      res.setHumanElement(parseString(json.get("human").getAsString()));
    if (json.has("_human"))
      parseElementProperties(json.getAsJsonObject("_human"), res.getHumanElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
    if (json.has("xpath"))
      res.setXpathElement(parseString(json.get("xpath").getAsString()));
    if (json.has("_xpath"))
      parseElementProperties(json.getAsJsonObject("_xpath"), res.getXpathElement());
    if (json.has("source"))
      res.setSourceElement(parseUri(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
  }

  protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionElementDefinitionBindingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
    parseElementDefinitionElementDefinitionBindingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionBindingComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionBindingComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("strength"))
      res.setStrengthElement(parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
    if (json.has("_strength"))
      parseElementProperties(json.getAsJsonObject("_strength"), res.getStrengthElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    Type valueSet = parseType("valueSet", json);
    if (valueSet != null)
      res.setValueSet(valueSet);
  }

  protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionElementDefinitionMappingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
    parseElementDefinitionElementDefinitionMappingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionMappingComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionMappingComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("identity"))
      res.setIdentityElement(parseId(json.get("identity").getAsString()));
    if (json.has("_identity"))
      parseElementProperties(json.getAsJsonObject("_identity"), res.getIdentityElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("map"))
      res.setMapElement(parseString(json.get("map").getAsString()));
    if (json.has("_map"))
      parseElementProperties(json.getAsJsonObject("_map"), res.getMapElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
  }

  protected ParameterDefinition parseParameterDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ParameterDefinition res = new ParameterDefinition();
    parseParameterDefinitionProperties(json, res);
    return res;
  }

  protected void parseParameterDefinitionProperties(JsonObject json, ParameterDefinition res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseCode(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), ParameterDefinition.ParameterUse.NULL, new ParameterDefinition.ParameterUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfile(parseReference(json.getAsJsonObject("profile")));
  }

  protected void parseDomainResourceProperties(JsonObject json, DomainResource res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("text"))
      res.setText(parseNarrative(json.getAsJsonObject("text")));
    if (json.has("contained")) {
      JsonArray array = json.getAsJsonArray("contained");
      for (int i = 0; i < array.size(); i++) {
        res.getContained().add(parseResource(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("extension")) {
      JsonArray array = json.getAsJsonArray("extension");
      for (int i = 0; i < array.size(); i++) {
        res.getExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("modifierExtension")) {
      JsonArray array = json.getAsJsonArray("modifierExtension");
      for (int i = 0; i < array.size(); i++) {
        res.getModifierExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Parameters parseParameters(JsonObject json) throws IOException, FHIRFormatError {
    Parameters res = new Parameters();
    parseParametersProperties(json, res);
    return res;
  }

  protected void parseParametersProperties(JsonObject json, Parameters res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseParametersParametersParameterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Parameters.ParametersParameterComponent parseParametersParametersParameterComponent(JsonObject json, Parameters owner) throws IOException, FHIRFormatError {
    Parameters.ParametersParameterComponent res = new Parameters.ParametersParameterComponent();
    parseParametersParametersParameterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseParametersParametersParameterComponentProperties(JsonObject json, Parameters owner, Parameters.ParametersParameterComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("resource"))
      res.setResource(parseResource(json.getAsJsonObject("resource")));
    if (json.has("part")) {
      JsonArray array = json.getAsJsonArray("part");
      for (int i = 0; i < array.size(); i++) {
        res.getPart().add(parseParametersParametersParameterComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected void parseResourceProperties(JsonObject json, Resource res) throws IOException, FHIRFormatError {
    if (json.has("id"))
      res.setIdElement(parseId(json.get("id").getAsString()));
    if (json.has("_id"))
      parseElementProperties(json.getAsJsonObject("_id"), res.getIdElement());
    if (json.has("meta"))
      res.setMeta(parseMeta(json.getAsJsonObject("meta")));
    if (json.has("implicitRules"))
      res.setImplicitRulesElement(parseUri(json.get("implicitRules").getAsString()));
    if (json.has("_implicitRules"))
      parseElementProperties(json.getAsJsonObject("_implicitRules"), res.getImplicitRulesElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
  }

  protected Account parseAccount(JsonObject json) throws IOException, FHIRFormatError {
    Account res = new Account();
    parseAccountProperties(json, res);
    return res;
  }

  protected void parseAccountProperties(JsonObject json, Account res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("active"))
      res.setActive(parsePeriod(json.getAsJsonObject("active")));
    if (json.has("balance"))
      res.setBalance(parseMoney(json.getAsJsonObject("balance")));
    if (json.has("coverage")) {
      JsonArray array = json.getAsJsonArray("coverage");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverage().add(parseAccountCoverageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("owner"))
      res.setOwner(parseReference(json.getAsJsonObject("owner")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("guarantor")) {
      JsonArray array = json.getAsJsonArray("guarantor");
      for (int i = 0; i < array.size(); i++) {
        res.getGuarantor().add(parseAccountGuarantorComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Account.CoverageComponent parseAccountCoverageComponent(JsonObject json, Account owner) throws IOException, FHIRFormatError {
    Account.CoverageComponent res = new Account.CoverageComponent();
    parseAccountCoverageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAccountCoverageComponentProperties(JsonObject json, Account owner, Account.CoverageComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("priority"))
      res.setPriorityElement(parsePositiveInt(json.get("priority").getAsString()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
  }

  protected Account.GuarantorComponent parseAccountGuarantorComponent(JsonObject json, Account owner) throws IOException, FHIRFormatError {
    Account.GuarantorComponent res = new Account.GuarantorComponent();
    parseAccountGuarantorComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAccountGuarantorComponentProperties(JsonObject json, Account owner, Account.GuarantorComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
    if (json.has("onHold"))
      res.setOnHoldElement(parseBoolean(json.get("onHold").getAsBoolean()));
    if (json.has("_onHold"))
      parseElementProperties(json.getAsJsonObject("_onHold"), res.getOnHoldElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected ActivityDefinition parseActivityDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ActivityDefinition res = new ActivityDefinition();
    parseActivityDefinitionProperties(json, res);
    return res;
  }

  protected void parseActivityDefinitionProperties(JsonObject json, ActivityDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contributor")) {
      JsonArray array = json.getAsJsonArray("contributor");
      for (int i = 0; i < array.size(); i++) {
        res.getContributor().add(parseContributor(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("library")) {
      JsonArray array = json.getAsJsonArray("library");
      for (int i = 0; i < array.size(); i++) {
        res.getLibrary().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), ActivityDefinition.ActivityDefinitionKind.NULL, new ActivityDefinition.ActivityDefinitionKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseActivityDefinitionActivityDefinitionParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type product = parseType("product", json);
    if (product != null)
      res.setProduct(product);
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("dosage")) {
      JsonArray array = json.getAsJsonArray("dosage");
      for (int i = 0; i < array.size(); i++) {
        res.getDosage().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite")) {
      JsonArray array = json.getAsJsonArray("bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("transform"))
      res.setTransform(parseReference(json.getAsJsonObject("transform")));
    if (json.has("dynamicValue")) {
      JsonArray array = json.getAsJsonArray("dynamicValue");
      for (int i = 0; i < array.size(); i++) {
        res.getDynamicValue().add(parseActivityDefinitionActivityDefinitionDynamicValueComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ActivityDefinition.ActivityDefinitionParticipantComponent parseActivityDefinitionActivityDefinitionParticipantComponent(JsonObject json, ActivityDefinition owner) throws IOException, FHIRFormatError {
    ActivityDefinition.ActivityDefinitionParticipantComponent res = new ActivityDefinition.ActivityDefinitionParticipantComponent();
    parseActivityDefinitionActivityDefinitionParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseActivityDefinitionActivityDefinitionParticipantComponentProperties(JsonObject json, ActivityDefinition owner, ActivityDefinition.ActivityDefinitionParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ActivityDefinition.ActivityParticipantType.NULL, new ActivityDefinition.ActivityParticipantTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
  }

  protected ActivityDefinition.ActivityDefinitionDynamicValueComponent parseActivityDefinitionActivityDefinitionDynamicValueComponent(JsonObject json, ActivityDefinition owner) throws IOException, FHIRFormatError {
    ActivityDefinition.ActivityDefinitionDynamicValueComponent res = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
    parseActivityDefinitionActivityDefinitionDynamicValueComponentProperties(json, owner, res);
    return res;
  }

  protected void parseActivityDefinitionActivityDefinitionDynamicValueComponentProperties(JsonObject json, ActivityDefinition owner, ActivityDefinition.ActivityDefinitionDynamicValueComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("language"))
      res.setLanguageElement(parseString(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
  }

  protected AdverseEvent parseAdverseEvent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent res = new AdverseEvent();
    parseAdverseEventProperties(json, res);
    return res;
  }

  protected void parseAdverseEventProperties(JsonObject json, AdverseEvent res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("category"))
      res.setCategoryElement(parseEnumeration(json.get("category").getAsString(), AdverseEvent.AdverseEventCategory.NULL, new AdverseEvent.AdverseEventCategoryEnumFactory()));
    if (json.has("_category"))
      parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("reaction")) {
      JsonArray array = json.getAsJsonArray("reaction");
      for (int i = 0; i < array.size(); i++) {
        res.getReaction().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("seriousness"))
      res.setSeriousness(parseCodeableConcept(json.getAsJsonObject("seriousness")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    if (json.has("recorder"))
      res.setRecorder(parseReference(json.getAsJsonObject("recorder")));
    if (json.has("eventParticipant"))
      res.setEventParticipant(parseReference(json.getAsJsonObject("eventParticipant")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("suspectEntity")) {
      JsonArray array = json.getAsJsonArray("suspectEntity");
      for (int i = 0; i < array.size(); i++) {
        res.getSuspectEntity().add(parseAdverseEventAdverseEventSuspectEntityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("subjectMedicalHistory")) {
      JsonArray array = json.getAsJsonArray("subjectMedicalHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getSubjectMedicalHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referenceDocument")) {
      JsonArray array = json.getAsJsonArray("referenceDocument");
      for (int i = 0; i < array.size(); i++) {
        res.getReferenceDocument().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("study")) {
      JsonArray array = json.getAsJsonArray("study");
      for (int i = 0; i < array.size(); i++) {
        res.getStudy().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AdverseEvent.AdverseEventSuspectEntityComponent parseAdverseEventAdverseEventSuspectEntityComponent(JsonObject json, AdverseEvent owner) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSuspectEntityComponent res = new AdverseEvent.AdverseEventSuspectEntityComponent();
    parseAdverseEventAdverseEventSuspectEntityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAdverseEventAdverseEventSuspectEntityComponentProperties(JsonObject json, AdverseEvent owner, AdverseEvent.AdverseEventSuspectEntityComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("instance"))
      res.setInstance(parseReference(json.getAsJsonObject("instance")));
    if (json.has("causality"))
      res.setCausalityElement(parseEnumeration(json.get("causality").getAsString(), AdverseEvent.AdverseEventCausality.NULL, new AdverseEvent.AdverseEventCausalityEnumFactory()));
    if (json.has("_causality"))
      parseElementProperties(json.getAsJsonObject("_causality"), res.getCausalityElement());
    if (json.has("causalityAssessment"))
      res.setCausalityAssessment(parseCodeableConcept(json.getAsJsonObject("causalityAssessment")));
    if (json.has("causalityProductRelatedness"))
      res.setCausalityProductRelatednessElement(parseString(json.get("causalityProductRelatedness").getAsString()));
    if (json.has("_causalityProductRelatedness"))
      parseElementProperties(json.getAsJsonObject("_causalityProductRelatedness"), res.getCausalityProductRelatednessElement());
    if (json.has("causalityMethod"))
      res.setCausalityMethod(parseCodeableConcept(json.getAsJsonObject("causalityMethod")));
    if (json.has("causalityAuthor"))
      res.setCausalityAuthor(parseReference(json.getAsJsonObject("causalityAuthor")));
    if (json.has("causalityResult"))
      res.setCausalityResult(parseCodeableConcept(json.getAsJsonObject("causalityResult")));
  }

  protected AllergyIntolerance parseAllergyIntolerance(JsonObject json) throws IOException, FHIRFormatError {
    AllergyIntolerance res = new AllergyIntolerance();
    parseAllergyIntoleranceProperties(json, res);
    return res;
  }

  protected void parseAllergyIntoleranceProperties(JsonObject json, AllergyIntolerance res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("clinicalStatus"))
      res.setClinicalStatusElement(parseEnumeration(json.get("clinicalStatus").getAsString(), AllergyIntolerance.AllergyIntoleranceClinicalStatus.NULL, new AllergyIntolerance.AllergyIntoleranceClinicalStatusEnumFactory()));
    if (json.has("_clinicalStatus"))
      parseElementProperties(json.getAsJsonObject("_clinicalStatus"), res.getClinicalStatusElement());
    if (json.has("verificationStatus"))
      res.setVerificationStatusElement(parseEnumeration(json.get("verificationStatus").getAsString(), AllergyIntolerance.AllergyIntoleranceVerificationStatus.NULL, new AllergyIntolerance.AllergyIntoleranceVerificationStatusEnumFactory()));
    if (json.has("_verificationStatus"))
      parseElementProperties(json.getAsJsonObject("_verificationStatus"), res.getVerificationStatusElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), AllergyIntolerance.AllergyIntoleranceType.NULL, new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseEnumeration(array.get(i).getAsString(), AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
      }
    };
    if (json.has("_category")) {
      JsonArray array = json.getAsJsonArray("_category");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCategory().size())
          res.getCategory().add(parseEnumeration(null, AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCategory().get(i));
      }
    };
    if (json.has("criticality"))
      res.setCriticalityElement(parseEnumeration(json.get("criticality").getAsString(), AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
    if (json.has("_criticality"))
      parseElementProperties(json.getAsJsonObject("_criticality"), res.getCriticalityElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    Type onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    if (json.has("assertedDate"))
      res.setAssertedDateElement(parseDateTime(json.get("assertedDate").getAsString()));
    if (json.has("_assertedDate"))
      parseElementProperties(json.getAsJsonObject("_assertedDate"), res.getAssertedDateElement());
    if (json.has("recorder"))
      res.setRecorder(parseReference(json.getAsJsonObject("recorder")));
    if (json.has("asserter"))
      res.setAsserter(parseReference(json.getAsJsonObject("asserter")));
    if (json.has("lastOccurrence"))
      res.setLastOccurrenceElement(parseDateTime(json.get("lastOccurrence").getAsString()));
    if (json.has("_lastOccurrence"))
      parseElementProperties(json.getAsJsonObject("_lastOccurrence"), res.getLastOccurrenceElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reaction")) {
      JsonArray array = json.getAsJsonArray("reaction");
      for (int i = 0; i < array.size(); i++) {
        res.getReaction().add(parseAllergyIntoleranceAllergyIntoleranceReactionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceAllergyIntoleranceReactionComponent(JsonObject json, AllergyIntolerance owner) throws IOException, FHIRFormatError {
    AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
    parseAllergyIntoleranceAllergyIntoleranceReactionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAllergyIntoleranceAllergyIntoleranceReactionComponentProperties(JsonObject json, AllergyIntolerance owner, AllergyIntolerance.AllergyIntoleranceReactionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("substance"))
      res.setSubstance(parseCodeableConcept(json.getAsJsonObject("substance")));
    if (json.has("manifestation")) {
      JsonArray array = json.getAsJsonArray("manifestation");
      for (int i = 0; i < array.size(); i++) {
        res.getManifestation().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("onset"))
      res.setOnsetElement(parseDateTime(json.get("onset").getAsString()));
    if (json.has("_onset"))
      parseElementProperties(json.getAsJsonObject("_onset"), res.getOnsetElement());
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
    if (json.has("exposureRoute"))
      res.setExposureRoute(parseCodeableConcept(json.getAsJsonObject("exposureRoute")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Appointment parseAppointment(JsonObject json) throws IOException, FHIRFormatError {
    Appointment res = new Appointment();
    parseAppointmentProperties(json, res);
    return res;
  }

  protected void parseAppointmentProperties(JsonObject json, Appointment res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("serviceCategory"))
      res.setServiceCategory(parseCodeableConcept(json.getAsJsonObject("serviceCategory")));
    if (json.has("serviceType")) {
      JsonArray array = json.getAsJsonArray("serviceType");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("appointmentType"))
      res.setAppointmentType(parseCodeableConcept(json.getAsJsonObject("appointmentType")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("indication")) {
      JsonArray array = json.getAsJsonArray("indication");
      for (int i = 0; i < array.size(); i++) {
        res.getIndication().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriorityElement(parseUnsignedInt(json.get("priority").getAsString()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("start"))
      res.setStartElement(parseInstant(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInstant(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("minutesDuration"))
      res.setMinutesDurationElement(parsePositiveInt(json.get("minutesDuration").getAsString()));
    if (json.has("_minutesDuration"))
      parseElementProperties(json.getAsJsonObject("_minutesDuration"), res.getMinutesDurationElement());
    if (json.has("slot")) {
      JsonArray array = json.getAsJsonArray("slot");
      for (int i = 0; i < array.size(); i++) {
        res.getSlot().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("incomingReferral")) {
      JsonArray array = json.getAsJsonArray("incomingReferral");
      for (int i = 0; i < array.size(); i++) {
        res.getIncomingReferral().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseAppointmentAppointmentParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("requestedPeriod")) {
      JsonArray array = json.getAsJsonArray("requestedPeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getRequestedPeriod().add(parsePeriod(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Appointment.AppointmentParticipantComponent parseAppointmentAppointmentParticipantComponent(JsonObject json, Appointment owner) throws IOException, FHIRFormatError {
    Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
    parseAppointmentAppointmentParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAppointmentAppointmentParticipantComponentProperties(JsonObject json, Appointment owner, Appointment.AppointmentParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("required"))
      res.setRequiredElement(parseEnumeration(json.get("required").getAsString(), Appointment.ParticipantRequired.NULL, new Appointment.ParticipantRequiredEnumFactory()));
    if (json.has("_required"))
      parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Appointment.ParticipationStatus.NULL, new Appointment.ParticipationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
  }

  protected AppointmentResponse parseAppointmentResponse(JsonObject json) throws IOException, FHIRFormatError {
    AppointmentResponse res = new AppointmentResponse();
    parseAppointmentResponseProperties(json, res);
    return res;
  }

  protected void parseAppointmentResponseProperties(JsonObject json, AppointmentResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("appointment"))
      res.setAppointment(parseReference(json.getAsJsonObject("appointment")));
    if (json.has("start"))
      res.setStartElement(parseInstant(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInstant(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("participantType")) {
      JsonArray array = json.getAsJsonArray("participantType");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipantType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("participantStatus"))
      res.setParticipantStatusElement(parseEnumeration(json.get("participantStatus").getAsString(), AppointmentResponse.ParticipantStatus.NULL, new AppointmentResponse.ParticipantStatusEnumFactory()));
    if (json.has("_participantStatus"))
      parseElementProperties(json.getAsJsonObject("_participantStatus"), res.getParticipantStatusElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
  }

  protected AuditEvent parseAuditEvent(JsonObject json) throws IOException, FHIRFormatError {
    AuditEvent res = new AuditEvent();
    parseAuditEventProperties(json, res);
    return res;
  }

  protected void parseAuditEventProperties(JsonObject json, AuditEvent res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("subtype")) {
      JsonArray array = json.getAsJsonArray("subtype");
      for (int i = 0; i < array.size(); i++) {
        res.getSubtype().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("action"))
      res.setActionElement(parseEnumeration(json.get("action").getAsString(), AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
    if (json.has("_action"))
      parseElementProperties(json.getAsJsonObject("_action"), res.getActionElement());
    if (json.has("recorded"))
      res.setRecordedElement(parseInstant(json.get("recorded").getAsString()));
    if (json.has("_recorded"))
      parseElementProperties(json.getAsJsonObject("_recorded"), res.getRecordedElement());
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), AuditEvent.AuditEventOutcome.NULL, new AuditEvent.AuditEventOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("outcomeDesc"))
      res.setOutcomeDescElement(parseString(json.get("outcomeDesc").getAsString()));
    if (json.has("_outcomeDesc"))
      parseElementProperties(json.getAsJsonObject("_outcomeDesc"), res.getOutcomeDescElement());
    if (json.has("purposeOfEvent")) {
      JsonArray array = json.getAsJsonArray("purposeOfEvent");
      for (int i = 0; i < array.size(); i++) {
        res.getPurposeOfEvent().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("agent")) {
      JsonArray array = json.getAsJsonArray("agent");
      for (int i = 0; i < array.size(); i++) {
        res.getAgent().add(parseAuditEventAuditEventAgentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("source"))
      res.setSource(parseAuditEventAuditEventSourceComponent(json.getAsJsonObject("source"), res));
    if (json.has("entity")) {
      JsonArray array = json.getAsJsonArray("entity");
      for (int i = 0; i < array.size(); i++) {
        res.getEntity().add(parseAuditEventAuditEventEntityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected AuditEvent.AuditEventAgentComponent parseAuditEventAuditEventAgentComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
    parseAuditEventAuditEventAgentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAuditEventAuditEventAgentComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventAgentComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("role")) {
      JsonArray array = json.getAsJsonArray("role");
      for (int i = 0; i < array.size(); i++) {
        res.getRole().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
    if (json.has("userId"))
      res.setUserId(parseIdentifier(json.getAsJsonObject("userId")));
    if (json.has("altId"))
      res.setAltIdElement(parseString(json.get("altId").getAsString()));
    if (json.has("_altId"))
      parseElementProperties(json.getAsJsonObject("_altId"), res.getAltIdElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("requestor"))
      res.setRequestorElement(parseBoolean(json.get("requestor").getAsBoolean()));
    if (json.has("_requestor"))
      parseElementProperties(json.getAsJsonObject("_requestor"), res.getRequestorElement());
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("policy")) {
      JsonArray array = json.getAsJsonArray("policy");
      for (int i = 0; i < array.size(); i++) {
        res.getPolicy().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_policy")) {
      JsonArray array = json.getAsJsonArray("_policy");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPolicy().size())
          res.getPolicy().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPolicy().get(i));
      }
    };
    if (json.has("media"))
      res.setMedia(parseCoding(json.getAsJsonObject("media")));
    if (json.has("network"))
      res.setNetwork(parseAuditEventAuditEventAgentNetworkComponent(json.getAsJsonObject("network"), owner));
    if (json.has("purposeOfUse")) {
      JsonArray array = json.getAsJsonArray("purposeOfUse");
      for (int i = 0; i < array.size(); i++) {
        res.getPurposeOfUse().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AuditEvent.AuditEventAgentNetworkComponent parseAuditEventAuditEventAgentNetworkComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentNetworkComponent res = new AuditEvent.AuditEventAgentNetworkComponent();
    parseAuditEventAuditEventAgentNetworkComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAuditEventAuditEventAgentNetworkComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventAgentNetworkComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("address"))
      res.setAddressElement(parseString(json.get("address").getAsString()));
    if (json.has("_address"))
      parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), AuditEvent.AuditEventAgentNetworkType.NULL, new AuditEvent.AuditEventAgentNetworkTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
  }

  protected AuditEvent.AuditEventSourceComponent parseAuditEventAuditEventSourceComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
    parseAuditEventAuditEventSourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAuditEventAuditEventSourceComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventSourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("site"))
      res.setSiteElement(parseString(json.get("site").getAsString()));
    if (json.has("_site"))
      parseElementProperties(json.getAsJsonObject("_site"), res.getSiteElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AuditEvent.AuditEventEntityComponent parseAuditEventAuditEventEntityComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
    parseAuditEventAuditEventEntityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAuditEventAuditEventEntityComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventEntityComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("role"))
      res.setRole(parseCoding(json.getAsJsonObject("role")));
    if (json.has("lifecycle"))
      res.setLifecycle(parseCoding(json.getAsJsonObject("lifecycle")));
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("query"))
      res.setQueryElement(parseBase64Binary(json.get("query").getAsString()));
    if (json.has("_query"))
      parseElementProperties(json.getAsJsonObject("_query"), res.getQueryElement());
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseAuditEventAuditEventEntityDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventAuditEventEntityDetailComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
    parseAuditEventAuditEventEntityDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAuditEventAuditEventEntityDetailComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventEntityDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseString(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("value"))
      res.setValueElement(parseBase64Binary(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected Basic parseBasic(JsonObject json) throws IOException, FHIRFormatError {
    Basic res = new Basic();
    parseBasicProperties(json, res);
    return res;
  }

  protected void parseBasicProperties(JsonObject json, Basic res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("created"))
      res.setCreatedElement(parseDate(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
  }

  protected Binary parseBinary(JsonObject json) throws IOException, FHIRFormatError {
    Binary res = new Binary();
    parseBinaryProperties(json, res);
    return res;
  }

  protected void parseBinaryProperties(JsonObject json, Binary res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("contentType"))
      res.setContentTypeElement(parseCode(json.get("contentType").getAsString()));
    if (json.has("_contentType"))
      parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
    if (json.has("securityContext"))
      res.setSecurityContext(parseReference(json.getAsJsonObject("securityContext")));
    if (json.has("content"))
      res.setContentElement(parseBase64Binary(json.get("content").getAsString()));
    if (json.has("_content"))
      parseElementProperties(json.getAsJsonObject("_content"), res.getContentElement());
  }

  protected BodySite parseBodySite(JsonObject json) throws IOException, FHIRFormatError {
    BodySite res = new BodySite();
    parseBodySiteProperties(json, res);
    return res;
  }

  protected void parseBodySiteProperties(JsonObject json, BodySite res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("qualifier")) {
      JsonArray array = json.getAsJsonArray("qualifier");
      for (int i = 0; i < array.size(); i++) {
        res.getQualifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("image")) {
      JsonArray array = json.getAsJsonArray("image");
      for (int i = 0; i < array.size(); i++) {
        res.getImage().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
  }

  protected Bundle parseBundle(JsonObject json) throws IOException, FHIRFormatError {
    Bundle res = new Bundle();
    parseBundleProperties(json, res);
    return res;
  }

  protected void parseBundleProperties(JsonObject json, Bundle res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("total"))
      res.setTotalElement(parseUnsignedInt(json.get("total").getAsString()));
    if (json.has("_total"))
      parseElementProperties(json.getAsJsonObject("_total"), res.getTotalElement());
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseBundleBundleLinkComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("entry")) {
      JsonArray array = json.getAsJsonArray("entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseBundleBundleEntryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("signature"))
      res.setSignature(parseSignature(json.getAsJsonObject("signature")));
  }

  protected Bundle.BundleLinkComponent parseBundleBundleLinkComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
    Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
    parseBundleBundleLinkComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBundleBundleLinkComponentProperties(JsonObject json, Bundle owner, Bundle.BundleLinkComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("relation"))
      res.setRelationElement(parseString(json.get("relation").getAsString()));
    if (json.has("_relation"))
      parseElementProperties(json.getAsJsonObject("_relation"), res.getRelationElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
  }

  protected Bundle.BundleEntryComponent parseBundleBundleEntryComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
    Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
    parseBundleBundleEntryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBundleBundleEntryComponentProperties(JsonObject json, Bundle owner, Bundle.BundleEntryComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseBundleBundleLinkComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("fullUrl"))
      res.setFullUrlElement(parseUri(json.get("fullUrl").getAsString()));
    if (json.has("_fullUrl"))
      parseElementProperties(json.getAsJsonObject("_fullUrl"), res.getFullUrlElement());
    if (json.has("resource"))
      res.setResource(parseResource(json.getAsJsonObject("resource")));
    if (json.has("search"))
      res.setSearch(parseBundleBundleEntrySearchComponent(json.getAsJsonObject("search"), owner));
    if (json.has("request"))
      res.setRequest(parseBundleBundleEntryRequestComponent(json.getAsJsonObject("request"), owner));
    if (json.has("response"))
      res.setResponse(parseBundleBundleEntryResponseComponent(json.getAsJsonObject("response"), owner));
  }

  protected Bundle.BundleEntrySearchComponent parseBundleBundleEntrySearchComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
    Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
    parseBundleBundleEntrySearchComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBundleBundleEntrySearchComponentProperties(JsonObject json, Bundle owner, Bundle.BundleEntrySearchComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("score"))
      res.setScoreElement(parseDecimal(json.get("score").getAsBigDecimal()));
    if (json.has("_score"))
      parseElementProperties(json.getAsJsonObject("_score"), res.getScoreElement());
  }

  protected Bundle.BundleEntryRequestComponent parseBundleBundleEntryRequestComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
    Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
    parseBundleBundleEntryRequestComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBundleBundleEntryRequestComponentProperties(JsonObject json, Bundle owner, Bundle.BundleEntryRequestComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("method"))
      res.setMethodElement(parseEnumeration(json.get("method").getAsString(), Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
    if (json.has("_method"))
      parseElementProperties(json.getAsJsonObject("_method"), res.getMethodElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("ifNoneMatch"))
      res.setIfNoneMatchElement(parseString(json.get("ifNoneMatch").getAsString()));
    if (json.has("_ifNoneMatch"))
      parseElementProperties(json.getAsJsonObject("_ifNoneMatch"), res.getIfNoneMatchElement());
    if (json.has("ifModifiedSince"))
      res.setIfModifiedSinceElement(parseInstant(json.get("ifModifiedSince").getAsString()));
    if (json.has("_ifModifiedSince"))
      parseElementProperties(json.getAsJsonObject("_ifModifiedSince"), res.getIfModifiedSinceElement());
    if (json.has("ifMatch"))
      res.setIfMatchElement(parseString(json.get("ifMatch").getAsString()));
    if (json.has("_ifMatch"))
      parseElementProperties(json.getAsJsonObject("_ifMatch"), res.getIfMatchElement());
    if (json.has("ifNoneExist"))
      res.setIfNoneExistElement(parseString(json.get("ifNoneExist").getAsString()));
    if (json.has("_ifNoneExist"))
      parseElementProperties(json.getAsJsonObject("_ifNoneExist"), res.getIfNoneExistElement());
  }

  protected Bundle.BundleEntryResponseComponent parseBundleBundleEntryResponseComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
    Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
    parseBundleBundleEntryResponseComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBundleBundleEntryResponseComponentProperties(JsonObject json, Bundle owner, Bundle.BundleEntryResponseComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseString(json.get("status").getAsString()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("location"))
      res.setLocationElement(parseUri(json.get("location").getAsString()));
    if (json.has("_location"))
      parseElementProperties(json.getAsJsonObject("_location"), res.getLocationElement());
    if (json.has("etag"))
      res.setEtagElement(parseString(json.get("etag").getAsString()));
    if (json.has("_etag"))
      parseElementProperties(json.getAsJsonObject("_etag"), res.getEtagElement());
    if (json.has("lastModified"))
      res.setLastModifiedElement(parseInstant(json.get("lastModified").getAsString()));
    if (json.has("_lastModified"))
      parseElementProperties(json.getAsJsonObject("_lastModified"), res.getLastModifiedElement());
    if (json.has("outcome"))
      res.setOutcome(parseResource(json.getAsJsonObject("outcome")));
  }

  protected CapabilityStatement parseCapabilityStatement(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement res = new CapabilityStatement();
    parseCapabilityStatementProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementProperties(JsonObject json, CapabilityStatement res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), CapabilityStatement.CapabilityStatementKind.NULL, new CapabilityStatement.CapabilityStatementKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("instantiates")) {
      JsonArray array = json.getAsJsonArray("instantiates");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiates().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiates")) {
      JsonArray array = json.getAsJsonArray("_instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiates().size())
          res.getInstantiates().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiates().get(i));
      }
    };
    if (json.has("software"))
      res.setSoftware(parseCapabilityStatementCapabilityStatementSoftwareComponent(json.getAsJsonObject("software"), res));
    if (json.has("implementation"))
      res.setImplementation(parseCapabilityStatementCapabilityStatementImplementationComponent(json.getAsJsonObject("implementation"), res));
    if (json.has("fhirVersion"))
      res.setFhirVersionElement(parseId(json.get("fhirVersion").getAsString()));
    if (json.has("_fhirVersion"))
      parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
    if (json.has("acceptUnknown"))
      res.setAcceptUnknownElement(parseEnumeration(json.get("acceptUnknown").getAsString(), CapabilityStatement.UnknownContentCode.NULL, new CapabilityStatement.UnknownContentCodeEnumFactory()));
    if (json.has("_acceptUnknown"))
      parseElementProperties(json.getAsJsonObject("_acceptUnknown"), res.getAcceptUnknownElement());
    if (json.has("format")) {
      JsonArray array = json.getAsJsonArray("format");
      for (int i = 0; i < array.size(); i++) {
        res.getFormat().add(parseCode(array.get(i).getAsString()));
      }
    };
    if (json.has("_format")) {
      JsonArray array = json.getAsJsonArray("_format");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFormat().size())
          res.getFormat().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getFormat().get(i));
      }
    };
    if (json.has("patchFormat")) {
      JsonArray array = json.getAsJsonArray("patchFormat");
      for (int i = 0; i < array.size(); i++) {
        res.getPatchFormat().add(parseCode(array.get(i).getAsString()));
      }
    };
    if (json.has("_patchFormat")) {
      JsonArray array = json.getAsJsonArray("_patchFormat");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPatchFormat().size())
          res.getPatchFormat().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPatchFormat().get(i));
      }
    };
    if (json.has("implementationGuide")) {
      JsonArray array = json.getAsJsonArray("implementationGuide");
      for (int i = 0; i < array.size(); i++) {
        res.getImplementationGuide().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_implementationGuide")) {
      JsonArray array = json.getAsJsonArray("_implementationGuide");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImplementationGuide().size())
          res.getImplementationGuide().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImplementationGuide().get(i));
      }
    };
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        res.getProfile().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("rest")) {
      JsonArray array = json.getAsJsonArray("rest");
      for (int i = 0; i < array.size(); i++) {
        res.getRest().add(parseCapabilityStatementCapabilityStatementRestComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("messaging")) {
      JsonArray array = json.getAsJsonArray("messaging");
      for (int i = 0; i < array.size(); i++) {
        res.getMessaging().add(parseCapabilityStatementCapabilityStatementMessagingComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("document")) {
      JsonArray array = json.getAsJsonArray("document");
      for (int i = 0; i < array.size(); i++) {
        res.getDocument().add(parseCapabilityStatementCapabilityStatementDocumentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected CapabilityStatement.CapabilityStatementSoftwareComponent parseCapabilityStatementCapabilityStatementSoftwareComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementSoftwareComponent res = new CapabilityStatement.CapabilityStatementSoftwareComponent();
    parseCapabilityStatementCapabilityStatementSoftwareComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementSoftwareComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementSoftwareComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("releaseDate"))
      res.setReleaseDateElement(parseDateTime(json.get("releaseDate").getAsString()));
    if (json.has("_releaseDate"))
      parseElementProperties(json.getAsJsonObject("_releaseDate"), res.getReleaseDateElement());
  }

  protected CapabilityStatement.CapabilityStatementImplementationComponent parseCapabilityStatementCapabilityStatementImplementationComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementImplementationComponent res = new CapabilityStatement.CapabilityStatementImplementationComponent();
    parseCapabilityStatementCapabilityStatementImplementationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementImplementationComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementImplementationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
  }

  protected CapabilityStatement.CapabilityStatementRestComponent parseCapabilityStatementCapabilityStatementRestComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestComponent res = new CapabilityStatement.CapabilityStatementRestComponent();
    parseCapabilityStatementCapabilityStatementRestComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementRestComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.RestfulCapabilityMode.NULL, new CapabilityStatement.RestfulCapabilityModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("security"))
      res.setSecurity(parseCapabilityStatementCapabilityStatementRestSecurityComponent(json.getAsJsonObject("security"), owner));
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseCapabilityStatementCapabilityStatementRestResourceComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("interaction")) {
      JsonArray array = json.getAsJsonArray("interaction");
      for (int i = 0; i < array.size(); i++) {
        res.getInteraction().add(parseCapabilityStatementSystemInteractionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("searchParam")) {
      JsonArray array = json.getAsJsonArray("searchParam");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchParam().add(parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("operation")) {
      JsonArray array = json.getAsJsonArray("operation");
      for (int i = 0; i < array.size(); i++) {
        res.getOperation().add(parseCapabilityStatementCapabilityStatementRestOperationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("compartment")) {
      JsonArray array = json.getAsJsonArray("compartment");
      for (int i = 0; i < array.size(); i++) {
        res.getCompartment().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_compartment")) {
      JsonArray array = json.getAsJsonArray("_compartment");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCompartment().size())
          res.getCompartment().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCompartment().get(i));
      }
    };
  }

  protected CapabilityStatement.CapabilityStatementRestSecurityComponent parseCapabilityStatementCapabilityStatementRestSecurityComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestSecurityComponent res = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
    parseCapabilityStatementCapabilityStatementRestSecurityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementRestSecurityComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestSecurityComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("cors"))
      res.setCorsElement(parseBoolean(json.get("cors").getAsBoolean()));
    if (json.has("_cors"))
      parseElementProperties(json.getAsJsonObject("_cors"), res.getCorsElement());
    if (json.has("service")) {
      JsonArray array = json.getAsJsonArray("service");
      for (int i = 0; i < array.size(); i++) {
        res.getService().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("certificate")) {
      JsonArray array = json.getAsJsonArray("certificate");
      for (int i = 0; i < array.size(); i++) {
        res.getCertificate().add(parseCapabilityStatementCapabilityStatementRestSecurityCertificateComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent parseCapabilityStatementCapabilityStatementRestSecurityCertificateComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent res = new CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent();
    parseCapabilityStatementCapabilityStatementRestSecurityCertificateComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementRestSecurityCertificateComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("blob"))
      res.setBlobElement(parseBase64Binary(json.get("blob").getAsString()));
    if (json.has("_blob"))
      parseElementProperties(json.getAsJsonObject("_blob"), res.getBlobElement());
  }

  protected CapabilityStatement.CapabilityStatementRestResourceComponent parseCapabilityStatementCapabilityStatementRestResourceComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceComponent res = new CapabilityStatement.CapabilityStatementRestResourceComponent();
    parseCapabilityStatementCapabilityStatementRestResourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementRestResourceComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfile(parseReference(json.getAsJsonObject("profile")));
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("interaction")) {
      JsonArray array = json.getAsJsonArray("interaction");
      for (int i = 0; i < array.size(); i++) {
        res.getInteraction().add(parseCapabilityStatementResourceInteractionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("versioning"))
      res.setVersioningElement(parseEnumeration(json.get("versioning").getAsString(), CapabilityStatement.ResourceVersionPolicy.NULL, new CapabilityStatement.ResourceVersionPolicyEnumFactory()));
    if (json.has("_versioning"))
      parseElementProperties(json.getAsJsonObject("_versioning"), res.getVersioningElement());
    if (json.has("readHistory"))
      res.setReadHistoryElement(parseBoolean(json.get("readHistory").getAsBoolean()));
    if (json.has("_readHistory"))
      parseElementProperties(json.getAsJsonObject("_readHistory"), res.getReadHistoryElement());
    if (json.has("updateCreate"))
      res.setUpdateCreateElement(parseBoolean(json.get("updateCreate").getAsBoolean()));
    if (json.has("_updateCreate"))
      parseElementProperties(json.getAsJsonObject("_updateCreate"), res.getUpdateCreateElement());
    if (json.has("conditionalCreate"))
      res.setConditionalCreateElement(parseBoolean(json.get("conditionalCreate").getAsBoolean()));
    if (json.has("_conditionalCreate"))
      parseElementProperties(json.getAsJsonObject("_conditionalCreate"), res.getConditionalCreateElement());
    if (json.has("conditionalRead"))
      res.setConditionalReadElement(parseEnumeration(json.get("conditionalRead").getAsString(), CapabilityStatement.ConditionalReadStatus.NULL, new CapabilityStatement.ConditionalReadStatusEnumFactory()));
    if (json.has("_conditionalRead"))
      parseElementProperties(json.getAsJsonObject("_conditionalRead"), res.getConditionalReadElement());
    if (json.has("conditionalUpdate"))
      res.setConditionalUpdateElement(parseBoolean(json.get("conditionalUpdate").getAsBoolean()));
    if (json.has("_conditionalUpdate"))
      parseElementProperties(json.getAsJsonObject("_conditionalUpdate"), res.getConditionalUpdateElement());
    if (json.has("conditionalDelete"))
      res.setConditionalDeleteElement(parseEnumeration(json.get("conditionalDelete").getAsString(), CapabilityStatement.ConditionalDeleteStatus.NULL, new CapabilityStatement.ConditionalDeleteStatusEnumFactory()));
    if (json.has("_conditionalDelete"))
      parseElementProperties(json.getAsJsonObject("_conditionalDelete"), res.getConditionalDeleteElement());
    if (json.has("referencePolicy")) {
      JsonArray array = json.getAsJsonArray("referencePolicy");
      for (int i = 0; i < array.size(); i++) {
        res.getReferencePolicy().add(parseEnumeration(array.get(i).getAsString(), CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
      }
    };
    if (json.has("_referencePolicy")) {
      JsonArray array = json.getAsJsonArray("_referencePolicy");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReferencePolicy().size())
          res.getReferencePolicy().add(parseEnumeration(null, CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getReferencePolicy().get(i));
      }
    };
    if (json.has("searchInclude")) {
      JsonArray array = json.getAsJsonArray("searchInclude");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchInclude().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_searchInclude")) {
      JsonArray array = json.getAsJsonArray("_searchInclude");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSearchInclude().size())
          res.getSearchInclude().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchInclude().get(i));
      }
    };
    if (json.has("searchRevInclude")) {
      JsonArray array = json.getAsJsonArray("searchRevInclude");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchRevInclude().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_searchRevInclude")) {
      JsonArray array = json.getAsJsonArray("_searchRevInclude");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSearchRevInclude().size())
          res.getSearchRevInclude().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchRevInclude().get(i));
      }
    };
    if (json.has("searchParam")) {
      JsonArray array = json.getAsJsonArray("searchParam");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchParam().add(parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected CapabilityStatement.ResourceInteractionComponent parseCapabilityStatementResourceInteractionComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.ResourceInteractionComponent res = new CapabilityStatement.ResourceInteractionComponent();
    parseCapabilityStatementResourceInteractionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementResourceInteractionComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.ResourceInteractionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CapabilityStatement.TypeRestfulInteraction.NULL, new CapabilityStatement.TypeRestfulInteractionEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
    parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseUri(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.SystemInteractionComponent parseCapabilityStatementSystemInteractionComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.SystemInteractionComponent res = new CapabilityStatement.SystemInteractionComponent();
    parseCapabilityStatementSystemInteractionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementSystemInteractionComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.SystemInteractionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CapabilityStatement.SystemRestfulInteraction.NULL, new CapabilityStatement.SystemRestfulInteractionEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.CapabilityStatementRestOperationComponent parseCapabilityStatementCapabilityStatementRestOperationComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestOperationComponent res = new CapabilityStatement.CapabilityStatementRestOperationComponent();
    parseCapabilityStatementCapabilityStatementRestOperationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementRestOperationComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("definition"))
      res.setDefinition(parseReference(json.getAsJsonObject("definition")));
  }

  protected CapabilityStatement.CapabilityStatementMessagingComponent parseCapabilityStatementCapabilityStatementMessagingComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingComponent res = new CapabilityStatement.CapabilityStatementMessagingComponent();
    parseCapabilityStatementCapabilityStatementMessagingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementMessagingComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseCapabilityStatementCapabilityStatementMessagingEndpointComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("reliableCache"))
      res.setReliableCacheElement(parseUnsignedInt(json.get("reliableCache").getAsString()));
    if (json.has("_reliableCache"))
      parseElementProperties(json.getAsJsonObject("_reliableCache"), res.getReliableCacheElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("supportedMessage")) {
      JsonArray array = json.getAsJsonArray("supportedMessage");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportedMessage().add(parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseCapabilityStatementCapabilityStatementMessagingEventComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected CapabilityStatement.CapabilityStatementMessagingEndpointComponent parseCapabilityStatementCapabilityStatementMessagingEndpointComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingEndpointComponent res = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
    parseCapabilityStatementCapabilityStatementMessagingEndpointComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementMessagingEndpointComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingEndpointComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("protocol"))
      res.setProtocol(parseCoding(json.getAsJsonObject("protocol")));
    if (json.has("address"))
      res.setAddressElement(parseUri(json.get("address").getAsString()));
    if (json.has("_address"))
      parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
  }

  protected CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
    parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("definition"))
      res.setDefinition(parseReference(json.getAsJsonObject("definition")));
  }

  protected CapabilityStatement.CapabilityStatementMessagingEventComponent parseCapabilityStatementCapabilityStatementMessagingEventComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingEventComponent res = new CapabilityStatement.CapabilityStatementMessagingEventComponent();
    parseCapabilityStatementCapabilityStatementMessagingEventComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementMessagingEventComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingEventComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCoding(json.getAsJsonObject("code")));
    if (json.has("category"))
      res.setCategoryElement(parseEnumeration(json.get("category").getAsString(), CapabilityStatement.MessageSignificanceCategory.NULL, new CapabilityStatement.MessageSignificanceCategoryEnumFactory()));
    if (json.has("_category"))
      parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("focus"))
      res.setFocusElement(parseCode(json.get("focus").getAsString()));
    if (json.has("_focus"))
      parseElementProperties(json.getAsJsonObject("_focus"), res.getFocusElement());
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("response"))
      res.setResponse(parseReference(json.getAsJsonObject("response")));
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.CapabilityStatementDocumentComponent parseCapabilityStatementCapabilityStatementDocumentComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementDocumentComponent res = new CapabilityStatement.CapabilityStatementDocumentComponent();
    parseCapabilityStatementCapabilityStatementDocumentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementDocumentComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementDocumentComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.DocumentMode.NULL, new CapabilityStatement.DocumentModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("profile"))
      res.setProfile(parseReference(json.getAsJsonObject("profile")));
  }

  protected CarePlan parseCarePlan(JsonObject json) throws IOException, FHIRFormatError {
    CarePlan res = new CarePlan();
    parseCarePlanProperties(json, res);
    return res;
  }

  protected void parseCarePlanProperties(JsonObject json, CarePlan res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        res.getDefinition().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CarePlan.CarePlanStatus.NULL, new CarePlan.CarePlanStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), CarePlan.CarePlanIntent.NULL, new CarePlan.CarePlanIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("careTeam")) {
      JsonArray array = json.getAsJsonArray("careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("addresses")) {
      JsonArray array = json.getAsJsonArray("addresses");
      for (int i = 0; i < array.size(); i++) {
        res.getAddresses().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("goal")) {
      JsonArray array = json.getAsJsonArray("goal");
      for (int i = 0; i < array.size(); i++) {
        res.getGoal().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("activity")) {
      JsonArray array = json.getAsJsonArray("activity");
      for (int i = 0; i < array.size(); i++) {
        res.getActivity().add(parseCarePlanCarePlanActivityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CarePlan.CarePlanActivityComponent parseCarePlanCarePlanActivityComponent(JsonObject json, CarePlan owner) throws IOException, FHIRFormatError {
    CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
    parseCarePlanCarePlanActivityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCarePlanCarePlanActivityComponentProperties(JsonObject json, CarePlan owner, CarePlan.CarePlanActivityComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("outcomeCodeableConcept")) {
      JsonArray array = json.getAsJsonArray("outcomeCodeableConcept");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcomeCodeableConcept().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("outcomeReference")) {
      JsonArray array = json.getAsJsonArray("outcomeReference");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcomeReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("progress")) {
      JsonArray array = json.getAsJsonArray("progress");
      for (int i = 0; i < array.size(); i++) {
        res.getProgress().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
    if (json.has("detail"))
      res.setDetail(parseCarePlanCarePlanActivityDetailComponent(json.getAsJsonObject("detail"), owner));
  }

  protected CarePlan.CarePlanActivityDetailComponent parseCarePlanCarePlanActivityDetailComponent(JsonObject json, CarePlan owner) throws IOException, FHIRFormatError {
    CarePlan.CarePlanActivityDetailComponent res = new CarePlan.CarePlanActivityDetailComponent();
    parseCarePlanCarePlanActivityDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCarePlanCarePlanActivityDetailComponentProperties(JsonObject json, CarePlan owner, CarePlan.CarePlanActivityDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("definition"))
      res.setDefinition(parseReference(json.getAsJsonObject("definition")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("goal")) {
      JsonArray array = json.getAsJsonArray("goal");
      for (int i = 0; i < array.size(); i++) {
        res.getGoal().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CarePlan.CarePlanActivityStatus.NULL, new CarePlan.CarePlanActivityStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReasonElement(parseString(json.get("statusReason").getAsString()));
    if (json.has("_statusReason"))
      parseElementProperties(json.getAsJsonObject("_statusReason"), res.getStatusReasonElement());
    if (json.has("prohibited"))
      res.setProhibitedElement(parseBoolean(json.get("prohibited").getAsBoolean()));
    if (json.has("_prohibited"))
      parseElementProperties(json.getAsJsonObject("_prohibited"), res.getProhibitedElement());
    Type scheduled = parseType("scheduled", json);
    if (scheduled != null)
      res.setScheduled(scheduled);
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type product = parseType("product", json);
    if (product != null)
      res.setProduct(product);
    if (json.has("dailyAmount"))
      res.setDailyAmount(parseSimpleQuantity(json.getAsJsonObject("dailyAmount")));
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
  }

  protected CareTeam parseCareTeam(JsonObject json) throws IOException, FHIRFormatError {
    CareTeam res = new CareTeam();
    parseCareTeamProperties(json, res);
    return res;
  }

  protected void parseCareTeamProperties(JsonObject json, CareTeam res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CareTeam.CareTeamStatus.NULL, new CareTeam.CareTeamStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseCareTeamCareTeamParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("managingOrganization")) {
      JsonArray array = json.getAsJsonArray("managingOrganization");
      for (int i = 0; i < array.size(); i++) {
        res.getManagingOrganization().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CareTeam.CareTeamParticipantComponent parseCareTeamCareTeamParticipantComponent(JsonObject json, CareTeam owner) throws IOException, FHIRFormatError {
    CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
    parseCareTeamCareTeamParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCareTeamCareTeamParticipantComponentProperties(JsonObject json, CareTeam owner, CareTeam.CareTeamParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("member"))
      res.setMember(parseReference(json.getAsJsonObject("member")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(json.getAsJsonObject("onBehalfOf")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected ChargeItem parseChargeItem(JsonObject json) throws IOException, FHIRFormatError {
    ChargeItem res = new ChargeItem();
    parseChargeItemProperties(json, res);
    return res;
  }

  protected void parseChargeItemProperties(JsonObject json, ChargeItem res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        res.getDefinition().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_definition")) {
      JsonArray array = json.getAsJsonArray("_definition");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDefinition().size())
          res.getDefinition().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDefinition().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ChargeItem.ChargeItemStatus.NULL, new ChargeItem.ChargeItemStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseChargeItemChargeItemParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("performingOrganization"))
      res.setPerformingOrganization(parseReference(json.getAsJsonObject("performingOrganization")));
    if (json.has("requestingOrganization"))
      res.setRequestingOrganization(parseReference(json.getAsJsonObject("requestingOrganization")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("bodysite")) {
      JsonArray array = json.getAsJsonArray("bodysite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodysite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("factorOverride"))
      res.setFactorOverrideElement(parseDecimal(json.get("factorOverride").getAsBigDecimal()));
    if (json.has("_factorOverride"))
      parseElementProperties(json.getAsJsonObject("_factorOverride"), res.getFactorOverrideElement());
    if (json.has("priceOverride"))
      res.setPriceOverride(parseMoney(json.getAsJsonObject("priceOverride")));
    if (json.has("overrideReason"))
      res.setOverrideReasonElement(parseString(json.get("overrideReason").getAsString()));
    if (json.has("_overrideReason"))
      parseElementProperties(json.getAsJsonObject("_overrideReason"), res.getOverrideReasonElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(json.getAsJsonObject("enterer")));
    if (json.has("enteredDate"))
      res.setEnteredDateElement(parseDateTime(json.get("enteredDate").getAsString()));
    if (json.has("_enteredDate"))
      parseElementProperties(json.getAsJsonObject("_enteredDate"), res.getEnteredDateElement());
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("service")) {
      JsonArray array = json.getAsJsonArray("service");
      for (int i = 0; i < array.size(); i++) {
        res.getService().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("account")) {
      JsonArray array = json.getAsJsonArray("account");
      for (int i = 0; i < array.size(); i++) {
        res.getAccount().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ChargeItem.ChargeItemParticipantComponent parseChargeItemChargeItemParticipantComponent(JsonObject json, ChargeItem owner) throws IOException, FHIRFormatError {
    ChargeItem.ChargeItemParticipantComponent res = new ChargeItem.ChargeItemParticipantComponent();
    parseChargeItemChargeItemParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseChargeItemChargeItemParticipantComponentProperties(JsonObject json, ChargeItem owner, ChargeItem.ChargeItemParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
  }

  protected Claim parseClaim(JsonObject json) throws IOException, FHIRFormatError {
    Claim res = new Claim();
    parseClaimProperties(json, res);
    return res;
  }

  protected void parseClaimProperties(JsonObject json, Claim res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Claim.ClaimStatus.NULL, new Claim.ClaimStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType")) {
      JsonArray array = json.getAsJsonArray("subType");
      for (int i = 0; i < array.size(); i++) {
        res.getSubType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Claim.Use.NULL, new Claim.UseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("billablePeriod"))
      res.setBillablePeriod(parsePeriod(json.getAsJsonObject("billablePeriod")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(json.getAsJsonObject("enterer")));
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("fundsReserve"))
      res.setFundsReserve(parseCodeableConcept(json.getAsJsonObject("fundsReserve")));
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseClaimRelatedClaimComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("prescription"))
      res.setPrescription(parseReference(json.getAsJsonObject("prescription")));
    if (json.has("originalPrescription"))
      res.setOriginalPrescription(parseReference(json.getAsJsonObject("originalPrescription")));
    if (json.has("payee"))
      res.setPayee(parseClaimPayeeComponent(json.getAsJsonObject("payee"), res));
    if (json.has("referral"))
      res.setReferral(parseReference(json.getAsJsonObject("referral")));
    if (json.has("facility"))
      res.setFacility(parseReference(json.getAsJsonObject("facility")));
    if (json.has("careTeam")) {
      JsonArray array = json.getAsJsonArray("careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseClaimCareTeamComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("information")) {
      JsonArray array = json.getAsJsonArray("information");
      for (int i = 0; i < array.size(); i++) {
        res.getInformation().add(parseClaimSpecialConditionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseClaimDiagnosisComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("procedure")) {
      JsonArray array = json.getAsJsonArray("procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseClaimProcedureComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseClaimInsuranceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("accident"))
      res.setAccident(parseClaimAccidentComponent(json.getAsJsonObject("accident"), res));
    if (json.has("employmentImpacted"))
      res.setEmploymentImpacted(parsePeriod(json.getAsJsonObject("employmentImpacted")));
    if (json.has("hospitalization"))
      res.setHospitalization(parsePeriod(json.getAsJsonObject("hospitalization")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseClaimItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("total"))
      res.setTotal(parseMoney(json.getAsJsonObject("total")));
  }

  protected Claim.RelatedClaimComponent parseClaimRelatedClaimComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.RelatedClaimComponent res = new Claim.RelatedClaimComponent();
    parseClaimRelatedClaimComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimRelatedClaimComponentProperties(JsonObject json, Claim owner, Claim.RelatedClaimComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("claim"))
      res.setClaim(parseReference(json.getAsJsonObject("claim")));
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(json.getAsJsonObject("relationship")));
    if (json.has("reference"))
      res.setReference(parseIdentifier(json.getAsJsonObject("reference")));
  }

  protected Claim.PayeeComponent parseClaimPayeeComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.PayeeComponent res = new Claim.PayeeComponent();
    parseClaimPayeeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimPayeeComponentProperties(JsonObject json, Claim owner, Claim.PayeeComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("resourceType"))
      res.setResourceType(parseCoding(json.getAsJsonObject("resourceType")));
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
  }

  protected Claim.CareTeamComponent parseClaimCareTeamComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.CareTeamComponent res = new Claim.CareTeamComponent();
    parseClaimCareTeamComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimCareTeamComponentProperties(JsonObject json, Claim owner, Claim.CareTeamComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("responsible"))
      res.setResponsibleElement(parseBoolean(json.get("responsible").getAsBoolean()));
    if (json.has("_responsible"))
      parseElementProperties(json.getAsJsonObject("_responsible"), res.getResponsibleElement());
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("qualification"))
      res.setQualification(parseCodeableConcept(json.getAsJsonObject("qualification")));
  }

  protected Claim.SpecialConditionComponent parseClaimSpecialConditionComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.SpecialConditionComponent res = new Claim.SpecialConditionComponent();
    parseClaimSpecialConditionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimSpecialConditionComponentProperties(JsonObject json, Claim owner, Claim.SpecialConditionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
  }

  protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
    parseClaimDiagnosisComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimDiagnosisComponentProperties(JsonObject json, Claim owner, Claim.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    Type diagnosis = parseType("diagnosis", json);
    if (diagnosis != null)
      res.setDiagnosis(diagnosis);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("packageCode"))
      res.setPackageCode(parseCodeableConcept(json.getAsJsonObject("packageCode")));
  }

  protected Claim.ProcedureComponent parseClaimProcedureComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.ProcedureComponent res = new Claim.ProcedureComponent();
    parseClaimProcedureComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimProcedureComponentProperties(JsonObject json, Claim owner, Claim.ProcedureComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    Type procedure = parseType("procedure", json);
    if (procedure != null)
      res.setProcedure(procedure);
  }

  protected Claim.InsuranceComponent parseClaimInsuranceComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.InsuranceComponent res = new Claim.InsuranceComponent();
    parseClaimInsuranceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimInsuranceComponentProperties(JsonObject json, Claim owner, Claim.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
    if (json.has("preAuthRef")) {
      JsonArray array = json.getAsJsonArray("preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        res.getPreAuthRef().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_preAuthRef")) {
      JsonArray array = json.getAsJsonArray("_preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPreAuthRef().size())
          res.getPreAuthRef().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
      }
    };
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(json.getAsJsonObject("claimResponse")));
  }

  protected Claim.AccidentComponent parseClaimAccidentComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.AccidentComponent res = new Claim.AccidentComponent();
    parseClaimAccidentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimAccidentComponentProperties(JsonObject json, Claim owner, Claim.AccidentComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    Type location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
  }

  protected Claim.ItemComponent parseClaimItemComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.ItemComponent res = new Claim.ItemComponent();
    parseClaimItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimItemComponentProperties(JsonObject json, Claim owner, Claim.ItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("careTeamLinkId")) {
      JsonArray array = json.getAsJsonArray("careTeamLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeamLinkId().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_careTeamLinkId")) {
      JsonArray array = json.getAsJsonArray("_careTeamLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCareTeamLinkId().size())
          res.getCareTeamLinkId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCareTeamLinkId().get(i));
      }
    };
    if (json.has("diagnosisLinkId")) {
      JsonArray array = json.getAsJsonArray("diagnosisLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosisLinkId().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_diagnosisLinkId")) {
      JsonArray array = json.getAsJsonArray("_diagnosisLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDiagnosisLinkId().size())
          res.getDiagnosisLinkId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDiagnosisLinkId().get(i));
      }
    };
    if (json.has("procedureLinkId")) {
      JsonArray array = json.getAsJsonArray("procedureLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedureLinkId().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_procedureLinkId")) {
      JsonArray array = json.getAsJsonArray("_procedureLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProcedureLinkId().size())
          res.getProcedureLinkId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProcedureLinkId().get(i));
      }
    };
    if (json.has("informationLinkId")) {
      JsonArray array = json.getAsJsonArray("informationLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getInformationLinkId().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_informationLinkId")) {
      JsonArray array = json.getAsJsonArray("_informationLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInformationLinkId().size())
          res.getInformationLinkId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInformationLinkId().get(i));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("service"))
      res.setService(parseCodeableConcept(json.getAsJsonObject("service")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    Type location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("subSite")) {
      JsonArray array = json.getAsJsonArray("subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("encounter")) {
      JsonArray array = json.getAsJsonArray("encounter");
      for (int i = 0; i < array.size(); i++) {
        res.getEncounter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Claim.DetailComponent parseClaimDetailComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.DetailComponent res = new Claim.DetailComponent();
    parseClaimDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimDetailComponentProperties(JsonObject json, Claim owner, Claim.DetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("service"))
      res.setService(parseCodeableConcept(json.getAsJsonObject("service")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseClaimSubDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Claim.SubDetailComponent parseClaimSubDetailComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.SubDetailComponent res = new Claim.SubDetailComponent();
    parseClaimSubDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimSubDetailComponentProperties(JsonObject json, Claim owner, Claim.SubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("service"))
      res.setService(parseCodeableConcept(json.getAsJsonObject("service")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClaimResponse parseClaimResponse(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse res = new ClaimResponse();
    parseClaimResponseProperties(json, res);
    return res;
  }

  protected void parseClaimResponseProperties(JsonObject json, ClaimResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ClaimResponse.ClaimResponseStatus.NULL, new ClaimResponse.ClaimResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("requestProvider"))
      res.setRequestProvider(parseReference(json.getAsJsonObject("requestProvider")));
    if (json.has("requestOrganization"))
      res.setRequestOrganization(parseReference(json.getAsJsonObject("requestOrganization")));
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("payeeType"))
      res.setPayeeType(parseCodeableConcept(json.getAsJsonObject("payeeType")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseClaimResponseItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("addItem")) {
      JsonArray array = json.getAsJsonArray("addItem");
      for (int i = 0; i < array.size(); i++) {
        res.getAddItem().add(parseClaimResponseAddedItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("error")) {
      JsonArray array = json.getAsJsonArray("error");
      for (int i = 0; i < array.size(); i++) {
        res.getError().add(parseClaimResponseErrorComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("totalCost"))
      res.setTotalCost(parseMoney(json.getAsJsonObject("totalCost")));
    if (json.has("unallocDeductable"))
      res.setUnallocDeductable(parseMoney(json.getAsJsonObject("unallocDeductable")));
    if (json.has("totalBenefit"))
      res.setTotalBenefit(parseMoney(json.getAsJsonObject("totalBenefit")));
    if (json.has("payment"))
      res.setPayment(parseClaimResponsePaymentComponent(json.getAsJsonObject("payment"), res));
    if (json.has("reserved"))
      res.setReserved(parseCoding(json.getAsJsonObject("reserved")));
    if (json.has("form"))
      res.setForm(parseCodeableConcept(json.getAsJsonObject("form")));
    if (json.has("processNote")) {
      JsonArray array = json.getAsJsonArray("processNote");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessNote().add(parseClaimResponseNoteComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("communicationRequest")) {
      JsonArray array = json.getAsJsonArray("communicationRequest");
      for (int i = 0; i < array.size(); i++) {
        res.getCommunicationRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseClaimResponseInsuranceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ClaimResponse.ItemComponent parseClaimResponseItemComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.ItemComponent res = new ClaimResponse.ItemComponent();
    parseClaimResponseItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseItemComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.ItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequenceLinkId"))
      res.setSequenceLinkIdElement(parsePositiveInt(json.get("sequenceLinkId").getAsString()));
    if (json.has("_sequenceLinkId"))
      parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimResponseItemDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.AdjudicationComponent parseClaimResponseAdjudicationComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.AdjudicationComponent res = new ClaimResponse.AdjudicationComponent();
    parseClaimResponseAdjudicationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseAdjudicationComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.AdjudicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
    parseClaimResponseItemDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseItemDetailComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.ItemDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequenceLinkId"))
      res.setSequenceLinkIdElement(parsePositiveInt(json.get("sequenceLinkId").getAsString()));
    if (json.has("_sequenceLinkId"))
      parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseClaimResponseSubDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
    parseClaimResponseSubDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseSubDetailComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.SubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequenceLinkId"))
      res.setSequenceLinkIdElement(parsePositiveInt(json.get("sequenceLinkId").getAsString()));
    if (json.has("_sequenceLinkId"))
      parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
    parseClaimResponseAddedItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseAddedItemComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.AddedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequenceLinkId")) {
      JsonArray array = json.getAsJsonArray("sequenceLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getSequenceLinkId().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_sequenceLinkId")) {
      JsonArray array = json.getAsJsonArray("_sequenceLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSequenceLinkId().size())
          res.getSequenceLinkId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSequenceLinkId().get(i));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("service"))
      res.setService(parseCodeableConcept(json.getAsJsonObject("service")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("fee"))
      res.setFee(parseMoney(json.getAsJsonObject("fee")));
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimResponseAddedItemsDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.AddedItemsDetailComponent parseClaimResponseAddedItemsDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemsDetailComponent res = new ClaimResponse.AddedItemsDetailComponent();
    parseClaimResponseAddedItemsDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseAddedItemsDetailComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.AddedItemsDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("service"))
      res.setService(parseCodeableConcept(json.getAsJsonObject("service")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("fee"))
      res.setFee(parseMoney(json.getAsJsonObject("fee")));
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.ErrorComponent parseClaimResponseErrorComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.ErrorComponent res = new ClaimResponse.ErrorComponent();
    parseClaimResponseErrorComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseErrorComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.ErrorComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequenceLinkId"))
      res.setSequenceLinkIdElement(parsePositiveInt(json.get("sequenceLinkId").getAsString()));
    if (json.has("_sequenceLinkId"))
      parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
    if (json.has("detailSequenceLinkId"))
      res.setDetailSequenceLinkIdElement(parsePositiveInt(json.get("detailSequenceLinkId").getAsString()));
    if (json.has("_detailSequenceLinkId"))
      parseElementProperties(json.getAsJsonObject("_detailSequenceLinkId"), res.getDetailSequenceLinkIdElement());
    if (json.has("subdetailSequenceLinkId"))
      res.setSubdetailSequenceLinkIdElement(parsePositiveInt(json.get("subdetailSequenceLinkId").getAsString()));
    if (json.has("_subdetailSequenceLinkId"))
      parseElementProperties(json.getAsJsonObject("_subdetailSequenceLinkId"), res.getSubdetailSequenceLinkIdElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
  }

  protected ClaimResponse.PaymentComponent parseClaimResponsePaymentComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.PaymentComponent res = new ClaimResponse.PaymentComponent();
    parseClaimResponsePaymentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponsePaymentComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.PaymentComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("adjustment"))
      res.setAdjustment(parseMoney(json.getAsJsonObject("adjustment")));
    if (json.has("adjustmentReason"))
      res.setAdjustmentReason(parseCodeableConcept(json.getAsJsonObject("adjustmentReason")));
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
  }

  protected ClaimResponse.NoteComponent parseClaimResponseNoteComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.NoteComponent res = new ClaimResponse.NoteComponent();
    parseClaimResponseNoteComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseNoteComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.NoteComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("number"))
      res.setNumberElement(parsePositiveInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(json.getAsJsonObject("language")));
  }

  protected ClaimResponse.InsuranceComponent parseClaimResponseInsuranceComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.InsuranceComponent res = new ClaimResponse.InsuranceComponent();
    parseClaimResponseInsuranceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseInsuranceComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
    if (json.has("preAuthRef")) {
      JsonArray array = json.getAsJsonArray("preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        res.getPreAuthRef().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_preAuthRef")) {
      JsonArray array = json.getAsJsonArray("_preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPreAuthRef().size())
          res.getPreAuthRef().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
      }
    };
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(json.getAsJsonObject("claimResponse")));
  }

  protected ClinicalImpression parseClinicalImpression(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalImpression res = new ClinicalImpression();
    parseClinicalImpressionProperties(json, res);
    return res;
  }

  protected void parseClinicalImpressionProperties(JsonObject json, ClinicalImpression res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ClinicalImpression.ClinicalImpressionStatus.NULL, new ClinicalImpression.ClinicalImpressionStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("assessor"))
      res.setAssessor(parseReference(json.getAsJsonObject("assessor")));
    if (json.has("previous"))
      res.setPrevious(parseReference(json.getAsJsonObject("previous")));
    if (json.has("problem")) {
      JsonArray array = json.getAsJsonArray("problem");
      for (int i = 0; i < array.size(); i++) {
        res.getProblem().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("investigation")) {
      JsonArray array = json.getAsJsonArray("investigation");
      for (int i = 0; i < array.size(); i++) {
        res.getInvestigation().add(parseClinicalImpressionClinicalImpressionInvestigationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("protocol")) {
      JsonArray array = json.getAsJsonArray("protocol");
      for (int i = 0; i < array.size(); i++) {
        res.getProtocol().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_protocol")) {
      JsonArray array = json.getAsJsonArray("_protocol");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProtocol().size())
          res.getProtocol().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProtocol().get(i));
      }
    };
    if (json.has("summary"))
      res.setSummaryElement(parseString(json.get("summary").getAsString()));
    if (json.has("_summary"))
      parseElementProperties(json.getAsJsonObject("_summary"), res.getSummaryElement());
    if (json.has("finding")) {
      JsonArray array = json.getAsJsonArray("finding");
      for (int i = 0; i < array.size(); i++) {
        res.getFinding().add(parseClinicalImpressionClinicalImpressionFindingComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("prognosisCodeableConcept")) {
      JsonArray array = json.getAsJsonArray("prognosisCodeableConcept");
      for (int i = 0; i < array.size(); i++) {
        res.getPrognosisCodeableConcept().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("prognosisReference")) {
      JsonArray array = json.getAsJsonArray("prognosisReference");
      for (int i = 0; i < array.size(); i++) {
        res.getPrognosisReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClinicalImpression.ClinicalImpressionInvestigationComponent parseClinicalImpressionClinicalImpressionInvestigationComponent(JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
    ClinicalImpression.ClinicalImpressionInvestigationComponent res = new ClinicalImpression.ClinicalImpressionInvestigationComponent();
    parseClinicalImpressionClinicalImpressionInvestigationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClinicalImpressionClinicalImpressionInvestigationComponentProperties(JsonObject json, ClinicalImpression owner, ClinicalImpression.ClinicalImpressionInvestigationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionClinicalImpressionFindingComponent(JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
    ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
    parseClinicalImpressionClinicalImpressionFindingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClinicalImpressionClinicalImpressionFindingComponentProperties(JsonObject json, ClinicalImpression owner, ClinicalImpression.ClinicalImpressionFindingComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    Type item = parseType("item", json);
    if (item != null)
      res.setItem(item);
    if (json.has("basis"))
      res.setBasisElement(parseString(json.get("basis").getAsString()));
    if (json.has("_basis"))
      parseElementProperties(json.getAsJsonObject("_basis"), res.getBasisElement());
  }

  protected CodeSystem parseCodeSystem(JsonObject json) throws IOException, FHIRFormatError {
    CodeSystem res = new CodeSystem();
    parseCodeSystemProperties(json, res);
    return res;
  }

  protected void parseCodeSystemProperties(JsonObject json, CodeSystem res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("caseSensitive"))
      res.setCaseSensitiveElement(parseBoolean(json.get("caseSensitive").getAsBoolean()));
    if (json.has("_caseSensitive"))
      parseElementProperties(json.getAsJsonObject("_caseSensitive"), res.getCaseSensitiveElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseUri(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(json.getAsJsonObject("_valueSet"), res.getValueSetElement());
    if (json.has("hierarchyMeaning"))
      res.setHierarchyMeaningElement(parseEnumeration(json.get("hierarchyMeaning").getAsString(), CodeSystem.CodeSystemHierarchyMeaning.NULL, new CodeSystem.CodeSystemHierarchyMeaningEnumFactory()));
    if (json.has("_hierarchyMeaning"))
      parseElementProperties(json.getAsJsonObject("_hierarchyMeaning"), res.getHierarchyMeaningElement());
    if (json.has("compositional"))
      res.setCompositionalElement(parseBoolean(json.get("compositional").getAsBoolean()));
    if (json.has("_compositional"))
      parseElementProperties(json.getAsJsonObject("_compositional"), res.getCompositionalElement());
    if (json.has("versionNeeded"))
      res.setVersionNeededElement(parseBoolean(json.get("versionNeeded").getAsBoolean()));
    if (json.has("_versionNeeded"))
      parseElementProperties(json.getAsJsonObject("_versionNeeded"), res.getVersionNeededElement());
    if (json.has("content"))
      res.setContentElement(parseEnumeration(json.get("content").getAsString(), CodeSystem.CodeSystemContentMode.NULL, new CodeSystem.CodeSystemContentModeEnumFactory()));
    if (json.has("_content"))
      parseElementProperties(json.getAsJsonObject("_content"), res.getContentElement());
    if (json.has("count"))
      res.setCountElement(parseUnsignedInt(json.get("count").getAsString()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("filter")) {
      JsonArray array = json.getAsJsonArray("filter");
      for (int i = 0; i < array.size(); i++) {
        res.getFilter().add(parseCodeSystemCodeSystemFilterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("property")) {
      JsonArray array = json.getAsJsonArray("property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseCodeSystemPropertyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("concept")) {
      JsonArray array = json.getAsJsonArray("concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseCodeSystemConceptDefinitionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected CodeSystem.CodeSystemFilterComponent parseCodeSystemCodeSystemFilterComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
    parseCodeSystemCodeSystemFilterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCodeSystemCodeSystemFilterComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.CodeSystemFilterComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("operator")) {
      JsonArray array = json.getAsJsonArray("operator");
      for (int i = 0; i < array.size(); i++) {
        res.getOperator().add(parseEnumeration(array.get(i).getAsString(), CodeSystem.FilterOperator.NULL, new CodeSystem.FilterOperatorEnumFactory()));
      }
    };
    if (json.has("_operator")) {
      JsonArray array = json.getAsJsonArray("_operator");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getOperator().size())
          res.getOperator().add(parseEnumeration(null, CodeSystem.FilterOperator.NULL, new CodeSystem.FilterOperatorEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getOperator().get(i));
      }
    };
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected CodeSystem.PropertyComponent parseCodeSystemPropertyComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.PropertyComponent res = new CodeSystem.PropertyComponent();
    parseCodeSystemPropertyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCodeSystemPropertyComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.PropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), CodeSystem.PropertyType.NULL, new CodeSystem.PropertyTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
  }

  protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
    parseCodeSystemConceptDefinitionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCodeSystemConceptDefinitionComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.ConceptDefinitionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseString(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("designation")) {
      JsonArray array = json.getAsJsonArray("designation");
      for (int i = 0; i < array.size(); i++) {
        res.getDesignation().add(parseCodeSystemConceptDefinitionDesignationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("property")) {
      JsonArray array = json.getAsJsonArray("property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseCodeSystemConceptPropertyComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("concept")) {
      JsonArray array = json.getAsJsonArray("concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseCodeSystemConceptDefinitionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
    parseCodeSystemConceptDefinitionDesignationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCodeSystemConceptDefinitionDesignationComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.ConceptDefinitionDesignationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("use"))
      res.setUse(parseCoding(json.getAsJsonObject("use")));
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected CodeSystem.ConceptPropertyComponent parseCodeSystemConceptPropertyComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.ConceptPropertyComponent res = new CodeSystem.ConceptPropertyComponent();
    parseCodeSystemConceptPropertyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCodeSystemConceptPropertyComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.ConceptPropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Communication parseCommunication(JsonObject json) throws IOException, FHIRFormatError {
    Communication res = new Communication();
    parseCommunicationProperties(json, res);
    return res;
  }

  protected void parseCommunicationProperties(JsonObject json, Communication res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        res.getDefinition().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Communication.CommunicationStatus.NULL, new Communication.CommunicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("notDone"))
      res.setNotDoneElement(parseBoolean(json.get("notDone").getAsBoolean()));
    if (json.has("_notDone"))
      parseElementProperties(json.getAsJsonObject("_notDone"), res.getNotDoneElement());
    if (json.has("notDoneReason"))
      res.setNotDoneReason(parseCodeableConcept(json.getAsJsonObject("notDoneReason")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("medium")) {
      JsonArray array = json.getAsJsonArray("medium");
      for (int i = 0; i < array.size(); i++) {
        res.getMedium().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("sent"))
      res.setSentElement(parseDateTime(json.get("sent").getAsString()));
    if (json.has("_sent"))
      parseElementProperties(json.getAsJsonObject("_sent"), res.getSentElement());
    if (json.has("received"))
      res.setReceivedElement(parseDateTime(json.get("received").getAsString()));
    if (json.has("_received"))
      parseElementProperties(json.getAsJsonObject("_received"), res.getReceivedElement());
    if (json.has("sender"))
      res.setSender(parseReference(json.getAsJsonObject("sender")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("payload")) {
      JsonArray array = json.getAsJsonArray("payload");
      for (int i = 0; i < array.size(); i++) {
        res.getPayload().add(parseCommunicationCommunicationPayloadComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Communication.CommunicationPayloadComponent parseCommunicationCommunicationPayloadComponent(JsonObject json, Communication owner) throws IOException, FHIRFormatError {
    Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
    parseCommunicationCommunicationPayloadComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCommunicationCommunicationPayloadComponentProperties(JsonObject json, Communication owner, Communication.CommunicationPayloadComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected CommunicationRequest parseCommunicationRequest(JsonObject json) throws IOException, FHIRFormatError {
    CommunicationRequest res = new CommunicationRequest();
    parseCommunicationRequestProperties(json, res);
    return res;
  }

  protected void parseCommunicationRequestProperties(JsonObject json, CommunicationRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(json.getAsJsonObject("groupIdentifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CommunicationRequest.CommunicationRequestStatus.NULL, new CommunicationRequest.CommunicationRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), CommunicationRequest.CommunicationPriority.NULL, new CommunicationRequest.CommunicationPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("medium")) {
      JsonArray array = json.getAsJsonArray("medium");
      for (int i = 0; i < array.size(); i++) {
        res.getMedium().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("payload")) {
      JsonArray array = json.getAsJsonArray("payload");
      for (int i = 0; i < array.size(); i++) {
        res.getPayload().add(parseCommunicationRequestCommunicationRequestPayloadComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
    if (json.has("sender"))
      res.setSender(parseReference(json.getAsJsonObject("sender")));
    if (json.has("requester"))
      res.setRequester(parseCommunicationRequestCommunicationRequestRequesterComponent(json.getAsJsonObject("requester"), res));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestCommunicationRequestPayloadComponent(JsonObject json, CommunicationRequest owner) throws IOException, FHIRFormatError {
    CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
    parseCommunicationRequestCommunicationRequestPayloadComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCommunicationRequestCommunicationRequestPayloadComponentProperties(JsonObject json, CommunicationRequest owner, CommunicationRequest.CommunicationRequestPayloadComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected CommunicationRequest.CommunicationRequestRequesterComponent parseCommunicationRequestCommunicationRequestRequesterComponent(JsonObject json, CommunicationRequest owner) throws IOException, FHIRFormatError {
    CommunicationRequest.CommunicationRequestRequesterComponent res = new CommunicationRequest.CommunicationRequestRequesterComponent();
    parseCommunicationRequestCommunicationRequestRequesterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCommunicationRequestCommunicationRequestRequesterComponentProperties(JsonObject json, CommunicationRequest owner, CommunicationRequest.CommunicationRequestRequesterComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("agent"))
      res.setAgent(parseReference(json.getAsJsonObject("agent")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(json.getAsJsonObject("onBehalfOf")));
  }

  protected CompartmentDefinition parseCompartmentDefinition(JsonObject json) throws IOException, FHIRFormatError {
    CompartmentDefinition res = new CompartmentDefinition();
    parseCompartmentDefinitionProperties(json, res);
    return res;
  }

  protected void parseCompartmentDefinitionProperties(JsonObject json, CompartmentDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CompartmentDefinition.CompartmentType.NULL, new CompartmentDefinition.CompartmentTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("search"))
      res.setSearchElement(parseBoolean(json.get("search").getAsBoolean()));
    if (json.has("_search"))
      parseElementProperties(json.getAsJsonObject("_search"), res.getSearchElement());
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseCompartmentDefinitionCompartmentDefinitionResourceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionCompartmentDefinitionResourceComponent(JsonObject json, CompartmentDefinition owner) throws IOException, FHIRFormatError {
    CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
    parseCompartmentDefinitionCompartmentDefinitionResourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCompartmentDefinitionCompartmentDefinitionResourceComponentProperties(JsonObject json, CompartmentDefinition owner, CompartmentDefinition.CompartmentDefinitionResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("param")) {
      JsonArray array = json.getAsJsonArray("param");
      for (int i = 0; i < array.size(); i++) {
        res.getParam().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_param")) {
      JsonArray array = json.getAsJsonArray("_param");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getParam().size())
          res.getParam().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getParam().get(i));
      }
    };
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected Composition parseComposition(JsonObject json) throws IOException, FHIRFormatError {
    Composition res = new Composition();
    parseCompositionProperties(json, res);
    return res;
  }

  protected void parseCompositionProperties(JsonObject json, Composition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Composition.CompositionStatus.NULL, new Composition.CompositionStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("class"))
      res.setClass_(parseCodeableConcept(json.getAsJsonObject("class")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("confidentiality"))
      res.setConfidentialityElement(parseEnumeration(json.get("confidentiality").getAsString(), Composition.DocumentConfidentiality.NULL, new Composition.DocumentConfidentialityEnumFactory()));
    if (json.has("_confidentiality"))
      parseElementProperties(json.getAsJsonObject("_confidentiality"), res.getConfidentialityElement());
    if (json.has("attester")) {
      JsonArray array = json.getAsJsonArray("attester");
      for (int i = 0; i < array.size(); i++) {
        res.getAttester().add(parseCompositionCompositionAttesterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("custodian"))
      res.setCustodian(parseReference(json.getAsJsonObject("custodian")));
    if (json.has("relatesTo")) {
      JsonArray array = json.getAsJsonArray("relatesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatesTo().add(parseCompositionCompositionRelatesToComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseCompositionCompositionEventComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("section")) {
      JsonArray array = json.getAsJsonArray("section");
      for (int i = 0; i < array.size(); i++) {
        res.getSection().add(parseCompositionSectionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Composition.CompositionAttesterComponent parseCompositionCompositionAttesterComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
    Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
    parseCompositionCompositionAttesterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCompositionCompositionAttesterComponentProperties(JsonObject json, Composition owner, Composition.CompositionAttesterComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("mode")) {
      JsonArray array = json.getAsJsonArray("mode");
      for (int i = 0; i < array.size(); i++) {
        res.getMode().add(parseEnumeration(array.get(i).getAsString(), Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
      }
    };
    if (json.has("_mode")) {
      JsonArray array = json.getAsJsonArray("_mode");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getMode().size())
          res.getMode().add(parseEnumeration(null, Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getMode().get(i));
      }
    };
    if (json.has("time"))
      res.setTimeElement(parseDateTime(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
  }

  protected Composition.CompositionRelatesToComponent parseCompositionCompositionRelatesToComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
    Composition.CompositionRelatesToComponent res = new Composition.CompositionRelatesToComponent();
    parseCompositionCompositionRelatesToComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCompositionCompositionRelatesToComponentProperties(JsonObject json, Composition owner, Composition.CompositionRelatesToComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), Composition.DocumentRelationshipType.NULL, new Composition.DocumentRelationshipTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    Type target = parseType("target", json);
    if (target != null)
      res.setTarget(target);
  }

  protected Composition.CompositionEventComponent parseCompositionCompositionEventComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
    Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
    parseCompositionCompositionEventComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCompositionCompositionEventComponentProperties(JsonObject json, Composition owner, Composition.CompositionEventComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Composition.SectionComponent parseCompositionSectionComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
    Composition.SectionComponent res = new Composition.SectionComponent();
    parseCompositionSectionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCompositionSectionComponentProperties(JsonObject json, Composition owner, Composition.SectionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("text"))
      res.setText(parseNarrative(json.getAsJsonObject("text")));
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Composition.SectionMode.NULL, new Composition.SectionModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("orderedBy"))
      res.setOrderedBy(parseCodeableConcept(json.getAsJsonObject("orderedBy")));
    if (json.has("entry")) {
      JsonArray array = json.getAsJsonArray("entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("emptyReason"))
      res.setEmptyReason(parseCodeableConcept(json.getAsJsonObject("emptyReason")));
    if (json.has("section")) {
      JsonArray array = json.getAsJsonArray("section");
      for (int i = 0; i < array.size(); i++) {
        res.getSection().add(parseCompositionSectionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ConceptMap parseConceptMap(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap res = new ConceptMap();
    parseConceptMapProperties(json, res);
    return res;
  }

  protected void parseConceptMapProperties(JsonObject json, ConceptMap res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    Type source = parseType("source", json);
    if (source != null)
      res.setSource(source);
    Type target = parseType("target", json);
    if (target != null)
      res.setTarget(target);
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseConceptMapConceptMapGroupComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ConceptMap.ConceptMapGroupComponent parseConceptMapConceptMapGroupComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
    ConceptMap.ConceptMapGroupComponent res = new ConceptMap.ConceptMapGroupComponent();
    parseConceptMapConceptMapGroupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConceptMapConceptMapGroupComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.ConceptMapGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("source"))
      res.setSourceElement(parseUri(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
    if (json.has("sourceVersion"))
      res.setSourceVersionElement(parseString(json.get("sourceVersion").getAsString()));
    if (json.has("_sourceVersion"))
      parseElementProperties(json.getAsJsonObject("_sourceVersion"), res.getSourceVersionElement());
    if (json.has("target"))
      res.setTargetElement(parseUri(json.get("target").getAsString()));
    if (json.has("_target"))
      parseElementProperties(json.getAsJsonObject("_target"), res.getTargetElement());
    if (json.has("targetVersion"))
      res.setTargetVersionElement(parseString(json.get("targetVersion").getAsString()));
    if (json.has("_targetVersion"))
      parseElementProperties(json.getAsJsonObject("_targetVersion"), res.getTargetVersionElement());
    if (json.has("element")) {
      JsonArray array = json.getAsJsonArray("element");
      for (int i = 0; i < array.size(); i++) {
        res.getElement().add(parseConceptMapSourceElementComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("unmapped"))
      res.setUnmapped(parseConceptMapConceptMapGroupUnmappedComponent(json.getAsJsonObject("unmapped"), owner));
  }

  protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
    ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
    parseConceptMapSourceElementComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConceptMapSourceElementComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.SourceElementComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseConceptMapTargetElementComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
    ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
    parseConceptMapTargetElementComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConceptMapTargetElementComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.TargetElementComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("equivalence"))
      res.setEquivalenceElement(parseEnumeration(json.get("equivalence").getAsString(), Enumerations.ConceptMapEquivalence.NULL, new Enumerations.ConceptMapEquivalenceEnumFactory()));
    if (json.has("_equivalence"))
      parseElementProperties(json.getAsJsonObject("_equivalence"), res.getEquivalenceElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("dependsOn")) {
      JsonArray array = json.getAsJsonArray("dependsOn");
      for (int i = 0; i < array.size(); i++) {
        res.getDependsOn().add(parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("product")) {
      JsonArray array = json.getAsJsonArray("product");
      for (int i = 0; i < array.size(); i++) {
        res.getProduct().add(parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
    ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
    parseConceptMapOtherElementComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConceptMapOtherElementComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.OtherElementComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("property"))
      res.setPropertyElement(parseUri(json.get("property").getAsString()));
    if (json.has("_property"))
      parseElementProperties(json.getAsJsonObject("_property"), res.getPropertyElement());
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("code"))
      res.setCodeElement(parseString(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
  }

  protected ConceptMap.ConceptMapGroupUnmappedComponent parseConceptMapConceptMapGroupUnmappedComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
    ConceptMap.ConceptMapGroupUnmappedComponent res = new ConceptMap.ConceptMapGroupUnmappedComponent();
    parseConceptMapConceptMapGroupUnmappedComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConceptMapConceptMapGroupUnmappedComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.ConceptMapGroupUnmappedComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), ConceptMap.ConceptMapGroupUnmappedMode.NULL, new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
  }

  protected Condition parseCondition(JsonObject json) throws IOException, FHIRFormatError {
    Condition res = new Condition();
    parseConditionProperties(json, res);
    return res;
  }

  protected void parseConditionProperties(JsonObject json, Condition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("clinicalStatus"))
      res.setClinicalStatusElement(parseEnumeration(json.get("clinicalStatus").getAsString(), Condition.ConditionClinicalStatus.NULL, new Condition.ConditionClinicalStatusEnumFactory()));
    if (json.has("_clinicalStatus"))
      parseElementProperties(json.getAsJsonObject("_clinicalStatus"), res.getClinicalStatusElement());
    if (json.has("verificationStatus"))
      res.setVerificationStatusElement(parseEnumeration(json.get("verificationStatus").getAsString(), Condition.ConditionVerificationStatus.NULL, new Condition.ConditionVerificationStatusEnumFactory()));
    if (json.has("_verificationStatus"))
      parseElementProperties(json.getAsJsonObject("_verificationStatus"), res.getVerificationStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("severity"))
      res.setSeverity(parseCodeableConcept(json.getAsJsonObject("severity")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("bodySite")) {
      JsonArray array = json.getAsJsonArray("bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    Type abatement = parseType("abatement", json);
    if (abatement != null)
      res.setAbatement(abatement);
    if (json.has("assertedDate"))
      res.setAssertedDateElement(parseDateTime(json.get("assertedDate").getAsString()));
    if (json.has("_assertedDate"))
      parseElementProperties(json.getAsJsonObject("_assertedDate"), res.getAssertedDateElement());
    if (json.has("asserter"))
      res.setAsserter(parseReference(json.getAsJsonObject("asserter")));
    if (json.has("stage"))
      res.setStage(parseConditionConditionStageComponent(json.getAsJsonObject("stage"), res));
    if (json.has("evidence")) {
      JsonArray array = json.getAsJsonArray("evidence");
      for (int i = 0; i < array.size(); i++) {
        res.getEvidence().add(parseConditionConditionEvidenceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Condition.ConditionStageComponent parseConditionConditionStageComponent(JsonObject json, Condition owner) throws IOException, FHIRFormatError {
    Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
    parseConditionConditionStageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConditionConditionStageComponentProperties(JsonObject json, Condition owner, Condition.ConditionStageComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("summary"))
      res.setSummary(parseCodeableConcept(json.getAsJsonObject("summary")));
    if (json.has("assessment")) {
      JsonArray array = json.getAsJsonArray("assessment");
      for (int i = 0; i < array.size(); i++) {
        res.getAssessment().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Condition.ConditionEvidenceComponent parseConditionConditionEvidenceComponent(JsonObject json, Condition owner) throws IOException, FHIRFormatError {
    Condition.ConditionEvidenceComponent res = new Condition.ConditionEvidenceComponent();
    parseConditionConditionEvidenceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConditionConditionEvidenceComponentProperties(JsonObject json, Condition owner, Condition.ConditionEvidenceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Consent parseConsent(JsonObject json) throws IOException, FHIRFormatError {
    Consent res = new Consent();
    parseConsentProperties(json, res);
    return res;
  }

  protected void parseConsentProperties(JsonObject json, Consent res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Consent.ConsentState.NULL, new Consent.ConsentStateEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("dateTime"))
      res.setDateTimeElement(parseDateTime(json.get("dateTime").getAsString()));
    if (json.has("_dateTime"))
      parseElementProperties(json.getAsJsonObject("_dateTime"), res.getDateTimeElement());
    if (json.has("consentingParty")) {
      JsonArray array = json.getAsJsonArray("consentingParty");
      for (int i = 0; i < array.size(); i++) {
        res.getConsentingParty().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("actor")) {
      JsonArray array = json.getAsJsonArray("actor");
      for (int i = 0; i < array.size(); i++) {
        res.getActor().add(parseConsentConsentActorComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("organization")) {
      JsonArray array = json.getAsJsonArray("organization");
      for (int i = 0; i < array.size(); i++) {
        res.getOrganization().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type source = parseType("source", json);
    if (source != null)
      res.setSource(source);
    if (json.has("policy")) {
      JsonArray array = json.getAsJsonArray("policy");
      for (int i = 0; i < array.size(); i++) {
        res.getPolicy().add(parseConsentConsentPolicyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("policyRule"))
      res.setPolicyRuleElement(parseUri(json.get("policyRule").getAsString()));
    if (json.has("_policyRule"))
      parseElementProperties(json.getAsJsonObject("_policyRule"), res.getPolicyRuleElement());
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose")) {
      JsonArray array = json.getAsJsonArray("purpose");
      for (int i = 0; i < array.size(); i++) {
        res.getPurpose().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dataPeriod"))
      res.setDataPeriod(parsePeriod(json.getAsJsonObject("dataPeriod")));
    if (json.has("data")) {
      JsonArray array = json.getAsJsonArray("data");
      for (int i = 0; i < array.size(); i++) {
        res.getData().add(parseConsentConsentDataComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("except")) {
      JsonArray array = json.getAsJsonArray("except");
      for (int i = 0; i < array.size(); i++) {
        res.getExcept().add(parseConsentExceptComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Consent.ConsentActorComponent parseConsentConsentActorComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
    Consent.ConsentActorComponent res = new Consent.ConsentActorComponent();
    parseConsentConsentActorComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConsentConsentActorComponentProperties(JsonObject json, Consent owner, Consent.ConsentActorComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
  }

  protected Consent.ConsentPolicyComponent parseConsentConsentPolicyComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
    Consent.ConsentPolicyComponent res = new Consent.ConsentPolicyComponent();
    parseConsentConsentPolicyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConsentConsentPolicyComponentProperties(JsonObject json, Consent owner, Consent.ConsentPolicyComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("authority"))
      res.setAuthorityElement(parseUri(json.get("authority").getAsString()));
    if (json.has("_authority"))
      parseElementProperties(json.getAsJsonObject("_authority"), res.getAuthorityElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
  }

  protected Consent.ConsentDataComponent parseConsentConsentDataComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
    Consent.ConsentDataComponent res = new Consent.ConsentDataComponent();
    parseConsentConsentDataComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConsentConsentDataComponentProperties(JsonObject json, Consent owner, Consent.ConsentDataComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("meaning"))
      res.setMeaningElement(parseEnumeration(json.get("meaning").getAsString(), Consent.ConsentDataMeaning.NULL, new Consent.ConsentDataMeaningEnumFactory()));
    if (json.has("_meaning"))
      parseElementProperties(json.getAsJsonObject("_meaning"), res.getMeaningElement());
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
  }

  protected Consent.ExceptComponent parseConsentExceptComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
    Consent.ExceptComponent res = new Consent.ExceptComponent();
    parseConsentExceptComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConsentExceptComponentProperties(JsonObject json, Consent owner, Consent.ExceptComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Consent.ConsentExceptType.NULL, new Consent.ConsentExceptTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("actor")) {
      JsonArray array = json.getAsJsonArray("actor");
      for (int i = 0; i < array.size(); i++) {
        res.getActor().add(parseConsentExceptActorComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose")) {
      JsonArray array = json.getAsJsonArray("purpose");
      for (int i = 0; i < array.size(); i++) {
        res.getPurpose().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("class")) {
      JsonArray array = json.getAsJsonArray("class");
      for (int i = 0; i < array.size(); i++) {
        res.getClass_().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dataPeriod"))
      res.setDataPeriod(parsePeriod(json.getAsJsonObject("dataPeriod")));
    if (json.has("data")) {
      JsonArray array = json.getAsJsonArray("data");
      for (int i = 0; i < array.size(); i++) {
        res.getData().add(parseConsentExceptDataComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Consent.ExceptActorComponent parseConsentExceptActorComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
    Consent.ExceptActorComponent res = new Consent.ExceptActorComponent();
    parseConsentExceptActorComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConsentExceptActorComponentProperties(JsonObject json, Consent owner, Consent.ExceptActorComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
  }

  protected Consent.ExceptDataComponent parseConsentExceptDataComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
    Consent.ExceptDataComponent res = new Consent.ExceptDataComponent();
    parseConsentExceptDataComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConsentExceptDataComponentProperties(JsonObject json, Consent owner, Consent.ExceptDataComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("meaning"))
      res.setMeaningElement(parseEnumeration(json.get("meaning").getAsString(), Consent.ConsentDataMeaning.NULL, new Consent.ConsentDataMeaningEnumFactory()));
    if (json.has("_meaning"))
      parseElementProperties(json.getAsJsonObject("_meaning"), res.getMeaningElement());
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
  }

  protected Contract parseContract(JsonObject json) throws IOException, FHIRFormatError {
    Contract res = new Contract();
    parseContractProperties(json, res);
    return res;
  }

  protected void parseContractProperties(JsonObject json, Contract res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Contract.ContractStatus.NULL, new Contract.ContractStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("issued"))
      res.setIssuedElement(parseDateTime(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("applies"))
      res.setApplies(parsePeriod(json.getAsJsonObject("applies")));
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("authority")) {
      JsonArray array = json.getAsJsonArray("authority");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthority().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("domain")) {
      JsonArray array = json.getAsJsonArray("domain");
      for (int i = 0; i < array.size(); i++) {
        res.getDomain().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType")) {
      JsonArray array = json.getAsJsonArray("subType");
      for (int i = 0; i < array.size(); i++) {
        res.getSubType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("actionReason")) {
      JsonArray array = json.getAsJsonArray("actionReason");
      for (int i = 0; i < array.size(); i++) {
        res.getActionReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("decisionType"))
      res.setDecisionType(parseCodeableConcept(json.getAsJsonObject("decisionType")));
    if (json.has("contentDerivative"))
      res.setContentDerivative(parseCodeableConcept(json.getAsJsonObject("contentDerivative")));
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("agent")) {
      JsonArray array = json.getAsJsonArray("agent");
      for (int i = 0; i < array.size(); i++) {
        res.getAgent().add(parseContractAgentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("signer")) {
      JsonArray array = json.getAsJsonArray("signer");
      for (int i = 0; i < array.size(); i++) {
        res.getSigner().add(parseContractSignatoryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("valuedItem")) {
      JsonArray array = json.getAsJsonArray("valuedItem");
      for (int i = 0; i < array.size(); i++) {
        res.getValuedItem().add(parseContractValuedItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("term")) {
      JsonArray array = json.getAsJsonArray("term");
      for (int i = 0; i < array.size(); i++) {
        res.getTerm().add(parseContractTermComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type binding = parseType("binding", json);
    if (binding != null)
      res.setBinding(binding);
    if (json.has("friendly")) {
      JsonArray array = json.getAsJsonArray("friendly");
      for (int i = 0; i < array.size(); i++) {
        res.getFriendly().add(parseContractFriendlyLanguageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("legal")) {
      JsonArray array = json.getAsJsonArray("legal");
      for (int i = 0; i < array.size(); i++) {
        res.getLegal().add(parseContractLegalLanguageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("rule")) {
      JsonArray array = json.getAsJsonArray("rule");
      for (int i = 0; i < array.size(); i++) {
        res.getRule().add(parseContractComputableLanguageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Contract.AgentComponent parseContractAgentComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.AgentComponent res = new Contract.AgentComponent();
    parseContractAgentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractAgentComponentProperties(JsonObject json, Contract owner, Contract.AgentComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("role")) {
      JsonArray array = json.getAsJsonArray("role");
      for (int i = 0; i < array.size(); i++) {
        res.getRole().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Contract.SignatoryComponent parseContractSignatoryComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.SignatoryComponent res = new Contract.SignatoryComponent();
    parseContractSignatoryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractSignatoryComponentProperties(JsonObject json, Contract owner, Contract.SignatoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
    if (json.has("signature")) {
      JsonArray array = json.getAsJsonArray("signature");
      for (int i = 0; i < array.size(); i++) {
        res.getSignature().add(parseSignature(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Contract.ValuedItemComponent parseContractValuedItemComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
    parseContractValuedItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractValuedItemComponentProperties(JsonObject json, Contract owner, Contract.ValuedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    Type entity = parseType("entity", json);
    if (entity != null)
      res.setEntity(entity);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("effectiveTime"))
      res.setEffectiveTimeElement(parseDateTime(json.get("effectiveTime").getAsString()));
    if (json.has("_effectiveTime"))
      parseElementProperties(json.getAsJsonObject("_effectiveTime"), res.getEffectiveTimeElement());
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("points"))
      res.setPointsElement(parseDecimal(json.get("points").getAsBigDecimal()));
    if (json.has("_points"))
      parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
  }

  protected Contract.TermComponent parseContractTermComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.TermComponent res = new Contract.TermComponent();
    parseContractTermComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractTermComponentProperties(JsonObject json, Contract owner, Contract.TermComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("issued"))
      res.setIssuedElement(parseDateTime(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("applies"))
      res.setApplies(parsePeriod(json.getAsJsonObject("applies")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(json.getAsJsonObject("subType")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("actionReason")) {
      JsonArray array = json.getAsJsonArray("actionReason");
      for (int i = 0; i < array.size(); i++) {
        res.getActionReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("agent")) {
      JsonArray array = json.getAsJsonArray("agent");
      for (int i = 0; i < array.size(); i++) {
        res.getAgent().add(parseContractTermAgentComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("valuedItem")) {
      JsonArray array = json.getAsJsonArray("valuedItem");
      for (int i = 0; i < array.size(); i++) {
        res.getValuedItem().add(parseContractTermValuedItemComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseContractTermComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Contract.TermAgentComponent parseContractTermAgentComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.TermAgentComponent res = new Contract.TermAgentComponent();
    parseContractTermAgentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractTermAgentComponentProperties(JsonObject json, Contract owner, Contract.TermAgentComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("role")) {
      JsonArray array = json.getAsJsonArray("role");
      for (int i = 0; i < array.size(); i++) {
        res.getRole().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Contract.TermValuedItemComponent parseContractTermValuedItemComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.TermValuedItemComponent res = new Contract.TermValuedItemComponent();
    parseContractTermValuedItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractTermValuedItemComponentProperties(JsonObject json, Contract owner, Contract.TermValuedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    Type entity = parseType("entity", json);
    if (entity != null)
      res.setEntity(entity);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("effectiveTime"))
      res.setEffectiveTimeElement(parseDateTime(json.get("effectiveTime").getAsString()));
    if (json.has("_effectiveTime"))
      parseElementProperties(json.getAsJsonObject("_effectiveTime"), res.getEffectiveTimeElement());
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("points"))
      res.setPointsElement(parseDecimal(json.get("points").getAsBigDecimal()));
    if (json.has("_points"))
      parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
  }

  protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
    parseContractFriendlyLanguageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractFriendlyLanguageComponentProperties(JsonObject json, Contract owner, Contract.FriendlyLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
    parseContractLegalLanguageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractLegalLanguageComponentProperties(JsonObject json, Contract owner, Contract.LegalLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
    parseContractComputableLanguageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractComputableLanguageComponentProperties(JsonObject json, Contract owner, Contract.ComputableLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected Coverage parseCoverage(JsonObject json) throws IOException, FHIRFormatError {
    Coverage res = new Coverage();
    parseCoverageProperties(json, res);
    return res;
  }

  protected void parseCoverageProperties(JsonObject json, Coverage res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Coverage.CoverageStatus.NULL, new Coverage.CoverageStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("policyHolder"))
      res.setPolicyHolder(parseReference(json.getAsJsonObject("policyHolder")));
    if (json.has("subscriber"))
      res.setSubscriber(parseReference(json.getAsJsonObject("subscriber")));
    if (json.has("subscriberId"))
      res.setSubscriberIdElement(parseString(json.get("subscriberId").getAsString()));
    if (json.has("_subscriberId"))
      parseElementProperties(json.getAsJsonObject("_subscriberId"), res.getSubscriberIdElement());
    if (json.has("beneficiary"))
      res.setBeneficiary(parseReference(json.getAsJsonObject("beneficiary")));
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(json.getAsJsonObject("relationship")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("payor")) {
      JsonArray array = json.getAsJsonArray("payor");
      for (int i = 0; i < array.size(); i++) {
        res.getPayor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("grouping"))
      res.setGrouping(parseCoverageGroupComponent(json.getAsJsonObject("grouping"), res));
    if (json.has("dependent"))
      res.setDependentElement(parseString(json.get("dependent").getAsString()));
    if (json.has("_dependent"))
      parseElementProperties(json.getAsJsonObject("_dependent"), res.getDependentElement());
    if (json.has("sequence"))
      res.setSequenceElement(parseString(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("order"))
      res.setOrderElement(parsePositiveInt(json.get("order").getAsString()));
    if (json.has("_order"))
      parseElementProperties(json.getAsJsonObject("_order"), res.getOrderElement());
    if (json.has("network"))
      res.setNetworkElement(parseString(json.get("network").getAsString()));
    if (json.has("_network"))
      parseElementProperties(json.getAsJsonObject("_network"), res.getNetworkElement());
    if (json.has("contract")) {
      JsonArray array = json.getAsJsonArray("contract");
      for (int i = 0; i < array.size(); i++) {
        res.getContract().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Coverage.GroupComponent parseCoverageGroupComponent(JsonObject json, Coverage owner) throws IOException, FHIRFormatError {
    Coverage.GroupComponent res = new Coverage.GroupComponent();
    parseCoverageGroupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageGroupComponentProperties(JsonObject json, Coverage owner, Coverage.GroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("group"))
      res.setGroupElement(parseString(json.get("group").getAsString()));
    if (json.has("_group"))
      parseElementProperties(json.getAsJsonObject("_group"), res.getGroupElement());
    if (json.has("groupDisplay"))
      res.setGroupDisplayElement(parseString(json.get("groupDisplay").getAsString()));
    if (json.has("_groupDisplay"))
      parseElementProperties(json.getAsJsonObject("_groupDisplay"), res.getGroupDisplayElement());
    if (json.has("subGroup"))
      res.setSubGroupElement(parseString(json.get("subGroup").getAsString()));
    if (json.has("_subGroup"))
      parseElementProperties(json.getAsJsonObject("_subGroup"), res.getSubGroupElement());
    if (json.has("subGroupDisplay"))
      res.setSubGroupDisplayElement(parseString(json.get("subGroupDisplay").getAsString()));
    if (json.has("_subGroupDisplay"))
      parseElementProperties(json.getAsJsonObject("_subGroupDisplay"), res.getSubGroupDisplayElement());
    if (json.has("plan"))
      res.setPlanElement(parseString(json.get("plan").getAsString()));
    if (json.has("_plan"))
      parseElementProperties(json.getAsJsonObject("_plan"), res.getPlanElement());
    if (json.has("planDisplay"))
      res.setPlanDisplayElement(parseString(json.get("planDisplay").getAsString()));
    if (json.has("_planDisplay"))
      parseElementProperties(json.getAsJsonObject("_planDisplay"), res.getPlanDisplayElement());
    if (json.has("subPlan"))
      res.setSubPlanElement(parseString(json.get("subPlan").getAsString()));
    if (json.has("_subPlan"))
      parseElementProperties(json.getAsJsonObject("_subPlan"), res.getSubPlanElement());
    if (json.has("subPlanDisplay"))
      res.setSubPlanDisplayElement(parseString(json.get("subPlanDisplay").getAsString()));
    if (json.has("_subPlanDisplay"))
      parseElementProperties(json.getAsJsonObject("_subPlanDisplay"), res.getSubPlanDisplayElement());
    if (json.has("class"))
      res.setClass_Element(parseString(json.get("class").getAsString()));
    if (json.has("_class"))
      parseElementProperties(json.getAsJsonObject("_class"), res.getClass_Element());
    if (json.has("classDisplay"))
      res.setClassDisplayElement(parseString(json.get("classDisplay").getAsString()));
    if (json.has("_classDisplay"))
      parseElementProperties(json.getAsJsonObject("_classDisplay"), res.getClassDisplayElement());
    if (json.has("subClass"))
      res.setSubClassElement(parseString(json.get("subClass").getAsString()));
    if (json.has("_subClass"))
      parseElementProperties(json.getAsJsonObject("_subClass"), res.getSubClassElement());
    if (json.has("subClassDisplay"))
      res.setSubClassDisplayElement(parseString(json.get("subClassDisplay").getAsString()));
    if (json.has("_subClassDisplay"))
      parseElementProperties(json.getAsJsonObject("_subClassDisplay"), res.getSubClassDisplayElement());
  }

  protected DataElement parseDataElement(JsonObject json) throws IOException, FHIRFormatError {
    DataElement res = new DataElement();
    parseDataElementProperties(json, res);
    return res;
  }

  protected void parseDataElementProperties(JsonObject json, DataElement res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("stringency"))
      res.setStringencyElement(parseEnumeration(json.get("stringency").getAsString(), DataElement.DataElementStringency.NULL, new DataElement.DataElementStringencyEnumFactory()));
    if (json.has("_stringency"))
      parseElementProperties(json.getAsJsonObject("_stringency"), res.getStringencyElement());
    if (json.has("mapping")) {
      JsonArray array = json.getAsJsonArray("mapping");
      for (int i = 0; i < array.size(); i++) {
        res.getMapping().add(parseDataElementDataElementMappingComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("element")) {
      JsonArray array = json.getAsJsonArray("element");
      for (int i = 0; i < array.size(); i++) {
        res.getElement().add(parseElementDefinition(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DataElement.DataElementMappingComponent parseDataElementDataElementMappingComponent(JsonObject json, DataElement owner) throws IOException, FHIRFormatError {
    DataElement.DataElementMappingComponent res = new DataElement.DataElementMappingComponent();
    parseDataElementDataElementMappingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDataElementDataElementMappingComponentProperties(JsonObject json, DataElement owner, DataElement.DataElementMappingComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identity"))
      res.setIdentityElement(parseId(json.get("identity").getAsString()));
    if (json.has("_identity"))
      parseElementProperties(json.getAsJsonObject("_identity"), res.getIdentityElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
  }

  protected DetectedIssue parseDetectedIssue(JsonObject json) throws IOException, FHIRFormatError {
    DetectedIssue res = new DetectedIssue();
    parseDetectedIssueProperties(json, res);
    return res;
  }

  protected void parseDetectedIssueProperties(JsonObject json, DetectedIssue res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DetectedIssue.DetectedIssueStatus.NULL, new DetectedIssue.DetectedIssueStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("implicated")) {
      JsonArray array = json.getAsJsonArray("implicated");
      for (int i = 0; i < array.size(); i++) {
        res.getImplicated().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail"))
      res.setDetailElement(parseString(json.get("detail").getAsString()));
    if (json.has("_detail"))
      parseElementProperties(json.getAsJsonObject("_detail"), res.getDetailElement());
    if (json.has("reference"))
      res.setReferenceElement(parseUri(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
    if (json.has("mitigation")) {
      JsonArray array = json.getAsJsonArray("mitigation");
      for (int i = 0; i < array.size(); i++) {
        res.getMitigation().add(parseDetectedIssueDetectedIssueMitigationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueDetectedIssueMitigationComponent(JsonObject json, DetectedIssue owner) throws IOException, FHIRFormatError {
    DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
    parseDetectedIssueDetectedIssueMitigationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDetectedIssueDetectedIssueMitigationComponentProperties(JsonObject json, DetectedIssue owner, DetectedIssue.DetectedIssueMitigationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("action"))
      res.setAction(parseCodeableConcept(json.getAsJsonObject("action")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
  }

  protected Device parseDevice(JsonObject json) throws IOException, FHIRFormatError {
    Device res = new Device();
    parseDeviceProperties(json, res);
    return res;
  }

  protected void parseDeviceProperties(JsonObject json, Device res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("udi"))
      res.setUdi(parseDeviceDeviceUdiComponent(json.getAsJsonObject("udi"), res));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Device.FHIRDeviceStatus.NULL, new Device.FHIRDeviceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
    if (json.has("manufacturer"))
      res.setManufacturerElement(parseString(json.get("manufacturer").getAsString()));
    if (json.has("_manufacturer"))
      parseElementProperties(json.getAsJsonObject("_manufacturer"), res.getManufacturerElement());
    if (json.has("manufactureDate"))
      res.setManufactureDateElement(parseDateTime(json.get("manufactureDate").getAsString()));
    if (json.has("_manufactureDate"))
      parseElementProperties(json.getAsJsonObject("_manufactureDate"), res.getManufactureDateElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDateTime(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
    if (json.has("model"))
      res.setModelElement(parseString(json.get("model").getAsString()));
    if (json.has("_model"))
      parseElementProperties(json.getAsJsonObject("_model"), res.getModelElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("owner"))
      res.setOwner(parseReference(json.getAsJsonObject("owner")));
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("safety")) {
      JsonArray array = json.getAsJsonArray("safety");
      for (int i = 0; i < array.size(); i++) {
        res.getSafety().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Device.DeviceUdiComponent parseDeviceDeviceUdiComponent(JsonObject json, Device owner) throws IOException, FHIRFormatError {
    Device.DeviceUdiComponent res = new Device.DeviceUdiComponent();
    parseDeviceDeviceUdiComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDeviceUdiComponentProperties(JsonObject json, Device owner, Device.DeviceUdiComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("deviceIdentifier"))
      res.setDeviceIdentifierElement(parseString(json.get("deviceIdentifier").getAsString()));
    if (json.has("_deviceIdentifier"))
      parseElementProperties(json.getAsJsonObject("_deviceIdentifier"), res.getDeviceIdentifierElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("jurisdiction"))
      res.setJurisdictionElement(parseUri(json.get("jurisdiction").getAsString()));
    if (json.has("_jurisdiction"))
      parseElementProperties(json.getAsJsonObject("_jurisdiction"), res.getJurisdictionElement());
    if (json.has("carrierHRF"))
      res.setCarrierHRFElement(parseString(json.get("carrierHRF").getAsString()));
    if (json.has("_carrierHRF"))
      parseElementProperties(json.getAsJsonObject("_carrierHRF"), res.getCarrierHRFElement());
    if (json.has("carrierAIDC"))
      res.setCarrierAIDCElement(parseBase64Binary(json.get("carrierAIDC").getAsString()));
    if (json.has("_carrierAIDC"))
      parseElementProperties(json.getAsJsonObject("_carrierAIDC"), res.getCarrierAIDCElement());
    if (json.has("issuer"))
      res.setIssuerElement(parseUri(json.get("issuer").getAsString()));
    if (json.has("_issuer"))
      parseElementProperties(json.getAsJsonObject("_issuer"), res.getIssuerElement());
    if (json.has("entryType"))
      res.setEntryTypeElement(parseEnumeration(json.get("entryType").getAsString(), Device.UDIEntryType.NULL, new Device.UDIEntryTypeEnumFactory()));
    if (json.has("_entryType"))
      parseElementProperties(json.getAsJsonObject("_entryType"), res.getEntryTypeElement());
  }

  protected DeviceComponent parseDeviceComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceComponent res = new DeviceComponent();
    parseDeviceComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceComponentProperties(JsonObject json, DeviceComponent res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("lastSystemChange"))
      res.setLastSystemChangeElement(parseInstant(json.get("lastSystemChange").getAsString()));
    if (json.has("_lastSystemChange"))
      parseElementProperties(json.getAsJsonObject("_lastSystemChange"), res.getLastSystemChangeElement());
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("parent"))
      res.setParent(parseReference(json.getAsJsonObject("parent")));
    if (json.has("operationalStatus")) {
      JsonArray array = json.getAsJsonArray("operationalStatus");
      for (int i = 0; i < array.size(); i++) {
        res.getOperationalStatus().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("parameterGroup"))
      res.setParameterGroup(parseCodeableConcept(json.getAsJsonObject("parameterGroup")));
    if (json.has("measurementPrinciple"))
      res.setMeasurementPrincipleElement(parseEnumeration(json.get("measurementPrinciple").getAsString(), DeviceComponent.MeasmntPrinciple.NULL, new DeviceComponent.MeasmntPrincipleEnumFactory()));
    if (json.has("_measurementPrinciple"))
      parseElementProperties(json.getAsJsonObject("_measurementPrinciple"), res.getMeasurementPrincipleElement());
    if (json.has("productionSpecification")) {
      JsonArray array = json.getAsJsonArray("productionSpecification");
      for (int i = 0; i < array.size(); i++) {
        res.getProductionSpecification().add(parseDeviceComponentDeviceComponentProductionSpecificationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("languageCode"))
      res.setLanguageCode(parseCodeableConcept(json.getAsJsonObject("languageCode")));
  }

  protected DeviceComponent.DeviceComponentProductionSpecificationComponent parseDeviceComponentDeviceComponentProductionSpecificationComponent(JsonObject json, DeviceComponent owner) throws IOException, FHIRFormatError {
    DeviceComponent.DeviceComponentProductionSpecificationComponent res = new DeviceComponent.DeviceComponentProductionSpecificationComponent();
    parseDeviceComponentDeviceComponentProductionSpecificationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceComponentDeviceComponentProductionSpecificationComponentProperties(JsonObject json, DeviceComponent owner, DeviceComponent.DeviceComponentProductionSpecificationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("specType"))
      res.setSpecType(parseCodeableConcept(json.getAsJsonObject("specType")));
    if (json.has("componentId"))
      res.setComponentId(parseIdentifier(json.getAsJsonObject("componentId")));
    if (json.has("productionSpec"))
      res.setProductionSpecElement(parseString(json.get("productionSpec").getAsString()));
    if (json.has("_productionSpec"))
      parseElementProperties(json.getAsJsonObject("_productionSpec"), res.getProductionSpecElement());
  }

  protected DeviceMetric parseDeviceMetric(JsonObject json) throws IOException, FHIRFormatError {
    DeviceMetric res = new DeviceMetric();
    parseDeviceMetricProperties(json, res);
    return res;
  }

  protected void parseDeviceMetricProperties(JsonObject json, DeviceMetric res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(json.getAsJsonObject("unit")));
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("parent"))
      res.setParent(parseReference(json.getAsJsonObject("parent")));
    if (json.has("operationalStatus"))
      res.setOperationalStatusElement(parseEnumeration(json.get("operationalStatus").getAsString(), DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
    if (json.has("_operationalStatus"))
      parseElementProperties(json.getAsJsonObject("_operationalStatus"), res.getOperationalStatusElement());
    if (json.has("color"))
      res.setColorElement(parseEnumeration(json.get("color").getAsString(), DeviceMetric.DeviceMetricColor.NULL, new DeviceMetric.DeviceMetricColorEnumFactory()));
    if (json.has("_color"))
      parseElementProperties(json.getAsJsonObject("_color"), res.getColorElement());
    if (json.has("category"))
      res.setCategoryElement(parseEnumeration(json.get("category").getAsString(), DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
    if (json.has("_category"))
      parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
    if (json.has("measurementPeriod"))
      res.setMeasurementPeriod(parseTiming(json.getAsJsonObject("measurementPeriod")));
    if (json.has("calibration")) {
      JsonArray array = json.getAsJsonArray("calibration");
      for (int i = 0; i < array.size(); i++) {
        res.getCalibration().add(parseDeviceMetricDeviceMetricCalibrationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricDeviceMetricCalibrationComponent(JsonObject json, DeviceMetric owner) throws IOException, FHIRFormatError {
    DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
    parseDeviceMetricDeviceMetricCalibrationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceMetricDeviceMetricCalibrationComponentProperties(JsonObject json, DeviceMetric owner, DeviceMetric.DeviceMetricCalibrationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("state"))
      res.setStateElement(parseEnumeration(json.get("state").getAsString(), DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
    if (json.has("_state"))
      parseElementProperties(json.getAsJsonObject("_state"), res.getStateElement());
    if (json.has("time"))
      res.setTimeElement(parseInstant(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
  }

  protected DeviceRequest parseDeviceRequest(JsonObject json) throws IOException, FHIRFormatError {
    DeviceRequest res = new DeviceRequest();
    parseDeviceRequestProperties(json, res);
    return res;
  }

  protected void parseDeviceRequestProperties(JsonObject json, DeviceRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        res.getDefinition().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priorRequest")) {
      JsonArray array = json.getAsJsonArray("priorRequest");
      for (int i = 0; i < array.size(); i++) {
        res.getPriorRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(json.getAsJsonObject("groupIdentifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DeviceRequest.DeviceRequestStatus.NULL, new DeviceRequest.DeviceRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntent(parseCodeableConcept(json.getAsJsonObject("intent")));
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), DeviceRequest.RequestPriority.NULL, new DeviceRequest.RequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    Type code = parseType("code", json);
    if (code != null)
      res.setCode(code);
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
    if (json.has("requester"))
      res.setRequester(parseDeviceRequestDeviceRequestRequesterComponent(json.getAsJsonObject("requester"), res));
    if (json.has("performerType"))
      res.setPerformerType(parseCodeableConcept(json.getAsJsonObject("performerType")));
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relevantHistory")) {
      JsonArray array = json.getAsJsonArray("relevantHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getRelevantHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DeviceRequest.DeviceRequestRequesterComponent parseDeviceRequestDeviceRequestRequesterComponent(JsonObject json, DeviceRequest owner) throws IOException, FHIRFormatError {
    DeviceRequest.DeviceRequestRequesterComponent res = new DeviceRequest.DeviceRequestRequesterComponent();
    parseDeviceRequestDeviceRequestRequesterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceRequestDeviceRequestRequesterComponentProperties(JsonObject json, DeviceRequest owner, DeviceRequest.DeviceRequestRequesterComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("agent"))
      res.setAgent(parseReference(json.getAsJsonObject("agent")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(json.getAsJsonObject("onBehalfOf")));
  }

  protected DeviceUseStatement parseDeviceUseStatement(JsonObject json) throws IOException, FHIRFormatError {
    DeviceUseStatement res = new DeviceUseStatement();
    parseDeviceUseStatementProperties(json, res);
    return res;
  }

  protected void parseDeviceUseStatementProperties(JsonObject json, DeviceUseStatement res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DeviceUseStatement.DeviceUseStatementStatus.NULL, new DeviceUseStatement.DeviceUseStatementStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("whenUsed"))
      res.setWhenUsed(parsePeriod(json.getAsJsonObject("whenUsed")));
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("recordedOn"))
      res.setRecordedOnElement(parseDateTime(json.get("recordedOn").getAsString()));
    if (json.has("_recordedOn"))
      parseElementProperties(json.getAsJsonObject("_recordedOn"), res.getRecordedOnElement());
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("device"))
      res.setDevice(parseReference(json.getAsJsonObject("device")));
    if (json.has("indication")) {
      JsonArray array = json.getAsJsonArray("indication");
      for (int i = 0; i < array.size(); i++) {
        res.getIndication().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DiagnosticReport parseDiagnosticReport(JsonObject json) throws IOException, FHIRFormatError {
    DiagnosticReport res = new DiagnosticReport();
    parseDiagnosticReportProperties(json, res);
    return res;
  }

  protected void parseDiagnosticReportProperties(JsonObject json, DiagnosticReport res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("issued"))
      res.setIssuedElement(parseInstant(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseDiagnosticReportDiagnosticReportPerformerComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("specimen")) {
      JsonArray array = json.getAsJsonArray("specimen");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimen().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("result")) {
      JsonArray array = json.getAsJsonArray("result");
      for (int i = 0; i < array.size(); i++) {
        res.getResult().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("imagingStudy")) {
      JsonArray array = json.getAsJsonArray("imagingStudy");
      for (int i = 0; i < array.size(); i++) {
        res.getImagingStudy().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("image")) {
      JsonArray array = json.getAsJsonArray("image");
      for (int i = 0; i < array.size(); i++) {
        res.getImage().add(parseDiagnosticReportDiagnosticReportImageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("conclusion"))
      res.setConclusionElement(parseString(json.get("conclusion").getAsString()));
    if (json.has("_conclusion"))
      parseElementProperties(json.getAsJsonObject("_conclusion"), res.getConclusionElement());
    if (json.has("codedDiagnosis")) {
      JsonArray array = json.getAsJsonArray("codedDiagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getCodedDiagnosis().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("presentedForm")) {
      JsonArray array = json.getAsJsonArray("presentedForm");
      for (int i = 0; i < array.size(); i++) {
        res.getPresentedForm().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DiagnosticReport.DiagnosticReportPerformerComponent parseDiagnosticReportDiagnosticReportPerformerComponent(JsonObject json, DiagnosticReport owner) throws IOException, FHIRFormatError {
    DiagnosticReport.DiagnosticReportPerformerComponent res = new DiagnosticReport.DiagnosticReportPerformerComponent();
    parseDiagnosticReportDiagnosticReportPerformerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDiagnosticReportDiagnosticReportPerformerComponentProperties(JsonObject json, DiagnosticReport owner, DiagnosticReport.DiagnosticReportPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
  }

  protected DiagnosticReport.DiagnosticReportImageComponent parseDiagnosticReportDiagnosticReportImageComponent(JsonObject json, DiagnosticReport owner) throws IOException, FHIRFormatError {
    DiagnosticReport.DiagnosticReportImageComponent res = new DiagnosticReport.DiagnosticReportImageComponent();
    parseDiagnosticReportDiagnosticReportImageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDiagnosticReportDiagnosticReportImageComponentProperties(JsonObject json, DiagnosticReport owner, DiagnosticReport.DiagnosticReportImageComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("link"))
      res.setLink(parseReference(json.getAsJsonObject("link")));
  }

  protected DocumentManifest parseDocumentManifest(JsonObject json) throws IOException, FHIRFormatError {
    DocumentManifest res = new DocumentManifest();
    parseDocumentManifestProperties(json, res);
    return res;
  }

  protected void parseDocumentManifestProperties(JsonObject json, DocumentManifest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("masterIdentifier"))
      res.setMasterIdentifier(parseIdentifier(json.getAsJsonObject("masterIdentifier")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("source"))
      res.setSourceElement(parseUri(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseDocumentManifestDocumentManifestContentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseDocumentManifestDocumentManifestRelatedComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected DocumentManifest.DocumentManifestContentComponent parseDocumentManifestDocumentManifestContentComponent(JsonObject json, DocumentManifest owner) throws IOException, FHIRFormatError {
    DocumentManifest.DocumentManifestContentComponent res = new DocumentManifest.DocumentManifestContentComponent();
    parseDocumentManifestDocumentManifestContentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDocumentManifestDocumentManifestContentComponentProperties(JsonObject json, DocumentManifest owner, DocumentManifest.DocumentManifestContentComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    Type p = parseType("p", json);
    if (p != null)
      res.setP(p);
  }

  protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestDocumentManifestRelatedComponent(JsonObject json, DocumentManifest owner) throws IOException, FHIRFormatError {
    DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
    parseDocumentManifestDocumentManifestRelatedComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDocumentManifestDocumentManifestRelatedComponentProperties(JsonObject json, DocumentManifest owner, DocumentManifest.DocumentManifestRelatedComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("ref"))
      res.setRef(parseReference(json.getAsJsonObject("ref")));
  }

  protected DocumentReference parseDocumentReference(JsonObject json) throws IOException, FHIRFormatError {
    DocumentReference res = new DocumentReference();
    parseDocumentReferenceProperties(json, res);
    return res;
  }

  protected void parseDocumentReferenceProperties(JsonObject json, DocumentReference res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("masterIdentifier"))
      res.setMasterIdentifier(parseIdentifier(json.getAsJsonObject("masterIdentifier")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("docStatus"))
      res.setDocStatusElement(parseEnumeration(json.get("docStatus").getAsString(), DocumentReference.ReferredDocumentStatus.NULL, new DocumentReference.ReferredDocumentStatusEnumFactory()));
    if (json.has("_docStatus"))
      parseElementProperties(json.getAsJsonObject("_docStatus"), res.getDocStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("class"))
      res.setClass_(parseCodeableConcept(json.getAsJsonObject("class")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("indexed"))
      res.setIndexedElement(parseInstant(json.get("indexed").getAsString()));
    if (json.has("_indexed"))
      parseElementProperties(json.getAsJsonObject("_indexed"), res.getIndexedElement());
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("authenticator"))
      res.setAuthenticator(parseReference(json.getAsJsonObject("authenticator")));
    if (json.has("custodian"))
      res.setCustodian(parseReference(json.getAsJsonObject("custodian")));
    if (json.has("relatesTo")) {
      JsonArray array = json.getAsJsonArray("relatesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatesTo().add(parseDocumentReferenceDocumentReferenceRelatesToComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseDocumentReferenceDocumentReferenceContentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("context"))
      res.setContext(parseDocumentReferenceDocumentReferenceContextComponent(json.getAsJsonObject("context"), res));
  }

  protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceDocumentReferenceRelatesToComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
    parseDocumentReferenceDocumentReferenceRelatesToComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDocumentReferenceDocumentReferenceRelatesToComponentProperties(JsonObject json, DocumentReference owner, DocumentReference.DocumentReferenceRelatesToComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), DocumentReference.DocumentRelationshipType.NULL, new DocumentReference.DocumentRelationshipTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
  }

  protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceDocumentReferenceContentComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
    parseDocumentReferenceDocumentReferenceContentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDocumentReferenceDocumentReferenceContentComponentProperties(JsonObject json, DocumentReference owner, DocumentReference.DocumentReferenceContentComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("attachment"))
      res.setAttachment(parseAttachment(json.getAsJsonObject("attachment")));
    if (json.has("format"))
      res.setFormat(parseCoding(json.getAsJsonObject("format")));
  }

  protected DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceDocumentReferenceContextComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContextComponent res = new DocumentReference.DocumentReferenceContextComponent();
    parseDocumentReferenceDocumentReferenceContextComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDocumentReferenceDocumentReferenceContextComponentProperties(JsonObject json, DocumentReference owner, DocumentReference.DocumentReferenceContextComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("facilityType"))
      res.setFacilityType(parseCodeableConcept(json.getAsJsonObject("facilityType")));
    if (json.has("practiceSetting"))
      res.setPracticeSetting(parseCodeableConcept(json.getAsJsonObject("practiceSetting")));
    if (json.has("sourcePatientInfo"))
      res.setSourcePatientInfo(parseReference(json.getAsJsonObject("sourcePatientInfo")));
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseDocumentReferenceDocumentReferenceContextRelatedComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected DocumentReference.DocumentReferenceContextRelatedComponent parseDocumentReferenceDocumentReferenceContextRelatedComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContextRelatedComponent res = new DocumentReference.DocumentReferenceContextRelatedComponent();
    parseDocumentReferenceDocumentReferenceContextRelatedComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDocumentReferenceDocumentReferenceContextRelatedComponentProperties(JsonObject json, DocumentReference owner, DocumentReference.DocumentReferenceContextRelatedComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("ref"))
      res.setRef(parseReference(json.getAsJsonObject("ref")));
  }

  protected EligibilityRequest parseEligibilityRequest(JsonObject json) throws IOException, FHIRFormatError {
    EligibilityRequest res = new EligibilityRequest();
    parseEligibilityRequestProperties(json, res);
    return res;
  }

  protected void parseEligibilityRequestProperties(JsonObject json, EligibilityRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EligibilityRequest.EligibilityRequestStatus.NULL, new EligibilityRequest.EligibilityRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(json.getAsJsonObject("enterer")));
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("facility"))
      res.setFacility(parseReference(json.getAsJsonObject("facility")));
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
    if (json.has("benefitCategory"))
      res.setBenefitCategory(parseCodeableConcept(json.getAsJsonObject("benefitCategory")));
    if (json.has("benefitSubCategory"))
      res.setBenefitSubCategory(parseCodeableConcept(json.getAsJsonObject("benefitSubCategory")));
  }

  protected EligibilityResponse parseEligibilityResponse(JsonObject json) throws IOException, FHIRFormatError {
    EligibilityResponse res = new EligibilityResponse();
    parseEligibilityResponseProperties(json, res);
    return res;
  }

  protected void parseEligibilityResponseProperties(JsonObject json, EligibilityResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EligibilityResponse.EligibilityResponseStatus.NULL, new EligibilityResponse.EligibilityResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("requestProvider"))
      res.setRequestProvider(parseReference(json.getAsJsonObject("requestProvider")));
    if (json.has("requestOrganization"))
      res.setRequestOrganization(parseReference(json.getAsJsonObject("requestOrganization")));
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("inforce"))
      res.setInforceElement(parseBoolean(json.get("inforce").getAsBoolean()));
    if (json.has("_inforce"))
      parseElementProperties(json.getAsJsonObject("_inforce"), res.getInforceElement());
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseEligibilityResponseInsuranceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("form"))
      res.setForm(parseCodeableConcept(json.getAsJsonObject("form")));
    if (json.has("error")) {
      JsonArray array = json.getAsJsonArray("error");
      for (int i = 0; i < array.size(); i++) {
        res.getError().add(parseEligibilityResponseErrorsComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected EligibilityResponse.InsuranceComponent parseEligibilityResponseInsuranceComponent(JsonObject json, EligibilityResponse owner) throws IOException, FHIRFormatError {
    EligibilityResponse.InsuranceComponent res = new EligibilityResponse.InsuranceComponent();
    parseEligibilityResponseInsuranceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEligibilityResponseInsuranceComponentProperties(JsonObject json, EligibilityResponse owner, EligibilityResponse.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("contract"))
      res.setContract(parseReference(json.getAsJsonObject("contract")));
    if (json.has("benefitBalance")) {
      JsonArray array = json.getAsJsonArray("benefitBalance");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefitBalance().add(parseEligibilityResponseBenefitsComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected EligibilityResponse.BenefitsComponent parseEligibilityResponseBenefitsComponent(JsonObject json, EligibilityResponse owner) throws IOException, FHIRFormatError {
    EligibilityResponse.BenefitsComponent res = new EligibilityResponse.BenefitsComponent();
    parseEligibilityResponseBenefitsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEligibilityResponseBenefitsComponentProperties(JsonObject json, EligibilityResponse owner, EligibilityResponse.BenefitsComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("subCategory"))
      res.setSubCategory(parseCodeableConcept(json.getAsJsonObject("subCategory")));
    if (json.has("excluded"))
      res.setExcludedElement(parseBoolean(json.get("excluded").getAsBoolean()));
    if (json.has("_excluded"))
      parseElementProperties(json.getAsJsonObject("_excluded"), res.getExcludedElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("network"))
      res.setNetwork(parseCodeableConcept(json.getAsJsonObject("network")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(json.getAsJsonObject("unit")));
    if (json.has("term"))
      res.setTerm(parseCodeableConcept(json.getAsJsonObject("term")));
    if (json.has("financial")) {
      JsonArray array = json.getAsJsonArray("financial");
      for (int i = 0; i < array.size(); i++) {
        res.getFinancial().add(parseEligibilityResponseBenefitComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected EligibilityResponse.BenefitComponent parseEligibilityResponseBenefitComponent(JsonObject json, EligibilityResponse owner) throws IOException, FHIRFormatError {
    EligibilityResponse.BenefitComponent res = new EligibilityResponse.BenefitComponent();
    parseEligibilityResponseBenefitComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEligibilityResponseBenefitComponentProperties(JsonObject json, EligibilityResponse owner, EligibilityResponse.BenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    Type allowed = parseType("allowed", json);
    if (allowed != null)
      res.setAllowed(allowed);
    Type used = parseType("used", json);
    if (used != null)
      res.setUsed(used);
  }

  protected EligibilityResponse.ErrorsComponent parseEligibilityResponseErrorsComponent(JsonObject json, EligibilityResponse owner) throws IOException, FHIRFormatError {
    EligibilityResponse.ErrorsComponent res = new EligibilityResponse.ErrorsComponent();
    parseEligibilityResponseErrorsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEligibilityResponseErrorsComponentProperties(JsonObject json, EligibilityResponse owner, EligibilityResponse.ErrorsComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
  }

  protected Encounter parseEncounter(JsonObject json) throws IOException, FHIRFormatError {
    Encounter res = new Encounter();
    parseEncounterProperties(json, res);
    return res;
  }

  protected void parseEncounterProperties(JsonObject json, Encounter res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusHistory")) {
      JsonArray array = json.getAsJsonArray("statusHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusHistory().add(parseEncounterStatusHistoryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("class"))
      res.setClass_(parseCoding(json.getAsJsonObject("class")));
    if (json.has("classHistory")) {
      JsonArray array = json.getAsJsonArray("classHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getClassHistory().add(parseEncounterClassHistoryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("episodeOfCare")) {
      JsonArray array = json.getAsJsonArray("episodeOfCare");
      for (int i = 0; i < array.size(); i++) {
        res.getEpisodeOfCare().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("incomingReferral")) {
      JsonArray array = json.getAsJsonArray("incomingReferral");
      for (int i = 0; i < array.size(); i++) {
        res.getIncomingReferral().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseEncounterEncounterParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("appointment"))
      res.setAppointment(parseReference(json.getAsJsonObject("appointment")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("length"))
      res.setLength(parseDuration(json.getAsJsonObject("length")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseEncounterDiagnosisComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("account")) {
      JsonArray array = json.getAsJsonArray("account");
      for (int i = 0; i < array.size(); i++) {
        res.getAccount().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("hospitalization"))
      res.setHospitalization(parseEncounterEncounterHospitalizationComponent(json.getAsJsonObject("hospitalization"), res));
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseEncounterEncounterLocationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("serviceProvider"))
      res.setServiceProvider(parseReference(json.getAsJsonObject("serviceProvider")));
    if (json.has("partOf"))
      res.setPartOf(parseReference(json.getAsJsonObject("partOf")));
  }

  protected Encounter.StatusHistoryComponent parseEncounterStatusHistoryComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.StatusHistoryComponent res = new Encounter.StatusHistoryComponent();
    parseEncounterStatusHistoryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterStatusHistoryComponentProperties(JsonObject json, Encounter owner, Encounter.StatusHistoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Encounter.ClassHistoryComponent parseEncounterClassHistoryComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.ClassHistoryComponent res = new Encounter.ClassHistoryComponent();
    parseEncounterClassHistoryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterClassHistoryComponentProperties(JsonObject json, Encounter owner, Encounter.ClassHistoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("class"))
      res.setClass_(parseCoding(json.getAsJsonObject("class")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Encounter.EncounterParticipantComponent parseEncounterEncounterParticipantComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
    parseEncounterEncounterParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterEncounterParticipantComponentProperties(JsonObject json, Encounter owner, Encounter.EncounterParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("individual"))
      res.setIndividual(parseReference(json.getAsJsonObject("individual")));
  }

  protected Encounter.DiagnosisComponent parseEncounterDiagnosisComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.DiagnosisComponent res = new Encounter.DiagnosisComponent();
    parseEncounterDiagnosisComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterDiagnosisComponentProperties(JsonObject json, Encounter owner, Encounter.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("condition"))
      res.setCondition(parseReference(json.getAsJsonObject("condition")));
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("rank"))
      res.setRankElement(parsePositiveInt(json.get("rank").getAsString()));
    if (json.has("_rank"))
      parseElementProperties(json.getAsJsonObject("_rank"), res.getRankElement());
  }

  protected Encounter.EncounterHospitalizationComponent parseEncounterEncounterHospitalizationComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.EncounterHospitalizationComponent res = new Encounter.EncounterHospitalizationComponent();
    parseEncounterEncounterHospitalizationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterEncounterHospitalizationComponentProperties(JsonObject json, Encounter owner, Encounter.EncounterHospitalizationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("preAdmissionIdentifier"))
      res.setPreAdmissionIdentifier(parseIdentifier(json.getAsJsonObject("preAdmissionIdentifier")));
    if (json.has("origin"))
      res.setOrigin(parseReference(json.getAsJsonObject("origin")));
    if (json.has("admitSource"))
      res.setAdmitSource(parseCodeableConcept(json.getAsJsonObject("admitSource")));
    if (json.has("reAdmission"))
      res.setReAdmission(parseCodeableConcept(json.getAsJsonObject("reAdmission")));
    if (json.has("dietPreference")) {
      JsonArray array = json.getAsJsonArray("dietPreference");
      for (int i = 0; i < array.size(); i++) {
        res.getDietPreference().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialCourtesy")) {
      JsonArray array = json.getAsJsonArray("specialCourtesy");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialCourtesy().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialArrangement")) {
      JsonArray array = json.getAsJsonArray("specialArrangement");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialArrangement().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("destination"))
      res.setDestination(parseReference(json.getAsJsonObject("destination")));
    if (json.has("dischargeDisposition"))
      res.setDischargeDisposition(parseCodeableConcept(json.getAsJsonObject("dischargeDisposition")));
  }

  protected Encounter.EncounterLocationComponent parseEncounterEncounterLocationComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
    parseEncounterEncounterLocationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterEncounterLocationComponentProperties(JsonObject json, Encounter owner, Encounter.EncounterLocationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Endpoint parseEndpoint(JsonObject json) throws IOException, FHIRFormatError {
    Endpoint res = new Endpoint();
    parseEndpointProperties(json, res);
    return res;
  }

  protected void parseEndpointProperties(JsonObject json, Endpoint res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Endpoint.EndpointStatus.NULL, new Endpoint.EndpointStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("connectionType"))
      res.setConnectionType(parseCoding(json.getAsJsonObject("connectionType")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("payloadType")) {
      JsonArray array = json.getAsJsonArray("payloadType");
      for (int i = 0; i < array.size(); i++) {
        res.getPayloadType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("payloadMimeType")) {
      JsonArray array = json.getAsJsonArray("payloadMimeType");
      for (int i = 0; i < array.size(); i++) {
        res.getPayloadMimeType().add(parseCode(array.get(i).getAsString()));
      }
    };
    if (json.has("_payloadMimeType")) {
      JsonArray array = json.getAsJsonArray("_payloadMimeType");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPayloadMimeType().size())
          res.getPayloadMimeType().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPayloadMimeType().get(i));
      }
    };
    if (json.has("address"))
      res.setAddressElement(parseUri(json.get("address").getAsString()));
    if (json.has("_address"))
      parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
    if (json.has("header")) {
      JsonArray array = json.getAsJsonArray("header");
      for (int i = 0; i < array.size(); i++) {
        res.getHeader().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_header")) {
      JsonArray array = json.getAsJsonArray("_header");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getHeader().size())
          res.getHeader().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getHeader().get(i));
      }
    };
  }

  protected EnrollmentRequest parseEnrollmentRequest(JsonObject json) throws IOException, FHIRFormatError {
    EnrollmentRequest res = new EnrollmentRequest();
    parseEnrollmentRequestProperties(json, res);
    return res;
  }

  protected void parseEnrollmentRequestProperties(JsonObject json, EnrollmentRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EnrollmentRequest.EnrollmentRequestStatus.NULL, new EnrollmentRequest.EnrollmentRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
  }

  protected EnrollmentResponse parseEnrollmentResponse(JsonObject json) throws IOException, FHIRFormatError {
    EnrollmentResponse res = new EnrollmentResponse();
    parseEnrollmentResponseProperties(json, res);
    return res;
  }

  protected void parseEnrollmentResponseProperties(JsonObject json, EnrollmentResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EnrollmentResponse.EnrollmentResponseStatus.NULL, new EnrollmentResponse.EnrollmentResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("requestProvider"))
      res.setRequestProvider(parseReference(json.getAsJsonObject("requestProvider")));
    if (json.has("requestOrganization"))
      res.setRequestOrganization(parseReference(json.getAsJsonObject("requestOrganization")));
  }

  protected EpisodeOfCare parseEpisodeOfCare(JsonObject json) throws IOException, FHIRFormatError {
    EpisodeOfCare res = new EpisodeOfCare();
    parseEpisodeOfCareProperties(json, res);
    return res;
  }

  protected void parseEpisodeOfCareProperties(JsonObject json, EpisodeOfCare res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusHistory")) {
      JsonArray array = json.getAsJsonArray("statusHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusHistory().add(parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseEpisodeOfCareDiagnosisComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("referralRequest")) {
      JsonArray array = json.getAsJsonArray("referralRequest");
      for (int i = 0; i < array.size(); i++) {
        res.getReferralRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("careManager"))
      res.setCareManager(parseReference(json.getAsJsonObject("careManager")));
    if (json.has("team")) {
      JsonArray array = json.getAsJsonArray("team");
      for (int i = 0; i < array.size(); i++) {
        res.getTeam().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("account")) {
      JsonArray array = json.getAsJsonArray("account");
      for (int i = 0; i < array.size(); i++) {
        res.getAccount().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(JsonObject json, EpisodeOfCare owner) throws IOException, FHIRFormatError {
    EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
    parseEpisodeOfCareEpisodeOfCareStatusHistoryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEpisodeOfCareEpisodeOfCareStatusHistoryComponentProperties(JsonObject json, EpisodeOfCare owner, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected EpisodeOfCare.DiagnosisComponent parseEpisodeOfCareDiagnosisComponent(JsonObject json, EpisodeOfCare owner) throws IOException, FHIRFormatError {
    EpisodeOfCare.DiagnosisComponent res = new EpisodeOfCare.DiagnosisComponent();
    parseEpisodeOfCareDiagnosisComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEpisodeOfCareDiagnosisComponentProperties(JsonObject json, EpisodeOfCare owner, EpisodeOfCare.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("condition"))
      res.setCondition(parseReference(json.getAsJsonObject("condition")));
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("rank"))
      res.setRankElement(parsePositiveInt(json.get("rank").getAsString()));
    if (json.has("_rank"))
      parseElementProperties(json.getAsJsonObject("_rank"), res.getRankElement());
  }

  protected ExpansionProfile parseExpansionProfile(JsonObject json) throws IOException, FHIRFormatError {
    ExpansionProfile res = new ExpansionProfile();
    parseExpansionProfileProperties(json, res);
    return res;
  }

  protected void parseExpansionProfileProperties(JsonObject json, ExpansionProfile res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("fixedVersion")) {
      JsonArray array = json.getAsJsonArray("fixedVersion");
      for (int i = 0; i < array.size(); i++) {
        res.getFixedVersion().add(parseExpansionProfileExpansionProfileFixedVersionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("excludedSystem"))
      res.setExcludedSystem(parseExpansionProfileExpansionProfileExcludedSystemComponent(json.getAsJsonObject("excludedSystem"), res));
    if (json.has("includeDesignations"))
      res.setIncludeDesignationsElement(parseBoolean(json.get("includeDesignations").getAsBoolean()));
    if (json.has("_includeDesignations"))
      parseElementProperties(json.getAsJsonObject("_includeDesignations"), res.getIncludeDesignationsElement());
    if (json.has("designation"))
      res.setDesignation(parseExpansionProfileExpansionProfileDesignationComponent(json.getAsJsonObject("designation"), res));
    if (json.has("includeDefinition"))
      res.setIncludeDefinitionElement(parseBoolean(json.get("includeDefinition").getAsBoolean()));
    if (json.has("_includeDefinition"))
      parseElementProperties(json.getAsJsonObject("_includeDefinition"), res.getIncludeDefinitionElement());
    if (json.has("activeOnly"))
      res.setActiveOnlyElement(parseBoolean(json.get("activeOnly").getAsBoolean()));
    if (json.has("_activeOnly"))
      parseElementProperties(json.getAsJsonObject("_activeOnly"), res.getActiveOnlyElement());
    if (json.has("excludeNested"))
      res.setExcludeNestedElement(parseBoolean(json.get("excludeNested").getAsBoolean()));
    if (json.has("_excludeNested"))
      parseElementProperties(json.getAsJsonObject("_excludeNested"), res.getExcludeNestedElement());
    if (json.has("excludeNotForUI"))
      res.setExcludeNotForUIElement(parseBoolean(json.get("excludeNotForUI").getAsBoolean()));
    if (json.has("_excludeNotForUI"))
      parseElementProperties(json.getAsJsonObject("_excludeNotForUI"), res.getExcludeNotForUIElement());
    if (json.has("excludePostCoordinated"))
      res.setExcludePostCoordinatedElement(parseBoolean(json.get("excludePostCoordinated").getAsBoolean()));
    if (json.has("_excludePostCoordinated"))
      parseElementProperties(json.getAsJsonObject("_excludePostCoordinated"), res.getExcludePostCoordinatedElement());
    if (json.has("displayLanguage"))
      res.setDisplayLanguageElement(parseCode(json.get("displayLanguage").getAsString()));
    if (json.has("_displayLanguage"))
      parseElementProperties(json.getAsJsonObject("_displayLanguage"), res.getDisplayLanguageElement());
    if (json.has("limitedExpansion"))
      res.setLimitedExpansionElement(parseBoolean(json.get("limitedExpansion").getAsBoolean()));
    if (json.has("_limitedExpansion"))
      parseElementProperties(json.getAsJsonObject("_limitedExpansion"), res.getLimitedExpansionElement());
  }

  protected ExpansionProfile.ExpansionProfileFixedVersionComponent parseExpansionProfileExpansionProfileFixedVersionComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.ExpansionProfileFixedVersionComponent res = new ExpansionProfile.ExpansionProfileFixedVersionComponent();
    parseExpansionProfileExpansionProfileFixedVersionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExpansionProfileExpansionProfileFixedVersionComponentProperties(JsonObject json, ExpansionProfile owner, ExpansionProfile.ExpansionProfileFixedVersionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), ExpansionProfile.SystemVersionProcessingMode.NULL, new ExpansionProfile.SystemVersionProcessingModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
  }

  protected ExpansionProfile.ExpansionProfileExcludedSystemComponent parseExpansionProfileExpansionProfileExcludedSystemComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.ExpansionProfileExcludedSystemComponent res = new ExpansionProfile.ExpansionProfileExcludedSystemComponent();
    parseExpansionProfileExpansionProfileExcludedSystemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExpansionProfileExpansionProfileExcludedSystemComponentProperties(JsonObject json, ExpansionProfile owner, ExpansionProfile.ExpansionProfileExcludedSystemComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
  }

  protected ExpansionProfile.ExpansionProfileDesignationComponent parseExpansionProfileExpansionProfileDesignationComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.ExpansionProfileDesignationComponent res = new ExpansionProfile.ExpansionProfileDesignationComponent();
    parseExpansionProfileExpansionProfileDesignationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExpansionProfileExpansionProfileDesignationComponentProperties(JsonObject json, ExpansionProfile owner, ExpansionProfile.ExpansionProfileDesignationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("include"))
      res.setInclude(parseExpansionProfileDesignationIncludeComponent(json.getAsJsonObject("include"), owner));
    if (json.has("exclude"))
      res.setExclude(parseExpansionProfileDesignationExcludeComponent(json.getAsJsonObject("exclude"), owner));
  }

  protected ExpansionProfile.DesignationIncludeComponent parseExpansionProfileDesignationIncludeComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.DesignationIncludeComponent res = new ExpansionProfile.DesignationIncludeComponent();
    parseExpansionProfileDesignationIncludeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExpansionProfileDesignationIncludeComponentProperties(JsonObject json, ExpansionProfile owner, ExpansionProfile.DesignationIncludeComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("designation")) {
      JsonArray array = json.getAsJsonArray("designation");
      for (int i = 0; i < array.size(); i++) {
        res.getDesignation().add(parseExpansionProfileDesignationIncludeDesignationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExpansionProfile.DesignationIncludeDesignationComponent parseExpansionProfileDesignationIncludeDesignationComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.DesignationIncludeDesignationComponent res = new ExpansionProfile.DesignationIncludeDesignationComponent();
    parseExpansionProfileDesignationIncludeDesignationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExpansionProfileDesignationIncludeDesignationComponentProperties(JsonObject json, ExpansionProfile owner, ExpansionProfile.DesignationIncludeDesignationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("use"))
      res.setUse(parseCoding(json.getAsJsonObject("use")));
  }

  protected ExpansionProfile.DesignationExcludeComponent parseExpansionProfileDesignationExcludeComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.DesignationExcludeComponent res = new ExpansionProfile.DesignationExcludeComponent();
    parseExpansionProfileDesignationExcludeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExpansionProfileDesignationExcludeComponentProperties(JsonObject json, ExpansionProfile owner, ExpansionProfile.DesignationExcludeComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("designation")) {
      JsonArray array = json.getAsJsonArray("designation");
      for (int i = 0; i < array.size(); i++) {
        res.getDesignation().add(parseExpansionProfileDesignationExcludeDesignationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExpansionProfile.DesignationExcludeDesignationComponent parseExpansionProfileDesignationExcludeDesignationComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.DesignationExcludeDesignationComponent res = new ExpansionProfile.DesignationExcludeDesignationComponent();
    parseExpansionProfileDesignationExcludeDesignationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExpansionProfileDesignationExcludeDesignationComponentProperties(JsonObject json, ExpansionProfile owner, ExpansionProfile.DesignationExcludeDesignationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("use"))
      res.setUse(parseCoding(json.getAsJsonObject("use")));
  }

  protected ExplanationOfBenefit parseExplanationOfBenefit(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit res = new ExplanationOfBenefit();
    parseExplanationOfBenefitProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitProperties(JsonObject json, ExplanationOfBenefit res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ExplanationOfBenefit.ExplanationOfBenefitStatus.NULL, new ExplanationOfBenefit.ExplanationOfBenefitStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType")) {
      JsonArray array = json.getAsJsonArray("subType");
      for (int i = 0; i < array.size(); i++) {
        res.getSubType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("billablePeriod"))
      res.setBillablePeriod(parsePeriod(json.getAsJsonObject("billablePeriod")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(json.getAsJsonObject("enterer")));
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("referral"))
      res.setReferral(parseReference(json.getAsJsonObject("referral")));
    if (json.has("facility"))
      res.setFacility(parseReference(json.getAsJsonObject("facility")));
    if (json.has("claim"))
      res.setClaim(parseReference(json.getAsJsonObject("claim")));
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(json.getAsJsonObject("claimResponse")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseExplanationOfBenefitRelatedClaimComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("prescription"))
      res.setPrescription(parseReference(json.getAsJsonObject("prescription")));
    if (json.has("originalPrescription"))
      res.setOriginalPrescription(parseReference(json.getAsJsonObject("originalPrescription")));
    if (json.has("payee"))
      res.setPayee(parseExplanationOfBenefitPayeeComponent(json.getAsJsonObject("payee"), res));
    if (json.has("information")) {
      JsonArray array = json.getAsJsonArray("information");
      for (int i = 0; i < array.size(); i++) {
        res.getInformation().add(parseExplanationOfBenefitSupportingInformationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("careTeam")) {
      JsonArray array = json.getAsJsonArray("careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseExplanationOfBenefitCareTeamComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseExplanationOfBenefitDiagnosisComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("procedure")) {
      JsonArray array = json.getAsJsonArray("procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseExplanationOfBenefitProcedureComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("precedence"))
      res.setPrecedenceElement(parsePositiveInt(json.get("precedence").getAsString()));
    if (json.has("_precedence"))
      parseElementProperties(json.getAsJsonObject("_precedence"), res.getPrecedenceElement());
    if (json.has("insurance"))
      res.setInsurance(parseExplanationOfBenefitInsuranceComponent(json.getAsJsonObject("insurance"), res));
    if (json.has("accident"))
      res.setAccident(parseExplanationOfBenefitAccidentComponent(json.getAsJsonObject("accident"), res));
    if (json.has("employmentImpacted"))
      res.setEmploymentImpacted(parsePeriod(json.getAsJsonObject("employmentImpacted")));
    if (json.has("hospitalization"))
      res.setHospitalization(parsePeriod(json.getAsJsonObject("hospitalization")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseExplanationOfBenefitItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("addItem")) {
      JsonArray array = json.getAsJsonArray("addItem");
      for (int i = 0; i < array.size(); i++) {
        res.getAddItem().add(parseExplanationOfBenefitAddedItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("totalCost"))
      res.setTotalCost(parseMoney(json.getAsJsonObject("totalCost")));
    if (json.has("unallocDeductable"))
      res.setUnallocDeductable(parseMoney(json.getAsJsonObject("unallocDeductable")));
    if (json.has("totalBenefit"))
      res.setTotalBenefit(parseMoney(json.getAsJsonObject("totalBenefit")));
    if (json.has("payment"))
      res.setPayment(parseExplanationOfBenefitPaymentComponent(json.getAsJsonObject("payment"), res));
    if (json.has("form"))
      res.setForm(parseCodeableConcept(json.getAsJsonObject("form")));
    if (json.has("processNote")) {
      JsonArray array = json.getAsJsonArray("processNote");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessNote().add(parseExplanationOfBenefitNoteComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("benefitBalance")) {
      JsonArray array = json.getAsJsonArray("benefitBalance");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefitBalance().add(parseExplanationOfBenefitBenefitBalanceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ExplanationOfBenefit.RelatedClaimComponent parseExplanationOfBenefitRelatedClaimComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.RelatedClaimComponent res = new ExplanationOfBenefit.RelatedClaimComponent();
    parseExplanationOfBenefitRelatedClaimComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitRelatedClaimComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.RelatedClaimComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("claim"))
      res.setClaim(parseReference(json.getAsJsonObject("claim")));
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(json.getAsJsonObject("relationship")));
    if (json.has("reference"))
      res.setReference(parseIdentifier(json.getAsJsonObject("reference")));
  }

  protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
    parseExplanationOfBenefitPayeeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitPayeeComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.PayeeComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("resourceType"))
      res.setResourceType(parseCodeableConcept(json.getAsJsonObject("resourceType")));
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
  }

  protected ExplanationOfBenefit.SupportingInformationComponent parseExplanationOfBenefitSupportingInformationComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.SupportingInformationComponent res = new ExplanationOfBenefit.SupportingInformationComponent();
    parseExplanationOfBenefitSupportingInformationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitSupportingInformationComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.SupportingInformationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("reason"))
      res.setReason(parseCoding(json.getAsJsonObject("reason")));
  }

  protected ExplanationOfBenefit.CareTeamComponent parseExplanationOfBenefitCareTeamComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.CareTeamComponent res = new ExplanationOfBenefit.CareTeamComponent();
    parseExplanationOfBenefitCareTeamComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitCareTeamComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.CareTeamComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("responsible"))
      res.setResponsibleElement(parseBoolean(json.get("responsible").getAsBoolean()));
    if (json.has("_responsible"))
      parseElementProperties(json.getAsJsonObject("_responsible"), res.getResponsibleElement());
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("qualification"))
      res.setQualification(parseCodeableConcept(json.getAsJsonObject("qualification")));
  }

  protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
    parseExplanationOfBenefitDiagnosisComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitDiagnosisComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    Type diagnosis = parseType("diagnosis", json);
    if (diagnosis != null)
      res.setDiagnosis(diagnosis);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("packageCode"))
      res.setPackageCode(parseCodeableConcept(json.getAsJsonObject("packageCode")));
  }

  protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
    parseExplanationOfBenefitProcedureComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitProcedureComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.ProcedureComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    Type procedure = parseType("procedure", json);
    if (procedure != null)
      res.setProcedure(procedure);
  }

  protected ExplanationOfBenefit.InsuranceComponent parseExplanationOfBenefitInsuranceComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.InsuranceComponent res = new ExplanationOfBenefit.InsuranceComponent();
    parseExplanationOfBenefitInsuranceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitInsuranceComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("preAuthRef")) {
      JsonArray array = json.getAsJsonArray("preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        res.getPreAuthRef().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_preAuthRef")) {
      JsonArray array = json.getAsJsonArray("_preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPreAuthRef().size())
          res.getPreAuthRef().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
      }
    };
  }

  protected ExplanationOfBenefit.AccidentComponent parseExplanationOfBenefitAccidentComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AccidentComponent res = new ExplanationOfBenefit.AccidentComponent();
    parseExplanationOfBenefitAccidentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitAccidentComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AccidentComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    Type location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
  }

  protected ExplanationOfBenefit.ItemComponent parseExplanationOfBenefitItemComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ItemComponent res = new ExplanationOfBenefit.ItemComponent();
    parseExplanationOfBenefitItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitItemComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.ItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("careTeamLinkId")) {
      JsonArray array = json.getAsJsonArray("careTeamLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeamLinkId().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_careTeamLinkId")) {
      JsonArray array = json.getAsJsonArray("_careTeamLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCareTeamLinkId().size())
          res.getCareTeamLinkId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCareTeamLinkId().get(i));
      }
    };
    if (json.has("diagnosisLinkId")) {
      JsonArray array = json.getAsJsonArray("diagnosisLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosisLinkId().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_diagnosisLinkId")) {
      JsonArray array = json.getAsJsonArray("_diagnosisLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDiagnosisLinkId().size())
          res.getDiagnosisLinkId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDiagnosisLinkId().get(i));
      }
    };
    if (json.has("procedureLinkId")) {
      JsonArray array = json.getAsJsonArray("procedureLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedureLinkId().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_procedureLinkId")) {
      JsonArray array = json.getAsJsonArray("_procedureLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProcedureLinkId().size())
          res.getProcedureLinkId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProcedureLinkId().get(i));
      }
    };
    if (json.has("informationLinkId")) {
      JsonArray array = json.getAsJsonArray("informationLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getInformationLinkId().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_informationLinkId")) {
      JsonArray array = json.getAsJsonArray("_informationLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInformationLinkId().size())
          res.getInformationLinkId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInformationLinkId().get(i));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("service"))
      res.setService(parseCodeableConcept(json.getAsJsonObject("service")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    Type location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("subSite")) {
      JsonArray array = json.getAsJsonArray("subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("encounter")) {
      JsonArray array = json.getAsJsonArray("encounter");
      for (int i = 0; i < array.size(); i++) {
        res.getEncounter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseExplanationOfBenefitDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.AdjudicationComponent parseExplanationOfBenefitAdjudicationComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AdjudicationComponent res = new ExplanationOfBenefit.AdjudicationComponent();
    parseExplanationOfBenefitAdjudicationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitAdjudicationComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AdjudicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
    parseExplanationOfBenefitDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitDetailComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.DetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("service"))
      res.setService(parseCodeableConcept(json.getAsJsonObject("service")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseExplanationOfBenefitSubDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
    parseExplanationOfBenefitSubDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitSubDetailComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.SubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("service"))
      res.setService(parseCodeableConcept(json.getAsJsonObject("service")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
    parseExplanationOfBenefitAddedItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitAddedItemComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequenceLinkId")) {
      JsonArray array = json.getAsJsonArray("sequenceLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getSequenceLinkId().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_sequenceLinkId")) {
      JsonArray array = json.getAsJsonArray("_sequenceLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSequenceLinkId().size())
          res.getSequenceLinkId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSequenceLinkId().get(i));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("service"))
      res.setService(parseCodeableConcept(json.getAsJsonObject("service")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("fee"))
      res.setFee(parseMoney(json.getAsJsonObject("fee")));
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseExplanationOfBenefitAddedItemsDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.AddedItemsDetailComponent parseExplanationOfBenefitAddedItemsDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemsDetailComponent res = new ExplanationOfBenefit.AddedItemsDetailComponent();
    parseExplanationOfBenefitAddedItemsDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitAddedItemsDetailComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemsDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("service"))
      res.setService(parseCodeableConcept(json.getAsJsonObject("service")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("fee"))
      res.setFee(parseMoney(json.getAsJsonObject("fee")));
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.PaymentComponent parseExplanationOfBenefitPaymentComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.PaymentComponent res = new ExplanationOfBenefit.PaymentComponent();
    parseExplanationOfBenefitPaymentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitPaymentComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.PaymentComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("adjustment"))
      res.setAdjustment(parseMoney(json.getAsJsonObject("adjustment")));
    if (json.has("adjustmentReason"))
      res.setAdjustmentReason(parseCodeableConcept(json.getAsJsonObject("adjustmentReason")));
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
  }

  protected ExplanationOfBenefit.NoteComponent parseExplanationOfBenefitNoteComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.NoteComponent res = new ExplanationOfBenefit.NoteComponent();
    parseExplanationOfBenefitNoteComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitNoteComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.NoteComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("number"))
      res.setNumberElement(parsePositiveInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(json.getAsJsonObject("language")));
  }

  protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
    parseExplanationOfBenefitBenefitBalanceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitBenefitBalanceComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.BenefitBalanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("subCategory"))
      res.setSubCategory(parseCodeableConcept(json.getAsJsonObject("subCategory")));
    if (json.has("excluded"))
      res.setExcludedElement(parseBoolean(json.get("excluded").getAsBoolean()));
    if (json.has("_excluded"))
      parseElementProperties(json.getAsJsonObject("_excluded"), res.getExcludedElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("network"))
      res.setNetwork(parseCodeableConcept(json.getAsJsonObject("network")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(json.getAsJsonObject("unit")));
    if (json.has("term"))
      res.setTerm(parseCodeableConcept(json.getAsJsonObject("term")));
    if (json.has("financial")) {
      JsonArray array = json.getAsJsonArray("financial");
      for (int i = 0; i < array.size(); i++) {
        res.getFinancial().add(parseExplanationOfBenefitBenefitComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
    parseExplanationOfBenefitBenefitComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitBenefitComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.BenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    Type allowed = parseType("allowed", json);
    if (allowed != null)
      res.setAllowed(allowed);
    Type used = parseType("used", json);
    if (used != null)
      res.setUsed(used);
  }

  protected FamilyMemberHistory parseFamilyMemberHistory(JsonObject json) throws IOException, FHIRFormatError {
    FamilyMemberHistory res = new FamilyMemberHistory();
    parseFamilyMemberHistoryProperties(json, res);
    return res;
  }

  protected void parseFamilyMemberHistoryProperties(JsonObject json, FamilyMemberHistory res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        res.getDefinition().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("notDone"))
      res.setNotDoneElement(parseBoolean(json.get("notDone").getAsBoolean()));
    if (json.has("_notDone"))
      parseElementProperties(json.getAsJsonObject("_notDone"), res.getNotDoneElement());
    if (json.has("notDoneReason"))
      res.setNotDoneReason(parseCodeableConcept(json.getAsJsonObject("notDoneReason")));
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(json.getAsJsonObject("relationship")));
    if (json.has("gender"))
      res.setGenderElement(parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
    if (json.has("_gender"))
      parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
    Type born = parseType("born", json);
    if (born != null)
      res.setBorn(born);
    Type age = parseType("age", json);
    if (age != null)
      res.setAge(age);
    if (json.has("estimatedAge"))
      res.setEstimatedAgeElement(parseBoolean(json.get("estimatedAge").getAsBoolean()));
    if (json.has("_estimatedAge"))
      parseElementProperties(json.getAsJsonObject("_estimatedAge"), res.getEstimatedAgeElement());
    Type deceased = parseType("deceased", json);
    if (deceased != null)
      res.setDeceased(deceased);
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("condition")) {
      JsonArray array = json.getAsJsonArray("condition");
      for (int i = 0; i < array.size(); i++) {
        res.getCondition().add(parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(JsonObject json, FamilyMemberHistory owner) throws IOException, FHIRFormatError {
    FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
    parseFamilyMemberHistoryFamilyMemberHistoryConditionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseFamilyMemberHistoryFamilyMemberHistoryConditionComponentProperties(JsonObject json, FamilyMemberHistory owner, FamilyMemberHistory.FamilyMemberHistoryConditionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    Type onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Flag parseFlag(JsonObject json) throws IOException, FHIRFormatError {
    Flag res = new Flag();
    parseFlagProperties(json, res);
    return res;
  }

  protected void parseFlagProperties(JsonObject json, Flag res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
  }

  protected Goal parseGoal(JsonObject json) throws IOException, FHIRFormatError {
    Goal res = new Goal();
    parseGoalProperties(json, res);
    return res;
  }

  protected void parseGoalProperties(JsonObject json, Goal res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Goal.GoalStatus.NULL, new Goal.GoalStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("description"))
      res.setDescription(parseCodeableConcept(json.getAsJsonObject("description")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    Type start = parseType("start", json);
    if (start != null)
      res.setStart(start);
    if (json.has("target"))
      res.setTarget(parseGoalGoalTargetComponent(json.getAsJsonObject("target"), res));
    if (json.has("statusDate"))
      res.setStatusDateElement(parseDate(json.get("statusDate").getAsString()));
    if (json.has("_statusDate"))
      parseElementProperties(json.getAsJsonObject("_statusDate"), res.getStatusDateElement());
    if (json.has("statusReason"))
      res.setStatusReasonElement(parseString(json.get("statusReason").getAsString()));
    if (json.has("_statusReason"))
      parseElementProperties(json.getAsJsonObject("_statusReason"), res.getStatusReasonElement());
    if (json.has("expressedBy"))
      res.setExpressedBy(parseReference(json.getAsJsonObject("expressedBy")));
    if (json.has("addresses")) {
      JsonArray array = json.getAsJsonArray("addresses");
      for (int i = 0; i < array.size(); i++) {
        res.getAddresses().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("outcomeCode")) {
      JsonArray array = json.getAsJsonArray("outcomeCode");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcomeCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("outcomeReference")) {
      JsonArray array = json.getAsJsonArray("outcomeReference");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcomeReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Goal.GoalTargetComponent parseGoalGoalTargetComponent(JsonObject json, Goal owner) throws IOException, FHIRFormatError {
    Goal.GoalTargetComponent res = new Goal.GoalTargetComponent();
    parseGoalGoalTargetComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGoalGoalTargetComponentProperties(JsonObject json, Goal owner, Goal.GoalTargetComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("measure"))
      res.setMeasure(parseCodeableConcept(json.getAsJsonObject("measure")));
    Type detail = parseType("detail", json);
    if (detail != null)
      res.setDetail(detail);
    Type due = parseType("due", json);
    if (due != null)
      res.setDue(due);
  }

  protected GraphDefinition parseGraphDefinition(JsonObject json) throws IOException, FHIRFormatError {
    GraphDefinition res = new GraphDefinition();
    parseGraphDefinitionProperties(json, res);
    return res;
  }

  protected void parseGraphDefinitionProperties(JsonObject json, GraphDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("start"))
      res.setStartElement(parseCode(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("profile"))
      res.setProfileElement(parseUri(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseGraphDefinitionGraphDefinitionLinkComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected GraphDefinition.GraphDefinitionLinkComponent parseGraphDefinitionGraphDefinitionLinkComponent(JsonObject json, GraphDefinition owner) throws IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkComponent res = new GraphDefinition.GraphDefinitionLinkComponent();
    parseGraphDefinitionGraphDefinitionLinkComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGraphDefinitionGraphDefinitionLinkComponentProperties(JsonObject json, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("sliceName"))
      res.setSliceNameElement(parseString(json.get("sliceName").getAsString()));
    if (json.has("_sliceName"))
      parseElementProperties(json.getAsJsonObject("_sliceName"), res.getSliceNameElement());
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseGraphDefinitionGraphDefinitionLinkTargetComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected GraphDefinition.GraphDefinitionLinkTargetComponent parseGraphDefinitionGraphDefinitionLinkTargetComponent(JsonObject json, GraphDefinition owner) throws IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkTargetComponent res = new GraphDefinition.GraphDefinitionLinkTargetComponent();
    parseGraphDefinitionGraphDefinitionLinkTargetComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGraphDefinitionGraphDefinitionLinkTargetComponentProperties(JsonObject json, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkTargetComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfileElement(parseUri(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
    if (json.has("compartment")) {
      JsonArray array = json.getAsJsonArray("compartment");
      for (int i = 0; i < array.size(); i++) {
        res.getCompartment().add(parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseGraphDefinitionGraphDefinitionLinkComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(JsonObject json, GraphDefinition owner) throws IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
    parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponentProperties(JsonObject json, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), GraphDefinition.CompartmentCode.NULL, new GraphDefinition.CompartmentCodeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("rule"))
      res.setRuleElement(parseEnumeration(json.get("rule").getAsString(), GraphDefinition.GraphCompartmentRule.NULL, new GraphDefinition.GraphCompartmentRuleEnumFactory()));
    if (json.has("_rule"))
      parseElementProperties(json.getAsJsonObject("_rule"), res.getRuleElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
  }

  protected Group parseGroup(JsonObject json) throws IOException, FHIRFormatError {
    Group res = new Group();
    parseGroupProperties(json, res);
    return res;
  }

  protected void parseGroupProperties(JsonObject json, Group res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("actual"))
      res.setActualElement(parseBoolean(json.get("actual").getAsBoolean()));
    if (json.has("_actual"))
      parseElementProperties(json.getAsJsonObject("_actual"), res.getActualElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("quantity"))
      res.setQuantityElement(parseUnsignedInt(json.get("quantity").getAsString()));
    if (json.has("_quantity"))
      parseElementProperties(json.getAsJsonObject("_quantity"), res.getQuantityElement());
    if (json.has("characteristic")) {
      JsonArray array = json.getAsJsonArray("characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseGroupGroupCharacteristicComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("member")) {
      JsonArray array = json.getAsJsonArray("member");
      for (int i = 0; i < array.size(); i++) {
        res.getMember().add(parseGroupGroupMemberComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Group.GroupCharacteristicComponent parseGroupGroupCharacteristicComponent(JsonObject json, Group owner) throws IOException, FHIRFormatError {
    Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
    parseGroupGroupCharacteristicComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGroupGroupCharacteristicComponentProperties(JsonObject json, Group owner, Group.GroupCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("exclude"))
      res.setExcludeElement(parseBoolean(json.get("exclude").getAsBoolean()));
    if (json.has("_exclude"))
      parseElementProperties(json.getAsJsonObject("_exclude"), res.getExcludeElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Group.GroupMemberComponent parseGroupGroupMemberComponent(JsonObject json, Group owner) throws IOException, FHIRFormatError {
    Group.GroupMemberComponent res = new Group.GroupMemberComponent();
    parseGroupGroupMemberComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGroupGroupMemberComponentProperties(JsonObject json, Group owner, Group.GroupMemberComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("entity"))
      res.setEntity(parseReference(json.getAsJsonObject("entity")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("inactive"))
      res.setInactiveElement(parseBoolean(json.get("inactive").getAsBoolean()));
    if (json.has("_inactive"))
      parseElementProperties(json.getAsJsonObject("_inactive"), res.getInactiveElement());
  }

  protected GuidanceResponse parseGuidanceResponse(JsonObject json) throws IOException, FHIRFormatError {
    GuidanceResponse res = new GuidanceResponse();
    parseGuidanceResponseProperties(json, res);
    return res;
  }

  protected void parseGuidanceResponseProperties(JsonObject json, GuidanceResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("requestId"))
      res.setRequestIdElement(parseId(json.get("requestId").getAsString()));
    if (json.has("_requestId"))
      parseElementProperties(json.getAsJsonObject("_requestId"), res.getRequestIdElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("module"))
      res.setModule(parseReference(json.getAsJsonObject("module")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), GuidanceResponse.GuidanceResponseStatus.NULL, new GuidanceResponse.GuidanceResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("occurrenceDateTime"))
      res.setOccurrenceDateTimeElement(parseDateTime(json.get("occurrenceDateTime").getAsString()));
    if (json.has("_occurrenceDateTime"))
      parseElementProperties(json.getAsJsonObject("_occurrenceDateTime"), res.getOccurrenceDateTimeElement());
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    Type reason = parseType("reason", json);
    if (reason != null)
      res.setReason(reason);
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("evaluationMessage")) {
      JsonArray array = json.getAsJsonArray("evaluationMessage");
      for (int i = 0; i < array.size(); i++) {
        res.getEvaluationMessage().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("outputParameters"))
      res.setOutputParameters(parseReference(json.getAsJsonObject("outputParameters")));
    if (json.has("result"))
      res.setResult(parseReference(json.getAsJsonObject("result")));
    if (json.has("dataRequirement")) {
      JsonArray array = json.getAsJsonArray("dataRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getDataRequirement().add(parseDataRequirement(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected HealthcareService parseHealthcareService(JsonObject json) throws IOException, FHIRFormatError {
    HealthcareService res = new HealthcareService();
    parseHealthcareServiceProperties(json, res);
    return res;
  }

  protected void parseHealthcareServiceProperties(JsonObject json, HealthcareService res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("providedBy"))
      res.setProvidedBy(parseReference(json.getAsJsonObject("providedBy")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("extraDetails"))
      res.setExtraDetailsElement(parseString(json.get("extraDetails").getAsString()));
    if (json.has("_extraDetails"))
      parseElementProperties(json.getAsJsonObject("_extraDetails"), res.getExtraDetailsElement());
    if (json.has("photo"))
      res.setPhoto(parseAttachment(json.getAsJsonObject("photo")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("coverageArea")) {
      JsonArray array = json.getAsJsonArray("coverageArea");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverageArea().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("serviceProvisionCode")) {
      JsonArray array = json.getAsJsonArray("serviceProvisionCode");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceProvisionCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("eligibility"))
      res.setEligibility(parseCodeableConcept(json.getAsJsonObject("eligibility")));
    if (json.has("eligibilityNote"))
      res.setEligibilityNoteElement(parseString(json.get("eligibilityNote").getAsString()));
    if (json.has("_eligibilityNote"))
      parseElementProperties(json.getAsJsonObject("_eligibilityNote"), res.getEligibilityNoteElement());
    if (json.has("programName")) {
      JsonArray array = json.getAsJsonArray("programName");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramName().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_programName")) {
      JsonArray array = json.getAsJsonArray("_programName");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProgramName().size())
          res.getProgramName().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProgramName().get(i));
      }
    };
    if (json.has("characteristic")) {
      JsonArray array = json.getAsJsonArray("characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referralMethod")) {
      JsonArray array = json.getAsJsonArray("referralMethod");
      for (int i = 0; i < array.size(); i++) {
        res.getReferralMethod().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("appointmentRequired"))
      res.setAppointmentRequiredElement(parseBoolean(json.get("appointmentRequired").getAsBoolean()));
    if (json.has("_appointmentRequired"))
      parseElementProperties(json.getAsJsonObject("_appointmentRequired"), res.getAppointmentRequiredElement());
    if (json.has("availableTime")) {
      JsonArray array = json.getAsJsonArray("availableTime");
      for (int i = 0; i < array.size(); i++) {
        res.getAvailableTime().add(parseHealthcareServiceHealthcareServiceAvailableTimeComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("notAvailable")) {
      JsonArray array = json.getAsJsonArray("notAvailable");
      for (int i = 0; i < array.size(); i++) {
        res.getNotAvailable().add(parseHealthcareServiceHealthcareServiceNotAvailableComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("availabilityExceptions"))
      res.setAvailabilityExceptionsElement(parseString(json.get("availabilityExceptions").getAsString()));
    if (json.has("_availabilityExceptions"))
      parseElementProperties(json.getAsJsonObject("_availabilityExceptions"), res.getAvailabilityExceptionsElement());
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected HealthcareService.HealthcareServiceAvailableTimeComponent parseHealthcareServiceHealthcareServiceAvailableTimeComponent(JsonObject json, HealthcareService owner) throws IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceAvailableTimeComponent res = new HealthcareService.HealthcareServiceAvailableTimeComponent();
    parseHealthcareServiceHealthcareServiceAvailableTimeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseHealthcareServiceHealthcareServiceAvailableTimeComponentProperties(JsonObject json, HealthcareService owner, HealthcareService.HealthcareServiceAvailableTimeComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        res.getDaysOfWeek().add(parseEnumeration(array.get(i).getAsString(), HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
      }
    };
    if (json.has("_daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("_daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDaysOfWeek().size())
          res.getDaysOfWeek().add(parseEnumeration(null, HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDaysOfWeek().get(i));
      }
    };
    if (json.has("allDay"))
      res.setAllDayElement(parseBoolean(json.get("allDay").getAsBoolean()));
    if (json.has("_allDay"))
      parseElementProperties(json.getAsJsonObject("_allDay"), res.getAllDayElement());
    if (json.has("availableStartTime"))
      res.setAvailableStartTimeElement(parseTime(json.get("availableStartTime").getAsString()));
    if (json.has("_availableStartTime"))
      parseElementProperties(json.getAsJsonObject("_availableStartTime"), res.getAvailableStartTimeElement());
    if (json.has("availableEndTime"))
      res.setAvailableEndTimeElement(parseTime(json.get("availableEndTime").getAsString()));
    if (json.has("_availableEndTime"))
      parseElementProperties(json.getAsJsonObject("_availableEndTime"), res.getAvailableEndTimeElement());
  }

  protected HealthcareService.HealthcareServiceNotAvailableComponent parseHealthcareServiceHealthcareServiceNotAvailableComponent(JsonObject json, HealthcareService owner) throws IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceNotAvailableComponent res = new HealthcareService.HealthcareServiceNotAvailableComponent();
    parseHealthcareServiceHealthcareServiceNotAvailableComponentProperties(json, owner, res);
    return res;
  }

  protected void parseHealthcareServiceHealthcareServiceNotAvailableComponentProperties(JsonObject json, HealthcareService owner, HealthcareService.HealthcareServiceNotAvailableComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("during"))
      res.setDuring(parsePeriod(json.getAsJsonObject("during")));
  }

  protected ImagingManifest parseImagingManifest(JsonObject json) throws IOException, FHIRFormatError {
    ImagingManifest res = new ImagingManifest();
    parseImagingManifestProperties(json, res);
    return res;
  }

  protected void parseImagingManifestProperties(JsonObject json, ImagingManifest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("authoringTime"))
      res.setAuthoringTimeElement(parseDateTime(json.get("authoringTime").getAsString()));
    if (json.has("_authoringTime"))
      parseElementProperties(json.getAsJsonObject("_authoringTime"), res.getAuthoringTimeElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("study")) {
      JsonArray array = json.getAsJsonArray("study");
      for (int i = 0; i < array.size(); i++) {
        res.getStudy().add(parseImagingManifestStudyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ImagingManifest.StudyComponent parseImagingManifestStudyComponent(JsonObject json, ImagingManifest owner) throws IOException, FHIRFormatError {
    ImagingManifest.StudyComponent res = new ImagingManifest.StudyComponent();
    parseImagingManifestStudyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImagingManifestStudyComponentProperties(JsonObject json, ImagingManifest owner, ImagingManifest.StudyComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("imagingStudy"))
      res.setImagingStudy(parseReference(json.getAsJsonObject("imagingStudy")));
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("series")) {
      JsonArray array = json.getAsJsonArray("series");
      for (int i = 0; i < array.size(); i++) {
        res.getSeries().add(parseImagingManifestSeriesComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ImagingManifest.SeriesComponent parseImagingManifestSeriesComponent(JsonObject json, ImagingManifest owner) throws IOException, FHIRFormatError {
    ImagingManifest.SeriesComponent res = new ImagingManifest.SeriesComponent();
    parseImagingManifestSeriesComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImagingManifestSeriesComponentProperties(JsonObject json, ImagingManifest owner, ImagingManifest.SeriesComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instance")) {
      JsonArray array = json.getAsJsonArray("instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseImagingManifestInstanceComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ImagingManifest.InstanceComponent parseImagingManifestInstanceComponent(JsonObject json, ImagingManifest owner) throws IOException, FHIRFormatError {
    ImagingManifest.InstanceComponent res = new ImagingManifest.InstanceComponent();
    parseImagingManifestInstanceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImagingManifestInstanceComponentProperties(JsonObject json, ImagingManifest owner, ImagingManifest.InstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sopClass"))
      res.setSopClassElement(parseOid(json.get("sopClass").getAsString()));
    if (json.has("_sopClass"))
      parseElementProperties(json.getAsJsonObject("_sopClass"), res.getSopClassElement());
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
  }

  protected ImagingStudy parseImagingStudy(JsonObject json) throws IOException, FHIRFormatError {
    ImagingStudy res = new ImagingStudy();
    parseImagingStudyProperties(json, res);
    return res;
  }

  protected void parseImagingStudyProperties(JsonObject json, ImagingStudy res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("accession"))
      res.setAccession(parseIdentifier(json.getAsJsonObject("accession")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("availability"))
      res.setAvailabilityElement(parseEnumeration(json.get("availability").getAsString(), ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
    if (json.has("_availability"))
      parseElementProperties(json.getAsJsonObject("_availability"), res.getAvailabilityElement());
    if (json.has("modalityList")) {
      JsonArray array = json.getAsJsonArray("modalityList");
      for (int i = 0; i < array.size(); i++) {
        res.getModalityList().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("started"))
      res.setStartedElement(parseDateTime(json.get("started").getAsString()));
    if (json.has("_started"))
      parseElementProperties(json.getAsJsonObject("_started"), res.getStartedElement());
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referrer"))
      res.setReferrer(parseReference(json.getAsJsonObject("referrer")));
    if (json.has("interpreter")) {
      JsonArray array = json.getAsJsonArray("interpreter");
      for (int i = 0; i < array.size(); i++) {
        res.getInterpreter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("numberOfSeries"))
      res.setNumberOfSeriesElement(parseUnsignedInt(json.get("numberOfSeries").getAsString()));
    if (json.has("_numberOfSeries"))
      parseElementProperties(json.getAsJsonObject("_numberOfSeries"), res.getNumberOfSeriesElement());
    if (json.has("numberOfInstances"))
      res.setNumberOfInstancesElement(parseUnsignedInt(json.get("numberOfInstances").getAsString()));
    if (json.has("_numberOfInstances"))
      parseElementProperties(json.getAsJsonObject("_numberOfInstances"), res.getNumberOfInstancesElement());
    if (json.has("procedureReference")) {
      JsonArray array = json.getAsJsonArray("procedureReference");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedureReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("procedureCode")) {
      JsonArray array = json.getAsJsonArray("procedureCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedureCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("series")) {
      JsonArray array = json.getAsJsonArray("series");
      for (int i = 0; i < array.size(); i++) {
        res.getSeries().add(parseImagingStudyImagingStudySeriesComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudyImagingStudySeriesComponent(JsonObject json, ImagingStudy owner) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
    parseImagingStudyImagingStudySeriesComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImagingStudyImagingStudySeriesComponentProperties(JsonObject json, ImagingStudy owner, ImagingStudy.ImagingStudySeriesComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("number"))
      res.setNumberElement(parseUnsignedInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("modality"))
      res.setModality(parseCoding(json.getAsJsonObject("modality")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("numberOfInstances"))
      res.setNumberOfInstancesElement(parseUnsignedInt(json.get("numberOfInstances").getAsString()));
    if (json.has("_numberOfInstances"))
      parseElementProperties(json.getAsJsonObject("_numberOfInstances"), res.getNumberOfInstancesElement());
    if (json.has("availability"))
      res.setAvailabilityElement(parseEnumeration(json.get("availability").getAsString(), ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
    if (json.has("_availability"))
      parseElementProperties(json.getAsJsonObject("_availability"), res.getAvailabilityElement());
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCoding(json.getAsJsonObject("bodySite")));
    if (json.has("laterality"))
      res.setLaterality(parseCoding(json.getAsJsonObject("laterality")));
    if (json.has("started"))
      res.setStartedElement(parseDateTime(json.get("started").getAsString()));
    if (json.has("_started"))
      parseElementProperties(json.getAsJsonObject("_started"), res.getStartedElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instance")) {
      JsonArray array = json.getAsJsonArray("instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseImagingStudyImagingStudySeriesInstanceComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudyImagingStudySeriesInstanceComponent(JsonObject json, ImagingStudy owner) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
    parseImagingStudyImagingStudySeriesInstanceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImagingStudyImagingStudySeriesInstanceComponentProperties(JsonObject json, ImagingStudy owner, ImagingStudy.ImagingStudySeriesInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("number"))
      res.setNumberElement(parseUnsignedInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("sopClass"))
      res.setSopClassElement(parseOid(json.get("sopClass").getAsString()));
    if (json.has("_sopClass"))
      parseElementProperties(json.getAsJsonObject("_sopClass"), res.getSopClassElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
  }

  protected Immunization parseImmunization(JsonObject json) throws IOException, FHIRFormatError {
    Immunization res = new Immunization();
    parseImmunizationProperties(json, res);
    return res;
  }

  protected void parseImmunizationProperties(JsonObject json, Immunization res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Immunization.ImmunizationStatus.NULL, new Immunization.ImmunizationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("notGiven"))
      res.setNotGivenElement(parseBoolean(json.get("notGiven").getAsBoolean()));
    if (json.has("_notGiven"))
      parseElementProperties(json.getAsJsonObject("_notGiven"), res.getNotGivenElement());
    if (json.has("vaccineCode"))
      res.setVaccineCode(parseCodeableConcept(json.getAsJsonObject("vaccineCode")));
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("primarySource"))
      res.setPrimarySourceElement(parseBoolean(json.get("primarySource").getAsBoolean()));
    if (json.has("_primarySource"))
      parseElementProperties(json.getAsJsonObject("_primarySource"), res.getPrimarySourceElement());
    if (json.has("reportOrigin"))
      res.setReportOrigin(parseCodeableConcept(json.getAsJsonObject("reportOrigin")));
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("manufacturer"))
      res.setManufacturer(parseReference(json.getAsJsonObject("manufacturer")));
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDate(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
    if (json.has("site"))
      res.setSite(parseCodeableConcept(json.getAsJsonObject("site")));
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(json.getAsJsonObject("route")));
    if (json.has("doseQuantity"))
      res.setDoseQuantity(parseSimpleQuantity(json.getAsJsonObject("doseQuantity")));
    if (json.has("practitioner")) {
      JsonArray array = json.getAsJsonArray("practitioner");
      for (int i = 0; i < array.size(); i++) {
        res.getPractitioner().add(parseImmunizationImmunizationPractitionerComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("explanation"))
      res.setExplanation(parseImmunizationImmunizationExplanationComponent(json.getAsJsonObject("explanation"), res));
    if (json.has("reaction")) {
      JsonArray array = json.getAsJsonArray("reaction");
      for (int i = 0; i < array.size(); i++) {
        res.getReaction().add(parseImmunizationImmunizationReactionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("vaccinationProtocol")) {
      JsonArray array = json.getAsJsonArray("vaccinationProtocol");
      for (int i = 0; i < array.size(); i++) {
        res.getVaccinationProtocol().add(parseImmunizationImmunizationVaccinationProtocolComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Immunization.ImmunizationPractitionerComponent parseImmunizationImmunizationPractitionerComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
    Immunization.ImmunizationPractitionerComponent res = new Immunization.ImmunizationPractitionerComponent();
    parseImmunizationImmunizationPractitionerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationImmunizationPractitionerComponentProperties(JsonObject json, Immunization owner, Immunization.ImmunizationPractitionerComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
  }

  protected Immunization.ImmunizationExplanationComponent parseImmunizationImmunizationExplanationComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
    Immunization.ImmunizationExplanationComponent res = new Immunization.ImmunizationExplanationComponent();
    parseImmunizationImmunizationExplanationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationImmunizationExplanationComponentProperties(JsonObject json, Immunization owner, Immunization.ImmunizationExplanationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonNotGiven")) {
      JsonArray array = json.getAsJsonArray("reasonNotGiven");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonNotGiven().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Immunization.ImmunizationReactionComponent parseImmunizationImmunizationReactionComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
    Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
    parseImmunizationImmunizationReactionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationImmunizationReactionComponentProperties(JsonObject json, Immunization owner, Immunization.ImmunizationReactionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("detail"))
      res.setDetail(parseReference(json.getAsJsonObject("detail")));
    if (json.has("reported"))
      res.setReportedElement(parseBoolean(json.get("reported").getAsBoolean()));
    if (json.has("_reported"))
      parseElementProperties(json.getAsJsonObject("_reported"), res.getReportedElement());
  }

  protected Immunization.ImmunizationVaccinationProtocolComponent parseImmunizationImmunizationVaccinationProtocolComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
    Immunization.ImmunizationVaccinationProtocolComponent res = new Immunization.ImmunizationVaccinationProtocolComponent();
    parseImmunizationImmunizationVaccinationProtocolComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationImmunizationVaccinationProtocolComponentProperties(JsonObject json, Immunization owner, Immunization.ImmunizationVaccinationProtocolComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("doseSequence"))
      res.setDoseSequenceElement(parsePositiveInt(json.get("doseSequence").getAsString()));
    if (json.has("_doseSequence"))
      parseElementProperties(json.getAsJsonObject("_doseSequence"), res.getDoseSequenceElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("authority"))
      res.setAuthority(parseReference(json.getAsJsonObject("authority")));
    if (json.has("series"))
      res.setSeriesElement(parseString(json.get("series").getAsString()));
    if (json.has("_series"))
      parseElementProperties(json.getAsJsonObject("_series"), res.getSeriesElement());
    if (json.has("seriesDoses"))
      res.setSeriesDosesElement(parsePositiveInt(json.get("seriesDoses").getAsString()));
    if (json.has("_seriesDoses"))
      parseElementProperties(json.getAsJsonObject("_seriesDoses"), res.getSeriesDosesElement());
    if (json.has("targetDisease")) {
      JsonArray array = json.getAsJsonArray("targetDisease");
      for (int i = 0; i < array.size(); i++) {
        res.getTargetDisease().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("doseStatus"))
      res.setDoseStatus(parseCodeableConcept(json.getAsJsonObject("doseStatus")));
    if (json.has("doseStatusReason"))
      res.setDoseStatusReason(parseCodeableConcept(json.getAsJsonObject("doseStatusReason")));
  }

  protected ImmunizationRecommendation parseImmunizationRecommendation(JsonObject json) throws IOException, FHIRFormatError {
    ImmunizationRecommendation res = new ImmunizationRecommendation();
    parseImmunizationRecommendationProperties(json, res);
    return res;
  }

  protected void parseImmunizationRecommendationProperties(JsonObject json, ImmunizationRecommendation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("recommendation")) {
      JsonArray array = json.getAsJsonArray("recommendation");
      for (int i = 0; i < array.size(); i++) {
        res.getRecommendation().add(parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
    parseImmunizationRecommendationImmunizationRecommendationRecommendationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationRecommendationImmunizationRecommendationRecommendationComponentProperties(JsonObject json, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("vaccineCode"))
      res.setVaccineCode(parseCodeableConcept(json.getAsJsonObject("vaccineCode")));
    if (json.has("targetDisease"))
      res.setTargetDisease(parseCodeableConcept(json.getAsJsonObject("targetDisease")));
    if (json.has("doseNumber"))
      res.setDoseNumberElement(parsePositiveInt(json.get("doseNumber").getAsString()));
    if (json.has("_doseNumber"))
      parseElementProperties(json.getAsJsonObject("_doseNumber"), res.getDoseNumberElement());
    if (json.has("forecastStatus"))
      res.setForecastStatus(parseCodeableConcept(json.getAsJsonObject("forecastStatus")));
    if (json.has("dateCriterion")) {
      JsonArray array = json.getAsJsonArray("dateCriterion");
      for (int i = 0; i < array.size(); i++) {
        res.getDateCriterion().add(parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("protocol"))
      res.setProtocol(parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(json.getAsJsonObject("protocol"), owner));
    if (json.has("supportingImmunization")) {
      JsonArray array = json.getAsJsonArray("supportingImmunization");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingImmunization().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingPatientInformation")) {
      JsonArray array = json.getAsJsonArray("supportingPatientInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingPatientInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
    parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponentProperties(JsonObject json, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("value"))
      res.setValueElement(parseDateTime(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent();
    parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponentProperties(JsonObject json, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("doseSequence"))
      res.setDoseSequenceElement(parsePositiveInt(json.get("doseSequence").getAsString()));
    if (json.has("_doseSequence"))
      parseElementProperties(json.getAsJsonObject("_doseSequence"), res.getDoseSequenceElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("authority"))
      res.setAuthority(parseReference(json.getAsJsonObject("authority")));
    if (json.has("series"))
      res.setSeriesElement(parseString(json.get("series").getAsString()));
    if (json.has("_series"))
      parseElementProperties(json.getAsJsonObject("_series"), res.getSeriesElement());
  }

  protected ImplementationGuide parseImplementationGuide(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide res = new ImplementationGuide();
    parseImplementationGuideProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideProperties(JsonObject json, ImplementationGuide res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("fhirVersion"))
      res.setFhirVersionElement(parseId(json.get("fhirVersion").getAsString()));
    if (json.has("_fhirVersion"))
      parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
    if (json.has("dependency")) {
      JsonArray array = json.getAsJsonArray("dependency");
      for (int i = 0; i < array.size(); i++) {
        res.getDependency().add(parseImplementationGuideImplementationGuideDependencyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("package")) {
      JsonArray array = json.getAsJsonArray("package");
      for (int i = 0; i < array.size(); i++) {
        res.getPackage().add(parseImplementationGuideImplementationGuidePackageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("global")) {
      JsonArray array = json.getAsJsonArray("global");
      for (int i = 0; i < array.size(); i++) {
        res.getGlobal().add(parseImplementationGuideImplementationGuideGlobalComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("binary")) {
      JsonArray array = json.getAsJsonArray("binary");
      for (int i = 0; i < array.size(); i++) {
        res.getBinary().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_binary")) {
      JsonArray array = json.getAsJsonArray("_binary");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getBinary().size())
          res.getBinary().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getBinary().get(i));
      }
    };
    if (json.has("page"))
      res.setPage(parseImplementationGuideImplementationGuidePageComponent(json.getAsJsonObject("page"), res));
  }

  protected ImplementationGuide.ImplementationGuideDependencyComponent parseImplementationGuideImplementationGuideDependencyComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDependencyComponent res = new ImplementationGuide.ImplementationGuideDependencyComponent();
    parseImplementationGuideImplementationGuideDependencyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideDependencyComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDependencyComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ImplementationGuide.GuideDependencyType.NULL, new ImplementationGuide.GuideDependencyTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
  }

  protected ImplementationGuide.ImplementationGuidePackageComponent parseImplementationGuideImplementationGuidePackageComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuidePackageComponent res = new ImplementationGuide.ImplementationGuidePackageComponent();
    parseImplementationGuideImplementationGuidePackageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuidePackageComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuidePackageComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseImplementationGuideImplementationGuidePackageResourceComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ImplementationGuide.ImplementationGuidePackageResourceComponent parseImplementationGuideImplementationGuidePackageResourceComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuidePackageResourceComponent res = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
    parseImplementationGuideImplementationGuidePackageResourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuidePackageResourceComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuidePackageResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("example"))
      res.setExampleElement(parseBoolean(json.get("example").getAsBoolean()));
    if (json.has("_example"))
      parseElementProperties(json.getAsJsonObject("_example"), res.getExampleElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("acronym"))
      res.setAcronymElement(parseString(json.get("acronym").getAsString()));
    if (json.has("_acronym"))
      parseElementProperties(json.getAsJsonObject("_acronym"), res.getAcronymElement());
    Type source = parseType("source", json);
    if (source != null)
      res.setSource(source);
    if (json.has("exampleFor"))
      res.setExampleFor(parseReference(json.getAsJsonObject("exampleFor")));
  }

  protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideImplementationGuideGlobalComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
    parseImplementationGuideImplementationGuideGlobalComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideGlobalComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideGlobalComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfile(parseReference(json.getAsJsonObject("profile")));
  }

  protected ImplementationGuide.ImplementationGuidePageComponent parseImplementationGuideImplementationGuidePageComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuidePageComponent res = new ImplementationGuide.ImplementationGuidePageComponent();
    parseImplementationGuideImplementationGuidePageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuidePageComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuidePageComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("source"))
      res.setSourceElement(parseUri(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), ImplementationGuide.GuidePageKind.NULL, new ImplementationGuide.GuidePageKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCode(array.get(i).getAsString()));
      }
    };
    if (json.has("_type")) {
      JsonArray array = json.getAsJsonArray("_type");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getType().size())
          res.getType().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getType().get(i));
      }
    };
    if (json.has("package")) {
      JsonArray array = json.getAsJsonArray("package");
      for (int i = 0; i < array.size(); i++) {
        res.getPackage().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_package")) {
      JsonArray array = json.getAsJsonArray("_package");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPackage().size())
          res.getPackage().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPackage().get(i));
      }
    };
    if (json.has("format"))
      res.setFormatElement(parseCode(json.get("format").getAsString()));
    if (json.has("_format"))
      parseElementProperties(json.getAsJsonObject("_format"), res.getFormatElement());
    if (json.has("page")) {
      JsonArray array = json.getAsJsonArray("page");
      for (int i = 0; i < array.size(); i++) {
        res.getPage().add(parseImplementationGuideImplementationGuidePageComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Library parseLibrary(JsonObject json) throws IOException, FHIRFormatError {
    Library res = new Library();
    parseLibraryProperties(json, res);
    return res;
  }

  protected void parseLibraryProperties(JsonObject json, Library res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contributor")) {
      JsonArray array = json.getAsJsonArray("contributor");
      for (int i = 0; i < array.size(); i++) {
        res.getContributor().add(parseContributor(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseParameterDefinition(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dataRequirement")) {
      JsonArray array = json.getAsJsonArray("dataRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getDataRequirement().add(parseDataRequirement(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Linkage parseLinkage(JsonObject json) throws IOException, FHIRFormatError {
    Linkage res = new Linkage();
    parseLinkageProperties(json, res);
    return res;
  }

  protected void parseLinkageProperties(JsonObject json, Linkage res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseLinkageLinkageItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Linkage.LinkageItemComponent parseLinkageLinkageItemComponent(JsonObject json, Linkage owner) throws IOException, FHIRFormatError {
    Linkage.LinkageItemComponent res = new Linkage.LinkageItemComponent();
    parseLinkageLinkageItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseLinkageLinkageItemComponentProperties(JsonObject json, Linkage owner, Linkage.LinkageItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Linkage.LinkageType.NULL, new Linkage.LinkageTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("resource"))
      res.setResource(parseReference(json.getAsJsonObject("resource")));
  }

  protected ListResource parseListResource(JsonObject json) throws IOException, FHIRFormatError {
    ListResource res = new ListResource();
    parseListResourceProperties(json, res);
    return res;
  }

  protected void parseListResourceProperties(JsonObject json, ListResource res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ListResource.ListStatus.NULL, new ListResource.ListStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), ListResource.ListMode.NULL, new ListResource.ListModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("orderedBy"))
      res.setOrderedBy(parseCodeableConcept(json.getAsJsonObject("orderedBy")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("entry")) {
      JsonArray array = json.getAsJsonArray("entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseListResourceListEntryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("emptyReason"))
      res.setEmptyReason(parseCodeableConcept(json.getAsJsonObject("emptyReason")));
  }

  protected ListResource.ListEntryComponent parseListResourceListEntryComponent(JsonObject json, ListResource owner) throws IOException, FHIRFormatError {
    ListResource.ListEntryComponent res = new ListResource.ListEntryComponent();
    parseListResourceListEntryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseListResourceListEntryComponentProperties(JsonObject json, ListResource owner, ListResource.ListEntryComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("flag"))
      res.setFlag(parseCodeableConcept(json.getAsJsonObject("flag")));
    if (json.has("deleted"))
      res.setDeletedElement(parseBoolean(json.get("deleted").getAsBoolean()));
    if (json.has("_deleted"))
      parseElementProperties(json.getAsJsonObject("_deleted"), res.getDeletedElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("item"))
      res.setItem(parseReference(json.getAsJsonObject("item")));
  }

  protected Location parseLocation(JsonObject json) throws IOException, FHIRFormatError {
    Location res = new Location();
    parseLocationProperties(json, res);
    return res;
  }

  protected void parseLocationProperties(JsonObject json, Location res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Location.LocationStatus.NULL, new Location.LocationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("operationalStatus"))
      res.setOperationalStatus(parseCoding(json.getAsJsonObject("operationalStatus")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        res.getAlias().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Location.LocationMode.NULL, new Location.LocationModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("address"))
      res.setAddress(parseAddress(json.getAsJsonObject("address")));
    if (json.has("physicalType"))
      res.setPhysicalType(parseCodeableConcept(json.getAsJsonObject("physicalType")));
    if (json.has("position"))
      res.setPosition(parseLocationLocationPositionComponent(json.getAsJsonObject("position"), res));
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("partOf"))
      res.setPartOf(parseReference(json.getAsJsonObject("partOf")));
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Location.LocationPositionComponent parseLocationLocationPositionComponent(JsonObject json, Location owner) throws IOException, FHIRFormatError {
    Location.LocationPositionComponent res = new Location.LocationPositionComponent();
    parseLocationLocationPositionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseLocationLocationPositionComponentProperties(JsonObject json, Location owner, Location.LocationPositionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("longitude"))
      res.setLongitudeElement(parseDecimal(json.get("longitude").getAsBigDecimal()));
    if (json.has("_longitude"))
      parseElementProperties(json.getAsJsonObject("_longitude"), res.getLongitudeElement());
    if (json.has("latitude"))
      res.setLatitudeElement(parseDecimal(json.get("latitude").getAsBigDecimal()));
    if (json.has("_latitude"))
      parseElementProperties(json.getAsJsonObject("_latitude"), res.getLatitudeElement());
    if (json.has("altitude"))
      res.setAltitudeElement(parseDecimal(json.get("altitude").getAsBigDecimal()));
    if (json.has("_altitude"))
      parseElementProperties(json.getAsJsonObject("_altitude"), res.getAltitudeElement());
  }

  protected Measure parseMeasure(JsonObject json) throws IOException, FHIRFormatError {
    Measure res = new Measure();
    parseMeasureProperties(json, res);
    return res;
  }

  protected void parseMeasureProperties(JsonObject json, Measure res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contributor")) {
      JsonArray array = json.getAsJsonArray("contributor");
      for (int i = 0; i < array.size(); i++) {
        res.getContributor().add(parseContributor(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("library")) {
      JsonArray array = json.getAsJsonArray("library");
      for (int i = 0; i < array.size(); i++) {
        res.getLibrary().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("disclaimer"))
      res.setDisclaimerElement(parseMarkdown(json.get("disclaimer").getAsString()));
    if (json.has("_disclaimer"))
      parseElementProperties(json.getAsJsonObject("_disclaimer"), res.getDisclaimerElement());
    if (json.has("scoring"))
      res.setScoring(parseCodeableConcept(json.getAsJsonObject("scoring")));
    if (json.has("compositeScoring"))
      res.setCompositeScoring(parseCodeableConcept(json.getAsJsonObject("compositeScoring")));
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("riskAdjustment"))
      res.setRiskAdjustmentElement(parseString(json.get("riskAdjustment").getAsString()));
    if (json.has("_riskAdjustment"))
      parseElementProperties(json.getAsJsonObject("_riskAdjustment"), res.getRiskAdjustmentElement());
    if (json.has("rateAggregation"))
      res.setRateAggregationElement(parseString(json.get("rateAggregation").getAsString()));
    if (json.has("_rateAggregation"))
      parseElementProperties(json.getAsJsonObject("_rateAggregation"), res.getRateAggregationElement());
    if (json.has("rationale"))
      res.setRationaleElement(parseMarkdown(json.get("rationale").getAsString()));
    if (json.has("_rationale"))
      parseElementProperties(json.getAsJsonObject("_rationale"), res.getRationaleElement());
    if (json.has("clinicalRecommendationStatement"))
      res.setClinicalRecommendationStatementElement(parseMarkdown(json.get("clinicalRecommendationStatement").getAsString()));
    if (json.has("_clinicalRecommendationStatement"))
      parseElementProperties(json.getAsJsonObject("_clinicalRecommendationStatement"), res.getClinicalRecommendationStatementElement());
    if (json.has("improvementNotation"))
      res.setImprovementNotationElement(parseString(json.get("improvementNotation").getAsString()));
    if (json.has("_improvementNotation"))
      parseElementProperties(json.getAsJsonObject("_improvementNotation"), res.getImprovementNotationElement());
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        res.getDefinition().add(parseMarkdown(array.get(i).getAsString()));
      }
    };
    if (json.has("_definition")) {
      JsonArray array = json.getAsJsonArray("_definition");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDefinition().size())
          res.getDefinition().add(parseMarkdown(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDefinition().get(i));
      }
    };
    if (json.has("guidance"))
      res.setGuidanceElement(parseMarkdown(json.get("guidance").getAsString()));
    if (json.has("_guidance"))
      parseElementProperties(json.getAsJsonObject("_guidance"), res.getGuidanceElement());
    if (json.has("set"))
      res.setSetElement(parseString(json.get("set").getAsString()));
    if (json.has("_set"))
      parseElementProperties(json.getAsJsonObject("_set"), res.getSetElement());
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseMeasureMeasureGroupComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("supplementalData")) {
      JsonArray array = json.getAsJsonArray("supplementalData");
      for (int i = 0; i < array.size(); i++) {
        res.getSupplementalData().add(parseMeasureMeasureSupplementalDataComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Measure.MeasureGroupComponent parseMeasureMeasureGroupComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
    Measure.MeasureGroupComponent res = new Measure.MeasureGroupComponent();
    parseMeasureMeasureGroupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureMeasureGroupComponentProperties(JsonObject json, Measure owner, Measure.MeasureGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMeasureMeasureGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("stratifier")) {
      JsonArray array = json.getAsJsonArray("stratifier");
      for (int i = 0; i < array.size(); i++) {
        res.getStratifier().add(parseMeasureMeasureGroupStratifierComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Measure.MeasureGroupPopulationComponent parseMeasureMeasureGroupPopulationComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
    Measure.MeasureGroupPopulationComponent res = new Measure.MeasureGroupPopulationComponent();
    parseMeasureMeasureGroupPopulationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureMeasureGroupPopulationComponentProperties(JsonObject json, Measure owner, Measure.MeasureGroupPopulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("criteria"))
      res.setCriteriaElement(parseString(json.get("criteria").getAsString()));
    if (json.has("_criteria"))
      parseElementProperties(json.getAsJsonObject("_criteria"), res.getCriteriaElement());
  }

  protected Measure.MeasureGroupStratifierComponent parseMeasureMeasureGroupStratifierComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
    Measure.MeasureGroupStratifierComponent res = new Measure.MeasureGroupStratifierComponent();
    parseMeasureMeasureGroupStratifierComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureMeasureGroupStratifierComponentProperties(JsonObject json, Measure owner, Measure.MeasureGroupStratifierComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("criteria"))
      res.setCriteriaElement(parseString(json.get("criteria").getAsString()));
    if (json.has("_criteria"))
      parseElementProperties(json.getAsJsonObject("_criteria"), res.getCriteriaElement());
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
  }

  protected Measure.MeasureSupplementalDataComponent parseMeasureMeasureSupplementalDataComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
    Measure.MeasureSupplementalDataComponent res = new Measure.MeasureSupplementalDataComponent();
    parseMeasureMeasureSupplementalDataComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureMeasureSupplementalDataComponentProperties(JsonObject json, Measure owner, Measure.MeasureSupplementalDataComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("usage")) {
      JsonArray array = json.getAsJsonArray("usage");
      for (int i = 0; i < array.size(); i++) {
        res.getUsage().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("criteria"))
      res.setCriteriaElement(parseString(json.get("criteria").getAsString()));
    if (json.has("_criteria"))
      parseElementProperties(json.getAsJsonObject("_criteria"), res.getCriteriaElement());
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
  }

  protected MeasureReport parseMeasureReport(JsonObject json) throws IOException, FHIRFormatError {
    MeasureReport res = new MeasureReport();
    parseMeasureReportProperties(json, res);
    return res;
  }

  protected void parseMeasureReportProperties(JsonObject json, MeasureReport res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MeasureReport.MeasureReportStatus.NULL, new MeasureReport.MeasureReportStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), MeasureReport.MeasureReportType.NULL, new MeasureReport.MeasureReportTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("measure"))
      res.setMeasure(parseReference(json.getAsJsonObject("measure")));
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("reportingOrganization"))
      res.setReportingOrganization(parseReference(json.getAsJsonObject("reportingOrganization")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseMeasureReportMeasureReportGroupComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("evaluatedResources"))
      res.setEvaluatedResources(parseReference(json.getAsJsonObject("evaluatedResources")));
  }

  protected MeasureReport.MeasureReportGroupComponent parseMeasureReportMeasureReportGroupComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupComponent res = new MeasureReport.MeasureReportGroupComponent();
    parseMeasureReportMeasureReportGroupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureReportMeasureReportGroupComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.MeasureReportGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMeasureReportMeasureReportGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("measureScore"))
      res.setMeasureScoreElement(parseDecimal(json.get("measureScore").getAsBigDecimal()));
    if (json.has("_measureScore"))
      parseElementProperties(json.getAsJsonObject("_measureScore"), res.getMeasureScoreElement());
    if (json.has("stratifier")) {
      JsonArray array = json.getAsJsonArray("stratifier");
      for (int i = 0; i < array.size(); i++) {
        res.getStratifier().add(parseMeasureReportMeasureReportGroupStratifierComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MeasureReport.MeasureReportGroupPopulationComponent parseMeasureReportMeasureReportGroupPopulationComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupPopulationComponent res = new MeasureReport.MeasureReportGroupPopulationComponent();
    parseMeasureReportMeasureReportGroupPopulationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureReportMeasureReportGroupPopulationComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.MeasureReportGroupPopulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("count"))
      res.setCountElement(parseInteger(json.get("count").getAsLong()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("patients"))
      res.setPatients(parseReference(json.getAsJsonObject("patients")));
  }

  protected MeasureReport.MeasureReportGroupStratifierComponent parseMeasureReportMeasureReportGroupStratifierComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupStratifierComponent res = new MeasureReport.MeasureReportGroupStratifierComponent();
    parseMeasureReportMeasureReportGroupStratifierComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureReportMeasureReportGroupStratifierComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.MeasureReportGroupStratifierComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("stratum")) {
      JsonArray array = json.getAsJsonArray("stratum");
      for (int i = 0; i < array.size(); i++) {
        res.getStratum().add(parseMeasureReportStratifierGroupComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MeasureReport.StratifierGroupComponent parseMeasureReportStratifierGroupComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.StratifierGroupComponent res = new MeasureReport.StratifierGroupComponent();
    parseMeasureReportStratifierGroupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureReportStratifierGroupComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.StratifierGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMeasureReportStratifierGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("measureScore"))
      res.setMeasureScoreElement(parseDecimal(json.get("measureScore").getAsBigDecimal()));
    if (json.has("_measureScore"))
      parseElementProperties(json.getAsJsonObject("_measureScore"), res.getMeasureScoreElement());
  }

  protected MeasureReport.StratifierGroupPopulationComponent parseMeasureReportStratifierGroupPopulationComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.StratifierGroupPopulationComponent res = new MeasureReport.StratifierGroupPopulationComponent();
    parseMeasureReportStratifierGroupPopulationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureReportStratifierGroupPopulationComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.StratifierGroupPopulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("count"))
      res.setCountElement(parseInteger(json.get("count").getAsLong()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("patients"))
      res.setPatients(parseReference(json.getAsJsonObject("patients")));
  }

  protected Media parseMedia(JsonObject json) throws IOException, FHIRFormatError {
    Media res = new Media();
    parseMediaProperties(json, res);
    return res;
  }

  protected void parseMediaProperties(JsonObject json, Media res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Media.DigitalMediaType.NULL, new Media.DigitalMediaTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("subtype"))
      res.setSubtype(parseCodeableConcept(json.getAsJsonObject("subtype")));
    if (json.has("view"))
      res.setView(parseCodeableConcept(json.getAsJsonObject("view")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("operator"))
      res.setOperator(parseReference(json.getAsJsonObject("operator")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("device"))
      res.setDevice(parseReference(json.getAsJsonObject("device")));
    if (json.has("height"))
      res.setHeightElement(parsePositiveInt(json.get("height").getAsString()));
    if (json.has("_height"))
      parseElementProperties(json.getAsJsonObject("_height"), res.getHeightElement());
    if (json.has("width"))
      res.setWidthElement(parsePositiveInt(json.get("width").getAsString()));
    if (json.has("_width"))
      parseElementProperties(json.getAsJsonObject("_width"), res.getWidthElement());
    if (json.has("frames"))
      res.setFramesElement(parsePositiveInt(json.get("frames").getAsString()));
    if (json.has("_frames"))
      parseElementProperties(json.getAsJsonObject("_frames"), res.getFramesElement());
    if (json.has("duration"))
      res.setDurationElement(parseUnsignedInt(json.get("duration").getAsString()));
    if (json.has("_duration"))
      parseElementProperties(json.getAsJsonObject("_duration"), res.getDurationElement());
    if (json.has("content"))
      res.setContent(parseAttachment(json.getAsJsonObject("content")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Medication parseMedication(JsonObject json) throws IOException, FHIRFormatError {
    Medication res = new Medication();
    parseMedicationProperties(json, res);
    return res;
  }

  protected void parseMedicationProperties(JsonObject json, Medication res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Medication.MedicationStatus.NULL, new Medication.MedicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("isBrand"))
      res.setIsBrandElement(parseBoolean(json.get("isBrand").getAsBoolean()));
    if (json.has("_isBrand"))
      parseElementProperties(json.getAsJsonObject("_isBrand"), res.getIsBrandElement());
    if (json.has("isOverTheCounter"))
      res.setIsOverTheCounterElement(parseBoolean(json.get("isOverTheCounter").getAsBoolean()));
    if (json.has("_isOverTheCounter"))
      parseElementProperties(json.getAsJsonObject("_isOverTheCounter"), res.getIsOverTheCounterElement());
    if (json.has("manufacturer"))
      res.setManufacturer(parseReference(json.getAsJsonObject("manufacturer")));
    if (json.has("form"))
      res.setForm(parseCodeableConcept(json.getAsJsonObject("form")));
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseMedicationMedicationIngredientComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("package"))
      res.setPackage(parseMedicationMedicationPackageComponent(json.getAsJsonObject("package"), res));
    if (json.has("image")) {
      JsonArray array = json.getAsJsonArray("image");
      for (int i = 0; i < array.size(); i++) {
        res.getImage().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Medication.MedicationIngredientComponent parseMedicationMedicationIngredientComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
    Medication.MedicationIngredientComponent res = new Medication.MedicationIngredientComponent();
    parseMedicationMedicationIngredientComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationMedicationIngredientComponentProperties(JsonObject json, Medication owner, Medication.MedicationIngredientComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    Type item = parseType("item", json);
    if (item != null)
      res.setItem(item);
    if (json.has("isActive"))
      res.setIsActiveElement(parseBoolean(json.get("isActive").getAsBoolean()));
    if (json.has("_isActive"))
      parseElementProperties(json.getAsJsonObject("_isActive"), res.getIsActiveElement());
    if (json.has("amount"))
      res.setAmount(parseRatio(json.getAsJsonObject("amount")));
  }

  protected Medication.MedicationPackageComponent parseMedicationMedicationPackageComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
    Medication.MedicationPackageComponent res = new Medication.MedicationPackageComponent();
    parseMedicationMedicationPackageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationMedicationPackageComponentProperties(JsonObject json, Medication owner, Medication.MedicationPackageComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("container"))
      res.setContainer(parseCodeableConcept(json.getAsJsonObject("container")));
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseMedicationMedicationPackageContentComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("batch")) {
      JsonArray array = json.getAsJsonArray("batch");
      for (int i = 0; i < array.size(); i++) {
        res.getBatch().add(parseMedicationMedicationPackageBatchComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Medication.MedicationPackageContentComponent parseMedicationMedicationPackageContentComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
    Medication.MedicationPackageContentComponent res = new Medication.MedicationPackageContentComponent();
    parseMedicationMedicationPackageContentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationMedicationPackageContentComponentProperties(JsonObject json, Medication owner, Medication.MedicationPackageContentComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    Type item = parseType("item", json);
    if (item != null)
      res.setItem(item);
    if (json.has("amount"))
      res.setAmount(parseSimpleQuantity(json.getAsJsonObject("amount")));
  }

  protected Medication.MedicationPackageBatchComponent parseMedicationMedicationPackageBatchComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
    Medication.MedicationPackageBatchComponent res = new Medication.MedicationPackageBatchComponent();
    parseMedicationMedicationPackageBatchComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationMedicationPackageBatchComponentProperties(JsonObject json, Medication owner, Medication.MedicationPackageBatchComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDateTime(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
  }

  protected MedicationAdministration parseMedicationAdministration(JsonObject json) throws IOException, FHIRFormatError {
    MedicationAdministration res = new MedicationAdministration();
    parseMedicationAdministrationProperties(json, res);
    return res;
  }

  protected void parseMedicationAdministrationProperties(JsonObject json, MedicationAdministration res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        res.getDefinition().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationAdministration.MedicationAdministrationStatus.NULL, new MedicationAdministration.MedicationAdministrationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseMedicationAdministrationMedicationAdministrationPerformerComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("notGiven"))
      res.setNotGivenElement(parseBoolean(json.get("notGiven").getAsBoolean()));
    if (json.has("_notGiven"))
      parseElementProperties(json.getAsJsonObject("_notGiven"), res.getNotGivenElement());
    if (json.has("reasonNotGiven")) {
      JsonArray array = json.getAsJsonArray("reasonNotGiven");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonNotGiven().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("prescription"))
      res.setPrescription(parseReference(json.getAsJsonObject("prescription")));
    if (json.has("device")) {
      JsonArray array = json.getAsJsonArray("device");
      for (int i = 0; i < array.size(); i++) {
        res.getDevice().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dosage"))
      res.setDosage(parseMedicationAdministrationMedicationAdministrationDosageComponent(json.getAsJsonObject("dosage"), res));
    if (json.has("eventHistory")) {
      JsonArray array = json.getAsJsonArray("eventHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getEventHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationAdministration.MedicationAdministrationPerformerComponent parseMedicationAdministrationMedicationAdministrationPerformerComponent(JsonObject json, MedicationAdministration owner) throws IOException, FHIRFormatError {
    MedicationAdministration.MedicationAdministrationPerformerComponent res = new MedicationAdministration.MedicationAdministrationPerformerComponent();
    parseMedicationAdministrationMedicationAdministrationPerformerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationAdministrationMedicationAdministrationPerformerComponentProperties(JsonObject json, MedicationAdministration owner, MedicationAdministration.MedicationAdministrationPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(json.getAsJsonObject("onBehalfOf")));
  }

  protected MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationMedicationAdministrationDosageComponent(JsonObject json, MedicationAdministration owner) throws IOException, FHIRFormatError {
    MedicationAdministration.MedicationAdministrationDosageComponent res = new MedicationAdministration.MedicationAdministrationDosageComponent();
    parseMedicationAdministrationMedicationAdministrationDosageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationAdministrationMedicationAdministrationDosageComponentProperties(JsonObject json, MedicationAdministration owner, MedicationAdministration.MedicationAdministrationDosageComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("site"))
      res.setSite(parseCodeableConcept(json.getAsJsonObject("site")));
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(json.getAsJsonObject("route")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("dose"))
      res.setDose(parseSimpleQuantity(json.getAsJsonObject("dose")));
    Type rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
  }

  protected MedicationDispense parseMedicationDispense(JsonObject json) throws IOException, FHIRFormatError {
    MedicationDispense res = new MedicationDispense();
    parseMedicationDispenseProperties(json, res);
    return res;
  }

  protected void parseMedicationDispenseProperties(JsonObject json, MedicationDispense res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationDispense.MedicationDispenseStatus.NULL, new MedicationDispense.MedicationDispenseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseMedicationDispenseMedicationDispensePerformerComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("authorizingPrescription")) {
      JsonArray array = json.getAsJsonArray("authorizingPrescription");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthorizingPrescription().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("daysSupply"))
      res.setDaysSupply(parseSimpleQuantity(json.getAsJsonObject("daysSupply")));
    if (json.has("whenPrepared"))
      res.setWhenPreparedElement(parseDateTime(json.get("whenPrepared").getAsString()));
    if (json.has("_whenPrepared"))
      parseElementProperties(json.getAsJsonObject("_whenPrepared"), res.getWhenPreparedElement());
    if (json.has("whenHandedOver"))
      res.setWhenHandedOverElement(parseDateTime(json.get("whenHandedOver").getAsString()));
    if (json.has("_whenHandedOver"))
      parseElementProperties(json.getAsJsonObject("_whenHandedOver"), res.getWhenHandedOverElement());
    if (json.has("destination"))
      res.setDestination(parseReference(json.getAsJsonObject("destination")));
    if (json.has("receiver")) {
      JsonArray array = json.getAsJsonArray("receiver");
      for (int i = 0; i < array.size(); i++) {
        res.getReceiver().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dosageInstruction")) {
      JsonArray array = json.getAsJsonArray("dosageInstruction");
      for (int i = 0; i < array.size(); i++) {
        res.getDosageInstruction().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("substitution"))
      res.setSubstitution(parseMedicationDispenseMedicationDispenseSubstitutionComponent(json.getAsJsonObject("substitution"), res));
    if (json.has("detectedIssue")) {
      JsonArray array = json.getAsJsonArray("detectedIssue");
      for (int i = 0; i < array.size(); i++) {
        res.getDetectedIssue().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("notDone"))
      res.setNotDoneElement(parseBoolean(json.get("notDone").getAsBoolean()));
    if (json.has("_notDone"))
      parseElementProperties(json.getAsJsonObject("_notDone"), res.getNotDoneElement());
    Type notDoneReason = parseType("notDoneReason", json);
    if (notDoneReason != null)
      res.setNotDoneReason(notDoneReason);
    if (json.has("eventHistory")) {
      JsonArray array = json.getAsJsonArray("eventHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getEventHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationDispense.MedicationDispensePerformerComponent parseMedicationDispenseMedicationDispensePerformerComponent(JsonObject json, MedicationDispense owner) throws IOException, FHIRFormatError {
    MedicationDispense.MedicationDispensePerformerComponent res = new MedicationDispense.MedicationDispensePerformerComponent();
    parseMedicationDispenseMedicationDispensePerformerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationDispenseMedicationDispensePerformerComponentProperties(JsonObject json, MedicationDispense owner, MedicationDispense.MedicationDispensePerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(json.getAsJsonObject("onBehalfOf")));
  }

  protected MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseMedicationDispenseSubstitutionComponent(JsonObject json, MedicationDispense owner) throws IOException, FHIRFormatError {
    MedicationDispense.MedicationDispenseSubstitutionComponent res = new MedicationDispense.MedicationDispenseSubstitutionComponent();
    parseMedicationDispenseMedicationDispenseSubstitutionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationDispenseMedicationDispenseSubstitutionComponentProperties(JsonObject json, MedicationDispense owner, MedicationDispense.MedicationDispenseSubstitutionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("wasSubstituted"))
      res.setWasSubstitutedElement(parseBoolean(json.get("wasSubstituted").getAsBoolean()));
    if (json.has("_wasSubstituted"))
      parseElementProperties(json.getAsJsonObject("_wasSubstituted"), res.getWasSubstitutedElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("responsibleParty")) {
      JsonArray array = json.getAsJsonArray("responsibleParty");
      for (int i = 0; i < array.size(); i++) {
        res.getResponsibleParty().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationRequest parseMedicationRequest(JsonObject json) throws IOException, FHIRFormatError {
    MedicationRequest res = new MedicationRequest();
    parseMedicationRequestProperties(json, res);
    return res;
  }

  protected void parseMedicationRequestProperties(JsonObject json, MedicationRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        res.getDefinition().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(json.getAsJsonObject("groupIdentifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationRequest.MedicationRequestStatus.NULL, new MedicationRequest.MedicationRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), MedicationRequest.MedicationRequestIntent.NULL, new MedicationRequest.MedicationRequestIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), MedicationRequest.MedicationRequestPriority.NULL, new MedicationRequest.MedicationRequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
    if (json.has("requester"))
      res.setRequester(parseMedicationRequestMedicationRequestRequesterComponent(json.getAsJsonObject("requester"), res));
    if (json.has("recorder"))
      res.setRecorder(parseReference(json.getAsJsonObject("recorder")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dosageInstruction")) {
      JsonArray array = json.getAsJsonArray("dosageInstruction");
      for (int i = 0; i < array.size(); i++) {
        res.getDosageInstruction().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dispenseRequest"))
      res.setDispenseRequest(parseMedicationRequestMedicationRequestDispenseRequestComponent(json.getAsJsonObject("dispenseRequest"), res));
    if (json.has("substitution"))
      res.setSubstitution(parseMedicationRequestMedicationRequestSubstitutionComponent(json.getAsJsonObject("substitution"), res));
    if (json.has("priorPrescription"))
      res.setPriorPrescription(parseReference(json.getAsJsonObject("priorPrescription")));
    if (json.has("detectedIssue")) {
      JsonArray array = json.getAsJsonArray("detectedIssue");
      for (int i = 0; i < array.size(); i++) {
        res.getDetectedIssue().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("eventHistory")) {
      JsonArray array = json.getAsJsonArray("eventHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getEventHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationRequest.MedicationRequestRequesterComponent parseMedicationRequestMedicationRequestRequesterComponent(JsonObject json, MedicationRequest owner) throws IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestRequesterComponent res = new MedicationRequest.MedicationRequestRequesterComponent();
    parseMedicationRequestMedicationRequestRequesterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationRequestMedicationRequestRequesterComponentProperties(JsonObject json, MedicationRequest owner, MedicationRequest.MedicationRequestRequesterComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("agent"))
      res.setAgent(parseReference(json.getAsJsonObject("agent")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(json.getAsJsonObject("onBehalfOf")));
  }

  protected MedicationRequest.MedicationRequestDispenseRequestComponent parseMedicationRequestMedicationRequestDispenseRequestComponent(JsonObject json, MedicationRequest owner) throws IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestDispenseRequestComponent res = new MedicationRequest.MedicationRequestDispenseRequestComponent();
    parseMedicationRequestMedicationRequestDispenseRequestComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationRequestMedicationRequestDispenseRequestComponentProperties(JsonObject json, MedicationRequest owner, MedicationRequest.MedicationRequestDispenseRequestComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("validityPeriod"))
      res.setValidityPeriod(parsePeriod(json.getAsJsonObject("validityPeriod")));
    if (json.has("numberOfRepeatsAllowed"))
      res.setNumberOfRepeatsAllowedElement(parsePositiveInt(json.get("numberOfRepeatsAllowed").getAsString()));
    if (json.has("_numberOfRepeatsAllowed"))
      parseElementProperties(json.getAsJsonObject("_numberOfRepeatsAllowed"), res.getNumberOfRepeatsAllowedElement());
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("expectedSupplyDuration"))
      res.setExpectedSupplyDuration(parseDuration(json.getAsJsonObject("expectedSupplyDuration")));
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
  }

  protected MedicationRequest.MedicationRequestSubstitutionComponent parseMedicationRequestMedicationRequestSubstitutionComponent(JsonObject json, MedicationRequest owner) throws IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestSubstitutionComponent res = new MedicationRequest.MedicationRequestSubstitutionComponent();
    parseMedicationRequestMedicationRequestSubstitutionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationRequestMedicationRequestSubstitutionComponentProperties(JsonObject json, MedicationRequest owner, MedicationRequest.MedicationRequestSubstitutionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("allowed"))
      res.setAllowedElement(parseBoolean(json.get("allowed").getAsBoolean()));
    if (json.has("_allowed"))
      parseElementProperties(json.getAsJsonObject("_allowed"), res.getAllowedElement());
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
  }

  protected MedicationStatement parseMedicationStatement(JsonObject json) throws IOException, FHIRFormatError {
    MedicationStatement res = new MedicationStatement();
    parseMedicationStatementProperties(json, res);
    return res;
  }

  protected void parseMedicationStatementProperties(JsonObject json, MedicationStatement res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationStatement.MedicationStatementStatus.NULL, new MedicationStatement.MedicationStatementStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("dateAsserted"))
      res.setDateAssertedElement(parseDateTime(json.get("dateAsserted").getAsString()));
    if (json.has("_dateAsserted"))
      parseElementProperties(json.getAsJsonObject("_dateAsserted"), res.getDateAssertedElement());
    if (json.has("informationSource"))
      res.setInformationSource(parseReference(json.getAsJsonObject("informationSource")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("derivedFrom")) {
      JsonArray array = json.getAsJsonArray("derivedFrom");
      for (int i = 0; i < array.size(); i++) {
        res.getDerivedFrom().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("taken"))
      res.setTakenElement(parseEnumeration(json.get("taken").getAsString(), MedicationStatement.MedicationStatementTaken.NULL, new MedicationStatement.MedicationStatementTakenEnumFactory()));
    if (json.has("_taken"))
      parseElementProperties(json.getAsJsonObject("_taken"), res.getTakenElement());
    if (json.has("reasonNotTaken")) {
      JsonArray array = json.getAsJsonArray("reasonNotTaken");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonNotTaken().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dosage")) {
      JsonArray array = json.getAsJsonArray("dosage");
      for (int i = 0; i < array.size(); i++) {
        res.getDosage().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MessageDefinition parseMessageDefinition(JsonObject json) throws IOException, FHIRFormatError {
    MessageDefinition res = new MessageDefinition();
    parseMessageDefinitionProperties(json, res);
    return res;
  }

  protected void parseMessageDefinitionProperties(JsonObject json, MessageDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("base"))
      res.setBase(parseReference(json.getAsJsonObject("base")));
    if (json.has("parent")) {
      JsonArray array = json.getAsJsonArray("parent");
      for (int i = 0; i < array.size(); i++) {
        res.getParent().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("event"))
      res.setEvent(parseCoding(json.getAsJsonObject("event")));
    if (json.has("category"))
      res.setCategoryElement(parseEnumeration(json.get("category").getAsString(), MessageDefinition.MessageSignificanceCategory.NULL, new MessageDefinition.MessageSignificanceCategoryEnumFactory()));
    if (json.has("_category"))
      parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
    if (json.has("focus")) {
      JsonArray array = json.getAsJsonArray("focus");
      for (int i = 0; i < array.size(); i++) {
        res.getFocus().add(parseMessageDefinitionMessageDefinitionFocusComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("responseRequired"))
      res.setResponseRequiredElement(parseBoolean(json.get("responseRequired").getAsBoolean()));
    if (json.has("_responseRequired"))
      parseElementProperties(json.getAsJsonObject("_responseRequired"), res.getResponseRequiredElement());
    if (json.has("allowedResponse")) {
      JsonArray array = json.getAsJsonArray("allowedResponse");
      for (int i = 0; i < array.size(); i++) {
        res.getAllowedResponse().add(parseMessageDefinitionMessageDefinitionAllowedResponseComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected MessageDefinition.MessageDefinitionFocusComponent parseMessageDefinitionMessageDefinitionFocusComponent(JsonObject json, MessageDefinition owner) throws IOException, FHIRFormatError {
    MessageDefinition.MessageDefinitionFocusComponent res = new MessageDefinition.MessageDefinitionFocusComponent();
    parseMessageDefinitionMessageDefinitionFocusComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMessageDefinitionMessageDefinitionFocusComponentProperties(JsonObject json, MessageDefinition owner, MessageDefinition.MessageDefinitionFocusComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("profile"))
      res.setProfile(parseReference(json.getAsJsonObject("profile")));
    if (json.has("min"))
      res.setMinElement(parseUnsignedInt(json.get("min").getAsString()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
  }

  protected MessageDefinition.MessageDefinitionAllowedResponseComponent parseMessageDefinitionMessageDefinitionAllowedResponseComponent(JsonObject json, MessageDefinition owner) throws IOException, FHIRFormatError {
    MessageDefinition.MessageDefinitionAllowedResponseComponent res = new MessageDefinition.MessageDefinitionAllowedResponseComponent();
    parseMessageDefinitionMessageDefinitionAllowedResponseComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMessageDefinitionMessageDefinitionAllowedResponseComponentProperties(JsonObject json, MessageDefinition owner, MessageDefinition.MessageDefinitionAllowedResponseComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("message"))
      res.setMessage(parseReference(json.getAsJsonObject("message")));
    if (json.has("situation"))
      res.setSituationElement(parseMarkdown(json.get("situation").getAsString()));
    if (json.has("_situation"))
      parseElementProperties(json.getAsJsonObject("_situation"), res.getSituationElement());
  }

  protected MessageHeader parseMessageHeader(JsonObject json) throws IOException, FHIRFormatError {
    MessageHeader res = new MessageHeader();
    parseMessageHeaderProperties(json, res);
    return res;
  }

  protected void parseMessageHeaderProperties(JsonObject json, MessageHeader res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("event"))
      res.setEvent(parseCoding(json.getAsJsonObject("event")));
    if (json.has("destination")) {
      JsonArray array = json.getAsJsonArray("destination");
      for (int i = 0; i < array.size(); i++) {
        res.getDestination().add(parseMessageHeaderMessageDestinationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("receiver"))
      res.setReceiver(parseReference(json.getAsJsonObject("receiver")));
    if (json.has("sender"))
      res.setSender(parseReference(json.getAsJsonObject("sender")));
    if (json.has("timestamp"))
      res.setTimestampElement(parseInstant(json.get("timestamp").getAsString()));
    if (json.has("_timestamp"))
      parseElementProperties(json.getAsJsonObject("_timestamp"), res.getTimestampElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(json.getAsJsonObject("enterer")));
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("source"))
      res.setSource(parseMessageHeaderMessageSourceComponent(json.getAsJsonObject("source"), res));
    if (json.has("responsible"))
      res.setResponsible(parseReference(json.getAsJsonObject("responsible")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
    if (json.has("response"))
      res.setResponse(parseMessageHeaderMessageHeaderResponseComponent(json.getAsJsonObject("response"), res));
    if (json.has("focus")) {
      JsonArray array = json.getAsJsonArray("focus");
      for (int i = 0; i < array.size(); i++) {
        res.getFocus().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
    MessageHeader.MessageDestinationComponent res = new MessageHeader.MessageDestinationComponent();
    parseMessageHeaderMessageDestinationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMessageHeaderMessageDestinationComponentProperties(JsonObject json, MessageHeader owner, MessageHeader.MessageDestinationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
    if (json.has("endpoint"))
      res.setEndpointElement(parseUri(json.get("endpoint").getAsString()));
    if (json.has("_endpoint"))
      parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
  }

  protected MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
    MessageHeader.MessageSourceComponent res = new MessageHeader.MessageSourceComponent();
    parseMessageHeaderMessageSourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMessageHeaderMessageSourceComponentProperties(JsonObject json, MessageHeader owner, MessageHeader.MessageSourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("software"))
      res.setSoftwareElement(parseString(json.get("software").getAsString()));
    if (json.has("_software"))
      parseElementProperties(json.getAsJsonObject("_software"), res.getSoftwareElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("contact"))
      res.setContact(parseContactPoint(json.getAsJsonObject("contact")));
    if (json.has("endpoint"))
      res.setEndpointElement(parseUri(json.get("endpoint").getAsString()));
    if (json.has("_endpoint"))
      parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
  }

  protected MessageHeader.MessageHeaderResponseComponent parseMessageHeaderMessageHeaderResponseComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
    MessageHeader.MessageHeaderResponseComponent res = new MessageHeader.MessageHeaderResponseComponent();
    parseMessageHeaderMessageHeaderResponseComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMessageHeaderMessageHeaderResponseComponentProperties(JsonObject json, MessageHeader owner, MessageHeader.MessageHeaderResponseComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifierElement(parseId(json.get("identifier").getAsString()));
    if (json.has("_identifier"))
      parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), MessageHeader.ResponseType.NULL, new MessageHeader.ResponseTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("details"))
      res.setDetails(parseReference(json.getAsJsonObject("details")));
  }

  protected NamingSystem parseNamingSystem(JsonObject json) throws IOException, FHIRFormatError {
    NamingSystem res = new NamingSystem();
    parseNamingSystemProperties(json, res);
    return res;
  }

  protected void parseNamingSystemProperties(JsonObject json, NamingSystem res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), NamingSystem.NamingSystemType.NULL, new NamingSystem.NamingSystemTypeEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("responsible"))
      res.setResponsibleElement(parseString(json.get("responsible").getAsString()));
    if (json.has("_responsible"))
      parseElementProperties(json.getAsJsonObject("_responsible"), res.getResponsibleElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("uniqueId")) {
      JsonArray array = json.getAsJsonArray("uniqueId");
      for (int i = 0; i < array.size(); i++) {
        res.getUniqueId().add(parseNamingSystemNamingSystemUniqueIdComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("replacedBy"))
      res.setReplacedBy(parseReference(json.getAsJsonObject("replacedBy")));
  }

  protected NamingSystem.NamingSystemUniqueIdComponent parseNamingSystemNamingSystemUniqueIdComponent(JsonObject json, NamingSystem owner) throws IOException, FHIRFormatError {
    NamingSystem.NamingSystemUniqueIdComponent res = new NamingSystem.NamingSystemUniqueIdComponent();
    parseNamingSystemNamingSystemUniqueIdComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNamingSystemNamingSystemUniqueIdComponentProperties(JsonObject json, NamingSystem owner, NamingSystem.NamingSystemUniqueIdComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), NamingSystem.NamingSystemIdentifierType.NULL, new NamingSystem.NamingSystemIdentifierTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("preferred"))
      res.setPreferredElement(parseBoolean(json.get("preferred").getAsBoolean()));
    if (json.has("_preferred"))
      parseElementProperties(json.getAsJsonObject("_preferred"), res.getPreferredElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected NutritionOrder parseNutritionOrder(JsonObject json) throws IOException, FHIRFormatError {
    NutritionOrder res = new NutritionOrder();
    parseNutritionOrderProperties(json, res);
    return res;
  }

  protected void parseNutritionOrderProperties(JsonObject json, NutritionOrder res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), NutritionOrder.NutritionOrderStatus.NULL, new NutritionOrder.NutritionOrderStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("dateTime"))
      res.setDateTimeElement(parseDateTime(json.get("dateTime").getAsString()));
    if (json.has("_dateTime"))
      parseElementProperties(json.getAsJsonObject("_dateTime"), res.getDateTimeElement());
    if (json.has("orderer"))
      res.setOrderer(parseReference(json.getAsJsonObject("orderer")));
    if (json.has("allergyIntolerance")) {
      JsonArray array = json.getAsJsonArray("allergyIntolerance");
      for (int i = 0; i < array.size(); i++) {
        res.getAllergyIntolerance().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("foodPreferenceModifier")) {
      JsonArray array = json.getAsJsonArray("foodPreferenceModifier");
      for (int i = 0; i < array.size(); i++) {
        res.getFoodPreferenceModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("excludeFoodModifier")) {
      JsonArray array = json.getAsJsonArray("excludeFoodModifier");
      for (int i = 0; i < array.size(); i++) {
        res.getExcludeFoodModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("oralDiet"))
      res.setOralDiet(parseNutritionOrderNutritionOrderOralDietComponent(json.getAsJsonObject("oralDiet"), res));
    if (json.has("supplement")) {
      JsonArray array = json.getAsJsonArray("supplement");
      for (int i = 0; i < array.size(); i++) {
        res.getSupplement().add(parseNutritionOrderNutritionOrderSupplementComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("enteralFormula"))
      res.setEnteralFormula(parseNutritionOrderNutritionOrderEnteralFormulaComponent(json.getAsJsonObject("enteralFormula"), res));
  }

  protected NutritionOrder.NutritionOrderOralDietComponent parseNutritionOrderNutritionOrderOralDietComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietComponent res = new NutritionOrder.NutritionOrderOralDietComponent();
    parseNutritionOrderNutritionOrderOralDietComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderOralDietComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("schedule")) {
      JsonArray array = json.getAsJsonArray("schedule");
      for (int i = 0; i < array.size(); i++) {
        res.getSchedule().add(parseTiming(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("nutrient")) {
      JsonArray array = json.getAsJsonArray("nutrient");
      for (int i = 0; i < array.size(); i++) {
        res.getNutrient().add(parseNutritionOrderNutritionOrderOralDietNutrientComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("texture")) {
      JsonArray array = json.getAsJsonArray("texture");
      for (int i = 0; i < array.size(); i++) {
        res.getTexture().add(parseNutritionOrderNutritionOrderOralDietTextureComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("fluidConsistencyType")) {
      JsonArray array = json.getAsJsonArray("fluidConsistencyType");
      for (int i = 0; i < array.size(); i++) {
        res.getFluidConsistencyType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instruction"))
      res.setInstructionElement(parseString(json.get("instruction").getAsString()));
    if (json.has("_instruction"))
      parseElementProperties(json.getAsJsonObject("_instruction"), res.getInstructionElement());
  }

  protected NutritionOrder.NutritionOrderOralDietNutrientComponent parseNutritionOrderNutritionOrderOralDietNutrientComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietNutrientComponent res = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
    parseNutritionOrderNutritionOrderOralDietNutrientComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderOralDietNutrientComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietNutrientComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("modifier"))
      res.setModifier(parseCodeableConcept(json.getAsJsonObject("modifier")));
    if (json.has("amount"))
      res.setAmount(parseSimpleQuantity(json.getAsJsonObject("amount")));
  }

  protected NutritionOrder.NutritionOrderOralDietTextureComponent parseNutritionOrderNutritionOrderOralDietTextureComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietTextureComponent res = new NutritionOrder.NutritionOrderOralDietTextureComponent();
    parseNutritionOrderNutritionOrderOralDietTextureComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderOralDietTextureComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietTextureComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("modifier"))
      res.setModifier(parseCodeableConcept(json.getAsJsonObject("modifier")));
    if (json.has("foodType"))
      res.setFoodType(parseCodeableConcept(json.getAsJsonObject("foodType")));
  }

  protected NutritionOrder.NutritionOrderSupplementComponent parseNutritionOrderNutritionOrderSupplementComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderSupplementComponent res = new NutritionOrder.NutritionOrderSupplementComponent();
    parseNutritionOrderNutritionOrderSupplementComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderSupplementComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderSupplementComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("productName"))
      res.setProductNameElement(parseString(json.get("productName").getAsString()));
    if (json.has("_productName"))
      parseElementProperties(json.getAsJsonObject("_productName"), res.getProductNameElement());
    if (json.has("schedule")) {
      JsonArray array = json.getAsJsonArray("schedule");
      for (int i = 0; i < array.size(); i++) {
        res.getSchedule().add(parseTiming(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("instruction"))
      res.setInstructionElement(parseString(json.get("instruction").getAsString()));
    if (json.has("_instruction"))
      parseElementProperties(json.getAsJsonObject("_instruction"), res.getInstructionElement());
  }

  protected NutritionOrder.NutritionOrderEnteralFormulaComponent parseNutritionOrderNutritionOrderEnteralFormulaComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderEnteralFormulaComponent res = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
    parseNutritionOrderNutritionOrderEnteralFormulaComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderEnteralFormulaComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderEnteralFormulaComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("baseFormulaType"))
      res.setBaseFormulaType(parseCodeableConcept(json.getAsJsonObject("baseFormulaType")));
    if (json.has("baseFormulaProductName"))
      res.setBaseFormulaProductNameElement(parseString(json.get("baseFormulaProductName").getAsString()));
    if (json.has("_baseFormulaProductName"))
      parseElementProperties(json.getAsJsonObject("_baseFormulaProductName"), res.getBaseFormulaProductNameElement());
    if (json.has("additiveType"))
      res.setAdditiveType(parseCodeableConcept(json.getAsJsonObject("additiveType")));
    if (json.has("additiveProductName"))
      res.setAdditiveProductNameElement(parseString(json.get("additiveProductName").getAsString()));
    if (json.has("_additiveProductName"))
      parseElementProperties(json.getAsJsonObject("_additiveProductName"), res.getAdditiveProductNameElement());
    if (json.has("caloricDensity"))
      res.setCaloricDensity(parseSimpleQuantity(json.getAsJsonObject("caloricDensity")));
    if (json.has("routeofAdministration"))
      res.setRouteofAdministration(parseCodeableConcept(json.getAsJsonObject("routeofAdministration")));
    if (json.has("administration")) {
      JsonArray array = json.getAsJsonArray("administration");
      for (int i = 0; i < array.size(); i++) {
        res.getAdministration().add(parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("maxVolumeToDeliver"))
      res.setMaxVolumeToDeliver(parseSimpleQuantity(json.getAsJsonObject("maxVolumeToDeliver")));
    if (json.has("administrationInstruction"))
      res.setAdministrationInstructionElement(parseString(json.get("administrationInstruction").getAsString()));
    if (json.has("_administrationInstruction"))
      parseElementProperties(json.getAsJsonObject("_administrationInstruction"), res.getAdministrationInstructionElement());
  }

  protected NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
    parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("schedule"))
      res.setSchedule(parseTiming(json.getAsJsonObject("schedule")));
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    Type rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
  }

  protected Observation parseObservation(JsonObject json) throws IOException, FHIRFormatError {
    Observation res = new Observation();
    parseObservationProperties(json, res);
    return res;
  }

  protected void parseObservationProperties(JsonObject json, Observation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Observation.ObservationStatus.NULL, new Observation.ObservationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("issued"))
      res.setIssuedElement(parseInstant(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("dataAbsentReason"))
      res.setDataAbsentReason(parseCodeableConcept(json.getAsJsonObject("dataAbsentReason")));
    if (json.has("interpretation"))
      res.setInterpretation(parseCodeableConcept(json.getAsJsonObject("interpretation")));
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("specimen"))
      res.setSpecimen(parseReference(json.getAsJsonObject("specimen")));
    if (json.has("device"))
      res.setDevice(parseReference(json.getAsJsonObject("device")));
    if (json.has("referenceRange")) {
      JsonArray array = json.getAsJsonArray("referenceRange");
      for (int i = 0; i < array.size(); i++) {
        res.getReferenceRange().add(parseObservationObservationReferenceRangeComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseObservationObservationRelatedComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("component")) {
      JsonArray array = json.getAsJsonArray("component");
      for (int i = 0; i < array.size(); i++) {
        res.getComponent().add(parseObservationObservationComponentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Observation.ObservationReferenceRangeComponent parseObservationObservationReferenceRangeComponent(JsonObject json, Observation owner) throws IOException, FHIRFormatError {
    Observation.ObservationReferenceRangeComponent res = new Observation.ObservationReferenceRangeComponent();
    parseObservationObservationReferenceRangeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseObservationObservationReferenceRangeComponentProperties(JsonObject json, Observation owner, Observation.ObservationReferenceRangeComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("low"))
      res.setLow(parseSimpleQuantity(json.getAsJsonObject("low")));
    if (json.has("high"))
      res.setHigh(parseSimpleQuantity(json.getAsJsonObject("high")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("appliesTo")) {
      JsonArray array = json.getAsJsonArray("appliesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getAppliesTo().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("age"))
      res.setAge(parseRange(json.getAsJsonObject("age")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
  }

  protected Observation.ObservationRelatedComponent parseObservationObservationRelatedComponent(JsonObject json, Observation owner) throws IOException, FHIRFormatError {
    Observation.ObservationRelatedComponent res = new Observation.ObservationRelatedComponent();
    parseObservationObservationRelatedComponentProperties(json, owner, res);
    return res;
  }

  protected void parseObservationObservationRelatedComponentProperties(JsonObject json, Observation owner, Observation.ObservationRelatedComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Observation.ObservationRelationshipType.NULL, new Observation.ObservationRelationshipTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
  }

  protected Observation.ObservationComponentComponent parseObservationObservationComponentComponent(JsonObject json, Observation owner) throws IOException, FHIRFormatError {
    Observation.ObservationComponentComponent res = new Observation.ObservationComponentComponent();
    parseObservationObservationComponentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseObservationObservationComponentComponentProperties(JsonObject json, Observation owner, Observation.ObservationComponentComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("dataAbsentReason"))
      res.setDataAbsentReason(parseCodeableConcept(json.getAsJsonObject("dataAbsentReason")));
    if (json.has("interpretation"))
      res.setInterpretation(parseCodeableConcept(json.getAsJsonObject("interpretation")));
    if (json.has("referenceRange")) {
      JsonArray array = json.getAsJsonArray("referenceRange");
      for (int i = 0; i < array.size(); i++) {
        res.getReferenceRange().add(parseObservationObservationReferenceRangeComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected OperationDefinition parseOperationDefinition(JsonObject json) throws IOException, FHIRFormatError {
    OperationDefinition res = new OperationDefinition();
    parseOperationDefinitionProperties(json, res);
    return res;
  }

  protected void parseOperationDefinitionProperties(JsonObject json, OperationDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), OperationDefinition.OperationKind.NULL, new OperationDefinition.OperationKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("idempotent"))
      res.setIdempotentElement(parseBoolean(json.get("idempotent").getAsBoolean()));
    if (json.has("_idempotent"))
      parseElementProperties(json.getAsJsonObject("_idempotent"), res.getIdempotentElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("base"))
      res.setBase(parseReference(json.getAsJsonObject("base")));
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseCode(array.get(i).getAsString()));
      }
    };
    if (json.has("_resource")) {
      JsonArray array = json.getAsJsonArray("_resource");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getResource().size())
          res.getResource().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getResource().get(i));
      }
    };
    if (json.has("system"))
      res.setSystemElement(parseBoolean(json.get("system").getAsBoolean()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("type"))
      res.setTypeElement(parseBoolean(json.get("type").getAsBoolean()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("instance"))
      res.setInstanceElement(parseBoolean(json.get("instance").getAsBoolean()));
    if (json.has("_instance"))
      parseElementProperties(json.getAsJsonObject("_instance"), res.getInstanceElement());
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseOperationDefinitionOperationDefinitionParameterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("overload")) {
      JsonArray array = json.getAsJsonArray("overload");
      for (int i = 0; i < array.size(); i++) {
        res.getOverload().add(parseOperationDefinitionOperationDefinitionOverloadComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected OperationDefinition.OperationDefinitionParameterComponent parseOperationDefinitionOperationDefinitionParameterComponent(JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionParameterComponent res = new OperationDefinition.OperationDefinitionParameterComponent();
    parseOperationDefinitionOperationDefinitionParameterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseOperationDefinitionOperationDefinitionParameterComponentProperties(JsonObject json, OperationDefinition owner, OperationDefinition.OperationDefinitionParameterComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseCode(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), OperationDefinition.OperationParameterUse.NULL, new OperationDefinition.OperationParameterUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("searchType"))
      res.setSearchTypeElement(parseEnumeration(json.get("searchType").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
    if (json.has("_searchType"))
      parseElementProperties(json.getAsJsonObject("_searchType"), res.getSearchTypeElement());
    if (json.has("profile"))
      res.setProfile(parseReference(json.getAsJsonObject("profile")));
    if (json.has("binding"))
      res.setBinding(parseOperationDefinitionOperationDefinitionParameterBindingComponent(json.getAsJsonObject("binding"), owner));
    if (json.has("part")) {
      JsonArray array = json.getAsJsonArray("part");
      for (int i = 0; i < array.size(); i++) {
        res.getPart().add(parseOperationDefinitionOperationDefinitionParameterComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected OperationDefinition.OperationDefinitionParameterBindingComponent parseOperationDefinitionOperationDefinitionParameterBindingComponent(JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionParameterBindingComponent res = new OperationDefinition.OperationDefinitionParameterBindingComponent();
    parseOperationDefinitionOperationDefinitionParameterBindingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseOperationDefinitionOperationDefinitionParameterBindingComponentProperties(JsonObject json, OperationDefinition owner, OperationDefinition.OperationDefinitionParameterBindingComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("strength"))
      res.setStrengthElement(parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
    if (json.has("_strength"))
      parseElementProperties(json.getAsJsonObject("_strength"), res.getStrengthElement());
    Type valueSet = parseType("valueSet", json);
    if (valueSet != null)
      res.setValueSet(valueSet);
  }

  protected OperationDefinition.OperationDefinitionOverloadComponent parseOperationDefinitionOperationDefinitionOverloadComponent(JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionOverloadComponent res = new OperationDefinition.OperationDefinitionOverloadComponent();
    parseOperationDefinitionOperationDefinitionOverloadComponentProperties(json, owner, res);
    return res;
  }

  protected void parseOperationDefinitionOperationDefinitionOverloadComponentProperties(JsonObject json, OperationDefinition owner, OperationDefinition.OperationDefinitionOverloadComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("parameterName")) {
      JsonArray array = json.getAsJsonArray("parameterName");
      for (int i = 0; i < array.size(); i++) {
        res.getParameterName().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_parameterName")) {
      JsonArray array = json.getAsJsonArray("_parameterName");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getParameterName().size())
          res.getParameterName().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getParameterName().get(i));
      }
    };
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
  }

  protected OperationOutcome parseOperationOutcome(JsonObject json) throws IOException, FHIRFormatError {
    OperationOutcome res = new OperationOutcome();
    parseOperationOutcomeProperties(json, res);
    return res;
  }

  protected void parseOperationOutcomeProperties(JsonObject json, OperationOutcome res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("issue")) {
      JsonArray array = json.getAsJsonArray("issue");
      for (int i = 0; i < array.size(); i++) {
        res.getIssue().add(parseOperationOutcomeOperationOutcomeIssueComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected OperationOutcome.OperationOutcomeIssueComponent parseOperationOutcomeOperationOutcomeIssueComponent(JsonObject json, OperationOutcome owner) throws IOException, FHIRFormatError {
    OperationOutcome.OperationOutcomeIssueComponent res = new OperationOutcome.OperationOutcomeIssueComponent();
    parseOperationOutcomeOperationOutcomeIssueComponentProperties(json, owner, res);
    return res;
  }

  protected void parseOperationOutcomeOperationOutcomeIssueComponentProperties(JsonObject json, OperationOutcome owner, OperationOutcome.OperationOutcomeIssueComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), OperationOutcome.IssueSeverity.NULL, new OperationOutcome.IssueSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), OperationOutcome.IssueType.NULL, new OperationOutcome.IssueTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("details"))
      res.setDetails(parseCodeableConcept(json.getAsJsonObject("details")));
    if (json.has("diagnostics"))
      res.setDiagnosticsElement(parseString(json.get("diagnostics").getAsString()));
    if (json.has("_diagnostics"))
      parseElementProperties(json.getAsJsonObject("_diagnostics"), res.getDiagnosticsElement());
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_location")) {
      JsonArray array = json.getAsJsonArray("_location");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLocation().size())
          res.getLocation().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLocation().get(i));
      }
    };
    if (json.has("expression")) {
      JsonArray array = json.getAsJsonArray("expression");
      for (int i = 0; i < array.size(); i++) {
        res.getExpression().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_expression")) {
      JsonArray array = json.getAsJsonArray("_expression");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getExpression().size())
          res.getExpression().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getExpression().get(i));
      }
    };
  }

  protected Organization parseOrganization(JsonObject json) throws IOException, FHIRFormatError {
    Organization res = new Organization();
    parseOrganizationProperties(json, res);
    return res;
  }

  protected void parseOrganizationProperties(JsonObject json, Organization res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        res.getAlias().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("address")) {
      JsonArray array = json.getAsJsonArray("address");
      for (int i = 0; i < array.size(); i++) {
        res.getAddress().add(parseAddress(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf"))
      res.setPartOf(parseReference(json.getAsJsonObject("partOf")));
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseOrganizationOrganizationContactComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Organization.OrganizationContactComponent parseOrganizationOrganizationContactComponent(JsonObject json, Organization owner) throws IOException, FHIRFormatError {
    Organization.OrganizationContactComponent res = new Organization.OrganizationContactComponent();
    parseOrganizationOrganizationContactComponentProperties(json, owner, res);
    return res;
  }

  protected void parseOrganizationOrganizationContactComponentProperties(JsonObject json, Organization owner, Organization.OrganizationContactComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("purpose"))
      res.setPurpose(parseCodeableConcept(json.getAsJsonObject("purpose")));
    if (json.has("name"))
      res.setName(parseHumanName(json.getAsJsonObject("name")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("address"))
      res.setAddress(parseAddress(json.getAsJsonObject("address")));
  }

  protected Patient parsePatient(JsonObject json) throws IOException, FHIRFormatError {
    Patient res = new Patient();
    parsePatientProperties(json, res);
    return res;
  }

  protected void parsePatientProperties(JsonObject json, Patient res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("name")) {
      JsonArray array = json.getAsJsonArray("name");
      for (int i = 0; i < array.size(); i++) {
        res.getName().add(parseHumanName(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("gender"))
      res.setGenderElement(parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
    if (json.has("_gender"))
      parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
    if (json.has("birthDate"))
      res.setBirthDateElement(parseDate(json.get("birthDate").getAsString()));
    if (json.has("_birthDate"))
      parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
    Type deceased = parseType("deceased", json);
    if (deceased != null)
      res.setDeceased(deceased);
    if (json.has("address")) {
      JsonArray array = json.getAsJsonArray("address");
      for (int i = 0; i < array.size(); i++) {
        res.getAddress().add(parseAddress(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("maritalStatus"))
      res.setMaritalStatus(parseCodeableConcept(json.getAsJsonObject("maritalStatus")));
    Type multipleBirth = parseType("multipleBirth", json);
    if (multipleBirth != null)
      res.setMultipleBirth(multipleBirth);
    if (json.has("photo")) {
      JsonArray array = json.getAsJsonArray("photo");
      for (int i = 0; i < array.size(); i++) {
        res.getPhoto().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parsePatientContactComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("animal"))
      res.setAnimal(parsePatientAnimalComponent(json.getAsJsonObject("animal"), res));
    if (json.has("communication")) {
      JsonArray array = json.getAsJsonArray("communication");
      for (int i = 0; i < array.size(); i++) {
        res.getCommunication().add(parsePatientPatientCommunicationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("generalPractitioner")) {
      JsonArray array = json.getAsJsonArray("generalPractitioner");
      for (int i = 0; i < array.size(); i++) {
        res.getGeneralPractitioner().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parsePatientPatientLinkComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Patient.ContactComponent parsePatientContactComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
    Patient.ContactComponent res = new Patient.ContactComponent();
    parsePatientContactComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePatientContactComponentProperties(JsonObject json, Patient owner, Patient.ContactComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("relationship")) {
      JsonArray array = json.getAsJsonArray("relationship");
      for (int i = 0; i < array.size(); i++) {
        res.getRelationship().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setName(parseHumanName(json.getAsJsonObject("name")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("address"))
      res.setAddress(parseAddress(json.getAsJsonObject("address")));
    if (json.has("gender"))
      res.setGenderElement(parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
    if (json.has("_gender"))
      parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Patient.AnimalComponent parsePatientAnimalComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
    Patient.AnimalComponent res = new Patient.AnimalComponent();
    parsePatientAnimalComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePatientAnimalComponentProperties(JsonObject json, Patient owner, Patient.AnimalComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("species"))
      res.setSpecies(parseCodeableConcept(json.getAsJsonObject("species")));
    if (json.has("breed"))
      res.setBreed(parseCodeableConcept(json.getAsJsonObject("breed")));
    if (json.has("genderStatus"))
      res.setGenderStatus(parseCodeableConcept(json.getAsJsonObject("genderStatus")));
  }

  protected Patient.PatientCommunicationComponent parsePatientPatientCommunicationComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
    Patient.PatientCommunicationComponent res = new Patient.PatientCommunicationComponent();
    parsePatientPatientCommunicationComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePatientPatientCommunicationComponentProperties(JsonObject json, Patient owner, Patient.PatientCommunicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(json.getAsJsonObject("language")));
    if (json.has("preferred"))
      res.setPreferredElement(parseBoolean(json.get("preferred").getAsBoolean()));
    if (json.has("_preferred"))
      parseElementProperties(json.getAsJsonObject("_preferred"), res.getPreferredElement());
  }

  protected Patient.PatientLinkComponent parsePatientPatientLinkComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
    Patient.PatientLinkComponent res = new Patient.PatientLinkComponent();
    parsePatientPatientLinkComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePatientPatientLinkComponentProperties(JsonObject json, Patient owner, Patient.PatientLinkComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("other"))
      res.setOther(parseReference(json.getAsJsonObject("other")));
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Patient.LinkType.NULL, new Patient.LinkTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
  }

  protected PaymentNotice parsePaymentNotice(JsonObject json) throws IOException, FHIRFormatError {
    PaymentNotice res = new PaymentNotice();
    parsePaymentNoticeProperties(json, res);
    return res;
  }

  protected void parsePaymentNoticeProperties(JsonObject json, PaymentNotice res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), PaymentNotice.PaymentNoticeStatus.NULL, new PaymentNotice.PaymentNoticeStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("response"))
      res.setResponse(parseReference(json.getAsJsonObject("response")));
    if (json.has("statusDate"))
      res.setStatusDateElement(parseDate(json.get("statusDate").getAsString()));
    if (json.has("_statusDate"))
      parseElementProperties(json.getAsJsonObject("_statusDate"), res.getStatusDateElement());
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("paymentStatus"))
      res.setPaymentStatus(parseCodeableConcept(json.getAsJsonObject("paymentStatus")));
  }

  protected PaymentReconciliation parsePaymentReconciliation(JsonObject json) throws IOException, FHIRFormatError {
    PaymentReconciliation res = new PaymentReconciliation();
    parsePaymentReconciliationProperties(json, res);
    return res;
  }

  protected void parsePaymentReconciliationProperties(JsonObject json, PaymentReconciliation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), PaymentReconciliation.PaymentReconciliationStatus.NULL, new PaymentReconciliation.PaymentReconciliationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("requestProvider"))
      res.setRequestProvider(parseReference(json.getAsJsonObject("requestProvider")));
    if (json.has("requestOrganization"))
      res.setRequestOrganization(parseReference(json.getAsJsonObject("requestOrganization")));
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parsePaymentReconciliationDetailsComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("form"))
      res.setForm(parseCodeableConcept(json.getAsJsonObject("form")));
    if (json.has("total"))
      res.setTotal(parseMoney(json.getAsJsonObject("total")));
    if (json.has("processNote")) {
      JsonArray array = json.getAsJsonArray("processNote");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessNote().add(parsePaymentReconciliationNotesComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected PaymentReconciliation.DetailsComponent parsePaymentReconciliationDetailsComponent(JsonObject json, PaymentReconciliation owner) throws IOException, FHIRFormatError {
    PaymentReconciliation.DetailsComponent res = new PaymentReconciliation.DetailsComponent();
    parsePaymentReconciliationDetailsComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePaymentReconciliationDetailsComponentProperties(JsonObject json, PaymentReconciliation owner, PaymentReconciliation.DetailsComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("response"))
      res.setResponse(parseReference(json.getAsJsonObject("response")));
    if (json.has("submitter"))
      res.setSubmitter(parseReference(json.getAsJsonObject("submitter")));
    if (json.has("payee"))
      res.setPayee(parseReference(json.getAsJsonObject("payee")));
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
  }

  protected PaymentReconciliation.NotesComponent parsePaymentReconciliationNotesComponent(JsonObject json, PaymentReconciliation owner) throws IOException, FHIRFormatError {
    PaymentReconciliation.NotesComponent res = new PaymentReconciliation.NotesComponent();
    parsePaymentReconciliationNotesComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePaymentReconciliationNotesComponentProperties(JsonObject json, PaymentReconciliation owner, PaymentReconciliation.NotesComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
  }

  protected Person parsePerson(JsonObject json) throws IOException, FHIRFormatError {
    Person res = new Person();
    parsePersonProperties(json, res);
    return res;
  }

  protected void parsePersonProperties(JsonObject json, Person res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name")) {
      JsonArray array = json.getAsJsonArray("name");
      for (int i = 0; i < array.size(); i++) {
        res.getName().add(parseHumanName(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("gender"))
      res.setGenderElement(parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
    if (json.has("_gender"))
      parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
    if (json.has("birthDate"))
      res.setBirthDateElement(parseDate(json.get("birthDate").getAsString()));
    if (json.has("_birthDate"))
      parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
    if (json.has("address")) {
      JsonArray array = json.getAsJsonArray("address");
      for (int i = 0; i < array.size(); i++) {
        res.getAddress().add(parseAddress(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("photo"))
      res.setPhoto(parseAttachment(json.getAsJsonObject("photo")));
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parsePersonPersonLinkComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Person.PersonLinkComponent parsePersonPersonLinkComponent(JsonObject json, Person owner) throws IOException, FHIRFormatError {
    Person.PersonLinkComponent res = new Person.PersonLinkComponent();
    parsePersonPersonLinkComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePersonPersonLinkComponentProperties(JsonObject json, Person owner, Person.PersonLinkComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
    if (json.has("assurance"))
      res.setAssuranceElement(parseEnumeration(json.get("assurance").getAsString(), Person.IdentityAssuranceLevel.NULL, new Person.IdentityAssuranceLevelEnumFactory()));
    if (json.has("_assurance"))
      parseElementProperties(json.getAsJsonObject("_assurance"), res.getAssuranceElement());
  }

  protected PlanDefinition parsePlanDefinition(JsonObject json) throws IOException, FHIRFormatError {
    PlanDefinition res = new PlanDefinition();
    parsePlanDefinitionProperties(json, res);
    return res;
  }

  protected void parsePlanDefinitionProperties(JsonObject json, PlanDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contributor")) {
      JsonArray array = json.getAsJsonArray("contributor");
      for (int i = 0; i < array.size(); i++) {
        res.getContributor().add(parseContributor(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("library")) {
      JsonArray array = json.getAsJsonArray("library");
      for (int i = 0; i < array.size(); i++) {
        res.getLibrary().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("goal")) {
      JsonArray array = json.getAsJsonArray("goal");
      for (int i = 0; i < array.size(); i++) {
        res.getGoal().add(parsePlanDefinitionPlanDefinitionGoalComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parsePlanDefinitionPlanDefinitionActionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected PlanDefinition.PlanDefinitionGoalComponent parsePlanDefinitionPlanDefinitionGoalComponent(JsonObject json, PlanDefinition owner) throws IOException, FHIRFormatError {
    PlanDefinition.PlanDefinitionGoalComponent res = new PlanDefinition.PlanDefinitionGoalComponent();
    parsePlanDefinitionPlanDefinitionGoalComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePlanDefinitionPlanDefinitionGoalComponentProperties(JsonObject json, PlanDefinition owner, PlanDefinition.PlanDefinitionGoalComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("description"))
      res.setDescription(parseCodeableConcept(json.getAsJsonObject("description")));
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("start"))
      res.setStart(parseCodeableConcept(json.getAsJsonObject("start")));
    if (json.has("addresses")) {
      JsonArray array = json.getAsJsonArray("addresses");
      for (int i = 0; i < array.size(); i++) {
        res.getAddresses().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("documentation")) {
      JsonArray array = json.getAsJsonArray("documentation");
      for (int i = 0; i < array.size(); i++) {
        res.getDocumentation().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parsePlanDefinitionPlanDefinitionGoalTargetComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected PlanDefinition.PlanDefinitionGoalTargetComponent parsePlanDefinitionPlanDefinitionGoalTargetComponent(JsonObject json, PlanDefinition owner) throws IOException, FHIRFormatError {
    PlanDefinition.PlanDefinitionGoalTargetComponent res = new PlanDefinition.PlanDefinitionGoalTargetComponent();
    parsePlanDefinitionPlanDefinitionGoalTargetComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePlanDefinitionPlanDefinitionGoalTargetComponentProperties(JsonObject json, PlanDefinition owner, PlanDefinition.PlanDefinitionGoalTargetComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("measure"))
      res.setMeasure(parseCodeableConcept(json.getAsJsonObject("measure")));
    Type detail = parseType("detail", json);
    if (detail != null)
      res.setDetail(detail);
    if (json.has("due"))
      res.setDue(parseDuration(json.getAsJsonObject("due")));
  }

  protected PlanDefinition.PlanDefinitionActionComponent parsePlanDefinitionPlanDefinitionActionComponent(JsonObject json, PlanDefinition owner) throws IOException, FHIRFormatError {
    PlanDefinition.PlanDefinitionActionComponent res = new PlanDefinition.PlanDefinitionActionComponent();
    parsePlanDefinitionPlanDefinitionActionComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePlanDefinitionPlanDefinitionActionComponentProperties(JsonObject json, PlanDefinition owner, PlanDefinition.PlanDefinitionActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("textEquivalent"))
      res.setTextEquivalentElement(parseString(json.get("textEquivalent").getAsString()));
    if (json.has("_textEquivalent"))
      parseElementProperties(json.getAsJsonObject("_textEquivalent"), res.getTextEquivalentElement());
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("documentation")) {
      JsonArray array = json.getAsJsonArray("documentation");
      for (int i = 0; i < array.size(); i++) {
        res.getDocumentation().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("goalId")) {
      JsonArray array = json.getAsJsonArray("goalId");
      for (int i = 0; i < array.size(); i++) {
        res.getGoalId().add(parseId(array.get(i).getAsString()));
      }
    };
    if (json.has("_goalId")) {
      JsonArray array = json.getAsJsonArray("_goalId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getGoalId().size())
          res.getGoalId().add(parseId(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getGoalId().get(i));
      }
    };
    if (json.has("triggerDefinition")) {
      JsonArray array = json.getAsJsonArray("triggerDefinition");
      for (int i = 0; i < array.size(); i++) {
        res.getTriggerDefinition().add(parseTriggerDefinition(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("condition")) {
      JsonArray array = json.getAsJsonArray("condition");
      for (int i = 0; i < array.size(); i++) {
        res.getCondition().add(parsePlanDefinitionPlanDefinitionActionConditionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("input")) {
      JsonArray array = json.getAsJsonArray("input");
      for (int i = 0; i < array.size(); i++) {
        res.getInput().add(parseDataRequirement(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("output")) {
      JsonArray array = json.getAsJsonArray("output");
      for (int i = 0; i < array.size(); i++) {
        res.getOutput().add(parseDataRequirement(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedAction")) {
      JsonArray array = json.getAsJsonArray("relatedAction");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedAction().add(parsePlanDefinitionPlanDefinitionActionRelatedActionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parsePlanDefinitionPlanDefinitionActionParticipantComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("groupingBehavior"))
      res.setGroupingBehaviorElement(parseEnumeration(json.get("groupingBehavior").getAsString(), PlanDefinition.ActionGroupingBehavior.NULL, new PlanDefinition.ActionGroupingBehaviorEnumFactory()));
    if (json.has("_groupingBehavior"))
      parseElementProperties(json.getAsJsonObject("_groupingBehavior"), res.getGroupingBehaviorElement());
    if (json.has("selectionBehavior"))
      res.setSelectionBehaviorElement(parseEnumeration(json.get("selectionBehavior").getAsString(), PlanDefinition.ActionSelectionBehavior.NULL, new PlanDefinition.ActionSelectionBehaviorEnumFactory()));
    if (json.has("_selectionBehavior"))
      parseElementProperties(json.getAsJsonObject("_selectionBehavior"), res.getSelectionBehaviorElement());
    if (json.has("requiredBehavior"))
      res.setRequiredBehaviorElement(parseEnumeration(json.get("requiredBehavior").getAsString(), PlanDefinition.ActionRequiredBehavior.NULL, new PlanDefinition.ActionRequiredBehaviorEnumFactory()));
    if (json.has("_requiredBehavior"))
      parseElementProperties(json.getAsJsonObject("_requiredBehavior"), res.getRequiredBehaviorElement());
    if (json.has("precheckBehavior"))
      res.setPrecheckBehaviorElement(parseEnumeration(json.get("precheckBehavior").getAsString(), PlanDefinition.ActionPrecheckBehavior.NULL, new PlanDefinition.ActionPrecheckBehaviorEnumFactory()));
    if (json.has("_precheckBehavior"))
      parseElementProperties(json.getAsJsonObject("_precheckBehavior"), res.getPrecheckBehaviorElement());
    if (json.has("cardinalityBehavior"))
      res.setCardinalityBehaviorElement(parseEnumeration(json.get("cardinalityBehavior").getAsString(), PlanDefinition.ActionCardinalityBehavior.NULL, new PlanDefinition.ActionCardinalityBehaviorEnumFactory()));
    if (json.has("_cardinalityBehavior"))
      parseElementProperties(json.getAsJsonObject("_cardinalityBehavior"), res.getCardinalityBehaviorElement());
    if (json.has("definition"))
      res.setDefinition(parseReference(json.getAsJsonObject("definition")));
    if (json.has("transform"))
      res.setTransform(parseReference(json.getAsJsonObject("transform")));
    if (json.has("dynamicValue")) {
      JsonArray array = json.getAsJsonArray("dynamicValue");
      for (int i = 0; i < array.size(); i++) {
        res.getDynamicValue().add(parsePlanDefinitionPlanDefinitionActionDynamicValueComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parsePlanDefinitionPlanDefinitionActionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected PlanDefinition.PlanDefinitionActionConditionComponent parsePlanDefinitionPlanDefinitionActionConditionComponent(JsonObject json, PlanDefinition owner) throws IOException, FHIRFormatError {
    PlanDefinition.PlanDefinitionActionConditionComponent res = new PlanDefinition.PlanDefinitionActionConditionComponent();
    parsePlanDefinitionPlanDefinitionActionConditionComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePlanDefinitionPlanDefinitionActionConditionComponentProperties(JsonObject json, PlanDefinition owner, PlanDefinition.PlanDefinitionActionConditionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), PlanDefinition.ActionConditionKind.NULL, new PlanDefinition.ActionConditionKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("language"))
      res.setLanguageElement(parseString(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
  }

  protected PlanDefinition.PlanDefinitionActionRelatedActionComponent parsePlanDefinitionPlanDefinitionActionRelatedActionComponent(JsonObject json, PlanDefinition owner) throws IOException, FHIRFormatError {
    PlanDefinition.PlanDefinitionActionRelatedActionComponent res = new PlanDefinition.PlanDefinitionActionRelatedActionComponent();
    parsePlanDefinitionPlanDefinitionActionRelatedActionComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePlanDefinitionPlanDefinitionActionRelatedActionComponentProperties(JsonObject json, PlanDefinition owner, PlanDefinition.PlanDefinitionActionRelatedActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("actionId"))
      res.setActionIdElement(parseId(json.get("actionId").getAsString()));
    if (json.has("_actionId"))
      parseElementProperties(json.getAsJsonObject("_actionId"), res.getActionIdElement());
    if (json.has("relationship"))
      res.setRelationshipElement(parseEnumeration(json.get("relationship").getAsString(), PlanDefinition.ActionRelationshipType.NULL, new PlanDefinition.ActionRelationshipTypeEnumFactory()));
    if (json.has("_relationship"))
      parseElementProperties(json.getAsJsonObject("_relationship"), res.getRelationshipElement());
    Type offset = parseType("offset", json);
    if (offset != null)
      res.setOffset(offset);
  }

  protected PlanDefinition.PlanDefinitionActionParticipantComponent parsePlanDefinitionPlanDefinitionActionParticipantComponent(JsonObject json, PlanDefinition owner) throws IOException, FHIRFormatError {
    PlanDefinition.PlanDefinitionActionParticipantComponent res = new PlanDefinition.PlanDefinitionActionParticipantComponent();
    parsePlanDefinitionPlanDefinitionActionParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePlanDefinitionPlanDefinitionActionParticipantComponentProperties(JsonObject json, PlanDefinition owner, PlanDefinition.PlanDefinitionActionParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), PlanDefinition.ActionParticipantType.NULL, new PlanDefinition.ActionParticipantTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
  }

  protected PlanDefinition.PlanDefinitionActionDynamicValueComponent parsePlanDefinitionPlanDefinitionActionDynamicValueComponent(JsonObject json, PlanDefinition owner) throws IOException, FHIRFormatError {
    PlanDefinition.PlanDefinitionActionDynamicValueComponent res = new PlanDefinition.PlanDefinitionActionDynamicValueComponent();
    parsePlanDefinitionPlanDefinitionActionDynamicValueComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePlanDefinitionPlanDefinitionActionDynamicValueComponentProperties(JsonObject json, PlanDefinition owner, PlanDefinition.PlanDefinitionActionDynamicValueComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("language"))
      res.setLanguageElement(parseString(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
  }

  protected Practitioner parsePractitioner(JsonObject json) throws IOException, FHIRFormatError {
    Practitioner res = new Practitioner();
    parsePractitionerProperties(json, res);
    return res;
  }

  protected void parsePractitionerProperties(JsonObject json, Practitioner res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("name")) {
      JsonArray array = json.getAsJsonArray("name");
      for (int i = 0; i < array.size(); i++) {
        res.getName().add(parseHumanName(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("address")) {
      JsonArray array = json.getAsJsonArray("address");
      for (int i = 0; i < array.size(); i++) {
        res.getAddress().add(parseAddress(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("gender"))
      res.setGenderElement(parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
    if (json.has("_gender"))
      parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
    if (json.has("birthDate"))
      res.setBirthDateElement(parseDate(json.get("birthDate").getAsString()));
    if (json.has("_birthDate"))
      parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
    if (json.has("photo")) {
      JsonArray array = json.getAsJsonArray("photo");
      for (int i = 0; i < array.size(); i++) {
        res.getPhoto().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("qualification")) {
      JsonArray array = json.getAsJsonArray("qualification");
      for (int i = 0; i < array.size(); i++) {
        res.getQualification().add(parsePractitionerPractitionerQualificationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("communication")) {
      JsonArray array = json.getAsJsonArray("communication");
      for (int i = 0; i < array.size(); i++) {
        res.getCommunication().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Practitioner.PractitionerQualificationComponent parsePractitionerPractitionerQualificationComponent(JsonObject json, Practitioner owner) throws IOException, FHIRFormatError {
    Practitioner.PractitionerQualificationComponent res = new Practitioner.PractitionerQualificationComponent();
    parsePractitionerPractitionerQualificationComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePractitionerPractitionerQualificationComponentProperties(JsonObject json, Practitioner owner, Practitioner.PractitionerQualificationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("issuer"))
      res.setIssuer(parseReference(json.getAsJsonObject("issuer")));
  }

  protected PractitionerRole parsePractitionerRole(JsonObject json) throws IOException, FHIRFormatError {
    PractitionerRole res = new PractitionerRole();
    parsePractitionerRoleProperties(json, res);
    return res;
  }

  protected void parsePractitionerRoleProperties(JsonObject json, PractitionerRole res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("practitioner"))
      res.setPractitioner(parseReference(json.getAsJsonObject("practitioner")));
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("healthcareService")) {
      JsonArray array = json.getAsJsonArray("healthcareService");
      for (int i = 0; i < array.size(); i++) {
        res.getHealthcareService().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("availableTime")) {
      JsonArray array = json.getAsJsonArray("availableTime");
      for (int i = 0; i < array.size(); i++) {
        res.getAvailableTime().add(parsePractitionerRolePractitionerRoleAvailableTimeComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("notAvailable")) {
      JsonArray array = json.getAsJsonArray("notAvailable");
      for (int i = 0; i < array.size(); i++) {
        res.getNotAvailable().add(parsePractitionerRolePractitionerRoleNotAvailableComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("availabilityExceptions"))
      res.setAvailabilityExceptionsElement(parseString(json.get("availabilityExceptions").getAsString()));
    if (json.has("_availabilityExceptions"))
      parseElementProperties(json.getAsJsonObject("_availabilityExceptions"), res.getAvailabilityExceptionsElement());
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected PractitionerRole.PractitionerRoleAvailableTimeComponent parsePractitionerRolePractitionerRoleAvailableTimeComponent(JsonObject json, PractitionerRole owner) throws IOException, FHIRFormatError {
    PractitionerRole.PractitionerRoleAvailableTimeComponent res = new PractitionerRole.PractitionerRoleAvailableTimeComponent();
    parsePractitionerRolePractitionerRoleAvailableTimeComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePractitionerRolePractitionerRoleAvailableTimeComponentProperties(JsonObject json, PractitionerRole owner, PractitionerRole.PractitionerRoleAvailableTimeComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        res.getDaysOfWeek().add(parseEnumeration(array.get(i).getAsString(), PractitionerRole.DaysOfWeek.NULL, new PractitionerRole.DaysOfWeekEnumFactory()));
      }
    };
    if (json.has("_daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("_daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDaysOfWeek().size())
          res.getDaysOfWeek().add(parseEnumeration(null, PractitionerRole.DaysOfWeek.NULL, new PractitionerRole.DaysOfWeekEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDaysOfWeek().get(i));
      }
    };
    if (json.has("allDay"))
      res.setAllDayElement(parseBoolean(json.get("allDay").getAsBoolean()));
    if (json.has("_allDay"))
      parseElementProperties(json.getAsJsonObject("_allDay"), res.getAllDayElement());
    if (json.has("availableStartTime"))
      res.setAvailableStartTimeElement(parseTime(json.get("availableStartTime").getAsString()));
    if (json.has("_availableStartTime"))
      parseElementProperties(json.getAsJsonObject("_availableStartTime"), res.getAvailableStartTimeElement());
    if (json.has("availableEndTime"))
      res.setAvailableEndTimeElement(parseTime(json.get("availableEndTime").getAsString()));
    if (json.has("_availableEndTime"))
      parseElementProperties(json.getAsJsonObject("_availableEndTime"), res.getAvailableEndTimeElement());
  }

  protected PractitionerRole.PractitionerRoleNotAvailableComponent parsePractitionerRolePractitionerRoleNotAvailableComponent(JsonObject json, PractitionerRole owner) throws IOException, FHIRFormatError {
    PractitionerRole.PractitionerRoleNotAvailableComponent res = new PractitionerRole.PractitionerRoleNotAvailableComponent();
    parsePractitionerRolePractitionerRoleNotAvailableComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePractitionerRolePractitionerRoleNotAvailableComponentProperties(JsonObject json, PractitionerRole owner, PractitionerRole.PractitionerRoleNotAvailableComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("during"))
      res.setDuring(parsePeriod(json.getAsJsonObject("during")));
  }

  protected Procedure parseProcedure(JsonObject json) throws IOException, FHIRFormatError {
    Procedure res = new Procedure();
    parseProcedureProperties(json, res);
    return res;
  }

  protected void parseProcedureProperties(JsonObject json, Procedure res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        res.getDefinition().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Procedure.ProcedureStatus.NULL, new Procedure.ProcedureStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("notDone"))
      res.setNotDoneElement(parseBoolean(json.get("notDone").getAsBoolean()));
    if (json.has("_notDone"))
      parseElementProperties(json.getAsJsonObject("_notDone"), res.getNotDoneElement());
    if (json.has("notDoneReason"))
      res.setNotDoneReason(parseCodeableConcept(json.getAsJsonObject("notDoneReason")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type performed = parseType("performed", json);
    if (performed != null)
      res.setPerformed(performed);
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseProcedureProcedurePerformerComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite")) {
      JsonArray array = json.getAsJsonArray("bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    if (json.has("report")) {
      JsonArray array = json.getAsJsonArray("report");
      for (int i = 0; i < array.size(); i++) {
        res.getReport().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("complication")) {
      JsonArray array = json.getAsJsonArray("complication");
      for (int i = 0; i < array.size(); i++) {
        res.getComplication().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("complicationDetail")) {
      JsonArray array = json.getAsJsonArray("complicationDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getComplicationDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("followUp")) {
      JsonArray array = json.getAsJsonArray("followUp");
      for (int i = 0; i < array.size(); i++) {
        res.getFollowUp().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("focalDevice")) {
      JsonArray array = json.getAsJsonArray("focalDevice");
      for (int i = 0; i < array.size(); i++) {
        res.getFocalDevice().add(parseProcedureProcedureFocalDeviceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("usedReference")) {
      JsonArray array = json.getAsJsonArray("usedReference");
      for (int i = 0; i < array.size(); i++) {
        res.getUsedReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("usedCode")) {
      JsonArray array = json.getAsJsonArray("usedCode");
      for (int i = 0; i < array.size(); i++) {
        res.getUsedCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Procedure.ProcedurePerformerComponent parseProcedureProcedurePerformerComponent(JsonObject json, Procedure owner) throws IOException, FHIRFormatError {
    Procedure.ProcedurePerformerComponent res = new Procedure.ProcedurePerformerComponent();
    parseProcedureProcedurePerformerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseProcedureProcedurePerformerComponentProperties(JsonObject json, Procedure owner, Procedure.ProcedurePerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(json.getAsJsonObject("onBehalfOf")));
  }

  protected Procedure.ProcedureFocalDeviceComponent parseProcedureProcedureFocalDeviceComponent(JsonObject json, Procedure owner) throws IOException, FHIRFormatError {
    Procedure.ProcedureFocalDeviceComponent res = new Procedure.ProcedureFocalDeviceComponent();
    parseProcedureProcedureFocalDeviceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseProcedureProcedureFocalDeviceComponentProperties(JsonObject json, Procedure owner, Procedure.ProcedureFocalDeviceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("action"))
      res.setAction(parseCodeableConcept(json.getAsJsonObject("action")));
    if (json.has("manipulated"))
      res.setManipulated(parseReference(json.getAsJsonObject("manipulated")));
  }

  protected ProcedureRequest parseProcedureRequest(JsonObject json) throws IOException, FHIRFormatError {
    ProcedureRequest res = new ProcedureRequest();
    parseProcedureRequestProperties(json, res);
    return res;
  }

  protected void parseProcedureRequestProperties(JsonObject json, ProcedureRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        res.getDefinition().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("requisition"))
      res.setRequisition(parseIdentifier(json.getAsJsonObject("requisition")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ProcedureRequest.ProcedureRequestStatus.NULL, new ProcedureRequest.ProcedureRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), ProcedureRequest.ProcedureRequestIntent.NULL, new ProcedureRequest.ProcedureRequestIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), ProcedureRequest.ProcedureRequestPriority.NULL, new ProcedureRequest.ProcedureRequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(json.getAsJsonObject("_doNotPerform"), res.getDoNotPerformElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    Type asNeeded = parseType("asNeeded", json);
    if (asNeeded != null)
      res.setAsNeeded(asNeeded);
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
    if (json.has("requester"))
      res.setRequester(parseProcedureRequestProcedureRequestRequesterComponent(json.getAsJsonObject("requester"), res));
    if (json.has("performerType"))
      res.setPerformerType(parseCodeableConcept(json.getAsJsonObject("performerType")));
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specimen")) {
      JsonArray array = json.getAsJsonArray("specimen");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimen().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite")) {
      JsonArray array = json.getAsJsonArray("bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relevantHistory")) {
      JsonArray array = json.getAsJsonArray("relevantHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getRelevantHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ProcedureRequest.ProcedureRequestRequesterComponent parseProcedureRequestProcedureRequestRequesterComponent(JsonObject json, ProcedureRequest owner) throws IOException, FHIRFormatError {
    ProcedureRequest.ProcedureRequestRequesterComponent res = new ProcedureRequest.ProcedureRequestRequesterComponent();
    parseProcedureRequestProcedureRequestRequesterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseProcedureRequestProcedureRequestRequesterComponentProperties(JsonObject json, ProcedureRequest owner, ProcedureRequest.ProcedureRequestRequesterComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("agent"))
      res.setAgent(parseReference(json.getAsJsonObject("agent")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(json.getAsJsonObject("onBehalfOf")));
  }

  protected ProcessRequest parseProcessRequest(JsonObject json) throws IOException, FHIRFormatError {
    ProcessRequest res = new ProcessRequest();
    parseProcessRequestProperties(json, res);
    return res;
  }

  protected void parseProcessRequestProperties(JsonObject json, ProcessRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ProcessRequest.ProcessRequestStatus.NULL, new ProcessRequest.ProcessRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("action"))
      res.setActionElement(parseEnumeration(json.get("action").getAsString(), ProcessRequest.ActionList.NULL, new ProcessRequest.ActionListEnumFactory()));
    if (json.has("_action"))
      parseElementProperties(json.getAsJsonObject("_action"), res.getActionElement());
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("response"))
      res.setResponse(parseReference(json.getAsJsonObject("response")));
    if (json.has("nullify"))
      res.setNullifyElement(parseBoolean(json.get("nullify").getAsBoolean()));
    if (json.has("_nullify"))
      parseElementProperties(json.getAsJsonObject("_nullify"), res.getNullifyElement());
    if (json.has("reference"))
      res.setReferenceElement(parseString(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseProcessRequestItemsComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("include")) {
      JsonArray array = json.getAsJsonArray("include");
      for (int i = 0; i < array.size(); i++) {
        res.getInclude().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_include")) {
      JsonArray array = json.getAsJsonArray("_include");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInclude().size())
          res.getInclude().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInclude().get(i));
      }
    };
    if (json.has("exclude")) {
      JsonArray array = json.getAsJsonArray("exclude");
      for (int i = 0; i < array.size(); i++) {
        res.getExclude().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_exclude")) {
      JsonArray array = json.getAsJsonArray("_exclude");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getExclude().size())
          res.getExclude().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getExclude().get(i));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected ProcessRequest.ItemsComponent parseProcessRequestItemsComponent(JsonObject json, ProcessRequest owner) throws IOException, FHIRFormatError {
    ProcessRequest.ItemsComponent res = new ProcessRequest.ItemsComponent();
    parseProcessRequestItemsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseProcessRequestItemsComponentProperties(JsonObject json, ProcessRequest owner, ProcessRequest.ItemsComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("sequenceLinkId"))
      res.setSequenceLinkIdElement(parseInteger(json.get("sequenceLinkId").getAsLong()));
    if (json.has("_sequenceLinkId"))
      parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
  }

  protected ProcessResponse parseProcessResponse(JsonObject json) throws IOException, FHIRFormatError {
    ProcessResponse res = new ProcessResponse();
    parseProcessResponseProperties(json, res);
    return res;
  }

  protected void parseProcessResponseProperties(JsonObject json, ProcessResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ProcessResponse.ProcessResponseStatus.NULL, new ProcessResponse.ProcessResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("requestProvider"))
      res.setRequestProvider(parseReference(json.getAsJsonObject("requestProvider")));
    if (json.has("requestOrganization"))
      res.setRequestOrganization(parseReference(json.getAsJsonObject("requestOrganization")));
    if (json.has("form"))
      res.setForm(parseCodeableConcept(json.getAsJsonObject("form")));
    if (json.has("processNote")) {
      JsonArray array = json.getAsJsonArray("processNote");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessNote().add(parseProcessResponseProcessResponseProcessNoteComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("error")) {
      JsonArray array = json.getAsJsonArray("error");
      for (int i = 0; i < array.size(); i++) {
        res.getError().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("communicationRequest")) {
      JsonArray array = json.getAsJsonArray("communicationRequest");
      for (int i = 0; i < array.size(); i++) {
        res.getCommunicationRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ProcessResponse.ProcessResponseProcessNoteComponent parseProcessResponseProcessResponseProcessNoteComponent(JsonObject json, ProcessResponse owner) throws IOException, FHIRFormatError {
    ProcessResponse.ProcessResponseProcessNoteComponent res = new ProcessResponse.ProcessResponseProcessNoteComponent();
    parseProcessResponseProcessResponseProcessNoteComponentProperties(json, owner, res);
    return res;
  }

  protected void parseProcessResponseProcessResponseProcessNoteComponentProperties(JsonObject json, ProcessResponse owner, ProcessResponse.ProcessResponseProcessNoteComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
  }

  protected Provenance parseProvenance(JsonObject json) throws IOException, FHIRFormatError {
    Provenance res = new Provenance();
    parseProvenanceProperties(json, res);
    return res;
  }

  protected void parseProvenanceProperties(JsonObject json, Provenance res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("recorded"))
      res.setRecordedElement(parseInstant(json.get("recorded").getAsString()));
    if (json.has("_recorded"))
      parseElementProperties(json.getAsJsonObject("_recorded"), res.getRecordedElement());
    if (json.has("policy")) {
      JsonArray array = json.getAsJsonArray("policy");
      for (int i = 0; i < array.size(); i++) {
        res.getPolicy().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_policy")) {
      JsonArray array = json.getAsJsonArray("_policy");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPolicy().size())
          res.getPolicy().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPolicy().get(i));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("activity"))
      res.setActivity(parseCoding(json.getAsJsonObject("activity")));
    if (json.has("agent")) {
      JsonArray array = json.getAsJsonArray("agent");
      for (int i = 0; i < array.size(); i++) {
        res.getAgent().add(parseProvenanceProvenanceAgentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("entity")) {
      JsonArray array = json.getAsJsonArray("entity");
      for (int i = 0; i < array.size(); i++) {
        res.getEntity().add(parseProvenanceProvenanceEntityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("signature")) {
      JsonArray array = json.getAsJsonArray("signature");
      for (int i = 0; i < array.size(); i++) {
        res.getSignature().add(parseSignature(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Provenance.ProvenanceAgentComponent parseProvenanceProvenanceAgentComponent(JsonObject json, Provenance owner) throws IOException, FHIRFormatError {
    Provenance.ProvenanceAgentComponent res = new Provenance.ProvenanceAgentComponent();
    parseProvenanceProvenanceAgentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseProvenanceProvenanceAgentComponentProperties(JsonObject json, Provenance owner, Provenance.ProvenanceAgentComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("role")) {
      JsonArray array = json.getAsJsonArray("role");
      for (int i = 0; i < array.size(); i++) {
        res.getRole().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    Type who = parseType("who", json);
    if (who != null)
      res.setWho(who);
    Type onBehalfOf = parseType("onBehalfOf", json);
    if (onBehalfOf != null)
      res.setOnBehalfOf(onBehalfOf);
    if (json.has("relatedAgentType"))
      res.setRelatedAgentType(parseCodeableConcept(json.getAsJsonObject("relatedAgentType")));
  }

  protected Provenance.ProvenanceEntityComponent parseProvenanceProvenanceEntityComponent(JsonObject json, Provenance owner) throws IOException, FHIRFormatError {
    Provenance.ProvenanceEntityComponent res = new Provenance.ProvenanceEntityComponent();
    parseProvenanceProvenanceEntityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseProvenanceProvenanceEntityComponentProperties(JsonObject json, Provenance owner, Provenance.ProvenanceEntityComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("role"))
      res.setRoleElement(parseEnumeration(json.get("role").getAsString(), Provenance.ProvenanceEntityRole.NULL, new Provenance.ProvenanceEntityRoleEnumFactory()));
    if (json.has("_role"))
      parseElementProperties(json.getAsJsonObject("_role"), res.getRoleElement());
    Type what = parseType("what", json);
    if (what != null)
      res.setWhat(what);
    if (json.has("agent")) {
      JsonArray array = json.getAsJsonArray("agent");
      for (int i = 0; i < array.size(); i++) {
        res.getAgent().add(parseProvenanceProvenanceAgentComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Questionnaire parseQuestionnaire(JsonObject json) throws IOException, FHIRFormatError {
    Questionnaire res = new Questionnaire();
    parseQuestionnaireProperties(json, res);
    return res;
  }

  protected void parseQuestionnaireProperties(JsonObject json, Questionnaire res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subjectType")) {
      JsonArray array = json.getAsJsonArray("subjectType");
      for (int i = 0; i < array.size(); i++) {
        res.getSubjectType().add(parseCode(array.get(i).getAsString()));
      }
    };
    if (json.has("_subjectType")) {
      JsonArray array = json.getAsJsonArray("_subjectType");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSubjectType().size())
          res.getSubjectType().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSubjectType().get(i));
      }
    };
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseQuestionnaireQuestionnaireItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Questionnaire.QuestionnaireItemComponent parseQuestionnaireQuestionnaireItemComponent(JsonObject json, Questionnaire owner) throws IOException, FHIRFormatError {
    Questionnaire.QuestionnaireItemComponent res = new Questionnaire.QuestionnaireItemComponent();
    parseQuestionnaireQuestionnaireItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseQuestionnaireQuestionnaireItemComponentProperties(JsonObject json, Questionnaire owner, Questionnaire.QuestionnaireItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("linkId"))
      res.setLinkIdElement(parseString(json.get("linkId").getAsString()));
    if (json.has("_linkId"))
      parseElementProperties(json.getAsJsonObject("_linkId"), res.getLinkIdElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseUri(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("prefix"))
      res.setPrefixElement(parseString(json.get("prefix").getAsString()));
    if (json.has("_prefix"))
      parseElementProperties(json.getAsJsonObject("_prefix"), res.getPrefixElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Questionnaire.QuestionnaireItemType.NULL, new Questionnaire.QuestionnaireItemTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("enableWhen")) {
      JsonArray array = json.getAsJsonArray("enableWhen");
      for (int i = 0; i < array.size(); i++) {
        res.getEnableWhen().add(parseQuestionnaireQuestionnaireItemEnableWhenComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("required"))
      res.setRequiredElement(parseBoolean(json.get("required").getAsBoolean()));
    if (json.has("_required"))
      parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
    if (json.has("repeats"))
      res.setRepeatsElement(parseBoolean(json.get("repeats").getAsBoolean()));
    if (json.has("_repeats"))
      parseElementProperties(json.getAsJsonObject("_repeats"), res.getRepeatsElement());
    if (json.has("readOnly"))
      res.setReadOnlyElement(parseBoolean(json.get("readOnly").getAsBoolean()));
    if (json.has("_readOnly"))
      parseElementProperties(json.getAsJsonObject("_readOnly"), res.getReadOnlyElement());
    if (json.has("maxLength"))
      res.setMaxLengthElement(parseInteger(json.get("maxLength").getAsLong()));
    if (json.has("_maxLength"))
      parseElementProperties(json.getAsJsonObject("_maxLength"), res.getMaxLengthElement());
    if (json.has("options"))
      res.setOptions(parseReference(json.getAsJsonObject("options")));
    if (json.has("option")) {
      JsonArray array = json.getAsJsonArray("option");
      for (int i = 0; i < array.size(); i++) {
        res.getOption().add(parseQuestionnaireQuestionnaireItemOptionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    Type initial = parseType("initial", json);
    if (initial != null)
      res.setInitial(initial);
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseQuestionnaireQuestionnaireItemComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Questionnaire.QuestionnaireItemEnableWhenComponent parseQuestionnaireQuestionnaireItemEnableWhenComponent(JsonObject json, Questionnaire owner) throws IOException, FHIRFormatError {
    Questionnaire.QuestionnaireItemEnableWhenComponent res = new Questionnaire.QuestionnaireItemEnableWhenComponent();
    parseQuestionnaireQuestionnaireItemEnableWhenComponentProperties(json, owner, res);
    return res;
  }

  protected void parseQuestionnaireQuestionnaireItemEnableWhenComponentProperties(JsonObject json, Questionnaire owner, Questionnaire.QuestionnaireItemEnableWhenComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("question"))
      res.setQuestionElement(parseString(json.get("question").getAsString()));
    if (json.has("_question"))
      parseElementProperties(json.getAsJsonObject("_question"), res.getQuestionElement());
    if (json.has("hasAnswer"))
      res.setHasAnswerElement(parseBoolean(json.get("hasAnswer").getAsBoolean()));
    if (json.has("_hasAnswer"))
      parseElementProperties(json.getAsJsonObject("_hasAnswer"), res.getHasAnswerElement());
    Type answer = parseType("answer", json);
    if (answer != null)
      res.setAnswer(answer);
  }

  protected Questionnaire.QuestionnaireItemOptionComponent parseQuestionnaireQuestionnaireItemOptionComponent(JsonObject json, Questionnaire owner) throws IOException, FHIRFormatError {
    Questionnaire.QuestionnaireItemOptionComponent res = new Questionnaire.QuestionnaireItemOptionComponent();
    parseQuestionnaireQuestionnaireItemOptionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseQuestionnaireQuestionnaireItemOptionComponentProperties(JsonObject json, Questionnaire owner, Questionnaire.QuestionnaireItemOptionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected QuestionnaireResponse parseQuestionnaireResponse(JsonObject json) throws IOException, FHIRFormatError {
    QuestionnaireResponse res = new QuestionnaireResponse();
    parseQuestionnaireResponseProperties(json, res);
    return res;
  }

  protected void parseQuestionnaireResponseProperties(JsonObject json, QuestionnaireResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("parent")) {
      JsonArray array = json.getAsJsonArray("parent");
      for (int i = 0; i < array.size(); i++) {
        res.getParent().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("questionnaire"))
      res.setQuestionnaire(parseReference(json.getAsJsonObject("questionnaire")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), QuestionnaireResponse.QuestionnaireResponseStatus.NULL, new QuestionnaireResponse.QuestionnaireResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("authored"))
      res.setAuthoredElement(parseDateTime(json.get("authored").getAsString()));
    if (json.has("_authored"))
      parseElementProperties(json.getAsJsonObject("_authored"), res.getAuthoredElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseQuestionnaireResponseQuestionnaireResponseItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected QuestionnaireResponse.QuestionnaireResponseItemComponent parseQuestionnaireResponseQuestionnaireResponseItemComponent(JsonObject json, QuestionnaireResponse owner) throws IOException, FHIRFormatError {
    QuestionnaireResponse.QuestionnaireResponseItemComponent res = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
    parseQuestionnaireResponseQuestionnaireResponseItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseQuestionnaireResponseQuestionnaireResponseItemComponentProperties(JsonObject json, QuestionnaireResponse owner, QuestionnaireResponse.QuestionnaireResponseItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("linkId"))
      res.setLinkIdElement(parseString(json.get("linkId").getAsString()));
    if (json.has("_linkId"))
      parseElementProperties(json.getAsJsonObject("_linkId"), res.getLinkIdElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseUri(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("answer")) {
      JsonArray array = json.getAsJsonArray("answer");
      for (int i = 0; i < array.size(); i++) {
        res.getAnswer().add(parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseQuestionnaireResponseQuestionnaireResponseItemComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(JsonObject json, QuestionnaireResponse owner) throws IOException, FHIRFormatError {
    QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent res = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
    parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponentProperties(JsonObject json, QuestionnaireResponse owner, QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseQuestionnaireResponseQuestionnaireResponseItemComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ReferralRequest parseReferralRequest(JsonObject json) throws IOException, FHIRFormatError {
    ReferralRequest res = new ReferralRequest();
    parseReferralRequestProperties(json, res);
    return res;
  }

  protected void parseReferralRequestProperties(JsonObject json, ReferralRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        res.getDefinition().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(json.getAsJsonObject("groupIdentifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ReferralRequest.ReferralRequestStatus.NULL, new ReferralRequest.ReferralRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), ReferralRequest.ReferralCategory.NULL, new ReferralRequest.ReferralCategoryEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), ReferralRequest.ReferralPriority.NULL, new ReferralRequest.ReferralPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("serviceRequested")) {
      JsonArray array = json.getAsJsonArray("serviceRequested");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceRequested().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
    if (json.has("requester"))
      res.setRequester(parseReferralRequestReferralRequestRequesterComponent(json.getAsJsonObject("requester"), res));
    if (json.has("specialty"))
      res.setSpecialty(parseCodeableConcept(json.getAsJsonObject("specialty")));
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relevantHistory")) {
      JsonArray array = json.getAsJsonArray("relevantHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getRelevantHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ReferralRequest.ReferralRequestRequesterComponent parseReferralRequestReferralRequestRequesterComponent(JsonObject json, ReferralRequest owner) throws IOException, FHIRFormatError {
    ReferralRequest.ReferralRequestRequesterComponent res = new ReferralRequest.ReferralRequestRequesterComponent();
    parseReferralRequestReferralRequestRequesterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseReferralRequestReferralRequestRequesterComponentProperties(JsonObject json, ReferralRequest owner, ReferralRequest.ReferralRequestRequesterComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("agent"))
      res.setAgent(parseReference(json.getAsJsonObject("agent")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(json.getAsJsonObject("onBehalfOf")));
  }

  protected RelatedPerson parseRelatedPerson(JsonObject json) throws IOException, FHIRFormatError {
    RelatedPerson res = new RelatedPerson();
    parseRelatedPersonProperties(json, res);
    return res;
  }

  protected void parseRelatedPersonProperties(JsonObject json, RelatedPerson res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(json.getAsJsonObject("relationship")));
    if (json.has("name")) {
      JsonArray array = json.getAsJsonArray("name");
      for (int i = 0; i < array.size(); i++) {
        res.getName().add(parseHumanName(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("gender"))
      res.setGenderElement(parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
    if (json.has("_gender"))
      parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
    if (json.has("birthDate"))
      res.setBirthDateElement(parseDate(json.get("birthDate").getAsString()));
    if (json.has("_birthDate"))
      parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
    if (json.has("address")) {
      JsonArray array = json.getAsJsonArray("address");
      for (int i = 0; i < array.size(); i++) {
        res.getAddress().add(parseAddress(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("photo")) {
      JsonArray array = json.getAsJsonArray("photo");
      for (int i = 0; i < array.size(); i++) {
        res.getPhoto().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected RequestGroup parseRequestGroup(JsonObject json) throws IOException, FHIRFormatError {
    RequestGroup res = new RequestGroup();
    parseRequestGroupProperties(json, res);
    return res;
  }

  protected void parseRequestGroupProperties(JsonObject json, RequestGroup res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        res.getDefinition().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(json.getAsJsonObject("groupIdentifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), RequestGroup.RequestStatus.NULL, new RequestGroup.RequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), RequestGroup.RequestIntent.NULL, new RequestGroup.RequestIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), RequestGroup.RequestPriority.NULL, new RequestGroup.RequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    Type reason = parseType("reason", json);
    if (reason != null)
      res.setReason(reason);
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseRequestGroupRequestGroupActionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected RequestGroup.RequestGroupActionComponent parseRequestGroupRequestGroupActionComponent(JsonObject json, RequestGroup owner) throws IOException, FHIRFormatError {
    RequestGroup.RequestGroupActionComponent res = new RequestGroup.RequestGroupActionComponent();
    parseRequestGroupRequestGroupActionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseRequestGroupRequestGroupActionComponentProperties(JsonObject json, RequestGroup owner, RequestGroup.RequestGroupActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("textEquivalent"))
      res.setTextEquivalentElement(parseString(json.get("textEquivalent").getAsString()));
    if (json.has("_textEquivalent"))
      parseElementProperties(json.getAsJsonObject("_textEquivalent"), res.getTextEquivalentElement());
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("documentation")) {
      JsonArray array = json.getAsJsonArray("documentation");
      for (int i = 0; i < array.size(); i++) {
        res.getDocumentation().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("condition")) {
      JsonArray array = json.getAsJsonArray("condition");
      for (int i = 0; i < array.size(); i++) {
        res.getCondition().add(parseRequestGroupRequestGroupActionConditionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("relatedAction")) {
      JsonArray array = json.getAsJsonArray("relatedAction");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedAction().add(parseRequestGroupRequestGroupActionRelatedActionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("groupingBehavior"))
      res.setGroupingBehaviorElement(parseEnumeration(json.get("groupingBehavior").getAsString(), RequestGroup.ActionGroupingBehavior.NULL, new RequestGroup.ActionGroupingBehaviorEnumFactory()));
    if (json.has("_groupingBehavior"))
      parseElementProperties(json.getAsJsonObject("_groupingBehavior"), res.getGroupingBehaviorElement());
    if (json.has("selectionBehavior"))
      res.setSelectionBehaviorElement(parseEnumeration(json.get("selectionBehavior").getAsString(), RequestGroup.ActionSelectionBehavior.NULL, new RequestGroup.ActionSelectionBehaviorEnumFactory()));
    if (json.has("_selectionBehavior"))
      parseElementProperties(json.getAsJsonObject("_selectionBehavior"), res.getSelectionBehaviorElement());
    if (json.has("requiredBehavior"))
      res.setRequiredBehaviorElement(parseEnumeration(json.get("requiredBehavior").getAsString(), RequestGroup.ActionRequiredBehavior.NULL, new RequestGroup.ActionRequiredBehaviorEnumFactory()));
    if (json.has("_requiredBehavior"))
      parseElementProperties(json.getAsJsonObject("_requiredBehavior"), res.getRequiredBehaviorElement());
    if (json.has("precheckBehavior"))
      res.setPrecheckBehaviorElement(parseEnumeration(json.get("precheckBehavior").getAsString(), RequestGroup.ActionPrecheckBehavior.NULL, new RequestGroup.ActionPrecheckBehaviorEnumFactory()));
    if (json.has("_precheckBehavior"))
      parseElementProperties(json.getAsJsonObject("_precheckBehavior"), res.getPrecheckBehaviorElement());
    if (json.has("cardinalityBehavior"))
      res.setCardinalityBehaviorElement(parseEnumeration(json.get("cardinalityBehavior").getAsString(), RequestGroup.ActionCardinalityBehavior.NULL, new RequestGroup.ActionCardinalityBehaviorEnumFactory()));
    if (json.has("_cardinalityBehavior"))
      parseElementProperties(json.getAsJsonObject("_cardinalityBehavior"), res.getCardinalityBehaviorElement());
    if (json.has("resource"))
      res.setResource(parseReference(json.getAsJsonObject("resource")));
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseRequestGroupRequestGroupActionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected RequestGroup.RequestGroupActionConditionComponent parseRequestGroupRequestGroupActionConditionComponent(JsonObject json, RequestGroup owner) throws IOException, FHIRFormatError {
    RequestGroup.RequestGroupActionConditionComponent res = new RequestGroup.RequestGroupActionConditionComponent();
    parseRequestGroupRequestGroupActionConditionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseRequestGroupRequestGroupActionConditionComponentProperties(JsonObject json, RequestGroup owner, RequestGroup.RequestGroupActionConditionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), RequestGroup.ActionConditionKind.NULL, new RequestGroup.ActionConditionKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("language"))
      res.setLanguageElement(parseString(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
  }

  protected RequestGroup.RequestGroupActionRelatedActionComponent parseRequestGroupRequestGroupActionRelatedActionComponent(JsonObject json, RequestGroup owner) throws IOException, FHIRFormatError {
    RequestGroup.RequestGroupActionRelatedActionComponent res = new RequestGroup.RequestGroupActionRelatedActionComponent();
    parseRequestGroupRequestGroupActionRelatedActionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseRequestGroupRequestGroupActionRelatedActionComponentProperties(JsonObject json, RequestGroup owner, RequestGroup.RequestGroupActionRelatedActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("actionId"))
      res.setActionIdElement(parseId(json.get("actionId").getAsString()));
    if (json.has("_actionId"))
      parseElementProperties(json.getAsJsonObject("_actionId"), res.getActionIdElement());
    if (json.has("relationship"))
      res.setRelationshipElement(parseEnumeration(json.get("relationship").getAsString(), RequestGroup.ActionRelationshipType.NULL, new RequestGroup.ActionRelationshipTypeEnumFactory()));
    if (json.has("_relationship"))
      parseElementProperties(json.getAsJsonObject("_relationship"), res.getRelationshipElement());
    Type offset = parseType("offset", json);
    if (offset != null)
      res.setOffset(offset);
  }

  protected ResearchStudy parseResearchStudy(JsonObject json) throws IOException, FHIRFormatError {
    ResearchStudy res = new ResearchStudy();
    parseResearchStudyProperties(json, res);
    return res;
  }

  protected void parseResearchStudyProperties(JsonObject json, ResearchStudy res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("protocol")) {
      JsonArray array = json.getAsJsonArray("protocol");
      for (int i = 0; i < array.size(); i++) {
        res.getProtocol().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ResearchStudy.ResearchStudyStatus.NULL, new ResearchStudy.ResearchStudyStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("focus")) {
      JsonArray array = json.getAsJsonArray("focus");
      for (int i = 0; i < array.size(); i++) {
        res.getFocus().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("keyword")) {
      JsonArray array = json.getAsJsonArray("keyword");
      for (int i = 0; i < array.size(); i++) {
        res.getKeyword().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("enrollment")) {
      JsonArray array = json.getAsJsonArray("enrollment");
      for (int i = 0; i < array.size(); i++) {
        res.getEnrollment().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("sponsor"))
      res.setSponsor(parseReference(json.getAsJsonObject("sponsor")));
    if (json.has("principalInvestigator"))
      res.setPrincipalInvestigator(parseReference(json.getAsJsonObject("principalInvestigator")));
    if (json.has("site")) {
      JsonArray array = json.getAsJsonArray("site");
      for (int i = 0; i < array.size(); i++) {
        res.getSite().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonStopped"))
      res.setReasonStopped(parseCodeableConcept(json.getAsJsonObject("reasonStopped")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("arm")) {
      JsonArray array = json.getAsJsonArray("arm");
      for (int i = 0; i < array.size(); i++) {
        res.getArm().add(parseResearchStudyResearchStudyArmComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ResearchStudy.ResearchStudyArmComponent parseResearchStudyResearchStudyArmComponent(JsonObject json, ResearchStudy owner) throws IOException, FHIRFormatError {
    ResearchStudy.ResearchStudyArmComponent res = new ResearchStudy.ResearchStudyArmComponent();
    parseResearchStudyResearchStudyArmComponentProperties(json, owner, res);
    return res;
  }

  protected void parseResearchStudyResearchStudyArmComponentProperties(JsonObject json, ResearchStudy owner, ResearchStudy.ResearchStudyArmComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
  }

  protected ResearchSubject parseResearchSubject(JsonObject json) throws IOException, FHIRFormatError {
    ResearchSubject res = new ResearchSubject();
    parseResearchSubjectProperties(json, res);
    return res;
  }

  protected void parseResearchSubjectProperties(JsonObject json, ResearchSubject res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ResearchSubject.ResearchSubjectStatus.NULL, new ResearchSubject.ResearchSubjectStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("study"))
      res.setStudy(parseReference(json.getAsJsonObject("study")));
    if (json.has("individual"))
      res.setIndividual(parseReference(json.getAsJsonObject("individual")));
    if (json.has("assignedArm"))
      res.setAssignedArmElement(parseString(json.get("assignedArm").getAsString()));
    if (json.has("_assignedArm"))
      parseElementProperties(json.getAsJsonObject("_assignedArm"), res.getAssignedArmElement());
    if (json.has("actualArm"))
      res.setActualArmElement(parseString(json.get("actualArm").getAsString()));
    if (json.has("_actualArm"))
      parseElementProperties(json.getAsJsonObject("_actualArm"), res.getActualArmElement());
    if (json.has("consent"))
      res.setConsent(parseReference(json.getAsJsonObject("consent")));
  }

  protected RiskAssessment parseRiskAssessment(JsonObject json) throws IOException, FHIRFormatError {
    RiskAssessment res = new RiskAssessment();
    parseRiskAssessmentProperties(json, res);
    return res;
  }

  protected void parseRiskAssessmentProperties(JsonObject json, RiskAssessment res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("basedOn"))
      res.setBasedOn(parseReference(json.getAsJsonObject("basedOn")));
    if (json.has("parent"))
      res.setParent(parseReference(json.getAsJsonObject("parent")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), RiskAssessment.RiskAssessmentStatus.NULL, new RiskAssessment.RiskAssessmentStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("condition"))
      res.setCondition(parseReference(json.getAsJsonObject("condition")));
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    Type reason = parseType("reason", json);
    if (reason != null)
      res.setReason(reason);
    if (json.has("basis")) {
      JsonArray array = json.getAsJsonArray("basis");
      for (int i = 0; i < array.size(); i++) {
        res.getBasis().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("prediction")) {
      JsonArray array = json.getAsJsonArray("prediction");
      for (int i = 0; i < array.size(); i++) {
        res.getPrediction().add(parseRiskAssessmentRiskAssessmentPredictionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("mitigation"))
      res.setMitigationElement(parseString(json.get("mitigation").getAsString()));
    if (json.has("_mitigation"))
      parseElementProperties(json.getAsJsonObject("_mitigation"), res.getMitigationElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
  }

  protected RiskAssessment.RiskAssessmentPredictionComponent parseRiskAssessmentRiskAssessmentPredictionComponent(JsonObject json, RiskAssessment owner) throws IOException, FHIRFormatError {
    RiskAssessment.RiskAssessmentPredictionComponent res = new RiskAssessment.RiskAssessmentPredictionComponent();
    parseRiskAssessmentRiskAssessmentPredictionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseRiskAssessmentRiskAssessmentPredictionComponentProperties(JsonObject json, RiskAssessment owner, RiskAssessment.RiskAssessmentPredictionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    Type probability = parseType("probability", json);
    if (probability != null)
      res.setProbability(probability);
    if (json.has("qualitativeRisk"))
      res.setQualitativeRisk(parseCodeableConcept(json.getAsJsonObject("qualitativeRisk")));
    if (json.has("relativeRisk"))
      res.setRelativeRiskElement(parseDecimal(json.get("relativeRisk").getAsBigDecimal()));
    if (json.has("_relativeRisk"))
      parseElementProperties(json.getAsJsonObject("_relativeRisk"), res.getRelativeRiskElement());
    Type when = parseType("when", json);
    if (when != null)
      res.setWhen(when);
    if (json.has("rationale"))
      res.setRationaleElement(parseString(json.get("rationale").getAsString()));
    if (json.has("_rationale"))
      parseElementProperties(json.getAsJsonObject("_rationale"), res.getRationaleElement());
  }

  protected Schedule parseSchedule(JsonObject json) throws IOException, FHIRFormatError {
    Schedule res = new Schedule();
    parseScheduleProperties(json, res);
    return res;
  }

  protected void parseScheduleProperties(JsonObject json, Schedule res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("serviceCategory"))
      res.setServiceCategory(parseCodeableConcept(json.getAsJsonObject("serviceCategory")));
    if (json.has("serviceType")) {
      JsonArray array = json.getAsJsonArray("serviceType");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("actor")) {
      JsonArray array = json.getAsJsonArray("actor");
      for (int i = 0; i < array.size(); i++) {
        res.getActor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("planningHorizon"))
      res.setPlanningHorizon(parsePeriod(json.getAsJsonObject("planningHorizon")));
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
  }

  protected SearchParameter parseSearchParameter(JsonObject json) throws IOException, FHIRFormatError {
    SearchParameter res = new SearchParameter();
    parseSearchParameterProperties(json, res);
    return res;
  }

  protected void parseSearchParameterProperties(JsonObject json, SearchParameter res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("base")) {
      JsonArray array = json.getAsJsonArray("base");
      for (int i = 0; i < array.size(); i++) {
        res.getBase().add(parseCode(array.get(i).getAsString()));
      }
    };
    if (json.has("_base")) {
      JsonArray array = json.getAsJsonArray("_base");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getBase().size())
          res.getBase().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getBase().get(i));
      }
    };
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("derivedFrom"))
      res.setDerivedFromElement(parseUri(json.get("derivedFrom").getAsString()));
    if (json.has("_derivedFrom"))
      parseElementProperties(json.getAsJsonObject("_derivedFrom"), res.getDerivedFromElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
    if (json.has("xpath"))
      res.setXpathElement(parseString(json.get("xpath").getAsString()));
    if (json.has("_xpath"))
      parseElementProperties(json.getAsJsonObject("_xpath"), res.getXpathElement());
    if (json.has("xpathUsage"))
      res.setXpathUsageElement(parseEnumeration(json.get("xpathUsage").getAsString(), SearchParameter.XPathUsageType.NULL, new SearchParameter.XPathUsageTypeEnumFactory()));
    if (json.has("_xpathUsage"))
      parseElementProperties(json.getAsJsonObject("_xpathUsage"), res.getXpathUsageElement());
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseCode(array.get(i).getAsString()));
      }
    };
    if (json.has("_target")) {
      JsonArray array = json.getAsJsonArray("_target");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getTarget().size())
          res.getTarget().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getTarget().get(i));
      }
    };
    if (json.has("comparator")) {
      JsonArray array = json.getAsJsonArray("comparator");
      for (int i = 0; i < array.size(); i++) {
        res.getComparator().add(parseEnumeration(array.get(i).getAsString(), SearchParameter.SearchComparator.NULL, new SearchParameter.SearchComparatorEnumFactory()));
      }
    };
    if (json.has("_comparator")) {
      JsonArray array = json.getAsJsonArray("_comparator");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getComparator().size())
          res.getComparator().add(parseEnumeration(null, SearchParameter.SearchComparator.NULL, new SearchParameter.SearchComparatorEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getComparator().get(i));
      }
    };
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseEnumeration(array.get(i).getAsString(), SearchParameter.SearchModifierCode.NULL, new SearchParameter.SearchModifierCodeEnumFactory()));
      }
    };
    if (json.has("_modifier")) {
      JsonArray array = json.getAsJsonArray("_modifier");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getModifier().size())
          res.getModifier().add(parseEnumeration(null, SearchParameter.SearchModifierCode.NULL, new SearchParameter.SearchModifierCodeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getModifier().get(i));
      }
    };
    if (json.has("chain")) {
      JsonArray array = json.getAsJsonArray("chain");
      for (int i = 0; i < array.size(); i++) {
        res.getChain().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_chain")) {
      JsonArray array = json.getAsJsonArray("_chain");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getChain().size())
          res.getChain().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getChain().get(i));
      }
    };
    if (json.has("component")) {
      JsonArray array = json.getAsJsonArray("component");
      for (int i = 0; i < array.size(); i++) {
        res.getComponent().add(parseSearchParameterSearchParameterComponentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected SearchParameter.SearchParameterComponentComponent parseSearchParameterSearchParameterComponentComponent(JsonObject json, SearchParameter owner) throws IOException, FHIRFormatError {
    SearchParameter.SearchParameterComponentComponent res = new SearchParameter.SearchParameterComponentComponent();
    parseSearchParameterSearchParameterComponentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseSearchParameterSearchParameterComponentComponentProperties(JsonObject json, SearchParameter owner, SearchParameter.SearchParameterComponentComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("definition"))
      res.setDefinition(parseReference(json.getAsJsonObject("definition")));
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
  }

  protected Sequence parseSequence(JsonObject json) throws IOException, FHIRFormatError {
    Sequence res = new Sequence();
    parseSequenceProperties(json, res);
    return res;
  }

  protected void parseSequenceProperties(JsonObject json, Sequence res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Sequence.SequenceType.NULL, new Sequence.SequenceTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("coordinateSystem"))
      res.setCoordinateSystemElement(parseInteger(json.get("coordinateSystem").getAsLong()));
    if (json.has("_coordinateSystem"))
      parseElementProperties(json.getAsJsonObject("_coordinateSystem"), res.getCoordinateSystemElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("specimen"))
      res.setSpecimen(parseReference(json.getAsJsonObject("specimen")));
    if (json.has("device"))
      res.setDevice(parseReference(json.getAsJsonObject("device")));
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("referenceSeq"))
      res.setReferenceSeq(parseSequenceSequenceReferenceSeqComponent(json.getAsJsonObject("referenceSeq"), res));
    if (json.has("variant")) {
      JsonArray array = json.getAsJsonArray("variant");
      for (int i = 0; i < array.size(); i++) {
        res.getVariant().add(parseSequenceSequenceVariantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("observedSeq"))
      res.setObservedSeqElement(parseString(json.get("observedSeq").getAsString()));
    if (json.has("_observedSeq"))
      parseElementProperties(json.getAsJsonObject("_observedSeq"), res.getObservedSeqElement());
    if (json.has("quality")) {
      JsonArray array = json.getAsJsonArray("quality");
      for (int i = 0; i < array.size(); i++) {
        res.getQuality().add(parseSequenceSequenceQualityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("readCoverage"))
      res.setReadCoverageElement(parseInteger(json.get("readCoverage").getAsLong()));
    if (json.has("_readCoverage"))
      parseElementProperties(json.getAsJsonObject("_readCoverage"), res.getReadCoverageElement());
    if (json.has("repository")) {
      JsonArray array = json.getAsJsonArray("repository");
      for (int i = 0; i < array.size(); i++) {
        res.getRepository().add(parseSequenceSequenceRepositoryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("pointer")) {
      JsonArray array = json.getAsJsonArray("pointer");
      for (int i = 0; i < array.size(); i++) {
        res.getPointer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Sequence.SequenceReferenceSeqComponent parseSequenceSequenceReferenceSeqComponent(JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
    Sequence.SequenceReferenceSeqComponent res = new Sequence.SequenceReferenceSeqComponent();
    parseSequenceSequenceReferenceSeqComponentProperties(json, owner, res);
    return res;
  }

  protected void parseSequenceSequenceReferenceSeqComponentProperties(JsonObject json, Sequence owner, Sequence.SequenceReferenceSeqComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("chromosome"))
      res.setChromosome(parseCodeableConcept(json.getAsJsonObject("chromosome")));
    if (json.has("genomeBuild"))
      res.setGenomeBuildElement(parseString(json.get("genomeBuild").getAsString()));
    if (json.has("_genomeBuild"))
      parseElementProperties(json.getAsJsonObject("_genomeBuild"), res.getGenomeBuildElement());
    if (json.has("referenceSeqId"))
      res.setReferenceSeqId(parseCodeableConcept(json.getAsJsonObject("referenceSeqId")));
    if (json.has("referenceSeqPointer"))
      res.setReferenceSeqPointer(parseReference(json.getAsJsonObject("referenceSeqPointer")));
    if (json.has("referenceSeqString"))
      res.setReferenceSeqStringElement(parseString(json.get("referenceSeqString").getAsString()));
    if (json.has("_referenceSeqString"))
      parseElementProperties(json.getAsJsonObject("_referenceSeqString"), res.getReferenceSeqStringElement());
    if (json.has("strand"))
      res.setStrandElement(parseInteger(json.get("strand").getAsLong()));
    if (json.has("_strand"))
      parseElementProperties(json.getAsJsonObject("_strand"), res.getStrandElement());
    if (json.has("windowStart"))
      res.setWindowStartElement(parseInteger(json.get("windowStart").getAsLong()));
    if (json.has("_windowStart"))
      parseElementProperties(json.getAsJsonObject("_windowStart"), res.getWindowStartElement());
    if (json.has("windowEnd"))
      res.setWindowEndElement(parseInteger(json.get("windowEnd").getAsLong()));
    if (json.has("_windowEnd"))
      parseElementProperties(json.getAsJsonObject("_windowEnd"), res.getWindowEndElement());
  }

  protected Sequence.SequenceVariantComponent parseSequenceSequenceVariantComponent(JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
    Sequence.SequenceVariantComponent res = new Sequence.SequenceVariantComponent();
    parseSequenceSequenceVariantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseSequenceSequenceVariantComponentProperties(JsonObject json, Sequence owner, Sequence.SequenceVariantComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseInteger(json.get("start").getAsLong()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInteger(json.get("end").getAsLong()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("observedAllele"))
      res.setObservedAlleleElement(parseString(json.get("observedAllele").getAsString()));
    if (json.has("_observedAllele"))
      parseElementProperties(json.getAsJsonObject("_observedAllele"), res.getObservedAlleleElement());
    if (json.has("referenceAllele"))
      res.setReferenceAlleleElement(parseString(json.get("referenceAllele").getAsString()));
    if (json.has("_referenceAllele"))
      parseElementProperties(json.getAsJsonObject("_referenceAllele"), res.getReferenceAlleleElement());
    if (json.has("cigar"))
      res.setCigarElement(parseString(json.get("cigar").getAsString()));
    if (json.has("_cigar"))
      parseElementProperties(json.getAsJsonObject("_cigar"), res.getCigarElement());
    if (json.has("variantPointer"))
      res.setVariantPointer(parseReference(json.getAsJsonObject("variantPointer")));
  }

  protected Sequence.SequenceQualityComponent parseSequenceSequenceQualityComponent(JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
    Sequence.SequenceQualityComponent res = new Sequence.SequenceQualityComponent();
    parseSequenceSequenceQualityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseSequenceSequenceQualityComponentProperties(JsonObject json, Sequence owner, Sequence.SequenceQualityComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Sequence.QualityType.NULL, new Sequence.QualityTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("standardSequence"))
      res.setStandardSequence(parseCodeableConcept(json.getAsJsonObject("standardSequence")));
    if (json.has("start"))
      res.setStartElement(parseInteger(json.get("start").getAsLong()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInteger(json.get("end").getAsLong()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("score"))
      res.setScore(parseQuantity(json.getAsJsonObject("score")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("truthTP"))
      res.setTruthTPElement(parseDecimal(json.get("truthTP").getAsBigDecimal()));
    if (json.has("_truthTP"))
      parseElementProperties(json.getAsJsonObject("_truthTP"), res.getTruthTPElement());
    if (json.has("queryTP"))
      res.setQueryTPElement(parseDecimal(json.get("queryTP").getAsBigDecimal()));
    if (json.has("_queryTP"))
      parseElementProperties(json.getAsJsonObject("_queryTP"), res.getQueryTPElement());
    if (json.has("truthFN"))
      res.setTruthFNElement(parseDecimal(json.get("truthFN").getAsBigDecimal()));
    if (json.has("_truthFN"))
      parseElementProperties(json.getAsJsonObject("_truthFN"), res.getTruthFNElement());
    if (json.has("queryFP"))
      res.setQueryFPElement(parseDecimal(json.get("queryFP").getAsBigDecimal()));
    if (json.has("_queryFP"))
      parseElementProperties(json.getAsJsonObject("_queryFP"), res.getQueryFPElement());
    if (json.has("gtFP"))
      res.setGtFPElement(parseDecimal(json.get("gtFP").getAsBigDecimal()));
    if (json.has("_gtFP"))
      parseElementProperties(json.getAsJsonObject("_gtFP"), res.getGtFPElement());
    if (json.has("precision"))
      res.setPrecisionElement(parseDecimal(json.get("precision").getAsBigDecimal()));
    if (json.has("_precision"))
      parseElementProperties(json.getAsJsonObject("_precision"), res.getPrecisionElement());
    if (json.has("recall"))
      res.setRecallElement(parseDecimal(json.get("recall").getAsBigDecimal()));
    if (json.has("_recall"))
      parseElementProperties(json.getAsJsonObject("_recall"), res.getRecallElement());
    if (json.has("fScore"))
      res.setFScoreElement(parseDecimal(json.get("fScore").getAsBigDecimal()));
    if (json.has("_fScore"))
      parseElementProperties(json.getAsJsonObject("_fScore"), res.getFScoreElement());
  }

  protected Sequence.SequenceRepositoryComponent parseSequenceSequenceRepositoryComponent(JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
    Sequence.SequenceRepositoryComponent res = new Sequence.SequenceRepositoryComponent();
    parseSequenceSequenceRepositoryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseSequenceSequenceRepositoryComponentProperties(JsonObject json, Sequence owner, Sequence.SequenceRepositoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Sequence.RepositoryType.NULL, new Sequence.RepositoryTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("datasetId"))
      res.setDatasetIdElement(parseString(json.get("datasetId").getAsString()));
    if (json.has("_datasetId"))
      parseElementProperties(json.getAsJsonObject("_datasetId"), res.getDatasetIdElement());
    if (json.has("variantsetId"))
      res.setVariantsetIdElement(parseString(json.get("variantsetId").getAsString()));
    if (json.has("_variantsetId"))
      parseElementProperties(json.getAsJsonObject("_variantsetId"), res.getVariantsetIdElement());
    if (json.has("readsetId"))
      res.setReadsetIdElement(parseString(json.get("readsetId").getAsString()));
    if (json.has("_readsetId"))
      parseElementProperties(json.getAsJsonObject("_readsetId"), res.getReadsetIdElement());
  }

  protected ServiceDefinition parseServiceDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ServiceDefinition res = new ServiceDefinition();
    parseServiceDefinitionProperties(json, res);
    return res;
  }

  protected void parseServiceDefinitionProperties(JsonObject json, ServiceDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contributor")) {
      JsonArray array = json.getAsJsonArray("contributor");
      for (int i = 0; i < array.size(); i++) {
        res.getContributor().add(parseContributor(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("trigger")) {
      JsonArray array = json.getAsJsonArray("trigger");
      for (int i = 0; i < array.size(); i++) {
        res.getTrigger().add(parseTriggerDefinition(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dataRequirement")) {
      JsonArray array = json.getAsJsonArray("dataRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getDataRequirement().add(parseDataRequirement(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("operationDefinition"))
      res.setOperationDefinition(parseReference(json.getAsJsonObject("operationDefinition")));
  }

  protected Slot parseSlot(JsonObject json) throws IOException, FHIRFormatError {
    Slot res = new Slot();
    parseSlotProperties(json, res);
    return res;
  }

  protected void parseSlotProperties(JsonObject json, Slot res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("serviceCategory"))
      res.setServiceCategory(parseCodeableConcept(json.getAsJsonObject("serviceCategory")));
    if (json.has("serviceType")) {
      JsonArray array = json.getAsJsonArray("serviceType");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("appointmentType"))
      res.setAppointmentType(parseCodeableConcept(json.getAsJsonObject("appointmentType")));
    if (json.has("schedule"))
      res.setSchedule(parseReference(json.getAsJsonObject("schedule")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Slot.SlotStatus.NULL, new Slot.SlotStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("start"))
      res.setStartElement(parseInstant(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInstant(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("overbooked"))
      res.setOverbookedElement(parseBoolean(json.get("overbooked").getAsBoolean()));
    if (json.has("_overbooked"))
      parseElementProperties(json.getAsJsonObject("_overbooked"), res.getOverbookedElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
  }

  protected Specimen parseSpecimen(JsonObject json) throws IOException, FHIRFormatError {
    Specimen res = new Specimen();
    parseSpecimenProperties(json, res);
    return res;
  }

  protected void parseSpecimenProperties(JsonObject json, Specimen res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("accessionIdentifier"))
      res.setAccessionIdentifier(parseIdentifier(json.getAsJsonObject("accessionIdentifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Specimen.SpecimenStatus.NULL, new Specimen.SpecimenStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("receivedTime"))
      res.setReceivedTimeElement(parseDateTime(json.get("receivedTime").getAsString()));
    if (json.has("_receivedTime"))
      parseElementProperties(json.getAsJsonObject("_receivedTime"), res.getReceivedTimeElement());
    if (json.has("parent")) {
      JsonArray array = json.getAsJsonArray("parent");
      for (int i = 0; i < array.size(); i++) {
        res.getParent().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("request")) {
      JsonArray array = json.getAsJsonArray("request");
      for (int i = 0; i < array.size(); i++) {
        res.getRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("collection"))
      res.setCollection(parseSpecimenSpecimenCollectionComponent(json.getAsJsonObject("collection"), res));
    if (json.has("processing")) {
      JsonArray array = json.getAsJsonArray("processing");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessing().add(parseSpecimenSpecimenProcessingComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("container")) {
      JsonArray array = json.getAsJsonArray("container");
      for (int i = 0; i < array.size(); i++) {
        res.getContainer().add(parseSpecimenSpecimenContainerComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Specimen.SpecimenCollectionComponent parseSpecimenSpecimenCollectionComponent(JsonObject json, Specimen owner) throws IOException, FHIRFormatError {
    Specimen.SpecimenCollectionComponent res = new Specimen.SpecimenCollectionComponent();
    parseSpecimenSpecimenCollectionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseSpecimenSpecimenCollectionComponentProperties(JsonObject json, Specimen owner, Specimen.SpecimenCollectionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("collector"))
      res.setCollector(parseReference(json.getAsJsonObject("collector")));
    Type collected = parseType("collected", json);
    if (collected != null)
      res.setCollected(collected);
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
  }

  protected Specimen.SpecimenProcessingComponent parseSpecimenSpecimenProcessingComponent(JsonObject json, Specimen owner) throws IOException, FHIRFormatError {
    Specimen.SpecimenProcessingComponent res = new Specimen.SpecimenProcessingComponent();
    parseSpecimenSpecimenProcessingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseSpecimenSpecimenProcessingComponentProperties(JsonObject json, Specimen owner, Specimen.SpecimenProcessingComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("procedure"))
      res.setProcedure(parseCodeableConcept(json.getAsJsonObject("procedure")));
    if (json.has("additive")) {
      JsonArray array = json.getAsJsonArray("additive");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditive().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type time = parseType("time", json);
    if (time != null)
      res.setTime(time);
  }

  protected Specimen.SpecimenContainerComponent parseSpecimenSpecimenContainerComponent(JsonObject json, Specimen owner) throws IOException, FHIRFormatError {
    Specimen.SpecimenContainerComponent res = new Specimen.SpecimenContainerComponent();
    parseSpecimenSpecimenContainerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseSpecimenSpecimenContainerComponentProperties(JsonObject json, Specimen owner, Specimen.SpecimenContainerComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("capacity"))
      res.setCapacity(parseSimpleQuantity(json.getAsJsonObject("capacity")));
    if (json.has("specimenQuantity"))
      res.setSpecimenQuantity(parseSimpleQuantity(json.getAsJsonObject("specimenQuantity")));
    Type additive = parseType("additive", json);
    if (additive != null)
      res.setAdditive(additive);
  }

  protected StructureDefinition parseStructureDefinition(JsonObject json) throws IOException, FHIRFormatError {
    StructureDefinition res = new StructureDefinition();
    parseStructureDefinitionProperties(json, res);
    return res;
  }

  protected void parseStructureDefinitionProperties(JsonObject json, StructureDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("keyword")) {
      JsonArray array = json.getAsJsonArray("keyword");
      for (int i = 0; i < array.size(); i++) {
        res.getKeyword().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("fhirVersion"))
      res.setFhirVersionElement(parseId(json.get("fhirVersion").getAsString()));
    if (json.has("_fhirVersion"))
      parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
    if (json.has("mapping")) {
      JsonArray array = json.getAsJsonArray("mapping");
      for (int i = 0; i < array.size(); i++) {
        res.getMapping().add(parseStructureDefinitionStructureDefinitionMappingComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), StructureDefinition.StructureDefinitionKind.NULL, new StructureDefinition.StructureDefinitionKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("abstract"))
      res.setAbstractElement(parseBoolean(json.get("abstract").getAsBoolean()));
    if (json.has("_abstract"))
      parseElementProperties(json.getAsJsonObject("_abstract"), res.getAbstractElement());
    if (json.has("contextType"))
      res.setContextTypeElement(parseEnumeration(json.get("contextType").getAsString(), StructureDefinition.ExtensionContext.NULL, new StructureDefinition.ExtensionContextEnumFactory()));
    if (json.has("_contextType"))
      parseElementProperties(json.getAsJsonObject("_contextType"), res.getContextTypeElement());
    if (json.has("context")) {
      JsonArray array = json.getAsJsonArray("context");
      for (int i = 0; i < array.size(); i++) {
        res.getContext().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_context")) {
      JsonArray array = json.getAsJsonArray("_context");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getContext().size())
          res.getContext().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getContext().get(i));
      }
    };
    if (json.has("contextInvariant")) {
      JsonArray array = json.getAsJsonArray("contextInvariant");
      for (int i = 0; i < array.size(); i++) {
        res.getContextInvariant().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_contextInvariant")) {
      JsonArray array = json.getAsJsonArray("_contextInvariant");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getContextInvariant().size())
          res.getContextInvariant().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getContextInvariant().get(i));
      }
    };
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("baseDefinition"))
      res.setBaseDefinitionElement(parseUri(json.get("baseDefinition").getAsString()));
    if (json.has("_baseDefinition"))
      parseElementProperties(json.getAsJsonObject("_baseDefinition"), res.getBaseDefinitionElement());
    if (json.has("derivation"))
      res.setDerivationElement(parseEnumeration(json.get("derivation").getAsString(), StructureDefinition.TypeDerivationRule.NULL, new StructureDefinition.TypeDerivationRuleEnumFactory()));
    if (json.has("_derivation"))
      parseElementProperties(json.getAsJsonObject("_derivation"), res.getDerivationElement());
    if (json.has("snapshot"))
      res.setSnapshot(parseStructureDefinitionStructureDefinitionSnapshotComponent(json.getAsJsonObject("snapshot"), res));
    if (json.has("differential"))
      res.setDifferential(parseStructureDefinitionStructureDefinitionDifferentialComponent(json.getAsJsonObject("differential"), res));
  }

  protected StructureDefinition.StructureDefinitionMappingComponent parseStructureDefinitionStructureDefinitionMappingComponent(JsonObject json, StructureDefinition owner) throws IOException, FHIRFormatError {
    StructureDefinition.StructureDefinitionMappingComponent res = new StructureDefinition.StructureDefinitionMappingComponent();
    parseStructureDefinitionStructureDefinitionMappingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseStructureDefinitionStructureDefinitionMappingComponentProperties(JsonObject json, StructureDefinition owner, StructureDefinition.StructureDefinitionMappingComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identity"))
      res.setIdentityElement(parseId(json.get("identity").getAsString()));
    if (json.has("_identity"))
      parseElementProperties(json.getAsJsonObject("_identity"), res.getIdentityElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
  }

  protected StructureDefinition.StructureDefinitionSnapshotComponent parseStructureDefinitionStructureDefinitionSnapshotComponent(JsonObject json, StructureDefinition owner) throws IOException, FHIRFormatError {
    StructureDefinition.StructureDefinitionSnapshotComponent res = new StructureDefinition.StructureDefinitionSnapshotComponent();
    parseStructureDefinitionStructureDefinitionSnapshotComponentProperties(json, owner, res);
    return res;
  }

  protected void parseStructureDefinitionStructureDefinitionSnapshotComponentProperties(JsonObject json, StructureDefinition owner, StructureDefinition.StructureDefinitionSnapshotComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("element")) {
      JsonArray array = json.getAsJsonArray("element");
      for (int i = 0; i < array.size(); i++) {
        res.getElement().add(parseElementDefinition(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected StructureDefinition.StructureDefinitionDifferentialComponent parseStructureDefinitionStructureDefinitionDifferentialComponent(JsonObject json, StructureDefinition owner) throws IOException, FHIRFormatError {
    StructureDefinition.StructureDefinitionDifferentialComponent res = new StructureDefinition.StructureDefinitionDifferentialComponent();
    parseStructureDefinitionStructureDefinitionDifferentialComponentProperties(json, owner, res);
    return res;
  }

  protected void parseStructureDefinitionStructureDefinitionDifferentialComponentProperties(JsonObject json, StructureDefinition owner, StructureDefinition.StructureDefinitionDifferentialComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("element")) {
      JsonArray array = json.getAsJsonArray("element");
      for (int i = 0; i < array.size(); i++) {
        res.getElement().add(parseElementDefinition(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected StructureMap parseStructureMap(JsonObject json) throws IOException, FHIRFormatError {
    StructureMap res = new StructureMap();
    parseStructureMapProperties(json, res);
    return res;
  }

  protected void parseStructureMapProperties(JsonObject json, StructureMap res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("structure")) {
      JsonArray array = json.getAsJsonArray("structure");
      for (int i = 0; i < array.size(); i++) {
        res.getStructure().add(parseStructureMapStructureMapStructureComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("import")) {
      JsonArray array = json.getAsJsonArray("import");
      for (int i = 0; i < array.size(); i++) {
        res.getImport().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_import")) {
      JsonArray array = json.getAsJsonArray("_import");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImport().size())
          res.getImport().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImport().get(i));
      }
    };
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseStructureMapStructureMapGroupComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected StructureMap.StructureMapStructureComponent parseStructureMapStructureMapStructureComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapStructureComponent res = new StructureMap.StructureMapStructureComponent();
    parseStructureMapStructureMapStructureComponentProperties(json, owner, res);
    return res;
  }

  protected void parseStructureMapStructureMapStructureComponentProperties(JsonObject json, StructureMap owner, StructureMap.StructureMapStructureComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), StructureMap.StructureMapModelMode.NULL, new StructureMap.StructureMapModelModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("alias"))
      res.setAliasElement(parseString(json.get("alias").getAsString()));
    if (json.has("_alias"))
      parseElementProperties(json.getAsJsonObject("_alias"), res.getAliasElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected StructureMap.StructureMapGroupComponent parseStructureMapStructureMapGroupComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapGroupComponent res = new StructureMap.StructureMapGroupComponent();
    parseStructureMapStructureMapGroupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseStructureMapStructureMapGroupComponentProperties(JsonObject json, StructureMap owner, StructureMap.StructureMapGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseId(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("extends"))
      res.setExtendsElement(parseId(json.get("extends").getAsString()));
    if (json.has("_extends"))
      parseElementProperties(json.getAsJsonObject("_extends"), res.getExtendsElement());
    if (json.has("typeMode"))
      res.setTypeModeElement(parseEnumeration(json.get("typeMode").getAsString(), StructureMap.StructureMapGroupTypeMode.NULL, new StructureMap.StructureMapGroupTypeModeEnumFactory()));
    if (json.has("_typeMode"))
      parseElementProperties(json.getAsJsonObject("_typeMode"), res.getTypeModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("input")) {
      JsonArray array = json.getAsJsonArray("input");
      for (int i = 0; i < array.size(); i++) {
        res.getInput().add(parseStructureMapStructureMapGroupInputComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("rule")) {
      JsonArray array = json.getAsJsonArray("rule");
      for (int i = 0; i < array.size(); i++) {
        res.getRule().add(parseStructureMapStructureMapGroupRuleComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected StructureMap.StructureMapGroupInputComponent parseStructureMapStructureMapGroupInputComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapGroupInputComponent res = new StructureMap.StructureMapGroupInputComponent();
    parseStructureMapStructureMapGroupInputComponentProperties(json, owner, res);
    return res;
  }

  protected void parseStructureMapStructureMapGroupInputComponentProperties(JsonObject json, StructureMap owner, StructureMap.StructureMapGroupInputComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseId(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("type"))
      res.setTypeElement(parseString(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), StructureMap.StructureMapInputMode.NULL, new StructureMap.StructureMapInputModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected StructureMap.StructureMapGroupRuleComponent parseStructureMapStructureMapGroupRuleComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapGroupRuleComponent res = new StructureMap.StructureMapGroupRuleComponent();
    parseStructureMapStructureMapGroupRuleComponentProperties(json, owner, res);
    return res;
  }

  protected void parseStructureMapStructureMapGroupRuleComponentProperties(JsonObject json, StructureMap owner, StructureMap.StructureMapGroupRuleComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseId(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("source")) {
      JsonArray array = json.getAsJsonArray("source");
      for (int i = 0; i < array.size(); i++) {
        res.getSource().add(parseStructureMapStructureMapGroupRuleSourceComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseStructureMapStructureMapGroupRuleTargetComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("rule")) {
      JsonArray array = json.getAsJsonArray("rule");
      for (int i = 0; i < array.size(); i++) {
        res.getRule().add(parseStructureMapStructureMapGroupRuleComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("dependent")) {
      JsonArray array = json.getAsJsonArray("dependent");
      for (int i = 0; i < array.size(); i++) {
        res.getDependent().add(parseStructureMapStructureMapGroupRuleDependentComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected StructureMap.StructureMapGroupRuleSourceComponent parseStructureMapStructureMapGroupRuleSourceComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapGroupRuleSourceComponent res = new StructureMap.StructureMapGroupRuleSourceComponent();
    parseStructureMapStructureMapGroupRuleSourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseStructureMapStructureMapGroupRuleSourceComponentProperties(JsonObject json, StructureMap owner, StructureMap.StructureMapGroupRuleSourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("context"))
      res.setContextElement(parseId(json.get("context").getAsString()));
    if (json.has("_context"))
      parseElementProperties(json.getAsJsonObject("_context"), res.getContextElement());
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
    if (json.has("type"))
      res.setTypeElement(parseString(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    Type defaultValue = parseType("defaultValue", json);
    if (defaultValue != null)
      res.setDefaultValue(defaultValue);
    if (json.has("element"))
      res.setElementElement(parseString(json.get("element").getAsString()));
    if (json.has("_element"))
      parseElementProperties(json.getAsJsonObject("_element"), res.getElementElement());
    if (json.has("listMode"))
      res.setListModeElement(parseEnumeration(json.get("listMode").getAsString(), StructureMap.StructureMapSourceListMode.NULL, new StructureMap.StructureMapSourceListModeEnumFactory()));
    if (json.has("_listMode"))
      parseElementProperties(json.getAsJsonObject("_listMode"), res.getListModeElement());
    if (json.has("variable"))
      res.setVariableElement(parseId(json.get("variable").getAsString()));
    if (json.has("_variable"))
      parseElementProperties(json.getAsJsonObject("_variable"), res.getVariableElement());
    if (json.has("condition"))
      res.setConditionElement(parseString(json.get("condition").getAsString()));
    if (json.has("_condition"))
      parseElementProperties(json.getAsJsonObject("_condition"), res.getConditionElement());
    if (json.has("check"))
      res.setCheckElement(parseString(json.get("check").getAsString()));
    if (json.has("_check"))
      parseElementProperties(json.getAsJsonObject("_check"), res.getCheckElement());
  }

  protected StructureMap.StructureMapGroupRuleTargetComponent parseStructureMapStructureMapGroupRuleTargetComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapGroupRuleTargetComponent res = new StructureMap.StructureMapGroupRuleTargetComponent();
    parseStructureMapStructureMapGroupRuleTargetComponentProperties(json, owner, res);
    return res;
  }

  protected void parseStructureMapStructureMapGroupRuleTargetComponentProperties(JsonObject json, StructureMap owner, StructureMap.StructureMapGroupRuleTargetComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("context"))
      res.setContextElement(parseId(json.get("context").getAsString()));
    if (json.has("_context"))
      parseElementProperties(json.getAsJsonObject("_context"), res.getContextElement());
    if (json.has("contextType"))
      res.setContextTypeElement(parseEnumeration(json.get("contextType").getAsString(), StructureMap.StructureMapContextType.NULL, new StructureMap.StructureMapContextTypeEnumFactory()));
    if (json.has("_contextType"))
      parseElementProperties(json.getAsJsonObject("_contextType"), res.getContextTypeElement());
    if (json.has("element"))
      res.setElementElement(parseString(json.get("element").getAsString()));
    if (json.has("_element"))
      parseElementProperties(json.getAsJsonObject("_element"), res.getElementElement());
    if (json.has("variable"))
      res.setVariableElement(parseId(json.get("variable").getAsString()));
    if (json.has("_variable"))
      parseElementProperties(json.getAsJsonObject("_variable"), res.getVariableElement());
    if (json.has("listMode")) {
      JsonArray array = json.getAsJsonArray("listMode");
      for (int i = 0; i < array.size(); i++) {
        res.getListMode().add(parseEnumeration(array.get(i).getAsString(), StructureMap.StructureMapTargetListMode.NULL, new StructureMap.StructureMapTargetListModeEnumFactory()));
      }
    };
    if (json.has("_listMode")) {
      JsonArray array = json.getAsJsonArray("_listMode");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getListMode().size())
          res.getListMode().add(parseEnumeration(null, StructureMap.StructureMapTargetListMode.NULL, new StructureMap.StructureMapTargetListModeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getListMode().get(i));
      }
    };
    if (json.has("listRuleId"))
      res.setListRuleIdElement(parseId(json.get("listRuleId").getAsString()));
    if (json.has("_listRuleId"))
      parseElementProperties(json.getAsJsonObject("_listRuleId"), res.getListRuleIdElement());
    if (json.has("transform"))
      res.setTransformElement(parseEnumeration(json.get("transform").getAsString(), StructureMap.StructureMapTransform.NULL, new StructureMap.StructureMapTransformEnumFactory()));
    if (json.has("_transform"))
      parseElementProperties(json.getAsJsonObject("_transform"), res.getTransformElement());
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseStructureMapStructureMapGroupRuleTargetParameterComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected StructureMap.StructureMapGroupRuleTargetParameterComponent parseStructureMapStructureMapGroupRuleTargetParameterComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapGroupRuleTargetParameterComponent res = new StructureMap.StructureMapGroupRuleTargetParameterComponent();
    parseStructureMapStructureMapGroupRuleTargetParameterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseStructureMapStructureMapGroupRuleTargetParameterComponentProperties(JsonObject json, StructureMap owner, StructureMap.StructureMapGroupRuleTargetParameterComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected StructureMap.StructureMapGroupRuleDependentComponent parseStructureMapStructureMapGroupRuleDependentComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapGroupRuleDependentComponent res = new StructureMap.StructureMapGroupRuleDependentComponent();
    parseStructureMapStructureMapGroupRuleDependentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseStructureMapStructureMapGroupRuleDependentComponentProperties(JsonObject json, StructureMap owner, StructureMap.StructureMapGroupRuleDependentComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseId(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("variable")) {
      JsonArray array = json.getAsJsonArray("variable");
      for (int i = 0; i < array.size(); i++) {
        res.getVariable().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_variable")) {
      JsonArray array = json.getAsJsonArray("_variable");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getVariable().size())
          res.getVariable().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getVariable().get(i));
      }
    };
  }

  protected Subscription parseSubscription(JsonObject json) throws IOException, FHIRFormatError {
    Subscription res = new Subscription();
    parseSubscriptionProperties(json, res);
    return res;
  }

  protected void parseSubscriptionProperties(JsonObject json, Subscription res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Subscription.SubscriptionStatus.NULL, new Subscription.SubscriptionStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("end"))
      res.setEndElement(parseInstant(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("reason"))
      res.setReasonElement(parseString(json.get("reason").getAsString()));
    if (json.has("_reason"))
      parseElementProperties(json.getAsJsonObject("_reason"), res.getReasonElement());
    if (json.has("criteria"))
      res.setCriteriaElement(parseString(json.get("criteria").getAsString()));
    if (json.has("_criteria"))
      parseElementProperties(json.getAsJsonObject("_criteria"), res.getCriteriaElement());
    if (json.has("error"))
      res.setErrorElement(parseString(json.get("error").getAsString()));
    if (json.has("_error"))
      parseElementProperties(json.getAsJsonObject("_error"), res.getErrorElement());
    if (json.has("channel"))
      res.setChannel(parseSubscriptionSubscriptionChannelComponent(json.getAsJsonObject("channel"), res));
    if (json.has("tag")) {
      JsonArray array = json.getAsJsonArray("tag");
      for (int i = 0; i < array.size(); i++) {
        res.getTag().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Subscription.SubscriptionChannelComponent parseSubscriptionSubscriptionChannelComponent(JsonObject json, Subscription owner) throws IOException, FHIRFormatError {
    Subscription.SubscriptionChannelComponent res = new Subscription.SubscriptionChannelComponent();
    parseSubscriptionSubscriptionChannelComponentProperties(json, owner, res);
    return res;
  }

  protected void parseSubscriptionSubscriptionChannelComponentProperties(JsonObject json, Subscription owner, Subscription.SubscriptionChannelComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Subscription.SubscriptionChannelType.NULL, new Subscription.SubscriptionChannelTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("endpoint"))
      res.setEndpointElement(parseUri(json.get("endpoint").getAsString()));
    if (json.has("_endpoint"))
      parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
    if (json.has("payload"))
      res.setPayloadElement(parseString(json.get("payload").getAsString()));
    if (json.has("_payload"))
      parseElementProperties(json.getAsJsonObject("_payload"), res.getPayloadElement());
    if (json.has("header")) {
      JsonArray array = json.getAsJsonArray("header");
      for (int i = 0; i < array.size(); i++) {
        res.getHeader().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_header")) {
      JsonArray array = json.getAsJsonArray("_header");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getHeader().size())
          res.getHeader().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getHeader().get(i));
      }
    };
  }

  protected Substance parseSubstance(JsonObject json) throws IOException, FHIRFormatError {
    Substance res = new Substance();
    parseSubstanceProperties(json, res);
    return res;
  }

  protected void parseSubstanceProperties(JsonObject json, Substance res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Substance.FHIRSubstanceStatus.NULL, new Substance.FHIRSubstanceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("instance")) {
      JsonArray array = json.getAsJsonArray("instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseSubstanceSubstanceInstanceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseSubstanceSubstanceIngredientComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Substance.SubstanceInstanceComponent parseSubstanceSubstanceInstanceComponent(JsonObject json, Substance owner) throws IOException, FHIRFormatError {
    Substance.SubstanceInstanceComponent res = new Substance.SubstanceInstanceComponent();
    parseSubstanceSubstanceInstanceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseSubstanceSubstanceInstanceComponentProperties(JsonObject json, Substance owner, Substance.SubstanceInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("expiry"))
      res.setExpiryElement(parseDateTime(json.get("expiry").getAsString()));
    if (json.has("_expiry"))
      parseElementProperties(json.getAsJsonObject("_expiry"), res.getExpiryElement());
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
  }

  protected Substance.SubstanceIngredientComponent parseSubstanceSubstanceIngredientComponent(JsonObject json, Substance owner) throws IOException, FHIRFormatError {
    Substance.SubstanceIngredientComponent res = new Substance.SubstanceIngredientComponent();
    parseSubstanceSubstanceIngredientComponentProperties(json, owner, res);
    return res;
  }

  protected void parseSubstanceSubstanceIngredientComponentProperties(JsonObject json, Substance owner, Substance.SubstanceIngredientComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("quantity"))
      res.setQuantity(parseRatio(json.getAsJsonObject("quantity")));
    Type substance = parseType("substance", json);
    if (substance != null)
      res.setSubstance(substance);
  }

  protected SupplyDelivery parseSupplyDelivery(JsonObject json) throws IOException, FHIRFormatError {
    SupplyDelivery res = new SupplyDelivery();
    parseSupplyDeliveryProperties(json, res);
    return res;
  }

  protected void parseSupplyDeliveryProperties(JsonObject json, SupplyDelivery res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), SupplyDelivery.SupplyDeliveryStatus.NULL, new SupplyDelivery.SupplyDeliveryStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("suppliedItem"))
      res.setSuppliedItem(parseSupplyDeliverySupplyDeliverySuppliedItemComponent(json.getAsJsonObject("suppliedItem"), res));
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("supplier"))
      res.setSupplier(parseReference(json.getAsJsonObject("supplier")));
    if (json.has("destination"))
      res.setDestination(parseReference(json.getAsJsonObject("destination")));
    if (json.has("receiver")) {
      JsonArray array = json.getAsJsonArray("receiver");
      for (int i = 0; i < array.size(); i++) {
        res.getReceiver().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected SupplyDelivery.SupplyDeliverySuppliedItemComponent parseSupplyDeliverySupplyDeliverySuppliedItemComponent(JsonObject json, SupplyDelivery owner) throws IOException, FHIRFormatError {
    SupplyDelivery.SupplyDeliverySuppliedItemComponent res = new SupplyDelivery.SupplyDeliverySuppliedItemComponent();
    parseSupplyDeliverySupplyDeliverySuppliedItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseSupplyDeliverySupplyDeliverySuppliedItemComponentProperties(JsonObject json, SupplyDelivery owner, SupplyDelivery.SupplyDeliverySuppliedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    Type item = parseType("item", json);
    if (item != null)
      res.setItem(item);
  }

  protected SupplyRequest parseSupplyRequest(JsonObject json) throws IOException, FHIRFormatError {
    SupplyRequest res = new SupplyRequest();
    parseSupplyRequestProperties(json, res);
    return res;
  }

  protected void parseSupplyRequestProperties(JsonObject json, SupplyRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), SupplyRequest.SupplyRequestStatus.NULL, new SupplyRequest.SupplyRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), SupplyRequest.RequestPriority.NULL, new SupplyRequest.RequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("orderedItem"))
      res.setOrderedItem(parseSupplyRequestSupplyRequestOrderedItemComponent(json.getAsJsonObject("orderedItem"), res));
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
    if (json.has("requester"))
      res.setRequester(parseSupplyRequestSupplyRequestRequesterComponent(json.getAsJsonObject("requester"), res));
    if (json.has("supplier")) {
      JsonArray array = json.getAsJsonArray("supplier");
      for (int i = 0; i < array.size(); i++) {
        res.getSupplier().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type reason = parseType("reason", json);
    if (reason != null)
      res.setReason(reason);
    if (json.has("deliverFrom"))
      res.setDeliverFrom(parseReference(json.getAsJsonObject("deliverFrom")));
    if (json.has("deliverTo"))
      res.setDeliverTo(parseReference(json.getAsJsonObject("deliverTo")));
  }

  protected SupplyRequest.SupplyRequestOrderedItemComponent parseSupplyRequestSupplyRequestOrderedItemComponent(JsonObject json, SupplyRequest owner) throws IOException, FHIRFormatError {
    SupplyRequest.SupplyRequestOrderedItemComponent res = new SupplyRequest.SupplyRequestOrderedItemComponent();
    parseSupplyRequestSupplyRequestOrderedItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseSupplyRequestSupplyRequestOrderedItemComponentProperties(JsonObject json, SupplyRequest owner, SupplyRequest.SupplyRequestOrderedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    Type item = parseType("item", json);
    if (item != null)
      res.setItem(item);
  }

  protected SupplyRequest.SupplyRequestRequesterComponent parseSupplyRequestSupplyRequestRequesterComponent(JsonObject json, SupplyRequest owner) throws IOException, FHIRFormatError {
    SupplyRequest.SupplyRequestRequesterComponent res = new SupplyRequest.SupplyRequestRequesterComponent();
    parseSupplyRequestSupplyRequestRequesterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseSupplyRequestSupplyRequestRequesterComponentProperties(JsonObject json, SupplyRequest owner, SupplyRequest.SupplyRequestRequesterComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("agent"))
      res.setAgent(parseReference(json.getAsJsonObject("agent")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(json.getAsJsonObject("onBehalfOf")));
  }

  protected Task parseTask(JsonObject json) throws IOException, FHIRFormatError {
    Task res = new Task();
    parseTaskProperties(json, res);
    return res;
  }

  protected void parseTaskProperties(JsonObject json, Task res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    Type definition = parseType("definition", json);
    if (definition != null)
      res.setDefinition(definition);
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(json.getAsJsonObject("groupIdentifier")));
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Task.TaskStatus.NULL, new Task.TaskStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(json.getAsJsonObject("statusReason")));
    if (json.has("businessStatus"))
      res.setBusinessStatus(parseCodeableConcept(json.getAsJsonObject("businessStatus")));
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), Task.TaskIntent.NULL, new Task.TaskIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), Task.TaskPriority.NULL, new Task.TaskPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("focus"))
      res.setFocus(parseReference(json.getAsJsonObject("focus")));
    if (json.has("for"))
      res.setFor(parseReference(json.getAsJsonObject("for")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("executionPeriod"))
      res.setExecutionPeriod(parsePeriod(json.getAsJsonObject("executionPeriod")));
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
    if (json.has("lastModified"))
      res.setLastModifiedElement(parseDateTime(json.get("lastModified").getAsString()));
    if (json.has("_lastModified"))
      parseElementProperties(json.getAsJsonObject("_lastModified"), res.getLastModifiedElement());
    if (json.has("requester"))
      res.setRequester(parseTaskTaskRequesterComponent(json.getAsJsonObject("requester"), res));
    if (json.has("performerType")) {
      JsonArray array = json.getAsJsonArray("performerType");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformerType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("owner"))
      res.setOwner(parseReference(json.getAsJsonObject("owner")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relevantHistory")) {
      JsonArray array = json.getAsJsonArray("relevantHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getRelevantHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("restriction"))
      res.setRestriction(parseTaskTaskRestrictionComponent(json.getAsJsonObject("restriction"), res));
    if (json.has("input")) {
      JsonArray array = json.getAsJsonArray("input");
      for (int i = 0; i < array.size(); i++) {
        res.getInput().add(parseTaskParameterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("output")) {
      JsonArray array = json.getAsJsonArray("output");
      for (int i = 0; i < array.size(); i++) {
        res.getOutput().add(parseTaskTaskOutputComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Task.TaskRequesterComponent parseTaskTaskRequesterComponent(JsonObject json, Task owner) throws IOException, FHIRFormatError {
    Task.TaskRequesterComponent res = new Task.TaskRequesterComponent();
    parseTaskTaskRequesterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTaskTaskRequesterComponentProperties(JsonObject json, Task owner, Task.TaskRequesterComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("agent"))
      res.setAgent(parseReference(json.getAsJsonObject("agent")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(json.getAsJsonObject("onBehalfOf")));
  }

  protected Task.TaskRestrictionComponent parseTaskTaskRestrictionComponent(JsonObject json, Task owner) throws IOException, FHIRFormatError {
    Task.TaskRestrictionComponent res = new Task.TaskRestrictionComponent();
    parseTaskTaskRestrictionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTaskTaskRestrictionComponentProperties(JsonObject json, Task owner, Task.TaskRestrictionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("repetitions"))
      res.setRepetitionsElement(parsePositiveInt(json.get("repetitions").getAsString()));
    if (json.has("_repetitions"))
      parseElementProperties(json.getAsJsonObject("_repetitions"), res.getRepetitionsElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Task.ParameterComponent parseTaskParameterComponent(JsonObject json, Task owner) throws IOException, FHIRFormatError {
    Task.ParameterComponent res = new Task.ParameterComponent();
    parseTaskParameterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTaskParameterComponentProperties(JsonObject json, Task owner, Task.ParameterComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Task.TaskOutputComponent parseTaskTaskOutputComponent(JsonObject json, Task owner) throws IOException, FHIRFormatError {
    Task.TaskOutputComponent res = new Task.TaskOutputComponent();
    parseTaskTaskOutputComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTaskTaskOutputComponentProperties(JsonObject json, Task owner, Task.TaskOutputComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected TestReport parseTestReport(JsonObject json) throws IOException, FHIRFormatError {
    TestReport res = new TestReport();
    parseTestReportProperties(json, res);
    return res;
  }

  protected void parseTestReportProperties(JsonObject json, TestReport res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), TestReport.TestReportStatus.NULL, new TestReport.TestReportStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("testScript"))
      res.setTestScript(parseReference(json.getAsJsonObject("testScript")));
    if (json.has("result"))
      res.setResultElement(parseEnumeration(json.get("result").getAsString(), TestReport.TestReportResult.NULL, new TestReport.TestReportResultEnumFactory()));
    if (json.has("_result"))
      parseElementProperties(json.getAsJsonObject("_result"), res.getResultElement());
    if (json.has("score"))
      res.setScoreElement(parseDecimal(json.get("score").getAsBigDecimal()));
    if (json.has("_score"))
      parseElementProperties(json.getAsJsonObject("_score"), res.getScoreElement());
    if (json.has("tester"))
      res.setTesterElement(parseString(json.get("tester").getAsString()));
    if (json.has("_tester"))
      parseElementProperties(json.getAsJsonObject("_tester"), res.getTesterElement());
    if (json.has("issued"))
      res.setIssuedElement(parseDateTime(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseTestReportTestReportParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("setup"))
      res.setSetup(parseTestReportTestReportSetupComponent(json.getAsJsonObject("setup"), res));
    if (json.has("test")) {
      JsonArray array = json.getAsJsonArray("test");
      for (int i = 0; i < array.size(); i++) {
        res.getTest().add(parseTestReportTestReportTestComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("teardown"))
      res.setTeardown(parseTestReportTestReportTeardownComponent(json.getAsJsonObject("teardown"), res));
  }

  protected TestReport.TestReportParticipantComponent parseTestReportTestReportParticipantComponent(JsonObject json, TestReport owner) throws IOException, FHIRFormatError {
    TestReport.TestReportParticipantComponent res = new TestReport.TestReportParticipantComponent();
    parseTestReportTestReportParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestReportTestReportParticipantComponentProperties(JsonObject json, TestReport owner, TestReport.TestReportParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), TestReport.TestReportParticipantType.NULL, new TestReport.TestReportParticipantTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
  }

  protected TestReport.TestReportSetupComponent parseTestReportTestReportSetupComponent(JsonObject json, TestReport owner) throws IOException, FHIRFormatError {
    TestReport.TestReportSetupComponent res = new TestReport.TestReportSetupComponent();
    parseTestReportTestReportSetupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestReportTestReportSetupComponentProperties(JsonObject json, TestReport owner, TestReport.TestReportSetupComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseTestReportSetupActionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected TestReport.SetupActionComponent parseTestReportSetupActionComponent(JsonObject json, TestReport owner) throws IOException, FHIRFormatError {
    TestReport.SetupActionComponent res = new TestReport.SetupActionComponent();
    parseTestReportSetupActionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestReportSetupActionComponentProperties(JsonObject json, TestReport owner, TestReport.SetupActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("operation"))
      res.setOperation(parseTestReportSetupActionOperationComponent(json.getAsJsonObject("operation"), owner));
    if (json.has("assert"))
      res.setAssert(parseTestReportSetupActionAssertComponent(json.getAsJsonObject("assert"), owner));
  }

  protected TestReport.SetupActionOperationComponent parseTestReportSetupActionOperationComponent(JsonObject json, TestReport owner) throws IOException, FHIRFormatError {
    TestReport.SetupActionOperationComponent res = new TestReport.SetupActionOperationComponent();
    parseTestReportSetupActionOperationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestReportSetupActionOperationComponentProperties(JsonObject json, TestReport owner, TestReport.SetupActionOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("result"))
      res.setResultElement(parseEnumeration(json.get("result").getAsString(), TestReport.TestReportActionResult.NULL, new TestReport.TestReportActionResultEnumFactory()));
    if (json.has("_result"))
      parseElementProperties(json.getAsJsonObject("_result"), res.getResultElement());
    if (json.has("message"))
      res.setMessageElement(parseMarkdown(json.get("message").getAsString()));
    if (json.has("_message"))
      parseElementProperties(json.getAsJsonObject("_message"), res.getMessageElement());
    if (json.has("detail"))
      res.setDetailElement(parseUri(json.get("detail").getAsString()));
    if (json.has("_detail"))
      parseElementProperties(json.getAsJsonObject("_detail"), res.getDetailElement());
  }

  protected TestReport.SetupActionAssertComponent parseTestReportSetupActionAssertComponent(JsonObject json, TestReport owner) throws IOException, FHIRFormatError {
    TestReport.SetupActionAssertComponent res = new TestReport.SetupActionAssertComponent();
    parseTestReportSetupActionAssertComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestReportSetupActionAssertComponentProperties(JsonObject json, TestReport owner, TestReport.SetupActionAssertComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("result"))
      res.setResultElement(parseEnumeration(json.get("result").getAsString(), TestReport.TestReportActionResult.NULL, new TestReport.TestReportActionResultEnumFactory()));
    if (json.has("_result"))
      parseElementProperties(json.getAsJsonObject("_result"), res.getResultElement());
    if (json.has("message"))
      res.setMessageElement(parseMarkdown(json.get("message").getAsString()));
    if (json.has("_message"))
      parseElementProperties(json.getAsJsonObject("_message"), res.getMessageElement());
    if (json.has("detail"))
      res.setDetailElement(parseString(json.get("detail").getAsString()));
    if (json.has("_detail"))
      parseElementProperties(json.getAsJsonObject("_detail"), res.getDetailElement());
  }

  protected TestReport.TestReportTestComponent parseTestReportTestReportTestComponent(JsonObject json, TestReport owner) throws IOException, FHIRFormatError {
    TestReport.TestReportTestComponent res = new TestReport.TestReportTestComponent();
    parseTestReportTestReportTestComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestReportTestReportTestComponentProperties(JsonObject json, TestReport owner, TestReport.TestReportTestComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseTestReportTestActionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected TestReport.TestActionComponent parseTestReportTestActionComponent(JsonObject json, TestReport owner) throws IOException, FHIRFormatError {
    TestReport.TestActionComponent res = new TestReport.TestActionComponent();
    parseTestReportTestActionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestReportTestActionComponentProperties(JsonObject json, TestReport owner, TestReport.TestActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("operation"))
      res.setOperation(parseTestReportSetupActionOperationComponent(json.getAsJsonObject("operation"), owner));
    if (json.has("assert"))
      res.setAssert(parseTestReportSetupActionAssertComponent(json.getAsJsonObject("assert"), owner));
  }

  protected TestReport.TestReportTeardownComponent parseTestReportTestReportTeardownComponent(JsonObject json, TestReport owner) throws IOException, FHIRFormatError {
    TestReport.TestReportTeardownComponent res = new TestReport.TestReportTeardownComponent();
    parseTestReportTestReportTeardownComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestReportTestReportTeardownComponentProperties(JsonObject json, TestReport owner, TestReport.TestReportTeardownComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseTestReportTeardownActionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected TestReport.TeardownActionComponent parseTestReportTeardownActionComponent(JsonObject json, TestReport owner) throws IOException, FHIRFormatError {
    TestReport.TeardownActionComponent res = new TestReport.TeardownActionComponent();
    parseTestReportTeardownActionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestReportTeardownActionComponentProperties(JsonObject json, TestReport owner, TestReport.TeardownActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("operation"))
      res.setOperation(parseTestReportSetupActionOperationComponent(json.getAsJsonObject("operation"), owner));
  }

  protected TestScript parseTestScript(JsonObject json) throws IOException, FHIRFormatError {
    TestScript res = new TestScript();
    parseTestScriptProperties(json, res);
    return res;
  }

  protected void parseTestScriptProperties(JsonObject json, TestScript res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("origin")) {
      JsonArray array = json.getAsJsonArray("origin");
      for (int i = 0; i < array.size(); i++) {
        res.getOrigin().add(parseTestScriptTestScriptOriginComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("destination")) {
      JsonArray array = json.getAsJsonArray("destination");
      for (int i = 0; i < array.size(); i++) {
        res.getDestination().add(parseTestScriptTestScriptDestinationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("metadata"))
      res.setMetadata(parseTestScriptTestScriptMetadataComponent(json.getAsJsonObject("metadata"), res));
    if (json.has("fixture")) {
      JsonArray array = json.getAsJsonArray("fixture");
      for (int i = 0; i < array.size(); i++) {
        res.getFixture().add(parseTestScriptTestScriptFixtureComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        res.getProfile().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("variable")) {
      JsonArray array = json.getAsJsonArray("variable");
      for (int i = 0; i < array.size(); i++) {
        res.getVariable().add(parseTestScriptTestScriptVariableComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("rule")) {
      JsonArray array = json.getAsJsonArray("rule");
      for (int i = 0; i < array.size(); i++) {
        res.getRule().add(parseTestScriptTestScriptRuleComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("ruleset")) {
      JsonArray array = json.getAsJsonArray("ruleset");
      for (int i = 0; i < array.size(); i++) {
        res.getRuleset().add(parseTestScriptTestScriptRulesetComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("setup"))
      res.setSetup(parseTestScriptTestScriptSetupComponent(json.getAsJsonObject("setup"), res));
    if (json.has("test")) {
      JsonArray array = json.getAsJsonArray("test");
      for (int i = 0; i < array.size(); i++) {
        res.getTest().add(parseTestScriptTestScriptTestComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("teardown"))
      res.setTeardown(parseTestScriptTestScriptTeardownComponent(json.getAsJsonObject("teardown"), res));
  }

  protected TestScript.TestScriptOriginComponent parseTestScriptTestScriptOriginComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptOriginComponent res = new TestScript.TestScriptOriginComponent();
    parseTestScriptTestScriptOriginComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptTestScriptOriginComponentProperties(JsonObject json, TestScript owner, TestScript.TestScriptOriginComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("index"))
      res.setIndexElement(parseInteger(json.get("index").getAsLong()));
    if (json.has("_index"))
      parseElementProperties(json.getAsJsonObject("_index"), res.getIndexElement());
    if (json.has("profile"))
      res.setProfile(parseCoding(json.getAsJsonObject("profile")));
  }

  protected TestScript.TestScriptDestinationComponent parseTestScriptTestScriptDestinationComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptDestinationComponent res = new TestScript.TestScriptDestinationComponent();
    parseTestScriptTestScriptDestinationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptTestScriptDestinationComponentProperties(JsonObject json, TestScript owner, TestScript.TestScriptDestinationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("index"))
      res.setIndexElement(parseInteger(json.get("index").getAsLong()));
    if (json.has("_index"))
      parseElementProperties(json.getAsJsonObject("_index"), res.getIndexElement());
    if (json.has("profile"))
      res.setProfile(parseCoding(json.getAsJsonObject("profile")));
  }

  protected TestScript.TestScriptMetadataComponent parseTestScriptTestScriptMetadataComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptMetadataComponent res = new TestScript.TestScriptMetadataComponent();
    parseTestScriptTestScriptMetadataComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptTestScriptMetadataComponentProperties(JsonObject json, TestScript owner, TestScript.TestScriptMetadataComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseTestScriptTestScriptMetadataLinkComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("capability")) {
      JsonArray array = json.getAsJsonArray("capability");
      for (int i = 0; i < array.size(); i++) {
        res.getCapability().add(parseTestScriptTestScriptMetadataCapabilityComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected TestScript.TestScriptMetadataLinkComponent parseTestScriptTestScriptMetadataLinkComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptMetadataLinkComponent res = new TestScript.TestScriptMetadataLinkComponent();
    parseTestScriptTestScriptMetadataLinkComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptTestScriptMetadataLinkComponentProperties(JsonObject json, TestScript owner, TestScript.TestScriptMetadataLinkComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
  }

  protected TestScript.TestScriptMetadataCapabilityComponent parseTestScriptTestScriptMetadataCapabilityComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptMetadataCapabilityComponent res = new TestScript.TestScriptMetadataCapabilityComponent();
    parseTestScriptTestScriptMetadataCapabilityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptTestScriptMetadataCapabilityComponentProperties(JsonObject json, TestScript owner, TestScript.TestScriptMetadataCapabilityComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("required"))
      res.setRequiredElement(parseBoolean(json.get("required").getAsBoolean()));
    if (json.has("_required"))
      parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
    if (json.has("validated"))
      res.setValidatedElement(parseBoolean(json.get("validated").getAsBoolean()));
    if (json.has("_validated"))
      parseElementProperties(json.getAsJsonObject("_validated"), res.getValidatedElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("origin")) {
      JsonArray array = json.getAsJsonArray("origin");
      for (int i = 0; i < array.size(); i++) {
        res.getOrigin().add(parseInteger(array.get(i).getAsLong()));
      }
    };
    if (json.has("_origin")) {
      JsonArray array = json.getAsJsonArray("_origin");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getOrigin().size())
          res.getOrigin().add(parseInteger(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getOrigin().get(i));
      }
    };
    if (json.has("destination"))
      res.setDestinationElement(parseInteger(json.get("destination").getAsLong()));
    if (json.has("_destination"))
      parseElementProperties(json.getAsJsonObject("_destination"), res.getDestinationElement());
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_link")) {
      JsonArray array = json.getAsJsonArray("_link");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLink().size())
          res.getLink().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLink().get(i));
      }
    };
    if (json.has("capabilities"))
      res.setCapabilities(parseReference(json.getAsJsonObject("capabilities")));
  }

  protected TestScript.TestScriptFixtureComponent parseTestScriptTestScriptFixtureComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptFixtureComponent res = new TestScript.TestScriptFixtureComponent();
    parseTestScriptTestScriptFixtureComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptTestScriptFixtureComponentProperties(JsonObject json, TestScript owner, TestScript.TestScriptFixtureComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("autocreate"))
      res.setAutocreateElement(parseBoolean(json.get("autocreate").getAsBoolean()));
    if (json.has("_autocreate"))
      parseElementProperties(json.getAsJsonObject("_autocreate"), res.getAutocreateElement());
    if (json.has("autodelete"))
      res.setAutodeleteElement(parseBoolean(json.get("autodelete").getAsBoolean()));
    if (json.has("_autodelete"))
      parseElementProperties(json.getAsJsonObject("_autodelete"), res.getAutodeleteElement());
    if (json.has("resource"))
      res.setResource(parseReference(json.getAsJsonObject("resource")));
  }

  protected TestScript.TestScriptVariableComponent parseTestScriptTestScriptVariableComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptVariableComponent res = new TestScript.TestScriptVariableComponent();
    parseTestScriptTestScriptVariableComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptTestScriptVariableComponentProperties(JsonObject json, TestScript owner, TestScript.TestScriptVariableComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("defaultValue"))
      res.setDefaultValueElement(parseString(json.get("defaultValue").getAsString()));
    if (json.has("_defaultValue"))
      parseElementProperties(json.getAsJsonObject("_defaultValue"), res.getDefaultValueElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
    if (json.has("headerField"))
      res.setHeaderFieldElement(parseString(json.get("headerField").getAsString()));
    if (json.has("_headerField"))
      parseElementProperties(json.getAsJsonObject("_headerField"), res.getHeaderFieldElement());
    if (json.has("hint"))
      res.setHintElement(parseString(json.get("hint").getAsString()));
    if (json.has("_hint"))
      parseElementProperties(json.getAsJsonObject("_hint"), res.getHintElement());
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("sourceId"))
      res.setSourceIdElement(parseId(json.get("sourceId").getAsString()));
    if (json.has("_sourceId"))
      parseElementProperties(json.getAsJsonObject("_sourceId"), res.getSourceIdElement());
  }

  protected TestScript.TestScriptRuleComponent parseTestScriptTestScriptRuleComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptRuleComponent res = new TestScript.TestScriptRuleComponent();
    parseTestScriptTestScriptRuleComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptTestScriptRuleComponentProperties(JsonObject json, TestScript owner, TestScript.TestScriptRuleComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("resource"))
      res.setResource(parseReference(json.getAsJsonObject("resource")));
    if (json.has("param")) {
      JsonArray array = json.getAsJsonArray("param");
      for (int i = 0; i < array.size(); i++) {
        res.getParam().add(parseTestScriptRuleParamComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected TestScript.RuleParamComponent parseTestScriptRuleParamComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.RuleParamComponent res = new TestScript.RuleParamComponent();
    parseTestScriptRuleParamComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptRuleParamComponentProperties(JsonObject json, TestScript owner, TestScript.RuleParamComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected TestScript.TestScriptRulesetComponent parseTestScriptTestScriptRulesetComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptRulesetComponent res = new TestScript.TestScriptRulesetComponent();
    parseTestScriptTestScriptRulesetComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptTestScriptRulesetComponentProperties(JsonObject json, TestScript owner, TestScript.TestScriptRulesetComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("resource"))
      res.setResource(parseReference(json.getAsJsonObject("resource")));
    if (json.has("rule")) {
      JsonArray array = json.getAsJsonArray("rule");
      for (int i = 0; i < array.size(); i++) {
        res.getRule().add(parseTestScriptRulesetRuleComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected TestScript.RulesetRuleComponent parseTestScriptRulesetRuleComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.RulesetRuleComponent res = new TestScript.RulesetRuleComponent();
    parseTestScriptRulesetRuleComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptRulesetRuleComponentProperties(JsonObject json, TestScript owner, TestScript.RulesetRuleComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("ruleId"))
      res.setRuleIdElement(parseId(json.get("ruleId").getAsString()));
    if (json.has("_ruleId"))
      parseElementProperties(json.getAsJsonObject("_ruleId"), res.getRuleIdElement());
    if (json.has("param")) {
      JsonArray array = json.getAsJsonArray("param");
      for (int i = 0; i < array.size(); i++) {
        res.getParam().add(parseTestScriptRulesetRuleParamComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected TestScript.RulesetRuleParamComponent parseTestScriptRulesetRuleParamComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.RulesetRuleParamComponent res = new TestScript.RulesetRuleParamComponent();
    parseTestScriptRulesetRuleParamComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptRulesetRuleParamComponentProperties(JsonObject json, TestScript owner, TestScript.RulesetRuleParamComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected TestScript.TestScriptSetupComponent parseTestScriptTestScriptSetupComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptSetupComponent res = new TestScript.TestScriptSetupComponent();
    parseTestScriptTestScriptSetupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptTestScriptSetupComponentProperties(JsonObject json, TestScript owner, TestScript.TestScriptSetupComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseTestScriptSetupActionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected TestScript.SetupActionComponent parseTestScriptSetupActionComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.SetupActionComponent res = new TestScript.SetupActionComponent();
    parseTestScriptSetupActionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptSetupActionComponentProperties(JsonObject json, TestScript owner, TestScript.SetupActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("operation"))
      res.setOperation(parseTestScriptSetupActionOperationComponent(json.getAsJsonObject("operation"), owner));
    if (json.has("assert"))
      res.setAssert(parseTestScriptSetupActionAssertComponent(json.getAsJsonObject("assert"), owner));
  }

  protected TestScript.SetupActionOperationComponent parseTestScriptSetupActionOperationComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.SetupActionOperationComponent res = new TestScript.SetupActionOperationComponent();
    parseTestScriptSetupActionOperationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptSetupActionOperationComponentProperties(JsonObject json, TestScript owner, TestScript.SetupActionOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("resource"))
      res.setResourceElement(parseCode(json.get("resource").getAsString()));
    if (json.has("_resource"))
      parseElementProperties(json.getAsJsonObject("_resource"), res.getResourceElement());
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("accept"))
      res.setAcceptElement(parseEnumeration(json.get("accept").getAsString(), TestScript.ContentType.NULL, new TestScript.ContentTypeEnumFactory()));
    if (json.has("_accept"))
      parseElementProperties(json.getAsJsonObject("_accept"), res.getAcceptElement());
    if (json.has("contentType"))
      res.setContentTypeElement(parseEnumeration(json.get("contentType").getAsString(), TestScript.ContentType.NULL, new TestScript.ContentTypeEnumFactory()));
    if (json.has("_contentType"))
      parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
    if (json.has("destination"))
      res.setDestinationElement(parseInteger(json.get("destination").getAsLong()));
    if (json.has("_destination"))
      parseElementProperties(json.getAsJsonObject("_destination"), res.getDestinationElement());
    if (json.has("encodeRequestUrl"))
      res.setEncodeRequestUrlElement(parseBoolean(json.get("encodeRequestUrl").getAsBoolean()));
    if (json.has("_encodeRequestUrl"))
      parseElementProperties(json.getAsJsonObject("_encodeRequestUrl"), res.getEncodeRequestUrlElement());
    if (json.has("origin"))
      res.setOriginElement(parseInteger(json.get("origin").getAsLong()));
    if (json.has("_origin"))
      parseElementProperties(json.getAsJsonObject("_origin"), res.getOriginElement());
    if (json.has("params"))
      res.setParamsElement(parseString(json.get("params").getAsString()));
    if (json.has("_params"))
      parseElementProperties(json.getAsJsonObject("_params"), res.getParamsElement());
    if (json.has("requestHeader")) {
      JsonArray array = json.getAsJsonArray("requestHeader");
      for (int i = 0; i < array.size(); i++) {
        res.getRequestHeader().add(parseTestScriptSetupActionOperationRequestHeaderComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("requestId"))
      res.setRequestIdElement(parseId(json.get("requestId").getAsString()));
    if (json.has("_requestId"))
      parseElementProperties(json.getAsJsonObject("_requestId"), res.getRequestIdElement());
    if (json.has("responseId"))
      res.setResponseIdElement(parseId(json.get("responseId").getAsString()));
    if (json.has("_responseId"))
      parseElementProperties(json.getAsJsonObject("_responseId"), res.getResponseIdElement());
    if (json.has("sourceId"))
      res.setSourceIdElement(parseId(json.get("sourceId").getAsString()));
    if (json.has("_sourceId"))
      parseElementProperties(json.getAsJsonObject("_sourceId"), res.getSourceIdElement());
    if (json.has("targetId"))
      res.setTargetIdElement(parseId(json.get("targetId").getAsString()));
    if (json.has("_targetId"))
      parseElementProperties(json.getAsJsonObject("_targetId"), res.getTargetIdElement());
    if (json.has("url"))
      res.setUrlElement(parseString(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
  }

  protected TestScript.SetupActionOperationRequestHeaderComponent parseTestScriptSetupActionOperationRequestHeaderComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.SetupActionOperationRequestHeaderComponent res = new TestScript.SetupActionOperationRequestHeaderComponent();
    parseTestScriptSetupActionOperationRequestHeaderComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptSetupActionOperationRequestHeaderComponentProperties(JsonObject json, TestScript owner, TestScript.SetupActionOperationRequestHeaderComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("field"))
      res.setFieldElement(parseString(json.get("field").getAsString()));
    if (json.has("_field"))
      parseElementProperties(json.getAsJsonObject("_field"), res.getFieldElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected TestScript.SetupActionAssertComponent parseTestScriptSetupActionAssertComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.SetupActionAssertComponent res = new TestScript.SetupActionAssertComponent();
    parseTestScriptSetupActionAssertComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptSetupActionAssertComponentProperties(JsonObject json, TestScript owner, TestScript.SetupActionAssertComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("direction"))
      res.setDirectionElement(parseEnumeration(json.get("direction").getAsString(), TestScript.AssertionDirectionType.NULL, new TestScript.AssertionDirectionTypeEnumFactory()));
    if (json.has("_direction"))
      parseElementProperties(json.getAsJsonObject("_direction"), res.getDirectionElement());
    if (json.has("compareToSourceId"))
      res.setCompareToSourceIdElement(parseString(json.get("compareToSourceId").getAsString()));
    if (json.has("_compareToSourceId"))
      parseElementProperties(json.getAsJsonObject("_compareToSourceId"), res.getCompareToSourceIdElement());
    if (json.has("compareToSourceExpression"))
      res.setCompareToSourceExpressionElement(parseString(json.get("compareToSourceExpression").getAsString()));
    if (json.has("_compareToSourceExpression"))
      parseElementProperties(json.getAsJsonObject("_compareToSourceExpression"), res.getCompareToSourceExpressionElement());
    if (json.has("compareToSourcePath"))
      res.setCompareToSourcePathElement(parseString(json.get("compareToSourcePath").getAsString()));
    if (json.has("_compareToSourcePath"))
      parseElementProperties(json.getAsJsonObject("_compareToSourcePath"), res.getCompareToSourcePathElement());
    if (json.has("contentType"))
      res.setContentTypeElement(parseEnumeration(json.get("contentType").getAsString(), TestScript.ContentType.NULL, new TestScript.ContentTypeEnumFactory()));
    if (json.has("_contentType"))
      parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
    if (json.has("headerField"))
      res.setHeaderFieldElement(parseString(json.get("headerField").getAsString()));
    if (json.has("_headerField"))
      parseElementProperties(json.getAsJsonObject("_headerField"), res.getHeaderFieldElement());
    if (json.has("minimumId"))
      res.setMinimumIdElement(parseString(json.get("minimumId").getAsString()));
    if (json.has("_minimumId"))
      parseElementProperties(json.getAsJsonObject("_minimumId"), res.getMinimumIdElement());
    if (json.has("navigationLinks"))
      res.setNavigationLinksElement(parseBoolean(json.get("navigationLinks").getAsBoolean()));
    if (json.has("_navigationLinks"))
      parseElementProperties(json.getAsJsonObject("_navigationLinks"), res.getNavigationLinksElement());
    if (json.has("operator"))
      res.setOperatorElement(parseEnumeration(json.get("operator").getAsString(), TestScript.AssertionOperatorType.NULL, new TestScript.AssertionOperatorTypeEnumFactory()));
    if (json.has("_operator"))
      parseElementProperties(json.getAsJsonObject("_operator"), res.getOperatorElement());
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("requestMethod"))
      res.setRequestMethodElement(parseEnumeration(json.get("requestMethod").getAsString(), TestScript.TestScriptRequestMethodCode.NULL, new TestScript.TestScriptRequestMethodCodeEnumFactory()));
    if (json.has("_requestMethod"))
      parseElementProperties(json.getAsJsonObject("_requestMethod"), res.getRequestMethodElement());
    if (json.has("requestURL"))
      res.setRequestURLElement(parseString(json.get("requestURL").getAsString()));
    if (json.has("_requestURL"))
      parseElementProperties(json.getAsJsonObject("_requestURL"), res.getRequestURLElement());
    if (json.has("resource"))
      res.setResourceElement(parseCode(json.get("resource").getAsString()));
    if (json.has("_resource"))
      parseElementProperties(json.getAsJsonObject("_resource"), res.getResourceElement());
    if (json.has("response"))
      res.setResponseElement(parseEnumeration(json.get("response").getAsString(), TestScript.AssertionResponseTypes.NULL, new TestScript.AssertionResponseTypesEnumFactory()));
    if (json.has("_response"))
      parseElementProperties(json.getAsJsonObject("_response"), res.getResponseElement());
    if (json.has("responseCode"))
      res.setResponseCodeElement(parseString(json.get("responseCode").getAsString()));
    if (json.has("_responseCode"))
      parseElementProperties(json.getAsJsonObject("_responseCode"), res.getResponseCodeElement());
    if (json.has("rule"))
      res.setRule(parseTestScriptActionAssertRuleComponent(json.getAsJsonObject("rule"), owner));
    if (json.has("ruleset"))
      res.setRuleset(parseTestScriptActionAssertRulesetComponent(json.getAsJsonObject("ruleset"), owner));
    if (json.has("sourceId"))
      res.setSourceIdElement(parseId(json.get("sourceId").getAsString()));
    if (json.has("_sourceId"))
      parseElementProperties(json.getAsJsonObject("_sourceId"), res.getSourceIdElement());
    if (json.has("validateProfileId"))
      res.setValidateProfileIdElement(parseId(json.get("validateProfileId").getAsString()));
    if (json.has("_validateProfileId"))
      parseElementProperties(json.getAsJsonObject("_validateProfileId"), res.getValidateProfileIdElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("warningOnly"))
      res.setWarningOnlyElement(parseBoolean(json.get("warningOnly").getAsBoolean()));
    if (json.has("_warningOnly"))
      parseElementProperties(json.getAsJsonObject("_warningOnly"), res.getWarningOnlyElement());
  }

  protected TestScript.ActionAssertRuleComponent parseTestScriptActionAssertRuleComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.ActionAssertRuleComponent res = new TestScript.ActionAssertRuleComponent();
    parseTestScriptActionAssertRuleComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptActionAssertRuleComponentProperties(JsonObject json, TestScript owner, TestScript.ActionAssertRuleComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("ruleId"))
      res.setRuleIdElement(parseId(json.get("ruleId").getAsString()));
    if (json.has("_ruleId"))
      parseElementProperties(json.getAsJsonObject("_ruleId"), res.getRuleIdElement());
    if (json.has("param")) {
      JsonArray array = json.getAsJsonArray("param");
      for (int i = 0; i < array.size(); i++) {
        res.getParam().add(parseTestScriptActionAssertRuleParamComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected TestScript.ActionAssertRuleParamComponent parseTestScriptActionAssertRuleParamComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.ActionAssertRuleParamComponent res = new TestScript.ActionAssertRuleParamComponent();
    parseTestScriptActionAssertRuleParamComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptActionAssertRuleParamComponentProperties(JsonObject json, TestScript owner, TestScript.ActionAssertRuleParamComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected TestScript.ActionAssertRulesetComponent parseTestScriptActionAssertRulesetComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.ActionAssertRulesetComponent res = new TestScript.ActionAssertRulesetComponent();
    parseTestScriptActionAssertRulesetComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptActionAssertRulesetComponentProperties(JsonObject json, TestScript owner, TestScript.ActionAssertRulesetComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("rulesetId"))
      res.setRulesetIdElement(parseId(json.get("rulesetId").getAsString()));
    if (json.has("_rulesetId"))
      parseElementProperties(json.getAsJsonObject("_rulesetId"), res.getRulesetIdElement());
    if (json.has("rule")) {
      JsonArray array = json.getAsJsonArray("rule");
      for (int i = 0; i < array.size(); i++) {
        res.getRule().add(parseTestScriptActionAssertRulesetRuleComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected TestScript.ActionAssertRulesetRuleComponent parseTestScriptActionAssertRulesetRuleComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.ActionAssertRulesetRuleComponent res = new TestScript.ActionAssertRulesetRuleComponent();
    parseTestScriptActionAssertRulesetRuleComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptActionAssertRulesetRuleComponentProperties(JsonObject json, TestScript owner, TestScript.ActionAssertRulesetRuleComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("ruleId"))
      res.setRuleIdElement(parseId(json.get("ruleId").getAsString()));
    if (json.has("_ruleId"))
      parseElementProperties(json.getAsJsonObject("_ruleId"), res.getRuleIdElement());
    if (json.has("param")) {
      JsonArray array = json.getAsJsonArray("param");
      for (int i = 0; i < array.size(); i++) {
        res.getParam().add(parseTestScriptActionAssertRulesetRuleParamComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected TestScript.ActionAssertRulesetRuleParamComponent parseTestScriptActionAssertRulesetRuleParamComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.ActionAssertRulesetRuleParamComponent res = new TestScript.ActionAssertRulesetRuleParamComponent();
    parseTestScriptActionAssertRulesetRuleParamComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptActionAssertRulesetRuleParamComponentProperties(JsonObject json, TestScript owner, TestScript.ActionAssertRulesetRuleParamComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected TestScript.TestScriptTestComponent parseTestScriptTestScriptTestComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptTestComponent res = new TestScript.TestScriptTestComponent();
    parseTestScriptTestScriptTestComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptTestScriptTestComponentProperties(JsonObject json, TestScript owner, TestScript.TestScriptTestComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseTestScriptTestActionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected TestScript.TestActionComponent parseTestScriptTestActionComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestActionComponent res = new TestScript.TestActionComponent();
    parseTestScriptTestActionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptTestActionComponentProperties(JsonObject json, TestScript owner, TestScript.TestActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("operation"))
      res.setOperation(parseTestScriptSetupActionOperationComponent(json.getAsJsonObject("operation"), owner));
    if (json.has("assert"))
      res.setAssert(parseTestScriptSetupActionAssertComponent(json.getAsJsonObject("assert"), owner));
  }

  protected TestScript.TestScriptTeardownComponent parseTestScriptTestScriptTeardownComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptTeardownComponent res = new TestScript.TestScriptTeardownComponent();
    parseTestScriptTestScriptTeardownComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptTestScriptTeardownComponentProperties(JsonObject json, TestScript owner, TestScript.TestScriptTeardownComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseTestScriptTeardownActionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected TestScript.TeardownActionComponent parseTestScriptTeardownActionComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TeardownActionComponent res = new TestScript.TeardownActionComponent();
    parseTestScriptTeardownActionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTestScriptTeardownActionComponentProperties(JsonObject json, TestScript owner, TestScript.TeardownActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("operation"))
      res.setOperation(parseTestScriptSetupActionOperationComponent(json.getAsJsonObject("operation"), owner));
  }

  protected ValueSet parseValueSet(JsonObject json) throws IOException, FHIRFormatError {
    ValueSet res = new ValueSet();
    parseValueSetProperties(json, res);
    return res;
  }

  protected void parseValueSetProperties(JsonObject json, ValueSet res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("immutable"))
      res.setImmutableElement(parseBoolean(json.get("immutable").getAsBoolean()));
    if (json.has("_immutable"))
      parseElementProperties(json.getAsJsonObject("_immutable"), res.getImmutableElement());
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("extensible"))
      res.setExtensibleElement(parseBoolean(json.get("extensible").getAsBoolean()));
    if (json.has("_extensible"))
      parseElementProperties(json.getAsJsonObject("_extensible"), res.getExtensibleElement());
    if (json.has("compose"))
      res.setCompose(parseValueSetValueSetComposeComponent(json.getAsJsonObject("compose"), res));
    if (json.has("expansion"))
      res.setExpansion(parseValueSetValueSetExpansionComponent(json.getAsJsonObject("expansion"), res));
  }

  protected ValueSet.ValueSetComposeComponent parseValueSetValueSetComposeComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
    ValueSet.ValueSetComposeComponent res = new ValueSet.ValueSetComposeComponent();
    parseValueSetValueSetComposeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseValueSetValueSetComposeComponentProperties(JsonObject json, ValueSet owner, ValueSet.ValueSetComposeComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("lockedDate"))
      res.setLockedDateElement(parseDate(json.get("lockedDate").getAsString()));
    if (json.has("_lockedDate"))
      parseElementProperties(json.getAsJsonObject("_lockedDate"), res.getLockedDateElement());
    if (json.has("inactive"))
      res.setInactiveElement(parseBoolean(json.get("inactive").getAsBoolean()));
    if (json.has("_inactive"))
      parseElementProperties(json.getAsJsonObject("_inactive"), res.getInactiveElement());
    if (json.has("include")) {
      JsonArray array = json.getAsJsonArray("include");
      for (int i = 0; i < array.size(); i++) {
        res.getInclude().add(parseValueSetConceptSetComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("exclude")) {
      JsonArray array = json.getAsJsonArray("exclude");
      for (int i = 0; i < array.size(); i++) {
        res.getExclude().add(parseValueSetConceptSetComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ValueSet.ConceptSetComponent parseValueSetConceptSetComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
    ValueSet.ConceptSetComponent res = new ValueSet.ConceptSetComponent();
    parseValueSetConceptSetComponentProperties(json, owner, res);
    return res;
  }

  protected void parseValueSetConceptSetComponentProperties(JsonObject json, ValueSet owner, ValueSet.ConceptSetComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("concept")) {
      JsonArray array = json.getAsJsonArray("concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseValueSetConceptReferenceComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("filter")) {
      JsonArray array = json.getAsJsonArray("filter");
      for (int i = 0; i < array.size(); i++) {
        res.getFilter().add(parseValueSetConceptSetFilterComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("valueSet")) {
      JsonArray array = json.getAsJsonArray("valueSet");
      for (int i = 0; i < array.size(); i++) {
        res.getValueSet().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_valueSet")) {
      JsonArray array = json.getAsJsonArray("_valueSet");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getValueSet().size())
          res.getValueSet().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getValueSet().get(i));
      }
    };
  }

  protected ValueSet.ConceptReferenceComponent parseValueSetConceptReferenceComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
    ValueSet.ConceptReferenceComponent res = new ValueSet.ConceptReferenceComponent();
    parseValueSetConceptReferenceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseValueSetConceptReferenceComponentProperties(JsonObject json, ValueSet owner, ValueSet.ConceptReferenceComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("designation")) {
      JsonArray array = json.getAsJsonArray("designation");
      for (int i = 0; i < array.size(); i++) {
        res.getDesignation().add(parseValueSetConceptReferenceDesignationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ValueSet.ConceptReferenceDesignationComponent parseValueSetConceptReferenceDesignationComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
    ValueSet.ConceptReferenceDesignationComponent res = new ValueSet.ConceptReferenceDesignationComponent();
    parseValueSetConceptReferenceDesignationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseValueSetConceptReferenceDesignationComponentProperties(JsonObject json, ValueSet owner, ValueSet.ConceptReferenceDesignationComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("use"))
      res.setUse(parseCoding(json.getAsJsonObject("use")));
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected ValueSet.ConceptSetFilterComponent parseValueSetConceptSetFilterComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
    ValueSet.ConceptSetFilterComponent res = new ValueSet.ConceptSetFilterComponent();
    parseValueSetConceptSetFilterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseValueSetConceptSetFilterComponentProperties(JsonObject json, ValueSet owner, ValueSet.ConceptSetFilterComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("property"))
      res.setPropertyElement(parseCode(json.get("property").getAsString()));
    if (json.has("_property"))
      parseElementProperties(json.getAsJsonObject("_property"), res.getPropertyElement());
    if (json.has("op"))
      res.setOpElement(parseEnumeration(json.get("op").getAsString(), ValueSet.FilterOperator.NULL, new ValueSet.FilterOperatorEnumFactory()));
    if (json.has("_op"))
      parseElementProperties(json.getAsJsonObject("_op"), res.getOpElement());
    if (json.has("value"))
      res.setValueElement(parseCode(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected ValueSet.ValueSetExpansionComponent parseValueSetValueSetExpansionComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
    ValueSet.ValueSetExpansionComponent res = new ValueSet.ValueSetExpansionComponent();
    parseValueSetValueSetExpansionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseValueSetValueSetExpansionComponentProperties(JsonObject json, ValueSet owner, ValueSet.ValueSetExpansionComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifierElement(parseUri(json.get("identifier").getAsString()));
    if (json.has("_identifier"))
      parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
    if (json.has("timestamp"))
      res.setTimestampElement(parseDateTime(json.get("timestamp").getAsString()));
    if (json.has("_timestamp"))
      parseElementProperties(json.getAsJsonObject("_timestamp"), res.getTimestampElement());
    if (json.has("total"))
      res.setTotalElement(parseInteger(json.get("total").getAsLong()));
    if (json.has("_total"))
      parseElementProperties(json.getAsJsonObject("_total"), res.getTotalElement());
    if (json.has("offset"))
      res.setOffsetElement(parseInteger(json.get("offset").getAsLong()));
    if (json.has("_offset"))
      parseElementProperties(json.getAsJsonObject("_offset"), res.getOffsetElement());
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseValueSetValueSetExpansionParameterComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("contains")) {
      JsonArray array = json.getAsJsonArray("contains");
      for (int i = 0; i < array.size(); i++) {
        res.getContains().add(parseValueSetValueSetExpansionContainsComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ValueSet.ValueSetExpansionParameterComponent parseValueSetValueSetExpansionParameterComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
    ValueSet.ValueSetExpansionParameterComponent res = new ValueSet.ValueSetExpansionParameterComponent();
    parseValueSetValueSetExpansionParameterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseValueSetValueSetExpansionParameterComponentProperties(JsonObject json, ValueSet owner, ValueSet.ValueSetExpansionParameterComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected ValueSet.ValueSetExpansionContainsComponent parseValueSetValueSetExpansionContainsComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
    ValueSet.ValueSetExpansionContainsComponent res = new ValueSet.ValueSetExpansionContainsComponent();
    parseValueSetValueSetExpansionContainsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseValueSetValueSetExpansionContainsComponentProperties(JsonObject json, ValueSet owner, ValueSet.ValueSetExpansionContainsComponent res) throws IOException, FHIRFormatError {
    parseBackboneProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("abstract"))
      res.setAbstractElement(parseBoolean(json.get("abstract").getAsBoolean()));
    if (json.has("_abstract"))
      parseElementProperties(json.getAsJsonObject("_abstract"), res.getAbstractElement());
    if (json.has("inactive"))
