/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum GuideDependencyType {
    REFERENCE,
    INCLUSION,
    NULL;


    public static GuideDependencyType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("reference".equals(codeString)) {
            return REFERENCE;
        }
        if ("inclusion".equals(codeString)) {
            return INCLUSION;
        }
        throw new FHIRException("Unknown GuideDependencyType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case REFERENCE: {
                return "reference";
            }
            case INCLUSION: {
                return "inclusion";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/guide-dependency-type";
    }

    public String getDefinition() {
        switch (this) {
            case REFERENCE: {
                return "The guide is referred to by URL.";
            }
            case INCLUSION: {
                return "The guide is embedded in this guide when published.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case REFERENCE: {
                return "Reference";
            }
            case INCLUSION: {
                return "Inclusion";
            }
        }
        return "?";
    }
}

