/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MedicationPackageForm {
    AMPOULE,
    BOTTLE,
    BOX,
    CARTRIDGE,
    CONTAINER,
    TUBE,
    UNITDOSE,
    VIAL,
    NULL;


    public static MedicationPackageForm fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ampoule".equals(codeString)) {
            return AMPOULE;
        }
        if ("bottle".equals(codeString)) {
            return BOTTLE;
        }
        if ("box".equals(codeString)) {
            return BOX;
        }
        if ("cartridge".equals(codeString)) {
            return CARTRIDGE;
        }
        if ("container".equals(codeString)) {
            return CONTAINER;
        }
        if ("tube".equals(codeString)) {
            return TUBE;
        }
        if ("unitdose".equals(codeString)) {
            return UNITDOSE;
        }
        if ("vial".equals(codeString)) {
            return VIAL;
        }
        throw new FHIRException("Unknown MedicationPackageForm code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AMPOULE: {
                return "ampoule";
            }
            case BOTTLE: {
                return "bottle";
            }
            case BOX: {
                return "box";
            }
            case CARTRIDGE: {
                return "cartridge";
            }
            case CONTAINER: {
                return "container";
            }
            case TUBE: {
                return "tube";
            }
            case UNITDOSE: {
                return "unitdose";
            }
            case VIAL: {
                return "vial";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/medication-package-form";
    }

    public String getDefinition() {
        switch (this) {
            case AMPOULE: {
                return "A sealed glass capsule containing a liquid";
            }
            case BOTTLE: {
                return "A container, typically made of glass or plastic and with a narrow neck, used for storing liquids.";
            }
            case BOX: {
                return "A container with a flat base and sides, typically square or rectangular and having a lid.";
            }
            case CARTRIDGE: {
                return "A device of various configuration and composition used with a syringe for the application of anesthetic or other materials to a patient.";
            }
            case CONTAINER: {
                return "A package intended to store pharmaceuticals.";
            }
            case TUBE: {
                return "A long, hollow cylinder of metal, plastic, glass, etc., for holding medications, typically creams or ointments";
            }
            case UNITDOSE: {
                return "A dose of medicine prepared in an individual package for convenience, safety or monitoring.";
            }
            case VIAL: {
                return "A small container, typically cylindrical and made of glass, used especially for holding liquid medications.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AMPOULE: {
                return "Ampoule";
            }
            case BOTTLE: {
                return "Bottle";
            }
            case BOX: {
                return "Box";
            }
            case CARTRIDGE: {
                return "Cartridge";
            }
            case CONTAINER: {
                return "Container";
            }
            case TUBE: {
                return "Tube";
            }
            case UNITDOSE: {
                return "Unit Dose Blister";
            }
            case VIAL: {
                return "Vial";
            }
        }
        return "?";
    }
}

