/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MedicationRequestPriority {
    ROUTINE,
    URGENT,
    STAT,
    ASAP,
    NULL;


    public static MedicationRequestPriority fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("routine".equals(codeString)) {
            return ROUTINE;
        }
        if ("urgent".equals(codeString)) {
            return URGENT;
        }
        if ("stat".equals(codeString)) {
            return STAT;
        }
        if ("asap".equals(codeString)) {
            return ASAP;
        }
        throw new FHIRException("Unknown MedicationRequestPriority code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ROUTINE: {
                return "routine";
            }
            case URGENT: {
                return "urgent";
            }
            case STAT: {
                return "stat";
            }
            case ASAP: {
                return "asap";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/medication-request-priority";
    }

    public String getDefinition() {
        switch (this) {
            case ROUTINE: {
                return "The order has a normal priority .";
            }
            case URGENT: {
                return "The order should be urgently.";
            }
            case STAT: {
                return "The order is time-critical.";
            }
            case ASAP: {
                return "The order should be acted on as soon as possible.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ROUTINE: {
                return "Routine";
            }
            case URGENT: {
                return "Urgent";
            }
            case STAT: {
                return "Stat";
            }
            case ASAP: {
                return "ASAP";
            }
        }
        return "?";
    }
}

