/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum UdiEntryType {
    BARCODE,
    RFID,
    MANUAL,
    CARD,
    SELFREPORTED,
    UNKNOWN,
    NULL;


    public static UdiEntryType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("barcode".equals(codeString)) {
            return BARCODE;
        }
        if ("rfid".equals(codeString)) {
            return RFID;
        }
        if ("manual".equals(codeString)) {
            return MANUAL;
        }
        if ("card".equals(codeString)) {
            return CARD;
        }
        if ("self-reported".equals(codeString)) {
            return SELFREPORTED;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown UdiEntryType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case BARCODE: {
                return "barcode";
            }
            case RFID: {
                return "rfid";
            }
            case MANUAL: {
                return "manual";
            }
            case CARD: {
                return "card";
            }
            case SELFREPORTED: {
                return "self-reported";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/udi-entry-type";
    }

    public String getDefinition() {
        switch (this) {
            case BARCODE: {
                return "A Barcode scanner captured the data from the device label";
            }
            case RFID: {
                return "An RFID chip reader captured the data from the device label";
            }
            case MANUAL: {
                return "The data was read from the label by a person and manually entered. (e.g.  via a keyboard)";
            }
            case CARD: {
                return "The data originated from a patient's implant card and read by an operator.";
            }
            case SELFREPORTED: {
                return "The data originated from a patient source and not directly scanned or read from a label or card.";
            }
            case UNKNOWN: {
                return "The method of data capture has not been determined";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case BARCODE: {
                return "BarCode";
            }
            case RFID: {
                return "RFID";
            }
            case MANUAL: {
                return "Manual";
            }
            case CARD: {
                return "Card";
            }
            case SELFREPORTED: {
                return "Self Reported";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

