/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BaseNarrative;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.INarrative;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@DatatypeDef(name="Narrative")
public class Narrative
extends BaseNarrative
implements INarrative {
    @Child(name="status", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="generated | extensions | additional | empty", formalDefinition="The status of the narrative - whether it's entirely generated (from just the defined data or the extensions too), or whether a human authored it and it may contain additional data.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/narrative-status")
    protected Enumeration<NarrativeStatus> status;
    @Child(name="div", type={}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Limited xhtml content", formalDefinition="The actual narrative content, a stripped down version of XHTML.")
    protected XhtmlNode div;
    private static final long serialVersionUID = 1463852859L;

    public Narrative() {
    }

    public Narrative(Enumeration<NarrativeStatus> status, XhtmlNode div) {
        this.status = status;
        this.div = div;
    }

    public Enumeration<NarrativeStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Narrative.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<NarrativeStatus>(new NarrativeStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Narrative setStatusElement(Enumeration<NarrativeStatus> value) {
        this.status = value;
        return this;
    }

    public NarrativeStatus getStatus() {
        return this.status == null ? null : (NarrativeStatus)((Object)this.status.getValue());
    }

    public Narrative setStatus(NarrativeStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<NarrativeStatus>(new NarrativeStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public XhtmlNode getDiv() {
        if (this.div == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Narrative.div");
            }
            if (Configuration.doAutoCreate()) {
                this.div = new XhtmlNode();
            }
        }
        return this.div;
    }

    public boolean hasDiv() {
        return this.div != null && !this.div.isEmpty();
    }

    @Override
    public Narrative setDiv(XhtmlNode value) {
        this.div = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("status", "code", "The status of the narrative - whether it's entirely generated (from just the defined data or the extensions too), or whether a human authored it and it may contain additional data.", 0, 1, this.status));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -892481550: {
                return new Property("status", "code", "The status of the narrative - whether it's entirely generated (from just the defined data or the extensions too), or whether a human authored it and it may contain additional data.", 0, 1, this.status);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 99473: {
                Base[] baseArray;
                if (this.div == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = new StringType(new XhtmlComposer(true).composeEx(this.div));
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -892481550: {
                value = new NarrativeStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 99473: {
                this.div = this.castToXhtml(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("status")) {
            value = new NarrativeStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("div")) {
            this.div = this.castToXhtml(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -892481550: {
                return this.getStatusElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -892481550: {
                return new String[]{"code"};
            }
            case 99473: {
                return new String[]{"xhtml"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type Narrative.status");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Narrative";
    }

    @Override
    public Narrative copy() {
        Narrative dst = new Narrative();
        this.copyValues(dst);
        dst.status = this.status == null ? null : this.status.copy();
        dst.div = this.div == null ? null : this.div.copy();
        return dst;
    }

    @Override
    protected Narrative typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Narrative)) {
            return false;
        }
        Narrative o = (Narrative)other_;
        return Narrative.compareDeep(this.status, o.status, true) && Narrative.compareDeep(this.div, o.div, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Narrative)) {
            return false;
        }
        Narrative o = (Narrative)other_;
        return Narrative.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.status, this.div});
    }

    public static class NarrativeStatusEnumFactory
    implements EnumFactory<NarrativeStatus> {
        @Override
        public NarrativeStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("generated".equals(codeString)) {
                return NarrativeStatus.GENERATED;
            }
            if ("extensions".equals(codeString)) {
                return NarrativeStatus.EXTENSIONS;
            }
            if ("additional".equals(codeString)) {
                return NarrativeStatus.ADDITIONAL;
            }
            if ("empty".equals(codeString)) {
                return NarrativeStatus.EMPTY;
            }
            throw new IllegalArgumentException("Unknown NarrativeStatus code '" + codeString + "'");
        }

        public Enumeration<NarrativeStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<NarrativeStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("generated".equals(codeString)) {
                return new Enumeration<NarrativeStatus>(this, NarrativeStatus.GENERATED);
            }
            if ("extensions".equals(codeString)) {
                return new Enumeration<NarrativeStatus>(this, NarrativeStatus.EXTENSIONS);
            }
            if ("additional".equals(codeString)) {
                return new Enumeration<NarrativeStatus>(this, NarrativeStatus.ADDITIONAL);
            }
            if ("empty".equals(codeString)) {
                return new Enumeration<NarrativeStatus>(this, NarrativeStatus.EMPTY);
            }
            throw new FHIRException("Unknown NarrativeStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(NarrativeStatus code) {
            if (code == NarrativeStatus.GENERATED) {
                return "generated";
            }
            if (code == NarrativeStatus.EXTENSIONS) {
                return "extensions";
            }
            if (code == NarrativeStatus.ADDITIONAL) {
                return "additional";
            }
            if (code == NarrativeStatus.EMPTY) {
                return "empty";
            }
            return "?";
        }

        @Override
        public String toSystem(NarrativeStatus code) {
            return code.getSystem();
        }
    }

    public static enum NarrativeStatus {
        GENERATED,
        EXTENSIONS,
        ADDITIONAL,
        EMPTY,
        NULL;


        public static NarrativeStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("generated".equals(codeString)) {
                return GENERATED;
            }
            if ("extensions".equals(codeString)) {
                return EXTENSIONS;
            }
            if ("additional".equals(codeString)) {
                return ADDITIONAL;
            }
            if ("empty".equals(codeString)) {
                return EMPTY;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown NarrativeStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case GENERATED: {
                    return "generated";
                }
                case EXTENSIONS: {
                    return "extensions";
                }
                case ADDITIONAL: {
                    return "additional";
                }
                case EMPTY: {
                    return "empty";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case GENERATED: {
                    return "http://hl7.org/fhir/narrative-status";
                }
                case EXTENSIONS: {
                    return "http://hl7.org/fhir/narrative-status";
                }
                case ADDITIONAL: {
                    return "http://hl7.org/fhir/narrative-status";
                }
                case EMPTY: {
                    return "http://hl7.org/fhir/narrative-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case GENERATED: {
                    return "The contents of the narrative are entirely generated from the structured data in the content.";
                }
                case EXTENSIONS: {
                    return "The contents of the narrative are entirely generated from the structured data in the content and some of the content is generated from extensions";
                }
                case ADDITIONAL: {
                    return "The contents of the narrative may contain additional information not found in the structured data. Note that there is no computable way to determine what the extra information is, other than by human inspection";
                }
                case EMPTY: {
                    return "The contents of the narrative are some equivalent of \"No human-readable text provided in this case\"";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case GENERATED: {
                    return "Generated";
                }
                case EXTENSIONS: {
                    return "Extensions";
                }
                case ADDITIONAL: {
                    return "Additional";
                }
                case EMPTY: {
                    return "Empty";
                }
            }
            return "?";
        }
    }
}

