/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.Duration;
import org.hl7.fhir.dstu3.model.Element;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.TimeType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UnsignedIntType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;

@DatatypeDef(name="Timing")
public class Timing
extends Type
implements ICompositeType {
    @Child(name="event", type={DateTimeType.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="When the event occurs", formalDefinition="Identifies specific times when the event occurs.")
    protected List<DateTimeType> event;
    @Child(name="repeat", type={}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the event is to occur", formalDefinition="A set of rules that describe when the event is scheduled.")
    protected TimingRepeatComponent repeat;
    @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="BID | TID | QID | AM | PM | QD | QOD | Q4H | Q6H +", formalDefinition="A code for the timing schedule. Some codes such as BID are ubiquitous, but many institutions define their own additional codes. If a code is provided, the code is understood to be a complete statement of whatever is specified in the structured timing data, and either the code or the data may be used to interpret the Timing, with the exception that .repeat.bounds still applies over the code (and is not contained in the code).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/timing-abbreviation")
    protected CodeableConcept code;
    private static final long serialVersionUID = 791565112L;

    public List<DateTimeType> getEvent() {
        if (this.event == null) {
            this.event = new ArrayList<DateTimeType>();
        }
        return this.event;
    }

    public Timing setEvent(List<DateTimeType> theEvent) {
        this.event = theEvent;
        return this;
    }

    public boolean hasEvent() {
        if (this.event == null) {
            return false;
        }
        for (DateTimeType item : this.event) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DateTimeType addEventElement() {
        DateTimeType t = new DateTimeType();
        if (this.event == null) {
            this.event = new ArrayList<DateTimeType>();
        }
        this.event.add(t);
        return t;
    }

    public Timing addEvent(Date value) {
        DateTimeType t = new DateTimeType();
        t.setValue(value);
        if (this.event == null) {
            this.event = new ArrayList<DateTimeType>();
        }
        this.event.add(t);
        return this;
    }

    public boolean hasEvent(Date value) {
        if (this.event == null) {
            return false;
        }
        for (DateTimeType v : this.event) {
            if (!((Date)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public TimingRepeatComponent getRepeat() {
        if (this.repeat == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Timing.repeat");
            }
            if (Configuration.doAutoCreate()) {
                this.repeat = new TimingRepeatComponent();
            }
        }
        return this.repeat;
    }

    public boolean hasRepeat() {
        return this.repeat != null && !this.repeat.isEmpty();
    }

    public Timing setRepeat(TimingRepeatComponent value) {
        this.repeat = value;
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Timing.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Timing setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("event", "dateTime", "Identifies specific times when the event occurs.", 0, Integer.MAX_VALUE, this.event));
        children.add(new Property("repeat", "", "A set of rules that describe when the event is scheduled.", 0, 1, this.repeat));
        children.add(new Property("code", "CodeableConcept", "A code for the timing schedule. Some codes such as BID are ubiquitous, but many institutions define their own additional codes. If a code is provided, the code is understood to be a complete statement of whatever is specified in the structured timing data, and either the code or the data may be used to interpret the Timing, with the exception that .repeat.bounds still applies over the code (and is not contained in the code).", 0, 1, this.code));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 96891546: {
                return new Property("event", "dateTime", "Identifies specific times when the event occurs.", 0, Integer.MAX_VALUE, this.event);
            }
            case -934531685: {
                return new Property("repeat", "", "A set of rules that describe when the event is scheduled.", 0, 1, this.repeat);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "A code for the timing schedule. Some codes such as BID are ubiquitous, but many institutions define their own additional codes. If a code is provided, the code is understood to be a complete statement of whatever is specified in the structured timing data, and either the code or the data may be used to interpret the Timing, with the exception that .repeat.bounds still applies over the code (and is not contained in the code).", 0, 1, this.code);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 96891546: {
                return this.event == null ? new Base[]{} : this.event.toArray(new Base[this.event.size()]);
            }
            case -934531685: {
                Base[] baseArray;
                if (this.repeat == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.repeat;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.code;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 96891546: {
                this.getEvent().add(this.castToDateTime(value));
                return value;
            }
            case -934531685: {
                this.repeat = (TimingRepeatComponent)value;
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("event")) {
            this.getEvent().add(this.castToDateTime(value));
        } else if (name.equals("repeat")) {
            this.repeat = (TimingRepeatComponent)value;
        } else if (name.equals("code")) {
            this.code = this.castToCodeableConcept(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 96891546: {
                return this.addEventElement();
            }
            case -934531685: {
                return this.getRepeat();
            }
            case 3059181: {
                return this.getCode();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 96891546: {
                return new String[]{"dateTime"};
            }
            case -934531685: {
                return new String[0];
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("event")) {
            throw new FHIRException("Cannot call addChild on a primitive type Timing.event");
        }
        if (name.equals("repeat")) {
            this.repeat = new TimingRepeatComponent();
            return this.repeat;
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Timing";
    }

    @Override
    public Timing copy() {
        Timing dst = new Timing();
        this.copyValues(dst);
        if (this.event != null) {
            dst.event = new ArrayList<DateTimeType>();
            for (DateTimeType i : this.event) {
                dst.event.add(i.copy());
            }
        }
        dst.repeat = this.repeat == null ? null : this.repeat.copy();
        dst.code = this.code == null ? null : this.code.copy();
        return dst;
    }

    @Override
    protected Timing typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Timing)) {
            return false;
        }
        Timing o = (Timing)other_;
        return Timing.compareDeep(this.event, o.event, true) && Timing.compareDeep(this.repeat, o.repeat, true) && Timing.compareDeep(this.code, o.code, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Timing)) {
            return false;
        }
        Timing o = (Timing)other_;
        return Timing.compareValues(this.event, o.event, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.event, this.repeat, this.code});
    }

    @Block
    public static class TimingRepeatComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="bounds", type={Duration.class, Range.class, Period.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Length/Range of lengths, or (Start and/or end) limits", formalDefinition="Either a duration for the length of the timing schedule, a range of possible length, or outer bounds for start and/or end limits of the timing schedule.")
        protected Type bounds;
        @Child(name="count", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Number of times to repeat", formalDefinition="A total count of the desired number of repetitions.")
        protected IntegerType count;
        @Child(name="countMax", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Maximum number of times to repeat", formalDefinition="A maximum value for the count of the desired repetitions (e.g. do something 6-8 times).")
        protected IntegerType countMax;
        @Child(name="duration", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How long when it happens", formalDefinition="How long this thing happens for when it happens.")
        protected DecimalType duration;
        @Child(name="durationMax", type={DecimalType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How long when it happens (Max)", formalDefinition="The upper limit of how long this thing happens for when it happens.")
        protected DecimalType durationMax;
        @Child(name="durationUnit", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="s | min | h | d | wk | mo | a - unit of time (UCUM)", formalDefinition="The units of time for the duration, in UCUM units.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/units-of-time")
        protected Enumeration<UnitsOfTime> durationUnit;
        @Child(name="frequency", type={IntegerType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Event occurs frequency times per period", formalDefinition="The number of times to repeat the action within the specified period / period range (i.e. both period and periodMax provided).")
        protected IntegerType frequency;
        @Child(name="frequencyMax", type={IntegerType.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Event occurs up to frequencyMax times per period", formalDefinition="If present, indicates that the frequency is a range - so to repeat between [frequency] and [frequencyMax] times within the period or period range.")
        protected IntegerType frequencyMax;
        @Child(name="period", type={DecimalType.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Event occurs frequency times per period", formalDefinition="Indicates the duration of time over which repetitions are to occur; e.g. to express \"3 times per day\", 3 would be the frequency and \"1 day\" would be the period.")
        protected DecimalType period;
        @Child(name="periodMax", type={DecimalType.class}, order=10, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Upper limit of period (3-4 hours)", formalDefinition="If present, indicates that the period is a range from [period] to [periodMax], allowing expressing concepts such as \"do this once every 3-5 days.")
        protected DecimalType periodMax;
        @Child(name="periodUnit", type={CodeType.class}, order=11, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="s | min | h | d | wk | mo | a - unit of time (UCUM)", formalDefinition="The units of time for the period in UCUM units.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/units-of-time")
        protected Enumeration<UnitsOfTime> periodUnit;
        @Child(name="dayOfWeek", type={CodeType.class}, order=12, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="mon | tue | wed | thu | fri | sat | sun", formalDefinition="If one or more days of week is provided, then the action happens only on the specified day(s).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/days-of-week")
        protected List<Enumeration<DayOfWeek>> dayOfWeek;
        @Child(name="timeOfDay", type={TimeType.class}, order=13, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Time of day for action", formalDefinition="Specified time of day for action to take place.")
        protected List<TimeType> timeOfDay;
        @Child(name="when", type={CodeType.class}, order=14, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Regular life events the event is tied to", formalDefinition="Real world events that the occurrence of the event should be tied to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/event-timing")
        protected List<Enumeration<EventTiming>> when;
        @Child(name="offset", type={UnsignedIntType.class}, order=15, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Minutes from event (before or after)", formalDefinition="The number of minutes from the event. If the event code does not indicate whether the minutes is before or after the event, then the offset is assumed to be after the event.")
        protected UnsignedIntType offset;
        private static final long serialVersionUID = -1590643356L;

        public Type getBounds() {
            return this.bounds;
        }

        public Duration getBoundsDuration() throws FHIRException {
            if (this.bounds == null) {
                return null;
            }
            if (!(this.bounds instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.bounds.getClass().getName() + " was encountered");
            }
            return (Duration)this.bounds;
        }

        public boolean hasBoundsDuration() {
            return this != null && this.bounds instanceof Duration;
        }

        public Range getBoundsRange() throws FHIRException {
            if (this.bounds == null) {
                return null;
            }
            if (!(this.bounds instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.bounds.getClass().getName() + " was encountered");
            }
            return (Range)this.bounds;
        }

        public boolean hasBoundsRange() {
            return this != null && this.bounds instanceof Range;
        }

        public Period getBoundsPeriod() throws FHIRException {
            if (this.bounds == null) {
                return null;
            }
            if (!(this.bounds instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.bounds.getClass().getName() + " was encountered");
            }
            return (Period)this.bounds;
        }

        public boolean hasBoundsPeriod() {
            return this != null && this.bounds instanceof Period;
        }

        public boolean hasBounds() {
            return this.bounds != null && !this.bounds.isEmpty();
        }

        public TimingRepeatComponent setBounds(Type value) throws FHIRFormatError {
            if (!(value == null || value instanceof Duration || value instanceof Range || value instanceof Period)) {
                throw new FHIRFormatError("Not the right type for Timing.repeat.bounds[x]: " + value.fhirType());
            }
            this.bounds = value;
            return this;
        }

        public IntegerType getCountElement() {
            if (this.count == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.count");
                }
                if (Configuration.doAutoCreate()) {
                    this.count = new IntegerType();
                }
            }
            return this.count;
        }

        public boolean hasCountElement() {
            return this.count != null && !this.count.isEmpty();
        }

        public boolean hasCount() {
            return this.count != null && !this.count.isEmpty();
        }

        public TimingRepeatComponent setCountElement(IntegerType value) {
            this.count = value;
            return this;
        }

        public int getCount() {
            return this.count == null || this.count.isEmpty() ? 0 : (Integer)this.count.getValue();
        }

        public TimingRepeatComponent setCount(int value) {
            if (this.count == null) {
                this.count = new IntegerType();
            }
            this.count.setValue((Object)value);
            return this;
        }

        public IntegerType getCountMaxElement() {
            if (this.countMax == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.countMax");
                }
                if (Configuration.doAutoCreate()) {
                    this.countMax = new IntegerType();
                }
            }
            return this.countMax;
        }

        public boolean hasCountMaxElement() {
            return this.countMax != null && !this.countMax.isEmpty();
        }

        public boolean hasCountMax() {
            return this.countMax != null && !this.countMax.isEmpty();
        }

        public TimingRepeatComponent setCountMaxElement(IntegerType value) {
            this.countMax = value;
            return this;
        }

        public int getCountMax() {
            return this.countMax == null || this.countMax.isEmpty() ? 0 : (Integer)this.countMax.getValue();
        }

        public TimingRepeatComponent setCountMax(int value) {
            if (this.countMax == null) {
                this.countMax = new IntegerType();
            }
            this.countMax.setValue((Object)value);
            return this;
        }

        public DecimalType getDurationElement() {
            if (this.duration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.duration");
                }
                if (Configuration.doAutoCreate()) {
                    this.duration = new DecimalType();
                }
            }
            return this.duration;
        }

        public boolean hasDurationElement() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public boolean hasDuration() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public TimingRepeatComponent setDurationElement(DecimalType value) {
            this.duration = value;
            return this;
        }

        public BigDecimal getDuration() {
            return this.duration == null ? null : (BigDecimal)this.duration.getValue();
        }

        public TimingRepeatComponent setDuration(BigDecimal value) {
            if (value == null) {
                this.duration = null;
            } else {
                if (this.duration == null) {
                    this.duration = new DecimalType();
                }
                this.duration.setValue(value);
            }
            return this;
        }

        public TimingRepeatComponent setDuration(long value) {
            this.duration = new DecimalType();
            this.duration.setValue(value);
            return this;
        }

        public TimingRepeatComponent setDuration(double value) {
            this.duration = new DecimalType();
            this.duration.setValue(value);
            return this;
        }

        public DecimalType getDurationMaxElement() {
            if (this.durationMax == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.durationMax");
                }
                if (Configuration.doAutoCreate()) {
                    this.durationMax = new DecimalType();
                }
            }
            return this.durationMax;
        }

        public boolean hasDurationMaxElement() {
            return this.durationMax != null && !this.durationMax.isEmpty();
        }

        public boolean hasDurationMax() {
            return this.durationMax != null && !this.durationMax.isEmpty();
        }

        public TimingRepeatComponent setDurationMaxElement(DecimalType value) {
            this.durationMax = value;
            return this;
        }

        public BigDecimal getDurationMax() {
            return this.durationMax == null ? null : (BigDecimal)this.durationMax.getValue();
        }

        public TimingRepeatComponent setDurationMax(BigDecimal value) {
            if (value == null) {
                this.durationMax = null;
            } else {
                if (this.durationMax == null) {
                    this.durationMax = new DecimalType();
                }
                this.durationMax.setValue(value);
            }
            return this;
        }

        public TimingRepeatComponent setDurationMax(long value) {
            this.durationMax = new DecimalType();
            this.durationMax.setValue(value);
            return this;
        }

        public TimingRepeatComponent setDurationMax(double value) {
            this.durationMax = new DecimalType();
            this.durationMax.setValue(value);
            return this;
        }

        public Enumeration<UnitsOfTime> getDurationUnitElement() {
            if (this.durationUnit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.durationUnit");
                }
                if (Configuration.doAutoCreate()) {
                    this.durationUnit = new Enumeration<UnitsOfTime>(new UnitsOfTimeEnumFactory());
                }
            }
            return this.durationUnit;
        }

        public boolean hasDurationUnitElement() {
            return this.durationUnit != null && !this.durationUnit.isEmpty();
        }

        public boolean hasDurationUnit() {
            return this.durationUnit != null && !this.durationUnit.isEmpty();
        }

        public TimingRepeatComponent setDurationUnitElement(Enumeration<UnitsOfTime> value) {
            this.durationUnit = value;
            return this;
        }

        public UnitsOfTime getDurationUnit() {
            return this.durationUnit == null ? null : (UnitsOfTime)((Object)this.durationUnit.getValue());
        }

        public TimingRepeatComponent setDurationUnit(UnitsOfTime value) {
            if (value == null) {
                this.durationUnit = null;
            } else {
                if (this.durationUnit == null) {
                    this.durationUnit = new Enumeration<UnitsOfTime>(new UnitsOfTimeEnumFactory());
                }
                this.durationUnit.setValue((Object)value);
            }
            return this;
        }

        public IntegerType getFrequencyElement() {
            if (this.frequency == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.frequency");
                }
                if (Configuration.doAutoCreate()) {
                    this.frequency = new IntegerType();
                }
            }
            return this.frequency;
        }

        public boolean hasFrequencyElement() {
            return this.frequency != null && !this.frequency.isEmpty();
        }

        public boolean hasFrequency() {
            return this.frequency != null && !this.frequency.isEmpty();
        }

        public TimingRepeatComponent setFrequencyElement(IntegerType value) {
            this.frequency = value;
            return this;
        }

        public int getFrequency() {
            return this.frequency == null || this.frequency.isEmpty() ? 0 : (Integer)this.frequency.getValue();
        }

        public TimingRepeatComponent setFrequency(int value) {
            if (this.frequency == null) {
                this.frequency = new IntegerType();
            }
            this.frequency.setValue((Object)value);
            return this;
        }

        public IntegerType getFrequencyMaxElement() {
            if (this.frequencyMax == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.frequencyMax");
                }
                if (Configuration.doAutoCreate()) {
                    this.frequencyMax = new IntegerType();
                }
            }
            return this.frequencyMax;
        }

        public boolean hasFrequencyMaxElement() {
            return this.frequencyMax != null && !this.frequencyMax.isEmpty();
        }

        public boolean hasFrequencyMax() {
            return this.frequencyMax != null && !this.frequencyMax.isEmpty();
        }

        public TimingRepeatComponent setFrequencyMaxElement(IntegerType value) {
            this.frequencyMax = value;
            return this;
        }

        public int getFrequencyMax() {
            return this.frequencyMax == null || this.frequencyMax.isEmpty() ? 0 : (Integer)this.frequencyMax.getValue();
        }

        public TimingRepeatComponent setFrequencyMax(int value) {
            if (this.frequencyMax == null) {
                this.frequencyMax = new IntegerType();
            }
            this.frequencyMax.setValue((Object)value);
            return this;
        }

        public DecimalType getPeriodElement() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new DecimalType();
                }
            }
            return this.period;
        }

        public boolean hasPeriodElement() {
            return this.period != null && !this.period.isEmpty();
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public TimingRepeatComponent setPeriodElement(DecimalType value) {
            this.period = value;
            return this;
        }

        public BigDecimal getPeriod() {
            return this.period == null ? null : (BigDecimal)this.period.getValue();
        }

        public TimingRepeatComponent setPeriod(BigDecimal value) {
            if (value == null) {
                this.period = null;
            } else {
                if (this.period == null) {
                    this.period = new DecimalType();
                }
                this.period.setValue(value);
            }
            return this;
        }

        public TimingRepeatComponent setPeriod(long value) {
            this.period = new DecimalType();
            this.period.setValue(value);
            return this;
        }

        public TimingRepeatComponent setPeriod(double value) {
            this.period = new DecimalType();
            this.period.setValue(value);
            return this;
        }

        public DecimalType getPeriodMaxElement() {
            if (this.periodMax == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.periodMax");
                }
                if (Configuration.doAutoCreate()) {
                    this.periodMax = new DecimalType();
                }
            }
            return this.periodMax;
        }

        public boolean hasPeriodMaxElement() {
            return this.periodMax != null && !this.periodMax.isEmpty();
        }

        public boolean hasPeriodMax() {
            return this.periodMax != null && !this.periodMax.isEmpty();
        }

        public TimingRepeatComponent setPeriodMaxElement(DecimalType value) {
            this.periodMax = value;
            return this;
        }

        public BigDecimal getPeriodMax() {
            return this.periodMax == null ? null : (BigDecimal)this.periodMax.getValue();
        }

        public TimingRepeatComponent setPeriodMax(BigDecimal value) {
            if (value == null) {
                this.periodMax = null;
            } else {
                if (this.periodMax == null) {
                    this.periodMax = new DecimalType();
                }
                this.periodMax.setValue(value);
            }
            return this;
        }

        public TimingRepeatComponent setPeriodMax(long value) {
            this.periodMax = new DecimalType();
            this.periodMax.setValue(value);
            return this;
        }

        public TimingRepeatComponent setPeriodMax(double value) {
            this.periodMax = new DecimalType();
            this.periodMax.setValue(value);
            return this;
        }

        public Enumeration<UnitsOfTime> getPeriodUnitElement() {
            if (this.periodUnit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.periodUnit");
                }
                if (Configuration.doAutoCreate()) {
                    this.periodUnit = new Enumeration<UnitsOfTime>(new UnitsOfTimeEnumFactory());
                }
            }
            return this.periodUnit;
        }

        public boolean hasPeriodUnitElement() {
            return this.periodUnit != null && !this.periodUnit.isEmpty();
        }

        public boolean hasPeriodUnit() {
            return this.periodUnit != null && !this.periodUnit.isEmpty();
        }

        public TimingRepeatComponent setPeriodUnitElement(Enumeration<UnitsOfTime> value) {
            this.periodUnit = value;
            return this;
        }

        public UnitsOfTime getPeriodUnit() {
            return this.periodUnit == null ? null : (UnitsOfTime)((Object)this.periodUnit.getValue());
        }

        public TimingRepeatComponent setPeriodUnit(UnitsOfTime value) {
            if (value == null) {
                this.periodUnit = null;
            } else {
                if (this.periodUnit == null) {
                    this.periodUnit = new Enumeration<UnitsOfTime>(new UnitsOfTimeEnumFactory());
                }
                this.periodUnit.setValue((Object)value);
            }
            return this;
        }

        public List<Enumeration<DayOfWeek>> getDayOfWeek() {
            if (this.dayOfWeek == null) {
                this.dayOfWeek = new ArrayList<Enumeration<DayOfWeek>>();
            }
            return this.dayOfWeek;
        }

        public TimingRepeatComponent setDayOfWeek(List<Enumeration<DayOfWeek>> theDayOfWeek) {
            this.dayOfWeek = theDayOfWeek;
            return this;
        }

        public boolean hasDayOfWeek() {
            if (this.dayOfWeek == null) {
                return false;
            }
            for (Enumeration<DayOfWeek> item : this.dayOfWeek) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<DayOfWeek> addDayOfWeekElement() {
            Enumeration<DayOfWeek> t = new Enumeration<DayOfWeek>(new DayOfWeekEnumFactory());
            if (this.dayOfWeek == null) {
                this.dayOfWeek = new ArrayList<Enumeration<DayOfWeek>>();
            }
            this.dayOfWeek.add(t);
            return t;
        }

        public TimingRepeatComponent addDayOfWeek(DayOfWeek value) {
            Enumeration<DayOfWeek> t = new Enumeration<DayOfWeek>(new DayOfWeekEnumFactory());
            t.setValue((Object)value);
            if (this.dayOfWeek == null) {
                this.dayOfWeek = new ArrayList<Enumeration<DayOfWeek>>();
            }
            this.dayOfWeek.add(t);
            return this;
        }

        public boolean hasDayOfWeek(DayOfWeek value) {
            if (this.dayOfWeek == null) {
                return false;
            }
            for (Enumeration<DayOfWeek> v : this.dayOfWeek) {
                if (!((DayOfWeek)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public List<TimeType> getTimeOfDay() {
            if (this.timeOfDay == null) {
                this.timeOfDay = new ArrayList<TimeType>();
            }
            return this.timeOfDay;
        }

        public TimingRepeatComponent setTimeOfDay(List<TimeType> theTimeOfDay) {
            this.timeOfDay = theTimeOfDay;
            return this;
        }

        public boolean hasTimeOfDay() {
            if (this.timeOfDay == null) {
                return false;
            }
            for (TimeType item : this.timeOfDay) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TimeType addTimeOfDayElement() {
            TimeType t = new TimeType();
            if (this.timeOfDay == null) {
                this.timeOfDay = new ArrayList<TimeType>();
            }
            this.timeOfDay.add(t);
            return t;
        }

        public TimingRepeatComponent addTimeOfDay(String value) {
            TimeType t = new TimeType();
            t.setValue(value);
            if (this.timeOfDay == null) {
                this.timeOfDay = new ArrayList<TimeType>();
            }
            this.timeOfDay.add(t);
            return this;
        }

        public boolean hasTimeOfDay(String value) {
            if (this.timeOfDay == null) {
                return false;
            }
            for (TimeType v : this.timeOfDay) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<Enumeration<EventTiming>> getWhen() {
            if (this.when == null) {
                this.when = new ArrayList<Enumeration<EventTiming>>();
            }
            return this.when;
        }

        public TimingRepeatComponent setWhen(List<Enumeration<EventTiming>> theWhen) {
            this.when = theWhen;
            return this;
        }

        public boolean hasWhen() {
            if (this.when == null) {
                return false;
            }
            for (Enumeration<EventTiming> item : this.when) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<EventTiming> addWhenElement() {
            Enumeration<EventTiming> t = new Enumeration<EventTiming>(new EventTimingEnumFactory());
            if (this.when == null) {
                this.when = new ArrayList<Enumeration<EventTiming>>();
            }
            this.when.add(t);
            return t;
        }

        public TimingRepeatComponent addWhen(EventTiming value) {
            Enumeration<EventTiming> t = new Enumeration<EventTiming>(new EventTimingEnumFactory());
            t.setValue((Object)value);
            if (this.when == null) {
                this.when = new ArrayList<Enumeration<EventTiming>>();
            }
            this.when.add(t);
            return this;
        }

        public boolean hasWhen(EventTiming value) {
            if (this.when == null) {
                return false;
            }
            for (Enumeration<EventTiming> v : this.when) {
                if (!((EventTiming)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public UnsignedIntType getOffsetElement() {
            if (this.offset == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.offset");
                }
                if (Configuration.doAutoCreate()) {
                    this.offset = new UnsignedIntType();
                }
            }
            return this.offset;
        }

        public boolean hasOffsetElement() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public boolean hasOffset() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public TimingRepeatComponent setOffsetElement(UnsignedIntType value) {
            this.offset = value;
            return this;
        }

        public int getOffset() {
            return this.offset == null || this.offset.isEmpty() ? 0 : (Integer)this.offset.getValue();
        }

        public TimingRepeatComponent setOffset(int value) {
            if (this.offset == null) {
                this.offset = new UnsignedIntType();
            }
            this.offset.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("bounds[x]", "Duration|Range|Period", "Either a duration for the length of the timing schedule, a range of possible length, or outer bounds for start and/or end limits of the timing schedule.", 0, 1, this.bounds));
            children.add(new Property("count", "integer", "A total count of the desired number of repetitions.", 0, 1, this.count));
            children.add(new Property("countMax", "integer", "A maximum value for the count of the desired repetitions (e.g. do something 6-8 times).", 0, 1, this.countMax));
            children.add(new Property("duration", "decimal", "How long this thing happens for when it happens.", 0, 1, this.duration));
            children.add(new Property("durationMax", "decimal", "The upper limit of how long this thing happens for when it happens.", 0, 1, this.durationMax));
            children.add(new Property("durationUnit", "code", "The units of time for the duration, in UCUM units.", 0, 1, this.durationUnit));
            children.add(new Property("frequency", "integer", "The number of times to repeat the action within the specified period / period range (i.e. both period and periodMax provided).", 0, 1, this.frequency));
            children.add(new Property("frequencyMax", "integer", "If present, indicates that the frequency is a range - so to repeat between [frequency] and [frequencyMax] times within the period or period range.", 0, 1, this.frequencyMax));
            children.add(new Property("period", "decimal", "Indicates the duration of time over which repetitions are to occur; e.g. to express \"3 times per day\", 3 would be the frequency and \"1 day\" would be the period.", 0, 1, this.period));
            children.add(new Property("periodMax", "decimal", "If present, indicates that the period is a range from [period] to [periodMax], allowing expressing concepts such as \"do this once every 3-5 days.", 0, 1, this.periodMax));
            children.add(new Property("periodUnit", "code", "The units of time for the period in UCUM units.", 0, 1, this.periodUnit));
            children.add(new Property("dayOfWeek", "code", "If one or more days of week is provided, then the action happens only on the specified day(s).", 0, Integer.MAX_VALUE, this.dayOfWeek));
            children.add(new Property("timeOfDay", "time", "Specified time of day for action to take place.", 0, Integer.MAX_VALUE, this.timeOfDay));
            children.add(new Property("when", "code", "Real world events that the occurrence of the event should be tied to.", 0, Integer.MAX_VALUE, this.when));
            children.add(new Property("offset", "unsignedInt", "The number of minutes from the event. If the event code does not indicate whether the minutes is before or after the event, then the offset is assumed to be after the event.", 0, 1, this.offset));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1149635157: {
                    return new Property("bounds[x]", "Duration|Range|Period", "Either a duration for the length of the timing schedule, a range of possible length, or outer bounds for start and/or end limits of the timing schedule.", 0, 1, this.bounds);
                }
                case -1383205195: {
                    return new Property("bounds[x]", "Duration|Range|Period", "Either a duration for the length of the timing schedule, a range of possible length, or outer bounds for start and/or end limits of the timing schedule.", 0, 1, this.bounds);
                }
                case -189193367: {
                    return new Property("bounds[x]", "Duration|Range|Period", "Either a duration for the length of the timing schedule, a range of possible length, or outer bounds for start and/or end limits of the timing schedule.", 0, 1, this.bounds);
                }
                case -1001768056: {
                    return new Property("bounds[x]", "Duration|Range|Period", "Either a duration for the length of the timing schedule, a range of possible length, or outer bounds for start and/or end limits of the timing schedule.", 0, 1, this.bounds);
                }
                case -1043481386: {
                    return new Property("bounds[x]", "Duration|Range|Period", "Either a duration for the length of the timing schedule, a range of possible length, or outer bounds for start and/or end limits of the timing schedule.", 0, 1, this.bounds);
                }
                case 94851343: {
                    return new Property("count", "integer", "A total count of the desired number of repetitions.", 0, 1, this.count);
                }
                case -372044331: {
                    return new Property("countMax", "integer", "A maximum value for the count of the desired repetitions (e.g. do something 6-8 times).", 0, 1, this.countMax);
                }
                case -1992012396: {
                    return new Property("duration", "decimal", "How long this thing happens for when it happens.", 0, 1, this.duration);
                }
                case -478083280: {
                    return new Property("durationMax", "decimal", "The upper limit of how long this thing happens for when it happens.", 0, 1, this.durationMax);
                }
                case -1935429320: {
                    return new Property("durationUnit", "code", "The units of time for the duration, in UCUM units.", 0, 1, this.durationUnit);
                }
                case -70023844: {
                    return new Property("frequency", "integer", "The number of times to repeat the action within the specified period / period range (i.e. both period and periodMax provided).", 0, 1, this.frequency);
                }
                case 1273846376: {
                    return new Property("frequencyMax", "integer", "If present, indicates that the frequency is a range - so to repeat between [frequency] and [frequencyMax] times within the period or period range.", 0, 1, this.frequencyMax);
                }
                case -991726143: {
                    return new Property("period", "decimal", "Indicates the duration of time over which repetitions are to occur; e.g. to express \"3 times per day\", 3 would be the frequency and \"1 day\" would be the period.", 0, 1, this.period);
                }
                case 566580195: {
                    return new Property("periodMax", "decimal", "If present, indicates that the period is a range from [period] to [periodMax], allowing expressing concepts such as \"do this once every 3-5 days.", 0, 1, this.periodMax);
                }
                case 384367333: {
                    return new Property("periodUnit", "code", "The units of time for the period in UCUM units.", 0, 1, this.periodUnit);
                }
                case -730552025: {
                    return new Property("dayOfWeek", "code", "If one or more days of week is provided, then the action happens only on the specified day(s).", 0, Integer.MAX_VALUE, this.dayOfWeek);
                }
                case 21434232: {
                    return new Property("timeOfDay", "time", "Specified time of day for action to take place.", 0, Integer.MAX_VALUE, this.timeOfDay);
                }
                case 3648314: {
                    return new Property("when", "code", "Real world events that the occurrence of the event should be tied to.", 0, Integer.MAX_VALUE, this.when);
                }
                case -1019779949: {
                    return new Property("offset", "unsignedInt", "The number of minutes from the event. If the event code does not indicate whether the minutes is before or after the event, then the offset is assumed to be after the event.", 0, 1, this.offset);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1383205195: {
                    Base[] baseArray;
                    if (this.bounds == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.bounds;
                    }
                    return baseArray;
                }
                case 94851343: {
                    Base[] baseArray;
                    if (this.count == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.count;
                    }
                    return baseArray;
                }
                case -372044331: {
                    Base[] baseArray;
                    if (this.countMax == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.countMax;
                    }
                    return baseArray;
                }
                case -1992012396: {
                    Base[] baseArray;
                    if (this.duration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.duration;
                    }
                    return baseArray;
                }
                case -478083280: {
                    Base[] baseArray;
                    if (this.durationMax == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.durationMax;
                    }
                    return baseArray;
                }
                case -1935429320: {
                    Base[] baseArray;
                    if (this.durationUnit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.durationUnit;
                    }
                    return baseArray;
                }
                case -70023844: {
                    Base[] baseArray;
                    if (this.frequency == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.frequency;
                    }
                    return baseArray;
                }
                case 1273846376: {
                    Base[] baseArray;
                    if (this.frequencyMax == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.frequencyMax;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.period;
                    }
                    return baseArray;
                }
                case 566580195: {
                    Base[] baseArray;
                    if (this.periodMax == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.periodMax;
                    }
                    return baseArray;
                }
                case 384367333: {
                    Base[] baseArray;
                    if (this.periodUnit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.periodUnit;
                    }
                    return baseArray;
                }
                case -730552025: {
                    return this.dayOfWeek == null ? new Base[]{} : this.dayOfWeek.toArray(new Base[this.dayOfWeek.size()]);
                }
                case 21434232: {
                    return this.timeOfDay == null ? new Base[]{} : this.timeOfDay.toArray(new Base[this.timeOfDay.size()]);
                }
                case 3648314: {
                    return this.when == null ? new Base[]{} : this.when.toArray(new Base[this.when.size()]);
                }
                case -1019779949: {
                    Base[] baseArray;
                    if (this.offset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.offset;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1383205195: {
                    this.bounds = this.castToType(value);
                    return value;
                }
                case 94851343: {
                    this.count = this.castToInteger(value);
                    return value;
                }
                case -372044331: {
                    this.countMax = this.castToInteger(value);
                    return value;
                }
                case -1992012396: {
                    this.duration = this.castToDecimal(value);
                    return value;
                }
                case -478083280: {
                    this.durationMax = this.castToDecimal(value);
                    return value;
                }
                case -1935429320: {
                    value = new UnitsOfTimeEnumFactory().fromType(this.castToCode(value));
                    this.durationUnit = value;
                    return value;
                }
                case -70023844: {
                    this.frequency = this.castToInteger(value);
                    return value;
                }
                case 1273846376: {
                    this.frequencyMax = this.castToInteger(value);
                    return value;
                }
                case -991726143: {
                    this.period = this.castToDecimal(value);
                    return value;
                }
                case 566580195: {
                    this.periodMax = this.castToDecimal(value);
                    return value;
                }
                case 384367333: {
                    value = new UnitsOfTimeEnumFactory().fromType(this.castToCode(value));
                    this.periodUnit = value;
                    return value;
                }
                case -730552025: {
                    value = new DayOfWeekEnumFactory().fromType(this.castToCode(value));
                    this.getDayOfWeek().add(value);
                    return value;
                }
                case 21434232: {
                    this.getTimeOfDay().add(this.castToTime(value));
                    return value;
                }
                case 3648314: {
                    value = new EventTimingEnumFactory().fromType(this.castToCode(value));
                    this.getWhen().add(value);
                    return value;
                }
                case -1019779949: {
                    this.offset = this.castToUnsignedInt(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("bounds[x]")) {
                this.bounds = this.castToType(value);
            } else if (name.equals("count")) {
                this.count = this.castToInteger(value);
            } else if (name.equals("countMax")) {
                this.countMax = this.castToInteger(value);
            } else if (name.equals("duration")) {
                this.duration = this.castToDecimal(value);
            } else if (name.equals("durationMax")) {
                this.durationMax = this.castToDecimal(value);
            } else if (name.equals("durationUnit")) {
                value = new UnitsOfTimeEnumFactory().fromType(this.castToCode(value));
                this.durationUnit = value;
            } else if (name.equals("frequency")) {
                this.frequency = this.castToInteger(value);
            } else if (name.equals("frequencyMax")) {
                this.frequencyMax = this.castToInteger(value);
            } else if (name.equals("period")) {
                this.period = this.castToDecimal(value);
            } else if (name.equals("periodMax")) {
                this.periodMax = this.castToDecimal(value);
            } else if (name.equals("periodUnit")) {
                value = new UnitsOfTimeEnumFactory().fromType(this.castToCode(value));
                this.periodUnit = value;
            } else if (name.equals("dayOfWeek")) {
                value = new DayOfWeekEnumFactory().fromType(this.castToCode(value));
                this.getDayOfWeek().add(value);
            } else if (name.equals("timeOfDay")) {
                this.getTimeOfDay().add(this.castToTime(value));
            } else if (name.equals("when")) {
                value = new EventTimingEnumFactory().fromType(this.castToCode(value));
                this.getWhen().add(value);
            } else if (name.equals("offset")) {
                this.offset = this.castToUnsignedInt(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1149635157: {
                    return this.getBounds();
                }
                case -1383205195: {
                    return this.getBounds();
                }
                case 94851343: {
                    return this.getCountElement();
                }
                case -372044331: {
                    return this.getCountMaxElement();
                }
                case -1992012396: {
                    return this.getDurationElement();
                }
                case -478083280: {
                    return this.getDurationMaxElement();
                }
                case -1935429320: {
                    return this.getDurationUnitElement();
                }
                case -70023844: {
                    return this.getFrequencyElement();
                }
                case 1273846376: {
                    return this.getFrequencyMaxElement();
                }
                case -991726143: {
                    return this.getPeriodElement();
                }
                case 566580195: {
                    return this.getPeriodMaxElement();
                }
                case 384367333: {
                    return this.getPeriodUnitElement();
                }
                case -730552025: {
                    return this.addDayOfWeekElement();
                }
                case 21434232: {
                    return this.addTimeOfDayElement();
                }
                case 3648314: {
                    return this.addWhenElement();
                }
                case -1019779949: {
                    return this.getOffsetElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1383205195: {
                    return new String[]{"Duration", "Range", "Period"};
                }
                case 94851343: {
                    return new String[]{"integer"};
                }
                case -372044331: {
                    return new String[]{"integer"};
                }
                case -1992012396: {
                    return new String[]{"decimal"};
                }
                case -478083280: {
                    return new String[]{"decimal"};
                }
                case -1935429320: {
                    return new String[]{"code"};
                }
                case -70023844: {
                    return new String[]{"integer"};
                }
                case 1273846376: {
                    return new String[]{"integer"};
                }
                case -991726143: {
                    return new String[]{"decimal"};
                }
                case 566580195: {
                    return new String[]{"decimal"};
                }
                case 384367333: {
                    return new String[]{"code"};
                }
                case -730552025: {
                    return new String[]{"code"};
                }
                case 21434232: {
                    return new String[]{"time"};
                }
                case 3648314: {
                    return new String[]{"code"};
                }
                case -1019779949: {
                    return new String[]{"unsignedInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("boundsDuration")) {
                this.bounds = new Duration();
                return this.bounds;
            }
            if (name.equals("boundsRange")) {
                this.bounds = new Range();
                return this.bounds;
            }
            if (name.equals("boundsPeriod")) {
                this.bounds = new Period();
                return this.bounds;
            }
            if (name.equals("count")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.count");
            }
            if (name.equals("countMax")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.countMax");
            }
            if (name.equals("duration")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.duration");
            }
            if (name.equals("durationMax")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.durationMax");
            }
            if (name.equals("durationUnit")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.durationUnit");
            }
            if (name.equals("frequency")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.frequency");
            }
            if (name.equals("frequencyMax")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.frequencyMax");
            }
            if (name.equals("period")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.period");
            }
            if (name.equals("periodMax")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.periodMax");
            }
            if (name.equals("periodUnit")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.periodUnit");
            }
            if (name.equals("dayOfWeek")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.dayOfWeek");
            }
            if (name.equals("timeOfDay")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.timeOfDay");
            }
            if (name.equals("when")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.when");
            }
            if (name.equals("offset")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.offset");
            }
            return super.addChild(name);
        }

        @Override
        public TimingRepeatComponent copy() {
            TimingRepeatComponent dst = new TimingRepeatComponent();
            this.copyValues(dst);
            dst.bounds = this.bounds == null ? null : this.bounds.copy();
            dst.count = this.count == null ? null : this.count.copy();
            dst.countMax = this.countMax == null ? null : this.countMax.copy();
            dst.duration = this.duration == null ? null : this.duration.copy();
            dst.durationMax = this.durationMax == null ? null : this.durationMax.copy();
            dst.durationUnit = this.durationUnit == null ? null : this.durationUnit.copy();
            dst.frequency = this.frequency == null ? null : this.frequency.copy();
            dst.frequencyMax = this.frequencyMax == null ? null : this.frequencyMax.copy();
            dst.period = this.period == null ? null : this.period.copy();
            dst.periodMax = this.periodMax == null ? null : this.periodMax.copy();
            Enumeration<UnitsOfTime> enumeration = dst.periodUnit = this.periodUnit == null ? null : this.periodUnit.copy();
            if (this.dayOfWeek != null) {
                dst.dayOfWeek = new ArrayList<Enumeration<DayOfWeek>>();
                for (Enumeration enumeration2 : this.dayOfWeek) {
                    dst.dayOfWeek.add((Enumeration<DayOfWeek>)enumeration2.copy());
                }
            }
            if (this.timeOfDay != null) {
                dst.timeOfDay = new ArrayList<TimeType>();
                for (TimeType timeType : this.timeOfDay) {
                    dst.timeOfDay.add(timeType.copy());
                }
            }
            if (this.when != null) {
                dst.when = new ArrayList<Enumeration<EventTiming>>();
                for (Enumeration enumeration3 : this.when) {
                    dst.when.add((Enumeration<EventTiming>)enumeration3.copy());
                }
            }
            dst.offset = this.offset == null ? null : this.offset.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TimingRepeatComponent)) {
                return false;
            }
            TimingRepeatComponent o = (TimingRepeatComponent)other_;
            return TimingRepeatComponent.compareDeep(this.bounds, o.bounds, true) && TimingRepeatComponent.compareDeep(this.count, o.count, true) && TimingRepeatComponent.compareDeep(this.countMax, o.countMax, true) && TimingRepeatComponent.compareDeep(this.duration, o.duration, true) && TimingRepeatComponent.compareDeep(this.durationMax, o.durationMax, true) && TimingRepeatComponent.compareDeep(this.durationUnit, o.durationUnit, true) && TimingRepeatComponent.compareDeep(this.frequency, o.frequency, true) && TimingRepeatComponent.compareDeep(this.frequencyMax, o.frequencyMax, true) && TimingRepeatComponent.compareDeep(this.period, o.period, true) && TimingRepeatComponent.compareDeep(this.periodMax, o.periodMax, true) && TimingRepeatComponent.compareDeep(this.periodUnit, o.periodUnit, true) && TimingRepeatComponent.compareDeep(this.dayOfWeek, o.dayOfWeek, true) && TimingRepeatComponent.compareDeep(this.timeOfDay, o.timeOfDay, true) && TimingRepeatComponent.compareDeep(this.when, o.when, true) && TimingRepeatComponent.compareDeep(this.offset, o.offset, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TimingRepeatComponent)) {
                return false;
            }
            TimingRepeatComponent o = (TimingRepeatComponent)other_;
            return TimingRepeatComponent.compareValues(this.count, o.count, true) && TimingRepeatComponent.compareValues(this.countMax, o.countMax, true) && TimingRepeatComponent.compareValues(this.duration, o.duration, true) && TimingRepeatComponent.compareValues(this.durationMax, o.durationMax, true) && TimingRepeatComponent.compareValues(this.durationUnit, o.durationUnit, true) && TimingRepeatComponent.compareValues(this.frequency, o.frequency, true) && TimingRepeatComponent.compareValues(this.frequencyMax, o.frequencyMax, true) && TimingRepeatComponent.compareValues(this.period, o.period, true) && TimingRepeatComponent.compareValues(this.periodMax, o.periodMax, true) && TimingRepeatComponent.compareValues(this.periodUnit, o.periodUnit, true) && TimingRepeatComponent.compareValues(this.dayOfWeek, o.dayOfWeek, true) && TimingRepeatComponent.compareValues(this.timeOfDay, o.timeOfDay, true) && TimingRepeatComponent.compareValues(this.when, o.when, true) && TimingRepeatComponent.compareValues(this.offset, o.offset, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.bounds, this.count, this.countMax, this.duration, this.durationMax, this.durationUnit, this.frequency, this.frequencyMax, this.period, this.periodMax, this.periodUnit, this.dayOfWeek, this.timeOfDay, this.when, this.offset});
        }

        @Override
        public String fhirType() {
            return "Timing.repeat";
        }
    }

    public static class EventTimingEnumFactory
    implements EnumFactory<EventTiming> {
        @Override
        public EventTiming fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("MORN".equals(codeString)) {
                return EventTiming.MORN;
            }
            if ("AFT".equals(codeString)) {
                return EventTiming.AFT;
            }
            if ("EVE".equals(codeString)) {
                return EventTiming.EVE;
            }
            if ("NIGHT".equals(codeString)) {
                return EventTiming.NIGHT;
            }
            if ("PHS".equals(codeString)) {
                return EventTiming.PHS;
            }
            if ("HS".equals(codeString)) {
                return EventTiming.HS;
            }
            if ("WAKE".equals(codeString)) {
                return EventTiming.WAKE;
            }
            if ("C".equals(codeString)) {
                return EventTiming.C;
            }
            if ("CM".equals(codeString)) {
                return EventTiming.CM;
            }
            if ("CD".equals(codeString)) {
                return EventTiming.CD;
            }
            if ("CV".equals(codeString)) {
                return EventTiming.CV;
            }
            if ("AC".equals(codeString)) {
                return EventTiming.AC;
            }
            if ("ACM".equals(codeString)) {
                return EventTiming.ACM;
            }
            if ("ACD".equals(codeString)) {
                return EventTiming.ACD;
            }
            if ("ACV".equals(codeString)) {
                return EventTiming.ACV;
            }
            if ("PC".equals(codeString)) {
                return EventTiming.PC;
            }
            if ("PCM".equals(codeString)) {
                return EventTiming.PCM;
            }
            if ("PCD".equals(codeString)) {
                return EventTiming.PCD;
            }
            if ("PCV".equals(codeString)) {
                return EventTiming.PCV;
            }
            throw new IllegalArgumentException("Unknown EventTiming code '" + codeString + "'");
        }

        public Enumeration<EventTiming> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EventTiming>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("MORN".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.MORN);
            }
            if ("AFT".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.AFT);
            }
            if ("EVE".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.EVE);
            }
            if ("NIGHT".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.NIGHT);
            }
            if ("PHS".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.PHS);
            }
            if ("HS".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.HS);
            }
            if ("WAKE".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.WAKE);
            }
            if ("C".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.C);
            }
            if ("CM".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.CM);
            }
            if ("CD".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.CD);
            }
            if ("CV".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.CV);
            }
            if ("AC".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.AC);
            }
            if ("ACM".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.ACM);
            }
            if ("ACD".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.ACD);
            }
            if ("ACV".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.ACV);
            }
            if ("PC".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.PC);
            }
            if ("PCM".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.PCM);
            }
            if ("PCD".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.PCD);
            }
            if ("PCV".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.PCV);
            }
            throw new FHIRException("Unknown EventTiming code '" + codeString + "'");
        }

        @Override
        public String toCode(EventTiming code) {
            if (code == EventTiming.MORN) {
                return "MORN";
            }
            if (code == EventTiming.AFT) {
                return "AFT";
            }
            if (code == EventTiming.EVE) {
                return "EVE";
            }
            if (code == EventTiming.NIGHT) {
                return "NIGHT";
            }
            if (code == EventTiming.PHS) {
                return "PHS";
            }
            if (code == EventTiming.HS) {
                return "HS";
            }
            if (code == EventTiming.WAKE) {
                return "WAKE";
            }
            if (code == EventTiming.C) {
                return "C";
            }
            if (code == EventTiming.CM) {
                return "CM";
            }
            if (code == EventTiming.CD) {
                return "CD";
            }
            if (code == EventTiming.CV) {
                return "CV";
            }
            if (code == EventTiming.AC) {
                return "AC";
            }
            if (code == EventTiming.ACM) {
                return "ACM";
            }
            if (code == EventTiming.ACD) {
                return "ACD";
            }
            if (code == EventTiming.ACV) {
                return "ACV";
            }
            if (code == EventTiming.PC) {
                return "PC";
            }
            if (code == EventTiming.PCM) {
                return "PCM";
            }
            if (code == EventTiming.PCD) {
                return "PCD";
            }
            if (code == EventTiming.PCV) {
                return "PCV";
            }
            return "?";
        }

        @Override
        public String toSystem(EventTiming code) {
            return code.getSystem();
        }
    }

    public static enum EventTiming {
        MORN,
        AFT,
        EVE,
        NIGHT,
        PHS,
        HS,
        WAKE,
        C,
        CM,
        CD,
        CV,
        AC,
        ACM,
        ACD,
        ACV,
        PC,
        PCM,
        PCD,
        PCV,
        NULL;


        public static EventTiming fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("MORN".equals(codeString)) {
                return MORN;
            }
            if ("AFT".equals(codeString)) {
                return AFT;
            }
            if ("EVE".equals(codeString)) {
                return EVE;
            }
            if ("NIGHT".equals(codeString)) {
                return NIGHT;
            }
            if ("PHS".equals(codeString)) {
                return PHS;
            }
            if ("HS".equals(codeString)) {
                return HS;
            }
            if ("WAKE".equals(codeString)) {
                return WAKE;
            }
            if ("C".equals(codeString)) {
                return C;
            }
            if ("CM".equals(codeString)) {
                return CM;
            }
            if ("CD".equals(codeString)) {
                return CD;
            }
            if ("CV".equals(codeString)) {
                return CV;
            }
            if ("AC".equals(codeString)) {
                return AC;
            }
            if ("ACM".equals(codeString)) {
                return ACM;
            }
            if ("ACD".equals(codeString)) {
                return ACD;
            }
            if ("ACV".equals(codeString)) {
                return ACV;
            }
            if ("PC".equals(codeString)) {
                return PC;
            }
            if ("PCM".equals(codeString)) {
                return PCM;
            }
            if ("PCD".equals(codeString)) {
                return PCD;
            }
            if ("PCV".equals(codeString)) {
                return PCV;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EventTiming code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MORN: {
                    return "MORN";
                }
                case AFT: {
                    return "AFT";
                }
                case EVE: {
                    return "EVE";
                }
                case NIGHT: {
                    return "NIGHT";
                }
                case PHS: {
                    return "PHS";
                }
                case HS: {
                    return "HS";
                }
                case WAKE: {
                    return "WAKE";
                }
                case C: {
                    return "C";
                }
                case CM: {
                    return "CM";
                }
                case CD: {
                    return "CD";
                }
                case CV: {
                    return "CV";
                }
                case AC: {
                    return "AC";
                }
                case ACM: {
                    return "ACM";
                }
                case ACD: {
                    return "ACD";
                }
                case ACV: {
                    return "ACV";
                }
                case PC: {
                    return "PC";
                }
                case PCM: {
                    return "PCM";
                }
                case PCD: {
                    return "PCD";
                }
                case PCV: {
                    return "PCV";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MORN: {
                    return "http://hl7.org/fhir/event-timing";
                }
                case AFT: {
                    return "http://hl7.org/fhir/event-timing";
                }
                case EVE: {
                    return "http://hl7.org/fhir/event-timing";
                }
                case NIGHT: {
                    return "http://hl7.org/fhir/event-timing";
                }
                case PHS: {
                    return "http://hl7.org/fhir/event-timing";
                }
                case HS: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case WAKE: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case C: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case CM: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case CD: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case CV: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case AC: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case ACM: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case ACD: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case ACV: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case PC: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case PCM: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case PCD: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case PCV: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MORN: {
                    return "event occurs during the morning";
                }
                case AFT: {
                    return "event occurs during the afternoon";
                }
                case EVE: {
                    return "event occurs during the evening";
                }
                case NIGHT: {
                    return "event occurs during the night";
                }
                case PHS: {
                    return "event occurs [offset] after subject goes to sleep";
                }
                case HS: {
                    return "";
                }
                case WAKE: {
                    return "";
                }
                case C: {
                    return "";
                }
                case CM: {
                    return "";
                }
                case CD: {
                    return "";
                }
                case CV: {
                    return "";
                }
                case AC: {
                    return "";
                }
                case ACM: {
                    return "";
                }
                case ACD: {
                    return "";
                }
                case ACV: {
                    return "";
                }
                case PC: {
                    return "";
                }
                case PCM: {
                    return "";
                }
                case PCD: {
                    return "";
                }
                case PCV: {
                    return "";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MORN: {
                    return "Morning";
                }
                case AFT: {
                    return "Afternoon";
                }
                case EVE: {
                    return "Evening";
                }
                case NIGHT: {
                    return "Night";
                }
                case PHS: {
                    return "After Sleep";
                }
                case HS: {
                    return "HS";
                }
                case WAKE: {
                    return "WAKE";
                }
                case C: {
                    return "C";
                }
                case CM: {
                    return "CM";
                }
                case CD: {
                    return "CD";
                }
                case CV: {
                    return "CV";
                }
                case AC: {
                    return "AC";
                }
                case ACM: {
                    return "ACM";
                }
                case ACD: {
                    return "ACD";
                }
                case ACV: {
                    return "ACV";
                }
                case PC: {
                    return "PC";
                }
                case PCM: {
                    return "PCM";
                }
                case PCD: {
                    return "PCD";
                }
                case PCV: {
                    return "PCV";
                }
            }
            return "?";
        }
    }

    public static class DayOfWeekEnumFactory
    implements EnumFactory<DayOfWeek> {
        @Override
        public DayOfWeek fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("mon".equals(codeString)) {
                return DayOfWeek.MON;
            }
            if ("tue".equals(codeString)) {
                return DayOfWeek.TUE;
            }
            if ("wed".equals(codeString)) {
                return DayOfWeek.WED;
            }
            if ("thu".equals(codeString)) {
                return DayOfWeek.THU;
            }
            if ("fri".equals(codeString)) {
                return DayOfWeek.FRI;
            }
            if ("sat".equals(codeString)) {
                return DayOfWeek.SAT;
            }
            if ("sun".equals(codeString)) {
                return DayOfWeek.SUN;
            }
            throw new IllegalArgumentException("Unknown DayOfWeek code '" + codeString + "'");
        }

        public Enumeration<DayOfWeek> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DayOfWeek>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("mon".equals(codeString)) {
                return new Enumeration<DayOfWeek>(this, DayOfWeek.MON);
            }
            if ("tue".equals(codeString)) {
                return new Enumeration<DayOfWeek>(this, DayOfWeek.TUE);
            }
            if ("wed".equals(codeString)) {
                return new Enumeration<DayOfWeek>(this, DayOfWeek.WED);
            }
            if ("thu".equals(codeString)) {
                return new Enumeration<DayOfWeek>(this, DayOfWeek.THU);
            }
            if ("fri".equals(codeString)) {
                return new Enumeration<DayOfWeek>(this, DayOfWeek.FRI);
            }
            if ("sat".equals(codeString)) {
                return new Enumeration<DayOfWeek>(this, DayOfWeek.SAT);
            }
            if ("sun".equals(codeString)) {
                return new Enumeration<DayOfWeek>(this, DayOfWeek.SUN);
            }
            throw new FHIRException("Unknown DayOfWeek code '" + codeString + "'");
        }

        @Override
        public String toCode(DayOfWeek code) {
            if (code == DayOfWeek.MON) {
                return "mon";
            }
            if (code == DayOfWeek.TUE) {
                return "tue";
            }
            if (code == DayOfWeek.WED) {
                return "wed";
            }
            if (code == DayOfWeek.THU) {
                return "thu";
            }
            if (code == DayOfWeek.FRI) {
                return "fri";
            }
            if (code == DayOfWeek.SAT) {
                return "sat";
            }
            if (code == DayOfWeek.SUN) {
                return "sun";
            }
            return "?";
        }

        @Override
        public String toSystem(DayOfWeek code) {
            return code.getSystem();
        }
    }

    public static enum DayOfWeek {
        MON,
        TUE,
        WED,
        THU,
        FRI,
        SAT,
        SUN,
        NULL;


        public static DayOfWeek fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("mon".equals(codeString)) {
                return MON;
            }
            if ("tue".equals(codeString)) {
                return TUE;
            }
            if ("wed".equals(codeString)) {
                return WED;
            }
            if ("thu".equals(codeString)) {
                return THU;
            }
            if ("fri".equals(codeString)) {
                return FRI;
            }
            if ("sat".equals(codeString)) {
                return SAT;
            }
            if ("sun".equals(codeString)) {
                return SUN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DayOfWeek code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MON: {
                    return "mon";
                }
                case TUE: {
                    return "tue";
                }
                case WED: {
                    return "wed";
                }
                case THU: {
                    return "thu";
                }
                case FRI: {
                    return "fri";
                }
                case SAT: {
                    return "sat";
                }
                case SUN: {
                    return "sun";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MON: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case TUE: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case WED: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case THU: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case FRI: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case SAT: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case SUN: {
                    return "http://hl7.org/fhir/days-of-week";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MON: {
                    return "Monday";
                }
                case TUE: {
                    return "Tuesday";
                }
                case WED: {
                    return "Wednesday";
                }
                case THU: {
                    return "Thursday";
                }
                case FRI: {
                    return "Friday";
                }
                case SAT: {
                    return "Saturday";
                }
                case SUN: {
                    return "Sunday";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MON: {
                    return "Monday";
                }
                case TUE: {
                    return "Tuesday";
                }
                case WED: {
                    return "Wednesday";
                }
                case THU: {
                    return "Thursday";
                }
                case FRI: {
                    return "Friday";
                }
                case SAT: {
                    return "Saturday";
                }
                case SUN: {
                    return "Sunday";
                }
            }
            return "?";
        }
    }

    public static class UnitsOfTimeEnumFactory
    implements EnumFactory<UnitsOfTime> {
        @Override
        public UnitsOfTime fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("s".equals(codeString)) {
                return UnitsOfTime.S;
            }
            if ("min".equals(codeString)) {
                return UnitsOfTime.MIN;
            }
            if ("h".equals(codeString)) {
                return UnitsOfTime.H;
            }
            if ("d".equals(codeString)) {
                return UnitsOfTime.D;
            }
            if ("wk".equals(codeString)) {
                return UnitsOfTime.WK;
            }
            if ("mo".equals(codeString)) {
                return UnitsOfTime.MO;
            }
            if ("a".equals(codeString)) {
                return UnitsOfTime.A;
            }
            throw new IllegalArgumentException("Unknown UnitsOfTime code '" + codeString + "'");
        }

        public Enumeration<UnitsOfTime> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<UnitsOfTime>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("s".equals(codeString)) {
                return new Enumeration<UnitsOfTime>(this, UnitsOfTime.S);
            }
            if ("min".equals(codeString)) {
                return new Enumeration<UnitsOfTime>(this, UnitsOfTime.MIN);
            }
            if ("h".equals(codeString)) {
                return new Enumeration<UnitsOfTime>(this, UnitsOfTime.H);
            }
            if ("d".equals(codeString)) {
                return new Enumeration<UnitsOfTime>(this, UnitsOfTime.D);
            }
            if ("wk".equals(codeString)) {
                return new Enumeration<UnitsOfTime>(this, UnitsOfTime.WK);
            }
            if ("mo".equals(codeString)) {
                return new Enumeration<UnitsOfTime>(this, UnitsOfTime.MO);
            }
            if ("a".equals(codeString)) {
                return new Enumeration<UnitsOfTime>(this, UnitsOfTime.A);
            }
            throw new FHIRException("Unknown UnitsOfTime code '" + codeString + "'");
        }

        @Override
        public String toCode(UnitsOfTime code) {
            if (code == UnitsOfTime.S) {
                return "s";
            }
            if (code == UnitsOfTime.MIN) {
                return "min";
            }
            if (code == UnitsOfTime.H) {
                return "h";
            }
            if (code == UnitsOfTime.D) {
                return "d";
            }
            if (code == UnitsOfTime.WK) {
                return "wk";
            }
            if (code == UnitsOfTime.MO) {
                return "mo";
            }
            if (code == UnitsOfTime.A) {
                return "a";
            }
            return "?";
        }

        @Override
        public String toSystem(UnitsOfTime code) {
            return code.getSystem();
        }
    }

    public static enum UnitsOfTime {
        S,
        MIN,
        H,
        D,
        WK,
        MO,
        A,
        NULL;


        public static UnitsOfTime fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("s".equals(codeString)) {
                return S;
            }
            if ("min".equals(codeString)) {
                return MIN;
            }
            if ("h".equals(codeString)) {
                return H;
            }
            if ("d".equals(codeString)) {
                return D;
            }
            if ("wk".equals(codeString)) {
                return WK;
            }
            if ("mo".equals(codeString)) {
                return MO;
            }
            if ("a".equals(codeString)) {
                return A;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown UnitsOfTime code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case S: {
                    return "s";
                }
                case MIN: {
                    return "min";
                }
                case H: {
                    return "h";
                }
                case D: {
                    return "d";
                }
                case WK: {
                    return "wk";
                }
                case MO: {
                    return "mo";
                }
                case A: {
                    return "a";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case S: {
                    return "http://unitsofmeasure.org";
                }
                case MIN: {
                    return "http://unitsofmeasure.org";
                }
                case H: {
                    return "http://unitsofmeasure.org";
                }
                case D: {
                    return "http://unitsofmeasure.org";
                }
                case WK: {
                    return "http://unitsofmeasure.org";
                }
                case MO: {
                    return "http://unitsofmeasure.org";
                }
                case A: {
                    return "http://unitsofmeasure.org";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case S: {
                    return "";
                }
                case MIN: {
                    return "";
                }
                case H: {
                    return "";
                }
                case D: {
                    return "";
                }
                case WK: {
                    return "";
                }
                case MO: {
                    return "";
                }
                case A: {
                    return "";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case S: {
                    return "second";
                }
                case MIN: {
                    return "minute";
                }
                case H: {
                    return "hour";
                }
                case D: {
                    return "day";
                }
                case WK: {
                    return "week";
                }
                case MO: {
                    return "month";
                }
                case A: {
                    return "year";
                }
            }
            return "?";
        }
    }
}

