/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MedicationStatementStatus {
    ACTIVE,
    COMPLETED,
    ENTEREDINERROR,
    INTENDED,
    STOPPED,
    ONHOLD,
    NULL;


    public static MedicationStatementStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("intended".equals(codeString)) {
            return INTENDED;
        }
        if ("stopped".equals(codeString)) {
            return STOPPED;
        }
        if ("on-hold".equals(codeString)) {
            return ONHOLD;
        }
        throw new FHIRException("Unknown MedicationStatementStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case COMPLETED: {
                return "completed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case INTENDED: {
                return "intended";
            }
            case STOPPED: {
                return "stopped";
            }
            case ONHOLD: {
                return "on-hold";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/medication-statement-status";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "The medication is still being taken.";
            }
            case COMPLETED: {
                return "The medication is no longer being taken.";
            }
            case ENTEREDINERROR: {
                return "The statement was recorded incorrectly.";
            }
            case INTENDED: {
                return "The medication may be taken at some time in the future.";
            }
            case STOPPED: {
                return "Actions implied by the statement have been permanently halted, before all of them occurred.";
            }
            case ONHOLD: {
                return "Actions implied by the statement have been temporarily halted, but are expected to continue later. May also be called \"suspended\".";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case COMPLETED: {
                return "Completed";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case INTENDED: {
                return "Intended";
            }
            case STOPPED: {
                return "Stopped";
            }
            case ONHOLD: {
                return "On Hold";
            }
        }
        return "?";
    }
}

