/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MetricOperationalStatus {
    ON,
    OFF,
    STANDBY,
    ENTEREDINERROR,
    NULL;


    public static MetricOperationalStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("on".equals(codeString)) {
            return ON;
        }
        if ("off".equals(codeString)) {
            return OFF;
        }
        if ("standby".equals(codeString)) {
            return STANDBY;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown MetricOperationalStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ON: {
                return "on";
            }
            case OFF: {
                return "off";
            }
            case STANDBY: {
                return "standby";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/metric-operational-status";
    }

    public String getDefinition() {
        switch (this) {
            case ON: {
                return "The DeviceMetric is operating and will generate DeviceObservations.";
            }
            case OFF: {
                return "The DeviceMetric is not operating.";
            }
            case STANDBY: {
                return "The DeviceMetric is operating, but will not generate any DeviceObservations.";
            }
            case ENTEREDINERROR: {
                return "The DeviceMetric was entered in error.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ON: {
                return "On";
            }
            case OFF: {
                return "Off";
            }
            case STANDBY: {
                return "Standby";
            }
            case ENTEREDINERROR: {
                return "Entered In Error";
            }
        }
        return "?";
    }
}

