/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum VisionEyeCodes {
    RIGHT,
    LEFT,
    NULL;


    public static VisionEyeCodes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("right".equals(codeString)) {
            return RIGHT;
        }
        if ("left".equals(codeString)) {
            return LEFT;
        }
        throw new FHIRException("Unknown VisionEyeCodes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case RIGHT: {
                return "right";
            }
            case LEFT: {
                return "left";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/vision-eye-codes";
    }

    public String getDefinition() {
        switch (this) {
            case RIGHT: {
                return "Right Eye";
            }
            case LEFT: {
                return "Left Eye";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case RIGHT: {
                return "Right Eye";
            }
            case LEFT: {
                return "Left Eye";
            }
        }
        return "?";
    }
}

