/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum LinkType {
    REPLACEDBY,
    REPLACES,
    REFER,
    SEEALSO,
    NULL;


    public static LinkType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("replaced-by".equals(codeString)) {
            return REPLACEDBY;
        }
        if ("replaces".equals(codeString)) {
            return REPLACES;
        }
        if ("refer".equals(codeString)) {
            return REFER;
        }
        if ("seealso".equals(codeString)) {
            return SEEALSO;
        }
        throw new FHIRException("Unknown LinkType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case REPLACEDBY: {
                return "replaced-by";
            }
            case REPLACES: {
                return "replaces";
            }
            case REFER: {
                return "refer";
            }
            case SEEALSO: {
                return "seealso";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/link-type";
    }

    public String getDefinition() {
        switch (this) {
            case REPLACEDBY: {
                return "The patient resource containing this link must no longer be used. The link points forward to another patient resource that must be used in lieu of the patient resource that contains this link.";
            }
            case REPLACES: {
                return "The patient resource containing this link is the current active patient record. The link points back to an inactive patient resource that has been merged into this resource, and should be consulted to retrieve additional referenced information.";
            }
            case REFER: {
                return "The patient resource containing this link is in use and valid but not considered the main source of information about a patient. The link points forward to another patient resource that should be consulted to retrieve additional patient information.";
            }
            case SEEALSO: {
                return "The patient resource containing this link is in use and valid, but points to another patient resource that is known to contain data about the same person. Data in this resource might overlap or contradict information found in the other patient resource. This link does not indicate any relative importance of the resources concerned, and both should be regarded as equally valid.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case REPLACEDBY: {
                return "Replaced-by";
            }
            case REPLACES: {
                return "Replaces";
            }
            case REFER: {
                return "Refer";
            }
            case SEEALSO: {
                return "See also";
            }
        }
        return "?";
    }
}

