/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CatalogContentStatus {
    APPROVED,
    PENDING,
    DISCONTINUED,
    OFFICIAL,
    NULL;


    public static CatalogContentStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("approved".equals(codeString)) {
            return APPROVED;
        }
        if ("pending".equals(codeString)) {
            return PENDING;
        }
        if ("discontinued".equals(codeString)) {
            return DISCONTINUED;
        }
        if ("official".equals(codeString)) {
            return OFFICIAL;
        }
        throw new FHIRException("Unknown CatalogContentStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case APPROVED: {
                return "approved";
            }
            case PENDING: {
                return "pending";
            }
            case DISCONTINUED: {
                return "discontinued";
            }
            case OFFICIAL: {
                return "official";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/catalog-content-status";
    }

    public String getDefinition() {
        switch (this) {
            case APPROVED: {
                return "The catalog is approved";
            }
            case PENDING: {
                return "The catalog content is pending some action e.g. confirmation or approval";
            }
            case DISCONTINUED: {
                return "The catalog is discontinued";
            }
            case OFFICIAL: {
                return "The catalog content is considered official";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case APPROVED: {
                return "Approved";
            }
            case PENDING: {
                return "Pending";
            }
            case DISCONTINUED: {
                return "Discontinued";
            }
            case OFFICIAL: {
                return "Official";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

