/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SpecificationType {
    UNSPECIFIED,
    SERIALNUMBER,
    PARTNUMBER,
    HARDWAREREVISION,
    SOFTWAREREVISION,
    FIRMWAREREVISION,
    PROTOCOLREVISION,
    GMDN,
    NULL;


    public static SpecificationType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("unspecified".equals(codeString)) {
            return UNSPECIFIED;
        }
        if ("serial-number".equals(codeString)) {
            return SERIALNUMBER;
        }
        if ("part-number".equals(codeString)) {
            return PARTNUMBER;
        }
        if ("hardware-revision".equals(codeString)) {
            return HARDWAREREVISION;
        }
        if ("software-revision".equals(codeString)) {
            return SOFTWAREREVISION;
        }
        if ("firmware-revision".equals(codeString)) {
            return FIRMWAREREVISION;
        }
        if ("protocol-revision".equals(codeString)) {
            return PROTOCOLREVISION;
        }
        if ("gmdn".equals(codeString)) {
            return GMDN;
        }
        throw new FHIRException("Unknown SpecificationType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case UNSPECIFIED: {
                return "unspecified";
            }
            case SERIALNUMBER: {
                return "serial-number";
            }
            case PARTNUMBER: {
                return "part-number";
            }
            case HARDWAREREVISION: {
                return "hardware-revision";
            }
            case SOFTWAREREVISION: {
                return "software-revision";
            }
            case FIRMWAREREVISION: {
                return "firmware-revision";
            }
            case PROTOCOLREVISION: {
                return "protocol-revision";
            }
            case GMDN: {
                return "gmdn";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/specification-type";
    }

    public String getDefinition() {
        switch (this) {
            case UNSPECIFIED: {
                return "Unspecified Production Specification - MDC_ID_PROD_SPEC_UNSPECIFIED";
            }
            case SERIALNUMBER: {
                return "Serial Number - MDC_ID_PROD_SPEC_SERIAL";
            }
            case PARTNUMBER: {
                return "Part Number - MDC_ID_PROD_SPEC_PART";
            }
            case HARDWAREREVISION: {
                return "Hardware Revision - MDC_ID_PROD_SPEC_HW";
            }
            case SOFTWAREREVISION: {
                return "Software Revision - MDC_ID_PROD_SPEC_SW";
            }
            case FIRMWAREREVISION: {
                return "Firmware Revision - MDC_ID_PROD_SPEC_FW";
            }
            case PROTOCOLREVISION: {
                return "Protocol Revision - MDC_ID_PROD_SPEC_PROTOCOL";
            }
            case GMDN: {
                return "GMDN - MDC_ID_PROD_SPEC_GMDN";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case UNSPECIFIED: {
                return "Unspecified Production Specification";
            }
            case SERIALNUMBER: {
                return "Serial Number";
            }
            case PARTNUMBER: {
                return "Part Number";
            }
            case HARDWAREREVISION: {
                return "Hardware Revision";
            }
            case SOFTWAREREVISION: {
                return "Software Revision";
            }
            case FIRMWAREREVISION: {
                return "Firmware Revision";
            }
            case PROTOCOLREVISION: {
                return "Protocol Revision";
            }
            case GMDN: {
                return "GMDN";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

