/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CatalogEntryType {
    MEDICATION,
    DEVICE,
    NULL;


    public static CatalogEntryType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("medication".equals(codeString)) {
            return MEDICATION;
        }
        if ("device".equals(codeString)) {
            return DEVICE;
        }
        throw new FHIRException("Unknown CatalogEntryType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MEDICATION: {
                return "medication";
            }
            case DEVICE: {
                return "device";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/catalog-entry-type";
    }

    public String getDefinition() {
        switch (this) {
            case MEDICATION: {
                return "This is a medication";
            }
            case DEVICE: {
                return "This is a device";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MEDICATION: {
                return "Medication";
            }
            case DEVICE: {
                return "Device";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

