/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.BenefitCategory;

public class BenefitCategoryEnumFactory
implements EnumFactory<BenefitCategory> {
    @Override
    public BenefitCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("oral".equals(codeString)) {
            return BenefitCategory.ORAL;
        }
        if ("vision".equals(codeString)) {
            return BenefitCategory.VISION;
        }
        if ("medical".equals(codeString)) {
            return BenefitCategory.MEDICAL;
        }
        if ("pharmacy".equals(codeString)) {
            return BenefitCategory.PHARMACY;
        }
        throw new IllegalArgumentException("Unknown BenefitCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(BenefitCategory code) {
        if (code == BenefitCategory.ORAL) {
            return "oral";
        }
        if (code == BenefitCategory.VISION) {
            return "vision";
        }
        if (code == BenefitCategory.MEDICAL) {
            return "medical";
        }
        if (code == BenefitCategory.PHARMACY) {
            return "pharmacy";
        }
        return "?";
    }

    @Override
    public String toSystem(BenefitCategory code) {
        return code.getSystem();
    }
}

