/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.utils.client.network;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RetryInterceptor
implements Interceptor {
    private final long RETRY_TIME = 2000L;
    private final int maxRetry;
    private int retryCounter = 0;

    public RetryInterceptor(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = null;
        do {
            try {
                if (response != null) {
                    System.out.println("Previous " + chain.request().method() + " attempt returned HTTP<" + response.code() + "> from url -> " + chain.request().url() + ".");
                    response.close();
                }
                response = chain.proceed(request);
            }
            catch (IOException e) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    System.out.println(chain.request().method() + " to url -> " + chain.request().url() + " interrupted on try <" + this.retryCounter + ">");
                }
            }
            finally {
                ++this.retryCounter;
            }
        } while ((response == null || !response.isSuccessful()) && this.retryCounter <= this.maxRetry + 1);
        return response != null ? response : chain.proceed(request);
    }
}

