/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ResearchStudyStatus {
    DRAFT,
    INPROGRESS,
    SUSPENDED,
    STOPPED,
    COMPLETED,
    ENTEREDINERROR,
    NULL;


    public static ResearchStudyStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("suspended".equals(codeString)) {
            return SUSPENDED;
        }
        if ("stopped".equals(codeString)) {
            return STOPPED;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown ResearchStudyStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case INPROGRESS: {
                return "in-progress";
            }
            case SUSPENDED: {
                return "suspended";
            }
            case STOPPED: {
                return "stopped";
            }
            case COMPLETED: {
                return "completed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/research-study-status";
    }

    public String getDefinition() {
        switch (this) {
            case DRAFT: {
                return "The study is undergoing design but the process of selecting study subjects and capturing data has not yet begun.";
            }
            case INPROGRESS: {
                return "The study is currently being executed";
            }
            case SUSPENDED: {
                return "Execution of the study has been temporarily paused";
            }
            case STOPPED: {
                return "The study was terminated prior to the final determination of results";
            }
            case COMPLETED: {
                return "The information sought by the study has been gathered and compiled and no further work is being performed";
            }
            case ENTEREDINERROR: {
                return "This study never actually existed.  The record is retained for tracking purposes in the event decisions may have been made based on this erroneous information.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DRAFT: {
                return "Draft";
            }
            case INPROGRESS: {
                return "In-progress";
            }
            case SUSPENDED: {
                return "Suspended";
            }
            case STOPPED: {
                return "Stopped";
            }
            case COMPLETED: {
                return "Completed";
            }
            case ENTEREDINERROR: {
                return "Entered in error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

