/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MedicationStatementTaken {
    Y,
    N,
    UNK,
    NA,
    NULL;


    public static MedicationStatementTaken fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("y".equals(codeString)) {
            return Y;
        }
        if ("n".equals(codeString)) {
            return N;
        }
        if ("unk".equals(codeString)) {
            return UNK;
        }
        if ("na".equals(codeString)) {
            return NA;
        }
        throw new FHIRException("Unknown MedicationStatementTaken code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case Y: {
                return "y";
            }
            case N: {
                return "n";
            }
            case UNK: {
                return "unk";
            }
            case NA: {
                return "na";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/medication-statement-taken";
    }

    public String getDefinition() {
        switch (this) {
            case Y: {
                return "Positive assertion that patient has taken medication";
            }
            case N: {
                return "Negative assertion that patient has not taken medication";
            }
            case UNK: {
                return "Unknown assertion if patient has taken medication";
            }
            case NA: {
                return "Patient reporting does not apply";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case Y: {
                return "Yes";
            }
            case N: {
                return "No";
            }
            case UNK: {
                return "Unknown";
            }
            case NA: {
                return "Not Applicable";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

