/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum Participantrequired {
    REQUIRED,
    OPTIONAL,
    INFORMATIONONLY,
    NULL;


    public static Participantrequired fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("required".equals(codeString)) {
            return REQUIRED;
        }
        if ("optional".equals(codeString)) {
            return OPTIONAL;
        }
        if ("information-only".equals(codeString)) {
            return INFORMATIONONLY;
        }
        throw new FHIRException("Unknown Participantrequired code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case REQUIRED: {
                return "required";
            }
            case OPTIONAL: {
                return "optional";
            }
            case INFORMATIONONLY: {
                return "information-only";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/participantrequired";
    }

    public String getDefinition() {
        switch (this) {
            case REQUIRED: {
                return "The participant is required to attend the appointment.";
            }
            case OPTIONAL: {
                return "The participant may optionally attend the appointment.";
            }
            case INFORMATIONONLY: {
                return "The participant is excluded from the appointment, and may not be informed of the appointment taking place. (Appointment is about them, not for them - such as 2 doctors discussing results about a patient's test).";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case REQUIRED: {
                return "Required";
            }
            case OPTIONAL: {
                return "Optional";
            }
            case INFORMATIONONLY: {
                return "Information Only";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

