/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ClaimStatus;

public class ClaimStatusEnumFactory
implements EnumFactory<ClaimStatus> {
    @Override
    public ClaimStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ClaimStatus.ACTIVE;
        }
        if ("cancelled".equals(codeString)) {
            return ClaimStatus.CANCELLED;
        }
        if ("draft".equals(codeString)) {
            return ClaimStatus.DRAFT;
        }
        if ("entered-in-error".equals(codeString)) {
            return ClaimStatus.ENTEREDINERROR;
        }
        throw new IllegalArgumentException("Unknown ClaimStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(ClaimStatus code) {
        if (code == ClaimStatus.ACTIVE) {
            return "active";
        }
        if (code == ClaimStatus.CANCELLED) {
            return "cancelled";
        }
        if (code == ClaimStatus.DRAFT) {
            return "draft";
        }
        if (code == ClaimStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        return "?";
    }

    @Override
    public String toSystem(ClaimStatus code) {
        return code.getSystem();
    }
}

