/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.PlanDefinitionType;

public class PlanDefinitionTypeEnumFactory
implements EnumFactory<PlanDefinitionType> {
    @Override
    public PlanDefinitionType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("order-set".equals(codeString)) {
            return PlanDefinitionType.ORDERSET;
        }
        if ("protocol".equals(codeString)) {
            return PlanDefinitionType.PROTOCOL;
        }
        if ("eca-rule".equals(codeString)) {
            return PlanDefinitionType.ECARULE;
        }
        throw new IllegalArgumentException("Unknown PlanDefinitionType code '" + codeString + "'");
    }

    @Override
    public String toCode(PlanDefinitionType code) {
        if (code == PlanDefinitionType.ORDERSET) {
            return "order-set";
        }
        if (code == PlanDefinitionType.PROTOCOL) {
            return "protocol";
        }
        if (code == PlanDefinitionType.ECARULE) {
            return "eca-rule";
        }
        return "?";
    }

    @Override
    public String toSystem(PlanDefinitionType code) {
        return code.getSystem();
    }
}

