/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DeviceMetric;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PositiveIntType;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.ProcedureRequest;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.Specimen;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UnsignedIntType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;

@ResourceDef(name="Media", profile="http://hl7.org/fhir/Profile/Media")
public class Media
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier(s) for the image", formalDefinition="Identifiers associated with the image - these may include identifiers for the image itself, identifiers for the context of its collection (e.g. series ids) and context ids such as accession numbers or other workflow identifiers.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={ProcedureRequest.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Procedure that caused this media to be created", formalDefinition="A procedure that is fulfilled in whole or in part by the creation of this media.")
    protected List<Reference> basedOn;
    protected List<ProcedureRequest> basedOnTarget;
    @Child(name="type", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="photo | video | audio", formalDefinition="Whether the media is a photo (still image), an audio recording, or a video recording.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/digital-media-type")
    protected Enumeration<DigitalMediaType> type;
    @Child(name="subtype", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The type of acquisition equipment/process", formalDefinition="Details of the type of the media - usually, how it was acquired (what type of device). If images sourced from a DICOM system, are wrapped in a Media resource, then this is the modality.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/digital-media-subtype")
    protected CodeableConcept subtype;
    @Child(name="view", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Imaging view, e.g. Lateral or Antero-posterior", formalDefinition="The name of the imaging view e.g. Lateral or Antero-posterior (AP).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/media-view")
    protected CodeableConcept view;
    @Child(name="subject", type={Patient.class, Practitioner.class, Group.class, Device.class, Specimen.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/What this Media is a record of", formalDefinition="Who/What this Media is a record of.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter / Episode associated with media", formalDefinition="The encounter or episode of care that establishes the context for this media.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="occurrence", type={DateTimeType.class, Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When Media was collected", formalDefinition="The date and time(s) at which the media was collected.")
    protected Type occurrence;
    @Child(name="operator", type={Practitioner.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The person who generated the image", formalDefinition="The person who administered the collection of the image.")
    protected Reference operator;
    protected Practitioner operatorTarget;
    @Child(name="reasonCode", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Why was event performed?", formalDefinition="Describes why the event occurred in coded or textual form.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-reason")
    protected List<CodeableConcept> reasonCode;
    @Child(name="bodySite", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Body part in media", formalDefinition="Indicates the site on the subject's body where the media was collected (i.e. the target site).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected CodeableConcept bodySite;
    @Child(name="device", type={Device.class, DeviceMetric.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Observing Device", formalDefinition="The device used to collect the media.")
    protected Reference device;
    protected Resource deviceTarget;
    @Child(name="height", type={PositiveIntType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Height of the image in pixels (photo/video)", formalDefinition="Height of the image in pixels (photo/video).")
    protected PositiveIntType height;
    @Child(name="width", type={PositiveIntType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Width of the image in pixels (photo/video)", formalDefinition="Width of the image in pixels (photo/video).")
    protected PositiveIntType width;
    @Child(name="frames", type={PositiveIntType.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of frames if > 1 (photo)", formalDefinition="The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif. If there is more than one frame, this SHALL have a value in order to alert interface software that a multi-frame capable rendering widget is required.")
    protected PositiveIntType frames;
    @Child(name="duration", type={UnsignedIntType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Length in seconds (audio / video)", formalDefinition="The duration of the recording in seconds - for audio and video.")
    protected UnsignedIntType duration;
    @Child(name="content", type={Attachment.class}, order=16, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Actual Media - reference or data", formalDefinition="The actual content of the media - inline or by direct reference to the media source file.")
    protected Attachment content;
    @Child(name="note", type={Annotation.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the media", formalDefinition="Comments made about the media by the performer, subject or other participants.")
    protected List<Annotation> note;
    private static final long serialVersionUID = -831317677L;
    @SearchParamDefinition(name="date", path="Media.occurrence", description="When Media was collected", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Media.identifier", description="Identifier(s) for the image", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="created", path="Media.content.creation", description="Date attachment was first created", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="subject", path="Media.subject", description="Who/What this Media is a record of", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Patient"), @Compartment(name="Practitioner")}, target={Device.class, Group.class, Patient.class, Practitioner.class, Specimen.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Media:subject").toLocked();
    @SearchParamDefinition(name="type", path="Media.type", description="photo | video | audio", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="operator", path="Media.operator", description="The person who generated the image", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class})
    public static final String SP_OPERATOR = "operator";
    public static final ReferenceClientParam OPERATOR = new ReferenceClientParam("operator");
    public static final Include INCLUDE_OPERATOR = new Include("Media:operator").toLocked();
    @SearchParamDefinition(name="view", path="Media.view", description="Imaging view, e.g. Lateral or Antero-posterior", type="token")
    public static final String SP_VIEW = "view";
    public static final TokenClientParam VIEW = new TokenClientParam("view");
    @SearchParamDefinition(name="site", path="Media.bodySite", description="Body part in media", type="token")
    public static final String SP_SITE = "site";
    public static final TokenClientParam SITE = new TokenClientParam("site");
    @SearchParamDefinition(name="based-on", path="Media.basedOn", description="Procedure that caused this media to be created", type="reference", target={ProcedureRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("Media:based-on").toLocked();
    @SearchParamDefinition(name="subtype", path="Media.subtype", description="The type of acquisition equipment/process", type="token")
    public static final String SP_SUBTYPE = "subtype";
    public static final TokenClientParam SUBTYPE = new TokenClientParam("subtype");
    @SearchParamDefinition(name="patient", path="Media.subject", description="Who/What this Media is a record of", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Media:patient").toLocked();
    @SearchParamDefinition(name="context", path="Media.context", description="Encounter / Episode associated with media", type="reference", target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("Media:context").toLocked();
    @SearchParamDefinition(name="device", path="Media.device", description="Observing Device", type="reference", target={Device.class, DeviceMetric.class})
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("Media:device").toLocked();

    public Media() {
    }

    public Media(Enumeration<DigitalMediaType> type, Attachment content) {
        this.type = type;
        this.content = content;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Media setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Media addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Media setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public Media addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    @Deprecated
    public List<ProcedureRequest> getBasedOnTarget() {
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<ProcedureRequest>();
        }
        return this.basedOnTarget;
    }

    @Deprecated
    public ProcedureRequest addBasedOnTarget() {
        ProcedureRequest r = new ProcedureRequest();
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<ProcedureRequest>();
        }
        this.basedOnTarget.add(r);
        return r;
    }

    public Enumeration<DigitalMediaType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<DigitalMediaType>(new DigitalMediaTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Media setTypeElement(Enumeration<DigitalMediaType> value) {
        this.type = value;
        return this;
    }

    public DigitalMediaType getType() {
        return this.type == null ? null : (DigitalMediaType)((Object)this.type.getValue());
    }

    public Media setType(DigitalMediaType value) {
        if (this.type == null) {
            this.type = new Enumeration<DigitalMediaType>(new DigitalMediaTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public CodeableConcept getSubtype() {
        if (this.subtype == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.subtype");
            }
            if (Configuration.doAutoCreate()) {
                this.subtype = new CodeableConcept();
            }
        }
        return this.subtype;
    }

    public boolean hasSubtype() {
        return this.subtype != null && !this.subtype.isEmpty();
    }

    public Media setSubtype(CodeableConcept value) {
        this.subtype = value;
        return this;
    }

    public CodeableConcept getView() {
        if (this.view == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.view");
            }
            if (Configuration.doAutoCreate()) {
                this.view = new CodeableConcept();
            }
        }
        return this.view;
    }

    public boolean hasView() {
        return this.view != null && !this.view.isEmpty();
    }

    public Media setView(CodeableConcept value) {
        this.view = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Media setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Media setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public Media setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public Media setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public Type getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (this.occurrence == null) {
            return null;
        }
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this != null && this.occurrence instanceof DateTimeType;
    }

    public Period getOccurrencePeriod() throws FHIRException {
        if (this.occurrence == null) {
            return null;
        }
        if (!(this.occurrence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurrence;
    }

    public boolean hasOccurrencePeriod() {
        return this != null && this.occurrence instanceof Period;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public Media setOccurrence(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new FHIRFormatError("Not the right type for Media.occurrence[x]: " + value.fhirType());
        }
        this.occurrence = value;
        return this;
    }

    public Reference getOperator() {
        if (this.operator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.operator");
            }
            if (Configuration.doAutoCreate()) {
                this.operator = new Reference();
            }
        }
        return this.operator;
    }

    public boolean hasOperator() {
        return this.operator != null && !this.operator.isEmpty();
    }

    public Media setOperator(Reference value) {
        this.operator = value;
        return this;
    }

    public Practitioner getOperatorTarget() {
        if (this.operatorTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.operator");
            }
            if (Configuration.doAutoCreate()) {
                this.operatorTarget = new Practitioner();
            }
        }
        return this.operatorTarget;
    }

    public Media setOperatorTarget(Practitioner value) {
        this.operatorTarget = value;
        return this;
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public Media setReasonCode(List<CodeableConcept> theReasonCode) {
        this.reasonCode = theReasonCode;
        return this;
    }

    public boolean hasReasonCode() {
        if (this.reasonCode == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return t;
    }

    public Media addReasonCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return this;
    }

    public CodeableConcept getReasonCodeFirstRep() {
        if (this.getReasonCode().isEmpty()) {
            this.addReasonCode();
        }
        return this.getReasonCode().get(0);
    }

    public CodeableConcept getBodySite() {
        if (this.bodySite == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.bodySite");
            }
            if (Configuration.doAutoCreate()) {
                this.bodySite = new CodeableConcept();
            }
        }
        return this.bodySite;
    }

    public boolean hasBodySite() {
        return this.bodySite != null && !this.bodySite.isEmpty();
    }

    public Media setBodySite(CodeableConcept value) {
        this.bodySite = value;
        return this;
    }

    public Reference getDevice() {
        if (this.device == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.device");
            }
            if (Configuration.doAutoCreate()) {
                this.device = new Reference();
            }
        }
        return this.device;
    }

    public boolean hasDevice() {
        return this.device != null && !this.device.isEmpty();
    }

    public Media setDevice(Reference value) {
        this.device = value;
        return this;
    }

    public Resource getDeviceTarget() {
        return this.deviceTarget;
    }

    public Media setDeviceTarget(Resource value) {
        this.deviceTarget = value;
        return this;
    }

    public PositiveIntType getHeightElement() {
        if (this.height == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.height");
            }
            if (Configuration.doAutoCreate()) {
                this.height = new PositiveIntType();
            }
        }
        return this.height;
    }

    public boolean hasHeightElement() {
        return this.height != null && !this.height.isEmpty();
    }

    public boolean hasHeight() {
        return this.height != null && !this.height.isEmpty();
    }

    public Media setHeightElement(PositiveIntType value) {
        this.height = value;
        return this;
    }

    public int getHeight() {
        return this.height == null || this.height.isEmpty() ? 0 : (Integer)this.height.getValue();
    }

    public Media setHeight(int value) {
        if (this.height == null) {
            this.height = new PositiveIntType();
        }
        this.height.setValue((Object)value);
        return this;
    }

    public PositiveIntType getWidthElement() {
        if (this.width == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.width");
            }
            if (Configuration.doAutoCreate()) {
                this.width = new PositiveIntType();
            }
        }
        return this.width;
    }

    public boolean hasWidthElement() {
        return this.width != null && !this.width.isEmpty();
    }

    public boolean hasWidth() {
        return this.width != null && !this.width.isEmpty();
    }

    public Media setWidthElement(PositiveIntType value) {
        this.width = value;
        return this;
    }

    public int getWidth() {
        return this.width == null || this.width.isEmpty() ? 0 : (Integer)this.width.getValue();
    }

    public Media setWidth(int value) {
        if (this.width == null) {
            this.width = new PositiveIntType();
        }
        this.width.setValue((Object)value);
        return this;
    }

    public PositiveIntType getFramesElement() {
        if (this.frames == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.frames");
            }
            if (Configuration.doAutoCreate()) {
                this.frames = new PositiveIntType();
            }
        }
        return this.frames;
    }

    public boolean hasFramesElement() {
        return this.frames != null && !this.frames.isEmpty();
    }

    public boolean hasFrames() {
        return this.frames != null && !this.frames.isEmpty();
    }

    public Media setFramesElement(PositiveIntType value) {
        this.frames = value;
        return this;
    }

    public int getFrames() {
        return this.frames == null || this.frames.isEmpty() ? 0 : (Integer)this.frames.getValue();
    }

    public Media setFrames(int value) {
        if (this.frames == null) {
            this.frames = new PositiveIntType();
        }
        this.frames.setValue((Object)value);
        return this;
    }

    public UnsignedIntType getDurationElement() {
        if (this.duration == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.duration");
            }
            if (Configuration.doAutoCreate()) {
                this.duration = new UnsignedIntType();
            }
        }
        return this.duration;
    }

    public boolean hasDurationElement() {
        return this.duration != null && !this.duration.isEmpty();
    }

    public boolean hasDuration() {
        return this.duration != null && !this.duration.isEmpty();
    }

    public Media setDurationElement(UnsignedIntType value) {
        this.duration = value;
        return this;
    }

    public int getDuration() {
        return this.duration == null || this.duration.isEmpty() ? 0 : (Integer)this.duration.getValue();
    }

    public Media setDuration(int value) {
        if (this.duration == null) {
            this.duration = new UnsignedIntType();
        }
        this.duration.setValue((Object)value);
        return this;
    }

    public Attachment getContent() {
        if (this.content == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.content");
            }
            if (Configuration.doAutoCreate()) {
                this.content = new Attachment();
            }
        }
        return this.content;
    }

    public boolean hasContent() {
        return this.content != null && !this.content.isEmpty();
    }

    public Media setContent(Attachment value) {
        this.content = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Media setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Media addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with the image - these may include identifiers for the image itself, identifiers for the context of its collection (e.g. series ids) and context ids such as accession numbers or other workflow identifiers.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(ProcedureRequest)", "A procedure that is fulfilled in whole or in part by the creation of this media.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property(SP_TYPE, "code", "Whether the media is a photo (still image), an audio recording, or a video recording.", 0, 1, this.type));
        children.add(new Property(SP_SUBTYPE, "CodeableConcept", "Details of the type of the media - usually, how it was acquired (what type of device). If images sourced from a DICOM system, are wrapped in a Media resource, then this is the modality.", 0, 1, this.subtype));
        children.add(new Property(SP_VIEW, "CodeableConcept", "The name of the imaging view e.g. Lateral or Antero-posterior (AP).", 0, 1, this.view));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Practitioner|Group|Device|Specimen)", "Who/What this Media is a record of.", 0, 1, this.subject));
        children.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The encounter or episode of care that establishes the context for this media.", 0, 1, this.context));
        children.add(new Property("occurrence[x]", "dateTime|Period", "The date and time(s) at which the media was collected.", 0, 1, this.occurrence));
        children.add(new Property(SP_OPERATOR, "Reference(Practitioner)", "The person who administered the collection of the image.", 0, 1, this.operator));
        children.add(new Property("reasonCode", "CodeableConcept", "Describes why the event occurred in coded or textual form.", 0, Integer.MAX_VALUE, this.reasonCode));
        children.add(new Property("bodySite", "CodeableConcept", "Indicates the site on the subject's body where the media was collected (i.e. the target site).", 0, 1, this.bodySite));
        children.add(new Property(SP_DEVICE, "Reference(Device|DeviceMetric)", "The device used to collect the media.", 0, 1, this.device));
        children.add(new Property("height", "positiveInt", "Height of the image in pixels (photo/video).", 0, 1, this.height));
        children.add(new Property("width", "positiveInt", "Width of the image in pixels (photo/video).", 0, 1, this.width));
        children.add(new Property("frames", "positiveInt", "The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif. If there is more than one frame, this SHALL have a value in order to alert interface software that a multi-frame capable rendering widget is required.", 0, 1, this.frames));
        children.add(new Property("duration", "unsignedInt", "The duration of the recording in seconds - for audio and video.", 0, 1, this.duration));
        children.add(new Property("content", "Attachment", "The actual content of the media - inline or by direct reference to the media source file.", 0, 1, this.content));
        children.add(new Property("note", "Annotation", "Comments made about the media by the performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with the image - these may include identifiers for the image itself, identifiers for the context of its collection (e.g. series ids) and context ids such as accession numbers or other workflow identifiers.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(ProcedureRequest)", "A procedure that is fulfilled in whole or in part by the creation of this media.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case 3575610: {
                return new Property(SP_TYPE, "code", "Whether the media is a photo (still image), an audio recording, or a video recording.", 0, 1, this.type);
            }
            case -1867567750: {
                return new Property(SP_SUBTYPE, "CodeableConcept", "Details of the type of the media - usually, how it was acquired (what type of device). If images sourced from a DICOM system, are wrapped in a Media resource, then this is the modality.", 0, 1, this.subtype);
            }
            case 3619493: {
                return new Property(SP_VIEW, "CodeableConcept", "The name of the imaging view e.g. Lateral or Antero-posterior (AP).", 0, 1, this.view);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Practitioner|Group|Device|Specimen)", "Who/What this Media is a record of.", 0, 1, this.subject);
            }
            case 951530927: {
                return new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The encounter or episode of care that establishes the context for this media.", 0, 1, this.context);
            }
            case -2022646513: {
                return new Property("occurrence[x]", "dateTime|Period", "The date and time(s) at which the media was collected.", 0, 1, this.occurrence);
            }
            case 1687874001: {
                return new Property("occurrence[x]", "dateTime|Period", "The date and time(s) at which the media was collected.", 0, 1, this.occurrence);
            }
            case -298443636: {
                return new Property("occurrence[x]", "dateTime|Period", "The date and time(s) at which the media was collected.", 0, 1, this.occurrence);
            }
            case 1397156594: {
                return new Property("occurrence[x]", "dateTime|Period", "The date and time(s) at which the media was collected.", 0, 1, this.occurrence);
            }
            case -500553564: {
                return new Property(SP_OPERATOR, "Reference(Practitioner)", "The person who administered the collection of the image.", 0, 1, this.operator);
            }
            case 722137681: {
                return new Property("reasonCode", "CodeableConcept", "Describes why the event occurred in coded or textual form.", 0, Integer.MAX_VALUE, this.reasonCode);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableConcept", "Indicates the site on the subject's body where the media was collected (i.e. the target site).", 0, 1, this.bodySite);
            }
            case -1335157162: {
                return new Property(SP_DEVICE, "Reference(Device|DeviceMetric)", "The device used to collect the media.", 0, 1, this.device);
            }
            case -1221029593: {
                return new Property("height", "positiveInt", "Height of the image in pixels (photo/video).", 0, 1, this.height);
            }
            case 113126854: {
                return new Property("width", "positiveInt", "Width of the image in pixels (photo/video).", 0, 1, this.width);
            }
            case -1266514778: {
                return new Property("frames", "positiveInt", "The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif. If there is more than one frame, this SHALL have a value in order to alert interface software that a multi-frame capable rendering widget is required.", 0, 1, this.frames);
            }
            case -1992012396: {
                return new Property("duration", "unsignedInt", "The duration of the recording in seconds - for audio and video.", 0, 1, this.duration);
            }
            case 951530617: {
                return new Property("content", "Attachment", "The actual content of the media - inline or by direct reference to the media source file.", 0, 1, this.content);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments made about the media by the performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case -1867567750: {
                Base[] baseArray;
                if (this.subtype == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.subtype;
                }
                return baseArray;
            }
            case 3619493: {
                Base[] baseArray;
                if (this.view == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.view;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.context;
                }
                return baseArray;
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.occurrence;
                }
                return baseArray;
            }
            case -500553564: {
                Base[] baseArray;
                if (this.operator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.operator;
                }
                return baseArray;
            }
            case 722137681: {
                return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
            }
            case 1702620169: {
                Base[] baseArray;
                if (this.bodySite == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.bodySite;
                }
                return baseArray;
            }
            case -1335157162: {
                Base[] baseArray;
                if (this.device == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.device;
                }
                return baseArray;
            }
            case -1221029593: {
                Base[] baseArray;
                if (this.height == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.height;
                }
                return baseArray;
            }
            case 113126854: {
                Base[] baseArray;
                if (this.width == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.width;
                }
                return baseArray;
            }
            case -1266514778: {
                Base[] baseArray;
                if (this.frames == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.frames;
                }
                return baseArray;
            }
            case -1992012396: {
                Base[] baseArray;
                if (this.duration == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.duration;
                }
                return baseArray;
            }
            case 951530617: {
                Base[] baseArray;
                if (this.content == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.content;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                return value;
            }
            case 3575610: {
                value = new DigitalMediaTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
                return value;
            }
            case -1867567750: {
                this.subtype = this.castToCodeableConcept(value);
                return value;
            }
            case 3619493: {
                this.view = this.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case 1687874001: {
                this.occurrence = this.castToType(value);
                return value;
            }
            case -500553564: {
                this.operator = this.castToReference(value);
                return value;
            }
            case 722137681: {
                this.getReasonCode().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1702620169: {
                this.bodySite = this.castToCodeableConcept(value);
                return value;
            }
            case -1335157162: {
                this.device = this.castToReference(value);
                return value;
            }
            case -1221029593: {
                this.height = this.castToPositiveInt(value);
                return value;
            }
            case 113126854: {
                this.width = this.castToPositiveInt(value);
                return value;
            }
            case -1266514778: {
                this.frames = this.castToPositiveInt(value);
                return value;
            }
            case -1992012396: {
                this.duration = this.castToUnsignedInt(value);
                return value;
            }
            case 951530617: {
                this.content = this.castToAttachment(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals(SP_TYPE)) {
            value = new DigitalMediaTypeEnumFactory().fromType(this.castToCode(value));
            this.type = value;
        } else if (name.equals(SP_SUBTYPE)) {
            this.subtype = this.castToCodeableConcept(value);
        } else if (name.equals(SP_VIEW)) {
            this.view = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = this.castToType(value);
        } else if (name.equals(SP_OPERATOR)) {
            this.operator = this.castToReference(value);
        } else if (name.equals("reasonCode")) {
            this.getReasonCode().add(this.castToCodeableConcept(value));
        } else if (name.equals("bodySite")) {
            this.bodySite = this.castToCodeableConcept(value);
        } else if (name.equals(SP_DEVICE)) {
            this.device = this.castToReference(value);
        } else if (name.equals("height")) {
            this.height = this.castToPositiveInt(value);
        } else if (name.equals("width")) {
            this.width = this.castToPositiveInt(value);
        } else if (name.equals("frames")) {
            this.frames = this.castToPositiveInt(value);
        } else if (name.equals("duration")) {
            this.duration = this.castToUnsignedInt(value);
        } else if (name.equals("content")) {
            this.content = this.castToAttachment(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case -1867567750: {
                return this.getSubtype();
            }
            case 3619493: {
                return this.getView();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.getContext();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case -500553564: {
                return this.getOperator();
            }
            case 722137681: {
                return this.addReasonCode();
            }
            case 1702620169: {
                return this.getBodySite();
            }
            case -1335157162: {
                return this.getDevice();
            }
            case -1221029593: {
                return this.getHeightElement();
            }
            case 113126854: {
                return this.getWidthElement();
            }
            case -1266514778: {
                return this.getFramesElement();
            }
            case -1992012396: {
                return this.getDurationElement();
            }
            case 951530617: {
                return this.getContent();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case 3575610: {
                return new String[]{"code"};
            }
            case -1867567750: {
                return new String[]{"CodeableConcept"};
            }
            case 3619493: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case 1687874001: {
                return new String[]{"dateTime", "Period"};
            }
            case -500553564: {
                return new String[]{"Reference"};
            }
            case 722137681: {
                return new String[]{"CodeableConcept"};
            }
            case 1702620169: {
                return new String[]{"CodeableConcept"};
            }
            case -1335157162: {
                return new String[]{"Reference"};
            }
            case -1221029593: {
                return new String[]{"positiveInt"};
            }
            case 113126854: {
                return new String[]{"positiveInt"};
            }
            case -1266514778: {
                return new String[]{"positiveInt"};
            }
            case -1992012396: {
                return new String[]{"unsignedInt"};
            }
            case 951530617: {
                return new String[]{"Attachment"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Media.type");
        }
        if (name.equals(SP_SUBTYPE)) {
            this.subtype = new CodeableConcept();
            return this.subtype;
        }
        if (name.equals(SP_VIEW)) {
            this.view = new CodeableConcept();
            return this.view;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrencePeriod")) {
            this.occurrence = new Period();
            return this.occurrence;
        }
        if (name.equals(SP_OPERATOR)) {
            this.operator = new Reference();
            return this.operator;
        }
        if (name.equals("reasonCode")) {
            return this.addReasonCode();
        }
        if (name.equals("bodySite")) {
            this.bodySite = new CodeableConcept();
            return this.bodySite;
        }
        if (name.equals(SP_DEVICE)) {
            this.device = new Reference();
            return this.device;
        }
        if (name.equals("height")) {
            throw new FHIRException("Cannot call addChild on a primitive type Media.height");
        }
        if (name.equals("width")) {
            throw new FHIRException("Cannot call addChild on a primitive type Media.width");
        }
        if (name.equals("frames")) {
            throw new FHIRException("Cannot call addChild on a primitive type Media.frames");
        }
        if (name.equals("duration")) {
            throw new FHIRException("Cannot call addChild on a primitive type Media.duration");
        }
        if (name.equals("content")) {
            this.content = new Attachment();
            return this.content;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Media";
    }

    @Override
    public Media copy() {
        Media dst = new Media();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.subtype = this.subtype == null ? null : this.subtype.copy();
        dst.view = this.view == null ? null : this.view.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.context = this.context == null ? null : this.context.copy();
        dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        Reference reference = dst.operator = this.operator == null ? null : this.operator.copy();
        if (this.reasonCode != null) {
            dst.reasonCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonCode) {
                dst.reasonCode.add(codeableConcept.copy());
            }
        }
        dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
        dst.device = this.device == null ? null : this.device.copy();
        dst.height = this.height == null ? null : this.height.copy();
        dst.width = this.width == null ? null : this.width.copy();
        dst.frames = this.frames == null ? null : this.frames.copy();
        dst.duration = this.duration == null ? null : this.duration.copy();
        Attachment attachment = dst.content = this.content == null ? null : this.content.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        return dst;
    }

    protected Media typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Media)) {
            return false;
        }
        Media o = (Media)other_;
        return Media.compareDeep(this.identifier, o.identifier, true) && Media.compareDeep(this.basedOn, o.basedOn, true) && Media.compareDeep(this.type, o.type, true) && Media.compareDeep(this.subtype, o.subtype, true) && Media.compareDeep(this.view, o.view, true) && Media.compareDeep(this.subject, o.subject, true) && Media.compareDeep(this.context, o.context, true) && Media.compareDeep(this.occurrence, o.occurrence, true) && Media.compareDeep(this.operator, o.operator, true) && Media.compareDeep(this.reasonCode, o.reasonCode, true) && Media.compareDeep(this.bodySite, o.bodySite, true) && Media.compareDeep(this.device, o.device, true) && Media.compareDeep(this.height, o.height, true) && Media.compareDeep(this.width, o.width, true) && Media.compareDeep(this.frames, o.frames, true) && Media.compareDeep(this.duration, o.duration, true) && Media.compareDeep(this.content, o.content, true) && Media.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Media)) {
            return false;
        }
        Media o = (Media)other_;
        return Media.compareValues(this.type, o.type, true) && Media.compareValues(this.height, o.height, true) && Media.compareValues(this.width, o.width, true) && Media.compareValues(this.frames, o.frames, true) && Media.compareValues(this.duration, o.duration, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.type, this.subtype, this.view, this.subject, this.context, this.occurrence, this.operator, this.reasonCode, this.bodySite, this.device, this.height, this.width, this.frames, this.duration, this.content, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Media;
    }

    public static class DigitalMediaTypeEnumFactory
    implements EnumFactory<DigitalMediaType> {
        @Override
        public DigitalMediaType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("photo".equals(codeString)) {
                return DigitalMediaType.PHOTO;
            }
            if ("video".equals(codeString)) {
                return DigitalMediaType.VIDEO;
            }
            if ("audio".equals(codeString)) {
                return DigitalMediaType.AUDIO;
            }
            throw new IllegalArgumentException("Unknown DigitalMediaType code '" + codeString + "'");
        }

        public Enumeration<DigitalMediaType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DigitalMediaType>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("photo".equals(codeString)) {
                return new Enumeration<DigitalMediaType>(this, DigitalMediaType.PHOTO);
            }
            if ("video".equals(codeString)) {
                return new Enumeration<DigitalMediaType>(this, DigitalMediaType.VIDEO);
            }
            if ("audio".equals(codeString)) {
                return new Enumeration<DigitalMediaType>(this, DigitalMediaType.AUDIO);
            }
            throw new FHIRException("Unknown DigitalMediaType code '" + codeString + "'");
        }

        @Override
        public String toCode(DigitalMediaType code) {
            if (code == DigitalMediaType.PHOTO) {
                return "photo";
            }
            if (code == DigitalMediaType.VIDEO) {
                return "video";
            }
            if (code == DigitalMediaType.AUDIO) {
                return "audio";
            }
            return "?";
        }

        @Override
        public String toSystem(DigitalMediaType code) {
            return code.getSystem();
        }
    }

    public static enum DigitalMediaType {
        PHOTO,
        VIDEO,
        AUDIO,
        NULL;


        public static DigitalMediaType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("photo".equals(codeString)) {
                return PHOTO;
            }
            if ("video".equals(codeString)) {
                return VIDEO;
            }
            if ("audio".equals(codeString)) {
                return AUDIO;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DigitalMediaType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PHOTO: {
                    return "photo";
                }
                case VIDEO: {
                    return "video";
                }
                case AUDIO: {
                    return "audio";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PHOTO: {
                    return "http://hl7.org/fhir/digital-media-type";
                }
                case VIDEO: {
                    return "http://hl7.org/fhir/digital-media-type";
                }
                case AUDIO: {
                    return "http://hl7.org/fhir/digital-media-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PHOTO: {
                    return "The media consists of one or more unmoving images, including photographs, computer-generated graphs and charts, and scanned documents";
                }
                case VIDEO: {
                    return "The media consists of a series of frames that capture a moving image";
                }
                case AUDIO: {
                    return "The media consists of a sound recording";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PHOTO: {
                    return "Photo";
                }
                case VIDEO: {
                    return "Video";
                }
                case AUDIO: {
                    return "Audio";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

