/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.Consent;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResearchStudy;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ResearchSubject", profile="http://hl7.org/fhir/Profile/ResearchSubject")
public class ResearchSubject
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for research subject", formalDefinition="Identifiers assigned to this research study by the sponsor or other systems.")
    protected Identifier identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="candidate | enrolled | active | suspended | withdrawn | completed", formalDefinition="The current state of the subject.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-subject-status")
    protected Enumeration<ResearchSubjectStatus> status;
    @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Start and end of participation", formalDefinition="The dates the subject began and ended their participation in the study.")
    protected Period period;
    @Child(name="study", type={ResearchStudy.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Study subject is part of", formalDefinition="Reference to the study the subject is participating in.")
    protected Reference study;
    protected ResearchStudy studyTarget;
    @Child(name="individual", type={Patient.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is part of study", formalDefinition="The record of the person or animal who is involved in the study.")
    protected Reference individual;
    protected Patient individualTarget;
    @Child(name="assignedArm", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What path should be followed", formalDefinition="The name of the arm in the study the subject is expected to follow as part of this study.")
    protected StringType assignedArm;
    @Child(name="actualArm", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What path was followed", formalDefinition="The name of the arm in the study the subject actually followed as part of this study.")
    protected StringType actualArm;
    @Child(name="consent", type={Consent.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Agreement to participate in study", formalDefinition="A record of the patient's informed agreement to participate in the study.")
    protected Reference consent;
    protected Consent consentTarget;
    private static final long serialVersionUID = -1730128953L;
    @SearchParamDefinition(name="date", path="ResearchSubject.period", description="Start and end of participation", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ResearchSubject.identifier", description="Business Identifier for research subject", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="individual", path="ResearchSubject.individual", description="Who is part of study", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_INDIVIDUAL = "individual";
    public static final ReferenceClientParam INDIVIDUAL = new ReferenceClientParam("individual");
    public static final Include INCLUDE_INDIVIDUAL = new Include("ResearchSubject:individual").toLocked();
    @SearchParamDefinition(name="patient", path="ResearchSubject.individual", description="Who is part of study", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ResearchSubject:patient").toLocked();
    @SearchParamDefinition(name="status", path="ResearchSubject.status", description="candidate | enrolled | active | suspended | withdrawn | completed", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ResearchSubject() {
    }

    public ResearchSubject(Enumeration<ResearchSubjectStatus> status, Reference study, Reference individual) {
        this.status = status;
        this.study = study;
        this.individual = individual;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public ResearchSubject setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Enumeration<ResearchSubjectStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ResearchSubjectStatus>(new ResearchSubjectStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ResearchSubject setStatusElement(Enumeration<ResearchSubjectStatus> value) {
        this.status = value;
        return this;
    }

    public ResearchSubjectStatus getStatus() {
        return this.status == null ? null : (ResearchSubjectStatus)((Object)this.status.getValue());
    }

    public ResearchSubject setStatus(ResearchSubjectStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ResearchSubjectStatus>(new ResearchSubjectStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public ResearchSubject setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getStudy() {
        if (this.study == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.study");
            }
            if (Configuration.doAutoCreate()) {
                this.study = new Reference();
            }
        }
        return this.study;
    }

    public boolean hasStudy() {
        return this.study != null && !this.study.isEmpty();
    }

    public ResearchSubject setStudy(Reference value) {
        this.study = value;
        return this;
    }

    public ResearchStudy getStudyTarget() {
        if (this.studyTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.study");
            }
            if (Configuration.doAutoCreate()) {
                this.studyTarget = new ResearchStudy();
            }
        }
        return this.studyTarget;
    }

    public ResearchSubject setStudyTarget(ResearchStudy value) {
        this.studyTarget = value;
        return this;
    }

    public Reference getIndividual() {
        if (this.individual == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.individual");
            }
            if (Configuration.doAutoCreate()) {
                this.individual = new Reference();
            }
        }
        return this.individual;
    }

    public boolean hasIndividual() {
        return this.individual != null && !this.individual.isEmpty();
    }

    public ResearchSubject setIndividual(Reference value) {
        this.individual = value;
        return this;
    }

    public Patient getIndividualTarget() {
        if (this.individualTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.individual");
            }
            if (Configuration.doAutoCreate()) {
                this.individualTarget = new Patient();
            }
        }
        return this.individualTarget;
    }

    public ResearchSubject setIndividualTarget(Patient value) {
        this.individualTarget = value;
        return this;
    }

    public StringType getAssignedArmElement() {
        if (this.assignedArm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.assignedArm");
            }
            if (Configuration.doAutoCreate()) {
                this.assignedArm = new StringType();
            }
        }
        return this.assignedArm;
    }

    public boolean hasAssignedArmElement() {
        return this.assignedArm != null && !this.assignedArm.isEmpty();
    }

    public boolean hasAssignedArm() {
        return this.assignedArm != null && !this.assignedArm.isEmpty();
    }

    public ResearchSubject setAssignedArmElement(StringType value) {
        this.assignedArm = value;
        return this;
    }

    public String getAssignedArm() {
        return this.assignedArm == null ? null : (String)this.assignedArm.getValue();
    }

    public ResearchSubject setAssignedArm(String value) {
        if (Utilities.noString((String)value)) {
            this.assignedArm = null;
        } else {
            if (this.assignedArm == null) {
                this.assignedArm = new StringType();
            }
            this.assignedArm.setValue(value);
        }
        return this;
    }

    public StringType getActualArmElement() {
        if (this.actualArm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.actualArm");
            }
            if (Configuration.doAutoCreate()) {
                this.actualArm = new StringType();
            }
        }
        return this.actualArm;
    }

    public boolean hasActualArmElement() {
        return this.actualArm != null && !this.actualArm.isEmpty();
    }

    public boolean hasActualArm() {
        return this.actualArm != null && !this.actualArm.isEmpty();
    }

    public ResearchSubject setActualArmElement(StringType value) {
        this.actualArm = value;
        return this;
    }

    public String getActualArm() {
        return this.actualArm == null ? null : (String)this.actualArm.getValue();
    }

    public ResearchSubject setActualArm(String value) {
        if (Utilities.noString((String)value)) {
            this.actualArm = null;
        } else {
            if (this.actualArm == null) {
                this.actualArm = new StringType();
            }
            this.actualArm.setValue(value);
        }
        return this;
    }

    public Reference getConsent() {
        if (this.consent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.consent");
            }
            if (Configuration.doAutoCreate()) {
                this.consent = new Reference();
            }
        }
        return this.consent;
    }

    public boolean hasConsent() {
        return this.consent != null && !this.consent.isEmpty();
    }

    public ResearchSubject setConsent(Reference value) {
        this.consent = value;
        return this;
    }

    public Consent getConsentTarget() {
        if (this.consentTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.consent");
            }
            if (Configuration.doAutoCreate()) {
                this.consentTarget = new Consent();
            }
        }
        return this.consentTarget;
    }

    public ResearchSubject setConsentTarget(Consent value) {
        this.consentTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this research study by the sponsor or other systems.", 0, 1, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The current state of the subject.", 0, 1, this.status));
        children.add(new Property("period", "Period", "The dates the subject began and ended their participation in the study.", 0, 1, this.period));
        children.add(new Property("study", "Reference(ResearchStudy)", "Reference to the study the subject is participating in.", 0, 1, this.study));
        children.add(new Property(SP_INDIVIDUAL, "Reference(Patient)", "The record of the person or animal who is involved in the study.", 0, 1, this.individual));
        children.add(new Property("assignedArm", "string", "The name of the arm in the study the subject is expected to follow as part of this study.", 0, 1, this.assignedArm));
        children.add(new Property("actualArm", "string", "The name of the arm in the study the subject actually followed as part of this study.", 0, 1, this.actualArm));
        children.add(new Property("consent", "Reference(Consent)", "A record of the patient's informed agreement to participate in the study.", 0, 1, this.consent));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this research study by the sponsor or other systems.", 0, 1, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the subject.", 0, 1, this.status);
            }
            case -991726143: {
                return new Property("period", "Period", "The dates the subject began and ended their participation in the study.", 0, 1, this.period);
            }
            case 109776329: {
                return new Property("study", "Reference(ResearchStudy)", "Reference to the study the subject is participating in.", 0, 1, this.study);
            }
            case -46292327: {
                return new Property(SP_INDIVIDUAL, "Reference(Patient)", "The record of the person or animal who is involved in the study.", 0, 1, this.individual);
            }
            case 1741912494: {
                return new Property("assignedArm", "string", "The name of the arm in the study the subject is expected to follow as part of this study.", 0, 1, this.assignedArm);
            }
            case 528827886: {
                return new Property("actualArm", "string", "The name of the arm in the study the subject actually followed as part of this study.", 0, 1, this.actualArm);
            }
            case 951500826: {
                return new Property("consent", "Reference(Consent)", "A record of the patient's informed agreement to participate in the study.", 0, 1, this.consent);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.period;
                }
                return baseArray;
            }
            case 109776329: {
                Base[] baseArray;
                if (this.study == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.study;
                }
                return baseArray;
            }
            case -46292327: {
                Base[] baseArray;
                if (this.individual == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.individual;
                }
                return baseArray;
            }
            case 1741912494: {
                Base[] baseArray;
                if (this.assignedArm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.assignedArm;
                }
                return baseArray;
            }
            case 528827886: {
                Base[] baseArray;
                if (this.actualArm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.actualArm;
                }
                return baseArray;
            }
            case 951500826: {
                Base[] baseArray;
                if (this.consent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.consent;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new ResearchSubjectStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                return value;
            }
            case 109776329: {
                this.study = this.castToReference(value);
                return value;
            }
            case -46292327: {
                this.individual = this.castToReference(value);
                return value;
            }
            case 1741912494: {
                this.assignedArm = this.castToString(value);
                return value;
            }
            case 528827886: {
                this.actualArm = this.castToString(value);
                return value;
            }
            case 951500826: {
                this.consent = this.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            value = new ResearchSubjectStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("study")) {
            this.study = this.castToReference(value);
        } else if (name.equals(SP_INDIVIDUAL)) {
            this.individual = this.castToReference(value);
        } else if (name.equals("assignedArm")) {
            this.assignedArm = this.castToString(value);
        } else if (name.equals("actualArm")) {
            this.actualArm = this.castToString(value);
        } else if (name.equals("consent")) {
            this.consent = this.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 109776329: {
                return this.getStudy();
            }
            case -46292327: {
                return this.getIndividual();
            }
            case 1741912494: {
                return this.getAssignedArmElement();
            }
            case 528827886: {
                return this.getActualArmElement();
            }
            case 951500826: {
                return this.getConsent();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 109776329: {
                return new String[]{"Reference"};
            }
            case -46292327: {
                return new String[]{"Reference"};
            }
            case 1741912494: {
                return new String[]{"string"};
            }
            case 528827886: {
                return new String[]{"string"};
            }
            case 951500826: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchSubject.status");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("study")) {
            this.study = new Reference();
            return this.study;
        }
        if (name.equals(SP_INDIVIDUAL)) {
            this.individual = new Reference();
            return this.individual;
        }
        if (name.equals("assignedArm")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchSubject.assignedArm");
        }
        if (name.equals("actualArm")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchSubject.actualArm");
        }
        if (name.equals("consent")) {
            this.consent = new Reference();
            return this.consent;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ResearchSubject";
    }

    @Override
    public ResearchSubject copy() {
        ResearchSubject dst = new ResearchSubject();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.study = this.study == null ? null : this.study.copy();
        dst.individual = this.individual == null ? null : this.individual.copy();
        dst.assignedArm = this.assignedArm == null ? null : this.assignedArm.copy();
        dst.actualArm = this.actualArm == null ? null : this.actualArm.copy();
        dst.consent = this.consent == null ? null : this.consent.copy();
        return dst;
    }

    protected ResearchSubject typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ResearchSubject)) {
            return false;
        }
        ResearchSubject o = (ResearchSubject)other_;
        return ResearchSubject.compareDeep(this.identifier, o.identifier, true) && ResearchSubject.compareDeep(this.status, o.status, true) && ResearchSubject.compareDeep(this.period, o.period, true) && ResearchSubject.compareDeep(this.study, o.study, true) && ResearchSubject.compareDeep(this.individual, o.individual, true) && ResearchSubject.compareDeep(this.assignedArm, o.assignedArm, true) && ResearchSubject.compareDeep(this.actualArm, o.actualArm, true) && ResearchSubject.compareDeep(this.consent, o.consent, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ResearchSubject)) {
            return false;
        }
        ResearchSubject o = (ResearchSubject)other_;
        return ResearchSubject.compareValues(this.status, o.status, true) && ResearchSubject.compareValues(this.assignedArm, o.assignedArm, true) && ResearchSubject.compareValues(this.actualArm, o.actualArm, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.identifier, this.status, this.period, this.study, this.individual, this.assignedArm, this.actualArm, this.consent});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ResearchSubject;
    }

    public static class ResearchSubjectStatusEnumFactory
    implements EnumFactory<ResearchSubjectStatus> {
        @Override
        public ResearchSubjectStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("candidate".equals(codeString)) {
                return ResearchSubjectStatus.CANDIDATE;
            }
            if ("enrolled".equals(codeString)) {
                return ResearchSubjectStatus.ENROLLED;
            }
            if ("active".equals(codeString)) {
                return ResearchSubjectStatus.ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return ResearchSubjectStatus.SUSPENDED;
            }
            if ("withdrawn".equals(codeString)) {
                return ResearchSubjectStatus.WITHDRAWN;
            }
            if ("completed".equals(codeString)) {
                return ResearchSubjectStatus.COMPLETED;
            }
            throw new IllegalArgumentException("Unknown ResearchSubjectStatus code '" + codeString + "'");
        }

        public Enumeration<ResearchSubjectStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ResearchSubjectStatus>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("candidate".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.CANDIDATE);
            }
            if ("enrolled".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.ENROLLED);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.ACTIVE);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.SUSPENDED);
            }
            if ("withdrawn".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.WITHDRAWN);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.COMPLETED);
            }
            throw new FHIRException("Unknown ResearchSubjectStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ResearchSubjectStatus code) {
            if (code == ResearchSubjectStatus.CANDIDATE) {
                return "candidate";
            }
            if (code == ResearchSubjectStatus.ENROLLED) {
                return "enrolled";
            }
            if (code == ResearchSubjectStatus.ACTIVE) {
                return "active";
            }
            if (code == ResearchSubjectStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == ResearchSubjectStatus.WITHDRAWN) {
                return "withdrawn";
            }
            if (code == ResearchSubjectStatus.COMPLETED) {
                return "completed";
            }
            return "?";
        }

        @Override
        public String toSystem(ResearchSubjectStatus code) {
            return code.getSystem();
        }
    }

    public static enum ResearchSubjectStatus {
        CANDIDATE,
        ENROLLED,
        ACTIVE,
        SUSPENDED,
        WITHDRAWN,
        COMPLETED,
        NULL;


        public static ResearchSubjectStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("candidate".equals(codeString)) {
                return CANDIDATE;
            }
            if ("enrolled".equals(codeString)) {
                return ENROLLED;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("withdrawn".equals(codeString)) {
                return WITHDRAWN;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ResearchSubjectStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CANDIDATE: {
                    return "candidate";
                }
                case ENROLLED: {
                    return "enrolled";
                }
                case ACTIVE: {
                    return "active";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case WITHDRAWN: {
                    return "withdrawn";
                }
                case COMPLETED: {
                    return "completed";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CANDIDATE: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case ENROLLED: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case WITHDRAWN: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CANDIDATE: {
                    return "The subject has been identified as a potential participant in the study but has not yet agreed to participate";
                }
                case ENROLLED: {
                    return "The subject has agreed to participate in the study but has not yet begun performing any action within the study";
                }
                case ACTIVE: {
                    return "The subject is currently being monitored and/or subject to treatment as part of the study";
                }
                case SUSPENDED: {
                    return "The subject has temporarily discontinued monitoring/treatment as part of the study";
                }
                case WITHDRAWN: {
                    return "The subject has permanently ended participation in the study prior to completion of the intended monitoring/treatment";
                }
                case COMPLETED: {
                    return "All intended monitoring/treatment of the subject has been completed and their engagement with the study is now ended";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CANDIDATE: {
                    return "Candidate";
                }
                case ENROLLED: {
                    return "Enrolled";
                }
                case ACTIVE: {
                    return "Active";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case WITHDRAWN: {
                    return "Withdrawn";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

