/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.EndpointConnectionType;

public class EndpointConnectionTypeEnumFactory
implements EnumFactory<EndpointConnectionType> {
    @Override
    public EndpointConnectionType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ihe-xcpd".equals(codeString)) {
            return EndpointConnectionType.IHEXCPD;
        }
        if ("ihe-xca".equals(codeString)) {
            return EndpointConnectionType.IHEXCA;
        }
        if ("ihe-xdr".equals(codeString)) {
            return EndpointConnectionType.IHEXDR;
        }
        if ("ihe-xds".equals(codeString)) {
            return EndpointConnectionType.IHEXDS;
        }
        if ("ihe-iid".equals(codeString)) {
            return EndpointConnectionType.IHEIID;
        }
        if ("dicom-wado-rs".equals(codeString)) {
            return EndpointConnectionType.DICOMWADORS;
        }
        if ("dicom-qido-rs".equals(codeString)) {
            return EndpointConnectionType.DICOMQIDORS;
        }
        if ("dicom-stow-rs".equals(codeString)) {
            return EndpointConnectionType.DICOMSTOWRS;
        }
        if ("dicom-wado-uri".equals(codeString)) {
            return EndpointConnectionType.DICOMWADOURI;
        }
        if ("hl7-fhir-rest".equals(codeString)) {
            return EndpointConnectionType.HL7FHIRREST;
        }
        if ("hl7-fhir-msg".equals(codeString)) {
            return EndpointConnectionType.HL7FHIRMSG;
        }
        if ("hl7v2-mllp".equals(codeString)) {
            return EndpointConnectionType.HL7V2MLLP;
        }
        if ("secure-email".equals(codeString)) {
            return EndpointConnectionType.SECUREEMAIL;
        }
        if ("direct-project".equals(codeString)) {
            return EndpointConnectionType.DIRECTPROJECT;
        }
        throw new IllegalArgumentException("Unknown EndpointConnectionType code '" + codeString + "'");
    }

    @Override
    public String toCode(EndpointConnectionType code) {
        if (code == EndpointConnectionType.IHEXCPD) {
            return "ihe-xcpd";
        }
        if (code == EndpointConnectionType.IHEXCA) {
            return "ihe-xca";
        }
        if (code == EndpointConnectionType.IHEXDR) {
            return "ihe-xdr";
        }
        if (code == EndpointConnectionType.IHEXDS) {
            return "ihe-xds";
        }
        if (code == EndpointConnectionType.IHEIID) {
            return "ihe-iid";
        }
        if (code == EndpointConnectionType.DICOMWADORS) {
            return "dicom-wado-rs";
        }
        if (code == EndpointConnectionType.DICOMQIDORS) {
            return "dicom-qido-rs";
        }
        if (code == EndpointConnectionType.DICOMSTOWRS) {
            return "dicom-stow-rs";
        }
        if (code == EndpointConnectionType.DICOMWADOURI) {
            return "dicom-wado-uri";
        }
        if (code == EndpointConnectionType.HL7FHIRREST) {
            return "hl7-fhir-rest";
        }
        if (code == EndpointConnectionType.HL7FHIRMSG) {
            return "hl7-fhir-msg";
        }
        if (code == EndpointConnectionType.HL7V2MLLP) {
            return "hl7v2-mllp";
        }
        if (code == EndpointConnectionType.SECUREEMAIL) {
            return "secure-email";
        }
        if (code == EndpointConnectionType.DIRECTPROJECT) {
            return "direct-project";
        }
        return "?";
    }

    @Override
    public String toSystem(EndpointConnectionType code) {
        return code.getSystem();
    }
}

