/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.Endpoint;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.OidType;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Procedure;
import org.hl7.fhir.dstu3.model.ProcedureRequest;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ReferralRequest;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.UnsignedIntType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImagingStudy", profile="http://hl7.org/fhir/Profile/ImagingStudy")
public class ImagingStudy
extends DomainResource {
    @Child(name="uid", type={OidType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Formal DICOM identifier for the study", formalDefinition="Formal identifier for the study.")
    protected OidType uid;
    @Child(name="accession", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Related workflow identifier (\"Accession Number\")", formalDefinition="Accession Number is an identifier related to some aspect of imaging workflow and data management. Usage may vary across different institutions.  See for instance [IHE Radiology Technical Framework Volume 1 Appendix A](http://www.ihe.net/uploadedFiles/Documents/Radiology/IHE_RAD_TF_Rev13.0_Vol1_FT_2014-07-30.pdf).")
    protected Identifier accession;
    @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Other identifiers for the study", formalDefinition="Other identifiers for the study.")
    protected List<Identifier> identifier;
    @Child(name="availability", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="ONLINE | OFFLINE | NEARLINE | UNAVAILABLE", formalDefinition="Availability of study (online, offline, or nearline).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/instance-availability")
    protected Enumeration<InstanceAvailability> availability;
    @Child(name="modalityList", type={Coding.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="All series modality if actual acquisition modalities", formalDefinition="A list of all the Series.ImageModality values that are actual acquisition modalities, i.e. those in the DICOM Context Group 29 (value set OID 1.2.840.10008.6.1.19).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/dicom-cid29")
    protected List<Coding> modalityList;
    @Child(name="patient", type={Patient.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the images are of", formalDefinition="The patient imaged in the study.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Originating context", formalDefinition="The encounter or episode at which the request is initiated.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="started", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the study was started", formalDefinition="Date and time the study started.")
    protected DateTimeType started;
    @Child(name="basedOn", type={ReferralRequest.class, CarePlan.class, ProcedureRequest.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Request fulfilled", formalDefinition="A list of the diagnostic requests that resulted in this imaging study being performed.")
    protected List<Reference> basedOn;
    protected List<Resource> basedOnTarget;
    @Child(name="referrer", type={Practitioner.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Referring physician", formalDefinition="The requesting/referring physician.")
    protected Reference referrer;
    protected Practitioner referrerTarget;
    @Child(name="interpreter", type={Practitioner.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who interpreted images", formalDefinition="Who read the study and interpreted the images or other content.")
    protected List<Reference> interpreter;
    protected List<Practitioner> interpreterTarget;
    @Child(name="endpoint", type={Endpoint.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Study access endpoint", formalDefinition="The network service providing access (e.g., query, view, or retrieval) for the study. See implementation notes for information about using DICOM endpoints. A study-level endpoint applies to each series in the study, unless overridden by a series-level endpoint with the same Endpoint.type.")
    protected List<Reference> endpoint;
    protected List<Endpoint> endpointTarget;
    @Child(name="numberOfSeries", type={UnsignedIntType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of Study Related Series", formalDefinition="Number of Series in the Study. This value given may be larger than the number of series elements this Resource contains due to resource availability, security, or other factors. This element should be present if any series elements are present.")
    protected UnsignedIntType numberOfSeries;
    @Child(name="numberOfInstances", type={UnsignedIntType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of Study Related Instances", formalDefinition="Number of SOP Instances in Study. This value given may be larger than the number of instance elements this resource contains due to resource availability, security, or other factors. This element should be present if any instance elements are present.")
    protected UnsignedIntType numberOfInstances;
    @Child(name="procedureReference", type={Procedure.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The performed Procedure reference", formalDefinition="A reference to the performed Procedure.")
    protected List<Reference> procedureReference;
    protected List<Procedure> procedureReferenceTarget;
    @Child(name="procedureCode", type={CodeableConcept.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The performed procedure code", formalDefinition="The code for the performed procedure type.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-code")
    protected List<CodeableConcept> procedureCode;
    @Child(name="reason", type={CodeableConcept.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Why the study was requested", formalDefinition="Description of clinical condition indicating why the ImagingStudy was requested.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-reason")
    protected CodeableConcept reason;
    @Child(name="description", type={StringType.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Institution-generated description", formalDefinition="Institution-generated description or classification of the Study performed.")
    protected StringType description;
    @Child(name="series", type={}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Each study has one or more series of instances", formalDefinition="Each study has one or more series of images or other content.")
    protected List<ImagingStudySeriesComponent> series;
    private static final long serialVersionUID = -1987354693L;
    @SearchParamDefinition(name="identifier", path="ImagingStudy.identifier", description="Other identifiers for the Study", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="reason", path="ImagingStudy.reason", description="The reason for the study", type="token")
    public static final String SP_REASON = "reason";
    public static final TokenClientParam REASON = new TokenClientParam("reason");
    @SearchParamDefinition(name="study", path="ImagingStudy.uid", description="The study identifier for the image", type="uri")
    public static final String SP_STUDY = "study";
    public static final UriClientParam STUDY = new UriClientParam("study");
    @SearchParamDefinition(name="dicom-class", path="ImagingStudy.series.instance.sopClass", description="The type of the instance", type="uri")
    public static final String SP_DICOM_CLASS = "dicom-class";
    public static final UriClientParam DICOM_CLASS = new UriClientParam("dicom-class");
    @SearchParamDefinition(name="modality", path="ImagingStudy.series.modality", description="The modality of the series", type="token")
    public static final String SP_MODALITY = "modality";
    public static final TokenClientParam MODALITY = new TokenClientParam("modality");
    @SearchParamDefinition(name="bodysite", path="ImagingStudy.series.bodySite", description="The body site studied", type="token")
    public static final String SP_BODYSITE = "bodysite";
    public static final TokenClientParam BODYSITE = new TokenClientParam("bodysite");
    @SearchParamDefinition(name="performer", path="ImagingStudy.series.performer", description="The person who performed the study", type="reference", target={Practitioner.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("ImagingStudy:performer").toLocked();
    @SearchParamDefinition(name="started", path="ImagingStudy.started", description="When the study was started", type="date")
    public static final String SP_STARTED = "started";
    public static final DateClientParam STARTED = new DateClientParam("started");
    @SearchParamDefinition(name="accession", path="ImagingStudy.accession", description="The accession identifier for the study", type="token")
    public static final String SP_ACCESSION = "accession";
    public static final TokenClientParam ACCESSION = new TokenClientParam("accession");
    @SearchParamDefinition(name="uid", path="ImagingStudy.series.instance.uid", description="The instance unique identifier", type="uri")
    public static final String SP_UID = "uid";
    public static final UriClientParam UID = new UriClientParam("uid");
    @SearchParamDefinition(name="endpoint", path="ImagingStudy.endpoint | ImagingStudy.series.endpoint", description="The endpoint for te study or series", type="reference", target={Endpoint.class})
    public static final String SP_ENDPOINT = "endpoint";
    public static final ReferenceClientParam ENDPOINT = new ReferenceClientParam("endpoint");
    public static final Include INCLUDE_ENDPOINT = new Include("ImagingStudy:endpoint").toLocked();
    @SearchParamDefinition(name="patient", path="ImagingStudy.patient", description="Who the study is about", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ImagingStudy:patient").toLocked();
    @SearchParamDefinition(name="series", path="ImagingStudy.series.uid", description="The identifier of the series of images", type="uri")
    public static final String SP_SERIES = "series";
    public static final UriClientParam SERIES = new UriClientParam("series");
    @SearchParamDefinition(name="context", path="ImagingStudy.context", description="The context of the study", type="reference", target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("ImagingStudy:context").toLocked();
    @SearchParamDefinition(name="basedon", path="ImagingStudy.basedOn", description="The order for the image", type="reference", target={CarePlan.class, ProcedureRequest.class, ReferralRequest.class})
    public static final String SP_BASEDON = "basedon";
    public static final ReferenceClientParam BASEDON = new ReferenceClientParam("basedon");
    public static final Include INCLUDE_BASEDON = new Include("ImagingStudy:basedon").toLocked();

    public ImagingStudy() {
    }

    public ImagingStudy(OidType uid, Reference patient) {
        this.uid = uid;
        this.patient = patient;
    }

    public OidType getUidElement() {
        if (this.uid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.uid");
            }
            if (Configuration.doAutoCreate()) {
                this.uid = new OidType();
            }
        }
        return this.uid;
    }

    public boolean hasUidElement() {
        return this.uid != null && !this.uid.isEmpty();
    }

    public boolean hasUid() {
        return this.uid != null && !this.uid.isEmpty();
    }

    public ImagingStudy setUidElement(OidType value) {
        this.uid = value;
        return this;
    }

    public String getUid() {
        return this.uid == null ? null : (String)this.uid.getValue();
    }

    public ImagingStudy setUid(String value) {
        if (this.uid == null) {
            this.uid = new OidType();
        }
        this.uid.setValue(value);
        return this;
    }

    public Identifier getAccession() {
        if (this.accession == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.accession");
            }
            if (Configuration.doAutoCreate()) {
                this.accession = new Identifier();
            }
        }
        return this.accession;
    }

    public boolean hasAccession() {
        return this.accession != null && !this.accession.isEmpty();
    }

    public ImagingStudy setAccession(Identifier value) {
        this.accession = value;
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ImagingStudy setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ImagingStudy addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<InstanceAvailability> getAvailabilityElement() {
        if (this.availability == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.availability");
            }
            if (Configuration.doAutoCreate()) {
                this.availability = new Enumeration<InstanceAvailability>(new InstanceAvailabilityEnumFactory());
            }
        }
        return this.availability;
    }

    public boolean hasAvailabilityElement() {
        return this.availability != null && !this.availability.isEmpty();
    }

    public boolean hasAvailability() {
        return this.availability != null && !this.availability.isEmpty();
    }

    public ImagingStudy setAvailabilityElement(Enumeration<InstanceAvailability> value) {
        this.availability = value;
        return this;
    }

    public InstanceAvailability getAvailability() {
        return this.availability == null ? null : (InstanceAvailability)((Object)this.availability.getValue());
    }

    public ImagingStudy setAvailability(InstanceAvailability value) {
        if (value == null) {
            this.availability = null;
        } else {
            if (this.availability == null) {
                this.availability = new Enumeration<InstanceAvailability>(new InstanceAvailabilityEnumFactory());
            }
            this.availability.setValue((Object)value);
        }
        return this;
    }

    public List<Coding> getModalityList() {
        if (this.modalityList == null) {
            this.modalityList = new ArrayList<Coding>();
        }
        return this.modalityList;
    }

    public ImagingStudy setModalityList(List<Coding> theModalityList) {
        this.modalityList = theModalityList;
        return this;
    }

    public boolean hasModalityList() {
        if (this.modalityList == null) {
            return false;
        }
        for (Coding item : this.modalityList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addModalityList() {
        Coding t = new Coding();
        if (this.modalityList == null) {
            this.modalityList = new ArrayList<Coding>();
        }
        this.modalityList.add(t);
        return t;
    }

    public ImagingStudy addModalityList(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.modalityList == null) {
            this.modalityList = new ArrayList<Coding>();
        }
        this.modalityList.add(t);
        return this;
    }

    public Coding getModalityListFirstRep() {
        if (this.getModalityList().isEmpty()) {
            this.addModalityList();
        }
        return this.getModalityList().get(0);
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ImagingStudy setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public ImagingStudy setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public ImagingStudy setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public ImagingStudy setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public DateTimeType getStartedElement() {
        if (this.started == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.started");
            }
            if (Configuration.doAutoCreate()) {
                this.started = new DateTimeType();
            }
        }
        return this.started;
    }

    public boolean hasStartedElement() {
        return this.started != null && !this.started.isEmpty();
    }

    public boolean hasStarted() {
        return this.started != null && !this.started.isEmpty();
    }

    public ImagingStudy setStartedElement(DateTimeType value) {
        this.started = value;
        return this;
    }

    public Date getStarted() {
        return this.started == null ? null : (Date)this.started.getValue();
    }

    public ImagingStudy setStarted(Date value) {
        if (value == null) {
            this.started = null;
        } else {
            if (this.started == null) {
                this.started = new DateTimeType();
            }
            this.started.setValue(value);
        }
        return this;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public ImagingStudy setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public ImagingStudy addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    @Deprecated
    public List<Resource> getBasedOnTarget() {
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<Resource>();
        }
        return this.basedOnTarget;
    }

    public Reference getReferrer() {
        if (this.referrer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.referrer");
            }
            if (Configuration.doAutoCreate()) {
                this.referrer = new Reference();
            }
        }
        return this.referrer;
    }

    public boolean hasReferrer() {
        return this.referrer != null && !this.referrer.isEmpty();
    }

    public ImagingStudy setReferrer(Reference value) {
        this.referrer = value;
        return this;
    }

    public Practitioner getReferrerTarget() {
        if (this.referrerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.referrer");
            }
            if (Configuration.doAutoCreate()) {
                this.referrerTarget = new Practitioner();
            }
        }
        return this.referrerTarget;
    }

    public ImagingStudy setReferrerTarget(Practitioner value) {
        this.referrerTarget = value;
        return this;
    }

    public List<Reference> getInterpreter() {
        if (this.interpreter == null) {
            this.interpreter = new ArrayList<Reference>();
        }
        return this.interpreter;
    }

    public ImagingStudy setInterpreter(List<Reference> theInterpreter) {
        this.interpreter = theInterpreter;
        return this;
    }

    public boolean hasInterpreter() {
        if (this.interpreter == null) {
            return false;
        }
        for (Reference item : this.interpreter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addInterpreter() {
        Reference t = new Reference();
        if (this.interpreter == null) {
            this.interpreter = new ArrayList<Reference>();
        }
        this.interpreter.add(t);
        return t;
    }

    public ImagingStudy addInterpreter(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.interpreter == null) {
            this.interpreter = new ArrayList<Reference>();
        }
        this.interpreter.add(t);
        return this;
    }

    public Reference getInterpreterFirstRep() {
        if (this.getInterpreter().isEmpty()) {
            this.addInterpreter();
        }
        return this.getInterpreter().get(0);
    }

    @Deprecated
    public List<Practitioner> getInterpreterTarget() {
        if (this.interpreterTarget == null) {
            this.interpreterTarget = new ArrayList<Practitioner>();
        }
        return this.interpreterTarget;
    }

    @Deprecated
    public Practitioner addInterpreterTarget() {
        Practitioner r = new Practitioner();
        if (this.interpreterTarget == null) {
            this.interpreterTarget = new ArrayList<Practitioner>();
        }
        this.interpreterTarget.add(r);
        return r;
    }

    public List<Reference> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        return this.endpoint;
    }

    public ImagingStudy setEndpoint(List<Reference> theEndpoint) {
        this.endpoint = theEndpoint;
        return this;
    }

    public boolean hasEndpoint() {
        if (this.endpoint == null) {
            return false;
        }
        for (Reference item : this.endpoint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEndpoint() {
        Reference t = new Reference();
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return t;
    }

    public ImagingStudy addEndpoint(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return this;
    }

    public Reference getEndpointFirstRep() {
        if (this.getEndpoint().isEmpty()) {
            this.addEndpoint();
        }
        return this.getEndpoint().get(0);
    }

    @Deprecated
    public List<Endpoint> getEndpointTarget() {
        if (this.endpointTarget == null) {
            this.endpointTarget = new ArrayList<Endpoint>();
        }
        return this.endpointTarget;
    }

    @Deprecated
    public Endpoint addEndpointTarget() {
        Endpoint r = new Endpoint();
        if (this.endpointTarget == null) {
            this.endpointTarget = new ArrayList<Endpoint>();
        }
        this.endpointTarget.add(r);
        return r;
    }

    public UnsignedIntType getNumberOfSeriesElement() {
        if (this.numberOfSeries == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.numberOfSeries");
            }
            if (Configuration.doAutoCreate()) {
                this.numberOfSeries = new UnsignedIntType();
            }
        }
        return this.numberOfSeries;
    }

    public boolean hasNumberOfSeriesElement() {
        return this.numberOfSeries != null && !this.numberOfSeries.isEmpty();
    }

    public boolean hasNumberOfSeries() {
        return this.numberOfSeries != null && !this.numberOfSeries.isEmpty();
    }

    public ImagingStudy setNumberOfSeriesElement(UnsignedIntType value) {
        this.numberOfSeries = value;
        return this;
    }

    public int getNumberOfSeries() {
        return this.numberOfSeries == null || this.numberOfSeries.isEmpty() ? 0 : (Integer)this.numberOfSeries.getValue();
    }

    public ImagingStudy setNumberOfSeries(int value) {
        if (this.numberOfSeries == null) {
            this.numberOfSeries = new UnsignedIntType();
        }
        this.numberOfSeries.setValue((Object)value);
        return this;
    }

    public UnsignedIntType getNumberOfInstancesElement() {
        if (this.numberOfInstances == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.numberOfInstances");
            }
            if (Configuration.doAutoCreate()) {
                this.numberOfInstances = new UnsignedIntType();
            }
        }
        return this.numberOfInstances;
    }

    public boolean hasNumberOfInstancesElement() {
        return this.numberOfInstances != null && !this.numberOfInstances.isEmpty();
    }

    public boolean hasNumberOfInstances() {
        return this.numberOfInstances != null && !this.numberOfInstances.isEmpty();
    }

    public ImagingStudy setNumberOfInstancesElement(UnsignedIntType value) {
        this.numberOfInstances = value;
        return this;
    }

    public int getNumberOfInstances() {
        return this.numberOfInstances == null || this.numberOfInstances.isEmpty() ? 0 : (Integer)this.numberOfInstances.getValue();
    }

    public ImagingStudy setNumberOfInstances(int value) {
        if (this.numberOfInstances == null) {
            this.numberOfInstances = new UnsignedIntType();
        }
        this.numberOfInstances.setValue((Object)value);
        return this;
    }

    public List<Reference> getProcedureReference() {
        if (this.procedureReference == null) {
            this.procedureReference = new ArrayList<Reference>();
        }
        return this.procedureReference;
    }

    public ImagingStudy setProcedureReference(List<Reference> theProcedureReference) {
        this.procedureReference = theProcedureReference;
        return this;
    }

    public boolean hasProcedureReference() {
        if (this.procedureReference == null) {
            return false;
        }
        for (Reference item : this.procedureReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addProcedureReference() {
        Reference t = new Reference();
        if (this.procedureReference == null) {
            this.procedureReference = new ArrayList<Reference>();
        }
        this.procedureReference.add(t);
        return t;
    }

    public ImagingStudy addProcedureReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.procedureReference == null) {
            this.procedureReference = new ArrayList<Reference>();
        }
        this.procedureReference.add(t);
        return this;
    }

    public Reference getProcedureReferenceFirstRep() {
        if (this.getProcedureReference().isEmpty()) {
            this.addProcedureReference();
        }
        return this.getProcedureReference().get(0);
    }

    @Deprecated
    public List<Procedure> getProcedureReferenceTarget() {
        if (this.procedureReferenceTarget == null) {
            this.procedureReferenceTarget = new ArrayList<Procedure>();
        }
        return this.procedureReferenceTarget;
    }

    @Deprecated
    public Procedure addProcedureReferenceTarget() {
        Procedure r = new Procedure();
        if (this.procedureReferenceTarget == null) {
            this.procedureReferenceTarget = new ArrayList<Procedure>();
        }
        this.procedureReferenceTarget.add(r);
        return r;
    }

    public List<CodeableConcept> getProcedureCode() {
        if (this.procedureCode == null) {
            this.procedureCode = new ArrayList<CodeableConcept>();
        }
        return this.procedureCode;
    }

    public ImagingStudy setProcedureCode(List<CodeableConcept> theProcedureCode) {
        this.procedureCode = theProcedureCode;
        return this;
    }

    public boolean hasProcedureCode() {
        if (this.procedureCode == null) {
            return false;
        }
        for (CodeableConcept item : this.procedureCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addProcedureCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.procedureCode == null) {
            this.procedureCode = new ArrayList<CodeableConcept>();
        }
        this.procedureCode.add(t);
        return t;
    }

    public ImagingStudy addProcedureCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.procedureCode == null) {
            this.procedureCode = new ArrayList<CodeableConcept>();
        }
        this.procedureCode.add(t);
        return this;
    }

    public CodeableConcept getProcedureCodeFirstRep() {
        if (this.getProcedureCode().isEmpty()) {
            this.addProcedureCode();
        }
        return this.getProcedureCode().get(0);
    }

    public CodeableConcept getReason() {
        if (this.reason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.reason");
            }
            if (Configuration.doAutoCreate()) {
                this.reason = new CodeableConcept();
            }
        }
        return this.reason;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public ImagingStudy setReason(CodeableConcept value) {
        this.reason = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ImagingStudy setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ImagingStudy setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<ImagingStudySeriesComponent> getSeries() {
        if (this.series == null) {
            this.series = new ArrayList<ImagingStudySeriesComponent>();
        }
        return this.series;
    }

    public ImagingStudy setSeries(List<ImagingStudySeriesComponent> theSeries) {
        this.series = theSeries;
        return this;
    }

    public boolean hasSeries() {
        if (this.series == null) {
            return false;
        }
        for (ImagingStudySeriesComponent item : this.series) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImagingStudySeriesComponent addSeries() {
        ImagingStudySeriesComponent t = new ImagingStudySeriesComponent();
        if (this.series == null) {
            this.series = new ArrayList<ImagingStudySeriesComponent>();
        }
        this.series.add(t);
        return t;
    }

    public ImagingStudy addSeries(ImagingStudySeriesComponent t) {
        if (t == null) {
            return this;
        }
        if (this.series == null) {
            this.series = new ArrayList<ImagingStudySeriesComponent>();
        }
        this.series.add(t);
        return this;
    }

    public ImagingStudySeriesComponent getSeriesFirstRep() {
        if (this.getSeries().isEmpty()) {
            this.addSeries();
        }
        return this.getSeries().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_UID, "oid", "Formal identifier for the study.", 0, 1, this.uid));
        children.add(new Property(SP_ACCESSION, "Identifier", "Accession Number is an identifier related to some aspect of imaging workflow and data management. Usage may vary across different institutions.  See for instance [IHE Radiology Technical Framework Volume 1 Appendix A](http://www.ihe.net/uploadedFiles/Documents/Radiology/IHE_RAD_TF_Rev13.0_Vol1_FT_2014-07-30.pdf).", 0, 1, this.accession));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Other identifiers for the study.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("availability", "code", "Availability of study (online, offline, or nearline).", 0, 1, this.availability));
        children.add(new Property("modalityList", "Coding", "A list of all the Series.ImageModality values that are actual acquisition modalities, i.e. those in the DICOM Context Group 29 (value set OID 1.2.840.10008.6.1.19).", 0, Integer.MAX_VALUE, this.modalityList));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient imaged in the study.", 0, 1, this.patient));
        children.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The encounter or episode at which the request is initiated.", 0, 1, this.context));
        children.add(new Property(SP_STARTED, "dateTime", "Date and time the study started.", 0, 1, this.started));
        children.add(new Property("basedOn", "Reference(ReferralRequest|CarePlan|ProcedureRequest)", "A list of the diagnostic requests that resulted in this imaging study being performed.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("referrer", "Reference(Practitioner)", "The requesting/referring physician.", 0, 1, this.referrer));
        children.add(new Property("interpreter", "Reference(Practitioner)", "Who read the study and interpreted the images or other content.", 0, Integer.MAX_VALUE, this.interpreter));
        children.add(new Property(SP_ENDPOINT, "Reference(Endpoint)", "The network service providing access (e.g., query, view, or retrieval) for the study. See implementation notes for information about using DICOM endpoints. A study-level endpoint applies to each series in the study, unless overridden by a series-level endpoint with the same Endpoint.type.", 0, Integer.MAX_VALUE, this.endpoint));
        children.add(new Property("numberOfSeries", "unsignedInt", "Number of Series in the Study. This value given may be larger than the number of series elements this Resource contains due to resource availability, security, or other factors. This element should be present if any series elements are present.", 0, 1, this.numberOfSeries));
        children.add(new Property("numberOfInstances", "unsignedInt", "Number of SOP Instances in Study. This value given may be larger than the number of instance elements this resource contains due to resource availability, security, or other factors. This element should be present if any instance elements are present.", 0, 1, this.numberOfInstances));
        children.add(new Property("procedureReference", "Reference(Procedure)", "A reference to the performed Procedure.", 0, Integer.MAX_VALUE, this.procedureReference));
        children.add(new Property("procedureCode", "CodeableConcept", "The code for the performed procedure type.", 0, Integer.MAX_VALUE, this.procedureCode));
        children.add(new Property(SP_REASON, "CodeableConcept", "Description of clinical condition indicating why the ImagingStudy was requested.", 0, 1, this.reason));
        children.add(new Property("description", "string", "Institution-generated description or classification of the Study performed.", 0, 1, this.description));
        children.add(new Property(SP_SERIES, "", "Each study has one or more series of images or other content.", 0, Integer.MAX_VALUE, this.series));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 115792: {
                return new Property(SP_UID, "oid", "Formal identifier for the study.", 0, 1, this.uid);
            }
            case -2115028956: {
                return new Property(SP_ACCESSION, "Identifier", "Accession Number is an identifier related to some aspect of imaging workflow and data management. Usage may vary across different institutions.  See for instance [IHE Radiology Technical Framework Volume 1 Appendix A](http://www.ihe.net/uploadedFiles/Documents/Radiology/IHE_RAD_TF_Rev13.0_Vol1_FT_2014-07-30.pdf).", 0, 1, this.accession);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Other identifiers for the study.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 1997542747: {
                return new Property("availability", "code", "Availability of study (online, offline, or nearline).", 0, 1, this.availability);
            }
            case -1030238433: {
                return new Property("modalityList", "Coding", "A list of all the Series.ImageModality values that are actual acquisition modalities, i.e. those in the DICOM Context Group 29 (value set OID 1.2.840.10008.6.1.19).", 0, Integer.MAX_VALUE, this.modalityList);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The patient imaged in the study.", 0, 1, this.patient);
            }
            case 951530927: {
                return new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The encounter or episode at which the request is initiated.", 0, 1, this.context);
            }
            case -1897185151: {
                return new Property(SP_STARTED, "dateTime", "Date and time the study started.", 0, 1, this.started);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(ReferralRequest|CarePlan|ProcedureRequest)", "A list of the diagnostic requests that resulted in this imaging study being performed.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -722568161: {
                return new Property("referrer", "Reference(Practitioner)", "The requesting/referring physician.", 0, 1, this.referrer);
            }
            case -2008009094: {
                return new Property("interpreter", "Reference(Practitioner)", "Who read the study and interpreted the images or other content.", 0, Integer.MAX_VALUE, this.interpreter);
            }
            case 1741102485: {
                return new Property(SP_ENDPOINT, "Reference(Endpoint)", "The network service providing access (e.g., query, view, or retrieval) for the study. See implementation notes for information about using DICOM endpoints. A study-level endpoint applies to each series in the study, unless overridden by a series-level endpoint with the same Endpoint.type.", 0, Integer.MAX_VALUE, this.endpoint);
            }
            case 1920000407: {
                return new Property("numberOfSeries", "unsignedInt", "Number of Series in the Study. This value given may be larger than the number of series elements this Resource contains due to resource availability, security, or other factors. This element should be present if any series elements are present.", 0, 1, this.numberOfSeries);
            }
            case -1043544226: {
                return new Property("numberOfInstances", "unsignedInt", "Number of SOP Instances in Study. This value given may be larger than the number of instance elements this resource contains due to resource availability, security, or other factors. This element should be present if any instance elements are present.", 0, 1, this.numberOfInstances);
            }
            case 881809848: {
                return new Property("procedureReference", "Reference(Procedure)", "A reference to the performed Procedure.", 0, Integer.MAX_VALUE, this.procedureReference);
            }
            case -698023072: {
                return new Property("procedureCode", "CodeableConcept", "The code for the performed procedure type.", 0, Integer.MAX_VALUE, this.procedureCode);
            }
            case -934964668: {
                return new Property(SP_REASON, "CodeableConcept", "Description of clinical condition indicating why the ImagingStudy was requested.", 0, 1, this.reason);
            }
            case -1724546052: {
                return new Property("description", "string", "Institution-generated description or classification of the Study performed.", 0, 1, this.description);
            }
            case -905838985: {
                return new Property(SP_SERIES, "", "Each study has one or more series of images or other content.", 0, Integer.MAX_VALUE, this.series);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 115792: {
                Base[] baseArray;
                if (this.uid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.uid;
                }
                return baseArray;
            }
            case -2115028956: {
                Base[] baseArray;
                if (this.accession == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.accession;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 1997542747: {
                Base[] baseArray;
                if (this.availability == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.availability;
                }
                return baseArray;
            }
            case -1030238433: {
                return this.modalityList == null ? new Base[]{} : this.modalityList.toArray(new Base[this.modalityList.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.patient;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.context;
                }
                return baseArray;
            }
            case -1897185151: {
                Base[] baseArray;
                if (this.started == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.started;
                }
                return baseArray;
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -722568161: {
                Base[] baseArray;
                if (this.referrer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.referrer;
                }
                return baseArray;
            }
            case -2008009094: {
                return this.interpreter == null ? new Base[]{} : this.interpreter.toArray(new Base[this.interpreter.size()]);
            }
            case 1741102485: {
                return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
            }
            case 1920000407: {
                Base[] baseArray;
                if (this.numberOfSeries == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.numberOfSeries;
                }
                return baseArray;
            }
            case -1043544226: {
                Base[] baseArray;
                if (this.numberOfInstances == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.numberOfInstances;
                }
                return baseArray;
            }
            case 881809848: {
                return this.procedureReference == null ? new Base[]{} : this.procedureReference.toArray(new Base[this.procedureReference.size()]);
            }
            case -698023072: {
                return this.procedureCode == null ? new Base[]{} : this.procedureCode.toArray(new Base[this.procedureCode.size()]);
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.reason;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.description;
                }
                return baseArray;
            }
            case -905838985: {
                return this.series == null ? new Base[]{} : this.series.toArray(new Base[this.series.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 115792: {
                this.uid = this.castToOid(value);
                return value;
            }
            case -2115028956: {
                this.accession = this.castToIdentifier(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 1997542747: {
                value = new InstanceAvailabilityEnumFactory().fromType(this.castToCode(value));
                this.availability = value;
                return value;
            }
            case -1030238433: {
                this.getModalityList().add(this.castToCoding(value));
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case -1897185151: {
                this.started = this.castToDateTime(value);
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                return value;
            }
            case -722568161: {
                this.referrer = this.castToReference(value);
                return value;
            }
            case -2008009094: {
                this.getInterpreter().add(this.castToReference(value));
                return value;
            }
            case 1741102485: {
                this.getEndpoint().add(this.castToReference(value));
                return value;
            }
            case 1920000407: {
                this.numberOfSeries = this.castToUnsignedInt(value);
                return value;
            }
            case -1043544226: {
                this.numberOfInstances = this.castToUnsignedInt(value);
                return value;
            }
            case 881809848: {
                this.getProcedureReference().add(this.castToReference(value));
                return value;
            }
            case -698023072: {
                this.getProcedureCode().add(this.castToCodeableConcept(value));
                return value;
            }
            case -934964668: {
                this.reason = this.castToCodeableConcept(value);
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case -905838985: {
                this.getSeries().add((ImagingStudySeriesComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_UID)) {
            this.uid = this.castToOid(value);
        } else if (name.equals(SP_ACCESSION)) {
            this.accession = this.castToIdentifier(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("availability")) {
            value = new InstanceAvailabilityEnumFactory().fromType(this.castToCode(value));
            this.availability = value;
        } else if (name.equals("modalityList")) {
            this.getModalityList().add(this.castToCoding(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals(SP_STARTED)) {
            this.started = this.castToDateTime(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals("referrer")) {
            this.referrer = this.castToReference(value);
        } else if (name.equals("interpreter")) {
            this.getInterpreter().add(this.castToReference(value));
        } else if (name.equals(SP_ENDPOINT)) {
            this.getEndpoint().add(this.castToReference(value));
        } else if (name.equals("numberOfSeries")) {
            this.numberOfSeries = this.castToUnsignedInt(value);
        } else if (name.equals("numberOfInstances")) {
            this.numberOfInstances = this.castToUnsignedInt(value);
        } else if (name.equals("procedureReference")) {
            this.getProcedureReference().add(this.castToReference(value));
        } else if (name.equals("procedureCode")) {
            this.getProcedureCode().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_REASON)) {
            this.reason = this.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals(SP_SERIES)) {
            this.getSeries().add((ImagingStudySeriesComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 115792: {
                return this.getUidElement();
            }
            case -2115028956: {
                return this.getAccession();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 1997542747: {
                return this.getAvailabilityElement();
            }
            case -1030238433: {
                return this.addModalityList();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 951530927: {
                return this.getContext();
            }
            case -1897185151: {
                return this.getStartedElement();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -722568161: {
                return this.getReferrer();
            }
            case -2008009094: {
                return this.addInterpreter();
            }
            case 1741102485: {
                return this.addEndpoint();
            }
            case 1920000407: {
                return this.getNumberOfSeriesElement();
            }
            case -1043544226: {
                return this.getNumberOfInstancesElement();
            }
            case 881809848: {
                return this.addProcedureReference();
            }
            case -698023072: {
                return this.addProcedureCode();
            }
            case -934964668: {
                return this.getReason();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -905838985: {
                return this.addSeries();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 115792: {
                return new String[]{"oid"};
            }
            case -2115028956: {
                return new String[]{"Identifier"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 1997542747: {
                return new String[]{"code"};
            }
            case -1030238433: {
                return new String[]{"Coding"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case -1897185151: {
                return new String[]{"dateTime"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -722568161: {
                return new String[]{"Reference"};
            }
            case -2008009094: {
                return new String[]{"Reference"};
            }
            case 1741102485: {
                return new String[]{"Reference"};
            }
            case 1920000407: {
                return new String[]{"unsignedInt"};
            }
            case -1043544226: {
                return new String[]{"unsignedInt"};
            }
            case 881809848: {
                return new String[]{"Reference"};
            }
            case -698023072: {
                return new String[]{"CodeableConcept"};
            }
            case -934964668: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case -905838985: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_UID)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.uid");
        }
        if (name.equals(SP_ACCESSION)) {
            this.accession = new Identifier();
            return this.accession;
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("availability")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.availability");
        }
        if (name.equals("modalityList")) {
            return this.addModalityList();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals(SP_STARTED)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.started");
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("referrer")) {
            this.referrer = new Reference();
            return this.referrer;
        }
        if (name.equals("interpreter")) {
            return this.addInterpreter();
        }
        if (name.equals(SP_ENDPOINT)) {
            return this.addEndpoint();
        }
        if (name.equals("numberOfSeries")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.numberOfSeries");
        }
        if (name.equals("numberOfInstances")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.numberOfInstances");
        }
        if (name.equals("procedureReference")) {
            return this.addProcedureReference();
        }
        if (name.equals("procedureCode")) {
            return this.addProcedureCode();
        }
        if (name.equals(SP_REASON)) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.description");
        }
        if (name.equals(SP_SERIES)) {
            return this.addSeries();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImagingStudy";
    }

    @Override
    public ImagingStudy copy() {
        ImagingStudy dst = new ImagingStudy();
        this.copyValues(dst);
        dst.uid = this.uid == null ? null : this.uid.copy();
        Identifier identifier = dst.accession = this.accession == null ? null : this.accession.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier2 : this.identifier) {
                dst.identifier.add(identifier2.copy());
            }
        }
        Enumeration<InstanceAvailability> enumeration = dst.availability = this.availability == null ? null : this.availability.copy();
        if (this.modalityList != null) {
            dst.modalityList = new ArrayList<Coding>();
            for (Coding coding : this.modalityList) {
                dst.modalityList.add(coding.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.context = this.context == null ? null : this.context.copy();
        DateTimeType dateTimeType = dst.started = this.started == null ? null : this.started.copy();
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        Reference reference = dst.referrer = this.referrer == null ? null : this.referrer.copy();
        if (this.interpreter != null) {
            dst.interpreter = new ArrayList<Reference>();
            for (Reference reference2 : this.interpreter) {
                dst.interpreter.add(reference2.copy());
            }
        }
        if (this.endpoint != null) {
            dst.endpoint = new ArrayList<Reference>();
            for (Reference reference3 : this.endpoint) {
                dst.endpoint.add(reference3.copy());
            }
        }
        dst.numberOfSeries = this.numberOfSeries == null ? null : this.numberOfSeries.copy();
        UnsignedIntType unsignedIntType = dst.numberOfInstances = this.numberOfInstances == null ? null : this.numberOfInstances.copy();
        if (this.procedureReference != null) {
            dst.procedureReference = new ArrayList<Reference>();
            for (Reference reference4 : this.procedureReference) {
                dst.procedureReference.add(reference4.copy());
            }
        }
        if (this.procedureCode != null) {
            dst.procedureCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.procedureCode) {
                dst.procedureCode.add(codeableConcept.copy());
            }
        }
        dst.reason = this.reason == null ? null : this.reason.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.series != null) {
            dst.series = new ArrayList<ImagingStudySeriesComponent>();
            for (ImagingStudySeriesComponent imagingStudySeriesComponent : this.series) {
                dst.series.add(imagingStudySeriesComponent.copy());
            }
        }
        return dst;
    }

    protected ImagingStudy typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ImagingStudy)) {
            return false;
        }
        ImagingStudy o = (ImagingStudy)other_;
        return ImagingStudy.compareDeep(this.uid, o.uid, true) && ImagingStudy.compareDeep(this.accession, o.accession, true) && ImagingStudy.compareDeep(this.identifier, o.identifier, true) && ImagingStudy.compareDeep(this.availability, o.availability, true) && ImagingStudy.compareDeep(this.modalityList, o.modalityList, true) && ImagingStudy.compareDeep(this.patient, o.patient, true) && ImagingStudy.compareDeep(this.context, o.context, true) && ImagingStudy.compareDeep(this.started, o.started, true) && ImagingStudy.compareDeep(this.basedOn, o.basedOn, true) && ImagingStudy.compareDeep(this.referrer, o.referrer, true) && ImagingStudy.compareDeep(this.interpreter, o.interpreter, true) && ImagingStudy.compareDeep(this.endpoint, o.endpoint, true) && ImagingStudy.compareDeep(this.numberOfSeries, o.numberOfSeries, true) && ImagingStudy.compareDeep(this.numberOfInstances, o.numberOfInstances, true) && ImagingStudy.compareDeep(this.procedureReference, o.procedureReference, true) && ImagingStudy.compareDeep(this.procedureCode, o.procedureCode, true) && ImagingStudy.compareDeep(this.reason, o.reason, true) && ImagingStudy.compareDeep(this.description, o.description, true) && ImagingStudy.compareDeep(this.series, o.series, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ImagingStudy)) {
            return false;
        }
        ImagingStudy o = (ImagingStudy)other_;
        return ImagingStudy.compareValues(this.uid, o.uid, true) && ImagingStudy.compareValues(this.availability, o.availability, true) && ImagingStudy.compareValues(this.started, o.started, true) && ImagingStudy.compareValues(this.numberOfSeries, o.numberOfSeries, true) && ImagingStudy.compareValues(this.numberOfInstances, o.numberOfInstances, true) && ImagingStudy.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.uid, this.accession, this.identifier, this.availability, this.modalityList, this.patient, this.context, this.started, this.basedOn, this.referrer, this.interpreter, this.endpoint, this.numberOfSeries, this.numberOfInstances, this.procedureReference, this.procedureCode, this.reason, this.description, this.series});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImagingStudy;
    }

    @Block
    public static class ImagingStudySeriesInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uid", type={OidType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Formal DICOM identifier for this instance", formalDefinition="Formal identifier for this image or other content.")
        protected OidType uid;
        @Child(name="number", type={UnsignedIntType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The number of this instance in the series", formalDefinition="The number of instance in the series.")
        protected UnsignedIntType number;
        @Child(name="sopClass", type={OidType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="DICOM class type", formalDefinition="DICOM instance  type.")
        protected OidType sopClass;
        @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of instance", formalDefinition="The description of the instance.")
        protected StringType title;
        private static final long serialVersionUID = -771526344L;

        public ImagingStudySeriesInstanceComponent() {
        }

        public ImagingStudySeriesInstanceComponent(OidType uid, OidType sopClass) {
            this.uid = uid;
            this.sopClass = sopClass;
        }

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesInstanceComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public ImagingStudySeriesInstanceComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public ImagingStudySeriesInstanceComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(value);
            return this;
        }

        public UnsignedIntType getNumberElement() {
            if (this.number == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesInstanceComponent.number");
                }
                if (Configuration.doAutoCreate()) {
                    this.number = new UnsignedIntType();
                }
            }
            return this.number;
        }

        public boolean hasNumberElement() {
            return this.number != null && !this.number.isEmpty();
        }

        public boolean hasNumber() {
            return this.number != null && !this.number.isEmpty();
        }

        public ImagingStudySeriesInstanceComponent setNumberElement(UnsignedIntType value) {
            this.number = value;
            return this;
        }

        public int getNumber() {
            return this.number == null || this.number.isEmpty() ? 0 : (Integer)this.number.getValue();
        }

        public ImagingStudySeriesInstanceComponent setNumber(int value) {
            if (this.number == null) {
                this.number = new UnsignedIntType();
            }
            this.number.setValue((Object)value);
            return this;
        }

        public OidType getSopClassElement() {
            if (this.sopClass == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesInstanceComponent.sopClass");
                }
                if (Configuration.doAutoCreate()) {
                    this.sopClass = new OidType();
                }
            }
            return this.sopClass;
        }

        public boolean hasSopClassElement() {
            return this.sopClass != null && !this.sopClass.isEmpty();
        }

        public boolean hasSopClass() {
            return this.sopClass != null && !this.sopClass.isEmpty();
        }

        public ImagingStudySeriesInstanceComponent setSopClassElement(OidType value) {
            this.sopClass = value;
            return this;
        }

        public String getSopClass() {
            return this.sopClass == null ? null : (String)this.sopClass.getValue();
        }

        public ImagingStudySeriesInstanceComponent setSopClass(String value) {
            if (this.sopClass == null) {
                this.sopClass = new OidType();
            }
            this.sopClass.setValue(value);
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesInstanceComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ImagingStudySeriesInstanceComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ImagingStudySeriesInstanceComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ImagingStudy.SP_UID, "oid", "Formal identifier for this image or other content.", 0, 1, this.uid));
            children.add(new Property("number", "unsignedInt", "The number of instance in the series.", 0, 1, this.number));
            children.add(new Property("sopClass", "oid", "DICOM instance  type.", 0, 1, this.sopClass));
            children.add(new Property("title", "string", "The description of the instance.", 0, 1, this.title));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 115792: {
                    return new Property(ImagingStudy.SP_UID, "oid", "Formal identifier for this image or other content.", 0, 1, this.uid);
                }
                case -1034364087: {
                    return new Property("number", "unsignedInt", "The number of instance in the series.", 0, 1, this.number);
                }
                case 1560041540: {
                    return new Property("sopClass", "oid", "DICOM instance  type.", 0, 1, this.sopClass);
                }
                case 110371416: {
                    return new Property("title", "string", "The description of the instance.", 0, 1, this.title);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uid;
                    }
                    return baseArray;
                }
                case -1034364087: {
                    Base[] baseArray;
                    if (this.number == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.number;
                    }
                    return baseArray;
                }
                case 1560041540: {
                    Base[] baseArray;
                    if (this.sopClass == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.sopClass;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.title;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 115792: {
                    this.uid = this.castToOid(value);
                    return value;
                }
                case -1034364087: {
                    this.number = this.castToUnsignedInt(value);
                    return value;
                }
                case 1560041540: {
                    this.sopClass = this.castToOid(value);
                    return value;
                }
                case 110371416: {
                    this.title = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ImagingStudy.SP_UID)) {
                this.uid = this.castToOid(value);
            } else if (name.equals("number")) {
                this.number = this.castToUnsignedInt(value);
            } else if (name.equals("sopClass")) {
                this.sopClass = this.castToOid(value);
            } else if (name.equals("title")) {
                this.title = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    return this.getUidElement();
                }
                case -1034364087: {
                    return this.getNumberElement();
                }
                case 1560041540: {
                    return this.getSopClassElement();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    return new String[]{"oid"};
                }
                case -1034364087: {
                    return new String[]{"unsignedInt"};
                }
                case 1560041540: {
                    return new String[]{"oid"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ImagingStudy.SP_UID)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.uid");
            }
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.number");
            }
            if (name.equals("sopClass")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.sopClass");
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.title");
            }
            return super.addChild(name);
        }

        @Override
        public ImagingStudySeriesInstanceComponent copy() {
            ImagingStudySeriesInstanceComponent dst = new ImagingStudySeriesInstanceComponent();
            this.copyValues(dst);
            dst.uid = this.uid == null ? null : this.uid.copy();
            dst.number = this.number == null ? null : this.number.copy();
            dst.sopClass = this.sopClass == null ? null : this.sopClass.copy();
            dst.title = this.title == null ? null : this.title.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingStudySeriesInstanceComponent)) {
                return false;
            }
            ImagingStudySeriesInstanceComponent o = (ImagingStudySeriesInstanceComponent)other_;
            return ImagingStudySeriesInstanceComponent.compareDeep(this.uid, o.uid, true) && ImagingStudySeriesInstanceComponent.compareDeep(this.number, o.number, true) && ImagingStudySeriesInstanceComponent.compareDeep(this.sopClass, o.sopClass, true) && ImagingStudySeriesInstanceComponent.compareDeep(this.title, o.title, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingStudySeriesInstanceComponent)) {
                return false;
            }
            ImagingStudySeriesInstanceComponent o = (ImagingStudySeriesInstanceComponent)other_;
            return ImagingStudySeriesInstanceComponent.compareValues(this.uid, o.uid, true) && ImagingStudySeriesInstanceComponent.compareValues(this.number, o.number, true) && ImagingStudySeriesInstanceComponent.compareValues(this.sopClass, o.sopClass, true) && ImagingStudySeriesInstanceComponent.compareValues(this.title, o.title, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.uid, this.number, this.sopClass, this.title});
        }

        @Override
        public String fhirType() {
            return "ImagingStudy.series.instance";
        }
    }

    @Block
    public static class ImagingStudySeriesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uid", type={OidType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Formal DICOM identifier for this series", formalDefinition="Formal identifier for this series.")
        protected OidType uid;
        @Child(name="number", type={UnsignedIntType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Numeric identifier of this series", formalDefinition="The numeric identifier of this series in the study.")
        protected UnsignedIntType number;
        @Child(name="modality", type={Coding.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The modality of the instances in the series", formalDefinition="The modality of this series sequence.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/dicom-cid29")
        protected Coding modality;
        @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A short human readable summary of the series", formalDefinition="A description of the series.")
        protected StringType description;
        @Child(name="numberOfInstances", type={UnsignedIntType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Number of Series Related Instances", formalDefinition="Number of SOP Instances in the Study. The value given may be larger than the number of instance elements this resource contains due to resource availability, security, or other factors. This element should be present if any instance elements are present.")
        protected UnsignedIntType numberOfInstances;
        @Child(name="availability", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="ONLINE | OFFLINE | NEARLINE | UNAVAILABLE", formalDefinition="Availability of series (online, offline or nearline).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/instance-availability")
        protected Enumeration<InstanceAvailability> availability;
        @Child(name="endpoint", type={Endpoint.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Series access endpoint", formalDefinition="The network service providing access (e.g., query, view, or retrieval) for this series. See implementation notes for information about using DICOM endpoints. A series-level endpoint, if present, has precedence over a study-level endpoint with the same Endpoint.type.")
        protected List<Reference> endpoint;
        protected List<Endpoint> endpointTarget;
        @Child(name="bodySite", type={Coding.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Body part examined", formalDefinition="The anatomic structures examined. See DICOM Part 16 Annex L (http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_L.html) for DICOM to SNOMED-CT mappings. The bodySite may indicate the laterality of body part imaged; if so, it shall be consistent with any content of ImagingStudy.series.laterality.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
        protected Coding bodySite;
        @Child(name="laterality", type={Coding.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Body part laterality", formalDefinition="The laterality of the (possibly paired) anatomic structures examined. E.g., the left knee, both lungs, or unpaired abdomen. If present, shall be consistent with any laterality information indicated in ImagingStudy.series.bodySite.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/bodysite-laterality")
        protected Coding laterality;
        @Child(name="started", type={DateTimeType.class}, order=10, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When the series started", formalDefinition="The date and time the series was started.")
        protected DateTimeType started;
        @Child(name="performer", type={Practitioner.class}, order=11, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Who performed the series", formalDefinition="The physician or operator (often the radiology technician)  who performed the series. The performer is recorded at the series level, since each series in a study may be performed by a different practitioner, at different times, and using different devices. A series may be performed by multiple practitioners.")
        protected List<Reference> performer;
        protected List<Practitioner> performerTarget;
        @Child(name="instance", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A single SOP instance from the series", formalDefinition="A single SOP instance within the series, e.g. an image, or presentation state.")
        protected List<ImagingStudySeriesInstanceComponent> instance;
        private static final long serialVersionUID = -1469376087L;

        public ImagingStudySeriesComponent() {
        }

        public ImagingStudySeriesComponent(OidType uid, Coding modality) {
            this.uid = uid;
            this.modality = modality;
        }

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public ImagingStudySeriesComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public ImagingStudySeriesComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(value);
            return this;
        }

        public UnsignedIntType getNumberElement() {
            if (this.number == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.number");
                }
                if (Configuration.doAutoCreate()) {
                    this.number = new UnsignedIntType();
                }
            }
            return this.number;
        }

        public boolean hasNumberElement() {
            return this.number != null && !this.number.isEmpty();
        }

        public boolean hasNumber() {
            return this.number != null && !this.number.isEmpty();
        }

        public ImagingStudySeriesComponent setNumberElement(UnsignedIntType value) {
            this.number = value;
            return this;
        }

        public int getNumber() {
            return this.number == null || this.number.isEmpty() ? 0 : (Integer)this.number.getValue();
        }

        public ImagingStudySeriesComponent setNumber(int value) {
            if (this.number == null) {
                this.number = new UnsignedIntType();
            }
            this.number.setValue((Object)value);
            return this;
        }

        public Coding getModality() {
            if (this.modality == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.modality");
                }
                if (Configuration.doAutoCreate()) {
                    this.modality = new Coding();
                }
            }
            return this.modality;
        }

        public boolean hasModality() {
            return this.modality != null && !this.modality.isEmpty();
        }

        public ImagingStudySeriesComponent setModality(Coding value) {
            this.modality = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ImagingStudySeriesComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ImagingStudySeriesComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public UnsignedIntType getNumberOfInstancesElement() {
            if (this.numberOfInstances == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.numberOfInstances");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfInstances = new UnsignedIntType();
                }
            }
            return this.numberOfInstances;
        }

        public boolean hasNumberOfInstancesElement() {
            return this.numberOfInstances != null && !this.numberOfInstances.isEmpty();
        }

        public boolean hasNumberOfInstances() {
            return this.numberOfInstances != null && !this.numberOfInstances.isEmpty();
        }

        public ImagingStudySeriesComponent setNumberOfInstancesElement(UnsignedIntType value) {
            this.numberOfInstances = value;
            return this;
        }

        public int getNumberOfInstances() {
            return this.numberOfInstances == null || this.numberOfInstances.isEmpty() ? 0 : (Integer)this.numberOfInstances.getValue();
        }

        public ImagingStudySeriesComponent setNumberOfInstances(int value) {
            if (this.numberOfInstances == null) {
                this.numberOfInstances = new UnsignedIntType();
            }
            this.numberOfInstances.setValue((Object)value);
            return this;
        }

        public Enumeration<InstanceAvailability> getAvailabilityElement() {
            if (this.availability == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.availability");
                }
                if (Configuration.doAutoCreate()) {
                    this.availability = new Enumeration<InstanceAvailability>(new InstanceAvailabilityEnumFactory());
                }
            }
            return this.availability;
        }

        public boolean hasAvailabilityElement() {
            return this.availability != null && !this.availability.isEmpty();
        }

        public boolean hasAvailability() {
            return this.availability != null && !this.availability.isEmpty();
        }

        public ImagingStudySeriesComponent setAvailabilityElement(Enumeration<InstanceAvailability> value) {
            this.availability = value;
            return this;
        }

        public InstanceAvailability getAvailability() {
            return this.availability == null ? null : (InstanceAvailability)((Object)this.availability.getValue());
        }

        public ImagingStudySeriesComponent setAvailability(InstanceAvailability value) {
            if (value == null) {
                this.availability = null;
            } else {
                if (this.availability == null) {
                    this.availability = new Enumeration<InstanceAvailability>(new InstanceAvailabilityEnumFactory());
                }
                this.availability.setValue((Object)value);
            }
            return this;
        }

        public List<Reference> getEndpoint() {
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<Reference>();
            }
            return this.endpoint;
        }

        public ImagingStudySeriesComponent setEndpoint(List<Reference> theEndpoint) {
            this.endpoint = theEndpoint;
            return this;
        }

        public boolean hasEndpoint() {
            if (this.endpoint == null) {
                return false;
            }
            for (Reference item : this.endpoint) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addEndpoint() {
            Reference t = new Reference();
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<Reference>();
            }
            this.endpoint.add(t);
            return t;
        }

        public ImagingStudySeriesComponent addEndpoint(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<Reference>();
            }
            this.endpoint.add(t);
            return this;
        }

        public Reference getEndpointFirstRep() {
            if (this.getEndpoint().isEmpty()) {
                this.addEndpoint();
            }
            return this.getEndpoint().get(0);
        }

        @Deprecated
        public List<Endpoint> getEndpointTarget() {
            if (this.endpointTarget == null) {
                this.endpointTarget = new ArrayList<Endpoint>();
            }
            return this.endpointTarget;
        }

        @Deprecated
        public Endpoint addEndpointTarget() {
            Endpoint r = new Endpoint();
            if (this.endpointTarget == null) {
                this.endpointTarget = new ArrayList<Endpoint>();
            }
            this.endpointTarget.add(r);
            return r;
        }

        public Coding getBodySite() {
            if (this.bodySite == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.bodySite");
                }
                if (Configuration.doAutoCreate()) {
                    this.bodySite = new Coding();
                }
            }
            return this.bodySite;
        }

        public boolean hasBodySite() {
            return this.bodySite != null && !this.bodySite.isEmpty();
        }

        public ImagingStudySeriesComponent setBodySite(Coding value) {
            this.bodySite = value;
            return this;
        }

        public Coding getLaterality() {
            if (this.laterality == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.laterality");
                }
                if (Configuration.doAutoCreate()) {
                    this.laterality = new Coding();
                }
            }
            return this.laterality;
        }

        public boolean hasLaterality() {
            return this.laterality != null && !this.laterality.isEmpty();
        }

        public ImagingStudySeriesComponent setLaterality(Coding value) {
            this.laterality = value;
            return this;
        }

        public DateTimeType getStartedElement() {
            if (this.started == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.started");
                }
                if (Configuration.doAutoCreate()) {
                    this.started = new DateTimeType();
                }
            }
            return this.started;
        }

        public boolean hasStartedElement() {
            return this.started != null && !this.started.isEmpty();
        }

        public boolean hasStarted() {
            return this.started != null && !this.started.isEmpty();
        }

        public ImagingStudySeriesComponent setStartedElement(DateTimeType value) {
            this.started = value;
            return this;
        }

        public Date getStarted() {
            return this.started == null ? null : (Date)this.started.getValue();
        }

        public ImagingStudySeriesComponent setStarted(Date value) {
            if (value == null) {
                this.started = null;
            } else {
                if (this.started == null) {
                    this.started = new DateTimeType();
                }
                this.started.setValue(value);
            }
            return this;
        }

        public List<Reference> getPerformer() {
            if (this.performer == null) {
                this.performer = new ArrayList<Reference>();
            }
            return this.performer;
        }

        public ImagingStudySeriesComponent setPerformer(List<Reference> thePerformer) {
            this.performer = thePerformer;
            return this;
        }

        public boolean hasPerformer() {
            if (this.performer == null) {
                return false;
            }
            for (Reference item : this.performer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addPerformer() {
            Reference t = new Reference();
            if (this.performer == null) {
                this.performer = new ArrayList<Reference>();
            }
            this.performer.add(t);
            return t;
        }

        public ImagingStudySeriesComponent addPerformer(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.performer == null) {
                this.performer = new ArrayList<Reference>();
            }
            this.performer.add(t);
            return this;
        }

        public Reference getPerformerFirstRep() {
            if (this.getPerformer().isEmpty()) {
                this.addPerformer();
            }
            return this.getPerformer().get(0);
        }

        @Deprecated
        public List<Practitioner> getPerformerTarget() {
            if (this.performerTarget == null) {
                this.performerTarget = new ArrayList<Practitioner>();
            }
            return this.performerTarget;
        }

        @Deprecated
        public Practitioner addPerformerTarget() {
            Practitioner r = new Practitioner();
            if (this.performerTarget == null) {
                this.performerTarget = new ArrayList<Practitioner>();
            }
            this.performerTarget.add(r);
            return r;
        }

        public List<ImagingStudySeriesInstanceComponent> getInstance() {
            if (this.instance == null) {
                this.instance = new ArrayList<ImagingStudySeriesInstanceComponent>();
            }
            return this.instance;
        }

        public ImagingStudySeriesComponent setInstance(List<ImagingStudySeriesInstanceComponent> theInstance) {
            this.instance = theInstance;
            return this;
        }

        public boolean hasInstance() {
            if (this.instance == null) {
                return false;
            }
            for (ImagingStudySeriesInstanceComponent item : this.instance) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImagingStudySeriesInstanceComponent addInstance() {
            ImagingStudySeriesInstanceComponent t = new ImagingStudySeriesInstanceComponent();
            if (this.instance == null) {
                this.instance = new ArrayList<ImagingStudySeriesInstanceComponent>();
            }
            this.instance.add(t);
            return t;
        }

        public ImagingStudySeriesComponent addInstance(ImagingStudySeriesInstanceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.instance == null) {
                this.instance = new ArrayList<ImagingStudySeriesInstanceComponent>();
            }
            this.instance.add(t);
            return this;
        }

        public ImagingStudySeriesInstanceComponent getInstanceFirstRep() {
            if (this.getInstance().isEmpty()) {
                this.addInstance();
            }
            return this.getInstance().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ImagingStudy.SP_UID, "oid", "Formal identifier for this series.", 0, 1, this.uid));
            children.add(new Property("number", "unsignedInt", "The numeric identifier of this series in the study.", 0, 1, this.number));
            children.add(new Property(ImagingStudy.SP_MODALITY, "Coding", "The modality of this series sequence.", 0, 1, this.modality));
            children.add(new Property("description", "string", "A description of the series.", 0, 1, this.description));
            children.add(new Property("numberOfInstances", "unsignedInt", "Number of SOP Instances in the Study. The value given may be larger than the number of instance elements this resource contains due to resource availability, security, or other factors. This element should be present if any instance elements are present.", 0, 1, this.numberOfInstances));
            children.add(new Property("availability", "code", "Availability of series (online, offline or nearline).", 0, 1, this.availability));
            children.add(new Property(ImagingStudy.SP_ENDPOINT, "Reference(Endpoint)", "The network service providing access (e.g., query, view, or retrieval) for this series. See implementation notes for information about using DICOM endpoints. A series-level endpoint, if present, has precedence over a study-level endpoint with the same Endpoint.type.", 0, Integer.MAX_VALUE, this.endpoint));
            children.add(new Property("bodySite", "Coding", "The anatomic structures examined. See DICOM Part 16 Annex L (http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_L.html) for DICOM to SNOMED-CT mappings. The bodySite may indicate the laterality of body part imaged; if so, it shall be consistent with any content of ImagingStudy.series.laterality.", 0, 1, this.bodySite));
            children.add(new Property("laterality", "Coding", "The laterality of the (possibly paired) anatomic structures examined. E.g., the left knee, both lungs, or unpaired abdomen. If present, shall be consistent with any laterality information indicated in ImagingStudy.series.bodySite.", 0, 1, this.laterality));
            children.add(new Property(ImagingStudy.SP_STARTED, "dateTime", "The date and time the series was started.", 0, 1, this.started));
            children.add(new Property(ImagingStudy.SP_PERFORMER, "Reference(Practitioner)", "The physician or operator (often the radiology technician)  who performed the series. The performer is recorded at the series level, since each series in a study may be performed by a different practitioner, at different times, and using different devices. A series may be performed by multiple practitioners.", 0, Integer.MAX_VALUE, this.performer));
            children.add(new Property("instance", "", "A single SOP instance within the series, e.g. an image, or presentation state.", 0, Integer.MAX_VALUE, this.instance));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 115792: {
                    return new Property(ImagingStudy.SP_UID, "oid", "Formal identifier for this series.", 0, 1, this.uid);
                }
                case -1034364087: {
                    return new Property("number", "unsignedInt", "The numeric identifier of this series in the study.", 0, 1, this.number);
                }
                case -622722335: {
                    return new Property(ImagingStudy.SP_MODALITY, "Coding", "The modality of this series sequence.", 0, 1, this.modality);
                }
                case -1724546052: {
                    return new Property("description", "string", "A description of the series.", 0, 1, this.description);
                }
                case -1043544226: {
                    return new Property("numberOfInstances", "unsignedInt", "Number of SOP Instances in the Study. The value given may be larger than the number of instance elements this resource contains due to resource availability, security, or other factors. This element should be present if any instance elements are present.", 0, 1, this.numberOfInstances);
                }
                case 1997542747: {
                    return new Property("availability", "code", "Availability of series (online, offline or nearline).", 0, 1, this.availability);
                }
                case 1741102485: {
                    return new Property(ImagingStudy.SP_ENDPOINT, "Reference(Endpoint)", "The network service providing access (e.g., query, view, or retrieval) for this series. See implementation notes for information about using DICOM endpoints. A series-level endpoint, if present, has precedence over a study-level endpoint with the same Endpoint.type.", 0, Integer.MAX_VALUE, this.endpoint);
                }
                case 1702620169: {
                    return new Property("bodySite", "Coding", "The anatomic structures examined. See DICOM Part 16 Annex L (http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_L.html) for DICOM to SNOMED-CT mappings. The bodySite may indicate the laterality of body part imaged; if so, it shall be consistent with any content of ImagingStudy.series.laterality.", 0, 1, this.bodySite);
                }
                case -170291817: {
                    return new Property("laterality", "Coding", "The laterality of the (possibly paired) anatomic structures examined. E.g., the left knee, both lungs, or unpaired abdomen. If present, shall be consistent with any laterality information indicated in ImagingStudy.series.bodySite.", 0, 1, this.laterality);
                }
                case -1897185151: {
                    return new Property(ImagingStudy.SP_STARTED, "dateTime", "The date and time the series was started.", 0, 1, this.started);
                }
                case 481140686: {
                    return new Property(ImagingStudy.SP_PERFORMER, "Reference(Practitioner)", "The physician or operator (often the radiology technician)  who performed the series. The performer is recorded at the series level, since each series in a study may be performed by a different practitioner, at different times, and using different devices. A series may be performed by multiple practitioners.", 0, Integer.MAX_VALUE, this.performer);
                }
                case 555127957: {
                    return new Property("instance", "", "A single SOP instance within the series, e.g. an image, or presentation state.", 0, Integer.MAX_VALUE, this.instance);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uid;
                    }
                    return baseArray;
                }
                case -1034364087: {
                    Base[] baseArray;
                    if (this.number == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.number;
                    }
                    return baseArray;
                }
                case -622722335: {
                    Base[] baseArray;
                    if (this.modality == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.modality;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case -1043544226: {
                    Base[] baseArray;
                    if (this.numberOfInstances == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.numberOfInstances;
                    }
                    return baseArray;
                }
                case 1997542747: {
                    Base[] baseArray;
                    if (this.availability == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.availability;
                    }
                    return baseArray;
                }
                case 1741102485: {
                    return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
                }
                case 1702620169: {
                    Base[] baseArray;
                    if (this.bodySite == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.bodySite;
                    }
                    return baseArray;
                }
                case -170291817: {
                    Base[] baseArray;
                    if (this.laterality == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.laterality;
                    }
                    return baseArray;
                }
                case -1897185151: {
                    Base[] baseArray;
                    if (this.started == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.started;
                    }
                    return baseArray;
                }
                case 481140686: {
                    return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
                }
                case 555127957: {
                    return this.instance == null ? new Base[]{} : this.instance.toArray(new Base[this.instance.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 115792: {
                    this.uid = this.castToOid(value);
                    return value;
                }
                case -1034364087: {
                    this.number = this.castToUnsignedInt(value);
                    return value;
                }
                case -622722335: {
                    this.modality = this.castToCoding(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -1043544226: {
                    this.numberOfInstances = this.castToUnsignedInt(value);
                    return value;
                }
                case 1997542747: {
                    value = new InstanceAvailabilityEnumFactory().fromType(this.castToCode(value));
                    this.availability = value;
                    return value;
                }
                case 1741102485: {
                    this.getEndpoint().add(this.castToReference(value));
                    return value;
                }
                case 1702620169: {
                    this.bodySite = this.castToCoding(value);
                    return value;
                }
                case -170291817: {
                    this.laterality = this.castToCoding(value);
                    return value;
                }
                case -1897185151: {
                    this.started = this.castToDateTime(value);
                    return value;
                }
                case 481140686: {
                    this.getPerformer().add(this.castToReference(value));
                    return value;
                }
                case 555127957: {
                    this.getInstance().add((ImagingStudySeriesInstanceComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ImagingStudy.SP_UID)) {
                this.uid = this.castToOid(value);
            } else if (name.equals("number")) {
                this.number = this.castToUnsignedInt(value);
            } else if (name.equals(ImagingStudy.SP_MODALITY)) {
                this.modality = this.castToCoding(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("numberOfInstances")) {
                this.numberOfInstances = this.castToUnsignedInt(value);
            } else if (name.equals("availability")) {
                value = new InstanceAvailabilityEnumFactory().fromType(this.castToCode(value));
                this.availability = value;
            } else if (name.equals(ImagingStudy.SP_ENDPOINT)) {
                this.getEndpoint().add(this.castToReference(value));
            } else if (name.equals("bodySite")) {
                this.bodySite = this.castToCoding(value);
            } else if (name.equals("laterality")) {
                this.laterality = this.castToCoding(value);
            } else if (name.equals(ImagingStudy.SP_STARTED)) {
                this.started = this.castToDateTime(value);
            } else if (name.equals(ImagingStudy.SP_PERFORMER)) {
                this.getPerformer().add(this.castToReference(value));
            } else if (name.equals("instance")) {
                this.getInstance().add((ImagingStudySeriesInstanceComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    return this.getUidElement();
                }
                case -1034364087: {
                    return this.getNumberElement();
                }
                case -622722335: {
                    return this.getModality();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1043544226: {
                    return this.getNumberOfInstancesElement();
                }
                case 1997542747: {
                    return this.getAvailabilityElement();
                }
                case 1741102485: {
                    return this.addEndpoint();
                }
                case 1702620169: {
                    return this.getBodySite();
                }
                case -170291817: {
                    return this.getLaterality();
                }
                case -1897185151: {
                    return this.getStartedElement();
                }
                case 481140686: {
                    return this.addPerformer();
                }
                case 555127957: {
                    return this.addInstance();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    return new String[]{"oid"};
                }
                case -1034364087: {
                    return new String[]{"unsignedInt"};
                }
                case -622722335: {
                    return new String[]{"Coding"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1043544226: {
                    return new String[]{"unsignedInt"};
                }
                case 1997542747: {
                    return new String[]{"code"};
                }
                case 1741102485: {
                    return new String[]{"Reference"};
                }
                case 1702620169: {
                    return new String[]{"Coding"};
                }
                case -170291817: {
                    return new String[]{"Coding"};
                }
                case -1897185151: {
                    return new String[]{"dateTime"};
                }
                case 481140686: {
                    return new String[]{"Reference"};
                }
                case 555127957: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ImagingStudy.SP_UID)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.uid");
            }
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.number");
            }
            if (name.equals(ImagingStudy.SP_MODALITY)) {
                this.modality = new Coding();
                return this.modality;
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.description");
            }
            if (name.equals("numberOfInstances")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.numberOfInstances");
            }
            if (name.equals("availability")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.availability");
            }
            if (name.equals(ImagingStudy.SP_ENDPOINT)) {
                return this.addEndpoint();
            }
            if (name.equals("bodySite")) {
                this.bodySite = new Coding();
                return this.bodySite;
            }
            if (name.equals("laterality")) {
                this.laterality = new Coding();
                return this.laterality;
            }
            if (name.equals(ImagingStudy.SP_STARTED)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.started");
            }
            if (name.equals(ImagingStudy.SP_PERFORMER)) {
                return this.addPerformer();
            }
            if (name.equals("instance")) {
                return this.addInstance();
            }
            return super.addChild(name);
        }

        @Override
        public ImagingStudySeriesComponent copy() {
            ImagingStudySeriesComponent dst = new ImagingStudySeriesComponent();
            this.copyValues(dst);
            dst.uid = this.uid == null ? null : this.uid.copy();
            dst.number = this.number == null ? null : this.number.copy();
            dst.modality = this.modality == null ? null : this.modality.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.numberOfInstances = this.numberOfInstances == null ? null : this.numberOfInstances.copy();
            Enumeration<InstanceAvailability> enumeration = dst.availability = this.availability == null ? null : this.availability.copy();
            if (this.endpoint != null) {
                dst.endpoint = new ArrayList<Reference>();
                for (Reference reference : this.endpoint) {
                    dst.endpoint.add(reference.copy());
                }
            }
            dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
            dst.laterality = this.laterality == null ? null : this.laterality.copy();
            DateTimeType dateTimeType = dst.started = this.started == null ? null : this.started.copy();
            if (this.performer != null) {
                dst.performer = new ArrayList<Reference>();
                for (Reference reference : this.performer) {
                    dst.performer.add(reference.copy());
                }
            }
            if (this.instance != null) {
                dst.instance = new ArrayList<ImagingStudySeriesInstanceComponent>();
                for (ImagingStudySeriesInstanceComponent imagingStudySeriesInstanceComponent : this.instance) {
                    dst.instance.add(imagingStudySeriesInstanceComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingStudySeriesComponent)) {
                return false;
            }
            ImagingStudySeriesComponent o = (ImagingStudySeriesComponent)other_;
            return ImagingStudySeriesComponent.compareDeep(this.uid, o.uid, true) && ImagingStudySeriesComponent.compareDeep(this.number, o.number, true) && ImagingStudySeriesComponent.compareDeep(this.modality, o.modality, true) && ImagingStudySeriesComponent.compareDeep(this.description, o.description, true) && ImagingStudySeriesComponent.compareDeep(this.numberOfInstances, o.numberOfInstances, true) && ImagingStudySeriesComponent.compareDeep(this.availability, o.availability, true) && ImagingStudySeriesComponent.compareDeep(this.endpoint, o.endpoint, true) && ImagingStudySeriesComponent.compareDeep(this.bodySite, o.bodySite, true) && ImagingStudySeriesComponent.compareDeep(this.laterality, o.laterality, true) && ImagingStudySeriesComponent.compareDeep(this.started, o.started, true) && ImagingStudySeriesComponent.compareDeep(this.performer, o.performer, true) && ImagingStudySeriesComponent.compareDeep(this.instance, o.instance, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingStudySeriesComponent)) {
                return false;
            }
            ImagingStudySeriesComponent o = (ImagingStudySeriesComponent)other_;
            return ImagingStudySeriesComponent.compareValues(this.uid, o.uid, true) && ImagingStudySeriesComponent.compareValues(this.number, o.number, true) && ImagingStudySeriesComponent.compareValues(this.description, o.description, true) && ImagingStudySeriesComponent.compareValues(this.numberOfInstances, o.numberOfInstances, true) && ImagingStudySeriesComponent.compareValues(this.availability, o.availability, true) && ImagingStudySeriesComponent.compareValues(this.started, o.started, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.uid, this.number, this.modality, this.description, this.numberOfInstances, this.availability, this.endpoint, this.bodySite, this.laterality, this.started, this.performer, this.instance});
        }

        @Override
        public String fhirType() {
            return "ImagingStudy.series";
        }
    }

    public static class InstanceAvailabilityEnumFactory
    implements EnumFactory<InstanceAvailability> {
        @Override
        public InstanceAvailability fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("ONLINE".equals(codeString)) {
                return InstanceAvailability.ONLINE;
            }
            if ("OFFLINE".equals(codeString)) {
                return InstanceAvailability.OFFLINE;
            }
            if ("NEARLINE".equals(codeString)) {
                return InstanceAvailability.NEARLINE;
            }
            if ("UNAVAILABLE".equals(codeString)) {
                return InstanceAvailability.UNAVAILABLE;
            }
            throw new IllegalArgumentException("Unknown InstanceAvailability code '" + codeString + "'");
        }

        public Enumeration<InstanceAvailability> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<InstanceAvailability>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("ONLINE".equals(codeString)) {
                return new Enumeration<InstanceAvailability>(this, InstanceAvailability.ONLINE);
            }
            if ("OFFLINE".equals(codeString)) {
                return new Enumeration<InstanceAvailability>(this, InstanceAvailability.OFFLINE);
            }
            if ("NEARLINE".equals(codeString)) {
                return new Enumeration<InstanceAvailability>(this, InstanceAvailability.NEARLINE);
            }
            if ("UNAVAILABLE".equals(codeString)) {
                return new Enumeration<InstanceAvailability>(this, InstanceAvailability.UNAVAILABLE);
            }
            throw new FHIRException("Unknown InstanceAvailability code '" + codeString + "'");
        }

        @Override
        public String toCode(InstanceAvailability code) {
            if (code == InstanceAvailability.ONLINE) {
                return "ONLINE";
            }
            if (code == InstanceAvailability.OFFLINE) {
                return "OFFLINE";
            }
            if (code == InstanceAvailability.NEARLINE) {
                return "NEARLINE";
            }
            if (code == InstanceAvailability.UNAVAILABLE) {
                return "UNAVAILABLE";
            }
            return "?";
        }

        @Override
        public String toSystem(InstanceAvailability code) {
            return code.getSystem();
        }
    }

    public static enum InstanceAvailability {
        ONLINE,
        OFFLINE,
        NEARLINE,
        UNAVAILABLE,
        NULL;


        public static InstanceAvailability fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("ONLINE".equals(codeString)) {
                return ONLINE;
            }
            if ("OFFLINE".equals(codeString)) {
                return OFFLINE;
            }
            if ("NEARLINE".equals(codeString)) {
                return NEARLINE;
            }
            if ("UNAVAILABLE".equals(codeString)) {
                return UNAVAILABLE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown InstanceAvailability code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ONLINE: {
                    return "ONLINE";
                }
                case OFFLINE: {
                    return "OFFLINE";
                }
                case NEARLINE: {
                    return "NEARLINE";
                }
                case UNAVAILABLE: {
                    return "UNAVAILABLE";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ONLINE: {
                    return "http://dicom.nema.org/resources/ontology/DCM";
                }
                case OFFLINE: {
                    return "http://dicom.nema.org/resources/ontology/DCM";
                }
                case NEARLINE: {
                    return "http://dicom.nema.org/resources/ontology/DCM";
                }
                case UNAVAILABLE: {
                    return "http://dicom.nema.org/resources/ontology/DCM";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ONLINE: {
                    return "";
                }
                case OFFLINE: {
                    return "";
                }
                case NEARLINE: {
                    return "";
                }
                case UNAVAILABLE: {
                    return "";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ONLINE: {
                    return "ONLINE";
                }
                case OFFLINE: {
                    return "OFFLINE";
                }
                case NEARLINE: {
                    return "NEARLINE";
                }
                case UNAVAILABLE: {
                    return "UNAVAILABLE";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

