/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ChargeitemStatus {
    PLANNED,
    BILLABLE,
    NOTBILLABLE,
    ABORTED,
    BILLED,
    ENTEREDINERROR,
    UNKNOWN,
    NULL;


    public static ChargeitemStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("planned".equals(codeString)) {
            return PLANNED;
        }
        if ("billable".equals(codeString)) {
            return BILLABLE;
        }
        if ("not-billable".equals(codeString)) {
            return NOTBILLABLE;
        }
        if ("aborted".equals(codeString)) {
            return ABORTED;
        }
        if ("billed".equals(codeString)) {
            return BILLED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown ChargeitemStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PLANNED: {
                return "planned";
            }
            case BILLABLE: {
                return "billable";
            }
            case NOTBILLABLE: {
                return "not-billable";
            }
            case ABORTED: {
                return "aborted";
            }
            case BILLED: {
                return "billed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case UNKNOWN: {
                return "unknown";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/chargeitem-status";
    }

    public String getDefinition() {
        switch (this) {
            case PLANNED: {
                return "The charge item has been entered, but the charged service is not  yet complete, so it shall not be billed yet but might be used in the context of pre-authorization";
            }
            case BILLABLE: {
                return "The charge item is ready for billing";
            }
            case NOTBILLABLE: {
                return "The charge item has been determined to be not billable (e.g. due to rules associated with the billing code)";
            }
            case ABORTED: {
                return "The processing of the charge was aborted";
            }
            case BILLED: {
                return "The charge item has been billed (e.g. a billing engine has generated financial transactions by applying the associated ruled for the charge item to the context of the Encounter, and placed them into Claims/Invoices";
            }
            case ENTEREDINERROR: {
                return "The charge item has been entered in error and should not be processed for billing";
            }
            case UNKNOWN: {
                return "The authoring system does not know which of the status values currently applies for this charge item  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, it's just not known which one.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PLANNED: {
                return "Planned";
            }
            case BILLABLE: {
                return "Billable";
            }
            case NOTBILLABLE: {
                return "Not billable";
            }
            case ABORTED: {
                return "Aborted";
            }
            case BILLED: {
                return "Billed";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case UNKNOWN: {
                return "Unknown";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

