/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ConsentAction;

public class ConsentActionEnumFactory
implements EnumFactory<ConsentAction> {
    @Override
    public ConsentAction fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("collect".equals(codeString)) {
            return ConsentAction.COLLECT;
        }
        if ("access".equals(codeString)) {
            return ConsentAction.ACCESS;
        }
        if ("use".equals(codeString)) {
            return ConsentAction.USE;
        }
        if ("disclose".equals(codeString)) {
            return ConsentAction.DISCLOSE;
        }
        if ("correct".equals(codeString)) {
            return ConsentAction.CORRECT;
        }
        throw new IllegalArgumentException("Unknown ConsentAction code '" + codeString + "'");
    }

    @Override
    public String toCode(ConsentAction code) {
        if (code == ConsentAction.COLLECT) {
            return "collect";
        }
        if (code == ConsentAction.ACCESS) {
            return "access";
        }
        if (code == ConsentAction.USE) {
            return "use";
        }
        if (code == ConsentAction.DISCLOSE) {
            return "disclose";
        }
        if (code == ConsentAction.CORRECT) {
            return "correct";
        }
        return "?";
    }

    @Override
    public String toSystem(ConsentAction code) {
        return code.getSystem();
    }
}

