/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DefinitionTopic {
    TREATMENT,
    EDUCATION,
    ASSESSMENT,
    NULL;


    public static DefinitionTopic fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("treatment".equals(codeString)) {
            return TREATMENT;
        }
        if ("education".equals(codeString)) {
            return EDUCATION;
        }
        if ("assessment".equals(codeString)) {
            return ASSESSMENT;
        }
        throw new FHIRException("Unknown DefinitionTopic code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case TREATMENT: {
                return "treatment";
            }
            case EDUCATION: {
                return "education";
            }
            case ASSESSMENT: {
                return "assessment";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/definition-topic";
    }

    public String getDefinition() {
        switch (this) {
            case TREATMENT: {
                return "The definition is related to treatment of the patient";
            }
            case EDUCATION: {
                return "The definition is related to education of the patient";
            }
            case ASSESSMENT: {
                return "The definition is related to assessment of the patient";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case TREATMENT: {
                return "Treatment";
            }
            case EDUCATION: {
                return "Education";
            }
            case ASSESSMENT: {
                return "Assessment";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

