/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.Contract;
import org.hl7.fhir.dstu3.model.Coverage;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EligibilityRequest;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Money;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UnsignedIntType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="EligibilityResponse", profile="http://hl7.org/fhir/Profile/EligibilityResponse")
public class EligibilityResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier", formalDefinition="The Response business identifier.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<EligibilityResponseStatus> status;
    @Child(name="created", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Creation date", formalDefinition="The date when the enclosed suite of services were performed or completed.")
    protected DateTimeType created;
    @Child(name="requestProvider", type={Practitioner.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Reference requestProvider;
    protected Practitioner requestProviderTarget;
    @Child(name="requestOrganization", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible organization", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    protected Reference requestOrganization;
    protected Organization requestOrganizationTarget;
    @Child(name="request", type={EligibilityRequest.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Eligibility reference", formalDefinition="Original request resource reference.")
    protected Reference request;
    protected EligibilityRequest requestTarget;
    @Child(name="outcome", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="complete | error | partial", formalDefinition="Transaction status: error, complete.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/remittance-outcome")
    protected CodeableConcept outcome;
    @Child(name="disposition", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Disposition Message", formalDefinition="A description of the status of the adjudication.")
    protected StringType disposition;
    @Child(name="insurer", type={Organization.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Insurer issuing the coverage", formalDefinition="The Insurer who produced this adjudicated response.")
    protected Reference insurer;
    protected Organization insurerTarget;
    @Child(name="inforce", type={BooleanType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Coverage inforce indicator", formalDefinition="Flag indicating if the coverage provided is inforce currently  if no service date(s) specified or for the whole duration of the service dates.")
    protected BooleanType inforce;
    @Child(name="insurance", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Details by insurance coverage", formalDefinition="The insurer may provide both the details for the requested coverage as well as details for additional coverages known to the insurer.")
    protected List<InsuranceComponent> insurance;
    @Child(name="form", type={CodeableConcept.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Printed Form Identifier", formalDefinition="The form to be used for printing the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/forms")
    protected CodeableConcept form;
    @Child(name="error", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Processing errors", formalDefinition="Mutually exclusive with Services Provided (Item).")
    protected List<ErrorsComponent> error;
    private static final long serialVersionUID = 954270539L;
    @SearchParamDefinition(name="identifier", path="EligibilityResponse.identifier", description="The business identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="request", path="EligibilityResponse.request", description="The EligibilityRequest reference", type="reference", target={EligibilityRequest.class})
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUEST = new Include("EligibilityResponse:request").toLocked();
    @SearchParamDefinition(name="disposition", path="EligibilityResponse.disposition", description="The contents of the disposition message", type="string")
    public static final String SP_DISPOSITION = "disposition";
    public static final StringClientParam DISPOSITION = new StringClientParam("disposition");
    @SearchParamDefinition(name="insurer", path="EligibilityResponse.insurer", description="The organization which generated this resource", type="reference", target={Organization.class})
    public static final String SP_INSURER = "insurer";
    public static final ReferenceClientParam INSURER = new ReferenceClientParam("insurer");
    public static final Include INCLUDE_INSURER = new Include("EligibilityResponse:insurer").toLocked();
    @SearchParamDefinition(name="created", path="EligibilityResponse.created", description="The creation date", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="request-organization", path="EligibilityResponse.requestOrganization", description="The EligibilityRequest organization", type="reference", target={Organization.class})
    public static final String SP_REQUEST_ORGANIZATION = "request-organization";
    public static final ReferenceClientParam REQUEST_ORGANIZATION = new ReferenceClientParam("request-organization");
    public static final Include INCLUDE_REQUEST_ORGANIZATION = new Include("EligibilityResponse:request-organization").toLocked();
    @SearchParamDefinition(name="request-provider", path="EligibilityResponse.requestProvider", description="The EligibilityRequest provider", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class})
    public static final String SP_REQUEST_PROVIDER = "request-provider";
    public static final ReferenceClientParam REQUEST_PROVIDER = new ReferenceClientParam("request-provider");
    public static final Include INCLUDE_REQUEST_PROVIDER = new Include("EligibilityResponse:request-provider").toLocked();
    @SearchParamDefinition(name="outcome", path="EligibilityResponse.outcome", description="The processing outcome", type="token")
    public static final String SP_OUTCOME = "outcome";
    public static final TokenClientParam OUTCOME = new TokenClientParam("outcome");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public EligibilityResponse setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public EligibilityResponse addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<EligibilityResponseStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<EligibilityResponseStatus>(new EligibilityResponseStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public EligibilityResponse setStatusElement(Enumeration<EligibilityResponseStatus> value) {
        this.status = value;
        return this;
    }

    public EligibilityResponseStatus getStatus() {
        return this.status == null ? null : (EligibilityResponseStatus)((Object)this.status.getValue());
    }

    public EligibilityResponse setStatus(EligibilityResponseStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<EligibilityResponseStatus>(new EligibilityResponseStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public EligibilityResponse setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public EligibilityResponse setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getRequestProvider() {
        if (this.requestProvider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.requestProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.requestProvider = new Reference();
            }
        }
        return this.requestProvider;
    }

    public boolean hasRequestProvider() {
        return this.requestProvider != null && !this.requestProvider.isEmpty();
    }

    public EligibilityResponse setRequestProvider(Reference value) {
        this.requestProvider = value;
        return this;
    }

    public Practitioner getRequestProviderTarget() {
        if (this.requestProviderTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.requestProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.requestProviderTarget = new Practitioner();
            }
        }
        return this.requestProviderTarget;
    }

    public EligibilityResponse setRequestProviderTarget(Practitioner value) {
        this.requestProviderTarget = value;
        return this;
    }

    public Reference getRequestOrganization() {
        if (this.requestOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.requestOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.requestOrganization = new Reference();
            }
        }
        return this.requestOrganization;
    }

    public boolean hasRequestOrganization() {
        return this.requestOrganization != null && !this.requestOrganization.isEmpty();
    }

    public EligibilityResponse setRequestOrganization(Reference value) {
        this.requestOrganization = value;
        return this;
    }

    public Organization getRequestOrganizationTarget() {
        if (this.requestOrganizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.requestOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.requestOrganizationTarget = new Organization();
            }
        }
        return this.requestOrganizationTarget;
    }

    public EligibilityResponse setRequestOrganizationTarget(Organization value) {
        this.requestOrganizationTarget = value;
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public EligibilityResponse setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public EligibilityRequest getRequestTarget() {
        if (this.requestTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.request");
            }
            if (Configuration.doAutoCreate()) {
                this.requestTarget = new EligibilityRequest();
            }
        }
        return this.requestTarget;
    }

    public EligibilityResponse setRequestTarget(EligibilityRequest value) {
        this.requestTarget = value;
        return this;
    }

    public CodeableConcept getOutcome() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new CodeableConcept();
            }
        }
        return this.outcome;
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public EligibilityResponse setOutcome(CodeableConcept value) {
        this.outcome = value;
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public EligibilityResponse setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public EligibilityResponse setDisposition(String value) {
        if (Utilities.noString((String)value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public Reference getInsurer() {
        if (this.insurer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurer = new Reference();
            }
        }
        return this.insurer;
    }

    public boolean hasInsurer() {
        return this.insurer != null && !this.insurer.isEmpty();
    }

    public EligibilityResponse setInsurer(Reference value) {
        this.insurer = value;
        return this;
    }

    public Organization getInsurerTarget() {
        if (this.insurerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurerTarget = new Organization();
            }
        }
        return this.insurerTarget;
    }

    public EligibilityResponse setInsurerTarget(Organization value) {
        this.insurerTarget = value;
        return this;
    }

    public BooleanType getInforceElement() {
        if (this.inforce == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.inforce");
            }
            if (Configuration.doAutoCreate()) {
                this.inforce = new BooleanType();
            }
        }
        return this.inforce;
    }

    public boolean hasInforceElement() {
        return this.inforce != null && !this.inforce.isEmpty();
    }

    public boolean hasInforce() {
        return this.inforce != null && !this.inforce.isEmpty();
    }

    public EligibilityResponse setInforceElement(BooleanType value) {
        this.inforce = value;
        return this;
    }

    public boolean getInforce() {
        return this.inforce == null || this.inforce.isEmpty() ? false : (Boolean)this.inforce.getValue();
    }

    public EligibilityResponse setInforce(boolean value) {
        if (this.inforce == null) {
            this.inforce = new BooleanType();
        }
        this.inforce.setValue((Object)value);
        return this;
    }

    public List<InsuranceComponent> getInsurance() {
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        return this.insurance;
    }

    public EligibilityResponse setInsurance(List<InsuranceComponent> theInsurance) {
        this.insurance = theInsurance;
        return this;
    }

    public boolean hasInsurance() {
        if (this.insurance == null) {
            return false;
        }
        for (InsuranceComponent item : this.insurance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InsuranceComponent addInsurance() {
        InsuranceComponent t = new InsuranceComponent();
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return t;
    }

    public EligibilityResponse addInsurance(InsuranceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return this;
    }

    public InsuranceComponent getInsuranceFirstRep() {
        if (this.getInsurance().isEmpty()) {
            this.addInsurance();
        }
        return this.getInsurance().get(0);
    }

    public CodeableConcept getForm() {
        if (this.form == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityResponse.form");
            }
            if (Configuration.doAutoCreate()) {
                this.form = new CodeableConcept();
            }
        }
        return this.form;
    }

    public boolean hasForm() {
        return this.form != null && !this.form.isEmpty();
    }

    public EligibilityResponse setForm(CodeableConcept value) {
        this.form = value;
        return this;
    }

    public List<ErrorsComponent> getError() {
        if (this.error == null) {
            this.error = new ArrayList<ErrorsComponent>();
        }
        return this.error;
    }

    public EligibilityResponse setError(List<ErrorsComponent> theError) {
        this.error = theError;
        return this;
    }

    public boolean hasError() {
        if (this.error == null) {
            return false;
        }
        for (ErrorsComponent item : this.error) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ErrorsComponent addError() {
        ErrorsComponent t = new ErrorsComponent();
        if (this.error == null) {
            this.error = new ArrayList<ErrorsComponent>();
        }
        this.error.add(t);
        return t;
    }

    public EligibilityResponse addError(ErrorsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.error == null) {
            this.error = new ArrayList<ErrorsComponent>();
        }
        this.error.add(t);
        return this;
    }

    public ErrorsComponent getErrorFirstRep() {
        if (this.getError().isEmpty()) {
            this.addError();
        }
        return this.getError().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("status", "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property(SP_CREATED, "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, 1, this.created));
        children.add(new Property("requestProvider", "Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.requestProvider));
        children.add(new Property("requestOrganization", "Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, 1, this.requestOrganization));
        children.add(new Property(SP_REQUEST, "Reference(EligibilityRequest)", "Original request resource reference.", 0, 1, this.request));
        children.add(new Property(SP_OUTCOME, "CodeableConcept", "Transaction status: error, complete.", 0, 1, this.outcome));
        children.add(new Property(SP_DISPOSITION, "string", "A description of the status of the adjudication.", 0, 1, this.disposition));
        children.add(new Property(SP_INSURER, "Reference(Organization)", "The Insurer who produced this adjudicated response.", 0, 1, this.insurer));
        children.add(new Property("inforce", "boolean", "Flag indicating if the coverage provided is inforce currently  if no service date(s) specified or for the whole duration of the service dates.", 0, 1, this.inforce));
        children.add(new Property("insurance", "", "The insurer may provide both the details for the requested coverage as well as details for additional coverages known to the insurer.", 0, Integer.MAX_VALUE, this.insurance));
        children.add(new Property("form", "CodeableConcept", "The form to be used for printing the content.", 0, 1, this.form));
        children.add(new Property("error", "", "Mutually exclusive with Services Provided (Item).", 0, Integer.MAX_VALUE, this.error));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property("status", "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 1028554472: {
                return new Property(SP_CREATED, "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, 1, this.created);
            }
            case 1601527200: {
                return new Property("requestProvider", "Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.requestProvider);
            }
            case 599053666: {
                return new Property("requestOrganization", "Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, 1, this.requestOrganization);
            }
            case 1095692943: {
                return new Property(SP_REQUEST, "Reference(EligibilityRequest)", "Original request resource reference.", 0, 1, this.request);
            }
            case -1106507950: {
                return new Property(SP_OUTCOME, "CodeableConcept", "Transaction status: error, complete.", 0, 1, this.outcome);
            }
            case 583380919: {
                return new Property(SP_DISPOSITION, "string", "A description of the status of the adjudication.", 0, 1, this.disposition);
            }
            case 1957615864: {
                return new Property(SP_INSURER, "Reference(Organization)", "The Insurer who produced this adjudicated response.", 0, 1, this.insurer);
            }
            case 1945431270: {
                return new Property("inforce", "boolean", "Flag indicating if the coverage provided is inforce currently  if no service date(s) specified or for the whole duration of the service dates.", 0, 1, this.inforce);
            }
            case 73049818: {
                return new Property("insurance", "", "The insurer may provide both the details for the requested coverage as well as details for additional coverages known to the insurer.", 0, Integer.MAX_VALUE, this.insurance);
            }
            case 3148996: {
                return new Property("form", "CodeableConcept", "The form to be used for printing the content.", 0, 1, this.form);
            }
            case 96784904: {
                return new Property("error", "", "Mutually exclusive with Services Provided (Item).", 0, Integer.MAX_VALUE, this.error);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.created;
                }
                return baseArray;
            }
            case 1601527200: {
                Base[] baseArray;
                if (this.requestProvider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.requestProvider;
                }
                return baseArray;
            }
            case 599053666: {
                Base[] baseArray;
                if (this.requestOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.requestOrganization;
                }
                return baseArray;
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.request;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.outcome;
                }
                return baseArray;
            }
            case 583380919: {
                Base[] baseArray;
                if (this.disposition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.disposition;
                }
                return baseArray;
            }
            case 1957615864: {
                Base[] baseArray;
                if (this.insurer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.insurer;
                }
                return baseArray;
            }
            case 1945431270: {
                Base[] baseArray;
                if (this.inforce == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.inforce;
                }
                return baseArray;
            }
            case 73049818: {
                return this.insurance == null ? new Base[]{} : this.insurance.toArray(new Base[this.insurance.size()]);
            }
            case 3148996: {
                Base[] baseArray;
                if (this.form == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.form;
                }
                return baseArray;
            }
            case 96784904: {
                return this.error == null ? new Base[]{} : this.error.toArray(new Base[this.error.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new EligibilityResponseStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                return value;
            }
            case 1601527200: {
                this.requestProvider = this.castToReference(value);
                return value;
            }
            case 599053666: {
                this.requestOrganization = this.castToReference(value);
                return value;
            }
            case 1095692943: {
                this.request = this.castToReference(value);
                return value;
            }
            case -1106507950: {
                this.outcome = this.castToCodeableConcept(value);
                return value;
            }
            case 583380919: {
                this.disposition = this.castToString(value);
                return value;
            }
            case 1957615864: {
                this.insurer = this.castToReference(value);
                return value;
            }
            case 1945431270: {
                this.inforce = this.castToBoolean(value);
                return value;
            }
            case 73049818: {
                this.getInsurance().add((InsuranceComponent)((Object)value));
                return value;
            }
            case 3148996: {
                this.form = this.castToCodeableConcept(value);
                return value;
            }
            case 96784904: {
                this.getError().add((ErrorsComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("status")) {
            value = new EligibilityResponseStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("requestProvider")) {
            this.requestProvider = this.castToReference(value);
        } else if (name.equals("requestOrganization")) {
            this.requestOrganization = this.castToReference(value);
        } else if (name.equals(SP_REQUEST)) {
            this.request = this.castToReference(value);
        } else if (name.equals(SP_OUTCOME)) {
            this.outcome = this.castToCodeableConcept(value);
        } else if (name.equals(SP_DISPOSITION)) {
            this.disposition = this.castToString(value);
        } else if (name.equals(SP_INSURER)) {
            this.insurer = this.castToReference(value);
        } else if (name.equals("inforce")) {
            this.inforce = this.castToBoolean(value);
        } else if (name.equals("insurance")) {
            this.getInsurance().add((InsuranceComponent)((Object)value));
        } else if (name.equals("form")) {
            this.form = this.castToCodeableConcept(value);
        } else if (name.equals("error")) {
            this.getError().add((ErrorsComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case 1601527200: {
                return this.getRequestProvider();
            }
            case 599053666: {
                return this.getRequestOrganization();
            }
            case 1095692943: {
                return this.getRequest();
            }
            case -1106507950: {
                return this.getOutcome();
            }
            case 583380919: {
                return this.getDispositionElement();
            }
            case 1957615864: {
                return this.getInsurer();
            }
            case 1945431270: {
                return this.getInforceElement();
            }
            case 73049818: {
                return this.addInsurance();
            }
            case 3148996: {
                return this.getForm();
            }
            case 96784904: {
                return this.addError();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case 1601527200: {
                return new String[]{"Reference"};
            }
            case 599053666: {
                return new String[]{"Reference"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case -1106507950: {
                return new String[]{"CodeableConcept"};
            }
            case 583380919: {
                return new String[]{"string"};
            }
            case 1957615864: {
                return new String[]{"Reference"};
            }
            case 1945431270: {
                return new String[]{"boolean"};
            }
            case 73049818: {
                return new String[0];
            }
            case 3148996: {
                return new String[]{"CodeableConcept"};
            }
            case 96784904: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a singleton property EligibilityResponse.status");
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a singleton property EligibilityResponse.created");
        }
        if (name.equals("requestProvider")) {
            this.requestProvider = new Reference();
            return this.requestProvider;
        }
        if (name.equals("requestOrganization")) {
            this.requestOrganization = new Reference();
            return this.requestOrganization;
        }
        if (name.equals(SP_REQUEST)) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals(SP_OUTCOME)) {
            this.outcome = new CodeableConcept();
            return this.outcome;
        }
        if (name.equals(SP_DISPOSITION)) {
            throw new FHIRException("Cannot call addChild on a singleton property EligibilityResponse.disposition");
        }
        if (name.equals(SP_INSURER)) {
            this.insurer = new Reference();
            return this.insurer;
        }
        if (name.equals("inforce")) {
            throw new FHIRException("Cannot call addChild on a singleton property EligibilityResponse.inforce");
        }
        if (name.equals("insurance")) {
            return this.addInsurance();
        }
        if (name.equals("form")) {
            this.form = new CodeableConcept();
            return this.form;
        }
        if (name.equals("error")) {
            return this.addError();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EligibilityResponse";
    }

    @Override
    public EligibilityResponse copy() {
        EligibilityResponse dst = new EligibilityResponse();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.requestProvider = this.requestProvider == null ? null : this.requestProvider.copy();
        dst.requestOrganization = this.requestOrganization == null ? null : this.requestOrganization.copy();
        dst.request = this.request == null ? null : this.request.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
        dst.insurer = this.insurer == null ? null : this.insurer.copy();
        BooleanType booleanType = dst.inforce = this.inforce == null ? null : this.inforce.copy();
        if (this.insurance != null) {
            dst.insurance = new ArrayList<InsuranceComponent>();
            for (InsuranceComponent insuranceComponent : this.insurance) {
                dst.insurance.add(insuranceComponent.copy());
            }
        }
        CodeableConcept codeableConcept = dst.form = this.form == null ? null : this.form.copy();
        if (this.error != null) {
            dst.error = new ArrayList<ErrorsComponent>();
            for (ErrorsComponent errorsComponent : this.error) {
                dst.error.add(errorsComponent.copy());
            }
        }
        return dst;
    }

    protected EligibilityResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EligibilityResponse)) {
            return false;
        }
        EligibilityResponse o = (EligibilityResponse)other_;
        return EligibilityResponse.compareDeep(this.identifier, o.identifier, true) && EligibilityResponse.compareDeep(this.status, o.status, true) && EligibilityResponse.compareDeep(this.created, o.created, true) && EligibilityResponse.compareDeep(this.requestProvider, o.requestProvider, true) && EligibilityResponse.compareDeep(this.requestOrganization, o.requestOrganization, true) && EligibilityResponse.compareDeep(this.request, o.request, true) && EligibilityResponse.compareDeep(this.outcome, o.outcome, true) && EligibilityResponse.compareDeep(this.disposition, o.disposition, true) && EligibilityResponse.compareDeep(this.insurer, o.insurer, true) && EligibilityResponse.compareDeep(this.inforce, o.inforce, true) && EligibilityResponse.compareDeep(this.insurance, o.insurance, true) && EligibilityResponse.compareDeep(this.form, o.form, true) && EligibilityResponse.compareDeep(this.error, o.error, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EligibilityResponse)) {
            return false;
        }
        EligibilityResponse o = (EligibilityResponse)other_;
        return EligibilityResponse.compareValues(this.status, o.status, true) && EligibilityResponse.compareValues(this.created, o.created, true) && EligibilityResponse.compareValues(this.disposition, o.disposition, true) && EligibilityResponse.compareValues(this.inforce, o.inforce, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.created, this.requestProvider, this.requestOrganization, this.request, this.outcome, this.disposition, this.insurer, this.inforce, this.insurance, this.form, this.error});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EligibilityResponse;
    }

    @Block
    public static class ErrorsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Error code detailing processing issues", formalDefinition="An error code,from a specified code system, which details why the eligibility check could not be performed.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication-error")
        protected CodeableConcept code;
        private static final long serialVersionUID = -1048343046L;

        public ErrorsComponent() {
        }

        public ErrorsComponent(CodeableConcept code) {
            this.code = code;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorsComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ErrorsComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "An error code,from a specified code system, which details why the eligibility check could not be performed.", 0, 1, this.code));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "An error code,from a specified code system, which details why the eligibility check could not be performed.", 0, 1, this.code);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("code")) {
                return super.setProperty(name, value);
            }
            this.code = this.castToCodeableConcept(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            return super.addChild(name);
        }

        @Override
        public ErrorsComponent copy() {
            ErrorsComponent dst = new ErrorsComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ErrorsComponent)) {
                return false;
            }
            ErrorsComponent o = (ErrorsComponent)other_;
            return ErrorsComponent.compareDeep(this.code, o.code, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ErrorsComponent)) {
                return false;
            }
            ErrorsComponent o = (ErrorsComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code});
        }

        @Override
        public String fhirType() {
            return "EligibilityResponse.error";
        }
    }

    @Block
    public static class BenefitComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Deductable, visits, benefit amount", formalDefinition="Deductable, visits, benefit amount.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-type")
        protected CodeableConcept type;
        @Child(name="allowed", type={UnsignedIntType.class, StringType.class, Money.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Benefits allowed", formalDefinition="Benefits allowed.")
        protected Type allowed;
        @Child(name="used", type={UnsignedIntType.class, Money.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Benefits used", formalDefinition="Benefits used.")
        protected Type used;
        private static final long serialVersionUID = -1506285314L;

        public BenefitComponent() {
        }

        public BenefitComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public BenefitComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Type getAllowed() {
            return this.allowed;
        }

        public UnsignedIntType getAllowedUnsignedIntType() throws FHIRException {
            if (this.allowed == null) {
                return null;
            }
            if (!(this.allowed instanceof UnsignedIntType)) {
                throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.allowed.getClass().getName() + " was encountered");
            }
            return (UnsignedIntType)this.allowed;
        }

        public boolean hasAllowedUnsignedIntType() {
            return this != null && this.allowed instanceof UnsignedIntType;
        }

        public StringType getAllowedStringType() throws FHIRException {
            if (this.allowed == null) {
                return null;
            }
            if (!(this.allowed instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.allowed.getClass().getName() + " was encountered");
            }
            return (StringType)this.allowed;
        }

        public boolean hasAllowedStringType() {
            return this != null && this.allowed instanceof StringType;
        }

        public Money getAllowedMoney() throws FHIRException {
            if (this.allowed == null) {
                return null;
            }
            if (!(this.allowed instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.allowed.getClass().getName() + " was encountered");
            }
            return (Money)this.allowed;
        }

        public boolean hasAllowedMoney() {
            return this != null && this.allowed instanceof Money;
        }

        public boolean hasAllowed() {
            return this.allowed != null && !this.allowed.isEmpty();
        }

        public BenefitComponent setAllowed(Type value) throws FHIRFormatError {
            if (!(value == null || value instanceof UnsignedIntType || value instanceof StringType || value instanceof Money)) {
                throw new FHIRFormatError("Not the right type for EligibilityResponse.insurance.benefitBalance.financial.allowed[x]: " + value.fhirType());
            }
            this.allowed = value;
            return this;
        }

        public Type getUsed() {
            return this.used;
        }

        public UnsignedIntType getUsedUnsignedIntType() throws FHIRException {
            if (this.used == null) {
                return null;
            }
            if (!(this.used instanceof UnsignedIntType)) {
                throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.used.getClass().getName() + " was encountered");
            }
            return (UnsignedIntType)this.used;
        }

        public boolean hasUsedUnsignedIntType() {
            return this != null && this.used instanceof UnsignedIntType;
        }

        public Money getUsedMoney() throws FHIRException {
            if (this.used == null) {
                return null;
            }
            if (!(this.used instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.used.getClass().getName() + " was encountered");
            }
            return (Money)this.used;
        }

        public boolean hasUsedMoney() {
            return this != null && this.used instanceof Money;
        }

        public boolean hasUsed() {
            return this.used != null && !this.used.isEmpty();
        }

        public BenefitComponent setUsed(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof UnsignedIntType) && !(value instanceof Money)) {
                throw new FHIRFormatError("Not the right type for EligibilityResponse.insurance.benefitBalance.financial.used[x]: " + value.fhirType());
            }
            this.used = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Deductable, visits, benefit amount.", 0, 1, this.type));
            children.add(new Property("allowed[x]", "unsignedInt|string|Money", "Benefits allowed.", 0, 1, this.allowed));
            children.add(new Property("used[x]", "unsignedInt|Money", "Benefits used.", 0, 1, this.used));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Deductable, visits, benefit amount.", 0, 1, this.type);
                }
                case -1336663592: {
                    return new Property("allowed[x]", "unsignedInt|string|Money", "Benefits allowed.", 0, 1, this.allowed);
                }
                case -911343192: {
                    return new Property("allowed[x]", "unsignedInt|string|Money", "Benefits allowed.", 0, 1, this.allowed);
                }
                case 1668802034: {
                    return new Property("allowed[x]", "unsignedInt|string|Money", "Benefits allowed.", 0, 1, this.allowed);
                }
                case -2135265319: {
                    return new Property("allowed[x]", "unsignedInt|string|Money", "Benefits allowed.", 0, 1, this.allowed);
                }
                case -351668232: {
                    return new Property("allowed[x]", "unsignedInt|string|Money", "Benefits allowed.", 0, 1, this.allowed);
                }
                case -147553373: {
                    return new Property("used[x]", "unsignedInt|Money", "Benefits used.", 0, 1, this.used);
                }
                case 3599293: {
                    return new Property("used[x]", "unsignedInt|Money", "Benefits used.", 0, 1, this.used);
                }
                case 1252740285: {
                    return new Property("used[x]", "unsignedInt|Money", "Benefits used.", 0, 1, this.used);
                }
                case -78048509: {
                    return new Property("used[x]", "unsignedInt|Money", "Benefits used.", 0, 1, this.used);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -911343192: {
                    Base[] baseArray;
                    if (this.allowed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.allowed;
                    }
                    return baseArray;
                }
                case 3599293: {
                    Base[] baseArray;
                    if (this.used == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.used;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -911343192: {
                    this.allowed = this.castToType(value);
                    return value;
                }
                case 3599293: {
                    this.used = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("allowed[x]")) {
                this.allowed = this.castToType(value);
            } else if (name.equals("used[x]")) {
                this.used = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1336663592: {
                    return this.getAllowed();
                }
                case -911343192: {
                    return this.getAllowed();
                }
                case -147553373: {
                    return this.getUsed();
                }
                case 3599293: {
                    return this.getUsed();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -911343192: {
                    return new String[]{"unsignedInt", "string", "Money"};
                }
                case 3599293: {
                    return new String[]{"unsignedInt", "Money"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("allowedUnsignedInt")) {
                this.allowed = new UnsignedIntType();
                return this.allowed;
            }
            if (name.equals("allowedString")) {
                this.allowed = new StringType();
                return this.allowed;
            }
            if (name.equals("allowedMoney")) {
                this.allowed = new Money();
                return this.allowed;
            }
            if (name.equals("usedUnsignedInt")) {
                this.used = new UnsignedIntType();
                return this.used;
            }
            if (name.equals("usedMoney")) {
                this.used = new Money();
                return this.used;
            }
            return super.addChild(name);
        }

        @Override
        public BenefitComponent copy() {
            BenefitComponent dst = new BenefitComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.allowed = this.allowed == null ? null : this.allowed.copy();
            dst.used = this.used == null ? null : this.used.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BenefitComponent)) {
                return false;
            }
            BenefitComponent o = (BenefitComponent)other_;
            return BenefitComponent.compareDeep(this.type, o.type, true) && BenefitComponent.compareDeep(this.allowed, o.allowed, true) && BenefitComponent.compareDeep(this.used, o.used, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BenefitComponent)) {
                return false;
            }
            BenefitComponent o = (BenefitComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.allowed, this.used});
        }

        @Override
        public String fhirType() {
            return "EligibilityResponse.insurance.benefitBalance.financial";
        }
    }

    @Block
    public static class BenefitsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of services covered", formalDefinition="Dental, Vision, Medical, Pharmacy, Rehab etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-category")
        protected CodeableConcept category;
        @Child(name="subCategory", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Detailed services covered within the type", formalDefinition="Dental: basic, major, ortho; Vision exam, glasses, contacts; etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-subcategory")
        protected CodeableConcept subCategory;
        @Child(name="excluded", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Excluded from the plan", formalDefinition="True if the indicated class of service is excluded from the plan, missing or False indicated the service is included in the coverage.")
        protected BooleanType excluded;
        @Child(name="name", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short name for the benefit", formalDefinition="A short name or tag for the benefit, for example MED01, or DENT2.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the benefit or services covered", formalDefinition="A richer description of the benefit, for example 'DENT2 covers 100% of basic, 50% of major but exclused Ortho, Implants and Costmetic services'.")
        protected StringType description;
        @Child(name="network", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="In or out of network", formalDefinition="Network designation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-network")
        protected CodeableConcept network;
        @Child(name="unit", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Individual or family", formalDefinition="Unit designation: individual or family.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-unit")
        protected CodeableConcept unit;
        @Child(name="term", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Annual or lifetime", formalDefinition="The term or period of the values such as 'maximum lifetime benefit' or 'maximum annual vistis'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-term")
        protected CodeableConcept term;
        @Child(name="financial", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Benefit Summary", formalDefinition="Benefits Used to date.")
        protected List<BenefitComponent> financial;
        private static final long serialVersionUID = 833826021L;

        public BenefitsComponent() {
        }

        public BenefitsComponent(CodeableConcept category) {
            this.category = category;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitsComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public BenefitsComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getSubCategory() {
            if (this.subCategory == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitsComponent.subCategory");
                }
                if (Configuration.doAutoCreate()) {
                    this.subCategory = new CodeableConcept();
                }
            }
            return this.subCategory;
        }

        public boolean hasSubCategory() {
            return this.subCategory != null && !this.subCategory.isEmpty();
        }

        public BenefitsComponent setSubCategory(CodeableConcept value) {
            this.subCategory = value;
            return this;
        }

        public BooleanType getExcludedElement() {
            if (this.excluded == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitsComponent.excluded");
                }
                if (Configuration.doAutoCreate()) {
                    this.excluded = new BooleanType();
                }
            }
            return this.excluded;
        }

        public boolean hasExcludedElement() {
            return this.excluded != null && !this.excluded.isEmpty();
        }

        public boolean hasExcluded() {
            return this.excluded != null && !this.excluded.isEmpty();
        }

        public BenefitsComponent setExcludedElement(BooleanType value) {
            this.excluded = value;
            return this;
        }

        public boolean getExcluded() {
            return this.excluded == null || this.excluded.isEmpty() ? false : (Boolean)this.excluded.getValue();
        }

        public BenefitsComponent setExcluded(boolean value) {
            if (this.excluded == null) {
                this.excluded = new BooleanType();
            }
            this.excluded.setValue((Object)value);
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitsComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public BenefitsComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public BenefitsComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitsComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public BenefitsComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public BenefitsComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeableConcept getNetwork() {
            if (this.network == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitsComponent.network");
                }
                if (Configuration.doAutoCreate()) {
                    this.network = new CodeableConcept();
                }
            }
            return this.network;
        }

        public boolean hasNetwork() {
            return this.network != null && !this.network.isEmpty();
        }

        public BenefitsComponent setNetwork(CodeableConcept value) {
            this.network = value;
            return this;
        }

        public CodeableConcept getUnit() {
            if (this.unit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitsComponent.unit");
                }
                if (Configuration.doAutoCreate()) {
                    this.unit = new CodeableConcept();
                }
            }
            return this.unit;
        }

        public boolean hasUnit() {
            return this.unit != null && !this.unit.isEmpty();
        }

        public BenefitsComponent setUnit(CodeableConcept value) {
            this.unit = value;
            return this;
        }

        public CodeableConcept getTerm() {
            if (this.term == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitsComponent.term");
                }
                if (Configuration.doAutoCreate()) {
                    this.term = new CodeableConcept();
                }
            }
            return this.term;
        }

        public boolean hasTerm() {
            return this.term != null && !this.term.isEmpty();
        }

        public BenefitsComponent setTerm(CodeableConcept value) {
            this.term = value;
            return this;
        }

        public List<BenefitComponent> getFinancial() {
            if (this.financial == null) {
                this.financial = new ArrayList<BenefitComponent>();
            }
            return this.financial;
        }

        public BenefitsComponent setFinancial(List<BenefitComponent> theFinancial) {
            this.financial = theFinancial;
            return this;
        }

        public boolean hasFinancial() {
            if (this.financial == null) {
                return false;
            }
            for (BenefitComponent item : this.financial) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public BenefitComponent addFinancial() {
            BenefitComponent t = new BenefitComponent();
            if (this.financial == null) {
                this.financial = new ArrayList<BenefitComponent>();
            }
            this.financial.add(t);
            return t;
        }

        public BenefitsComponent addFinancial(BenefitComponent t) {
            if (t == null) {
                return this;
            }
            if (this.financial == null) {
                this.financial = new ArrayList<BenefitComponent>();
            }
            this.financial.add(t);
            return this;
        }

        public BenefitComponent getFinancialFirstRep() {
            if (this.getFinancial().isEmpty()) {
                this.addFinancial();
            }
            return this.getFinancial().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "Dental, Vision, Medical, Pharmacy, Rehab etc.", 0, 1, this.category));
            children.add(new Property("subCategory", "CodeableConcept", "Dental: basic, major, ortho; Vision exam, glasses, contacts; etc.", 0, 1, this.subCategory));
            children.add(new Property("excluded", "boolean", "True if the indicated class of service is excluded from the plan, missing or False indicated the service is included in the coverage.", 0, 1, this.excluded));
            children.add(new Property("name", "string", "A short name or tag for the benefit, for example MED01, or DENT2.", 0, 1, this.name));
            children.add(new Property("description", "string", "A richer description of the benefit, for example 'DENT2 covers 100% of basic, 50% of major but exclused Ortho, Implants and Costmetic services'.", 0, 1, this.description));
            children.add(new Property("network", "CodeableConcept", "Network designation.", 0, 1, this.network));
            children.add(new Property("unit", "CodeableConcept", "Unit designation: individual or family.", 0, 1, this.unit));
            children.add(new Property("term", "CodeableConcept", "The term or period of the values such as 'maximum lifetime benefit' or 'maximum annual vistis'.", 0, 1, this.term));
            children.add(new Property("financial", "", "Benefits Used to date.", 0, Integer.MAX_VALUE, this.financial));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Dental, Vision, Medical, Pharmacy, Rehab etc.", 0, 1, this.category);
                }
                case 1365024606: {
                    return new Property("subCategory", "CodeableConcept", "Dental: basic, major, ortho; Vision exam, glasses, contacts; etc.", 0, 1, this.subCategory);
                }
                case 1994055114: {
                    return new Property("excluded", "boolean", "True if the indicated class of service is excluded from the plan, missing or False indicated the service is included in the coverage.", 0, 1, this.excluded);
                }
                case 3373707: {
                    return new Property("name", "string", "A short name or tag for the benefit, for example MED01, or DENT2.", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property("description", "string", "A richer description of the benefit, for example 'DENT2 covers 100% of basic, 50% of major but exclused Ortho, Implants and Costmetic services'.", 0, 1, this.description);
                }
                case 1843485230: {
                    return new Property("network", "CodeableConcept", "Network designation.", 0, 1, this.network);
                }
                case 3594628: {
                    return new Property("unit", "CodeableConcept", "Unit designation: individual or family.", 0, 1, this.unit);
                }
                case 3556460: {
                    return new Property("term", "CodeableConcept", "The term or period of the values such as 'maximum lifetime benefit' or 'maximum annual vistis'.", 0, 1, this.term);
                }
                case 357555337: {
                    return new Property("financial", "", "Benefits Used to date.", 0, Integer.MAX_VALUE, this.financial);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case 1365024606: {
                    Base[] baseArray;
                    if (this.subCategory == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.subCategory;
                    }
                    return baseArray;
                }
                case 1994055114: {
                    Base[] baseArray;
                    if (this.excluded == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.excluded;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.description;
                    }
                    return baseArray;
                }
                case 1843485230: {
                    Base[] baseArray;
                    if (this.network == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.network;
                    }
                    return baseArray;
                }
                case 3594628: {
                    Base[] baseArray;
                    if (this.unit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.unit;
                    }
                    return baseArray;
                }
                case 3556460: {
                    Base[] baseArray;
                    if (this.term == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.term;
                    }
                    return baseArray;
                }
                case 357555337: {
                    return this.financial == null ? new Base[]{} : this.financial.toArray(new Base[this.financial.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 1365024606: {
                    this.subCategory = this.castToCodeableConcept(value);
                    return value;
                }
                case 1994055114: {
                    this.excluded = this.castToBoolean(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case 1843485230: {
                    this.network = this.castToCodeableConcept(value);
                    return value;
                }
                case 3594628: {
                    this.unit = this.castToCodeableConcept(value);
                    return value;
                }
                case 3556460: {
                    this.term = this.castToCodeableConcept(value);
                    return value;
                }
                case 357555337: {
                    this.getFinancial().add((BenefitComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("subCategory")) {
                this.subCategory = this.castToCodeableConcept(value);
            } else if (name.equals("excluded")) {
                this.excluded = this.castToBoolean(value);
            } else if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("network")) {
                this.network = this.castToCodeableConcept(value);
            } else if (name.equals("unit")) {
                this.unit = this.castToCodeableConcept(value);
            } else if (name.equals("term")) {
                this.term = this.castToCodeableConcept(value);
            } else if (name.equals("financial")) {
                this.getFinancial().add((BenefitComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case 1365024606: {
                    return this.getSubCategory();
                }
                case 1994055114: {
                    return this.getExcludedElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 1843485230: {
                    return this.getNetwork();
                }
                case 3594628: {
                    return this.getUnit();
                }
                case 3556460: {
                    return this.getTerm();
                }
                case 357555337: {
                    return this.addFinancial();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 1365024606: {
                    return new String[]{"CodeableConcept"};
                }
                case 1994055114: {
                    return new String[]{"boolean"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 1843485230: {
                    return new String[]{"CodeableConcept"};
                }
                case 3594628: {
                    return new String[]{"CodeableConcept"};
                }
                case 3556460: {
                    return new String[]{"CodeableConcept"};
                }
                case 357555337: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("subCategory")) {
                this.subCategory = new CodeableConcept();
                return this.subCategory;
            }
            if (name.equals("excluded")) {
                throw new FHIRException("Cannot call addChild on a singleton property EligibilityResponse.excluded");
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property EligibilityResponse.name");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property EligibilityResponse.description");
            }
            if (name.equals("network")) {
                this.network = new CodeableConcept();
                return this.network;
            }
            if (name.equals("unit")) {
                this.unit = new CodeableConcept();
                return this.unit;
            }
            if (name.equals("term")) {
                this.term = new CodeableConcept();
                return this.term;
            }
            if (name.equals("financial")) {
                return this.addFinancial();
            }
            return super.addChild(name);
        }

        @Override
        public BenefitsComponent copy() {
            BenefitsComponent dst = new BenefitsComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.subCategory = this.subCategory == null ? null : this.subCategory.copy();
            dst.excluded = this.excluded == null ? null : this.excluded.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.network = this.network == null ? null : this.network.copy();
            dst.unit = this.unit == null ? null : this.unit.copy();
            CodeableConcept codeableConcept = dst.term = this.term == null ? null : this.term.copy();
            if (this.financial != null) {
                dst.financial = new ArrayList<BenefitComponent>();
                for (BenefitComponent i : this.financial) {
                    dst.financial.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BenefitsComponent)) {
                return false;
            }
            BenefitsComponent o = (BenefitsComponent)other_;
            return BenefitsComponent.compareDeep(this.category, o.category, true) && BenefitsComponent.compareDeep(this.subCategory, o.subCategory, true) && BenefitsComponent.compareDeep(this.excluded, o.excluded, true) && BenefitsComponent.compareDeep(this.name, o.name, true) && BenefitsComponent.compareDeep(this.description, o.description, true) && BenefitsComponent.compareDeep(this.network, o.network, true) && BenefitsComponent.compareDeep(this.unit, o.unit, true) && BenefitsComponent.compareDeep(this.term, o.term, true) && BenefitsComponent.compareDeep(this.financial, o.financial, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BenefitsComponent)) {
                return false;
            }
            BenefitsComponent o = (BenefitsComponent)other_;
            return BenefitsComponent.compareValues(this.excluded, o.excluded, true) && BenefitsComponent.compareValues(this.name, o.name, true) && BenefitsComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.category, this.subCategory, this.excluded, this.name, this.description, this.network, this.unit, this.term, this.financial});
        }

        @Override
        public String fhirType() {
            return "EligibilityResponse.insurance.benefitBalance";
        }
    }

    @Block
    public static class InsuranceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="coverage", type={Coverage.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Updated Coverage details", formalDefinition="A suite of updated or additional Coverages from the Insurer.")
        protected Reference coverage;
        protected Coverage coverageTarget;
        @Child(name="contract", type={Contract.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract details", formalDefinition="The contract resource which may provide more detailed information.")
        protected Reference contract;
        protected Contract contractTarget;
        @Child(name="benefitBalance", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Benefits by Category", formalDefinition="Benefits and optionally current balances by Category.")
        protected List<BenefitsComponent> benefitBalance;
        private static final long serialVersionUID = 821384102L;

        public Reference getCoverage() {
            if (this.coverage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverage = new Reference();
                }
            }
            return this.coverage;
        }

        public boolean hasCoverage() {
            return this.coverage != null && !this.coverage.isEmpty();
        }

        public InsuranceComponent setCoverage(Reference value) {
            this.coverage = value;
            return this;
        }

        public Coverage getCoverageTarget() {
            if (this.coverageTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverageTarget = new Coverage();
                }
            }
            return this.coverageTarget;
        }

        public InsuranceComponent setCoverageTarget(Coverage value) {
            this.coverageTarget = value;
            return this;
        }

        public Reference getContract() {
            if (this.contract == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.contract");
                }
                if (Configuration.doAutoCreate()) {
                    this.contract = new Reference();
                }
            }
            return this.contract;
        }

        public boolean hasContract() {
            return this.contract != null && !this.contract.isEmpty();
        }

        public InsuranceComponent setContract(Reference value) {
            this.contract = value;
            return this;
        }

        public Contract getContractTarget() {
            if (this.contractTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.contract");
                }
                if (Configuration.doAutoCreate()) {
                    this.contractTarget = new Contract();
                }
            }
            return this.contractTarget;
        }

        public InsuranceComponent setContractTarget(Contract value) {
            this.contractTarget = value;
            return this;
        }

        public List<BenefitsComponent> getBenefitBalance() {
            if (this.benefitBalance == null) {
                this.benefitBalance = new ArrayList<BenefitsComponent>();
            }
            return this.benefitBalance;
        }

        public InsuranceComponent setBenefitBalance(List<BenefitsComponent> theBenefitBalance) {
            this.benefitBalance = theBenefitBalance;
            return this;
        }

        public boolean hasBenefitBalance() {
            if (this.benefitBalance == null) {
                return false;
            }
            for (BenefitsComponent item : this.benefitBalance) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public BenefitsComponent addBenefitBalance() {
            BenefitsComponent t = new BenefitsComponent();
            if (this.benefitBalance == null) {
                this.benefitBalance = new ArrayList<BenefitsComponent>();
            }
            this.benefitBalance.add(t);
            return t;
        }

        public InsuranceComponent addBenefitBalance(BenefitsComponent t) {
            if (t == null) {
                return this;
            }
            if (this.benefitBalance == null) {
                this.benefitBalance = new ArrayList<BenefitsComponent>();
            }
            this.benefitBalance.add(t);
            return this;
        }

        public BenefitsComponent getBenefitBalanceFirstRep() {
            if (this.getBenefitBalance().isEmpty()) {
                this.addBenefitBalance();
            }
            return this.getBenefitBalance().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("coverage", "Reference(Coverage)", "A suite of updated or additional Coverages from the Insurer.", 0, 1, this.coverage));
            children.add(new Property("contract", "Reference(Contract)", "The contract resource which may provide more detailed information.", 0, 1, this.contract));
            children.add(new Property("benefitBalance", "", "Benefits and optionally current balances by Category.", 0, Integer.MAX_VALUE, this.benefitBalance));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -351767064: {
                    return new Property("coverage", "Reference(Coverage)", "A suite of updated or additional Coverages from the Insurer.", 0, 1, this.coverage);
                }
                case -566947566: {
                    return new Property("contract", "Reference(Contract)", "The contract resource which may provide more detailed information.", 0, 1, this.contract);
                }
                case 596003397: {
                    return new Property("benefitBalance", "", "Benefits and optionally current balances by Category.", 0, Integer.MAX_VALUE, this.benefitBalance);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    Base[] baseArray;
                    if (this.coverage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.coverage;
                    }
                    return baseArray;
                }
                case -566947566: {
                    Base[] baseArray;
                    if (this.contract == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.contract;
                    }
                    return baseArray;
                }
                case 596003397: {
                    return this.benefitBalance == null ? new Base[]{} : this.benefitBalance.toArray(new Base[this.benefitBalance.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    this.coverage = this.castToReference(value);
                    return value;
                }
                case -566947566: {
                    this.contract = this.castToReference(value);
                    return value;
                }
                case 596003397: {
                    this.getBenefitBalance().add((BenefitsComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("coverage")) {
                this.coverage = this.castToReference(value);
            } else if (name.equals("contract")) {
                this.contract = this.castToReference(value);
            } else if (name.equals("benefitBalance")) {
                this.getBenefitBalance().add((BenefitsComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    return this.getCoverage();
                }
                case -566947566: {
                    return this.getContract();
                }
                case 596003397: {
                    return this.addBenefitBalance();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    return new String[]{"Reference"};
                }
                case -566947566: {
                    return new String[]{"Reference"};
                }
                case 596003397: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("coverage")) {
                this.coverage = new Reference();
                return this.coverage;
            }
            if (name.equals("contract")) {
                this.contract = new Reference();
                return this.contract;
            }
            if (name.equals("benefitBalance")) {
                return this.addBenefitBalance();
            }
            return super.addChild(name);
        }

        @Override
        public InsuranceComponent copy() {
            InsuranceComponent dst = new InsuranceComponent();
            this.copyValues(dst);
            dst.coverage = this.coverage == null ? null : this.coverage.copy();
            Reference reference = dst.contract = this.contract == null ? null : this.contract.copy();
            if (this.benefitBalance != null) {
                dst.benefitBalance = new ArrayList<BenefitsComponent>();
                for (BenefitsComponent i : this.benefitBalance) {
                    dst.benefitBalance.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other_;
            return InsuranceComponent.compareDeep(this.coverage, o.coverage, true) && InsuranceComponent.compareDeep(this.contract, o.contract, true) && InsuranceComponent.compareDeep(this.benefitBalance, o.benefitBalance, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.coverage, this.contract, this.benefitBalance});
        }

        @Override
        public String fhirType() {
            return "EligibilityResponse.insurance";
        }
    }

    public static class EligibilityResponseStatusEnumFactory
    implements EnumFactory<EligibilityResponseStatus> {
        @Override
        public EligibilityResponseStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return EligibilityResponseStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return EligibilityResponseStatus.CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return EligibilityResponseStatus.DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return EligibilityResponseStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown EligibilityResponseStatus code '" + codeString + "'");
        }

        public Enumeration<EligibilityResponseStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EligibilityResponseStatus>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<EligibilityResponseStatus>(this, EligibilityResponseStatus.ACTIVE);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<EligibilityResponseStatus>(this, EligibilityResponseStatus.CANCELLED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<EligibilityResponseStatus>(this, EligibilityResponseStatus.DRAFT);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<EligibilityResponseStatus>(this, EligibilityResponseStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown EligibilityResponseStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EligibilityResponseStatus code) {
            if (code == EligibilityResponseStatus.ACTIVE) {
                return "active";
            }
            if (code == EligibilityResponseStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == EligibilityResponseStatus.DRAFT) {
                return "draft";
            }
            if (code == EligibilityResponseStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(EligibilityResponseStatus code) {
            return code.getSystem();
        }
    }

    public static enum EligibilityResponseStatus {
        ACTIVE,
        CANCELLED,
        DRAFT,
        ENTEREDINERROR,
        NULL;


        public static EligibilityResponseStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EligibilityResponseStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DRAFT: {
                    return "draft";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The instance is currently in-force.";
                }
                case CANCELLED: {
                    return "The instance is withdrawn, rescinded or reversed.";
                }
                case DRAFT: {
                    return "A new instance the contents of which is not complete.";
                }
                case ENTEREDINERROR: {
                    return "The instance was entered in error.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DRAFT: {
                    return "Draft";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

