/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ChoiceListOrientation {
    HORIZONTAL,
    VERTICAL,
    NULL;


    public static ChoiceListOrientation fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("horizontal".equals(codeString)) {
            return HORIZONTAL;
        }
        if ("vertical".equals(codeString)) {
            return VERTICAL;
        }
        throw new FHIRException("Unknown ChoiceListOrientation code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case HORIZONTAL: {
                return "horizontal";
            }
            case VERTICAL: {
                return "vertical";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/choice-list-orientation";
    }

    public String getDefinition() {
        switch (this) {
            case HORIZONTAL: {
                return "List choices along the horizontal axis";
            }
            case VERTICAL: {
                return "List choices down the vertical axis";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case HORIZONTAL: {
                return "Horizontal";
            }
            case VERTICAL: {
                return "Vertical";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

