/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SearchXpathUsage {
    NORMAL,
    PHONETIC,
    NEARBY,
    DISTANCE,
    OTHER,
    NULL;


    public static SearchXpathUsage fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("normal".equals(codeString)) {
            return NORMAL;
        }
        if ("phonetic".equals(codeString)) {
            return PHONETIC;
        }
        if ("nearby".equals(codeString)) {
            return NEARBY;
        }
        if ("distance".equals(codeString)) {
            return DISTANCE;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        throw new FHIRException("Unknown SearchXpathUsage code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NORMAL: {
                return "normal";
            }
            case PHONETIC: {
                return "phonetic";
            }
            case NEARBY: {
                return "nearby";
            }
            case DISTANCE: {
                return "distance";
            }
            case OTHER: {
                return "other";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/search-xpath-usage";
    }

    public String getDefinition() {
        switch (this) {
            case NORMAL: {
                return "The search parameter is derived directly from the selected nodes based on the type definitions.";
            }
            case PHONETIC: {
                return "The search parameter is derived by a phonetic transform from the selected nodes.";
            }
            case NEARBY: {
                return "The search parameter is based on a spatial transform of the selected nodes.";
            }
            case DISTANCE: {
                return "The search parameter is based on a spatial transform of the selected nodes, using physical distance from the middle.";
            }
            case OTHER: {
                return "The interpretation of the xpath statement is unknown (and can't be automated).";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NORMAL: {
                return "Normal";
            }
            case PHONETIC: {
                return "Phonetic";
            }
            case NEARBY: {
                return "Nearby";
            }
            case DISTANCE: {
                return "Distance";
            }
            case OTHER: {
                return "Other";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

