/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AllergyVerificationStatus {
    UNCONFIRMED,
    CONFIRMED,
    REFUTED,
    ENTEREDINERROR,
    NULL;


    public static AllergyVerificationStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("unconfirmed".equals(codeString)) {
            return UNCONFIRMED;
        }
        if ("confirmed".equals(codeString)) {
            return CONFIRMED;
        }
        if ("refuted".equals(codeString)) {
            return REFUTED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown AllergyVerificationStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case UNCONFIRMED: {
                return "unconfirmed";
            }
            case CONFIRMED: {
                return "confirmed";
            }
            case REFUTED: {
                return "refuted";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/allergy-verification-status";
    }

    public String getDefinition() {
        switch (this) {
            case UNCONFIRMED: {
                return "A low level of certainty about the propensity for a reaction to the identified substance.";
            }
            case CONFIRMED: {
                return "A high level of certainty about the propensity for a reaction to the identified substance, which may include clinical evidence by testing or rechallenge.";
            }
            case REFUTED: {
                return "A propensity for a reaction to the identified substance has been disproven with a high level of clinical certainty, which may include testing or rechallenge, and is refuted.";
            }
            case ENTEREDINERROR: {
                return "The statement was entered in error and is not valid.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case UNCONFIRMED: {
                return "Unconfirmed";
            }
            case CONFIRMED: {
                return "Confirmed";
            }
            case REFUTED: {
                return "Refuted";
            }
            case ENTEREDINERROR: {
                return "Entered In Error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

