/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="RiskAssessment", profile="http://hl7.org/fhir/Profile/RiskAssessment")
public class RiskAssessment
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier for the assessment", formalDefinition="Business identifier assigned to the risk assessment.")
    protected Identifier identifier;
    @Child(name="basedOn", type={Reference.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Request fulfilled by this assessment", formalDefinition="A reference to the request that is fulfilled by this risk assessment.")
    protected Reference basedOn;
    protected Resource basedOnTarget;
    @Child(name="parent", type={Reference.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Part of this occurrence", formalDefinition="A reference to a resource that this risk assessment is part of, such as a Procedure.")
    protected Reference parent;
    protected Resource parentTarget;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="registered | preliminary | final | amended +", formalDefinition="The status of the RiskAssessment, using the same statuses as an Observation.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-status")
    protected Enumeration<RiskAssessmentStatus> status;
    @Child(name="method", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Evaluation mechanism", formalDefinition="The algorithm, process or mechanism used to evaluate the risk.")
    protected CodeableConcept method;
    @Child(name="code", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of assessment", formalDefinition="The type of the risk assessment performed.")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/what does assessment apply to?", formalDefinition="The patient or group the risk assessment applies to.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where was assessment performed?", formalDefinition="The encounter where the assessment was performed.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="occurrence", type={DateTimeType.class, Period.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When was assessment made?", formalDefinition="The date (and possibly time) the risk assessment was performed.")
    protected Type occurrence;
    @Child(name="condition", type={Condition.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Condition assessed", formalDefinition="For assessments or prognosis specific to a particular condition, indicates the condition being assessed.")
    protected Reference condition;
    protected Condition conditionTarget;
    @Child(name="performer", type={Practitioner.class, Device.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who did assessment?", formalDefinition="The provider or software application that performed the assessment.")
    protected Reference performer;
    protected Resource performerTarget;
    @Child(name="reason", type={CodeableConcept.class, Reference.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why the assessment was necessary?", formalDefinition="The reason the risk assessment was performed.")
    protected Type reason;
    @Child(name="basis", type={Reference.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information used in assessment", formalDefinition="Indicates the source data considered as part of the assessment (FamilyHistory, Observations, Procedures, Conditions, etc.).")
    protected List<Reference> basis;
    protected List<Resource> basisTarget;
    @Child(name="prediction", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Outcome predicted", formalDefinition="Describes the expected outcome for the subject.")
    protected List<RiskAssessmentPredictionComponent> prediction;
    @Child(name="mitigation", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How to reduce risk", formalDefinition="A description of the steps that might be taken to reduce the identified risk(s).")
    protected StringType mitigation;
    @Child(name="comment", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Comments on the risk assessment", formalDefinition="Additional comments about the risk assessment.")
    protected StringType comment;
    private static final long serialVersionUID = -715866284L;
    @SearchParamDefinition(name="date", path="RiskAssessment.occurrence.as(DateTime)", description="When was assessment made?", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="RiskAssessment.identifier", description="Unique identifier for the assessment", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="condition", path="RiskAssessment.condition", description="Condition assessed", type="reference", target={Condition.class})
    public static final String SP_CONDITION = "condition";
    public static final ReferenceClientParam CONDITION = new ReferenceClientParam("condition");
    public static final Include INCLUDE_CONDITION = new Include("RiskAssessment:condition").toLocked();
    @SearchParamDefinition(name="performer", path="RiskAssessment.performer", description="Who did assessment?", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Practitioner")}, target={Device.class, Practitioner.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("RiskAssessment:performer").toLocked();
    @SearchParamDefinition(name="method", path="RiskAssessment.method", description="Evaluation mechanism", type="token")
    public static final String SP_METHOD = "method";
    public static final TokenClientParam METHOD = new TokenClientParam("method");
    @SearchParamDefinition(name="subject", path="RiskAssessment.subject", description="Who/what does assessment apply to?", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("RiskAssessment:subject").toLocked();
    @SearchParamDefinition(name="patient", path="RiskAssessment.subject", description="Who/what does assessment apply to?", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("RiskAssessment:patient").toLocked();
    @SearchParamDefinition(name="probability", path="RiskAssessment.prediction.probability", description="Likelihood of specified outcome", type="number")
    public static final String SP_PROBABILITY = "probability";
    public static final NumberClientParam PROBABILITY = new NumberClientParam("probability");
    @SearchParamDefinition(name="risk", path="RiskAssessment.prediction.qualitativeRisk", description="Likelihood of specified outcome as a qualitative value", type="token")
    public static final String SP_RISK = "risk";
    public static final TokenClientParam RISK = new TokenClientParam("risk");
    @SearchParamDefinition(name="encounter", path="RiskAssessment.context", description="Where was assessment performed?", type="reference", target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("RiskAssessment:encounter").toLocked();

    public RiskAssessment() {
    }

    public RiskAssessment(Enumeration<RiskAssessmentStatus> status) {
        this.status = status;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public RiskAssessment setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Reference getBasedOn() {
        if (this.basedOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.basedOn");
            }
            if (Configuration.doAutoCreate()) {
                this.basedOn = new Reference();
            }
        }
        return this.basedOn;
    }

    public boolean hasBasedOn() {
        return this.basedOn != null && !this.basedOn.isEmpty();
    }

    public RiskAssessment setBasedOn(Reference value) {
        this.basedOn = value;
        return this;
    }

    public Resource getBasedOnTarget() {
        return this.basedOnTarget;
    }

    public RiskAssessment setBasedOnTarget(Resource value) {
        this.basedOnTarget = value;
        return this;
    }

    public Reference getParent() {
        if (this.parent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.parent");
            }
            if (Configuration.doAutoCreate()) {
                this.parent = new Reference();
            }
        }
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null && !this.parent.isEmpty();
    }

    public RiskAssessment setParent(Reference value) {
        this.parent = value;
        return this;
    }

    public Resource getParentTarget() {
        return this.parentTarget;
    }

    public RiskAssessment setParentTarget(Resource value) {
        this.parentTarget = value;
        return this;
    }

    public Enumeration<RiskAssessmentStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<RiskAssessmentStatus>(new RiskAssessmentStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public RiskAssessment setStatusElement(Enumeration<RiskAssessmentStatus> value) {
        this.status = value;
        return this;
    }

    public RiskAssessmentStatus getStatus() {
        return this.status == null ? null : (RiskAssessmentStatus)((Object)this.status.getValue());
    }

    public RiskAssessment setStatus(RiskAssessmentStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<RiskAssessmentStatus>(new RiskAssessmentStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getMethod() {
        if (this.method == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.method");
            }
            if (Configuration.doAutoCreate()) {
                this.method = new CodeableConcept();
            }
        }
        return this.method;
    }

    public boolean hasMethod() {
        return this.method != null && !this.method.isEmpty();
    }

    public RiskAssessment setMethod(CodeableConcept value) {
        this.method = value;
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public RiskAssessment setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public RiskAssessment setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public RiskAssessment setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public RiskAssessment setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public RiskAssessment setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public Type getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (this.occurrence == null) {
            return null;
        }
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this != null && this.occurrence instanceof DateTimeType;
    }

    public Period getOccurrencePeriod() throws FHIRException {
        if (this.occurrence == null) {
            return null;
        }
        if (!(this.occurrence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurrence;
    }

    public boolean hasOccurrencePeriod() {
        return this != null && this.occurrence instanceof Period;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public RiskAssessment setOccurrence(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new FHIRFormatError("Not the right type for RiskAssessment.occurrence[x]: " + value.fhirType());
        }
        this.occurrence = value;
        return this;
    }

    public Reference getCondition() {
        if (this.condition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.condition");
            }
            if (Configuration.doAutoCreate()) {
                this.condition = new Reference();
            }
        }
        return this.condition;
    }

    public boolean hasCondition() {
        return this.condition != null && !this.condition.isEmpty();
    }

    public RiskAssessment setCondition(Reference value) {
        this.condition = value;
        return this;
    }

    public Condition getConditionTarget() {
        if (this.conditionTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.condition");
            }
            if (Configuration.doAutoCreate()) {
                this.conditionTarget = new Condition();
            }
        }
        return this.conditionTarget;
    }

    public RiskAssessment setConditionTarget(Condition value) {
        this.conditionTarget = value;
        return this;
    }

    public Reference getPerformer() {
        if (this.performer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.performer");
            }
            if (Configuration.doAutoCreate()) {
                this.performer = new Reference();
            }
        }
        return this.performer;
    }

    public boolean hasPerformer() {
        return this.performer != null && !this.performer.isEmpty();
    }

    public RiskAssessment setPerformer(Reference value) {
        this.performer = value;
        return this;
    }

    public Resource getPerformerTarget() {
        return this.performerTarget;
    }

    public RiskAssessment setPerformerTarget(Resource value) {
        this.performerTarget = value;
        return this;
    }

    public Type getReason() {
        return this.reason;
    }

    public CodeableConcept getReasonCodeableConcept() throws FHIRException {
        if (this.reason == null) {
            return null;
        }
        if (!(this.reason instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.reason;
    }

    public boolean hasReasonCodeableConcept() {
        return this != null && this.reason instanceof CodeableConcept;
    }

    public Reference getReasonReference() throws FHIRException {
        if (this.reason == null) {
            return null;
        }
        if (!(this.reason instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (Reference)this.reason;
    }

    public boolean hasReasonReference() {
        return this != null && this.reason instanceof Reference;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public RiskAssessment setReason(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new FHIRFormatError("Not the right type for RiskAssessment.reason[x]: " + value.fhirType());
        }
        this.reason = value;
        return this;
    }

    public List<Reference> getBasis() {
        if (this.basis == null) {
            this.basis = new ArrayList<Reference>();
        }
        return this.basis;
    }

    public RiskAssessment setBasis(List<Reference> theBasis) {
        this.basis = theBasis;
        return this;
    }

    public boolean hasBasis() {
        if (this.basis == null) {
            return false;
        }
        for (Reference item : this.basis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasis() {
        Reference t = new Reference();
        if (this.basis == null) {
            this.basis = new ArrayList<Reference>();
        }
        this.basis.add(t);
        return t;
    }

    public RiskAssessment addBasis(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basis == null) {
            this.basis = new ArrayList<Reference>();
        }
        this.basis.add(t);
        return this;
    }

    public Reference getBasisFirstRep() {
        if (this.getBasis().isEmpty()) {
            this.addBasis();
        }
        return this.getBasis().get(0);
    }

    @Deprecated
    public List<Resource> getBasisTarget() {
        if (this.basisTarget == null) {
            this.basisTarget = new ArrayList<Resource>();
        }
        return this.basisTarget;
    }

    public List<RiskAssessmentPredictionComponent> getPrediction() {
        if (this.prediction == null) {
            this.prediction = new ArrayList<RiskAssessmentPredictionComponent>();
        }
        return this.prediction;
    }

    public RiskAssessment setPrediction(List<RiskAssessmentPredictionComponent> thePrediction) {
        this.prediction = thePrediction;
        return this;
    }

    public boolean hasPrediction() {
        if (this.prediction == null) {
            return false;
        }
        for (RiskAssessmentPredictionComponent item : this.prediction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RiskAssessmentPredictionComponent addPrediction() {
        RiskAssessmentPredictionComponent t = new RiskAssessmentPredictionComponent();
        if (this.prediction == null) {
            this.prediction = new ArrayList<RiskAssessmentPredictionComponent>();
        }
        this.prediction.add(t);
        return t;
    }

    public RiskAssessment addPrediction(RiskAssessmentPredictionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.prediction == null) {
            this.prediction = new ArrayList<RiskAssessmentPredictionComponent>();
        }
        this.prediction.add(t);
        return this;
    }

    public RiskAssessmentPredictionComponent getPredictionFirstRep() {
        if (this.getPrediction().isEmpty()) {
            this.addPrediction();
        }
        return this.getPrediction().get(0);
    }

    public StringType getMitigationElement() {
        if (this.mitigation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.mitigation");
            }
            if (Configuration.doAutoCreate()) {
                this.mitigation = new StringType();
            }
        }
        return this.mitigation;
    }

    public boolean hasMitigationElement() {
        return this.mitigation != null && !this.mitigation.isEmpty();
    }

    public boolean hasMitigation() {
        return this.mitigation != null && !this.mitigation.isEmpty();
    }

    public RiskAssessment setMitigationElement(StringType value) {
        this.mitigation = value;
        return this;
    }

    public String getMitigation() {
        return this.mitigation == null ? null : (String)this.mitigation.getValue();
    }

    public RiskAssessment setMitigation(String value) {
        if (Utilities.noString((String)value)) {
            this.mitigation = null;
        } else {
            if (this.mitigation == null) {
                this.mitigation = new StringType();
            }
            this.mitigation.setValue(value);
        }
        return this;
    }

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public RiskAssessment setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public RiskAssessment setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier assigned to the risk assessment.", 0, 1, this.identifier));
        children.add(new Property("basedOn", "Reference(Any)", "A reference to the request that is fulfilled by this risk assessment.", 0, 1, this.basedOn));
        children.add(new Property("parent", "Reference(Any)", "A reference to a resource that this risk assessment is part of, such as a Procedure.", 0, 1, this.parent));
        children.add(new Property("status", "code", "The status of the RiskAssessment, using the same statuses as an Observation.", 0, 1, this.status));
        children.add(new Property(SP_METHOD, "CodeableConcept", "The algorithm, process or mechanism used to evaluate the risk.", 0, 1, this.method));
        children.add(new Property("code", "CodeableConcept", "The type of the risk assessment performed.", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group the risk assessment applies to.", 0, 1, this.subject));
        children.add(new Property("context", "Reference(Encounter|EpisodeOfCare)", "The encounter where the assessment was performed.", 0, 1, this.context));
        children.add(new Property("occurrence[x]", "dateTime|Period", "The date (and possibly time) the risk assessment was performed.", 0, 1, this.occurrence));
        children.add(new Property(SP_CONDITION, "Reference(Condition)", "For assessments or prognosis specific to a particular condition, indicates the condition being assessed.", 0, 1, this.condition));
        children.add(new Property(SP_PERFORMER, "Reference(Practitioner|Device)", "The provider or software application that performed the assessment.", 0, 1, this.performer));
        children.add(new Property("reason[x]", "CodeableConcept|Reference(Any)", "The reason the risk assessment was performed.", 0, 1, this.reason));
        children.add(new Property("basis", "Reference(Any)", "Indicates the source data considered as part of the assessment (FamilyHistory, Observations, Procedures, Conditions, etc.).", 0, Integer.MAX_VALUE, this.basis));
        children.add(new Property("prediction", "", "Describes the expected outcome for the subject.", 0, Integer.MAX_VALUE, this.prediction));
        children.add(new Property("mitigation", "string", "A description of the steps that might be taken to reduce the identified risk(s).", 0, 1, this.mitigation));
        children.add(new Property("comment", "string", "Additional comments about the risk assessment.", 0, 1, this.comment));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier assigned to the risk assessment.", 0, 1, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(Any)", "A reference to the request that is fulfilled by this risk assessment.", 0, 1, this.basedOn);
            }
            case -995424086: {
                return new Property("parent", "Reference(Any)", "A reference to a resource that this risk assessment is part of, such as a Procedure.", 0, 1, this.parent);
            }
            case -892481550: {
                return new Property("status", "code", "The status of the RiskAssessment, using the same statuses as an Observation.", 0, 1, this.status);
            }
            case -1077554975: {
                return new Property(SP_METHOD, "CodeableConcept", "The algorithm, process or mechanism used to evaluate the risk.", 0, 1, this.method);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "The type of the risk assessment performed.", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group the risk assessment applies to.", 0, 1, this.subject);
            }
            case 951530927: {
                return new Property("context", "Reference(Encounter|EpisodeOfCare)", "The encounter where the assessment was performed.", 0, 1, this.context);
            }
            case -2022646513: {
                return new Property("occurrence[x]", "dateTime|Period", "The date (and possibly time) the risk assessment was performed.", 0, 1, this.occurrence);
            }
            case 1687874001: {
                return new Property("occurrence[x]", "dateTime|Period", "The date (and possibly time) the risk assessment was performed.", 0, 1, this.occurrence);
            }
            case -298443636: {
                return new Property("occurrence[x]", "dateTime|Period", "The date (and possibly time) the risk assessment was performed.", 0, 1, this.occurrence);
            }
            case 1397156594: {
                return new Property("occurrence[x]", "dateTime|Period", "The date (and possibly time) the risk assessment was performed.", 0, 1, this.occurrence);
            }
            case -861311717: {
                return new Property(SP_CONDITION, "Reference(Condition)", "For assessments or prognosis specific to a particular condition, indicates the condition being assessed.", 0, 1, this.condition);
            }
            case 481140686: {
                return new Property(SP_PERFORMER, "Reference(Practitioner|Device)", "The provider or software application that performed the assessment.", 0, 1, this.performer);
            }
            case -669418564: {
                return new Property("reason[x]", "CodeableConcept|Reference(Any)", "The reason the risk assessment was performed.", 0, 1, this.reason);
            }
            case -934964668: {
                return new Property("reason[x]", "CodeableConcept|Reference(Any)", "The reason the risk assessment was performed.", 0, 1, this.reason);
            }
            case -610155331: {
                return new Property("reason[x]", "CodeableConcept|Reference(Any)", "The reason the risk assessment was performed.", 0, 1, this.reason);
            }
            case -1146218137: {
                return new Property("reason[x]", "CodeableConcept|Reference(Any)", "The reason the risk assessment was performed.", 0, 1, this.reason);
            }
            case 93508670: {
                return new Property("basis", "Reference(Any)", "Indicates the source data considered as part of the assessment (FamilyHistory, Observations, Procedures, Conditions, etc.).", 0, Integer.MAX_VALUE, this.basis);
            }
            case 1161234575: {
                return new Property("prediction", "", "Describes the expected outcome for the subject.", 0, Integer.MAX_VALUE, this.prediction);
            }
            case 1293793087: {
                return new Property("mitigation", "string", "A description of the steps that might be taken to reduce the identified risk(s).", 0, 1, this.mitigation);
            }
            case 950398559: {
                return new Property("comment", "string", "Additional comments about the risk assessment.", 0, 1, this.comment);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case -332612366: {
                Base[] baseArray;
                if (this.basedOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.basedOn;
                }
                return baseArray;
            }
            case -995424086: {
                Base[] baseArray;
                if (this.parent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.parent;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -1077554975: {
                Base[] baseArray;
                if (this.method == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.method;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.context;
                }
                return baseArray;
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.occurrence;
                }
                return baseArray;
            }
            case -861311717: {
                Base[] baseArray;
                if (this.condition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.condition;
                }
                return baseArray;
            }
            case 481140686: {
                Base[] baseArray;
                if (this.performer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.performer;
                }
                return baseArray;
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.reason;
                }
                return baseArray;
            }
            case 93508670: {
                return this.basis == null ? new Base[]{} : this.basis.toArray(new Base[this.basis.size()]);
            }
            case 1161234575: {
                return this.prediction == null ? new Base[]{} : this.prediction.toArray(new Base[this.prediction.size()]);
            }
            case 1293793087: {
                Base[] baseArray;
                if (this.mitigation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.mitigation;
                }
                return baseArray;
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.comment;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case -332612366: {
                this.basedOn = this.castToReference(value);
                return value;
            }
            case -995424086: {
                this.parent = this.castToReference(value);
                return value;
            }
            case -892481550: {
                value = new RiskAssessmentStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -1077554975: {
                this.method = this.castToCodeableConcept(value);
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case 1687874001: {
                this.occurrence = this.castToType(value);
                return value;
            }
            case -861311717: {
                this.condition = this.castToReference(value);
                return value;
            }
            case 481140686: {
                this.performer = this.castToReference(value);
                return value;
            }
            case -934964668: {
                this.reason = this.castToType(value);
                return value;
            }
            case 93508670: {
                this.getBasis().add(this.castToReference(value));
                return value;
            }
            case 1161234575: {
                this.getPrediction().add((RiskAssessmentPredictionComponent)((Object)value));
                return value;
            }
            case 1293793087: {
                this.mitigation = this.castToString(value);
                return value;
            }
            case 950398559: {
                this.comment = this.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("basedOn")) {
            this.basedOn = this.castToReference(value);
        } else if (name.equals("parent")) {
            this.parent = this.castToReference(value);
        } else if (name.equals("status")) {
            value = new RiskAssessmentStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_METHOD)) {
            this.method = this.castToCodeableConcept(value);
        } else if (name.equals("code")) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals("context")) {
            this.context = this.castToReference(value);
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = this.castToType(value);
        } else if (name.equals(SP_CONDITION)) {
            this.condition = this.castToReference(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.performer = this.castToReference(value);
        } else if (name.equals("reason[x]")) {
            this.reason = this.castToType(value);
        } else if (name.equals("basis")) {
            this.getBasis().add(this.castToReference(value));
        } else if (name.equals("prediction")) {
            this.getPrediction().add((RiskAssessmentPredictionComponent)((Object)value));
        } else if (name.equals("mitigation")) {
            this.mitigation = this.castToString(value);
        } else if (name.equals("comment")) {
            this.comment = this.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case -332612366: {
                return this.getBasedOn();
            }
            case -995424086: {
                return this.getParent();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1077554975: {
                return this.getMethod();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.getContext();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case -861311717: {
                return this.getCondition();
            }
            case 481140686: {
                return this.getPerformer();
            }
            case -669418564: {
                return this.getReason();
            }
            case -934964668: {
                return this.getReason();
            }
            case 93508670: {
                return this.addBasis();
            }
            case 1161234575: {
                return this.addPrediction();
            }
            case 1293793087: {
                return this.getMitigationElement();
            }
            case 950398559: {
                return this.getCommentElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -995424086: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1077554975: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case 1687874001: {
                return new String[]{"dateTime", "Period"};
            }
            case -861311717: {
                return new String[]{"Reference"};
            }
            case 481140686: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case 93508670: {
                return new String[]{"Reference"};
            }
            case 1161234575: {
                return new String[0];
            }
            case 1293793087: {
                return new String[]{"string"};
            }
            case 950398559: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("basedOn")) {
            this.basedOn = new Reference();
            return this.basedOn;
        }
        if (name.equals("parent")) {
            this.parent = new Reference();
            return this.parent;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a singleton property RiskAssessment.status");
        }
        if (name.equals(SP_METHOD)) {
            this.method = new CodeableConcept();
            return this.method;
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("context")) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrencePeriod")) {
            this.occurrence = new Period();
            return this.occurrence;
        }
        if (name.equals(SP_CONDITION)) {
            this.condition = new Reference();
            return this.condition;
        }
        if (name.equals(SP_PERFORMER)) {
            this.performer = new Reference();
            return this.performer;
        }
        if (name.equals("reasonCodeableConcept")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("reasonReference")) {
            this.reason = new Reference();
            return this.reason;
        }
        if (name.equals("basis")) {
            return this.addBasis();
        }
        if (name.equals("prediction")) {
            return this.addPrediction();
        }
        if (name.equals("mitigation")) {
            throw new FHIRException("Cannot call addChild on a singleton property RiskAssessment.mitigation");
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a singleton property RiskAssessment.comment");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "RiskAssessment";
    }

    @Override
    public RiskAssessment copy() {
        RiskAssessment dst = new RiskAssessment();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.basedOn = this.basedOn == null ? null : this.basedOn.copy();
        dst.parent = this.parent == null ? null : this.parent.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.method = this.method == null ? null : this.method.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.context = this.context == null ? null : this.context.copy();
        dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        dst.condition = this.condition == null ? null : this.condition.copy();
        dst.performer = this.performer == null ? null : this.performer.copy();
        Type type = dst.reason = this.reason == null ? null : this.reason.copy();
        if (this.basis != null) {
            dst.basis = new ArrayList<Reference>();
            for (Reference reference : this.basis) {
                dst.basis.add(reference.copy());
            }
        }
        if (this.prediction != null) {
            dst.prediction = new ArrayList<RiskAssessmentPredictionComponent>();
            for (RiskAssessmentPredictionComponent riskAssessmentPredictionComponent : this.prediction) {
                dst.prediction.add(riskAssessmentPredictionComponent.copy());
            }
        }
        dst.mitigation = this.mitigation == null ? null : this.mitigation.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
        return dst;
    }

    protected RiskAssessment typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof RiskAssessment)) {
            return false;
        }
        RiskAssessment o = (RiskAssessment)other_;
        return RiskAssessment.compareDeep(this.identifier, o.identifier, true) && RiskAssessment.compareDeep(this.basedOn, o.basedOn, true) && RiskAssessment.compareDeep(this.parent, o.parent, true) && RiskAssessment.compareDeep(this.status, o.status, true) && RiskAssessment.compareDeep(this.method, o.method, true) && RiskAssessment.compareDeep(this.code, o.code, true) && RiskAssessment.compareDeep(this.subject, o.subject, true) && RiskAssessment.compareDeep(this.context, o.context, true) && RiskAssessment.compareDeep(this.occurrence, o.occurrence, true) && RiskAssessment.compareDeep(this.condition, o.condition, true) && RiskAssessment.compareDeep(this.performer, o.performer, true) && RiskAssessment.compareDeep(this.reason, o.reason, true) && RiskAssessment.compareDeep(this.basis, o.basis, true) && RiskAssessment.compareDeep(this.prediction, o.prediction, true) && RiskAssessment.compareDeep(this.mitigation, o.mitigation, true) && RiskAssessment.compareDeep(this.comment, o.comment, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof RiskAssessment)) {
            return false;
        }
        RiskAssessment o = (RiskAssessment)other_;
        return RiskAssessment.compareValues(this.status, o.status, true) && RiskAssessment.compareValues(this.mitigation, o.mitigation, true) && RiskAssessment.compareValues(this.comment, o.comment, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.parent, this.status, this.method, this.code, this.subject, this.context, this.occurrence, this.condition, this.performer, this.reason, this.basis, this.prediction, this.mitigation, this.comment});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.RiskAssessment;
    }

    @Block
    public static class RiskAssessmentPredictionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="outcome", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Possible outcome for the subject", formalDefinition="One of the potential outcomes for the patient (e.g. remission, death,  a particular condition).")
        protected CodeableConcept outcome;
        @Child(name="probability", type={DecimalType.class, Range.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Likelihood of specified outcome", formalDefinition="How likely is the outcome (in the specified timeframe).")
        protected Type probability;
        @Child(name="qualitativeRisk", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Likelihood of specified outcome as a qualitative value", formalDefinition="How likely is the outcome (in the specified timeframe), expressed as a qualitative value (e.g. low, medium, high).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/risk-probability")
        protected CodeableConcept qualitativeRisk;
        @Child(name="relativeRisk", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Relative likelihood", formalDefinition="Indicates the risk for this particular subject (with their specific characteristics) divided by the risk of the population in general.  (Numbers greater than 1 = higher risk than the population, numbers less than 1 = lower risk.).")
        protected DecimalType relativeRisk;
        @Child(name="when", type={Period.class, Range.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Timeframe or age range", formalDefinition="Indicates the period of time or age range of the subject to which the specified probability applies.")
        protected Type when;
        @Child(name="rationale", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Explanation of prediction", formalDefinition="Additional information explaining the basis for the prediction.")
        protected StringType rationale;
        private static final long serialVersionUID = 1283401747L;

        public RiskAssessmentPredictionComponent() {
        }

        public RiskAssessmentPredictionComponent(CodeableConcept outcome) {
            this.outcome = outcome;
        }

        public CodeableConcept getOutcome() {
            if (this.outcome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskAssessmentPredictionComponent.outcome");
                }
                if (Configuration.doAutoCreate()) {
                    this.outcome = new CodeableConcept();
                }
            }
            return this.outcome;
        }

        public boolean hasOutcome() {
            return this.outcome != null && !this.outcome.isEmpty();
        }

        public RiskAssessmentPredictionComponent setOutcome(CodeableConcept value) {
            this.outcome = value;
            return this;
        }

        public Type getProbability() {
            return this.probability;
        }

        public DecimalType getProbabilityDecimalType() throws FHIRException {
            if (this.probability == null) {
                return null;
            }
            if (!(this.probability instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.probability.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.probability;
        }

        public boolean hasProbabilityDecimalType() {
            return this != null && this.probability instanceof DecimalType;
        }

        public Range getProbabilityRange() throws FHIRException {
            if (this.probability == null) {
                return null;
            }
            if (!(this.probability instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.probability.getClass().getName() + " was encountered");
            }
            return (Range)this.probability;
        }

        public boolean hasProbabilityRange() {
            return this != null && this.probability instanceof Range;
        }

        public boolean hasProbability() {
            return this.probability != null && !this.probability.isEmpty();
        }

        public RiskAssessmentPredictionComponent setProbability(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof DecimalType) && !(value instanceof Range)) {
                throw new FHIRFormatError("Not the right type for RiskAssessment.prediction.probability[x]: " + value.fhirType());
            }
            this.probability = value;
            return this;
        }

        public CodeableConcept getQualitativeRisk() {
            if (this.qualitativeRisk == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskAssessmentPredictionComponent.qualitativeRisk");
                }
                if (Configuration.doAutoCreate()) {
                    this.qualitativeRisk = new CodeableConcept();
                }
            }
            return this.qualitativeRisk;
        }

        public boolean hasQualitativeRisk() {
            return this.qualitativeRisk != null && !this.qualitativeRisk.isEmpty();
        }

        public RiskAssessmentPredictionComponent setQualitativeRisk(CodeableConcept value) {
            this.qualitativeRisk = value;
            return this;
        }

        public DecimalType getRelativeRiskElement() {
            if (this.relativeRisk == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskAssessmentPredictionComponent.relativeRisk");
                }
                if (Configuration.doAutoCreate()) {
                    this.relativeRisk = new DecimalType();
                }
            }
            return this.relativeRisk;
        }

        public boolean hasRelativeRiskElement() {
            return this.relativeRisk != null && !this.relativeRisk.isEmpty();
        }

        public boolean hasRelativeRisk() {
            return this.relativeRisk != null && !this.relativeRisk.isEmpty();
        }

        public RiskAssessmentPredictionComponent setRelativeRiskElement(DecimalType value) {
            this.relativeRisk = value;
            return this;
        }

        public BigDecimal getRelativeRisk() {
            return this.relativeRisk == null ? null : (BigDecimal)this.relativeRisk.getValue();
        }

        public RiskAssessmentPredictionComponent setRelativeRisk(BigDecimal value) {
            if (value == null) {
                this.relativeRisk = null;
            } else {
                if (this.relativeRisk == null) {
                    this.relativeRisk = new DecimalType();
                }
                this.relativeRisk.setValue(value);
            }
            return this;
        }

        public RiskAssessmentPredictionComponent setRelativeRisk(long value) {
            this.relativeRisk = new DecimalType();
            this.relativeRisk.setValue(value);
            return this;
        }

        public RiskAssessmentPredictionComponent setRelativeRisk(double value) {
            this.relativeRisk = new DecimalType();
            this.relativeRisk.setValue(value);
            return this;
        }

        public Type getWhen() {
            return this.when;
        }

        public Period getWhenPeriod() throws FHIRException {
            if (this.when == null) {
                return null;
            }
            if (!(this.when instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.when.getClass().getName() + " was encountered");
            }
            return (Period)this.when;
        }

        public boolean hasWhenPeriod() {
            return this != null && this.when instanceof Period;
        }

        public Range getWhenRange() throws FHIRException {
            if (this.when == null) {
                return null;
            }
            if (!(this.when instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.when.getClass().getName() + " was encountered");
            }
            return (Range)this.when;
        }

        public boolean hasWhenRange() {
            return this != null && this.when instanceof Range;
        }

        public boolean hasWhen() {
            return this.when != null && !this.when.isEmpty();
        }

        public RiskAssessmentPredictionComponent setWhen(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof Period) && !(value instanceof Range)) {
                throw new FHIRFormatError("Not the right type for RiskAssessment.prediction.when[x]: " + value.fhirType());
            }
            this.when = value;
            return this;
        }

        public StringType getRationaleElement() {
            if (this.rationale == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskAssessmentPredictionComponent.rationale");
                }
                if (Configuration.doAutoCreate()) {
                    this.rationale = new StringType();
                }
            }
            return this.rationale;
        }

        public boolean hasRationaleElement() {
            return this.rationale != null && !this.rationale.isEmpty();
        }

        public boolean hasRationale() {
            return this.rationale != null && !this.rationale.isEmpty();
        }

        public RiskAssessmentPredictionComponent setRationaleElement(StringType value) {
            this.rationale = value;
            return this;
        }

        public String getRationale() {
            return this.rationale == null ? null : (String)this.rationale.getValue();
        }

        public RiskAssessmentPredictionComponent setRationale(String value) {
            if (Utilities.noString((String)value)) {
                this.rationale = null;
            } else {
                if (this.rationale == null) {
                    this.rationale = new StringType();
                }
                this.rationale.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("outcome", "CodeableConcept", "One of the potential outcomes for the patient (e.g. remission, death,  a particular condition).", 0, 1, this.outcome));
            children.add(new Property("probability[x]", "decimal|Range", "How likely is the outcome (in the specified timeframe).", 0, 1, this.probability));
            children.add(new Property("qualitativeRisk", "CodeableConcept", "How likely is the outcome (in the specified timeframe), expressed as a qualitative value (e.g. low, medium, high).", 0, 1, this.qualitativeRisk));
            children.add(new Property("relativeRisk", "decimal", "Indicates the risk for this particular subject (with their specific characteristics) divided by the risk of the population in general.  (Numbers greater than 1 = higher risk than the population, numbers less than 1 = lower risk.).", 0, 1, this.relativeRisk));
            children.add(new Property("when[x]", "Period|Range", "Indicates the period of time or age range of the subject to which the specified probability applies.", 0, 1, this.when));
            children.add(new Property("rationale", "string", "Additional information explaining the basis for the prediction.", 0, 1, this.rationale));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1106507950: {
                    return new Property("outcome", "CodeableConcept", "One of the potential outcomes for the patient (e.g. remission, death,  a particular condition).", 0, 1, this.outcome);
                }
                case 1430185003: {
                    return new Property("probability[x]", "decimal|Range", "How likely is the outcome (in the specified timeframe).", 0, 1, this.probability);
                }
                case -1290561483: {
                    return new Property("probability[x]", "decimal|Range", "How likely is the outcome (in the specified timeframe).", 0, 1, this.probability);
                }
                case 888495452: {
                    return new Property("probability[x]", "decimal|Range", "How likely is the outcome (in the specified timeframe).", 0, 1, this.probability);
                }
                case 9275912: {
                    return new Property("probability[x]", "decimal|Range", "How likely is the outcome (in the specified timeframe).", 0, 1, this.probability);
                }
                case 123308730: {
                    return new Property("qualitativeRisk", "CodeableConcept", "How likely is the outcome (in the specified timeframe), expressed as a qualitative value (e.g. low, medium, high).", 0, 1, this.qualitativeRisk);
                }
                case -70741061: {
                    return new Property("relativeRisk", "decimal", "Indicates the risk for this particular subject (with their specific characteristics) divided by the risk of the population in general.  (Numbers greater than 1 = higher risk than the population, numbers less than 1 = lower risk.).", 0, 1, this.relativeRisk);
                }
                case 1312831238: {
                    return new Property("when[x]", "Period|Range", "Indicates the period of time or age range of the subject to which the specified probability applies.", 0, 1, this.when);
                }
                case 3648314: {
                    return new Property("when[x]", "Period|Range", "Indicates the period of time or age range of the subject to which the specified probability applies.", 0, 1, this.when);
                }
                case 251476379: {
                    return new Property("when[x]", "Period|Range", "Indicates the period of time or age range of the subject to which the specified probability applies.", 0, 1, this.when);
                }
                case -1098542557: {
                    return new Property("when[x]", "Period|Range", "Indicates the period of time or age range of the subject to which the specified probability applies.", 0, 1, this.when);
                }
                case 345689335: {
                    return new Property("rationale", "string", "Additional information explaining the basis for the prediction.", 0, 1, this.rationale);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1106507950: {
                    Base[] baseArray;
                    if (this.outcome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.outcome;
                    }
                    return baseArray;
                }
                case -1290561483: {
                    Base[] baseArray;
                    if (this.probability == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.probability;
                    }
                    return baseArray;
                }
                case 123308730: {
                    Base[] baseArray;
                    if (this.qualitativeRisk == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.qualitativeRisk;
                    }
                    return baseArray;
                }
                case -70741061: {
                    Base[] baseArray;
                    if (this.relativeRisk == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.relativeRisk;
                    }
                    return baseArray;
                }
                case 3648314: {
                    Base[] baseArray;
                    if (this.when == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.when;
                    }
                    return baseArray;
                }
                case 345689335: {
                    Base[] baseArray;
                    if (this.rationale == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.rationale;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1106507950: {
                    this.outcome = this.castToCodeableConcept(value);
                    return value;
                }
                case -1290561483: {
                    this.probability = this.castToType(value);
                    return value;
                }
                case 123308730: {
                    this.qualitativeRisk = this.castToCodeableConcept(value);
                    return value;
                }
                case -70741061: {
                    this.relativeRisk = this.castToDecimal(value);
                    return value;
                }
                case 3648314: {
                    this.when = this.castToType(value);
                    return value;
                }
                case 345689335: {
                    this.rationale = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("outcome")) {
                this.outcome = this.castToCodeableConcept(value);
            } else if (name.equals("probability[x]")) {
                this.probability = this.castToType(value);
            } else if (name.equals("qualitativeRisk")) {
                this.qualitativeRisk = this.castToCodeableConcept(value);
            } else if (name.equals("relativeRisk")) {
                this.relativeRisk = this.castToDecimal(value);
            } else if (name.equals("when[x]")) {
                this.when = this.castToType(value);
            } else if (name.equals("rationale")) {
                this.rationale = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1106507950: {
                    return this.getOutcome();
                }
                case 1430185003: {
                    return this.getProbability();
                }
                case -1290561483: {
                    return this.getProbability();
                }
                case 123308730: {
                    return this.getQualitativeRisk();
                }
                case -70741061: {
                    return this.getRelativeRiskElement();
                }
                case 1312831238: {
                    return this.getWhen();
                }
                case 3648314: {
                    return this.getWhen();
                }
                case 345689335: {
                    return this.getRationaleElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1106507950: {
                    return new String[]{"CodeableConcept"};
                }
                case -1290561483: {
                    return new String[]{"decimal", "Range"};
                }
                case 123308730: {
                    return new String[]{"CodeableConcept"};
                }
                case -70741061: {
                    return new String[]{"decimal"};
                }
                case 3648314: {
                    return new String[]{"Period", "Range"};
                }
                case 345689335: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("outcome")) {
                this.outcome = new CodeableConcept();
                return this.outcome;
            }
            if (name.equals("probabilityDecimal")) {
                this.probability = new DecimalType();
                return this.probability;
            }
            if (name.equals("probabilityRange")) {
                this.probability = new Range();
                return this.probability;
            }
            if (name.equals("qualitativeRisk")) {
                this.qualitativeRisk = new CodeableConcept();
                return this.qualitativeRisk;
            }
            if (name.equals("relativeRisk")) {
                throw new FHIRException("Cannot call addChild on a singleton property RiskAssessment.relativeRisk");
            }
            if (name.equals("whenPeriod")) {
                this.when = new Period();
                return this.when;
            }
            if (name.equals("whenRange")) {
                this.when = new Range();
                return this.when;
            }
            if (name.equals("rationale")) {
                throw new FHIRException("Cannot call addChild on a singleton property RiskAssessment.rationale");
            }
            return super.addChild(name);
        }

        @Override
        public RiskAssessmentPredictionComponent copy() {
            RiskAssessmentPredictionComponent dst = new RiskAssessmentPredictionComponent();
            this.copyValues(dst);
            dst.outcome = this.outcome == null ? null : this.outcome.copy();
            dst.probability = this.probability == null ? null : this.probability.copy();
            dst.qualitativeRisk = this.qualitativeRisk == null ? null : this.qualitativeRisk.copy();
            dst.relativeRisk = this.relativeRisk == null ? null : this.relativeRisk.copy();
            dst.when = this.when == null ? null : this.when.copy();
            dst.rationale = this.rationale == null ? null : this.rationale.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RiskAssessmentPredictionComponent)) {
                return false;
            }
            RiskAssessmentPredictionComponent o = (RiskAssessmentPredictionComponent)other_;
            return RiskAssessmentPredictionComponent.compareDeep(this.outcome, o.outcome, true) && RiskAssessmentPredictionComponent.compareDeep(this.probability, o.probability, true) && RiskAssessmentPredictionComponent.compareDeep(this.qualitativeRisk, o.qualitativeRisk, true) && RiskAssessmentPredictionComponent.compareDeep(this.relativeRisk, o.relativeRisk, true) && RiskAssessmentPredictionComponent.compareDeep(this.when, o.when, true) && RiskAssessmentPredictionComponent.compareDeep(this.rationale, o.rationale, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RiskAssessmentPredictionComponent)) {
                return false;
            }
            RiskAssessmentPredictionComponent o = (RiskAssessmentPredictionComponent)other_;
            return RiskAssessmentPredictionComponent.compareValues(this.relativeRisk, o.relativeRisk, true) && RiskAssessmentPredictionComponent.compareValues(this.rationale, o.rationale, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.outcome, this.probability, this.qualitativeRisk, this.relativeRisk, this.when, this.rationale});
        }

        @Override
        public String fhirType() {
            return "RiskAssessment.prediction";
        }
    }

    public static class RiskAssessmentStatusEnumFactory
    implements EnumFactory<RiskAssessmentStatus> {
        @Override
        public RiskAssessmentStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return RiskAssessmentStatus.REGISTERED;
            }
            if ("preliminary".equals(codeString)) {
                return RiskAssessmentStatus.PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return RiskAssessmentStatus.FINAL;
            }
            if ("amended".equals(codeString)) {
                return RiskAssessmentStatus.AMENDED;
            }
            if ("corrected".equals(codeString)) {
                return RiskAssessmentStatus.CORRECTED;
            }
            if ("cancelled".equals(codeString)) {
                return RiskAssessmentStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return RiskAssessmentStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return RiskAssessmentStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown RiskAssessmentStatus code '" + codeString + "'");
        }

        public Enumeration<RiskAssessmentStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RiskAssessmentStatus>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return new Enumeration<RiskAssessmentStatus>(this, RiskAssessmentStatus.REGISTERED);
            }
            if ("preliminary".equals(codeString)) {
                return new Enumeration<RiskAssessmentStatus>(this, RiskAssessmentStatus.PRELIMINARY);
            }
            if ("final".equals(codeString)) {
                return new Enumeration<RiskAssessmentStatus>(this, RiskAssessmentStatus.FINAL);
            }
            if ("amended".equals(codeString)) {
                return new Enumeration<RiskAssessmentStatus>(this, RiskAssessmentStatus.AMENDED);
            }
            if ("corrected".equals(codeString)) {
                return new Enumeration<RiskAssessmentStatus>(this, RiskAssessmentStatus.CORRECTED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<RiskAssessmentStatus>(this, RiskAssessmentStatus.CANCELLED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<RiskAssessmentStatus>(this, RiskAssessmentStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<RiskAssessmentStatus>(this, RiskAssessmentStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown RiskAssessmentStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(RiskAssessmentStatus code) {
            if (code == RiskAssessmentStatus.REGISTERED) {
                return "registered";
            }
            if (code == RiskAssessmentStatus.PRELIMINARY) {
                return "preliminary";
            }
            if (code == RiskAssessmentStatus.FINAL) {
                return "final";
            }
            if (code == RiskAssessmentStatus.AMENDED) {
                return "amended";
            }
            if (code == RiskAssessmentStatus.CORRECTED) {
                return "corrected";
            }
            if (code == RiskAssessmentStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == RiskAssessmentStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == RiskAssessmentStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(RiskAssessmentStatus code) {
            return code.getSystem();
        }
    }

    public static enum RiskAssessmentStatus {
        REGISTERED,
        PRELIMINARY,
        FINAL,
        AMENDED,
        CORRECTED,
        CANCELLED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static RiskAssessmentStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return REGISTERED;
            }
            if ("preliminary".equals(codeString)) {
                return PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return FINAL;
            }
            if ("amended".equals(codeString)) {
                return AMENDED;
            }
            if ("corrected".equals(codeString)) {
                return CORRECTED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RiskAssessmentStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REGISTERED: {
                    return "registered";
                }
                case PRELIMINARY: {
                    return "preliminary";
                }
                case FINAL: {
                    return "final";
                }
                case AMENDED: {
                    return "amended";
                }
                case CORRECTED: {
                    return "corrected";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REGISTERED: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case PRELIMINARY: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case FINAL: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case AMENDED: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case CORRECTED: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REGISTERED: {
                    return "The existence of the observation is registered, but there is no result yet available.";
                }
                case PRELIMINARY: {
                    return "This is an initial or interim observation: data may be incomplete or unverified.";
                }
                case FINAL: {
                    return "The observation is complete.";
                }
                case AMENDED: {
                    return "Subsequent to being Final, the observation has been modified subsequent.  This includes updates/new information and corrections.";
                }
                case CORRECTED: {
                    return "Subsequent to being Final, the observation has been modified to correct an error in the test result.";
                }
                case CANCELLED: {
                    return "The observation is unavailable because the measurement was not started or not completed (also sometimes called \"aborted\").";
                }
                case ENTEREDINERROR: {
                    return "The observation has been withdrawn following previous final release.  This electronic record should never have existed, though it is possible that real-world decisions were based on it. (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".)";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values currently applies for this request. Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, but the authoring system does not know which.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REGISTERED: {
                    return "Registered";
                }
                case PRELIMINARY: {
                    return "Preliminary";
                }
                case FINAL: {
                    return "Final";
                }
                case AMENDED: {
                    return "Amended";
                }
                case CORRECTED: {
                    return "Corrected";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

