/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SearchParameter", profile="http://hl7.org/fhir/Profile/SearchParameter")
@ChildOrder(names={"url", "version", "name", "status", "experimental", "date", "publisher", "contact", "useContext", "jurisdiction", "purpose", "code", "base", "type", "derivedFrom", "description", "expression", "xpath", "xpathUsage", "target", "comparator", "modifier", "chain", "component"})
public class SearchParameter
extends MetadataResource {
    @Child(name="purpose", type={MarkdownType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this search parameter is defined", formalDefinition="Explaination of why this search parameter is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Code used in URL", formalDefinition="The code used in the URL or the parameter name in a parameters resource for this search parameter.")
    protected CodeType code;
    @Child(name="base", type={CodeType.class}, order=2, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The resource type(s) this search parameter applies to", formalDefinition="The base resource type(s) that this search parameter can be used against.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
    protected List<CodeType> base;
    @Child(name="type", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="number | date | string | token | reference | composite | quantity | uri", formalDefinition="The type of value a search parameter refers to, and how the content is interpreted.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-param-type")
    protected Enumeration<Enumerations.SearchParamType> type;
    @Child(name="derivedFrom", type={UriType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Original Definition for the search parameter", formalDefinition="Where this search parameter is originally defined. If a derivedFrom is provided, then the details in the search parameter must be consistent with the definition from which it is defined. I.e. the parameter should have the same meaning, and (usually) the functionality should be a proper subset of the underlying search parameter.")
    protected UriType derivedFrom;
    @Child(name="expression", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="FHIRPath expression that extracts the values", formalDefinition="A FHIRPath expression that returns a set of elements for the search parameter.")
    protected StringType expression;
    @Child(name="xpath", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="XPath that extracts the values", formalDefinition="An XPath expression that returns a set of elements for the search parameter.")
    protected StringType xpath;
    @Child(name="xpathUsage", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="normal | phonetic | nearby | distance | other", formalDefinition="How the search parameter relates to the set of elements returned by evaluating the xpath query.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-xpath-usage")
    protected Enumeration<XPathUsageType> xpathUsage;
    @Child(name="target", type={CodeType.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Types of resource (if a resource reference)", formalDefinition="Types of resource (if a resource is referenced).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
    protected List<CodeType> target;
    @Child(name="comparator", type={CodeType.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="eq | ne | gt | lt | ge | le | sa | eb | ap", formalDefinition="Comparators supported for the search parameter.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-comparator")
    protected List<Enumeration<SearchComparator>> comparator;
    @Child(name="modifier", type={CodeType.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="missing | exact | contains | not | text | in | not-in | below | above | type", formalDefinition="A modifier supported for the search parameter.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-modifier-code")
    protected List<Enumeration<SearchModifierCode>> modifier;
    @Child(name="chain", type={StringType.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Chained names supported", formalDefinition="Contains the names of any search parameters which may be chained to the containing search parameter. Chained parameters may be added to search parameters of type reference, and specify that resources will only be returned if they contain a reference to a resource which matches the chained parameter value. Values for this field should be drawn from SearchParameter.code for a parameter on the target resource type.")
    protected List<StringType> chain;
    @Child(name="component", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="For Composite resources to define the parts", formalDefinition="Used to define the parts of a composite search parameter.")
    protected List<SearchParameterComponentComponent> component;
    private static final long serialVersionUID = -769368159L;
    @SearchParamDefinition(name="date", path="SearchParameter.date", description="The search parameter publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="code", path="SearchParameter.code", description="Code used in URL", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="jurisdiction", path="SearchParameter.jurisdiction", description="Intended jurisdiction for the search parameter", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="description", path="SearchParameter.description", description="The description of the search parameter", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="derived-from", path="SearchParameter.derivedFrom", description="Original Definition for the search parameter", type="uri")
    public static final String SP_DERIVED_FROM = "derived-from";
    public static final UriClientParam DERIVED_FROM = new UriClientParam("derived-from");
    @SearchParamDefinition(name="type", path="SearchParameter.type", description="number | date | string | token | reference | composite | quantity | uri", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="version", path="SearchParameter.version", description="The business version of the search parameter", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="SearchParameter.url", description="The uri that identifies the search parameter", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="target", path="SearchParameter.target", description="Types of resource (if a resource reference)", type="token")
    public static final String SP_TARGET = "target";
    public static final TokenClientParam TARGET = new TokenClientParam("target");
    @SearchParamDefinition(name="component", path="SearchParameter.component.definition", description="Defines how the part works", type="reference", target={SearchParameter.class})
    public static final String SP_COMPONENT = "component";
    public static final ReferenceClientParam COMPONENT = new ReferenceClientParam("component");
    public static final Include INCLUDE_COMPONENT = new Include("SearchParameter:component").toLocked();
    @SearchParamDefinition(name="name", path="SearchParameter.name", description="Computationally friendly name of the search parameter", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="SearchParameter.publisher", description="Name of the publisher of the search parameter", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="SearchParameter.status", description="The current status of the search parameter", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="base", path="SearchParameter.base", description="The resource type(s) this search parameter applies to", type="token")
    public static final String SP_BASE = "base";
    public static final TokenClientParam BASE = new TokenClientParam("base");

    public SearchParameter() {
    }

    public SearchParameter(UriType url, StringType name, Enumeration<Enumerations.PublicationStatus> status, CodeType code, Enumeration<Enumerations.SearchParamType> type, MarkdownType description) {
        this.url = url;
        this.name = name;
        this.status = status;
        this.code = code;
        this.type = type;
        this.description = description;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public SearchParameter setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public SearchParameter setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public SearchParameter setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public SearchParameter setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public SearchParameter setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public SearchParameter setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public SearchParameter setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public SearchParameter setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public SearchParameter setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public SearchParameter setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public SearchParameter setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public SearchParameter setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public SearchParameter setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public SearchParameter setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public SearchParameter setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public SearchParameter addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public SearchParameter setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public SearchParameter addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public SearchParameter setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public SearchParameter addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public SearchParameter setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public SearchParameter setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public CodeType getCodeElement() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeType();
            }
        }
        return this.code;
    }

    public boolean hasCodeElement() {
        return this.code != null && !this.code.isEmpty();
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public SearchParameter setCodeElement(CodeType value) {
        this.code = value;
        return this;
    }

    public String getCode() {
        return this.code == null ? null : (String)this.code.getValue();
    }

    public SearchParameter setCode(String value) {
        if (this.code == null) {
            this.code = new CodeType();
        }
        this.code.setValue(value);
        return this;
    }

    public List<CodeType> getBase() {
        if (this.base == null) {
            this.base = new ArrayList<CodeType>();
        }
        return this.base;
    }

    public SearchParameter setBase(List<CodeType> theBase) {
        this.base = theBase;
        return this;
    }

    public boolean hasBase() {
        if (this.base == null) {
            return false;
        }
        for (CodeType item : this.base) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addBaseElement() {
        CodeType t = new CodeType();
        if (this.base == null) {
            this.base = new ArrayList<CodeType>();
        }
        this.base.add(t);
        return t;
    }

    public SearchParameter addBase(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.base == null) {
            this.base = new ArrayList<CodeType>();
        }
        this.base.add(t);
        return this;
    }

    public boolean hasBase(String value) {
        if (this.base == null) {
            return false;
        }
        for (CodeType v : this.base) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<Enumerations.SearchParamType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public SearchParameter setTypeElement(Enumeration<Enumerations.SearchParamType> value) {
        this.type = value;
        return this;
    }

    public Enumerations.SearchParamType getType() {
        return this.type == null ? null : (Enumerations.SearchParamType)((Object)this.type.getValue());
    }

    public SearchParameter setType(Enumerations.SearchParamType value) {
        if (this.type == null) {
            this.type = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public UriType getDerivedFromElement() {
        if (this.derivedFrom == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.derivedFrom");
            }
            if (Configuration.doAutoCreate()) {
                this.derivedFrom = new UriType();
            }
        }
        return this.derivedFrom;
    }

    public boolean hasDerivedFromElement() {
        return this.derivedFrom != null && !this.derivedFrom.isEmpty();
    }

    public boolean hasDerivedFrom() {
        return this.derivedFrom != null && !this.derivedFrom.isEmpty();
    }

    public SearchParameter setDerivedFromElement(UriType value) {
        this.derivedFrom = value;
        return this;
    }

    public String getDerivedFrom() {
        return this.derivedFrom == null ? null : (String)this.derivedFrom.getValue();
    }

    public SearchParameter setDerivedFrom(String value) {
        if (Utilities.noString((String)value)) {
            this.derivedFrom = null;
        } else {
            if (this.derivedFrom == null) {
                this.derivedFrom = new UriType();
            }
            this.derivedFrom.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public SearchParameter setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public SearchParameter setDescription(String value) {
        if (this.description == null) {
            this.description = new MarkdownType();
        }
        this.description.setValue(value);
        return this;
    }

    public StringType getExpressionElement() {
        if (this.expression == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.expression");
            }
            if (Configuration.doAutoCreate()) {
                this.expression = new StringType();
            }
        }
        return this.expression;
    }

    public boolean hasExpressionElement() {
        return this.expression != null && !this.expression.isEmpty();
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isEmpty();
    }

    public SearchParameter setExpressionElement(StringType value) {
        this.expression = value;
        return this;
    }

    public String getExpression() {
        return this.expression == null ? null : (String)this.expression.getValue();
    }

    public SearchParameter setExpression(String value) {
        if (Utilities.noString((String)value)) {
            this.expression = null;
        } else {
            if (this.expression == null) {
                this.expression = new StringType();
            }
            this.expression.setValue(value);
        }
        return this;
    }

    public StringType getXpathElement() {
        if (this.xpath == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.xpath");
            }
            if (Configuration.doAutoCreate()) {
                this.xpath = new StringType();
            }
        }
        return this.xpath;
    }

    public boolean hasXpathElement() {
        return this.xpath != null && !this.xpath.isEmpty();
    }

    public boolean hasXpath() {
        return this.xpath != null && !this.xpath.isEmpty();
    }

    public SearchParameter setXpathElement(StringType value) {
        this.xpath = value;
        return this;
    }

    public String getXpath() {
        return this.xpath == null ? null : (String)this.xpath.getValue();
    }

    public SearchParameter setXpath(String value) {
        if (Utilities.noString((String)value)) {
            this.xpath = null;
        } else {
            if (this.xpath == null) {
                this.xpath = new StringType();
            }
            this.xpath.setValue(value);
        }
        return this;
    }

    public Enumeration<XPathUsageType> getXpathUsageElement() {
        if (this.xpathUsage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.xpathUsage");
            }
            if (Configuration.doAutoCreate()) {
                this.xpathUsage = new Enumeration<XPathUsageType>(new XPathUsageTypeEnumFactory());
            }
        }
        return this.xpathUsage;
    }

    public boolean hasXpathUsageElement() {
        return this.xpathUsage != null && !this.xpathUsage.isEmpty();
    }

    public boolean hasXpathUsage() {
        return this.xpathUsage != null && !this.xpathUsage.isEmpty();
    }

    public SearchParameter setXpathUsageElement(Enumeration<XPathUsageType> value) {
        this.xpathUsage = value;
        return this;
    }

    public XPathUsageType getXpathUsage() {
        return this.xpathUsage == null ? null : (XPathUsageType)((Object)this.xpathUsage.getValue());
    }

    public SearchParameter setXpathUsage(XPathUsageType value) {
        if (value == null) {
            this.xpathUsage = null;
        } else {
            if (this.xpathUsage == null) {
                this.xpathUsage = new Enumeration<XPathUsageType>(new XPathUsageTypeEnumFactory());
            }
            this.xpathUsage.setValue((Object)value);
        }
        return this;
    }

    public List<CodeType> getTarget() {
        if (this.target == null) {
            this.target = new ArrayList<CodeType>();
        }
        return this.target;
    }

    public SearchParameter setTarget(List<CodeType> theTarget) {
        this.target = theTarget;
        return this;
    }

    public boolean hasTarget() {
        if (this.target == null) {
            return false;
        }
        for (CodeType item : this.target) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addTargetElement() {
        CodeType t = new CodeType();
        if (this.target == null) {
            this.target = new ArrayList<CodeType>();
        }
        this.target.add(t);
        return t;
    }

    public SearchParameter addTarget(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.target == null) {
            this.target = new ArrayList<CodeType>();
        }
        this.target.add(t);
        return this;
    }

    public boolean hasTarget(String value) {
        if (this.target == null) {
            return false;
        }
        for (CodeType v : this.target) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<Enumeration<SearchComparator>> getComparator() {
        if (this.comparator == null) {
            this.comparator = new ArrayList<Enumeration<SearchComparator>>();
        }
        return this.comparator;
    }

    public SearchParameter setComparator(List<Enumeration<SearchComparator>> theComparator) {
        this.comparator = theComparator;
        return this;
    }

    public boolean hasComparator() {
        if (this.comparator == null) {
            return false;
        }
        for (Enumeration<SearchComparator> item : this.comparator) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<SearchComparator> addComparatorElement() {
        Enumeration<SearchComparator> t = new Enumeration<SearchComparator>(new SearchComparatorEnumFactory());
        if (this.comparator == null) {
            this.comparator = new ArrayList<Enumeration<SearchComparator>>();
        }
        this.comparator.add(t);
        return t;
    }

    public SearchParameter addComparator(SearchComparator value) {
        Enumeration<SearchComparator> t = new Enumeration<SearchComparator>(new SearchComparatorEnumFactory());
        t.setValue((Object)value);
        if (this.comparator == null) {
            this.comparator = new ArrayList<Enumeration<SearchComparator>>();
        }
        this.comparator.add(t);
        return this;
    }

    public boolean hasComparator(SearchComparator value) {
        if (this.comparator == null) {
            return false;
        }
        for (Enumeration<SearchComparator> v : this.comparator) {
            if (!((SearchComparator)((Object)v.getValue())).equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public List<Enumeration<SearchModifierCode>> getModifier() {
        if (this.modifier == null) {
            this.modifier = new ArrayList<Enumeration<SearchModifierCode>>();
        }
        return this.modifier;
    }

    public SearchParameter setModifier(List<Enumeration<SearchModifierCode>> theModifier) {
        this.modifier = theModifier;
        return this;
    }

    public boolean hasModifier() {
        if (this.modifier == null) {
            return false;
        }
        for (Enumeration<SearchModifierCode> item : this.modifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<SearchModifierCode> addModifierElement() {
        Enumeration<SearchModifierCode> t = new Enumeration<SearchModifierCode>(new SearchModifierCodeEnumFactory());
        if (this.modifier == null) {
            this.modifier = new ArrayList<Enumeration<SearchModifierCode>>();
        }
        this.modifier.add(t);
        return t;
    }

    public SearchParameter addModifier(SearchModifierCode value) {
        Enumeration<SearchModifierCode> t = new Enumeration<SearchModifierCode>(new SearchModifierCodeEnumFactory());
        t.setValue((Object)value);
        if (this.modifier == null) {
            this.modifier = new ArrayList<Enumeration<SearchModifierCode>>();
        }
        this.modifier.add(t);
        return this;
    }

    public boolean hasModifier(SearchModifierCode value) {
        if (this.modifier == null) {
            return false;
        }
        for (Enumeration<SearchModifierCode> v : this.modifier) {
            if (!((SearchModifierCode)((Object)v.getValue())).equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public List<StringType> getChain() {
        if (this.chain == null) {
            this.chain = new ArrayList<StringType>();
        }
        return this.chain;
    }

    public SearchParameter setChain(List<StringType> theChain) {
        this.chain = theChain;
        return this;
    }

    public boolean hasChain() {
        if (this.chain == null) {
            return false;
        }
        for (StringType item : this.chain) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addChainElement() {
        StringType t = new StringType();
        if (this.chain == null) {
            this.chain = new ArrayList<StringType>();
        }
        this.chain.add(t);
        return t;
    }

    public SearchParameter addChain(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.chain == null) {
            this.chain = new ArrayList<StringType>();
        }
        this.chain.add(t);
        return this;
    }

    public boolean hasChain(String value) {
        if (this.chain == null) {
            return false;
        }
        for (StringType v : this.chain) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<SearchParameterComponentComponent> getComponent() {
        if (this.component == null) {
            this.component = new ArrayList<SearchParameterComponentComponent>();
        }
        return this.component;
    }

    public SearchParameter setComponent(List<SearchParameterComponentComponent> theComponent) {
        this.component = theComponent;
        return this;
    }

    public boolean hasComponent() {
        if (this.component == null) {
            return false;
        }
        for (SearchParameterComponentComponent item : this.component) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SearchParameterComponentComponent addComponent() {
        SearchParameterComponentComponent t = new SearchParameterComponentComponent();
        if (this.component == null) {
            this.component = new ArrayList<SearchParameterComponentComponent>();
        }
        this.component.add(t);
        return t;
    }

    public SearchParameter addComponent(SearchParameterComponentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.component == null) {
            this.component = new ArrayList<SearchParameterComponentComponent>();
        }
        this.component.add(t);
        return this;
    }

    public SearchParameterComponentComponent getComponentFirstRep() {
        if (this.getComponent().isEmpty()) {
            this.addComponent();
        }
        return this.getComponent().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this search parameter when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this search parameter is (or will be) published. The URL SHOULD include the major version of the search parameter. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the search parameter when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the search parameter author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the search parameter. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_STATUS, SP_CODE, "The status of this search parameter. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A boolean value to indicate that this search parameter is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the search parameter was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the search parameter changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the search parameter.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate search parameter instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the search parameter is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explaination of why this search parameter is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property(SP_CODE, SP_CODE, "The code used in the URL or the parameter name in a parameters resource for this search parameter.", 0, 1, this.code));
        children.add(new Property(SP_BASE, SP_CODE, "The base resource type(s) that this search parameter can be used against.", 0, Integer.MAX_VALUE, this.base));
        children.add(new Property(SP_TYPE, SP_CODE, "The type of value a search parameter refers to, and how the content is interpreted.", 0, 1, this.type));
        children.add(new Property("derivedFrom", "uri", "Where this search parameter is originally defined. If a derivedFrom is provided, then the details in the search parameter must be consistent with the definition from which it is defined. I.e. the parameter should have the same meaning, and (usually) the functionality should be a proper subset of the underlying search parameter.", 0, 1, this.derivedFrom));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the search parameter from a consumer's perspective. and how it used.", 0, 1, this.description));
        children.add(new Property("expression", "string", "A FHIRPath expression that returns a set of elements for the search parameter.", 0, 1, this.expression));
        children.add(new Property("xpath", "string", "An XPath expression that returns a set of elements for the search parameter.", 0, 1, this.xpath));
        children.add(new Property("xpathUsage", SP_CODE, "How the search parameter relates to the set of elements returned by evaluating the xpath query.", 0, 1, this.xpathUsage));
        children.add(new Property(SP_TARGET, SP_CODE, "Types of resource (if a resource is referenced).", 0, Integer.MAX_VALUE, this.target));
        children.add(new Property("comparator", SP_CODE, "Comparators supported for the search parameter.", 0, Integer.MAX_VALUE, this.comparator));
        children.add(new Property("modifier", SP_CODE, "A modifier supported for the search parameter.", 0, Integer.MAX_VALUE, this.modifier));
        children.add(new Property("chain", "string", "Contains the names of any search parameters which may be chained to the containing search parameter. Chained parameters may be added to search parameters of type reference, and specify that resources will only be returned if they contain a reference to a resource which matches the chained parameter value. Values for this field should be drawn from SearchParameter.code for a parameter on the target resource type.", 0, Integer.MAX_VALUE, this.chain));
        children.add(new Property(SP_COMPONENT, "", "Used to define the parts of a composite search parameter.", 0, Integer.MAX_VALUE, this.component));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this search parameter when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this search parameter is (or will be) published. The URL SHOULD include the major version of the search parameter. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the search parameter when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the search parameter author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the search parameter. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The status of this search parameter. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A boolean value to indicate that this search parameter is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the search parameter was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the search parameter changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the search parameter.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate search parameter instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the search parameter is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explaination of why this search parameter is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 3059181: {
                return new Property(SP_CODE, SP_CODE, "The code used in the URL or the parameter name in a parameters resource for this search parameter.", 0, 1, this.code);
            }
            case 3016401: {
                return new Property(SP_BASE, SP_CODE, "The base resource type(s) that this search parameter can be used against.", 0, Integer.MAX_VALUE, this.base);
            }
            case 3575610: {
                return new Property(SP_TYPE, SP_CODE, "The type of value a search parameter refers to, and how the content is interpreted.", 0, 1, this.type);
            }
            case 1077922663: {
                return new Property("derivedFrom", "uri", "Where this search parameter is originally defined. If a derivedFrom is provided, then the details in the search parameter must be consistent with the definition from which it is defined. I.e. the parameter should have the same meaning, and (usually) the functionality should be a proper subset of the underlying search parameter.", 0, 1, this.derivedFrom);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the search parameter from a consumer's perspective. and how it used.", 0, 1, this.description);
            }
            case -1795452264: {
                return new Property("expression", "string", "A FHIRPath expression that returns a set of elements for the search parameter.", 0, 1, this.expression);
            }
            case 114256029: {
                return new Property("xpath", "string", "An XPath expression that returns a set of elements for the search parameter.", 0, 1, this.xpath);
            }
            case 1801322244: {
                return new Property("xpathUsage", SP_CODE, "How the search parameter relates to the set of elements returned by evaluating the xpath query.", 0, 1, this.xpathUsage);
            }
            case -880905839: {
                return new Property(SP_TARGET, SP_CODE, "Types of resource (if a resource is referenced).", 0, Integer.MAX_VALUE, this.target);
            }
            case -844673834: {
                return new Property("comparator", SP_CODE, "Comparators supported for the search parameter.", 0, Integer.MAX_VALUE, this.comparator);
            }
            case -615513385: {
                return new Property("modifier", SP_CODE, "A modifier supported for the search parameter.", 0, Integer.MAX_VALUE, this.modifier);
            }
            case 94623425: {
                return new Property("chain", "string", "Contains the names of any search parameters which may be chained to the containing search parameter. Chained parameters may be added to search parameters of type reference, and specify that resources will only be returned if they contain a reference to a resource which matches the chained parameter value. Values for this field should be drawn from SearchParameter.code for a parameter on the target resource type.", 0, Integer.MAX_VALUE, this.chain);
            }
            case -1399907075: {
                return new Property(SP_COMPONENT, "", "Used to define the parts of a composite search parameter.", 0, Integer.MAX_VALUE, this.component);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.purpose;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.code;
                }
                return baseArray;
            }
            case 3016401: {
                return this.base == null ? new Base[]{} : this.base.toArray(new Base[this.base.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.type;
                }
                return baseArray;
            }
            case 1077922663: {
                Base[] baseArray;
                if (this.derivedFrom == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.derivedFrom;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.description;
                }
                return baseArray;
            }
            case -1795452264: {
                Base[] baseArray;
                if (this.expression == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.expression;
                }
                return baseArray;
            }
            case 114256029: {
                Base[] baseArray;
                if (this.xpath == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.xpath;
                }
                return baseArray;
            }
            case 1801322244: {
                Base[] baseArray;
                if (this.xpathUsage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.xpathUsage;
                }
                return baseArray;
            }
            case -880905839: {
                return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
            }
            case -844673834: {
                return this.comparator == null ? new Base[]{} : this.comparator.toArray(new Base[this.comparator.size()]);
            }
            case -615513385: {
                return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
            }
            case 94623425: {
                return this.chain == null ? new Base[]{} : this.chain.toArray(new Base[this.chain.size()]);
            }
            case -1399907075: {
                return this.component == null ? new Base[]{} : this.component.toArray(new Base[this.component.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case 3059181: {
                this.code = this.castToCode(value);
                return value;
            }
            case 3016401: {
                this.getBase().add(this.castToCode(value));
                return value;
            }
            case 3575610: {
                value = new Enumerations.SearchParamTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
                return value;
            }
            case 1077922663: {
                this.derivedFrom = this.castToUri(value);
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -1795452264: {
                this.expression = this.castToString(value);
                return value;
            }
            case 114256029: {
                this.xpath = this.castToString(value);
                return value;
            }
            case 1801322244: {
                value = new XPathUsageTypeEnumFactory().fromType(this.castToCode(value));
                this.xpathUsage = value;
                return value;
            }
            case -880905839: {
                this.getTarget().add(this.castToCode(value));
                return value;
            }
            case -844673834: {
                value = new SearchComparatorEnumFactory().fromType(this.castToCode(value));
                this.getComparator().add(value);
                return value;
            }
            case -615513385: {
                value = new SearchModifierCodeEnumFactory().fromType(this.castToCode(value));
                this.getModifier().add(value);
                return value;
            }
            case 94623425: {
                this.getChain().add(this.castToString(value));
                return value;
            }
            case -1399907075: {
                this.getComponent().add((SearchParameterComponentComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCode(value);
        } else if (name.equals(SP_BASE)) {
            this.getBase().add(this.castToCode(value));
        } else if (name.equals(SP_TYPE)) {
            value = new Enumerations.SearchParamTypeEnumFactory().fromType(this.castToCode(value));
            this.type = value;
        } else if (name.equals("derivedFrom")) {
            this.derivedFrom = this.castToUri(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("expression")) {
            this.expression = this.castToString(value);
        } else if (name.equals("xpath")) {
            this.xpath = this.castToString(value);
        } else if (name.equals("xpathUsage")) {
            value = new XPathUsageTypeEnumFactory().fromType(this.castToCode(value));
            this.xpathUsage = value;
        } else if (name.equals(SP_TARGET)) {
            this.getTarget().add(this.castToCode(value));
        } else if (name.equals("comparator")) {
            value = new SearchComparatorEnumFactory().fromType(this.castToCode(value));
            this.getComparator().add(value);
        } else if (name.equals("modifier")) {
            value = new SearchModifierCodeEnumFactory().fromType(this.castToCode(value));
            this.getModifier().add(value);
        } else if (name.equals("chain")) {
            this.getChain().add(this.castToString(value));
        } else if (name.equals(SP_COMPONENT)) {
            this.getComponent().add((SearchParameterComponentComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 3059181: {
                return this.getCodeElement();
            }
            case 3016401: {
                return this.addBaseElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case 1077922663: {
                return this.getDerivedFromElement();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -1795452264: {
                return this.getExpressionElement();
            }
            case 114256029: {
                return this.getXpathElement();
            }
            case 1801322244: {
                return this.getXpathUsageElement();
            }
            case -880905839: {
                return this.addTargetElement();
            }
            case -844673834: {
                return this.addComparatorElement();
            }
            case -615513385: {
                return this.addModifierElement();
            }
            case 94623425: {
                return this.addChainElement();
            }
            case -1399907075: {
                return this.addComponent();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 3059181: {
                return new String[]{SP_CODE};
            }
            case 3016401: {
                return new String[]{SP_CODE};
            }
            case 3575610: {
                return new String[]{SP_CODE};
            }
            case 1077922663: {
                return new String[]{"uri"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -1795452264: {
                return new String[]{"string"};
            }
            case 114256029: {
                return new String[]{"string"};
            }
            case 1801322244: {
                return new String[]{SP_CODE};
            }
            case -880905839: {
                return new String[]{SP_CODE};
            }
            case -844673834: {
                return new String[]{SP_CODE};
            }
            case -615513385: {
                return new String[]{SP_CODE};
            }
            case 94623425: {
                return new String[]{"string"};
            }
            case -1399907075: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.purpose");
        }
        if (name.equals(SP_CODE)) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.code");
        }
        if (name.equals(SP_BASE)) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.base");
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.type");
        }
        if (name.equals("derivedFrom")) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.derivedFrom");
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.description");
        }
        if (name.equals("expression")) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.expression");
        }
        if (name.equals("xpath")) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.xpath");
        }
        if (name.equals("xpathUsage")) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.xpathUsage");
        }
        if (name.equals(SP_TARGET)) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.target");
        }
        if (name.equals("comparator")) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.comparator");
        }
        if (name.equals("modifier")) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.modifier");
        }
        if (name.equals("chain")) {
            throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.chain");
        }
        if (name.equals(SP_COMPONENT)) {
            return this.addComponent();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SearchParameter";
    }

    @Override
    public SearchParameter copy() {
        SearchParameter dst = new SearchParameter();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        CodeType codeType = dst.code = this.code == null ? null : this.code.copy();
        if (this.base != null) {
            dst.base = new ArrayList<CodeType>();
            for (CodeType codeType2 : this.base) {
                dst.base.add(codeType2.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.derivedFrom = this.derivedFrom == null ? null : this.derivedFrom.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.expression = this.expression == null ? null : this.expression.copy();
        dst.xpath = this.xpath == null ? null : this.xpath.copy();
        Enumeration<XPathUsageType> enumeration = dst.xpathUsage = this.xpathUsage == null ? null : this.xpathUsage.copy();
        if (this.target != null) {
            dst.target = new ArrayList<CodeType>();
            for (CodeType codeType3 : this.target) {
                dst.target.add(codeType3.copy());
            }
        }
        if (this.comparator != null) {
            dst.comparator = new ArrayList<Enumeration<SearchComparator>>();
            for (Enumeration enumeration2 : this.comparator) {
                dst.comparator.add((Enumeration<SearchComparator>)enumeration2.copy());
            }
        }
        if (this.modifier != null) {
            dst.modifier = new ArrayList<Enumeration<SearchModifierCode>>();
            for (Enumeration enumeration3 : this.modifier) {
                dst.modifier.add((Enumeration<SearchModifierCode>)enumeration3.copy());
            }
        }
        if (this.chain != null) {
            dst.chain = new ArrayList<StringType>();
            for (StringType stringType2 : this.chain) {
                dst.chain.add(stringType2.copy());
            }
        }
        if (this.component != null) {
            dst.component = new ArrayList<SearchParameterComponentComponent>();
            for (SearchParameterComponentComponent searchParameterComponentComponent : this.component) {
                dst.component.add(searchParameterComponentComponent.copy());
            }
        }
        return dst;
    }

    protected SearchParameter typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SearchParameter)) {
            return false;
        }
        SearchParameter o = (SearchParameter)other_;
        return SearchParameter.compareDeep(this.purpose, o.purpose, true) && SearchParameter.compareDeep(this.code, o.code, true) && SearchParameter.compareDeep(this.base, o.base, true) && SearchParameter.compareDeep(this.type, o.type, true) && SearchParameter.compareDeep(this.derivedFrom, o.derivedFrom, true) && SearchParameter.compareDeep(this.expression, o.expression, true) && SearchParameter.compareDeep(this.xpath, o.xpath, true) && SearchParameter.compareDeep(this.xpathUsage, o.xpathUsage, true) && SearchParameter.compareDeep(this.target, o.target, true) && SearchParameter.compareDeep(this.comparator, o.comparator, true) && SearchParameter.compareDeep(this.modifier, o.modifier, true) && SearchParameter.compareDeep(this.chain, o.chain, true) && SearchParameter.compareDeep(this.component, o.component, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SearchParameter)) {
            return false;
        }
        SearchParameter o = (SearchParameter)other_;
        return SearchParameter.compareValues(this.purpose, o.purpose, true) && SearchParameter.compareValues(this.code, o.code, true) && SearchParameter.compareValues(this.base, o.base, true) && SearchParameter.compareValues(this.type, o.type, true) && SearchParameter.compareValues(this.derivedFrom, o.derivedFrom, true) && SearchParameter.compareValues(this.expression, o.expression, true) && SearchParameter.compareValues(this.xpath, o.xpath, true) && SearchParameter.compareValues(this.xpathUsage, o.xpathUsage, true) && SearchParameter.compareValues(this.target, o.target, true) && SearchParameter.compareValues(this.comparator, o.comparator, true) && SearchParameter.compareValues(this.modifier, o.modifier, true) && SearchParameter.compareValues(this.chain, o.chain, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.purpose, this.code, this.base, this.type, this.derivedFrom, this.expression, this.xpath, this.xpathUsage, this.target, this.comparator, this.modifier, this.chain, this.component});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SearchParameter;
    }

    @Block
    public static class SearchParameterComponentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="definition", type={SearchParameter.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Defines how the part works", formalDefinition="The definition of the search parameter that describes this part.")
        protected Reference definition;
        protected SearchParameter definitionTarget;
        @Child(name="expression", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Subexpression relative to main expression", formalDefinition="A sub-expression that defines how to extract values for this component from the output of the main SearchParameter.expression.")
        protected StringType expression;
        private static final long serialVersionUID = -1105563614L;

        public SearchParameterComponentComponent() {
        }

        public SearchParameterComponentComponent(Reference definition, StringType expression) {
            this.definition = definition;
            this.expression = expression;
        }

        public Reference getDefinition() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SearchParameterComponentComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new Reference();
                }
            }
            return this.definition;
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public SearchParameterComponentComponent setDefinition(Reference value) {
            this.definition = value;
            return this;
        }

        public SearchParameter getDefinitionTarget() {
            if (this.definitionTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SearchParameterComponentComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definitionTarget = new SearchParameter();
                }
            }
            return this.definitionTarget;
        }

        public SearchParameterComponentComponent setDefinitionTarget(SearchParameter value) {
            this.definitionTarget = value;
            return this;
        }

        public StringType getExpressionElement() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SearchParameterComponentComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new StringType();
                }
            }
            return this.expression;
        }

        public boolean hasExpressionElement() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public SearchParameterComponentComponent setExpressionElement(StringType value) {
            this.expression = value;
            return this;
        }

        public String getExpression() {
            return this.expression == null ? null : (String)this.expression.getValue();
        }

        public SearchParameterComponentComponent setExpression(String value) {
            if (this.expression == null) {
                this.expression = new StringType();
            }
            this.expression.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("definition", "Reference(SearchParameter)", "The definition of the search parameter that describes this part.", 0, 1, this.definition));
            children.add(new Property("expression", "string", "A sub-expression that defines how to extract values for this component from the output of the main SearchParameter.expression.", 0, 1, this.expression));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1014418093: {
                    return new Property("definition", "Reference(SearchParameter)", "The definition of the search parameter that describes this part.", 0, 1, this.definition);
                }
                case -1795452264: {
                    return new Property("expression", "string", "A sub-expression that defines how to extract values for this component from the output of the main SearchParameter.expression.", 0, 1, this.expression);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.definition;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.expression;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1014418093: {
                    this.definition = this.castToReference(value);
                    return value;
                }
                case -1795452264: {
                    this.expression = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("definition")) {
                this.definition = this.castToReference(value);
            } else if (name.equals("expression")) {
                this.expression = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1014418093: {
                    return this.getDefinition();
                }
                case -1795452264: {
                    return this.getExpressionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1014418093: {
                    return new String[]{"Reference"};
                }
                case -1795452264: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("definition")) {
                this.definition = new Reference();
                return this.definition;
            }
            if (name.equals("expression")) {
                throw new FHIRException("Cannot call addChild on a singleton property SearchParameter.expression");
            }
            return super.addChild(name);
        }

        @Override
        public SearchParameterComponentComponent copy() {
            SearchParameterComponentComponent dst = new SearchParameterComponentComponent();
            this.copyValues(dst);
            dst.definition = this.definition == null ? null : this.definition.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SearchParameterComponentComponent)) {
                return false;
            }
            SearchParameterComponentComponent o = (SearchParameterComponentComponent)other_;
            return SearchParameterComponentComponent.compareDeep(this.definition, o.definition, true) && SearchParameterComponentComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SearchParameterComponentComponent)) {
                return false;
            }
            SearchParameterComponentComponent o = (SearchParameterComponentComponent)other_;
            return SearchParameterComponentComponent.compareValues(this.expression, o.expression, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.definition, this.expression});
        }

        @Override
        public String fhirType() {
            return "SearchParameter.component";
        }
    }

    public static class SearchModifierCodeEnumFactory
    implements EnumFactory<SearchModifierCode> {
        @Override
        public SearchModifierCode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("missing".equals(codeString)) {
                return SearchModifierCode.MISSING;
            }
            if ("exact".equals(codeString)) {
                return SearchModifierCode.EXACT;
            }
            if ("contains".equals(codeString)) {
                return SearchModifierCode.CONTAINS;
            }
            if ("not".equals(codeString)) {
                return SearchModifierCode.NOT;
            }
            if ("text".equals(codeString)) {
                return SearchModifierCode.TEXT;
            }
            if ("in".equals(codeString)) {
                return SearchModifierCode.IN;
            }
            if ("not-in".equals(codeString)) {
                return SearchModifierCode.NOTIN;
            }
            if ("below".equals(codeString)) {
                return SearchModifierCode.BELOW;
            }
            if ("above".equals(codeString)) {
                return SearchModifierCode.ABOVE;
            }
            if (SearchParameter.SP_TYPE.equals(codeString)) {
                return SearchModifierCode.TYPE;
            }
            throw new IllegalArgumentException("Unknown SearchModifierCode code '" + codeString + "'");
        }

        public Enumeration<SearchModifierCode> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SearchModifierCode>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("missing".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.MISSING);
            }
            if ("exact".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.EXACT);
            }
            if ("contains".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.CONTAINS);
            }
            if ("not".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.NOT);
            }
            if ("text".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.TEXT);
            }
            if ("in".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.IN);
            }
            if ("not-in".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.NOTIN);
            }
            if ("below".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.BELOW);
            }
            if ("above".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.ABOVE);
            }
            if (SearchParameter.SP_TYPE.equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.TYPE);
            }
            throw new FHIRException("Unknown SearchModifierCode code '" + codeString + "'");
        }

        @Override
        public String toCode(SearchModifierCode code) {
            if (code == SearchModifierCode.NULL) {
                return null;
            }
            if (code == SearchModifierCode.MISSING) {
                return "missing";
            }
            if (code == SearchModifierCode.EXACT) {
                return "exact";
            }
            if (code == SearchModifierCode.CONTAINS) {
                return "contains";
            }
            if (code == SearchModifierCode.NOT) {
                return "not";
            }
            if (code == SearchModifierCode.TEXT) {
                return "text";
            }
            if (code == SearchModifierCode.IN) {
                return "in";
            }
            if (code == SearchModifierCode.NOTIN) {
                return "not-in";
            }
            if (code == SearchModifierCode.BELOW) {
                return "below";
            }
            if (code == SearchModifierCode.ABOVE) {
                return "above";
            }
            if (code == SearchModifierCode.TYPE) {
                return SearchParameter.SP_TYPE;
            }
            return "?";
        }

        @Override
        public String toSystem(SearchModifierCode code) {
            return code.getSystem();
        }
    }

    public static enum SearchModifierCode {
        MISSING,
        EXACT,
        CONTAINS,
        NOT,
        TEXT,
        IN,
        NOTIN,
        BELOW,
        ABOVE,
        TYPE,
        NULL;


        public static SearchModifierCode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("missing".equals(codeString)) {
                return MISSING;
            }
            if ("exact".equals(codeString)) {
                return EXACT;
            }
            if ("contains".equals(codeString)) {
                return CONTAINS;
            }
            if ("not".equals(codeString)) {
                return NOT;
            }
            if ("text".equals(codeString)) {
                return TEXT;
            }
            if ("in".equals(codeString)) {
                return IN;
            }
            if ("not-in".equals(codeString)) {
                return NOTIN;
            }
            if ("below".equals(codeString)) {
                return BELOW;
            }
            if ("above".equals(codeString)) {
                return ABOVE;
            }
            if (SearchParameter.SP_TYPE.equals(codeString)) {
                return TYPE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SearchModifierCode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MISSING: {
                    return "missing";
                }
                case EXACT: {
                    return "exact";
                }
                case CONTAINS: {
                    return "contains";
                }
                case NOT: {
                    return "not";
                }
                case TEXT: {
                    return "text";
                }
                case IN: {
                    return "in";
                }
                case NOTIN: {
                    return "not-in";
                }
                case BELOW: {
                    return "below";
                }
                case ABOVE: {
                    return "above";
                }
                case TYPE: {
                    return SearchParameter.SP_TYPE;
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MISSING: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case EXACT: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case CONTAINS: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case NOT: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case TEXT: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case IN: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case NOTIN: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case BELOW: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case ABOVE: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case TYPE: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MISSING: {
                    return "The search parameter returns resources that have a value or not.";
                }
                case EXACT: {
                    return "The search parameter returns resources that have a value that exactly matches the supplied parameter (the whole string, including casing and accents).";
                }
                case CONTAINS: {
                    return "The search parameter returns resources that include the supplied parameter value anywhere within the field being searched.";
                }
                case NOT: {
                    return "The search parameter returns resources that do not contain a match.";
                }
                case TEXT: {
                    return "The search parameter is processed as a string that searches text associated with the code/value - either CodeableConcept.text, Coding.display, or Identifier.type.text.";
                }
                case IN: {
                    return "The search parameter is a URI (relative or absolute) that identifies a value set, and the search parameter tests whether the coding is in the specified value set.";
                }
                case NOTIN: {
                    return "The search parameter is a URI (relative or absolute) that identifies a value set, and the search parameter tests whether the coding is not in the specified value set.";
                }
                case BELOW: {
                    return "The search parameter tests whether the value in a resource is subsumed by the specified value (is-a, or hierarchical relationships).";
                }
                case ABOVE: {
                    return "The search parameter tests whether the value in a resource subsumes the specified value (is-a, or hierarchical relationships).";
                }
                case TYPE: {
                    return "The search parameter only applies to the Resource Type specified as a modifier (e.g. the modifier is not actually :type, but :Patient etc.).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MISSING: {
                    return "Missing";
                }
                case EXACT: {
                    return "Exact";
                }
                case CONTAINS: {
                    return "Contains";
                }
                case NOT: {
                    return "Not";
                }
                case TEXT: {
                    return "Text";
                }
                case IN: {
                    return "In";
                }
                case NOTIN: {
                    return "Not In";
                }
                case BELOW: {
                    return "Below";
                }
                case ABOVE: {
                    return "Above";
                }
                case TYPE: {
                    return "Type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class SearchComparatorEnumFactory
    implements EnumFactory<SearchComparator> {
        @Override
        public SearchComparator fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("eq".equals(codeString)) {
                return SearchComparator.EQ;
            }
            if ("ne".equals(codeString)) {
                return SearchComparator.NE;
            }
            if ("gt".equals(codeString)) {
                return SearchComparator.GT;
            }
            if ("lt".equals(codeString)) {
                return SearchComparator.LT;
            }
            if ("ge".equals(codeString)) {
                return SearchComparator.GE;
            }
            if ("le".equals(codeString)) {
                return SearchComparator.LE;
            }
            if ("sa".equals(codeString)) {
                return SearchComparator.SA;
            }
            if ("eb".equals(codeString)) {
                return SearchComparator.EB;
            }
            if ("ap".equals(codeString)) {
                return SearchComparator.AP;
            }
            throw new IllegalArgumentException("Unknown SearchComparator code '" + codeString + "'");
        }

        public Enumeration<SearchComparator> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SearchComparator>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("eq".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.EQ);
            }
            if ("ne".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.NE);
            }
            if ("gt".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.GT);
            }
            if ("lt".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.LT);
            }
            if ("ge".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.GE);
            }
            if ("le".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.LE);
            }
            if ("sa".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.SA);
            }
            if ("eb".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.EB);
            }
            if ("ap".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.AP);
            }
            throw new FHIRException("Unknown SearchComparator code '" + codeString + "'");
        }

        @Override
        public String toCode(SearchComparator code) {
            if (code == SearchComparator.NULL) {
                return null;
            }
            if (code == SearchComparator.EQ) {
                return "eq";
            }
            if (code == SearchComparator.NE) {
                return "ne";
            }
            if (code == SearchComparator.GT) {
                return "gt";
            }
            if (code == SearchComparator.LT) {
                return "lt";
            }
            if (code == SearchComparator.GE) {
                return "ge";
            }
            if (code == SearchComparator.LE) {
                return "le";
            }
            if (code == SearchComparator.SA) {
                return "sa";
            }
            if (code == SearchComparator.EB) {
                return "eb";
            }
            if (code == SearchComparator.AP) {
                return "ap";
            }
            return "?";
        }

        @Override
        public String toSystem(SearchComparator code) {
            return code.getSystem();
        }
    }

    public static enum SearchComparator {
        EQ,
        NE,
        GT,
        LT,
        GE,
        LE,
        SA,
        EB,
        AP,
        NULL;


        public static SearchComparator fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("eq".equals(codeString)) {
                return EQ;
            }
            if ("ne".equals(codeString)) {
                return NE;
            }
            if ("gt".equals(codeString)) {
                return GT;
            }
            if ("lt".equals(codeString)) {
                return LT;
            }
            if ("ge".equals(codeString)) {
                return GE;
            }
            if ("le".equals(codeString)) {
                return LE;
            }
            if ("sa".equals(codeString)) {
                return SA;
            }
            if ("eb".equals(codeString)) {
                return EB;
            }
            if ("ap".equals(codeString)) {
                return AP;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SearchComparator code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EQ: {
                    return "eq";
                }
                case NE: {
                    return "ne";
                }
                case GT: {
                    return "gt";
                }
                case LT: {
                    return "lt";
                }
                case GE: {
                    return "ge";
                }
                case LE: {
                    return "le";
                }
                case SA: {
                    return "sa";
                }
                case EB: {
                    return "eb";
                }
                case AP: {
                    return "ap";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EQ: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case NE: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case GT: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case LT: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case GE: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case LE: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case SA: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case EB: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case AP: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EQ: {
                    return "the value for the parameter in the resource is equal to the provided value";
                }
                case NE: {
                    return "the value for the parameter in the resource is not equal to the provided value";
                }
                case GT: {
                    return "the value for the parameter in the resource is greater than the provided value";
                }
                case LT: {
                    return "the value for the parameter in the resource is less than the provided value";
                }
                case GE: {
                    return "the value for the parameter in the resource is greater or equal to the provided value";
                }
                case LE: {
                    return "the value for the parameter in the resource is less or equal to the provided value";
                }
                case SA: {
                    return "the value for the parameter in the resource starts after the provided value";
                }
                case EB: {
                    return "the value for the parameter in the resource ends before the provided value";
                }
                case AP: {
                    return "the value for the parameter in the resource is approximately the same to the provided value.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EQ: {
                    return "Equals";
                }
                case NE: {
                    return "Not Equals";
                }
                case GT: {
                    return "Greater Than";
                }
                case LT: {
                    return "Less Then";
                }
                case GE: {
                    return "Greater or Equals";
                }
                case LE: {
                    return "Less of Equal";
                }
                case SA: {
                    return "Starts After";
                }
                case EB: {
                    return "Ends Before";
                }
                case AP: {
                    return "Approximately";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class XPathUsageTypeEnumFactory
    implements EnumFactory<XPathUsageType> {
        @Override
        public XPathUsageType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("normal".equals(codeString)) {
                return XPathUsageType.NORMAL;
            }
            if ("phonetic".equals(codeString)) {
                return XPathUsageType.PHONETIC;
            }
            if ("nearby".equals(codeString)) {
                return XPathUsageType.NEARBY;
            }
            if ("distance".equals(codeString)) {
                return XPathUsageType.DISTANCE;
            }
            if ("other".equals(codeString)) {
                return XPathUsageType.OTHER;
            }
            throw new IllegalArgumentException("Unknown XPathUsageType code '" + codeString + "'");
        }

        public Enumeration<XPathUsageType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<XPathUsageType>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("normal".equals(codeString)) {
                return new Enumeration<XPathUsageType>(this, XPathUsageType.NORMAL);
            }
            if ("phonetic".equals(codeString)) {
                return new Enumeration<XPathUsageType>(this, XPathUsageType.PHONETIC);
            }
            if ("nearby".equals(codeString)) {
                return new Enumeration<XPathUsageType>(this, XPathUsageType.NEARBY);
            }
            if ("distance".equals(codeString)) {
                return new Enumeration<XPathUsageType>(this, XPathUsageType.DISTANCE);
            }
            if ("other".equals(codeString)) {
                return new Enumeration<XPathUsageType>(this, XPathUsageType.OTHER);
            }
            throw new FHIRException("Unknown XPathUsageType code '" + codeString + "'");
        }

        @Override
        public String toCode(XPathUsageType code) {
            if (code == XPathUsageType.NULL) {
                return null;
            }
            if (code == XPathUsageType.NORMAL) {
                return "normal";
            }
            if (code == XPathUsageType.PHONETIC) {
                return "phonetic";
            }
            if (code == XPathUsageType.NEARBY) {
                return "nearby";
            }
            if (code == XPathUsageType.DISTANCE) {
                return "distance";
            }
            if (code == XPathUsageType.OTHER) {
                return "other";
            }
            return "?";
        }

        @Override
        public String toSystem(XPathUsageType code) {
            return code.getSystem();
        }
    }

    public static enum XPathUsageType {
        NORMAL,
        PHONETIC,
        NEARBY,
        DISTANCE,
        OTHER,
        NULL;


        public static XPathUsageType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("normal".equals(codeString)) {
                return NORMAL;
            }
            if ("phonetic".equals(codeString)) {
                return PHONETIC;
            }
            if ("nearby".equals(codeString)) {
                return NEARBY;
            }
            if ("distance".equals(codeString)) {
                return DISTANCE;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown XPathUsageType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NORMAL: {
                    return "normal";
                }
                case PHONETIC: {
                    return "phonetic";
                }
                case NEARBY: {
                    return "nearby";
                }
                case DISTANCE: {
                    return "distance";
                }
                case OTHER: {
                    return "other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NORMAL: {
                    return "http://hl7.org/fhir/search-xpath-usage";
                }
                case PHONETIC: {
                    return "http://hl7.org/fhir/search-xpath-usage";
                }
                case NEARBY: {
                    return "http://hl7.org/fhir/search-xpath-usage";
                }
                case DISTANCE: {
                    return "http://hl7.org/fhir/search-xpath-usage";
                }
                case OTHER: {
                    return "http://hl7.org/fhir/search-xpath-usage";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NORMAL: {
                    return "The search parameter is derived directly from the selected nodes based on the type definitions.";
                }
                case PHONETIC: {
                    return "The search parameter is derived by a phonetic transform from the selected nodes.";
                }
                case NEARBY: {
                    return "The search parameter is based on a spatial transform of the selected nodes.";
                }
                case DISTANCE: {
                    return "The search parameter is based on a spatial transform of the selected nodes, using physical distance from the middle.";
                }
                case OTHER: {
                    return "The interpretation of the xpath statement is unknown (and can't be automated).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NORMAL: {
                    return "Normal";
                }
                case PHONETIC: {
                    return "Phonetic";
                }
                case NEARBY: {
                    return "Nearby";
                }
                case DISTANCE: {
                    return "Distance";
                }
                case OTHER: {
                    return "Other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

