/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.DiscriminatorType;

public class DiscriminatorTypeEnumFactory
implements EnumFactory<DiscriminatorType> {
    @Override
    public DiscriminatorType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("value".equals(codeString)) {
            return DiscriminatorType.VALUE;
        }
        if ("exists".equals(codeString)) {
            return DiscriminatorType.EXISTS;
        }
        if ("pattern".equals(codeString)) {
            return DiscriminatorType.PATTERN;
        }
        if ("type".equals(codeString)) {
            return DiscriminatorType.TYPE;
        }
        if ("profile".equals(codeString)) {
            return DiscriminatorType.PROFILE;
        }
        throw new IllegalArgumentException("Unknown DiscriminatorType code '" + codeString + "'");
    }

    @Override
    public String toCode(DiscriminatorType code) {
        if (code == DiscriminatorType.NULL) {
            return null;
        }
        if (code == DiscriminatorType.VALUE) {
            return "value";
        }
        if (code == DiscriminatorType.EXISTS) {
            return "exists";
        }
        if (code == DiscriminatorType.PATTERN) {
            return "pattern";
        }
        if (code == DiscriminatorType.TYPE) {
            return "type";
        }
        if (code == DiscriminatorType.PROFILE) {
            return "profile";
        }
        return "?";
    }

    @Override
    public String toSystem(DiscriminatorType code) {
        return code.getSystem();
    }
}

