/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.RequestIntent;

public class RequestIntentEnumFactory
implements EnumFactory<RequestIntent> {
    @Override
    public RequestIntent fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposal".equals(codeString)) {
            return RequestIntent.PROPOSAL;
        }
        if ("plan".equals(codeString)) {
            return RequestIntent.PLAN;
        }
        if ("order".equals(codeString)) {
            return RequestIntent.ORDER;
        }
        if ("original-order".equals(codeString)) {
            return RequestIntent.ORIGINALORDER;
        }
        if ("reflex-order".equals(codeString)) {
            return RequestIntent.REFLEXORDER;
        }
        if ("filler-order".equals(codeString)) {
            return RequestIntent.FILLERORDER;
        }
        if ("instance-order".equals(codeString)) {
            return RequestIntent.INSTANCEORDER;
        }
        if ("option".equals(codeString)) {
            return RequestIntent.OPTION;
        }
        throw new IllegalArgumentException("Unknown RequestIntent code '" + codeString + "'");
    }

    @Override
    public String toCode(RequestIntent code) {
        if (code == RequestIntent.NULL) {
            return null;
        }
        if (code == RequestIntent.PROPOSAL) {
            return "proposal";
        }
        if (code == RequestIntent.PLAN) {
            return "plan";
        }
        if (code == RequestIntent.ORDER) {
            return "order";
        }
        if (code == RequestIntent.ORIGINALORDER) {
            return "original-order";
        }
        if (code == RequestIntent.REFLEXORDER) {
            return "reflex-order";
        }
        if (code == RequestIntent.FILLERORDER) {
            return "filler-order";
        }
        if (code == RequestIntent.INSTANCEORDER) {
            return "instance-order";
        }
        if (code == RequestIntent.OPTION) {
            return "option";
        }
        return "?";
    }

    @Override
    public String toSystem(RequestIntent code) {
        return code.getSystem();
    }
}

