/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.VisionStatus;

public class VisionStatusEnumFactory
implements EnumFactory<VisionStatus> {
    @Override
    public VisionStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return VisionStatus.ACTIVE;
        }
        if ("cancelled".equals(codeString)) {
            return VisionStatus.CANCELLED;
        }
        if ("draft".equals(codeString)) {
            return VisionStatus.DRAFT;
        }
        if ("entered-in-error".equals(codeString)) {
            return VisionStatus.ENTEREDINERROR;
        }
        throw new IllegalArgumentException("Unknown VisionStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(VisionStatus code) {
        if (code == VisionStatus.NULL) {
            return null;
        }
        if (code == VisionStatus.ACTIVE) {
            return "active";
        }
        if (code == VisionStatus.CANCELLED) {
            return "cancelled";
        }
        if (code == VisionStatus.DRAFT) {
            return "draft";
        }
        if (code == VisionStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        return "?";
    }

    @Override
    public String toSystem(VisionStatus code) {
        return code.getSystem();
    }
}

