/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.conformance;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.dstu3.conformance.ProfileUtilities;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.elementmodel.TurtleParser;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpander;
import org.hl7.fhir.exceptions.FHIRException;
import org.stringtemplate.v4.ST;

public class ShExGenerator {
    public boolean doDatatypes = true;
    public boolean withComments = true;
    public boolean completeModel = false;
    private static String SHEX_TEMPLATE = "$header$\n\n$shapeDefinitions$";
    private static String FHIR = "http://hl7.org/fhir/";
    private static String FHIR_VS = FHIR + "ValueSet/";
    private static String HEADER_TEMPLATE = "PREFIX fhir: <$fhir$> \nPREFIX fhirvs: <$fhirvs$>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \nBASE <http://hl7.org/fhir/shape/>\n$start$";
    private static String START_TEMPLATE = "\n\nstart=@<$id$> AND {fhir:nodeRole [fhir:treeRoot]}\n";
    private static String ALL_START_TEMPLATE = "\n\nstart=@<All>\n";
    private static String ALL_TEMPLATE = "\n<All> $all_entries$\n";
    private static String ALL_ENTRY_TEMPLATE = "(NOT { fhir:nodeRole [fhir:treeRoot] ; a [fhir:$id$] } OR @<$id$>)";
    private static String SHAPE_DEFINITION_TEMPLATE = "$comment$\n<$id$> CLOSED {\n    $resourceDecl$\n    $elements$\n    fhir:index xsd:integer?                 # Relative position in a list\n}\n";
    private static String RESOURCE_SHAPE_TEMPLATE = "$comment$\n<Resource> {a .+;\n    $elements$\n    fhir:index xsd:integer?\n}\n";
    private static String COMPLETE_RESOURCE_TEMPLATE = "<Resource>  @<$resources$>\n\n";
    private static String RESOURCE_DECL_TEMPLATE = "\na [fhir:$id$];$root$";
    private static String ROOT_TEMPLATE = "\nfhir:nodeRole [fhir:treeRoot]?;";
    private static String ELEMENT_TEMPLATE = "$id$$defn$$card$$comment$";
    private static int COMMENT_COL = 40;
    private static int MAX_CHARS = 35;
    private static int MIN_COMMENT_SEP = 2;
    private static String INNER_SHAPE_TEMPLATE = "($comment$\n    $defn$\n)$card$";
    private static String SIMPLE_ELEMENT_DEFN_TEMPLATE = "@<$typ$>$vsdef$";
    private static String VALUESET_DEFN_TEMPLATE = " AND\n\t{fhir:value @$vsn$}";
    private static String FIXED_VALUE_TEMPLATE = " AND\n\t{fhir:value [\"$val$\"]}";
    private static String PRIMITIVE_ELEMENT_DEFN_TEMPLATE = "$typ$$facets$";
    private static String MINVALUE_TEMPLATE = " MININCLUSIVE $val$";
    private static String MAXVALUE_TEMPLATE = " MAXINCLUSIVE $val$";
    private static String MAXLENGTH_TEMPLATE = " MAXLENGTH $val$";
    private static String PATTERN_TEMPLATE = " PATTERN \"$val$\"";
    private static String ALTERNATIVE_SHAPES_TEMPLATE = "fhir:$id$$comment$\n(   $altEntries$\n)$card$";
    private static String REFERENCE_DEFN_TEMPLATE = "@<$ref$Reference>";
    private static String XHTML_TYPE_TEMPLATE = "xsd:string";
    private static String CONCEPT_REFERENCE_TEMPLATE = "a NONLITERAL?;";
    private static String CONCEPT_REFERENCES_TEMPLATE = "a NONLITERAL*;";
    private static String RESOURCE_LINK_TEMPLATE = "fhir:link IRI?;";
    private static String TYPED_REFERENCE_TEMPLATE = "\n<$refType$Reference> CLOSED {\n    fhir:Element.id @<id>?;\n    fhir:Element.extension @<Extension>*;\n    fhir:link @<$refType$> OR CLOSED {a [fhir:$refType$]}?;\n    fhir:Reference.reference @<string>?;\n    fhir:Reference.display @<string>?;\n    fhir:index xsd:integer?\n}";
    private static String TARGET_REFERENCE_TEMPLATE = "\n<$refType$> {\n    a [fhir:$refType$];\n    fhir:nodeRole [fhir:treeRoot]?\n}";
    private static String VALUE_SET_DEFINITION = "# $comment$\n$vsuri$$val_list$\n";
    private IWorkerContext context;
    private HashSet<Pair<StructureDefinition, ElementDefinition>> innerTypes;
    private HashSet<Pair<StructureDefinition, ElementDefinition>> emittedInnerTypes;
    private HashSet<String> datatypes;
    private HashSet<String> emittedDatatypes;
    private HashSet<String> references;
    private LinkedList<StructureDefinition> uniq_structures;
    private HashSet<String> uniq_structure_urls;
    private HashSet<ValueSet> required_value_sets;
    private HashSet<String> known_resources;

    public ShExGenerator(IWorkerContext context) {
        this.context = context;
        this.innerTypes = new HashSet();
        this.emittedInnerTypes = new HashSet();
        this.datatypes = new HashSet();
        this.emittedDatatypes = new HashSet();
        this.references = new HashSet();
        this.required_value_sets = new HashSet();
        this.known_resources = new HashSet();
    }

    public String generate(HTMLLinkPolicy links, StructureDefinition structure) {
        ArrayList<StructureDefinition> list = new ArrayList<StructureDefinition>();
        list.add(structure);
        this.innerTypes.clear();
        this.emittedInnerTypes.clear();
        this.datatypes.clear();
        this.emittedDatatypes.clear();
        this.references.clear();
        this.required_value_sets.clear();
        this.known_resources.clear();
        return this.generate(links, list);
    }

    private ST tmplt(String template) {
        return new ST(template, '$', '$');
    }

    public String generate(HTMLLinkPolicy links, List<StructureDefinition> structures) {
        ST shex_def = this.tmplt(SHEX_TEMPLATE);
        String start_cmd = this.completeModel || structures.get(0).getKind().equals((Object)StructureDefinition.StructureDefinitionKind.RESOURCE) ? (this.completeModel ? this.tmplt(ALL_START_TEMPLATE).render() : this.tmplt(START_TEMPLATE).add("id", (Object)structures.get(0).getId()).render()) : "";
        shex_def.add("header", (Object)this.tmplt(HEADER_TEMPLATE).add("start", (Object)start_cmd).add("fhir", (Object)FHIR).add("fhirvs", (Object)FHIR_VS).render());
        Collections.sort(structures, new SortById());
        StringBuilder shapeDefinitions = new StringBuilder();
        this.uniq_structures = new LinkedList();
        this.uniq_structure_urls = new HashSet();
        for (StructureDefinition structureDefinition : structures) {
            if (this.uniq_structure_urls.contains(structureDefinition.getUrl())) continue;
            this.uniq_structures.add(structureDefinition);
            this.uniq_structure_urls.add(structureDefinition.getUrl());
        }
        for (StructureDefinition structureDefinition : this.uniq_structures) {
            shapeDefinitions.append(this.genShapeDefinition(structureDefinition, true));
        }
        shapeDefinitions.append(this.emitInnerTypes());
        if (this.doDatatypes) {
            shapeDefinitions.append("\n#---------------------- Data Types -------------------\n");
            while (this.emittedDatatypes.size() < this.datatypes.size() || this.emittedInnerTypes.size() < this.innerTypes.size()) {
                shapeDefinitions.append(this.emitDataTypes());
                shapeDefinitions.append(this.emitInnerTypes());
            }
        }
        shapeDefinitions.append("\n#---------------------- Reference Types -------------------\n");
        for (String string : this.references) {
            shapeDefinitions.append("\n").append(this.tmplt(TYPED_REFERENCE_TEMPLATE).add("refType", (Object)string).render()).append("\n");
            if ("Resource".equals(string) || this.known_resources.contains(string)) continue;
            shapeDefinitions.append("\n").append(this.tmplt(TARGET_REFERENCE_TEMPLATE).add("refType", (Object)string).render()).append("\n");
        }
        shex_def.add("shapeDefinitions", (Object)shapeDefinitions);
        if (this.completeModel && this.known_resources.size() > 0) {
            shapeDefinitions.append("\n").append(this.tmplt(COMPLETE_RESOURCE_TEMPLATE).add("resources", (Object)StringUtils.join(this.known_resources, (String)"> OR\n\t@<")).render());
            ArrayList<String> all_entries = new ArrayList<String>();
            for (String kr : this.known_resources) {
                all_entries.add(this.tmplt(ALL_ENTRY_TEMPLATE).add("id", (Object)kr).render());
            }
            shapeDefinitions.append("\n").append(this.tmplt(ALL_TEMPLATE).add("all_entries", (Object)StringUtils.join(all_entries, (String)" OR\n\t")).render());
        }
        shapeDefinitions.append("\n#---------------------- Value Sets ------------------------\n");
        for (ValueSet valueSet : this.required_value_sets) {
            shapeDefinitions.append("\n").append(this.genValueSet(valueSet));
        }
        return shex_def.render();
    }

    private String genShapeDefinition(StructureDefinition sd, boolean top_level) {
        ST shape_defn;
        if ("xhtml".equals(sd.getName()) || this.completeModel && "Resource".equals(sd.getName())) {
            return "";
        }
        if ("Resource".equals(sd.getName())) {
            shape_defn = this.tmplt(RESOURCE_SHAPE_TEMPLATE);
            this.known_resources.add(sd.getName());
        } else {
            shape_defn = this.tmplt(SHAPE_DEFINITION_TEMPLATE).add("id", (Object)sd.getId());
            if (sd.getKind().equals((Object)StructureDefinition.StructureDefinitionKind.RESOURCE)) {
                this.known_resources.add(sd.getName());
                ST resource_decl = this.tmplt(RESOURCE_DECL_TEMPLATE).add("id", (Object)sd.getId()).add("root", (Object)this.tmplt(ROOT_TEMPLATE));
                shape_defn.add("resourceDecl", (Object)resource_decl.render());
            } else {
                shape_defn.add("resourceDecl", (Object)"");
            }
        }
        ArrayList<String> elements = new ArrayList<String>();
        String sdn = sd.getName();
        if (sdn.equals("Coding")) {
            elements.add(this.tmplt(CONCEPT_REFERENCE_TEMPLATE).render());
        } else if (sdn.equals("CodeableConcept")) {
            elements.add(this.tmplt(CONCEPT_REFERENCES_TEMPLATE).render());
        } else if (sdn.equals("Reference")) {
            elements.add(this.tmplt(RESOURCE_LINK_TEMPLATE).render());
        }
        String root_comment = null;
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ed.getPath().contains(".")) {
                root_comment = ed.getShort();
                continue;
            }
            if (StringUtils.countMatches((CharSequence)ed.getPath(), (CharSequence)".") != 1 || "0".equals(ed.getMax())) continue;
            elements.add(this.genElementDefinition(sd, ed));
        }
        shape_defn.add("elements", (Object)StringUtils.join(elements, (String)"\n"));
        shape_defn.add("comment", root_comment == null ? " " : "# " + root_comment);
        return shape_defn.render();
    }

    private String emitInnerTypes() {
        StringBuilder itDefs = new StringBuilder();
        while (this.emittedInnerTypes.size() < this.innerTypes.size()) {
            for (Pair<StructureDefinition, ElementDefinition> it : new HashSet<Pair<StructureDefinition, ElementDefinition>>(this.innerTypes)) {
                if (this.emittedInnerTypes.contains(it)) continue;
                itDefs.append("\n").append(this.genInnerTypeDef((StructureDefinition)it.getLeft(), (ElementDefinition)it.getRight()));
                this.emittedInnerTypes.add(it);
            }
        }
        return itDefs.toString();
    }

    private String emitDataTypes() {
        StringBuilder dtDefs = new StringBuilder();
        while (this.emittedDatatypes.size() < this.datatypes.size()) {
            for (String dt : new HashSet<String>(this.datatypes)) {
                if (this.emittedDatatypes.contains(dt)) continue;
                StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + dt);
                if (sd != null && !this.uniq_structure_urls.contains(sd.getUrl())) {
                    dtDefs.append("\n").append(this.genShapeDefinition(sd, false));
                }
                this.emittedDatatypes.add(dt);
            }
        }
        return dtDefs.toString();
    }

    private ArrayList<String> split_text(String text, int max_col) {
        boolean pos = false;
        ArrayList<String> rval = new ArrayList<String>();
        if (text.length() <= max_col) {
            rval.add(text);
        } else {
            String[] words = text.split(" ");
            int word_idx = 0;
            while (word_idx < words.length) {
                StringBuilder accum = new StringBuilder();
                while (word_idx < words.length && accum.length() + words[word_idx].length() < max_col) {
                    accum.append(words[word_idx++] + " ");
                }
                if (accum.length() == 0) {
                    accum.append(words[word_idx].substring(0, max_col - 3) + "-");
                    words[word_idx] = words[word_idx].substring(max_col - 3);
                }
                rval.add(accum.toString());
                accum = new StringBuilder();
            }
        }
        return rval;
    }

    private void addComment(ST tmplt, ElementDefinition ed) {
        if (this.withComments && ed.hasShort() && !ed.getId().startsWith("Extension.")) {
            int nspaces = Integer.max(COMMENT_COL - tmplt.add("comment", (Object)"#").render().indexOf(35), MIN_COMMENT_SEP);
            tmplt.remove("comment");
            char[] sep = new char[nspaces];
            Arrays.fill(sep, ' ');
            ArrayList<String> comment_lines = this.split_text(ed.getShort().replace("\n", " "), MAX_CHARS);
            StringBuilder comment = new StringBuilder("# ");
            char[] indent = new char[COMMENT_COL];
            Arrays.fill(indent, ' ');
            int i = 0;
            while (i < comment_lines.size()) {
                comment.append(comment_lines.get(i++));
                if (i >= comment_lines.size()) continue;
                comment.append("\n" + new String(indent) + "# ");
            }
            tmplt.add("comment", (Object)(new String(sep) + comment.toString()));
        } else {
            tmplt.add("comment", (Object)" ");
        }
    }

    private String genElementDefinition(StructureDefinition sd, ElementDefinition ed) {
        String defn;
        ST element_def;
        String id = ed.hasBase() ? ed.getBase().getPath() : ed.getPath();
        String shortId = id.substring(id.lastIndexOf(".") + 1);
        String card = ("*".equals(ed.getMax()) ? (ed.getMin() == 0 ? "*" : "+") : (ed.getMin() == 0 ? "?" : "")) + ";";
        if (id.endsWith("[x]")) {
            element_def = ed.getType().size() > 1 ? this.tmplt(INNER_SHAPE_TEMPLATE) : this.tmplt(ELEMENT_TEMPLATE);
            element_def.add("id", (Object)"");
        } else {
            element_def = this.tmplt(ELEMENT_TEMPLATE);
            element_def.add("id", (Object)("fhir:" + (id.charAt(0) == id.toLowerCase().charAt(0) ? shortId : id) + " "));
        }
        List<ElementDefinition> children = ProfileUtilities.getChildList(sd, ed);
        if (children.size() > 0) {
            this.innerTypes.add((Pair<StructureDefinition, ElementDefinition>)new ImmutablePair((Object)sd, (Object)ed));
            defn = this.simpleElement(sd, ed, id);
        } else if (id.endsWith("[x]")) {
            defn = this.genChoiceTypes(sd, ed, id);
        } else if (ed.getType().size() == 1) {
            defn = this.genTypeRef(sd, ed, id, ed.getType().get(0));
        } else if (ed.getContentReference() != null) {
            String ref = ed.getContentReference();
            if (!ref.startsWith("#")) {
                throw new AssertionError((Object)("Not equipped to deal with absolute path references: " + ref));
            }
            String refPath = null;
            for (ElementDefinition ed1 : sd.getSnapshot().getElement()) {
                if (ed1.getId() == null || !ed1.getId().equals(ref.substring(1))) continue;
                refPath = ed1.getPath();
                break;
            }
            if (refPath == null) {
                throw new AssertionError((Object)("Reference path not found: " + ref));
            }
            defn = this.simpleElement(sd, ed, refPath);
        } else if (id.endsWith("[x]")) {
            defn = this.genChoiceTypes(sd, ed, id);
        } else {
            element_def = this.genAlternativeTypes(ed, id, shortId);
            element_def.add("id", (Object)(id.charAt(0) == id.toLowerCase().charAt(0) ? shortId : id));
            element_def.add("card", (Object)card);
            this.addComment(element_def, ed);
            return element_def.render();
        }
        element_def.add("defn", (Object)defn);
        element_def.add("card", (Object)card);
        this.addComment(element_def, ed);
        return element_def.render();
    }

    private String simpleElement(StructureDefinition sd, ElementDefinition ed, String typ) {
        ValueSet vs;
        String addldef = "";
        ElementDefinition.ElementDefinitionBindingComponent binding = ed.getBinding();
        if (binding.hasStrength() && binding.getStrength() == Enumerations.BindingStrength.REQUIRED && "code".equals(typ) && (vs = this.resolveBindingReference(sd, binding.getValueSet())) != null) {
            addldef = this.tmplt(VALUESET_DEFN_TEMPLATE).add("vsn", (Object)this.vsprefix(vs.getUrl())).render();
            this.required_value_sets.add(vs);
        }
        if (ed.hasFixed()) {
            addldef = this.tmplt(FIXED_VALUE_TEMPLATE).add("val", (Object)ed.getFixed().primitiveValue()).render();
        }
        return this.tmplt(SIMPLE_ELEMENT_DEFN_TEMPLATE).add("typ", (Object)typ).add("vsdef", (Object)addldef).render();
    }

    private String vsprefix(String uri) {
        if (uri.startsWith(FHIR_VS)) {
            return "fhirvs:" + uri.replace(FHIR_VS, "");
        }
        return "<" + uri + ">";
    }

    private String genTypeRef(StructureDefinition sd, ElementDefinition ed, String id, ElementDefinition.TypeRefComponent typ) {
        if (typ.hasProfile()) {
            if (typ.getCode().equals("Reference")) {
                return this.genReference("", typ);
            }
            if (ProfileUtilities.getChildList(sd, ed).size() > 0) {
                this.innerTypes.add((Pair<StructureDefinition, ElementDefinition>)new ImmutablePair((Object)sd, (Object)ed));
                return this.simpleElement(sd, ed, id);
            }
            String ref = this.getTypeName(typ);
            this.datatypes.add(ref);
            return this.simpleElement(sd, ed, ref);
        }
        if (typ.getCodeElement().getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-rdf-type").size() > 0) {
            Type mv;
            String xt = null;
            try {
                xt = typ.getCodeElement().getExtensionString("http://hl7.org/fhir/StructureDefinition/structuredefinition-rdf-type");
            }
            catch (FHIRException e) {
                e.printStackTrace();
            }
            ST td_entry = this.tmplt(PRIMITIVE_ELEMENT_DEFN_TEMPLATE).add("typ", (Object)xt.replace("xsd:token", "xsd:string").replace("xsd:int", "xsd:integer"));
            StringBuilder facets = new StringBuilder();
            if (ed.hasMinValue()) {
                mv = ed.getMinValue();
                facets.append(this.tmplt(MINVALUE_TEMPLATE).add("val", (Object)TurtleParser.ttlLiteral(mv.primitiveValue(), mv.fhirType())).render());
            }
            if (ed.hasMaxValue()) {
                mv = ed.getMaxValue();
                facets.append(this.tmplt(MAXVALUE_TEMPLATE).add("val", (Object)TurtleParser.ttlLiteral(mv.primitiveValue(), mv.fhirType())).render());
            }
            if (ed.hasMaxLength()) {
                int ml = ed.getMaxLength();
                facets.append(this.tmplt(MAXLENGTH_TEMPLATE).add("val", (Object)ml).render());
            }
            if (ed.hasPattern()) {
                Type pat = ed.getPattern();
                facets.append(this.tmplt(PATTERN_TEMPLATE).add("val", (Object)pat.primitiveValue()).render());
            }
            td_entry.add("facets", (Object)facets.toString());
            return td_entry.render();
        }
        if (typ.getCode() == null) {
            ST primitive_entry = this.tmplt(PRIMITIVE_ELEMENT_DEFN_TEMPLATE);
            primitive_entry.add("typ", (Object)"xsd:string");
            return primitive_entry.render();
        }
        if (typ.getCode().equals("xhtml")) {
            return this.tmplt(XHTML_TYPE_TEMPLATE).render();
        }
        this.datatypes.add(typ.getCode());
        return this.simpleElement(sd, ed, typ.getCode());
    }

    private ST genAlternativeTypes(ElementDefinition ed, String id, String shortId) {
        ST shex_alt = this.tmplt(ALTERNATIVE_SHAPES_TEMPLATE);
        ArrayList<String> altEntries = new ArrayList<String>();
        for (ElementDefinition.TypeRefComponent typ : ed.getType()) {
            altEntries.add(this.genAltEntry(id, typ));
        }
        shex_alt.add("altEntries", (Object)StringUtils.join(altEntries, (String)" OR\n    "));
        return shex_alt;
    }

    private String genAltEntry(String id, ElementDefinition.TypeRefComponent typ) {
        if (!typ.getCode().equals("Reference")) {
            throw new AssertionError((Object)("We do not handle " + typ.getCode() + " alternatives"));
        }
        return this.genReference(id, typ);
    }

    private String genChoiceTypes(StructureDefinition sd, ElementDefinition ed, String id) {
        ArrayList<String> choiceEntries = new ArrayList<String>();
        String base = id.replace("[x]", "");
        for (ElementDefinition.TypeRefComponent typ : ed.getType()) {
            choiceEntries.add(this.genChoiceEntry(sd, ed, id, base, typ));
        }
        return StringUtils.join(choiceEntries, (String)" |\n");
    }

    private String genChoiceEntry(StructureDefinition sd, ElementDefinition ed, String id, String base, ElementDefinition.TypeRefComponent typ) {
        ST shex_choice_entry = this.tmplt(ELEMENT_TEMPLATE);
        String ext = typ.getCode();
        shex_choice_entry.add("id", (Object)("fhir:" + base + Character.toUpperCase(ext.charAt(0)) + ext.substring(1) + " "));
        shex_choice_entry.add("card", (Object)"");
        shex_choice_entry.add("defn", (Object)this.genTypeRef(sd, ed, id, typ));
        shex_choice_entry.add("comment", (Object)" ");
        return shex_choice_entry.render();
    }

    private String genInnerTypeDef(StructureDefinition sd, ElementDefinition ed) {
        String path = ed.hasBase() ? ed.getBase().getPath() : ed.getPath();
        ST element_reference = this.tmplt(SHAPE_DEFINITION_TEMPLATE);
        element_reference.add("resourceDecl", (Object)"");
        element_reference.add("id", (Object)path);
        String comment = ed.getShort();
        element_reference.add("comment", comment == null ? " " : "# " + comment);
        ArrayList<String> elements = new ArrayList<String>();
        for (ElementDefinition child : ProfileUtilities.getChildList(sd, path, null)) {
            elements.add(this.genElementDefinition(sd, child));
        }
        element_reference.add("elements", (Object)StringUtils.join(elements, (String)"\n"));
        return element_reference.render();
    }

    private String genReference(String id, ElementDefinition.TypeRefComponent typ) {
        ST shex_ref = this.tmplt(REFERENCE_DEFN_TEMPLATE);
        String ref = this.getTypeName(typ);
        shex_ref.add("id", (Object)id);
        shex_ref.add("ref", (Object)ref);
        this.references.add(ref);
        return shex_ref.render();
    }

    private String getTypeName(ElementDefinition.TypeRefComponent typ) {
        if (typ.hasTargetProfile()) {
            String[] els = typ.getTargetProfile().split("/");
            return els[els.length - 1];
        }
        if (typ.hasProfile()) {
            String[] els = typ.getProfile().split("/");
            return els[els.length - 1];
        }
        return typ.getCode();
    }

    private String genValueSet(ValueSet vs) {
        ST vsd = this.tmplt(VALUE_SET_DEFINITION).add("vsuri", (Object)this.vsprefix(vs.getUrl())).add("comment", (Object)vs.getDescription());
        ValueSetExpander.ValueSetExpansionOutcome vse = this.context.expandVS(vs, true, false);
        ArrayList<CallSite> valid_codes = new ArrayList<CallSite>();
        if (vse != null && vse.getValueset() != null && vse.getValueset().hasExpansion() && vse.getValueset().getExpansion().hasContains()) {
            for (ValueSet.ValueSetExpansionContainsComponent vsec : vse.getValueset().getExpansion().getContains()) {
                valid_codes.add((CallSite)((Object)("\"" + vsec.getCode() + "\"")));
            }
        }
        return vsd.add("val_list", valid_codes.size() > 0 ? " [" + StringUtils.join(valid_codes, (String)" ") + "]" : " EXTERNAL").render();
    }

    private ValueSet resolveBindingReference(DomainResource ctxt, Type reference) {
        if (reference instanceof UriType) {
            return this.context.fetchResource(ValueSet.class, ((String)((UriType)reference).getValue()).toString());
        }
        if (reference instanceof Reference) {
            String s = ((Reference)reference).getReference();
            if (s.startsWith("#")) {
                for (Resource c : ctxt.getContained()) {
                    if (!c.getId().equals(s.substring(1)) || !(c instanceof ValueSet)) continue;
                    return (ValueSet)c;
                }
                return null;
            }
            return this.context.fetchResource(ValueSet.class, ((Reference)reference).getReference());
        }
        return null;
    }

    public class SortById
    implements Comparator<StructureDefinition> {
        @Override
        public int compare(StructureDefinition arg0, StructureDefinition arg1) {
            return arg0.getId().compareTo(arg1.getId());
        }
    }

    public static enum HTMLLinkPolicy {
        NONE,
        EXTERNAL,
        INTERNAL;

    }
}

