/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.AddressUse;

public class AddressUseEnumFactory
implements EnumFactory<AddressUse> {
    @Override
    public AddressUse fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("home".equals(codeString)) {
            return AddressUse.HOME;
        }
        if ("work".equals(codeString)) {
            return AddressUse.WORK;
        }
        if ("temp".equals(codeString)) {
            return AddressUse.TEMP;
        }
        if ("old".equals(codeString)) {
            return AddressUse.OLD;
        }
        throw new IllegalArgumentException("Unknown AddressUse code '" + codeString + "'");
    }

    @Override
    public String toCode(AddressUse code) {
        if (code == AddressUse.NULL) {
            return null;
        }
        if (code == AddressUse.HOME) {
            return "home";
        }
        if (code == AddressUse.WORK) {
            return "work";
        }
        if (code == AddressUse.TEMP) {
            return "temp";
        }
        if (code == AddressUse.OLD) {
            return "old";
        }
        return "?";
    }

    @Override
    public String toSystem(AddressUse code) {
        return code.getSystem();
    }
}

