/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.CatalogContentType;

public class CatalogContentTypeEnumFactory
implements EnumFactory<CatalogContentType> {
    @Override
    public CatalogContentType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("single-submission".equals(codeString)) {
            return CatalogContentType.SINGLESUBMISSION;
        }
        if ("resubmission".equals(codeString)) {
            return CatalogContentType.RESUBMISSION;
        }
        if ("full-catalog".equals(codeString)) {
            return CatalogContentType.FULLCATALOG;
        }
        if ("catalog-update".equals(codeString)) {
            return CatalogContentType.CATALOGUPDATE;
        }
        if ("catalog-response".equals(codeString)) {
            return CatalogContentType.CATALOGRESPONSE;
        }
        throw new IllegalArgumentException("Unknown CatalogContentType code '" + codeString + "'");
    }

    @Override
    public String toCode(CatalogContentType code) {
        if (code == CatalogContentType.NULL) {
            return null;
        }
        if (code == CatalogContentType.SINGLESUBMISSION) {
            return "single-submission";
        }
        if (code == CatalogContentType.RESUBMISSION) {
            return "resubmission";
        }
        if (code == CatalogContentType.FULLCATALOG) {
            return "full-catalog";
        }
        if (code == CatalogContentType.CATALOGUPDATE) {
            return "catalog-update";
        }
        if (code == CatalogContentType.CATALOGRESPONSE) {
            return "catalog-response";
        }
        return "?";
    }

    @Override
    public String toSystem(CatalogContentType code) {
        return code.getSystem();
    }
}

