/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.DefinitionTopic;

public class DefinitionTopicEnumFactory
implements EnumFactory<DefinitionTopic> {
    @Override
    public DefinitionTopic fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("treatment".equals(codeString)) {
            return DefinitionTopic.TREATMENT;
        }
        if ("education".equals(codeString)) {
            return DefinitionTopic.EDUCATION;
        }
        if ("assessment".equals(codeString)) {
            return DefinitionTopic.ASSESSMENT;
        }
        throw new IllegalArgumentException("Unknown DefinitionTopic code '" + codeString + "'");
    }

    @Override
    public String toCode(DefinitionTopic code) {
        if (code == DefinitionTopic.NULL) {
            return null;
        }
        if (code == DefinitionTopic.TREATMENT) {
            return "treatment";
        }
        if (code == DefinitionTopic.EDUCATION) {
            return "education";
        }
        if (code == DefinitionTopic.ASSESSMENT) {
            return "assessment";
        }
        return "?";
    }

    @Override
    public String toSystem(DefinitionTopic code) {
        return code.getSystem();
    }
}

