/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.CatalogItemRelationType;

public class CatalogItemRelationTypeEnumFactory
implements EnumFactory<CatalogItemRelationType> {
    @Override
    public CatalogItemRelationType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("pkg-contains".equals(codeString)) {
            return CatalogItemRelationType.PKGCONTAINS;
        }
        if ("pkg-is-contained-in".equals(codeString)) {
            return CatalogItemRelationType.PKGISCONTAINEDIN;
        }
        if ("contains-sbst".equals(codeString)) {
            return CatalogItemRelationType.CONTAINSSBST;
        }
        if ("combines-with".equals(codeString)) {
            return CatalogItemRelationType.COMBINESWITH;
        }
        if ("requires".equals(codeString)) {
            return CatalogItemRelationType.REQUIRES;
        }
        throw new IllegalArgumentException("Unknown CatalogItemRelationType code '" + codeString + "'");
    }

    @Override
    public String toCode(CatalogItemRelationType code) {
        if (code == CatalogItemRelationType.NULL) {
            return null;
        }
        if (code == CatalogItemRelationType.PKGCONTAINS) {
            return "pkg-contains";
        }
        if (code == CatalogItemRelationType.PKGISCONTAINEDIN) {
            return "pkg-is-contained-in";
        }
        if (code == CatalogItemRelationType.CONTAINSSBST) {
            return "contains-sbst";
        }
        if (code == CatalogItemRelationType.COMBINESWITH) {
            return "combines-with";
        }
        if (code == CatalogItemRelationType.REQUIRES) {
            return "requires";
        }
        return "?";
    }

    @Override
    public String toSystem(CatalogItemRelationType code) {
        return code.getSystem();
    }
}

