/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ActionCardinalityBehavior {
    SINGLE,
    MULTIPLE,
    NULL;


    public static ActionCardinalityBehavior fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("single".equals(codeString)) {
            return SINGLE;
        }
        if ("multiple".equals(codeString)) {
            return MULTIPLE;
        }
        throw new FHIRException("Unknown ActionCardinalityBehavior code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SINGLE: {
                return "single";
            }
            case MULTIPLE: {
                return "multiple";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/action-cardinality-behavior";
    }

    public String getDefinition() {
        switch (this) {
            case SINGLE: {
                return "The action may only be selected one time";
            }
            case MULTIPLE: {
                return "The action may be selected multiple times";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SINGLE: {
                return "Single";
            }
            case MULTIPLE: {
                return "Multiple";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

