/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DataElement", profile="http://hl7.org/fhir/Profile/DataElement")
@ChildOrder(names={"url", "identifier", "version", "status", "experimental", "date", "publisher", "name", "title", "contact", "useContext", "jurisdiction", "copyright", "stringency", "mapping", "element"})
public class DataElement
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the data element", formalDefinition="A formal identifier that is used to identify this data element when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="copyright", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the data element and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the data element.")
    protected MarkdownType copyright;
    @Child(name="stringency", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="comparable | fully-specified | equivalent | convertable | scaleable | flexible", formalDefinition="Identifies how precise the data element is in its definition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/dataelement-stringency")
    protected Enumeration<DataElementStringency> stringency;
    @Child(name="mapping", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="External specification mapped to", formalDefinition="Identifies a specification (other than a terminology) that the elements which make up the DataElement have some correspondence with.")
    protected List<DataElementMappingComponent> mapping;
    @Child(name="element", type={ElementDefinition.class}, order=4, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Definition of element", formalDefinition="Defines the structure, type, allowed values and other constraining characteristics of the data element.")
    protected List<ElementDefinition> element;
    private static final long serialVersionUID = 634422795L;
    @SearchParamDefinition(name="date", path="DataElement.date", description="The data element publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="DataElement.identifier", description="External identifier for the data element", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="code", path="DataElement.element.code", description="A code for the data element (server may choose to do subsumption)", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="stringency", path="DataElement.stringency", description="The stringency of the data element definition", type="token")
    public static final String SP_STRINGENCY = "stringency";
    public static final TokenClientParam STRINGENCY = new TokenClientParam("stringency");
    @SearchParamDefinition(name="jurisdiction", path="DataElement.jurisdiction", description="Intended jurisdiction for the data element", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="DataElement.name", description="Computationally friendly name of the data element", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="DataElement.publisher", description="Name of the publisher of the data element", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="description", path="DataElement.element.definition", description="Text search in the description of the data element.  This corresponds to the definition of the first DataElement.element.", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="title", path="DataElement.title", description="The human-friendly name of the data element", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="version", path="DataElement.version", description="The business version of the data element", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="DataElement.url", description="The uri that identifies the data element", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="status", path="DataElement.status", description="The current status of the data element", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public DataElement() {
    }

    public DataElement(Enumeration<Enumerations.PublicationStatus> status) {
        this.status = status;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public DataElement setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public DataElement setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DataElement setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DataElement addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public DataElement setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public DataElement setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public DataElement setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public DataElement setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public DataElement setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public DataElement setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public DataElement setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public DataElement setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public DataElement setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public DataElement setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public DataElement setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public DataElement setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public DataElement setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public DataElement setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public DataElement setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public DataElement addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public DataElement setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public DataElement addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public DataElement setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public DataElement addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public DataElement setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public DataElement setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public Enumeration<DataElementStringency> getStringencyElement() {
        if (this.stringency == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataElement.stringency");
            }
            if (Configuration.doAutoCreate()) {
                this.stringency = new Enumeration<DataElementStringency>(new DataElementStringencyEnumFactory());
            }
        }
        return this.stringency;
    }

    public boolean hasStringencyElement() {
        return this.stringency != null && !this.stringency.isEmpty();
    }

    public boolean hasStringency() {
        return this.stringency != null && !this.stringency.isEmpty();
    }

    public DataElement setStringencyElement(Enumeration<DataElementStringency> value) {
        this.stringency = value;
        return this;
    }

    public DataElementStringency getStringency() {
        return this.stringency == null ? null : (DataElementStringency)((Object)this.stringency.getValue());
    }

    public DataElement setStringency(DataElementStringency value) {
        if (value == null) {
            this.stringency = null;
        } else {
            if (this.stringency == null) {
                this.stringency = new Enumeration<DataElementStringency>(new DataElementStringencyEnumFactory());
            }
            this.stringency.setValue((Object)value);
        }
        return this;
    }

    public List<DataElementMappingComponent> getMapping() {
        if (this.mapping == null) {
            this.mapping = new ArrayList<DataElementMappingComponent>();
        }
        return this.mapping;
    }

    public DataElement setMapping(List<DataElementMappingComponent> theMapping) {
        this.mapping = theMapping;
        return this;
    }

    public boolean hasMapping() {
        if (this.mapping == null) {
            return false;
        }
        for (DataElementMappingComponent item : this.mapping) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DataElementMappingComponent addMapping() {
        DataElementMappingComponent t = new DataElementMappingComponent();
        if (this.mapping == null) {
            this.mapping = new ArrayList<DataElementMappingComponent>();
        }
        this.mapping.add(t);
        return t;
    }

    public DataElement addMapping(DataElementMappingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.mapping == null) {
            this.mapping = new ArrayList<DataElementMappingComponent>();
        }
        this.mapping.add(t);
        return this;
    }

    public DataElementMappingComponent getMappingFirstRep() {
        if (this.getMapping().isEmpty()) {
            this.addMapping();
        }
        return this.getMapping().get(0);
    }

    public List<ElementDefinition> getElement() {
        if (this.element == null) {
            this.element = new ArrayList<ElementDefinition>();
        }
        return this.element;
    }

    public DataElement setElement(List<ElementDefinition> theElement) {
        this.element = theElement;
        return this;
    }

    public boolean hasElement() {
        if (this.element == null) {
            return false;
        }
        for (ElementDefinition item : this.element) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ElementDefinition addElement() {
        ElementDefinition t = new ElementDefinition();
        if (this.element == null) {
            this.element = new ArrayList<ElementDefinition>();
        }
        this.element.add(t);
        return t;
    }

    public DataElement addElement(ElementDefinition t) {
        if (t == null) {
            return this;
        }
        if (this.element == null) {
            this.element = new ArrayList<ElementDefinition>();
        }
        this.element.add(t);
        return this;
    }

    public ElementDefinition getElementFirstRep() {
        if (this.getElement().isEmpty()) {
            this.addElement();
        }
        return this.getElement().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this data element when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this data element is (or will be) published. The URL SHOULD include the major version of the data element. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this data element when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the data element when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the data element author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_STATUS, SP_CODE, "The status of this data element. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A boolean value to indicate that this data element is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the data element was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the data element changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the data element.", 0, 1, this.publisher));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the data element. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the data element.", 0, 1, this.title));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate data element instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the data element is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the data element and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the data element.", 0, 1, this.copyright));
        children.add(new Property(SP_STRINGENCY, SP_CODE, "Identifies how precise the data element is in its definition.", 0, 1, this.stringency));
        children.add(new Property("mapping", "", "Identifies a specification (other than a terminology) that the elements which make up the DataElement have some correspondence with.", 0, Integer.MAX_VALUE, this.mapping));
        children.add(new Property("element", "ElementDefinition", "Defines the structure, type, allowed values and other constraining characteristics of the data element.", 0, Integer.MAX_VALUE, this.element));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this data element when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this data element is (or will be) published. The URL SHOULD include the major version of the data element. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this data element when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the data element when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the data element author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The status of this data element. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A boolean value to indicate that this data element is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the data element was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the data element changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the data element.", 0, 1, this.publisher);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the data element. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the data element.", 0, 1, this.title);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate data element instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the data element is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the data element and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the data element.", 0, 1, this.copyright);
            }
            case -1572568464: {
                return new Property(SP_STRINGENCY, SP_CODE, "Identifies how precise the data element is in its definition.", 0, 1, this.stringency);
            }
            case 837556430: {
                return new Property("mapping", "", "Identifies a specification (other than a terminology) that the elements which make up the DataElement have some correspondence with.", 0, Integer.MAX_VALUE, this.mapping);
            }
            case -1662836996: {
                return new Property("element", "ElementDefinition", "Defines the structure, type, allowed values and other constraining characteristics of the data element.", 0, Integer.MAX_VALUE, this.element);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.publisher;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.title;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.copyright;
                }
                return baseArray;
            }
            case -1572568464: {
                Base[] baseArray;
                if (this.stringency == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.stringency;
                }
                return baseArray;
            }
            case 837556430: {
                return this.mapping == null ? new Base[]{} : this.mapping.toArray(new Base[this.mapping.size()]);
            }
            case -1662836996: {
                return this.element == null ? new Base[]{} : this.element.toArray(new Base[this.element.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case -1572568464: {
                value = new DataElementStringencyEnumFactory().fromType(this.castToCode(value));
                this.stringency = value;
                return value;
            }
            case 837556430: {
                this.getMapping().add((DataElementMappingComponent)((Object)value));
                return value;
            }
            case -1662836996: {
                this.getElement().add(this.castToElementDefinition(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals(SP_STRINGENCY)) {
            value = new DataElementStringencyEnumFactory().fromType(this.castToCode(value));
            this.stringency = value;
        } else if (name.equals("mapping")) {
            this.getMapping().add((DataElementMappingComponent)((Object)value));
        } else if (name.equals("element")) {
            this.getElement().add(this.castToElementDefinition(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case -1572568464: {
                return this.getStringencyElement();
            }
            case 837556430: {
                return this.addMapping();
            }
            case -1662836996: {
                return this.addElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case -1572568464: {
                return new String[]{SP_CODE};
            }
            case 837556430: {
                return new String[0];
            }
            case -1662836996: {
                return new String[]{"ElementDefinition"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property DataElement.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property DataElement.version");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property DataElement.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property DataElement.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property DataElement.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property DataElement.publisher");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property DataElement.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property DataElement.title");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property DataElement.copyright");
        }
        if (name.equals(SP_STRINGENCY)) {
            throw new FHIRException("Cannot call addChild on a singleton property DataElement.stringency");
        }
        if (name.equals("mapping")) {
            return this.addMapping();
        }
        if (name.equals("element")) {
            return this.addElement();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DataElement";
    }

    @Override
    public DataElement copy() {
        DataElement dst = new DataElement();
        this.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.publisher = this.publisher == null ? null : this.publisher.copy();
        dst.name = this.name == null ? null : this.name.copy();
        StringType stringType = dst.title = this.title == null ? null : this.title.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        Enumeration<DataElementStringency> enumeration = dst.stringency = this.stringency == null ? null : this.stringency.copy();
        if (this.mapping != null) {
            dst.mapping = new ArrayList<DataElementMappingComponent>();
            for (DataElementMappingComponent dataElementMappingComponent : this.mapping) {
                dst.mapping.add(dataElementMappingComponent.copy());
            }
        }
        if (this.element != null) {
            dst.element = new ArrayList<ElementDefinition>();
            for (ElementDefinition elementDefinition : this.element) {
                dst.element.add(elementDefinition.copy());
            }
        }
        return dst;
    }

    protected DataElement typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DataElement)) {
            return false;
        }
        DataElement o = (DataElement)other_;
        return DataElement.compareDeep(this.identifier, o.identifier, true) && DataElement.compareDeep(this.copyright, o.copyright, true) && DataElement.compareDeep(this.stringency, o.stringency, true) && DataElement.compareDeep(this.mapping, o.mapping, true) && DataElement.compareDeep(this.element, o.element, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DataElement)) {
            return false;
        }
        DataElement o = (DataElement)other_;
        return DataElement.compareValues(this.copyright, o.copyright, true) && DataElement.compareValues(this.stringency, o.stringency, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.copyright, this.stringency, this.mapping, this.element});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DataElement;
    }

    @Block
    public static class DataElementMappingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identity", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Internal id when this mapping is used", formalDefinition="An internal id that is used to identify this mapping set when specific mappings are made on a per-element basis.")
        protected IdType identity;
        @Child(name="uri", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies what this mapping refers to", formalDefinition="An absolute URI that identifies the specification that this mapping is expressed to.")
        protected UriType uri;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Names what this mapping refers to", formalDefinition="A name for the specification that is being mapped to.")
        protected StringType name;
        @Child(name="comment", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Versions, issues, scope limitations, etc.", formalDefinition="Comments about this mapping, including version notes, issues, scope limitations, and other important notes for usage.")
        protected StringType comment;
        private static final long serialVersionUID = 9610265L;

        public DataElementMappingComponent() {
        }

        public DataElementMappingComponent(IdType identity) {
            this.identity = identity;
        }

        public IdType getIdentityElement() {
            if (this.identity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataElementMappingComponent.identity");
                }
                if (Configuration.doAutoCreate()) {
                    this.identity = new IdType();
                }
            }
            return this.identity;
        }

        public boolean hasIdentityElement() {
            return this.identity != null && !this.identity.isEmpty();
        }

        public boolean hasIdentity() {
            return this.identity != null && !this.identity.isEmpty();
        }

        public DataElementMappingComponent setIdentityElement(IdType value) {
            this.identity = value;
            return this;
        }

        public String getIdentity() {
            return this.identity == null ? null : this.identity.getValue();
        }

        public DataElementMappingComponent setIdentity(String value) {
            if (this.identity == null) {
                this.identity = new IdType();
            }
            this.identity.setValue(value);
            return this;
        }

        public UriType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataElementMappingComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new UriType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public DataElementMappingComponent setUriElement(UriType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public DataElementMappingComponent setUri(String value) {
            if (Utilities.noString((String)value)) {
                this.uri = null;
            } else {
                if (this.uri == null) {
                    this.uri = new UriType();
                }
                this.uri.setValue(value);
            }
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataElementMappingComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public DataElementMappingComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public DataElementMappingComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataElementMappingComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public DataElementMappingComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public DataElementMappingComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("identity", "id", "An internal id that is used to identify this mapping set when specific mappings are made on a per-element basis.", 0, 1, this.identity));
            children.add(new Property("uri", "uri", "An absolute URI that identifies the specification that this mapping is expressed to.", 0, 1, this.uri));
            children.add(new Property(DataElement.SP_NAME, "string", "A name for the specification that is being mapped to.", 0, 1, this.name));
            children.add(new Property("comment", "string", "Comments about this mapping, including version notes, issues, scope limitations, and other important notes for usage.", 0, 1, this.comment));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -135761730: {
                    return new Property("identity", "id", "An internal id that is used to identify this mapping set when specific mappings are made on a per-element basis.", 0, 1, this.identity);
                }
                case 116076: {
                    return new Property("uri", "uri", "An absolute URI that identifies the specification that this mapping is expressed to.", 0, 1, this.uri);
                }
                case 3373707: {
                    return new Property(DataElement.SP_NAME, "string", "A name for the specification that is being mapped to.", 0, 1, this.name);
                }
                case 950398559: {
                    return new Property("comment", "string", "Comments about this mapping, including version notes, issues, scope limitations, and other important notes for usage.", 0, 1, this.comment);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    Base[] baseArray;
                    if (this.identity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identity;
                    }
                    return baseArray;
                }
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uri;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.comment;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    this.identity = this.castToId(value);
                    return value;
                }
                case 116076: {
                    this.uri = this.castToUri(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 950398559: {
                    this.comment = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("identity")) {
                this.identity = this.castToId(value);
            } else if (name.equals("uri")) {
                this.uri = this.castToUri(value);
            } else if (name.equals(DataElement.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("comment")) {
                this.comment = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    return this.getIdentityElement();
                }
                case 116076: {
                    return this.getUriElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case 950398559: {
                    return this.getCommentElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    return new String[]{"id"};
                }
                case 116076: {
                    return new String[]{"uri"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case 950398559: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("identity")) {
                throw new FHIRException("Cannot call addChild on a singleton property DataElement.identity");
            }
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a singleton property DataElement.uri");
            }
            if (name.equals(DataElement.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a singleton property DataElement.name");
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a singleton property DataElement.comment");
            }
            return super.addChild(name);
        }

        @Override
        public DataElementMappingComponent copy() {
            DataElementMappingComponent dst = new DataElementMappingComponent();
            this.copyValues(dst);
            dst.identity = this.identity == null ? null : this.identity.copy();
            dst.uri = this.uri == null ? null : this.uri.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.comment = this.comment == null ? null : this.comment.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DataElementMappingComponent)) {
                return false;
            }
            DataElementMappingComponent o = (DataElementMappingComponent)other_;
            return DataElementMappingComponent.compareDeep(this.identity, o.identity, true) && DataElementMappingComponent.compareDeep(this.uri, o.uri, true) && DataElementMappingComponent.compareDeep(this.name, o.name, true) && DataElementMappingComponent.compareDeep(this.comment, o.comment, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DataElementMappingComponent)) {
                return false;
            }
            DataElementMappingComponent o = (DataElementMappingComponent)other_;
            return DataElementMappingComponent.compareValues(this.identity, o.identity, true) && DataElementMappingComponent.compareValues(this.uri, o.uri, true) && DataElementMappingComponent.compareValues(this.name, o.name, true) && DataElementMappingComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.identity, this.uri, this.name, this.comment});
        }

        @Override
        public String fhirType() {
            return "DataElement.mapping";
        }
    }

    public static class DataElementStringencyEnumFactory
    implements EnumFactory<DataElementStringency> {
        @Override
        public DataElementStringency fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("comparable".equals(codeString)) {
                return DataElementStringency.COMPARABLE;
            }
            if ("fully-specified".equals(codeString)) {
                return DataElementStringency.FULLYSPECIFIED;
            }
            if ("equivalent".equals(codeString)) {
                return DataElementStringency.EQUIVALENT;
            }
            if ("convertable".equals(codeString)) {
                return DataElementStringency.CONVERTABLE;
            }
            if ("scaleable".equals(codeString)) {
                return DataElementStringency.SCALEABLE;
            }
            if ("flexible".equals(codeString)) {
                return DataElementStringency.FLEXIBLE;
            }
            throw new IllegalArgumentException("Unknown DataElementStringency code '" + codeString + "'");
        }

        public Enumeration<DataElementStringency> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DataElementStringency>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("comparable".equals(codeString)) {
                return new Enumeration<DataElementStringency>(this, DataElementStringency.COMPARABLE);
            }
            if ("fully-specified".equals(codeString)) {
                return new Enumeration<DataElementStringency>(this, DataElementStringency.FULLYSPECIFIED);
            }
            if ("equivalent".equals(codeString)) {
                return new Enumeration<DataElementStringency>(this, DataElementStringency.EQUIVALENT);
            }
            if ("convertable".equals(codeString)) {
                return new Enumeration<DataElementStringency>(this, DataElementStringency.CONVERTABLE);
            }
            if ("scaleable".equals(codeString)) {
                return new Enumeration<DataElementStringency>(this, DataElementStringency.SCALEABLE);
            }
            if ("flexible".equals(codeString)) {
                return new Enumeration<DataElementStringency>(this, DataElementStringency.FLEXIBLE);
            }
            throw new FHIRException("Unknown DataElementStringency code '" + codeString + "'");
        }

        @Override
        public String toCode(DataElementStringency code) {
            if (code == DataElementStringency.NULL) {
                return null;
            }
            if (code == DataElementStringency.COMPARABLE) {
                return "comparable";
            }
            if (code == DataElementStringency.FULLYSPECIFIED) {
                return "fully-specified";
            }
            if (code == DataElementStringency.EQUIVALENT) {
                return "equivalent";
            }
            if (code == DataElementStringency.CONVERTABLE) {
                return "convertable";
            }
            if (code == DataElementStringency.SCALEABLE) {
                return "scaleable";
            }
            if (code == DataElementStringency.FLEXIBLE) {
                return "flexible";
            }
            return "?";
        }

        @Override
        public String toSystem(DataElementStringency code) {
            return code.getSystem();
        }
    }

    public static enum DataElementStringency {
        COMPARABLE,
        FULLYSPECIFIED,
        EQUIVALENT,
        CONVERTABLE,
        SCALEABLE,
        FLEXIBLE,
        NULL;


        public static DataElementStringency fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("comparable".equals(codeString)) {
                return COMPARABLE;
            }
            if ("fully-specified".equals(codeString)) {
                return FULLYSPECIFIED;
            }
            if ("equivalent".equals(codeString)) {
                return EQUIVALENT;
            }
            if ("convertable".equals(codeString)) {
                return CONVERTABLE;
            }
            if ("scaleable".equals(codeString)) {
                return SCALEABLE;
            }
            if ("flexible".equals(codeString)) {
                return FLEXIBLE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DataElementStringency code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case COMPARABLE: {
                    return "comparable";
                }
                case FULLYSPECIFIED: {
                    return "fully-specified";
                }
                case EQUIVALENT: {
                    return "equivalent";
                }
                case CONVERTABLE: {
                    return "convertable";
                }
                case SCALEABLE: {
                    return "scaleable";
                }
                case FLEXIBLE: {
                    return "flexible";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case COMPARABLE: {
                    return "http://hl7.org/fhir/dataelement-stringency";
                }
                case FULLYSPECIFIED: {
                    return "http://hl7.org/fhir/dataelement-stringency";
                }
                case EQUIVALENT: {
                    return "http://hl7.org/fhir/dataelement-stringency";
                }
                case CONVERTABLE: {
                    return "http://hl7.org/fhir/dataelement-stringency";
                }
                case SCALEABLE: {
                    return "http://hl7.org/fhir/dataelement-stringency";
                }
                case FLEXIBLE: {
                    return "http://hl7.org/fhir/dataelement-stringency";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case COMPARABLE: {
                    return "The data element is sufficiently well-constrained that multiple pieces of data captured according to the constraints of the data element will be comparable (though in some cases, a degree of automated conversion/normalization may be required).";
                }
                case FULLYSPECIFIED: {
                    return "The data element is fully specified down to a single value set, single unit of measure, single data type, etc.  Multiple pieces of data associated with this data element are fully comparable.";
                }
                case EQUIVALENT: {
                    return "The data element allows multiple units of measure having equivalent meaning; e.g. \"cc\" (cubic centimeter) and \"mL\" (milliliter).";
                }
                case CONVERTABLE: {
                    return "The data element allows multiple units of measure that are convertable between each other (e.g. inches and centimeters) and/or allows data to be captured in multiple value sets for which a known mapping exists allowing conversion of meaning.";
                }
                case SCALEABLE: {
                    return "A convertable data element where unit conversions are different only by a power of 10; e.g. g, mg, kg.";
                }
                case FLEXIBLE: {
                    return "The data element is unconstrained in units, choice of data types and/or choice of vocabulary such that automated comparison of data captured using the data element is not possible.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case COMPARABLE: {
                    return "Comparable";
                }
                case FULLYSPECIFIED: {
                    return "Fully Specified";
                }
                case EQUIVALENT: {
                    return "Equivalent";
                }
                case CONVERTABLE: {
                    return "Convertable";
                }
                case SCALEABLE: {
                    return "Scaleable";
                }
                case FLEXIBLE: {
                    return "Flexible";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

