/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ActionType;

public class ActionTypeEnumFactory
implements EnumFactory<ActionType> {
    @Override
    public ActionType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("create".equals(codeString)) {
            return ActionType.CREATE;
        }
        if ("update".equals(codeString)) {
            return ActionType.UPDATE;
        }
        if ("remove".equals(codeString)) {
            return ActionType.REMOVE;
        }
        if ("fire-event".equals(codeString)) {
            return ActionType.FIREEVENT;
        }
        throw new IllegalArgumentException("Unknown ActionType code '" + codeString + "'");
    }

    @Override
    public String toCode(ActionType code) {
        if (code == ActionType.NULL) {
            return null;
        }
        if (code == ActionType.CREATE) {
            return "create";
        }
        if (code == ActionType.UPDATE) {
            return "update";
        }
        if (code == ActionType.REMOVE) {
            return "remove";
        }
        if (code == ActionType.FIREEVENT) {
            return "fire-event";
        }
        return "?";
    }

    @Override
    public String toSystem(ActionType code) {
        return code.getSystem();
    }
}

