/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AuditEntityType {
    _1,
    _2,
    _3,
    _4,
    NULL;


    public static AuditEntityType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("1".equals(codeString)) {
            return _1;
        }
        if ("2".equals(codeString)) {
            return _2;
        }
        if ("3".equals(codeString)) {
            return _3;
        }
        if ("4".equals(codeString)) {
            return _4;
        }
        throw new FHIRException("Unknown AuditEntityType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _1: {
                return "1";
            }
            case _2: {
                return "2";
            }
            case _3: {
                return "3";
            }
            case _4: {
                return "4";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/audit-entity-type";
    }

    public String getDefinition() {
        switch (this) {
            case _1: {
                return "Person";
            }
            case _2: {
                return "System Object";
            }
            case _3: {
                return "Organization";
            }
            case _4: {
                return "Other";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _1: {
                return "Person";
            }
            case _2: {
                return "System Object";
            }
            case _3: {
                return "Organization";
            }
            case _4: {
                return "Other";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

