/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ExtensionContext;

public class ExtensionContextEnumFactory
implements EnumFactory<ExtensionContext> {
    @Override
    public ExtensionContext fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("resource".equals(codeString)) {
            return ExtensionContext.RESOURCE;
        }
        if ("datatype".equals(codeString)) {
            return ExtensionContext.DATATYPE;
        }
        if ("extension".equals(codeString)) {
            return ExtensionContext.EXTENSION;
        }
        throw new IllegalArgumentException("Unknown ExtensionContext code '" + codeString + "'");
    }

    @Override
    public String toCode(ExtensionContext code) {
        if (code == ExtensionContext.NULL) {
            return null;
        }
        if (code == ExtensionContext.RESOURCE) {
            return "resource";
        }
        if (code == ExtensionContext.DATATYPE) {
            return "datatype";
        }
        if (code == ExtensionContext.EXTENSION) {
            return "extension";
        }
        return "?";
    }

    @Override
    public String toSystem(ExtensionContext code) {
        return code.getSystem();
    }
}

