/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.Intervention;

public class InterventionEnumFactory
implements EnumFactory<Intervention> {
    @Override
    public Intervention fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("unknown".equals(codeString)) {
            return Intervention.UNKNOWN;
        }
        if ("other".equals(codeString)) {
            return Intervention.OTHER;
        }
        throw new IllegalArgumentException("Unknown Intervention code '" + codeString + "'");
    }

    @Override
    public String toCode(Intervention code) {
        if (code == Intervention.NULL) {
            return null;
        }
        if (code == Intervention.UNKNOWN) {
            return "unknown";
        }
        if (code == Intervention.OTHER) {
            return "other";
        }
        return "?";
    }

    @Override
    public String toSystem(Intervention code) {
        return code.getSystem();
    }
}

