/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SequenceType {
    AA,
    DNA,
    RNA,
    NULL;


    public static SequenceType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("aa".equals(codeString)) {
            return AA;
        }
        if ("dna".equals(codeString)) {
            return DNA;
        }
        if ("rna".equals(codeString)) {
            return RNA;
        }
        throw new FHIRException("Unknown SequenceType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AA: {
                return "aa";
            }
            case DNA: {
                return "dna";
            }
            case RNA: {
                return "rna";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/sequence-type";
    }

    public String getDefinition() {
        switch (this) {
            case AA: {
                return "Amino acid sequence";
            }
            case DNA: {
                return "DNA Sequence";
            }
            case RNA: {
                return "RNA Sequence";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AA: {
                return "AA Sequence";
            }
            case DNA: {
                return "DNA Sequence";
            }
            case RNA: {
                return "RNA Sequence";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

