/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum TaskStage {
    PROPOSAL,
    PLANNED,
    ACTIONABLE,
    NULL;


    public static TaskStage fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposal".equals(codeString)) {
            return PROPOSAL;
        }
        if ("planned".equals(codeString)) {
            return PLANNED;
        }
        if ("actionable".equals(codeString)) {
            return ACTIONABLE;
        }
        throw new FHIRException("Unknown TaskStage code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROPOSAL: {
                return "proposal";
            }
            case PLANNED: {
                return "planned";
            }
            case ACTIONABLE: {
                return "actionable";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/task-stage";
    }

    public String getDefinition() {
        switch (this) {
            case PROPOSAL: {
                return "The request is a recommendation or suggestion where there has not yet been any commitment to action";
            }
            case PLANNED: {
                return "The request has a specific intention to be performed and may be scheduled but is not yet authorized to be performed";
            }
            case ACTIONABLE: {
                return "Indicates that the task is authorized and ready to be actioned";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROPOSAL: {
                return "proposal";
            }
            case PLANNED: {
                return "planned";
            }
            case ACTIONABLE: {
                return "actionable";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

